# coding: utf-8

"""
    Dofusdude

    # A project for you - the developer. The free, always-up-to-date, low-latency, insert-buzzword-here Ankama API for your next cool project!  ## Client SDKs Don't write types or functions yourself - I already (kinda) did! 😉 - [Javascript](https://github.com/dofusdude/dofusdude-js) npm i dofusdude-js --save - [Typescript](https://github.com/dofusdude/dofusdude-ts) npm i dofusdude-ts --save - [Go](https://github.com/dofusdude/dodugo) go get -u github.com/dofusdude/dodugo - [Python](https://github.com/dofusdude/dofusdude-py) pip install dofusdude - [PHP](https://github.com/dofusdude/dofusdude-php)  Everything, including this site, is generated out of the [Docs Repo](https://github.com/dofusdude/api-docs). Consider it the Single Source of Truth. If there is a problem with the SDKs, create an issue there.  Your favorite language is missing? Please let me know!  # Main Features - 🥷 **Seamless Auto-Update** load data in the background when a new Dofus version is released and serving it within 2 minutes with atomic data source switching. No downtime and no effects for the user, just always up-to-date.  - ⚡ **Blazingly Fast** all data in-memory, aggressive caching over short time spans, HTTP/2 multiplexing, written in Go, optimized for low latency, hosted on bare metal in 🇩🇪.  - 📨 **Discord Integration** Ankama related Twitter, RSS and Almanax feeds to post to Discord servers with advanced features like filters or mentions. Use the endpoints as a dev or the official [Web Client](https://discord.dofusdude.com) as a user.  - 🩸 **Dofus 2 Beta** from stable to bleeding edge by replacing /dofus2 with /dofus2beta.  - 🗣️ **Multilingual** supporting _en_, _fr_, _es_, _pt_ including the dropped languages from the Dofus website _de_ and _it_.  - 🧠 **Search by Relevance** allowing typos in name and description, handled by language specific text analysis and indexing by the powerful [Meilisearch](https://www.meilisearch.com) written in Rust.  - 🕵️ **Complete** actual data from the game including items invisible to the encyclopedia like quest items.  - 🖼️ **HD Images** rendering vector graphics into PNGs up to 800x800 px in the background.   ## Current state - Weapons ✅ - Equipment ✅ - Sets ✅ - Resources ✅ - Consumables ✅ - Pets ✅ - Mounts ✅ - Cosmetics/Ceremonial Items ✅ - Harnesses ✅ - Quest Items ✅ - Almanax ✅ - Monsters ❌ - Spells ❌  ... and much more on the Roadmap on my Discord.   ## Deploy now. Use forever. Everything you see here on this site, you can use now and forever. Updates could introduce new fields, new paths or parameter but never break backwards compatibility, so no field or parameter will be deleted.  There is one exception! **The API will _always_ choose being up-to-date over everything else**. So if Ankama decides to drop languages from the game like they did with their website, the API will loose support for them, too.  ## Only the beginning... 🤯 I want this project to be useful and not just add plain GET-categories no one needs.  There is a long list of features I want to add (see the Roadmap on my [Discord](https://discord.gg/3EtHskZD8h)). But they are all focussed on you, the developers. So please let me know what you need. I will change the list based on demand.  # Get started! 🥳 Scroll down and try it for yourself!  Or see how these other awesome projects use it: - [KaellyBot](https://github.com/Kaysoro/KaellyBot) by Kaysoro - [Dofus Craftlist](https://dofuscraftlist-dev.netlify.app) by Lystina - [AlmanaxApp](https://almanaxapp.netlify.app) by Lystina - [DofuStuffSimulator](https://dofusstuffsimulator.netlify.app/)  I highly recommend using the SDKs for quick results. I use them myself for parts of the API.  ## Thank you! I highly welcome everyone on my [Discord](https://discord.gg/3EtHskZD8h) to just talk about projects and use cases or give feedback of any kind.  The servers have a fixed monthly cost to provide very fast responses. If you want to help me keeping them running or simply  donate, consider becoming a [GitHub Sponsor](https://github.com/sponsors/dofusdude). 

    The version of the OpenAPI document: 0.8.0
    Contact: stelzo@steado.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, StrictInt, StrictStr, conlist
from dofusdude.models.condition_entry import ConditionEntry
from dofusdude.models.cosmetic_type import CosmeticType
from dofusdude.models.effects_entry import EffectsEntry
from dofusdude.models.image_urls import ImageUrls
from dofusdude.models.recipe_entry import RecipeEntry

class Cosmetic(BaseModel):
    """
    Cosmetic
    """
    ankama_id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    type: Optional[CosmeticType] = None
    level: Optional[StrictInt] = None
    pods: Optional[StrictInt] = None
    image_urls: Optional[ImageUrls] = None
    effects: Optional[conlist(EffectsEntry)] = None
    conditions: Optional[conlist(ConditionEntry)] = None
    recipe: Optional[conlist(RecipeEntry)] = None
    __properties = ["ankama_id", "name", "description", "type", "level", "pods", "image_urls", "effects", "conditions", "recipe"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Cosmetic:
        """Create an instance of Cosmetic from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of image_urls
        if self.image_urls:
            _dict['image_urls'] = self.image_urls.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in effects (list)
        _items = []
        if self.effects:
            for _item in self.effects:
                if _item:
                    _items.append(_item.to_dict())
            _dict['effects'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in conditions (list)
        _items = []
        if self.conditions:
            for _item in self.conditions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['conditions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in recipe (list)
        _items = []
        if self.recipe:
            for _item in self.recipe:
                if _item:
                    _items.append(_item.to_dict())
            _dict['recipe'] = _items
        # set to None if effects (nullable) is None
        # and __fields_set__ contains the field
        if self.effects is None and "effects" in self.__fields_set__:
            _dict['effects'] = None

        # set to None if conditions (nullable) is None
        # and __fields_set__ contains the field
        if self.conditions is None and "conditions" in self.__fields_set__:
            _dict['conditions'] = None

        # set to None if recipe (nullable) is None
        # and __fields_set__ contains the field
        if self.recipe is None and "recipe" in self.__fields_set__:
            _dict['recipe'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Cosmetic:
        """Create an instance of Cosmetic from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Cosmetic.parse_obj(obj)

        _obj = Cosmetic.parse_obj({
            "ankama_id": obj.get("ankama_id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "type": CosmeticType.from_dict(obj.get("type")) if obj.get("type") is not None else None,
            "level": obj.get("level"),
            "pods": obj.get("pods"),
            "image_urls": ImageUrls.from_dict(obj.get("image_urls")) if obj.get("image_urls") is not None else None,
            "effects": [EffectsEntry.from_dict(_item) for _item in obj.get("effects")] if obj.get("effects") is not None else None,
            "conditions": [ConditionEntry.from_dict(_item) for _item in obj.get("conditions")] if obj.get("conditions") is not None else None,
            "recipe": [RecipeEntry.from_dict(_item) for _item in obj.get("recipe")] if obj.get("recipe") is not None else None
        })
        return _obj


