# Generated by Django 2.0.7 on 2018-07-30 22:24

import coderedcms.blocks.base_blocks
from django.db import migrations, models
import django.db.models.deletion
import django.forms.widgets
import modelcluster.fields
import wagtail.contrib.table_block.blocks
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.documents.blocks
import wagtail.images.blocks
import wagtail.snippets.blocks


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailimages', '0020_add-verbose-name'),
        ('wagtailcore', '0040_page_draft_title'),
    ]

    operations = [
        migrations.CreateModel(
            name='ADASettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('skip_navigation', models.BooleanField(default=False, help_text='Shows a "Skip Navigation" link above the navbar that takes you directly to the main content.', verbose_name='Show skip navigation link')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
            ],
            options={
                'verbose_name': 'Accessibility',
            },
        ),
        migrations.CreateModel(
            name='AnalyticsSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ga_tracking_id', models.CharField(blank=True, help_text='Your Google Analytics tracking ID (begins with "UA-")', max_length=255, verbose_name='GA Tracking ID')),
                ('ga_track_button_clicks', models.BooleanField(default=False, help_text='Track all button clicks using Google Analytics event tracking. Event tracking details can be specified in each button’s advanced settings options.', verbose_name='Track button clicks')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
            ],
            options={
                'verbose_name': 'Tracking',
            },
        ),
        migrations.CreateModel(
            name='Carousel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('show_controls', models.BooleanField(default=True, help_text='Shows arrows on the left and right of the carousel to advance next or previous slides.', verbose_name='Show controls')),
                ('show_indicators', models.BooleanField(default=True, help_text='Shows small indicators at the bottom of the carousel based on the number of slides.', verbose_name='Show indicators')),
                ('animation', models.CharField(blank=True, choices=[('', 'Slide'), ('carousel-fade', 'Fade')], default='', help_text='The animation when transitioning between slides.', max_length=20, verbose_name='Animation')),
            ],
            options={
                'verbose_name': 'Carousel',
            },
        ),
        migrations.CreateModel(
            name='CarouselSlide',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('background_color', models.CharField(blank=True, help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', max_length=255, verbose_name='Background color')),
                ('custom_css_class', models.CharField(blank=True, max_length=255, verbose_name='Custom CSS class')),
                ('custom_id', models.CharField(blank=True, max_length=255, verbose_name='Custom ID')),
                ('content', wagtail.core.fields.StreamField([('text', wagtail.core.blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.core.blocks.URLBlock(help_text='Link to a YouTube or Vimeo video.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('api_key', wagtail.core.blocks.CharBlock(help_text='Optional. Only required to use place ID and zoom features.', label='API key', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('code', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('language', wagtail.core.blocks.ChoiceBlock(choices=[('abap', 'ABAP'), ('apl', 'APL'), ('abnf', 'ABNF'), ('as3', 'ActionScript 3'), ('as', 'ActionScript'), ('ada', 'Ada'), ('adl', 'ADL'), ('agda', 'Agda'), ('aheui', 'Aheui'), ('alloy', 'Alloy'), ('at', 'AmbientTalk'), ('ampl', 'Ampl'), ('html+ng2', 'HTML + Angular2'), ('ng2', 'Angular2'), ('antlr-as', 'ANTLR With ActionScript Target'), ('antlr-csharp', 'ANTLR With C# Target'), ('antlr-cpp', 'ANTLR With CPP Target'), ('antlr-java', 'ANTLR With Java Target'), ('antlr', 'ANTLR'), ('antlr-objc', 'ANTLR With ObjectiveC Target'), ('antlr-perl', 'ANTLR With Perl Target'), ('antlr-python', 'ANTLR With Python Target'), ('antlr-ruby', 'ANTLR With Ruby Target'), ('apacheconf', 'ApacheConf'), ('applescript', 'AppleScript'), ('arduino', 'Arduino'), ('aspectj', 'AspectJ'), ('asy', 'Asymptote'), ('autoit', 'AutoIt'), ('ahk', 'autohotkey'), ('awk', 'Awk'), ('bbcode', 'BBCode'), ('bc', 'BC'), ('bst', 'BST'), ('basemake', 'Base Makefile'), ('bash', 'Bash'), ('console', 'Bash Session'), ('bat', 'Batchfile'), ('befunge', 'Befunge'), ('bib', 'BibTeX'), ('blitzbasic', 'BlitzBasic'), ('blitzmax', 'BlitzMax'), ('bnf', 'BNF'), ('boo', 'Boo'), ('boogie', 'Boogie'), ('brainfuck', 'Brainfuck'), ('bro', 'Bro'), ('bugs', 'BUGS'), ('camkes', 'CAmkES'), ('c', 'C'), ('cmake', 'CMake'), ('c-objdump', 'c-objdump'), ('cpsa', 'CPSA'), ('aspx-cs', 'aspx-cs'), ('csharp', 'C#'), ('ca65', 'ca65 assembler'), ('cadl', 'cADL'), ('capdl', 'CapDL'), ('capnp', "Cap'n Proto"), ('cbmbas', 'CBM BASIC V2'), ('ceylon', 'Ceylon'), ('cfengine3', 'CFEngine3'), ('chai', 'ChaiScript'), ('chapel', 'Chapel'), ('html+cheetah', 'HTML+Cheetah'), ('js+cheetah', 'JavaScript+Cheetah'), ('cheetah', 'Cheetah'), ('xml+cheetah', 'XML+Cheetah'), ('cirru', 'Cirru'), ('clay', 'Clay'), ('clean', 'Clean'), ('clojure', 'Clojure'), ('clojurescript', 'ClojureScript'), ('cobolfree', 'COBOLFree'), ('cobol', 'COBOL'), ('coffee-script', 'CoffeeScript'), ('cfc', 'Coldfusion CFC'), ('cfm', 'Coldfusion HTML'), ('cfs', 'cfstatement'), ('common-lisp', 'Common Lisp'), ('componentpascal', 'Component Pascal'), ('coq', 'Coq'), ('cpp', 'C++'), ('cpp-objdump', 'cpp-objdump'), ('crmsh', 'Crmsh'), ('croc', 'Croc'), ('cryptol', 'Cryptol'), ('cr', 'Crystal'), ('csound-document', 'Csound Document'), ('csound', 'Csound Orchestra'), ('csound-score', 'Csound Score'), ('css+django', 'CSS+Django/Jinja'), ('css+erb', 'CSS+Ruby'), ('css+genshitext', 'CSS+Genshi Text'), ('css', 'CSS'), ('css+php', 'CSS+PHP'), ('css+smarty', 'CSS+Smarty'), ('cuda', 'CUDA'), ('cypher', 'Cypher'), ('cython', 'Cython'), ('d', 'D'), ('d-objdump', 'd-objdump'), ('dpatch', 'Darcs Patch'), ('dart', 'Dart'), ('control', 'Debian Control file'), ('delphi', 'Delphi'), ('dg', 'dg'), ('diff', 'Diff'), ('django', 'Django/Jinja'), ('docker', 'Docker'), ('dtd', 'DTD'), ('duel', 'Duel'), ('dylan-console', 'Dylan session'), ('dylan', 'Dylan'), ('dylan-lid', 'DylanLID'), ('ecl', 'ECL'), ('ec', 'eC'), ('earl-grey', 'Earl Grey'), ('easytrieve', 'Easytrieve'), ('ebnf', 'EBNF'), ('eiffel', 'Eiffel'), ('iex', 'Elixir iex session'), ('elixir', 'Elixir'), ('elm', 'Elm'), ('emacs', 'EmacsLisp'), ('erb', 'ERB'), ('erlang', 'Erlang'), ('erl', 'Erlang erl session'), ('html+evoque', 'HTML+Evoque'), ('evoque', 'Evoque'), ('xml+evoque', 'XML+Evoque'), ('ezhil', 'Ezhil'), ('fsharp', 'FSharp'), ('factor', 'Factor'), ('fancy', 'Fancy'), ('fan', 'Fantom'), ('felix', 'Felix'), ('fish', 'Fish'), ('flatline', 'Flatline'), ('forth', 'Forth'), ('fortranfixed', 'FortranFixed'), ('fortran', 'Fortran'), ('foxpro', 'FoxPro'), ('gap', 'GAP'), ('glsl', 'GLSL'), ('gas', 'GAS'), ('genshi', 'Genshi'), ('genshitext', 'Genshi Text'), ('pot', 'Gettext Catalog'), ('cucumber', 'Gherkin'), ('gnuplot', 'Gnuplot'), ('go', 'Go'), ('golo', 'Golo'), ('gooddata-cl', 'GoodData-CL'), ('gosu', 'Gosu'), ('gst', 'Gosu Template'), ('groff', 'Groff'), ('groovy', 'Groovy'), ('haml', 'Haml'), ('html+handlebars', 'HTML+Handlebars'), ('handlebars', 'Handlebars'), ('haskell', 'Haskell'), ('hx', 'Haxe'), ('hexdump', 'Hexdump'), ('hsail', 'HSAIL'), ('html+django', 'HTML+Django/Jinja'), ('html+genshi', 'HTML+Genshi'), ('html', 'HTML'), ('html+php', 'HTML+PHP'), ('html+smarty', 'HTML+Smarty'), ('http', 'HTTP'), ('haxeml', 'Hxml'), ('hylang', 'Hy'), ('hybris', 'Hybris'), ('idl', 'IDL'), ('idris', 'Idris'), ('igor', 'Igor'), ('inform6', 'Inform 6'), ('i6t', 'Inform 6 template'), ('inform7', 'Inform 7'), ('ini', 'INI'), ('io', 'Io'), ('ioke', 'Ioke'), ('irc', 'IRC logs'), ('isabelle', 'Isabelle'), ('j', 'J'), ('jags', 'JAGS'), ('jasmin', 'Jasmin'), ('java', 'Java'), ('js+django', 'JavaScript+Django/Jinja'), ('js+erb', 'JavaScript+Ruby'), ('js+genshitext', 'JavaScript+Genshi Text'), ('js', 'JavaScript'), ('js+php', 'JavaScript+PHP'), ('js+smarty', 'JavaScript+Smarty'), ('jcl', 'JCL'), ('jsgf', 'JSGF'), ('json-object', 'JSONBareObject'), ('jsonld', 'JSON-LD'), ('json', 'JSON'), ('jsp', 'Java Server Page'), ('jlcon', 'Julia console'), ('julia', 'Julia'), ('juttle', 'Juttle'), ('kal', 'Kal'), ('kconfig', 'Kconfig'), ('koka', 'Koka'), ('kotlin', 'Kotlin'), ('lsl', 'LSL'), ('css+lasso', 'CSS+Lasso'), ('html+lasso', 'HTML+Lasso'), ('js+lasso', 'JavaScript+Lasso'), ('lasso', 'Lasso'), ('xml+lasso', 'XML+Lasso'), ('lean', 'Lean'), ('less', 'LessCss'), ('lighty', 'Lighttpd configuration file'), ('limbo', 'Limbo'), ('liquid', 'liquid'), ('lagda', 'Literate Agda'), ('lcry', 'Literate Cryptol'), ('lhs', 'Literate Haskell'), ('lidr', 'Literate Idris'), ('live-script', 'LiveScript'), ('llvm', 'LLVM'), ('logos', 'Logos'), ('logtalk', 'Logtalk'), ('lua', 'Lua'), ('moocode', 'MOOCode'), ('doscon', 'MSDOS Session'), ('make', 'Makefile'), ('css+mako', 'CSS+Mako'), ('html+mako', 'HTML+Mako'), ('js+mako', 'JavaScript+Mako'), ('mako', 'Mako'), ('xml+mako', 'XML+Mako'), ('maql', 'MAQL'), ('md', 'markdown'), ('mask', 'Mask'), ('mason', 'Mason'), ('mathematica', 'Mathematica'), ('matlab', 'Matlab'), ('matlabsession', 'Matlab session'), ('minid', 'MiniD'), ('modelica', 'Modelica'), ('modula2', 'Modula-2'), ('trac-wiki', 'MoinMoin/Trac Wiki markup'), ('monkey', 'Monkey'), ('monte', 'Monte'), ('moon', 'MoonScript'), ('css+mozpreproc', 'CSS+mozpreproc'), ('mozhashpreproc', 'mozhashpreproc'), ('javascript+mozpreproc', 'Javascript+mozpreproc'), ('mozpercentpreproc', 'mozpercentpreproc'), ('xul+mozpreproc', 'XUL+mozpreproc'), ('mql', 'MQL'), ('mscgen', 'Mscgen'), ('mupad', 'MuPAD'), ('mxml', 'MXML'), ('mysql', 'MySQL'), ('css+myghty', 'CSS+Myghty'), ('html+myghty', 'HTML+Myghty'), ('js+myghty', 'JavaScript+Myghty'), ('myghty', 'Myghty'), ('xml+myghty', 'XML+Myghty'), ('ncl', 'NCL'), ('nsis', 'NSIS'), ('nasm', 'NASM'), ('objdump-nasm', 'objdump-nasm'), ('nemerle', 'Nemerle'), ('nesc', 'nesC'), ('newlisp', 'NewLisp'), ('newspeak', 'Newspeak'), ('nginx', 'Nginx configuration file'), ('nim', 'Nimrod'), ('nit', 'Nit'), ('nixos', 'Nix'), ('nusmv', 'NuSMV'), ('numpy', 'NumPy'), ('objdump', 'objdump'), ('objective-c', 'Objective-C'), ('objective-c++', 'Objective-C++'), ('objective-j', 'Objective-J'), ('ocaml', 'OCaml'), ('octave', 'Octave'), ('odin', 'ODIN'), ('ooc', 'Ooc'), ('opa', 'Opa'), ('openedge', 'OpenEdge ABL'), ('pacmanconf', 'PacmanConf'), ('pan', 'Pan'), ('parasail', 'ParaSail'), ('pawn', 'Pawn'), ('perl6', 'Perl6'), ('perl', 'Perl'), ('php', 'PHP'), ('pig', 'Pig'), ('pike', 'Pike'), ('pkgconfig', 'PkgConfig'), ('plpgsql', 'PL/pgSQL'), ('postscript', 'PostScript'), ('psql', 'PostgreSQL console (psql)'), ('postgresql', 'PostgreSQL SQL dialect'), ('pov', 'POVRay'), ('powershell', 'PowerShell'), ('ps1con', 'PowerShell Session'), ('praat', 'Praat'), ('prolog', 'Prolog'), ('properties', 'Properties'), ('protobuf', 'Protocol Buffer'), ('pug', 'Pug'), ('puppet', 'Puppet'), ('pypylog', 'PyPy Log'), ('python3', 'Python 3'), ('py3tb', 'Python 3.0 Traceback'), ('pycon', 'Python console session'), ('python', 'Python'), ('pytb', 'Python Traceback'), ('qbasic', 'QBasic'), ('qvto', 'QVTO'), ('qml', 'QML'), ('rconsole', 'RConsole'), ('rnc', 'Relax-NG Compact'), ('spec', 'RPMSpec'), ('racket', 'Racket'), ('ragel-c', 'Ragel in C Host'), ('ragel-cpp', 'Ragel in CPP Host'), ('ragel-d', 'Ragel in D Host'), ('ragel-em', 'Embedded Ragel'), ('ragel-java', 'Ragel in Java Host'), ('ragel', 'Ragel'), ('ragel-objc', 'Ragel in Objective C Host'), ('ragel-ruby', 'Ragel in Ruby Host'), ('raw', 'Raw token data'), ('rd', 'Rd'), ('rebol', 'REBOL'), ('red', 'Red'), ('redcode', 'Redcode'), ('registry', 'reg'), ('resource', 'ResourceBundle'), ('rexx', 'Rexx'), ('rhtml', 'RHTML'), ('roboconf-graph', 'Roboconf Graph'), ('roboconf-instances', 'Roboconf Instances'), ('robotframework', 'RobotFramework'), ('rql', 'RQL'), ('rsl', 'RSL'), ('rst', 'reStructuredText'), ('rts', 'TrafficScript'), ('rbcon', 'Ruby irb session'), ('rb', 'Ruby'), ('rust', 'Rust'), ('sas', 'SAS'), ('splus', 'S'), ('sml', 'Standard ML'), ('sass', 'Sass'), ('scala', 'Scala'), ('scaml', 'Scaml'), ('scheme', 'Scheme'), ('scilab', 'Scilab'), ('scss', 'SCSS'), ('shen', 'Shen'), ('silver', 'Silver'), ('slim', 'Slim'), ('smali', 'Smali'), ('smalltalk', 'Smalltalk'), ('smarty', 'Smarty'), ('snobol', 'Snobol'), ('snowball', 'Snowball'), ('sp', 'SourcePawn'), ('sourceslist', 'Debian Sourcelist'), ('sparql', 'SPARQL'), ('sql', 'SQL'), ('sqlite3', 'sqlite3con'), ('squidconf', 'SquidConf'), ('ssp', 'Scalate Server Page'), ('stan', 'Stan'), ('stata', 'Stata'), ('sc', 'SuperCollider'), ('swift', 'Swift'), ('swig', 'SWIG'), ('systemverilog', 'systemverilog'), ('tap', 'TAP'), ('tads3', 'TADS 3'), ('tasm', 'TASM'), ('tcl', 'Tcl'), ('tcsh', 'Tcsh'), ('tcshcon', 'Tcsh Session'), ('tea', 'Tea'), ('termcap', 'Termcap'), ('terminfo', 'Terminfo'), ('terraform', 'Terraform'), ('tex', 'TeX'), ('text', 'Text only'), ('thrift', 'Thrift'), ('todotxt', 'Todotxt'), ('tsql', 'Transact-SQL'), ('treetop', 'Treetop'), ('turtle', 'Turtle'), ('html+twig', 'HTML+Twig'), ('twig', 'Twig'), ('ts', 'TypeScript'), ('typoscriptcssdata', 'TypoScriptCssData'), ('typoscripthtmldata', 'TypoScriptHtmlData'), ('typoscript', 'TypoScript'), ('urbiscript', 'UrbiScript'), ('vcl', 'VCL'), ('vclsnippets', 'VCLSnippets'), ('vctreestatus', 'VCTreeStatus'), ('vgl', 'VGL'), ('vala', 'Vala'), ('aspx-vb', 'aspx-vb'), ('vb.net', 'VB.net'), ('html+velocity', 'HTML+Velocity'), ('velocity', 'Velocity'), ('xml+velocity', 'XML+Velocity'), ('verilog', 'verilog'), ('vhdl', 'vhdl'), ('vim', 'VimL'), ('wdiff', 'WDiff'), ('whiley', 'Whiley'), ('x10', 'X10'), ('xquery', 'XQuery'), ('xml+django', 'XML+Django/Jinja'), ('xml+erb', 'XML+Ruby'), ('xml', 'XML'), ('xml+php', 'XML+PHP'), ('xml+smarty', 'XML+Smarty'), ('xslt', 'XSLT'), ('xtend', 'Xtend'), ('extempore', 'xtlang'), ('yaml+jinja', 'YAML+Jinja'), ('yaml', 'YAML'), ('zephir', 'Zephir')], label='Syntax highlighting', required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('code', wagtail.core.blocks.TextBlock(classname='monospace', help_text='Code is rendered in a <pre> tag.', label='Code', rows=8))]))], blank=True)),
                ('carousel', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='carousel_slides', to='coderedcms.Carousel', verbose_name='Carousel')),
                ('image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Image')),
            ],
            options={
                'verbose_name': 'Carousel Slide',
            },
        ),
        migrations.CreateModel(
            name='CoderedPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('index_show_subpages', models.BooleanField(default=False, verbose_name='Show list of child pages')),
                ('index_order_by', models.CharField(choices=[('-first_published_at', 'Date first published, newest to oldest'), ('first_published_at', 'Date first published, oldest to newest'), ('-last_published_at', 'Date updated, newest to oldest'), ('last_published_at', 'Date updated, oldest to newest'), ('title', 'Title, alphabetical'), ('-title', 'Title, reverse alphabetical')], default='-first_published_at', max_length=255, verbose_name='Order child pages by')),
                ('index_num_per_page', models.PositiveIntegerField(default=10, verbose_name='Number per page')),
                ('custom_template', models.CharField(blank=True, max_length=255, verbose_name='Template')),
                ('struct_org_type', models.CharField(blank=True, choices=[('Organization', 'Organization'), ('Airline', 'Organization > Airline'), ('Corporation', 'Organization > Corporation'), ('EducationalOrganization', 'Organization > EducationalOrganization'), ('CollegeOrUniversity', 'Organization > EducationalOrganization > CollegeOrUniversity'), ('ElementarySchool', 'Organization > EducationalOrganization > ElementarySchool'), ('HighSchool', 'Organization > EducationalOrganization > HighSchool'), ('MiddleSchool', 'Organization > EducationalOrganization > MiddleSchool'), ('Preschool', 'Organization > EducationalOrganization > Preschool'), ('School', 'Organization > EducationalOrganization > School'), ('GovernmentOrganization', 'Organization > GovernmentOrganization'), ('LocalBusiness', 'Organization > LocalBusiness'), ('AnimalShelter', 'Organization > LocalBusiness > AnimalShelter'), ('AutomotiveBusiness', 'Organization > LocalBusiness > AutomotiveBusiness'), ('AutoBodyShop', 'Organization > LocalBusiness > AutomotiveBusiness > AutoBodyShop'), ('AutoDealer', 'Organization > LocalBusiness > AutomotiveBusiness > AutoDealer'), ('AutoPartsStore', 'Organization > LocalBusiness > AutomotiveBusiness > AutoPartsStore'), ('AutoRental', 'Organization > LocalBusiness > AutomotiveBusiness > AutoRental'), ('AutoRepair', 'Organization > LocalBusiness > AutomotiveBusiness > AutoRepair'), ('AutoWash', 'Organization > LocalBusiness > AutomotiveBusiness > AutoWash'), ('GasStation', 'Organization > LocalBusiness > AutomotiveBusiness > GasStation'), ('MotorcycleDealer', 'Organization > LocalBusiness > AutomotiveBusiness > MotorcycleDealer'), ('MotorcycleRepair', 'Organization > LocalBusiness > AutomotiveBusiness > MotorcycleRepair'), ('ChildCare', 'Organization > LocalBusiness > ChildCare'), ('Dentist', 'Organization > LocalBusiness > Dentist'), ('DryCleaningOrLaundry', 'Organization > LocalBusiness > DryCleaningOrLaundry'), ('EmergencyService', 'Organization > LocalBusiness > EmergencyService'), ('FireStation', 'Organization > LocalBusiness > EmergencyService > FireStation'), ('Hospital', 'Organization > LocalBusiness > EmergencyService > Hospital'), ('PoliceStation', 'Organization > LocalBusiness > EmergencyService > PoliceStation'), ('EmploymentAgency', 'Organization > LocalBusiness > EmploymentAgency'), ('EntertainmentBusiness', 'Organization > LocalBusiness > EntertainmentBusiness'), ('AdultEntertainment', 'Organization > LocalBusiness > EntertainmentBusiness > AdultEntertainment'), ('AmusementPark', 'Organization > LocalBusiness > EntertainmentBusiness > AmusementPark'), ('ArtGallery', 'Organization > LocalBusiness > EntertainmentBusiness > ArtGallery'), ('Casino', 'Organization > LocalBusiness > EntertainmentBusiness > Casino'), ('ComedyClub', 'Organization > LocalBusiness > EntertainmentBusiness > ComedyClub'), ('MovieTheater', 'Organization > LocalBusiness > EntertainmentBusiness > MovieTheater'), ('NightClub', 'Organization > LocalBusiness > EntertainmentBusiness > NightClub'), ('FinancialService', 'Organization > LocalBusiness > FinancialService'), ('AccountingService', 'Organization > LocalBusiness > FinancialService > AccountingService'), ('AutomatedTeller', 'Organization > LocalBusiness > FinancialService > AutomatedTeller'), ('BankOrCreditUnion', 'Organization > LocalBusiness > FinancialService > BankOrCreditUnion'), ('InsuranceAgency', 'Organization > LocalBusiness > FinancialService > InsuranceAgency'), ('FoodEstablishment', 'Organization > LocalBusiness > FoodEstablishment'), ('Bakery', 'Organization > LocalBusiness > FoodEstablishment > Bakery'), ('BarOrPub', 'Organization > LocalBusiness > FoodEstablishment > BarOrPub'), ('Brewery', 'Organization > LocalBusiness > FoodEstablishment > Brewery'), ('CafeOrCoffeeShop', 'Organization > LocalBusiness > FoodEstablishment > CafeOrCoffeeShop'), ('FastFoodRestaurant', 'Organization > LocalBusiness > FoodEstablishment > FastFoodRestaurant'), ('IceCreamShop', 'Organization > LocalBusiness > FoodEstablishment > IceCreamShop'), ('Restaurant', 'Organization > LocalBusiness > FoodEstablishment > Restaurant'), ('Winery', 'Organization > LocalBusiness > FoodEstablishment > Winery'), ('GovernmentOffice', 'Organization > LocalBusiness > GovernmentOffice'), ('PostOffice', 'Organization > LocalBusiness > GovernmentOffice > PostOffice'), ('HealthAndBeautyBusiness', 'Organization > LocalBusiness > HealthAndBeautyBusiness'), ('BeautySalon', 'Organization > LocalBusiness > HealthAndBeautyBusiness > BeautySalon'), ('DaySpa', 'Organization > LocalBusiness > HealthAndBeautyBusiness > DaySpa'), ('HairSalon', 'Organization > LocalBusiness > HealthAndBeautyBusiness > HairSalon'), ('HealthClub', 'Organization > LocalBusiness > HealthAndBeautyBusiness > HealthClub'), ('NailSalon', 'Organization > LocalBusiness > HealthAndBeautyBusiness > NailSalon'), ('TattooParlor', 'Organization > LocalBusiness > HealthAndBeautyBusiness > TattooParlor'), ('HomeAndConstructionBusiness', 'Organization > LocalBusiness > HomeAndConstructionBusiness'), ('Electrician', 'Organization > LocalBusiness > HomeAndConstructionBusiness > Electrician'), ('GeneralContractor', 'Organization > LocalBusiness > HomeAndConstructionBusiness > GeneralContractor'), ('HVACBusiness', 'Organization > LocalBusiness > HomeAndConstructionBusiness > HVACBusiness'), ('HousePainter', 'Organization > LocalBusiness > HomeAndConstructionBusiness > HousePainter'), ('Locksmith', 'Organization > LocalBusiness > HomeAndConstructionBusiness > Locksmith'), ('MovingCompany', 'Organization > LocalBusiness > HomeAndConstructionBusiness > MovingCompany'), ('Plumber', 'Organization > LocalBusiness > HomeAndConstructionBusiness > Plumber'), ('RoofingContractor', 'Organization > LocalBusiness > HomeAndConstructionBusiness > RoofingContractor'), ('InternetCafe', 'Organization > LocalBusiness > InternetCafe'), ('LegalService', 'Organization > LocalBusiness > LegalService'), ('Attorney', 'Organization > LocalBusiness > LegalService > Attorney'), ('Notary', 'Organization > LocalBusiness > LegalService > Notary'), ('Library', 'Organization > LocalBusiness > Library'), ('LodgingBusiness', 'Organization > LocalBusiness > LodgingBusiness'), ('BedAndBreakfast', 'Organization > LocalBusiness > LodgingBusiness > BedAndBreakfast'), ('Campground', 'Organization > LocalBusiness > LodgingBusiness > Campground'), ('Hostel', 'Organization > LocalBusiness > LodgingBusiness > Hostel'), ('Hotel', 'Organization > LocalBusiness > LodgingBusiness > Hotel'), ('Motel', 'Organization > LocalBusiness > LodgingBusiness > Motel'), ('Resort', 'Organization > LocalBusiness > LodgingBusiness > Resort'), ('ProfessionalService', 'Organization > LocalBusiness > ProfessionalService'), ('RadioStation', 'Organization > LocalBusiness > RadioStation'), ('RealEstateAgent', 'Organization > LocalBusiness > RealEstateAgent'), ('RecyclingCenter', 'Organization > LocalBusiness > RecyclingCenter'), ('SelfStorage', 'Organization > LocalBusiness > SelfStorage'), ('ShoppingCenter', 'Organization > LocalBusiness > ShoppingCenter'), ('SportsActivityLocation', 'Organization > LocalBusiness > SportsActivityLocation'), ('BowlingAlley', 'Organization > LocalBusiness > SportsActivityLocation > BowlingAlley'), ('ExerciseGym', 'Organization > LocalBusiness > SportsActivityLocation > ExerciseGym'), ('GolfCourse', 'Organization > LocalBusiness > SportsActivityLocation > GolfCourse'), ('HealthClub', 'Organization > LocalBusiness > SportsActivityLocation > HealthClub'), ('PublicSwimmingPool', 'Organization > LocalBusiness > SportsActivityLocation > PublicSwimmingPool'), ('SkiResort', 'Organization > LocalBusiness > SportsActivityLocation > SkiResort'), ('SportsClub', 'Organization > LocalBusiness > SportsActivityLocation > SportsClub'), ('StadiumOrArena', 'Organization > LocalBusiness > SportsActivityLocation > StadiumOrArena'), ('TennisComplex', 'Organization > LocalBusiness > SportsActivityLocation > TennisComplex'), ('Store', 'Organization > LocalBusiness > Store'), ('AutoPartsStore', 'Organization > LocalBusiness > Store > AutoPartsStore'), ('BikeStore', 'Organization > LocalBusiness > Store > BikeStore'), ('BookStore', 'Organization > LocalBusiness > Store > BookStore'), ('ClothingStore', 'Organization > LocalBusiness > Store > ClothingStore'), ('ComputerStore', 'Organization > LocalBusiness > Store > ComputerStore'), ('ConvenienceStore', 'Organization > LocalBusiness > Store > ConvenienceStore'), ('DepartmentStore', 'Organization > LocalBusiness > Store > DepartmentStore'), ('ElectronicsStore', 'Organization > LocalBusiness > Store > ElectronicsStore'), ('Florist', 'Organization > LocalBusiness > Store > Florist'), ('FurnitureStore', 'Organization > LocalBusiness > Store > FurnitureStore'), ('GardenStore', 'Organization > LocalBusiness > Store > GardenStore'), ('GroceryStore', 'Organization > LocalBusiness > Store > GroceryStore'), ('HardwareStore', 'Organization > LocalBusiness > Store > HardwareStore'), ('HobbyShop', 'Organization > LocalBusiness > Store > HobbyShop'), ('HomeGoodsStore', 'Organization > LocalBusiness > Store > HomeGoodsStore'), ('JewelryStore', 'Organization > LocalBusiness > Store > JewelryStore'), ('LiquorStore', 'Organization > LocalBusiness > Store > LiquorStore'), ('MensClothingStore', 'Organization > LocalBusiness > Store > MensClothingStore'), ('MobilePhoneStore', 'Organization > LocalBusiness > Store > MobilePhoneStore'), ('MovieRentalStore', 'Organization > LocalBusiness > Store > MovieRentalStore'), ('MusicStore', 'Organization > LocalBusiness > Store > MusicStore'), ('OfficeEquipmentStore', 'Organization > LocalBusiness > Store > OfficeEquipmentStore'), ('OutletStore', 'Organization > LocalBusiness > Store > OutletStore'), ('PawnShop', 'Organization > LocalBusiness > Store > PawnShop'), ('PetStore', 'Organization > LocalBusiness > Store > PetStore'), ('ShoeStore', 'Organization > LocalBusiness > Store > ShoeStore'), ('SportingGoodsStore', 'Organization > LocalBusiness > Store > SportingGoodsStore'), ('TireShop', 'Organization > LocalBusiness > Store > TireShop'), ('ToyStore', 'Organization > LocalBusiness > Store > ToyStore'), ('WholesaleStore', 'Organization > LocalBusiness > Store > WholesaleStore'), ('TelevisionStation', 'Organization > LocalBusiness > TelevisionStation'), ('TouristInformationCenter', 'Organization > LocalBusiness > TouristInformationCenter'), ('TravelAgency', 'Organization > LocalBusiness > TravelAgency'), ('MedicalOrganization', 'Organization > MedicalOrganization'), ('Dentist', 'Organization > MedicalOrganization > Dentist'), ('Hospital', 'Organization > MedicalOrganization > Hospital'), ('Pharmacy', 'Organization > MedicalOrganization > Pharmacy'), ('Physician', 'Organization > MedicalOrganization > Physician'), ('NGO', 'Organization > NGO'), ('PerformingGroup', 'Organization > PerformingGroup'), ('DanceGroup', 'Organization > PerformingGroup > DanceGroup'), ('MusicGroup', 'Organization > PerformingGroup > MusicGroup'), ('TheaterGroup', 'Organization > PerformingGroup > TheaterGroup'), ('SportsOrganization', 'Organization > SportsOrganization'), ('SportsTeam', 'Organization > SportsOrganization > SportsTeam')], default='', help_text='If blank, no structured data will be used on this page.', max_length=255, verbose_name='Organization type')),
                ('struct_org_name', models.CharField(blank=True, default='', help_text='Leave blank to use the site name in Settings > Sites', max_length=255, verbose_name='Organization name')),
                ('struct_org_phone', models.CharField(blank=True, help_text='Include country code for best results. For example: +1-216-555-8000', max_length=255, verbose_name='Telephone number')),
                ('struct_org_address_street', models.CharField(blank=True, help_text='House number and street. For example, 55 Public Square Suite 1710', max_length=255, verbose_name='Street address')),
                ('struct_org_address_locality', models.CharField(blank=True, help_text='City or locality. For example, Cleveland', max_length=255, verbose_name='City')),
                ('struct_org_address_region', models.CharField(blank=True, help_text='State, province, county, or region. For example, OH', max_length=255, verbose_name='State')),
                ('struct_org_address_postal', models.CharField(blank=True, help_text='Zip or postal code. For example, 44113', max_length=255, verbose_name='Postal code')),
                ('struct_org_address_country', models.CharField(blank=True, help_text='For example, USA. Two-letter ISO 3166-1 alpha-2 country code is also acceptible https://en.wikipedia.org/wiki/ISO_3166-1', max_length=255, verbose_name='Country')),
                ('struct_org_geo_lat', models.DecimalField(blank=True, decimal_places=8, max_digits=10, null=True, verbose_name='Geographic latitude')),
                ('struct_org_geo_lng', models.DecimalField(blank=True, decimal_places=8, max_digits=10, null=True, verbose_name='Geographic longitude')),
                ('struct_org_hours', wagtail.core.fields.StreamField([('hours', wagtail.core.blocks.StructBlock([('days', coderedcms.blocks.base_blocks.MultiSelectBlock(choices=(('Monday', 'Monday'), ('Tuesday', 'Tuesday'), ('Wednesday', 'Wednesday'), ('Thursday', 'Thursday'), ('Friday', 'Friday'), ('Saturday', 'Saturday'), ('Sunday', 'Sunday')), help_text='For late night hours past 23:59, define each day in a separate block.', required=True, verbose_name='Days', widget=django.forms.widgets.CheckboxSelectMultiple)), ('start_time', wagtail.core.blocks.TimeBlock(verbose_name='Opening time')), ('end_time', wagtail.core.blocks.TimeBlock(verbose_name='Closing time'))]))], blank=True, verbose_name='Hours of operation')),
                ('struct_org_actions', wagtail.core.fields.StreamField([('actions', wagtail.core.blocks.StructBlock([('action_type', wagtail.core.blocks.ChoiceBlock(choices=[('OrderAction', 'OrderAction'), ('ReserveAction', 'ReserveAction')], verbose_name='Action Type')), ('target', wagtail.core.blocks.URLBlock(verbose_name='Target URL')), ('language', wagtail.core.blocks.CharBlock(default='en-US', help_text='If the action is offered in multiple languages, create separate actions for each language.', verbose_name='Language')), ('result_type', wagtail.core.blocks.ChoiceBlock(choices=[('Reservation', 'Reservation'), ('BusReservation', 'BusReservation'), ('EventReservation', 'EventReservation'), ('FlightReservation', 'FlightReservation'), ('FoodEstablishmentReservation', 'FoodEstablishmentReservation'), ('LodgingReservation', 'LodgingReservation'), ('RentalCarReservation', 'RentalCarReservation'), ('ReservationPackage', 'ReservationPackage'), ('TaxiReservation', 'TaxiReservation'), ('TrainReservation', 'TrainReservation')], help_text='Leave blank for OrderAction', required=False, verbose_name='Result Type')), ('result_name', wagtail.core.blocks.CharBlock(help_text='Example: "Reserve a table", "Book an appointment", etc.', required=False, verbose_name='Result Name')), ('extra_json', wagtail.core.blocks.RawHTMLBlock(classname='monospace', help_text='Additional JSON-LD inserted into the Action dictionary. Must be properties of https://schema.org/Action.', required=False, verbose_name='Additional action markup'))]))], blank=True, verbose_name='Actions')),
                ('struct_org_extra_json', models.TextField(blank=True, help_text='Additional JSON-LD inserted into the Organization dictionary. Must be properties of https://schema.org/Organization or the selected organization type.', verbose_name='Additional Organization markup')),
                ('cover_image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Cover image')),
                ('og_image', models.ForeignKey(blank=True, help_text='The image shown when linking to this page on social media. If blank, defaults to article cover image, or logo in Settings > Layout > Logo', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Open Graph preview image')),
                ('struct_org_image', models.ForeignKey(blank=True, help_text='A photo of the facility. This photo will be cropped to 1:1, 4:3, and 16:9 aspect ratios automatically.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Photo of Organization')),
                ('struct_org_logo', models.ForeignKey(blank=True, help_text='Leave blank to use the logo in Settings > Layout > Logo', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Organization logo')),
            ],
            options={
                'verbose_name': 'CodeRed Page',
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='Footer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('custom_css_class', models.CharField(blank=True, max_length=255, verbose_name='Custom CSS Class')),
                ('custom_id', models.CharField(blank=True, max_length=255, verbose_name='Custom ID')),
                ('content', wagtail.core.fields.StreamField([('row', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.core.blocks.URLBlock(help_text='Link to a YouTube or Vimeo video.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('api_key', wagtail.core.blocks.CharBlock(help_text='Optional. Only required to use place ID and zoom features.', label='API key', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('code', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('language', wagtail.core.blocks.ChoiceBlock(choices=[('abap', 'ABAP'), ('apl', 'APL'), ('abnf', 'ABNF'), ('as3', 'ActionScript 3'), ('as', 'ActionScript'), ('ada', 'Ada'), ('adl', 'ADL'), ('agda', 'Agda'), ('aheui', 'Aheui'), ('alloy', 'Alloy'), ('at', 'AmbientTalk'), ('ampl', 'Ampl'), ('html+ng2', 'HTML + Angular2'), ('ng2', 'Angular2'), ('antlr-as', 'ANTLR With ActionScript Target'), ('antlr-csharp', 'ANTLR With C# Target'), ('antlr-cpp', 'ANTLR With CPP Target'), ('antlr-java', 'ANTLR With Java Target'), ('antlr', 'ANTLR'), ('antlr-objc', 'ANTLR With ObjectiveC Target'), ('antlr-perl', 'ANTLR With Perl Target'), ('antlr-python', 'ANTLR With Python Target'), ('antlr-ruby', 'ANTLR With Ruby Target'), ('apacheconf', 'ApacheConf'), ('applescript', 'AppleScript'), ('arduino', 'Arduino'), ('aspectj', 'AspectJ'), ('asy', 'Asymptote'), ('autoit', 'AutoIt'), ('ahk', 'autohotkey'), ('awk', 'Awk'), ('bbcode', 'BBCode'), ('bc', 'BC'), ('bst', 'BST'), ('basemake', 'Base Makefile'), ('bash', 'Bash'), ('console', 'Bash Session'), ('bat', 'Batchfile'), ('befunge', 'Befunge'), ('bib', 'BibTeX'), ('blitzbasic', 'BlitzBasic'), ('blitzmax', 'BlitzMax'), ('bnf', 'BNF'), ('boo', 'Boo'), ('boogie', 'Boogie'), ('brainfuck', 'Brainfuck'), ('bro', 'Bro'), ('bugs', 'BUGS'), ('camkes', 'CAmkES'), ('c', 'C'), ('cmake', 'CMake'), ('c-objdump', 'c-objdump'), ('cpsa', 'CPSA'), ('aspx-cs', 'aspx-cs'), ('csharp', 'C#'), ('ca65', 'ca65 assembler'), ('cadl', 'cADL'), ('capdl', 'CapDL'), ('capnp', "Cap'n Proto"), ('cbmbas', 'CBM BASIC V2'), ('ceylon', 'Ceylon'), ('cfengine3', 'CFEngine3'), ('chai', 'ChaiScript'), ('chapel', 'Chapel'), ('html+cheetah', 'HTML+Cheetah'), ('js+cheetah', 'JavaScript+Cheetah'), ('cheetah', 'Cheetah'), ('xml+cheetah', 'XML+Cheetah'), ('cirru', 'Cirru'), ('clay', 'Clay'), ('clean', 'Clean'), ('clojure', 'Clojure'), ('clojurescript', 'ClojureScript'), ('cobolfree', 'COBOLFree'), ('cobol', 'COBOL'), ('coffee-script', 'CoffeeScript'), ('cfc', 'Coldfusion CFC'), ('cfm', 'Coldfusion HTML'), ('cfs', 'cfstatement'), ('common-lisp', 'Common Lisp'), ('componentpascal', 'Component Pascal'), ('coq', 'Coq'), ('cpp', 'C++'), ('cpp-objdump', 'cpp-objdump'), ('crmsh', 'Crmsh'), ('croc', 'Croc'), ('cryptol', 'Cryptol'), ('cr', 'Crystal'), ('csound-document', 'Csound Document'), ('csound', 'Csound Orchestra'), ('csound-score', 'Csound Score'), ('css+django', 'CSS+Django/Jinja'), ('css+erb', 'CSS+Ruby'), ('css+genshitext', 'CSS+Genshi Text'), ('css', 'CSS'), ('css+php', 'CSS+PHP'), ('css+smarty', 'CSS+Smarty'), ('cuda', 'CUDA'), ('cypher', 'Cypher'), ('cython', 'Cython'), ('d', 'D'), ('d-objdump', 'd-objdump'), ('dpatch', 'Darcs Patch'), ('dart', 'Dart'), ('control', 'Debian Control file'), ('delphi', 'Delphi'), ('dg', 'dg'), ('diff', 'Diff'), ('django', 'Django/Jinja'), ('docker', 'Docker'), ('dtd', 'DTD'), ('duel', 'Duel'), ('dylan-console', 'Dylan session'), ('dylan', 'Dylan'), ('dylan-lid', 'DylanLID'), ('ecl', 'ECL'), ('ec', 'eC'), ('earl-grey', 'Earl Grey'), ('easytrieve', 'Easytrieve'), ('ebnf', 'EBNF'), ('eiffel', 'Eiffel'), ('iex', 'Elixir iex session'), ('elixir', 'Elixir'), ('elm', 'Elm'), ('emacs', 'EmacsLisp'), ('erb', 'ERB'), ('erlang', 'Erlang'), ('erl', 'Erlang erl session'), ('html+evoque', 'HTML+Evoque'), ('evoque', 'Evoque'), ('xml+evoque', 'XML+Evoque'), ('ezhil', 'Ezhil'), ('fsharp', 'FSharp'), ('factor', 'Factor'), ('fancy', 'Fancy'), ('fan', 'Fantom'), ('felix', 'Felix'), ('fish', 'Fish'), ('flatline', 'Flatline'), ('forth', 'Forth'), ('fortranfixed', 'FortranFixed'), ('fortran', 'Fortran'), ('foxpro', 'FoxPro'), ('gap', 'GAP'), ('glsl', 'GLSL'), ('gas', 'GAS'), ('genshi', 'Genshi'), ('genshitext', 'Genshi Text'), ('pot', 'Gettext Catalog'), ('cucumber', 'Gherkin'), ('gnuplot', 'Gnuplot'), ('go', 'Go'), ('golo', 'Golo'), ('gooddata-cl', 'GoodData-CL'), ('gosu', 'Gosu'), ('gst', 'Gosu Template'), ('groff', 'Groff'), ('groovy', 'Groovy'), ('haml', 'Haml'), ('html+handlebars', 'HTML+Handlebars'), ('handlebars', 'Handlebars'), ('haskell', 'Haskell'), ('hx', 'Haxe'), ('hexdump', 'Hexdump'), ('hsail', 'HSAIL'), ('html+django', 'HTML+Django/Jinja'), ('html+genshi', 'HTML+Genshi'), ('html', 'HTML'), ('html+php', 'HTML+PHP'), ('html+smarty', 'HTML+Smarty'), ('http', 'HTTP'), ('haxeml', 'Hxml'), ('hylang', 'Hy'), ('hybris', 'Hybris'), ('idl', 'IDL'), ('idris', 'Idris'), ('igor', 'Igor'), ('inform6', 'Inform 6'), ('i6t', 'Inform 6 template'), ('inform7', 'Inform 7'), ('ini', 'INI'), ('io', 'Io'), ('ioke', 'Ioke'), ('irc', 'IRC logs'), ('isabelle', 'Isabelle'), ('j', 'J'), ('jags', 'JAGS'), ('jasmin', 'Jasmin'), ('java', 'Java'), ('js+django', 'JavaScript+Django/Jinja'), ('js+erb', 'JavaScript+Ruby'), ('js+genshitext', 'JavaScript+Genshi Text'), ('js', 'JavaScript'), ('js+php', 'JavaScript+PHP'), ('js+smarty', 'JavaScript+Smarty'), ('jcl', 'JCL'), ('jsgf', 'JSGF'), ('json-object', 'JSONBareObject'), ('jsonld', 'JSON-LD'), ('json', 'JSON'), ('jsp', 'Java Server Page'), ('jlcon', 'Julia console'), ('julia', 'Julia'), ('juttle', 'Juttle'), ('kal', 'Kal'), ('kconfig', 'Kconfig'), ('koka', 'Koka'), ('kotlin', 'Kotlin'), ('lsl', 'LSL'), ('css+lasso', 'CSS+Lasso'), ('html+lasso', 'HTML+Lasso'), ('js+lasso', 'JavaScript+Lasso'), ('lasso', 'Lasso'), ('xml+lasso', 'XML+Lasso'), ('lean', 'Lean'), ('less', 'LessCss'), ('lighty', 'Lighttpd configuration file'), ('limbo', 'Limbo'), ('liquid', 'liquid'), ('lagda', 'Literate Agda'), ('lcry', 'Literate Cryptol'), ('lhs', 'Literate Haskell'), ('lidr', 'Literate Idris'), ('live-script', 'LiveScript'), ('llvm', 'LLVM'), ('logos', 'Logos'), ('logtalk', 'Logtalk'), ('lua', 'Lua'), ('moocode', 'MOOCode'), ('doscon', 'MSDOS Session'), ('make', 'Makefile'), ('css+mako', 'CSS+Mako'), ('html+mako', 'HTML+Mako'), ('js+mako', 'JavaScript+Mako'), ('mako', 'Mako'), ('xml+mako', 'XML+Mako'), ('maql', 'MAQL'), ('md', 'markdown'), ('mask', 'Mask'), ('mason', 'Mason'), ('mathematica', 'Mathematica'), ('matlab', 'Matlab'), ('matlabsession', 'Matlab session'), ('minid', 'MiniD'), ('modelica', 'Modelica'), ('modula2', 'Modula-2'), ('trac-wiki', 'MoinMoin/Trac Wiki markup'), ('monkey', 'Monkey'), ('monte', 'Monte'), ('moon', 'MoonScript'), ('css+mozpreproc', 'CSS+mozpreproc'), ('mozhashpreproc', 'mozhashpreproc'), ('javascript+mozpreproc', 'Javascript+mozpreproc'), ('mozpercentpreproc', 'mozpercentpreproc'), ('xul+mozpreproc', 'XUL+mozpreproc'), ('mql', 'MQL'), ('mscgen', 'Mscgen'), ('mupad', 'MuPAD'), ('mxml', 'MXML'), ('mysql', 'MySQL'), ('css+myghty', 'CSS+Myghty'), ('html+myghty', 'HTML+Myghty'), ('js+myghty', 'JavaScript+Myghty'), ('myghty', 'Myghty'), ('xml+myghty', 'XML+Myghty'), ('ncl', 'NCL'), ('nsis', 'NSIS'), ('nasm', 'NASM'), ('objdump-nasm', 'objdump-nasm'), ('nemerle', 'Nemerle'), ('nesc', 'nesC'), ('newlisp', 'NewLisp'), ('newspeak', 'Newspeak'), ('nginx', 'Nginx configuration file'), ('nim', 'Nimrod'), ('nit', 'Nit'), ('nixos', 'Nix'), ('nusmv', 'NuSMV'), ('numpy', 'NumPy'), ('objdump', 'objdump'), ('objective-c', 'Objective-C'), ('objective-c++', 'Objective-C++'), ('objective-j', 'Objective-J'), ('ocaml', 'OCaml'), ('octave', 'Octave'), ('odin', 'ODIN'), ('ooc', 'Ooc'), ('opa', 'Opa'), ('openedge', 'OpenEdge ABL'), ('pacmanconf', 'PacmanConf'), ('pan', 'Pan'), ('parasail', 'ParaSail'), ('pawn', 'Pawn'), ('perl6', 'Perl6'), ('perl', 'Perl'), ('php', 'PHP'), ('pig', 'Pig'), ('pike', 'Pike'), ('pkgconfig', 'PkgConfig'), ('plpgsql', 'PL/pgSQL'), ('postscript', 'PostScript'), ('psql', 'PostgreSQL console (psql)'), ('postgresql', 'PostgreSQL SQL dialect'), ('pov', 'POVRay'), ('powershell', 'PowerShell'), ('ps1con', 'PowerShell Session'), ('praat', 'Praat'), ('prolog', 'Prolog'), ('properties', 'Properties'), ('protobuf', 'Protocol Buffer'), ('pug', 'Pug'), ('puppet', 'Puppet'), ('pypylog', 'PyPy Log'), ('python3', 'Python 3'), ('py3tb', 'Python 3.0 Traceback'), ('pycon', 'Python console session'), ('python', 'Python'), ('pytb', 'Python Traceback'), ('qbasic', 'QBasic'), ('qvto', 'QVTO'), ('qml', 'QML'), ('rconsole', 'RConsole'), ('rnc', 'Relax-NG Compact'), ('spec', 'RPMSpec'), ('racket', 'Racket'), ('ragel-c', 'Ragel in C Host'), ('ragel-cpp', 'Ragel in CPP Host'), ('ragel-d', 'Ragel in D Host'), ('ragel-em', 'Embedded Ragel'), ('ragel-java', 'Ragel in Java Host'), ('ragel', 'Ragel'), ('ragel-objc', 'Ragel in Objective C Host'), ('ragel-ruby', 'Ragel in Ruby Host'), ('raw', 'Raw token data'), ('rd', 'Rd'), ('rebol', 'REBOL'), ('red', 'Red'), ('redcode', 'Redcode'), ('registry', 'reg'), ('resource', 'ResourceBundle'), ('rexx', 'Rexx'), ('rhtml', 'RHTML'), ('roboconf-graph', 'Roboconf Graph'), ('roboconf-instances', 'Roboconf Instances'), ('robotframework', 'RobotFramework'), ('rql', 'RQL'), ('rsl', 'RSL'), ('rst', 'reStructuredText'), ('rts', 'TrafficScript'), ('rbcon', 'Ruby irb session'), ('rb', 'Ruby'), ('rust', 'Rust'), ('sas', 'SAS'), ('splus', 'S'), ('sml', 'Standard ML'), ('sass', 'Sass'), ('scala', 'Scala'), ('scaml', 'Scaml'), ('scheme', 'Scheme'), ('scilab', 'Scilab'), ('scss', 'SCSS'), ('shen', 'Shen'), ('silver', 'Silver'), ('slim', 'Slim'), ('smali', 'Smali'), ('smalltalk', 'Smalltalk'), ('smarty', 'Smarty'), ('snobol', 'Snobol'), ('snowball', 'Snowball'), ('sp', 'SourcePawn'), ('sourceslist', 'Debian Sourcelist'), ('sparql', 'SPARQL'), ('sql', 'SQL'), ('sqlite3', 'sqlite3con'), ('squidconf', 'SquidConf'), ('ssp', 'Scalate Server Page'), ('stan', 'Stan'), ('stata', 'Stata'), ('sc', 'SuperCollider'), ('swift', 'Swift'), ('swig', 'SWIG'), ('systemverilog', 'systemverilog'), ('tap', 'TAP'), ('tads3', 'TADS 3'), ('tasm', 'TASM'), ('tcl', 'Tcl'), ('tcsh', 'Tcsh'), ('tcshcon', 'Tcsh Session'), ('tea', 'Tea'), ('termcap', 'Termcap'), ('terminfo', 'Terminfo'), ('terraform', 'Terraform'), ('tex', 'TeX'), ('text', 'Text only'), ('thrift', 'Thrift'), ('todotxt', 'Todotxt'), ('tsql', 'Transact-SQL'), ('treetop', 'Treetop'), ('turtle', 'Turtle'), ('html+twig', 'HTML+Twig'), ('twig', 'Twig'), ('ts', 'TypeScript'), ('typoscriptcssdata', 'TypoScriptCssData'), ('typoscripthtmldata', 'TypoScriptHtmlData'), ('typoscript', 'TypoScript'), ('urbiscript', 'UrbiScript'), ('vcl', 'VCL'), ('vclsnippets', 'VCLSnippets'), ('vctreestatus', 'VCTreeStatus'), ('vgl', 'VGL'), ('vala', 'Vala'), ('aspx-vb', 'aspx-vb'), ('vb.net', 'VB.net'), ('html+velocity', 'HTML+Velocity'), ('velocity', 'Velocity'), ('xml+velocity', 'XML+Velocity'), ('verilog', 'verilog'), ('vhdl', 'vhdl'), ('vim', 'VimL'), ('wdiff', 'WDiff'), ('whiley', 'Whiley'), ('x10', 'X10'), ('xquery', 'XQuery'), ('xml+django', 'XML+Django/Jinja'), ('xml+erb', 'XML+Ruby'), ('xml', 'XML'), ('xml+php', 'XML+PHP'), ('xml+smarty', 'XML+Smarty'), ('xslt', 'XSLT'), ('xtend', 'Xtend'), ('extempore', 'xtlang'), ('yaml+jinja', 'YAML+Jinja'), ('yaml', 'YAML'), ('zephir', 'Zephir')], label='Syntax highlighting', required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('code', wagtail.core.blocks.TextBlock(classname='monospace', help_text='Code is rendered in a <pre> tag.', label='Code', rows=8))])), ('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.Carousel'))])), ('image_gallery', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', coderedcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection'))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show')), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Only show pages that are children of the selected page. Uses the subpage sorting as specified in the page’s LAYOUT tab.', label='Limit to', required=False))])), ('modal', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('header', wagtail.core.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.core.blocks.URLBlock(help_text='Link to a YouTube or Vimeo video.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('api_key', wagtail.core.blocks.CharBlock(help_text='Optional. Only required to use place ID and zoom features.', label='API key', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('code', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('language', wagtail.core.blocks.ChoiceBlock(choices=[('abap', 'ABAP'), ('apl', 'APL'), ('abnf', 'ABNF'), ('as3', 'ActionScript 3'), ('as', 'ActionScript'), ('ada', 'Ada'), ('adl', 'ADL'), ('agda', 'Agda'), ('aheui', 'Aheui'), ('alloy', 'Alloy'), ('at', 'AmbientTalk'), ('ampl', 'Ampl'), ('html+ng2', 'HTML + Angular2'), ('ng2', 'Angular2'), ('antlr-as', 'ANTLR With ActionScript Target'), ('antlr-csharp', 'ANTLR With C# Target'), ('antlr-cpp', 'ANTLR With CPP Target'), ('antlr-java', 'ANTLR With Java Target'), ('antlr', 'ANTLR'), ('antlr-objc', 'ANTLR With ObjectiveC Target'), ('antlr-perl', 'ANTLR With Perl Target'), ('antlr-python', 'ANTLR With Python Target'), ('antlr-ruby', 'ANTLR With Ruby Target'), ('apacheconf', 'ApacheConf'), ('applescript', 'AppleScript'), ('arduino', 'Arduino'), ('aspectj', 'AspectJ'), ('asy', 'Asymptote'), ('autoit', 'AutoIt'), ('ahk', 'autohotkey'), ('awk', 'Awk'), ('bbcode', 'BBCode'), ('bc', 'BC'), ('bst', 'BST'), ('basemake', 'Base Makefile'), ('bash', 'Bash'), ('console', 'Bash Session'), ('bat', 'Batchfile'), ('befunge', 'Befunge'), ('bib', 'BibTeX'), ('blitzbasic', 'BlitzBasic'), ('blitzmax', 'BlitzMax'), ('bnf', 'BNF'), ('boo', 'Boo'), ('boogie', 'Boogie'), ('brainfuck', 'Brainfuck'), ('bro', 'Bro'), ('bugs', 'BUGS'), ('camkes', 'CAmkES'), ('c', 'C'), ('cmake', 'CMake'), ('c-objdump', 'c-objdump'), ('cpsa', 'CPSA'), ('aspx-cs', 'aspx-cs'), ('csharp', 'C#'), ('ca65', 'ca65 assembler'), ('cadl', 'cADL'), ('capdl', 'CapDL'), ('capnp', "Cap'n Proto"), ('cbmbas', 'CBM BASIC V2'), ('ceylon', 'Ceylon'), ('cfengine3', 'CFEngine3'), ('chai', 'ChaiScript'), ('chapel', 'Chapel'), ('html+cheetah', 'HTML+Cheetah'), ('js+cheetah', 'JavaScript+Cheetah'), ('cheetah', 'Cheetah'), ('xml+cheetah', 'XML+Cheetah'), ('cirru', 'Cirru'), ('clay', 'Clay'), ('clean', 'Clean'), ('clojure', 'Clojure'), ('clojurescript', 'ClojureScript'), ('cobolfree', 'COBOLFree'), ('cobol', 'COBOL'), ('coffee-script', 'CoffeeScript'), ('cfc', 'Coldfusion CFC'), ('cfm', 'Coldfusion HTML'), ('cfs', 'cfstatement'), ('common-lisp', 'Common Lisp'), ('componentpascal', 'Component Pascal'), ('coq', 'Coq'), ('cpp', 'C++'), ('cpp-objdump', 'cpp-objdump'), ('crmsh', 'Crmsh'), ('croc', 'Croc'), ('cryptol', 'Cryptol'), ('cr', 'Crystal'), ('csound-document', 'Csound Document'), ('csound', 'Csound Orchestra'), ('csound-score', 'Csound Score'), ('css+django', 'CSS+Django/Jinja'), ('css+erb', 'CSS+Ruby'), ('css+genshitext', 'CSS+Genshi Text'), ('css', 'CSS'), ('css+php', 'CSS+PHP'), ('css+smarty', 'CSS+Smarty'), ('cuda', 'CUDA'), ('cypher', 'Cypher'), ('cython', 'Cython'), ('d', 'D'), ('d-objdump', 'd-objdump'), ('dpatch', 'Darcs Patch'), ('dart', 'Dart'), ('control', 'Debian Control file'), ('delphi', 'Delphi'), ('dg', 'dg'), ('diff', 'Diff'), ('django', 'Django/Jinja'), ('docker', 'Docker'), ('dtd', 'DTD'), ('duel', 'Duel'), ('dylan-console', 'Dylan session'), ('dylan', 'Dylan'), ('dylan-lid', 'DylanLID'), ('ecl', 'ECL'), ('ec', 'eC'), ('earl-grey', 'Earl Grey'), ('easytrieve', 'Easytrieve'), ('ebnf', 'EBNF'), ('eiffel', 'Eiffel'), ('iex', 'Elixir iex session'), ('elixir', 'Elixir'), ('elm', 'Elm'), ('emacs', 'EmacsLisp'), ('erb', 'ERB'), ('erlang', 'Erlang'), ('erl', 'Erlang erl session'), ('html+evoque', 'HTML+Evoque'), ('evoque', 'Evoque'), ('xml+evoque', 'XML+Evoque'), ('ezhil', 'Ezhil'), ('fsharp', 'FSharp'), ('factor', 'Factor'), ('fancy', 'Fancy'), ('fan', 'Fantom'), ('felix', 'Felix'), ('fish', 'Fish'), ('flatline', 'Flatline'), ('forth', 'Forth'), ('fortranfixed', 'FortranFixed'), ('fortran', 'Fortran'), ('foxpro', 'FoxPro'), ('gap', 'GAP'), ('glsl', 'GLSL'), ('gas', 'GAS'), ('genshi', 'Genshi'), ('genshitext', 'Genshi Text'), ('pot', 'Gettext Catalog'), ('cucumber', 'Gherkin'), ('gnuplot', 'Gnuplot'), ('go', 'Go'), ('golo', 'Golo'), ('gooddata-cl', 'GoodData-CL'), ('gosu', 'Gosu'), ('gst', 'Gosu Template'), ('groff', 'Groff'), ('groovy', 'Groovy'), ('haml', 'Haml'), ('html+handlebars', 'HTML+Handlebars'), ('handlebars', 'Handlebars'), ('haskell', 'Haskell'), ('hx', 'Haxe'), ('hexdump', 'Hexdump'), ('hsail', 'HSAIL'), ('html+django', 'HTML+Django/Jinja'), ('html+genshi', 'HTML+Genshi'), ('html', 'HTML'), ('html+php', 'HTML+PHP'), ('html+smarty', 'HTML+Smarty'), ('http', 'HTTP'), ('haxeml', 'Hxml'), ('hylang', 'Hy'), ('hybris', 'Hybris'), ('idl', 'IDL'), ('idris', 'Idris'), ('igor', 'Igor'), ('inform6', 'Inform 6'), ('i6t', 'Inform 6 template'), ('inform7', 'Inform 7'), ('ini', 'INI'), ('io', 'Io'), ('ioke', 'Ioke'), ('irc', 'IRC logs'), ('isabelle', 'Isabelle'), ('j', 'J'), ('jags', 'JAGS'), ('jasmin', 'Jasmin'), ('java', 'Java'), ('js+django', 'JavaScript+Django/Jinja'), ('js+erb', 'JavaScript+Ruby'), ('js+genshitext', 'JavaScript+Genshi Text'), ('js', 'JavaScript'), ('js+php', 'JavaScript+PHP'), ('js+smarty', 'JavaScript+Smarty'), ('jcl', 'JCL'), ('jsgf', 'JSGF'), ('json-object', 'JSONBareObject'), ('jsonld', 'JSON-LD'), ('json', 'JSON'), ('jsp', 'Java Server Page'), ('jlcon', 'Julia console'), ('julia', 'Julia'), ('juttle', 'Juttle'), ('kal', 'Kal'), ('kconfig', 'Kconfig'), ('koka', 'Koka'), ('kotlin', 'Kotlin'), ('lsl', 'LSL'), ('css+lasso', 'CSS+Lasso'), ('html+lasso', 'HTML+Lasso'), ('js+lasso', 'JavaScript+Lasso'), ('lasso', 'Lasso'), ('xml+lasso', 'XML+Lasso'), ('lean', 'Lean'), ('less', 'LessCss'), ('lighty', 'Lighttpd configuration file'), ('limbo', 'Limbo'), ('liquid', 'liquid'), ('lagda', 'Literate Agda'), ('lcry', 'Literate Cryptol'), ('lhs', 'Literate Haskell'), ('lidr', 'Literate Idris'), ('live-script', 'LiveScript'), ('llvm', 'LLVM'), ('logos', 'Logos'), ('logtalk', 'Logtalk'), ('lua', 'Lua'), ('moocode', 'MOOCode'), ('doscon', 'MSDOS Session'), ('make', 'Makefile'), ('css+mako', 'CSS+Mako'), ('html+mako', 'HTML+Mako'), ('js+mako', 'JavaScript+Mako'), ('mako', 'Mako'), ('xml+mako', 'XML+Mako'), ('maql', 'MAQL'), ('md', 'markdown'), ('mask', 'Mask'), ('mason', 'Mason'), ('mathematica', 'Mathematica'), ('matlab', 'Matlab'), ('matlabsession', 'Matlab session'), ('minid', 'MiniD'), ('modelica', 'Modelica'), ('modula2', 'Modula-2'), ('trac-wiki', 'MoinMoin/Trac Wiki markup'), ('monkey', 'Monkey'), ('monte', 'Monte'), ('moon', 'MoonScript'), ('css+mozpreproc', 'CSS+mozpreproc'), ('mozhashpreproc', 'mozhashpreproc'), ('javascript+mozpreproc', 'Javascript+mozpreproc'), ('mozpercentpreproc', 'mozpercentpreproc'), ('xul+mozpreproc', 'XUL+mozpreproc'), ('mql', 'MQL'), ('mscgen', 'Mscgen'), ('mupad', 'MuPAD'), ('mxml', 'MXML'), ('mysql', 'MySQL'), ('css+myghty', 'CSS+Myghty'), ('html+myghty', 'HTML+Myghty'), ('js+myghty', 'JavaScript+Myghty'), ('myghty', 'Myghty'), ('xml+myghty', 'XML+Myghty'), ('ncl', 'NCL'), ('nsis', 'NSIS'), ('nasm', 'NASM'), ('objdump-nasm', 'objdump-nasm'), ('nemerle', 'Nemerle'), ('nesc', 'nesC'), ('newlisp', 'NewLisp'), ('newspeak', 'Newspeak'), ('nginx', 'Nginx configuration file'), ('nim', 'Nimrod'), ('nit', 'Nit'), ('nixos', 'Nix'), ('nusmv', 'NuSMV'), ('numpy', 'NumPy'), ('objdump', 'objdump'), ('objective-c', 'Objective-C'), ('objective-c++', 'Objective-C++'), ('objective-j', 'Objective-J'), ('ocaml', 'OCaml'), ('octave', 'Octave'), ('odin', 'ODIN'), ('ooc', 'Ooc'), ('opa', 'Opa'), ('openedge', 'OpenEdge ABL'), ('pacmanconf', 'PacmanConf'), ('pan', 'Pan'), ('parasail', 'ParaSail'), ('pawn', 'Pawn'), ('perl6', 'Perl6'), ('perl', 'Perl'), ('php', 'PHP'), ('pig', 'Pig'), ('pike', 'Pike'), ('pkgconfig', 'PkgConfig'), ('plpgsql', 'PL/pgSQL'), ('postscript', 'PostScript'), ('psql', 'PostgreSQL console (psql)'), ('postgresql', 'PostgreSQL SQL dialect'), ('pov', 'POVRay'), ('powershell', 'PowerShell'), ('ps1con', 'PowerShell Session'), ('praat', 'Praat'), ('prolog', 'Prolog'), ('properties', 'Properties'), ('protobuf', 'Protocol Buffer'), ('pug', 'Pug'), ('puppet', 'Puppet'), ('pypylog', 'PyPy Log'), ('python3', 'Python 3'), ('py3tb', 'Python 3.0 Traceback'), ('pycon', 'Python console session'), ('python', 'Python'), ('pytb', 'Python Traceback'), ('qbasic', 'QBasic'), ('qvto', 'QVTO'), ('qml', 'QML'), ('rconsole', 'RConsole'), ('rnc', 'Relax-NG Compact'), ('spec', 'RPMSpec'), ('racket', 'Racket'), ('ragel-c', 'Ragel in C Host'), ('ragel-cpp', 'Ragel in CPP Host'), ('ragel-d', 'Ragel in D Host'), ('ragel-em', 'Embedded Ragel'), ('ragel-java', 'Ragel in Java Host'), ('ragel', 'Ragel'), ('ragel-objc', 'Ragel in Objective C Host'), ('ragel-ruby', 'Ragel in Ruby Host'), ('raw', 'Raw token data'), ('rd', 'Rd'), ('rebol', 'REBOL'), ('red', 'Red'), ('redcode', 'Redcode'), ('registry', 'reg'), ('resource', 'ResourceBundle'), ('rexx', 'Rexx'), ('rhtml', 'RHTML'), ('roboconf-graph', 'Roboconf Graph'), ('roboconf-instances', 'Roboconf Instances'), ('robotframework', 'RobotFramework'), ('rql', 'RQL'), ('rsl', 'RSL'), ('rst', 'reStructuredText'), ('rts', 'TrafficScript'), ('rbcon', 'Ruby irb session'), ('rb', 'Ruby'), ('rust', 'Rust'), ('sas', 'SAS'), ('splus', 'S'), ('sml', 'Standard ML'), ('sass', 'Sass'), ('scala', 'Scala'), ('scaml', 'Scaml'), ('scheme', 'Scheme'), ('scilab', 'Scilab'), ('scss', 'SCSS'), ('shen', 'Shen'), ('silver', 'Silver'), ('slim', 'Slim'), ('smali', 'Smali'), ('smalltalk', 'Smalltalk'), ('smarty', 'Smarty'), ('snobol', 'Snobol'), ('snowball', 'Snowball'), ('sp', 'SourcePawn'), ('sourceslist', 'Debian Sourcelist'), ('sparql', 'SPARQL'), ('sql', 'SQL'), ('sqlite3', 'sqlite3con'), ('squidconf', 'SquidConf'), ('ssp', 'Scalate Server Page'), ('stan', 'Stan'), ('stata', 'Stata'), ('sc', 'SuperCollider'), ('swift', 'Swift'), ('swig', 'SWIG'), ('systemverilog', 'systemverilog'), ('tap', 'TAP'), ('tads3', 'TADS 3'), ('tasm', 'TASM'), ('tcl', 'Tcl'), ('tcsh', 'Tcsh'), ('tcshcon', 'Tcsh Session'), ('tea', 'Tea'), ('termcap', 'Termcap'), ('terminfo', 'Terminfo'), ('terraform', 'Terraform'), ('tex', 'TeX'), ('text', 'Text only'), ('thrift', 'Thrift'), ('todotxt', 'Todotxt'), ('tsql', 'Transact-SQL'), ('treetop', 'Treetop'), ('turtle', 'Turtle'), ('html+twig', 'HTML+Twig'), ('twig', 'Twig'), ('ts', 'TypeScript'), ('typoscriptcssdata', 'TypoScriptCssData'), ('typoscripthtmldata', 'TypoScriptHtmlData'), ('typoscript', 'TypoScript'), ('urbiscript', 'UrbiScript'), ('vcl', 'VCL'), ('vclsnippets', 'VCLSnippets'), ('vctreestatus', 'VCTreeStatus'), ('vgl', 'VGL'), ('vala', 'Vala'), ('aspx-vb', 'aspx-vb'), ('vb.net', 'VB.net'), ('html+velocity', 'HTML+Velocity'), ('velocity', 'Velocity'), ('xml+velocity', 'XML+Velocity'), ('verilog', 'verilog'), ('vhdl', 'vhdl'), ('vim', 'VimL'), ('wdiff', 'WDiff'), ('whiley', 'Whiley'), ('x10', 'X10'), ('xquery', 'XQuery'), ('xml+django', 'XML+Django/Jinja'), ('xml+erb', 'XML+Ruby'), ('xml', 'XML'), ('xml+php', 'XML+PHP'), ('xml+smarty', 'XML+Smarty'), ('xslt', 'XSLT'), ('xtend', 'Xtend'), ('extempore', 'xtlang'), ('yaml+jinja', 'YAML+Jinja'), ('yaml', 'YAML'), ('zephir', 'Zephir')], label='Syntax highlighting', required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('code', wagtail.core.blocks.TextBlock(classname='monospace', help_text='Code is rendered in a <pre> tag.', label='Code', rows=8))]))], label='Content')), ('footer', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], label='Modal footer'))])), ('pricelist', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.core.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.core.blocks.StreamBlock([('item', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.core.blocks.CharBlock(label='Name', max_length=255, requred=True)), ('description', wagtail.core.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.core.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))]))], label='Content'))]))], label='Content'))])), ('cardgrid', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/cardgrid_group.html', 'Card group - attached cards of equal size'), ('coderedcms/blocks/cardgrid_deck.html', 'Card deck - separate cards of equal size'), ('coderedcms/blocks/cardgrid_columns.html', 'Card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))]))], label='Content'))])), ('hero', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(default=True, label='Full width', required=False)), ('is_parallax', wagtail.core.blocks.BooleanBlock(help_text='Background images scroll slower than foreground images, creating an illusion of depth.', label='Parallax Effect', required=False)), ('background_image', wagtail.images.blocks.ImageChooserBlock(required=False)), ('tile_image', wagtail.core.blocks.BooleanBlock(default=False, label='Tile background image', required=False)), ('background_color', wagtail.core.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Background color', max_length=255, required=False)), ('foreground_color', wagtail.core.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Text color', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('row', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.core.blocks.URLBlock(help_text='Link to a YouTube or Vimeo video.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('api_key', wagtail.core.blocks.CharBlock(help_text='Optional. Only required to use place ID and zoom features.', label='API key', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('code', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('language', wagtail.core.blocks.ChoiceBlock(choices=[('abap', 'ABAP'), ('apl', 'APL'), ('abnf', 'ABNF'), ('as3', 'ActionScript 3'), ('as', 'ActionScript'), ('ada', 'Ada'), ('adl', 'ADL'), ('agda', 'Agda'), ('aheui', 'Aheui'), ('alloy', 'Alloy'), ('at', 'AmbientTalk'), ('ampl', 'Ampl'), ('html+ng2', 'HTML + Angular2'), ('ng2', 'Angular2'), ('antlr-as', 'ANTLR With ActionScript Target'), ('antlr-csharp', 'ANTLR With C# Target'), ('antlr-cpp', 'ANTLR With CPP Target'), ('antlr-java', 'ANTLR With Java Target'), ('antlr', 'ANTLR'), ('antlr-objc', 'ANTLR With ObjectiveC Target'), ('antlr-perl', 'ANTLR With Perl Target'), ('antlr-python', 'ANTLR With Python Target'), ('antlr-ruby', 'ANTLR With Ruby Target'), ('apacheconf', 'ApacheConf'), ('applescript', 'AppleScript'), ('arduino', 'Arduino'), ('aspectj', 'AspectJ'), ('asy', 'Asymptote'), ('autoit', 'AutoIt'), ('ahk', 'autohotkey'), ('awk', 'Awk'), ('bbcode', 'BBCode'), ('bc', 'BC'), ('bst', 'BST'), ('basemake', 'Base Makefile'), ('bash', 'Bash'), ('console', 'Bash Session'), ('bat', 'Batchfile'), ('befunge', 'Befunge'), ('bib', 'BibTeX'), ('blitzbasic', 'BlitzBasic'), ('blitzmax', 'BlitzMax'), ('bnf', 'BNF'), ('boo', 'Boo'), ('boogie', 'Boogie'), ('brainfuck', 'Brainfuck'), ('bro', 'Bro'), ('bugs', 'BUGS'), ('camkes', 'CAmkES'), ('c', 'C'), ('cmake', 'CMake'), ('c-objdump', 'c-objdump'), ('cpsa', 'CPSA'), ('aspx-cs', 'aspx-cs'), ('csharp', 'C#'), ('ca65', 'ca65 assembler'), ('cadl', 'cADL'), ('capdl', 'CapDL'), ('capnp', "Cap'n Proto"), ('cbmbas', 'CBM BASIC V2'), ('ceylon', 'Ceylon'), ('cfengine3', 'CFEngine3'), ('chai', 'ChaiScript'), ('chapel', 'Chapel'), ('html+cheetah', 'HTML+Cheetah'), ('js+cheetah', 'JavaScript+Cheetah'), ('cheetah', 'Cheetah'), ('xml+cheetah', 'XML+Cheetah'), ('cirru', 'Cirru'), ('clay', 'Clay'), ('clean', 'Clean'), ('clojure', 'Clojure'), ('clojurescript', 'ClojureScript'), ('cobolfree', 'COBOLFree'), ('cobol', 'COBOL'), ('coffee-script', 'CoffeeScript'), ('cfc', 'Coldfusion CFC'), ('cfm', 'Coldfusion HTML'), ('cfs', 'cfstatement'), ('common-lisp', 'Common Lisp'), ('componentpascal', 'Component Pascal'), ('coq', 'Coq'), ('cpp', 'C++'), ('cpp-objdump', 'cpp-objdump'), ('crmsh', 'Crmsh'), ('croc', 'Croc'), ('cryptol', 'Cryptol'), ('cr', 'Crystal'), ('csound-document', 'Csound Document'), ('csound', 'Csound Orchestra'), ('csound-score', 'Csound Score'), ('css+django', 'CSS+Django/Jinja'), ('css+erb', 'CSS+Ruby'), ('css+genshitext', 'CSS+Genshi Text'), ('css', 'CSS'), ('css+php', 'CSS+PHP'), ('css+smarty', 'CSS+Smarty'), ('cuda', 'CUDA'), ('cypher', 'Cypher'), ('cython', 'Cython'), ('d', 'D'), ('d-objdump', 'd-objdump'), ('dpatch', 'Darcs Patch'), ('dart', 'Dart'), ('control', 'Debian Control file'), ('delphi', 'Delphi'), ('dg', 'dg'), ('diff', 'Diff'), ('django', 'Django/Jinja'), ('docker', 'Docker'), ('dtd', 'DTD'), ('duel', 'Duel'), ('dylan-console', 'Dylan session'), ('dylan', 'Dylan'), ('dylan-lid', 'DylanLID'), ('ecl', 'ECL'), ('ec', 'eC'), ('earl-grey', 'Earl Grey'), ('easytrieve', 'Easytrieve'), ('ebnf', 'EBNF'), ('eiffel', 'Eiffel'), ('iex', 'Elixir iex session'), ('elixir', 'Elixir'), ('elm', 'Elm'), ('emacs', 'EmacsLisp'), ('erb', 'ERB'), ('erlang', 'Erlang'), ('erl', 'Erlang erl session'), ('html+evoque', 'HTML+Evoque'), ('evoque', 'Evoque'), ('xml+evoque', 'XML+Evoque'), ('ezhil', 'Ezhil'), ('fsharp', 'FSharp'), ('factor', 'Factor'), ('fancy', 'Fancy'), ('fan', 'Fantom'), ('felix', 'Felix'), ('fish', 'Fish'), ('flatline', 'Flatline'), ('forth', 'Forth'), ('fortranfixed', 'FortranFixed'), ('fortran', 'Fortran'), ('foxpro', 'FoxPro'), ('gap', 'GAP'), ('glsl', 'GLSL'), ('gas', 'GAS'), ('genshi', 'Genshi'), ('genshitext', 'Genshi Text'), ('pot', 'Gettext Catalog'), ('cucumber', 'Gherkin'), ('gnuplot', 'Gnuplot'), ('go', 'Go'), ('golo', 'Golo'), ('gooddata-cl', 'GoodData-CL'), ('gosu', 'Gosu'), ('gst', 'Gosu Template'), ('groff', 'Groff'), ('groovy', 'Groovy'), ('haml', 'Haml'), ('html+handlebars', 'HTML+Handlebars'), ('handlebars', 'Handlebars'), ('haskell', 'Haskell'), ('hx', 'Haxe'), ('hexdump', 'Hexdump'), ('hsail', 'HSAIL'), ('html+django', 'HTML+Django/Jinja'), ('html+genshi', 'HTML+Genshi'), ('html', 'HTML'), ('html+php', 'HTML+PHP'), ('html+smarty', 'HTML+Smarty'), ('http', 'HTTP'), ('haxeml', 'Hxml'), ('hylang', 'Hy'), ('hybris', 'Hybris'), ('idl', 'IDL'), ('idris', 'Idris'), ('igor', 'Igor'), ('inform6', 'Inform 6'), ('i6t', 'Inform 6 template'), ('inform7', 'Inform 7'), ('ini', 'INI'), ('io', 'Io'), ('ioke', 'Ioke'), ('irc', 'IRC logs'), ('isabelle', 'Isabelle'), ('j', 'J'), ('jags', 'JAGS'), ('jasmin', 'Jasmin'), ('java', 'Java'), ('js+django', 'JavaScript+Django/Jinja'), ('js+erb', 'JavaScript+Ruby'), ('js+genshitext', 'JavaScript+Genshi Text'), ('js', 'JavaScript'), ('js+php', 'JavaScript+PHP'), ('js+smarty', 'JavaScript+Smarty'), ('jcl', 'JCL'), ('jsgf', 'JSGF'), ('json-object', 'JSONBareObject'), ('jsonld', 'JSON-LD'), ('json', 'JSON'), ('jsp', 'Java Server Page'), ('jlcon', 'Julia console'), ('julia', 'Julia'), ('juttle', 'Juttle'), ('kal', 'Kal'), ('kconfig', 'Kconfig'), ('koka', 'Koka'), ('kotlin', 'Kotlin'), ('lsl', 'LSL'), ('css+lasso', 'CSS+Lasso'), ('html+lasso', 'HTML+Lasso'), ('js+lasso', 'JavaScript+Lasso'), ('lasso', 'Lasso'), ('xml+lasso', 'XML+Lasso'), ('lean', 'Lean'), ('less', 'LessCss'), ('lighty', 'Lighttpd configuration file'), ('limbo', 'Limbo'), ('liquid', 'liquid'), ('lagda', 'Literate Agda'), ('lcry', 'Literate Cryptol'), ('lhs', 'Literate Haskell'), ('lidr', 'Literate Idris'), ('live-script', 'LiveScript'), ('llvm', 'LLVM'), ('logos', 'Logos'), ('logtalk', 'Logtalk'), ('lua', 'Lua'), ('moocode', 'MOOCode'), ('doscon', 'MSDOS Session'), ('make', 'Makefile'), ('css+mako', 'CSS+Mako'), ('html+mako', 'HTML+Mako'), ('js+mako', 'JavaScript+Mako'), ('mako', 'Mako'), ('xml+mako', 'XML+Mako'), ('maql', 'MAQL'), ('md', 'markdown'), ('mask', 'Mask'), ('mason', 'Mason'), ('mathematica', 'Mathematica'), ('matlab', 'Matlab'), ('matlabsession', 'Matlab session'), ('minid', 'MiniD'), ('modelica', 'Modelica'), ('modula2', 'Modula-2'), ('trac-wiki', 'MoinMoin/Trac Wiki markup'), ('monkey', 'Monkey'), ('monte', 'Monte'), ('moon', 'MoonScript'), ('css+mozpreproc', 'CSS+mozpreproc'), ('mozhashpreproc', 'mozhashpreproc'), ('javascript+mozpreproc', 'Javascript+mozpreproc'), ('mozpercentpreproc', 'mozpercentpreproc'), ('xul+mozpreproc', 'XUL+mozpreproc'), ('mql', 'MQL'), ('mscgen', 'Mscgen'), ('mupad', 'MuPAD'), ('mxml', 'MXML'), ('mysql', 'MySQL'), ('css+myghty', 'CSS+Myghty'), ('html+myghty', 'HTML+Myghty'), ('js+myghty', 'JavaScript+Myghty'), ('myghty', 'Myghty'), ('xml+myghty', 'XML+Myghty'), ('ncl', 'NCL'), ('nsis', 'NSIS'), ('nasm', 'NASM'), ('objdump-nasm', 'objdump-nasm'), ('nemerle', 'Nemerle'), ('nesc', 'nesC'), ('newlisp', 'NewLisp'), ('newspeak', 'Newspeak'), ('nginx', 'Nginx configuration file'), ('nim', 'Nimrod'), ('nit', 'Nit'), ('nixos', 'Nix'), ('nusmv', 'NuSMV'), ('numpy', 'NumPy'), ('objdump', 'objdump'), ('objective-c', 'Objective-C'), ('objective-c++', 'Objective-C++'), ('objective-j', 'Objective-J'), ('ocaml', 'OCaml'), ('octave', 'Octave'), ('odin', 'ODIN'), ('ooc', 'Ooc'), ('opa', 'Opa'), ('openedge', 'OpenEdge ABL'), ('pacmanconf', 'PacmanConf'), ('pan', 'Pan'), ('parasail', 'ParaSail'), ('pawn', 'Pawn'), ('perl6', 'Perl6'), ('perl', 'Perl'), ('php', 'PHP'), ('pig', 'Pig'), ('pike', 'Pike'), ('pkgconfig', 'PkgConfig'), ('plpgsql', 'PL/pgSQL'), ('postscript', 'PostScript'), ('psql', 'PostgreSQL console (psql)'), ('postgresql', 'PostgreSQL SQL dialect'), ('pov', 'POVRay'), ('powershell', 'PowerShell'), ('ps1con', 'PowerShell Session'), ('praat', 'Praat'), ('prolog', 'Prolog'), ('properties', 'Properties'), ('protobuf', 'Protocol Buffer'), ('pug', 'Pug'), ('puppet', 'Puppet'), ('pypylog', 'PyPy Log'), ('python3', 'Python 3'), ('py3tb', 'Python 3.0 Traceback'), ('pycon', 'Python console session'), ('python', 'Python'), ('pytb', 'Python Traceback'), ('qbasic', 'QBasic'), ('qvto', 'QVTO'), ('qml', 'QML'), ('rconsole', 'RConsole'), ('rnc', 'Relax-NG Compact'), ('spec', 'RPMSpec'), ('racket', 'Racket'), ('ragel-c', 'Ragel in C Host'), ('ragel-cpp', 'Ragel in CPP Host'), ('ragel-d', 'Ragel in D Host'), ('ragel-em', 'Embedded Ragel'), ('ragel-java', 'Ragel in Java Host'), ('ragel', 'Ragel'), ('ragel-objc', 'Ragel in Objective C Host'), ('ragel-ruby', 'Ragel in Ruby Host'), ('raw', 'Raw token data'), ('rd', 'Rd'), ('rebol', 'REBOL'), ('red', 'Red'), ('redcode', 'Redcode'), ('registry', 'reg'), ('resource', 'ResourceBundle'), ('rexx', 'Rexx'), ('rhtml', 'RHTML'), ('roboconf-graph', 'Roboconf Graph'), ('roboconf-instances', 'Roboconf Instances'), ('robotframework', 'RobotFramework'), ('rql', 'RQL'), ('rsl', 'RSL'), ('rst', 'reStructuredText'), ('rts', 'TrafficScript'), ('rbcon', 'Ruby irb session'), ('rb', 'Ruby'), ('rust', 'Rust'), ('sas', 'SAS'), ('splus', 'S'), ('sml', 'Standard ML'), ('sass', 'Sass'), ('scala', 'Scala'), ('scaml', 'Scaml'), ('scheme', 'Scheme'), ('scilab', 'Scilab'), ('scss', 'SCSS'), ('shen', 'Shen'), ('silver', 'Silver'), ('slim', 'Slim'), ('smali', 'Smali'), ('smalltalk', 'Smalltalk'), ('smarty', 'Smarty'), ('snobol', 'Snobol'), ('snowball', 'Snowball'), ('sp', 'SourcePawn'), ('sourceslist', 'Debian Sourcelist'), ('sparql', 'SPARQL'), ('sql', 'SQL'), ('sqlite3', 'sqlite3con'), ('squidconf', 'SquidConf'), ('ssp', 'Scalate Server Page'), ('stan', 'Stan'), ('stata', 'Stata'), ('sc', 'SuperCollider'), ('swift', 'Swift'), ('swig', 'SWIG'), ('systemverilog', 'systemverilog'), ('tap', 'TAP'), ('tads3', 'TADS 3'), ('tasm', 'TASM'), ('tcl', 'Tcl'), ('tcsh', 'Tcsh'), ('tcshcon', 'Tcsh Session'), ('tea', 'Tea'), ('termcap', 'Termcap'), ('terminfo', 'Terminfo'), ('terraform', 'Terraform'), ('tex', 'TeX'), ('text', 'Text only'), ('thrift', 'Thrift'), ('todotxt', 'Todotxt'), ('tsql', 'Transact-SQL'), ('treetop', 'Treetop'), ('turtle', 'Turtle'), ('html+twig', 'HTML+Twig'), ('twig', 'Twig'), ('ts', 'TypeScript'), ('typoscriptcssdata', 'TypoScriptCssData'), ('typoscripthtmldata', 'TypoScriptHtmlData'), ('typoscript', 'TypoScript'), ('urbiscript', 'UrbiScript'), ('vcl', 'VCL'), ('vclsnippets', 'VCLSnippets'), ('vctreestatus', 'VCTreeStatus'), ('vgl', 'VGL'), ('vala', 'Vala'), ('aspx-vb', 'aspx-vb'), ('vb.net', 'VB.net'), ('html+velocity', 'HTML+Velocity'), ('velocity', 'Velocity'), ('xml+velocity', 'XML+Velocity'), ('verilog', 'verilog'), ('vhdl', 'vhdl'), ('vim', 'VimL'), ('wdiff', 'WDiff'), ('whiley', 'Whiley'), ('x10', 'X10'), ('xquery', 'XQuery'), ('xml+django', 'XML+Django/Jinja'), ('xml+erb', 'XML+Ruby'), ('xml', 'XML'), ('xml+php', 'XML+PHP'), ('xml+smarty', 'XML+Smarty'), ('xslt', 'XSLT'), ('xtend', 'Xtend'), ('extempore', 'xtlang'), ('yaml+jinja', 'YAML+Jinja'), ('yaml', 'YAML'), ('zephir', 'Zephir')], label='Syntax highlighting', required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('code', wagtail.core.blocks.TextBlock(classname='monospace', help_text='Code is rendered in a <pre> tag.', label='Code', rows=8))])), ('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.Carousel'))])), ('image_gallery', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', coderedcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection'))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show')), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Only show pages that are children of the selected page. Uses the subpage sorting as specified in the page’s LAYOUT tab.', label='Limit to', required=False))])), ('modal', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('header', wagtail.core.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.core.blocks.URLBlock(help_text='Link to a YouTube or Vimeo video.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('api_key', wagtail.core.blocks.CharBlock(help_text='Optional. Only required to use place ID and zoom features.', label='API key', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('code', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('language', wagtail.core.blocks.ChoiceBlock(choices=[('abap', 'ABAP'), ('apl', 'APL'), ('abnf', 'ABNF'), ('as3', 'ActionScript 3'), ('as', 'ActionScript'), ('ada', 'Ada'), ('adl', 'ADL'), ('agda', 'Agda'), ('aheui', 'Aheui'), ('alloy', 'Alloy'), ('at', 'AmbientTalk'), ('ampl', 'Ampl'), ('html+ng2', 'HTML + Angular2'), ('ng2', 'Angular2'), ('antlr-as', 'ANTLR With ActionScript Target'), ('antlr-csharp', 'ANTLR With C# Target'), ('antlr-cpp', 'ANTLR With CPP Target'), ('antlr-java', 'ANTLR With Java Target'), ('antlr', 'ANTLR'), ('antlr-objc', 'ANTLR With ObjectiveC Target'), ('antlr-perl', 'ANTLR With Perl Target'), ('antlr-python', 'ANTLR With Python Target'), ('antlr-ruby', 'ANTLR With Ruby Target'), ('apacheconf', 'ApacheConf'), ('applescript', 'AppleScript'), ('arduino', 'Arduino'), ('aspectj', 'AspectJ'), ('asy', 'Asymptote'), ('autoit', 'AutoIt'), ('ahk', 'autohotkey'), ('awk', 'Awk'), ('bbcode', 'BBCode'), ('bc', 'BC'), ('bst', 'BST'), ('basemake', 'Base Makefile'), ('bash', 'Bash'), ('console', 'Bash Session'), ('bat', 'Batchfile'), ('befunge', 'Befunge'), ('bib', 'BibTeX'), ('blitzbasic', 'BlitzBasic'), ('blitzmax', 'BlitzMax'), ('bnf', 'BNF'), ('boo', 'Boo'), ('boogie', 'Boogie'), ('brainfuck', 'Brainfuck'), ('bro', 'Bro'), ('bugs', 'BUGS'), ('camkes', 'CAmkES'), ('c', 'C'), ('cmake', 'CMake'), ('c-objdump', 'c-objdump'), ('cpsa', 'CPSA'), ('aspx-cs', 'aspx-cs'), ('csharp', 'C#'), ('ca65', 'ca65 assembler'), ('cadl', 'cADL'), ('capdl', 'CapDL'), ('capnp', "Cap'n Proto"), ('cbmbas', 'CBM BASIC V2'), ('ceylon', 'Ceylon'), ('cfengine3', 'CFEngine3'), ('chai', 'ChaiScript'), ('chapel', 'Chapel'), ('html+cheetah', 'HTML+Cheetah'), ('js+cheetah', 'JavaScript+Cheetah'), ('cheetah', 'Cheetah'), ('xml+cheetah', 'XML+Cheetah'), ('cirru', 'Cirru'), ('clay', 'Clay'), ('clean', 'Clean'), ('clojure', 'Clojure'), ('clojurescript', 'ClojureScript'), ('cobolfree', 'COBOLFree'), ('cobol', 'COBOL'), ('coffee-script', 'CoffeeScript'), ('cfc', 'Coldfusion CFC'), ('cfm', 'Coldfusion HTML'), ('cfs', 'cfstatement'), ('common-lisp', 'Common Lisp'), ('componentpascal', 'Component Pascal'), ('coq', 'Coq'), ('cpp', 'C++'), ('cpp-objdump', 'cpp-objdump'), ('crmsh', 'Crmsh'), ('croc', 'Croc'), ('cryptol', 'Cryptol'), ('cr', 'Crystal'), ('csound-document', 'Csound Document'), ('csound', 'Csound Orchestra'), ('csound-score', 'Csound Score'), ('css+django', 'CSS+Django/Jinja'), ('css+erb', 'CSS+Ruby'), ('css+genshitext', 'CSS+Genshi Text'), ('css', 'CSS'), ('css+php', 'CSS+PHP'), ('css+smarty', 'CSS+Smarty'), ('cuda', 'CUDA'), ('cypher', 'Cypher'), ('cython', 'Cython'), ('d', 'D'), ('d-objdump', 'd-objdump'), ('dpatch', 'Darcs Patch'), ('dart', 'Dart'), ('control', 'Debian Control file'), ('delphi', 'Delphi'), ('dg', 'dg'), ('diff', 'Diff'), ('django', 'Django/Jinja'), ('docker', 'Docker'), ('dtd', 'DTD'), ('duel', 'Duel'), ('dylan-console', 'Dylan session'), ('dylan', 'Dylan'), ('dylan-lid', 'DylanLID'), ('ecl', 'ECL'), ('ec', 'eC'), ('earl-grey', 'Earl Grey'), ('easytrieve', 'Easytrieve'), ('ebnf', 'EBNF'), ('eiffel', 'Eiffel'), ('iex', 'Elixir iex session'), ('elixir', 'Elixir'), ('elm', 'Elm'), ('emacs', 'EmacsLisp'), ('erb', 'ERB'), ('erlang', 'Erlang'), ('erl', 'Erlang erl session'), ('html+evoque', 'HTML+Evoque'), ('evoque', 'Evoque'), ('xml+evoque', 'XML+Evoque'), ('ezhil', 'Ezhil'), ('fsharp', 'FSharp'), ('factor', 'Factor'), ('fancy', 'Fancy'), ('fan', 'Fantom'), ('felix', 'Felix'), ('fish', 'Fish'), ('flatline', 'Flatline'), ('forth', 'Forth'), ('fortranfixed', 'FortranFixed'), ('fortran', 'Fortran'), ('foxpro', 'FoxPro'), ('gap', 'GAP'), ('glsl', 'GLSL'), ('gas', 'GAS'), ('genshi', 'Genshi'), ('genshitext', 'Genshi Text'), ('pot', 'Gettext Catalog'), ('cucumber', 'Gherkin'), ('gnuplot', 'Gnuplot'), ('go', 'Go'), ('golo', 'Golo'), ('gooddata-cl', 'GoodData-CL'), ('gosu', 'Gosu'), ('gst', 'Gosu Template'), ('groff', 'Groff'), ('groovy', 'Groovy'), ('haml', 'Haml'), ('html+handlebars', 'HTML+Handlebars'), ('handlebars', 'Handlebars'), ('haskell', 'Haskell'), ('hx', 'Haxe'), ('hexdump', 'Hexdump'), ('hsail', 'HSAIL'), ('html+django', 'HTML+Django/Jinja'), ('html+genshi', 'HTML+Genshi'), ('html', 'HTML'), ('html+php', 'HTML+PHP'), ('html+smarty', 'HTML+Smarty'), ('http', 'HTTP'), ('haxeml', 'Hxml'), ('hylang', 'Hy'), ('hybris', 'Hybris'), ('idl', 'IDL'), ('idris', 'Idris'), ('igor', 'Igor'), ('inform6', 'Inform 6'), ('i6t', 'Inform 6 template'), ('inform7', 'Inform 7'), ('ini', 'INI'), ('io', 'Io'), ('ioke', 'Ioke'), ('irc', 'IRC logs'), ('isabelle', 'Isabelle'), ('j', 'J'), ('jags', 'JAGS'), ('jasmin', 'Jasmin'), ('java', 'Java'), ('js+django', 'JavaScript+Django/Jinja'), ('js+erb', 'JavaScript+Ruby'), ('js+genshitext', 'JavaScript+Genshi Text'), ('js', 'JavaScript'), ('js+php', 'JavaScript+PHP'), ('js+smarty', 'JavaScript+Smarty'), ('jcl', 'JCL'), ('jsgf', 'JSGF'), ('json-object', 'JSONBareObject'), ('jsonld', 'JSON-LD'), ('json', 'JSON'), ('jsp', 'Java Server Page'), ('jlcon', 'Julia console'), ('julia', 'Julia'), ('juttle', 'Juttle'), ('kal', 'Kal'), ('kconfig', 'Kconfig'), ('koka', 'Koka'), ('kotlin', 'Kotlin'), ('lsl', 'LSL'), ('css+lasso', 'CSS+Lasso'), ('html+lasso', 'HTML+Lasso'), ('js+lasso', 'JavaScript+Lasso'), ('lasso', 'Lasso'), ('xml+lasso', 'XML+Lasso'), ('lean', 'Lean'), ('less', 'LessCss'), ('lighty', 'Lighttpd configuration file'), ('limbo', 'Limbo'), ('liquid', 'liquid'), ('lagda', 'Literate Agda'), ('lcry', 'Literate Cryptol'), ('lhs', 'Literate Haskell'), ('lidr', 'Literate Idris'), ('live-script', 'LiveScript'), ('llvm', 'LLVM'), ('logos', 'Logos'), ('logtalk', 'Logtalk'), ('lua', 'Lua'), ('moocode', 'MOOCode'), ('doscon', 'MSDOS Session'), ('make', 'Makefile'), ('css+mako', 'CSS+Mako'), ('html+mako', 'HTML+Mako'), ('js+mako', 'JavaScript+Mako'), ('mako', 'Mako'), ('xml+mako', 'XML+Mako'), ('maql', 'MAQL'), ('md', 'markdown'), ('mask', 'Mask'), ('mason', 'Mason'), ('mathematica', 'Mathematica'), ('matlab', 'Matlab'), ('matlabsession', 'Matlab session'), ('minid', 'MiniD'), ('modelica', 'Modelica'), ('modula2', 'Modula-2'), ('trac-wiki', 'MoinMoin/Trac Wiki markup'), ('monkey', 'Monkey'), ('monte', 'Monte'), ('moon', 'MoonScript'), ('css+mozpreproc', 'CSS+mozpreproc'), ('mozhashpreproc', 'mozhashpreproc'), ('javascript+mozpreproc', 'Javascript+mozpreproc'), ('mozpercentpreproc', 'mozpercentpreproc'), ('xul+mozpreproc', 'XUL+mozpreproc'), ('mql', 'MQL'), ('mscgen', 'Mscgen'), ('mupad', 'MuPAD'), ('mxml', 'MXML'), ('mysql', 'MySQL'), ('css+myghty', 'CSS+Myghty'), ('html+myghty', 'HTML+Myghty'), ('js+myghty', 'JavaScript+Myghty'), ('myghty', 'Myghty'), ('xml+myghty', 'XML+Myghty'), ('ncl', 'NCL'), ('nsis', 'NSIS'), ('nasm', 'NASM'), ('objdump-nasm', 'objdump-nasm'), ('nemerle', 'Nemerle'), ('nesc', 'nesC'), ('newlisp', 'NewLisp'), ('newspeak', 'Newspeak'), ('nginx', 'Nginx configuration file'), ('nim', 'Nimrod'), ('nit', 'Nit'), ('nixos', 'Nix'), ('nusmv', 'NuSMV'), ('numpy', 'NumPy'), ('objdump', 'objdump'), ('objective-c', 'Objective-C'), ('objective-c++', 'Objective-C++'), ('objective-j', 'Objective-J'), ('ocaml', 'OCaml'), ('octave', 'Octave'), ('odin', 'ODIN'), ('ooc', 'Ooc'), ('opa', 'Opa'), ('openedge', 'OpenEdge ABL'), ('pacmanconf', 'PacmanConf'), ('pan', 'Pan'), ('parasail', 'ParaSail'), ('pawn', 'Pawn'), ('perl6', 'Perl6'), ('perl', 'Perl'), ('php', 'PHP'), ('pig', 'Pig'), ('pike', 'Pike'), ('pkgconfig', 'PkgConfig'), ('plpgsql', 'PL/pgSQL'), ('postscript', 'PostScript'), ('psql', 'PostgreSQL console (psql)'), ('postgresql', 'PostgreSQL SQL dialect'), ('pov', 'POVRay'), ('powershell', 'PowerShell'), ('ps1con', 'PowerShell Session'), ('praat', 'Praat'), ('prolog', 'Prolog'), ('properties', 'Properties'), ('protobuf', 'Protocol Buffer'), ('pug', 'Pug'), ('puppet', 'Puppet'), ('pypylog', 'PyPy Log'), ('python3', 'Python 3'), ('py3tb', 'Python 3.0 Traceback'), ('pycon', 'Python console session'), ('python', 'Python'), ('pytb', 'Python Traceback'), ('qbasic', 'QBasic'), ('qvto', 'QVTO'), ('qml', 'QML'), ('rconsole', 'RConsole'), ('rnc', 'Relax-NG Compact'), ('spec', 'RPMSpec'), ('racket', 'Racket'), ('ragel-c', 'Ragel in C Host'), ('ragel-cpp', 'Ragel in CPP Host'), ('ragel-d', 'Ragel in D Host'), ('ragel-em', 'Embedded Ragel'), ('ragel-java', 'Ragel in Java Host'), ('ragel', 'Ragel'), ('ragel-objc', 'Ragel in Objective C Host'), ('ragel-ruby', 'Ragel in Ruby Host'), ('raw', 'Raw token data'), ('rd', 'Rd'), ('rebol', 'REBOL'), ('red', 'Red'), ('redcode', 'Redcode'), ('registry', 'reg'), ('resource', 'ResourceBundle'), ('rexx', 'Rexx'), ('rhtml', 'RHTML'), ('roboconf-graph', 'Roboconf Graph'), ('roboconf-instances', 'Roboconf Instances'), ('robotframework', 'RobotFramework'), ('rql', 'RQL'), ('rsl', 'RSL'), ('rst', 'reStructuredText'), ('rts', 'TrafficScript'), ('rbcon', 'Ruby irb session'), ('rb', 'Ruby'), ('rust', 'Rust'), ('sas', 'SAS'), ('splus', 'S'), ('sml', 'Standard ML'), ('sass', 'Sass'), ('scala', 'Scala'), ('scaml', 'Scaml'), ('scheme', 'Scheme'), ('scilab', 'Scilab'), ('scss', 'SCSS'), ('shen', 'Shen'), ('silver', 'Silver'), ('slim', 'Slim'), ('smali', 'Smali'), ('smalltalk', 'Smalltalk'), ('smarty', 'Smarty'), ('snobol', 'Snobol'), ('snowball', 'Snowball'), ('sp', 'SourcePawn'), ('sourceslist', 'Debian Sourcelist'), ('sparql', 'SPARQL'), ('sql', 'SQL'), ('sqlite3', 'sqlite3con'), ('squidconf', 'SquidConf'), ('ssp', 'Scalate Server Page'), ('stan', 'Stan'), ('stata', 'Stata'), ('sc', 'SuperCollider'), ('swift', 'Swift'), ('swig', 'SWIG'), ('systemverilog', 'systemverilog'), ('tap', 'TAP'), ('tads3', 'TADS 3'), ('tasm', 'TASM'), ('tcl', 'Tcl'), ('tcsh', 'Tcsh'), ('tcshcon', 'Tcsh Session'), ('tea', 'Tea'), ('termcap', 'Termcap'), ('terminfo', 'Terminfo'), ('terraform', 'Terraform'), ('tex', 'TeX'), ('text', 'Text only'), ('thrift', 'Thrift'), ('todotxt', 'Todotxt'), ('tsql', 'Transact-SQL'), ('treetop', 'Treetop'), ('turtle', 'Turtle'), ('html+twig', 'HTML+Twig'), ('twig', 'Twig'), ('ts', 'TypeScript'), ('typoscriptcssdata', 'TypoScriptCssData'), ('typoscripthtmldata', 'TypoScriptHtmlData'), ('typoscript', 'TypoScript'), ('urbiscript', 'UrbiScript'), ('vcl', 'VCL'), ('vclsnippets', 'VCLSnippets'), ('vctreestatus', 'VCTreeStatus'), ('vgl', 'VGL'), ('vala', 'Vala'), ('aspx-vb', 'aspx-vb'), ('vb.net', 'VB.net'), ('html+velocity', 'HTML+Velocity'), ('velocity', 'Velocity'), ('xml+velocity', 'XML+Velocity'), ('verilog', 'verilog'), ('vhdl', 'vhdl'), ('vim', 'VimL'), ('wdiff', 'WDiff'), ('whiley', 'Whiley'), ('x10', 'X10'), ('xquery', 'XQuery'), ('xml+django', 'XML+Django/Jinja'), ('xml+erb', 'XML+Ruby'), ('xml', 'XML'), ('xml+php', 'XML+PHP'), ('xml+smarty', 'XML+Smarty'), ('xslt', 'XSLT'), ('xtend', 'Xtend'), ('extempore', 'xtlang'), ('yaml+jinja', 'YAML+Jinja'), ('yaml', 'YAML'), ('zephir', 'Zephir')], label='Syntax highlighting', required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('code', wagtail.core.blocks.TextBlock(classname='monospace', help_text='Code is rendered in a <pre> tag.', label='Code', rows=8))]))], label='Content')), ('footer', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], label='Modal footer'))])), ('pricelist', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.core.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.core.blocks.StreamBlock([('item', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.core.blocks.CharBlock(label='Name', max_length=255, requred=True)), ('description', wagtail.core.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.core.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))]))], label='Content'))]))], label='Content'))])), ('html', wagtail.core.blocks.RawHTMLBlock(classname='monospace', icon='code', label='HTML'))], label='Content'))])), ('html', wagtail.core.blocks.RawHTMLBlock(classname='monospace', icon='code', label='HTML'))], verbose_name='Content')),
            ],
            options={
                'verbose_name': 'Footer',
            },
        ),
        migrations.CreateModel(
            name='GeneralSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_email_address', models.EmailField(blank=True, help_text='The default email address this site uses to send emails.', max_length=255, verbose_name='From email address')),
                ('search_num_results', models.PositiveIntegerField(default=10, verbose_name='Number of results per page')),
                ('robots', models.TextField(blank=True, default='User-agent: *\nDisallow: /admin/\n\nUser-agent: *\nDisallow: /django-admin/\n\nUser-agent: *\nAllow: /\n\nSitemap: /sitemap.xml', help_text='Enter the contents of a robots.txt file.', verbose_name='robots.txt')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
            ],
            options={
                'verbose_name': 'General',
            },
        ),
        migrations.CreateModel(
            name='LayoutSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('navbar_color_scheme', models.CharField(blank=True, choices=[('navbar-light', 'Light - for use with a light-colored navbar'), ('navbar-dark', 'Dark - for use with a dark-colored navbar')], default='navbar-light', help_text='Optimizes text and other navbar elements for use with light or dark backgrounds.', max_length=50, verbose_name='Navbar color scheme')),
                ('navbar_class', models.CharField(blank=True, default='bg-light', help_text='Custom classes applied to navbar e.g. "bg-light", "bg-dark", "bg-primary".', max_length=255, verbose_name='Navbar CSS class')),
                ('navbar_fixed', models.BooleanField(default=False, help_text='Fixed navbar will remain at the top of the page when scrolling.', verbose_name='Fixed navbar')),
                ('navbar_wrapper_fluid', models.BooleanField(default=True, help_text='The navbar will fill edge to edge.', verbose_name='Full width navbar')),
                ('navbar_content_fluid', models.BooleanField(default=False, help_text='Content within the navbar will fill edge to edge.', verbose_name='Full width navbar contents')),
                ('navbar_collapse_mode', models.CharField(blank=True, choices=[('', 'Never show menu - Always collapse menu behind a button'), ('navbar-expand-sm', 'sm - Show on small screens (phone size) and larger'), ('navbar-expand-md', 'md - Show on medium screens (tablet size) and larger'), ('navbar-expand-lg', 'lg - Show on large screens (laptop size) and larger'), ('navbar-expand-xl', 'xl - Show on extra large screens (desktop, wide monitor)')], default='navbar-expand-lg', help_text='Control on what screen sizes to show and collapse the navbar menu links.', max_length=50, verbose_name='Collapse navbar menu')),
                ('navbar_format', models.CharField(blank=True, choices=[('', 'Default Bootstrap Navbar'), ('codered-navbar-center', 'Centered logo at top')], default='', max_length=50, verbose_name='Navbar format')),
                ('navbar_search', models.BooleanField(default=True, help_text='Show search box in navbar', verbose_name='Search box')),
                ('frontend_theme', models.CharField(blank=True, choices=[('', 'Default - Classic Bootstrap'), ('cerulean', 'Cerulean - A calm blue sky'), ('cosmo', 'Cosmo - An ode to Metro'), ('cyborg', 'Cyborg - Jet black and electric blue'), ('darkly', 'Darkly - Flatly in night mode'), ('flatly', 'Flatly - Flat and modern'), ('journal', 'Journal - Crisp like a new sheet of paper'), ('litera', 'Litera - The medium is the message'), ('lumen', 'Lumen - Light and shadow'), ('lux', 'Lux - A touch of class'), ('materia', 'Materia - Material is the metaphor'), ('minty', 'Minty - A fresh feel'), ('pulse', 'Pulse - A trace of purple'), ('sandstone', 'Sandstone - A touch of warmth'), ('simplex', 'Simplex - Mini and minimalist'), ('sketchy', 'Sketchy - A hand-drawn look for mockups and mirth'), ('slate', 'Slate - Shades of gunmetal gray'), ('solar', 'Solar - A dark spin on Solarized'), ('spacelab', 'Spacelab - Silvery and sleek'), ('superhero', 'Superhero - The brave and the blue'), ('united', 'United - Ubuntu orange and unique font'), ('yeti', 'Yeti - A friendly foundation')], default='', help_text='Change the color palette of your site with a Bootstrap theme. Powered by Bootswatch https://bootswatch.com/.', max_length=50, verbose_name='Theme variant')),
                ('favicon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='favicon', to='wagtailimages.Image', verbose_name='Favicon')),
                ('logo', models.ForeignKey(blank=True, help_text='Brand logo used in the navbar and throughout the site', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Logo')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
            ],
            options={
                'verbose_name': 'Layout',
            },
        ),
        migrations.CreateModel(
            name='Navbar',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('custom_css_class', models.CharField(blank=True, max_length=255, verbose_name='Custom CSS Class')),
                ('custom_id', models.CharField(blank=True, max_length=255, verbose_name='Custom ID')),
                ('menu_items', wagtail.core.fields.StreamField([('page_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Page')), ('sub_links', wagtail.core.blocks.StreamBlock([('page_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Page'))])), ('external_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('link', wagtail.core.blocks.CharBlock(label='URL', required=False))])), ('document_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('document', wagtail.documents.blocks.DocumentChooserBlock(label='Document'))]))], label='Sub-links', required=False)), ('show_child_links', wagtail.core.blocks.BooleanBlock(default=False, help_text='Automatically show a link to the Page’s child pages as a dropdown menu.', label='Show child pages', required=False))])), ('external_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('link', wagtail.core.blocks.CharBlock(label='URL', required=False)), ('sub_links', wagtail.core.blocks.StreamBlock([('page_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Page'))])), ('external_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('link', wagtail.core.blocks.CharBlock(label='URL', required=False))])), ('document_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('document', wagtail.documents.blocks.DocumentChooserBlock(label='Document'))]))], label='Sub-links', required=False))])), ('document_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('document', wagtail.documents.blocks.DocumentChooserBlock(label='Document')), ('sub_links', wagtail.core.blocks.StreamBlock([('page_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Page'))])), ('external_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('link', wagtail.core.blocks.CharBlock(label='URL', required=False))])), ('document_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('display_text', wagtail.core.blocks.CharBlock(label='Display text', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('document', wagtail.documents.blocks.DocumentChooserBlock(label='Document'))]))], label='Sub-links', required=False))]))], verbose_name='Navigation links')),
            ],
            options={
                'verbose_name': 'Navigation Bar',
            },
        ),
        migrations.CreateModel(
            name='SeoSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('og_meta', models.BooleanField(default=True, help_text='Show an optimized preview when linking to this site on Facebook, Linkedin, Twitter, and others. See http://ogp.me/.', verbose_name='Use OpenGraph Markup')),
                ('twitter_meta', models.BooleanField(default=True, help_text='Shows content as a "card" when linking to this site on Twitter. See https://developer.twitter.com/en/docs/tweets/optimize-with-cards/overview/abouts-cards.', verbose_name='Use Twitter Markup')),
                ('struct_meta', models.BooleanField(default=True, help_text='Optimizes information about your organization for search engines. See https://schema.org/.', verbose_name='Use Structured Data')),
                ('amp_pages', models.BooleanField(default=True, help_text='Generates an alternate AMP version of Article pages that are preferred by search engines. See https://www.ampproject.org/', verbose_name='Use AMP Pages')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
            ],
            options={
                'verbose_name': 'SEO',
            },
        ),
        migrations.CreateModel(
            name='SocialMediaSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('facebook', models.URLField(blank=True, help_text='Your Facebook page URL', verbose_name='Facebook')),
                ('twitter', models.URLField(blank=True, help_text='Your Twitter page URL', verbose_name='Twitter')),
                ('instagram', models.CharField(blank=True, help_text='Your Instagram username, without the @', max_length=255, verbose_name='Instagram')),
                ('youtube', models.URLField(blank=True, help_text='Your YouTube channel or user account URL', verbose_name='YouTube')),
                ('linkedin', models.URLField(blank=True, help_text='Your LinkedIn page URL', verbose_name='LinkedIn')),
                ('googleplus', models.URLField(blank=True, help_text='Your Google+ page or Google business listing URL', verbose_name='Google')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
            ],
            options={
                'verbose_name': 'Social Media',
            },
        ),
    ]
