# Generated by Django 2.2.1 on 2019-05-04 15:09

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('wagtailcore', '0041_group_collection_permissions_verbose_name_plural'),
        ('coderedcms', '0014_classifiers'),
    ]

    operations = [
        migrations.CreateModel(
            name='CoderedSubmissionRevision',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('created', 'Created'), ('changed', 'Changed'), ('deleted', 'Deleted')], max_length=7)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('submission_id', models.TextField()),
                ('data', models.TextField()),
                ('summary', models.TextField()),
                ('submission_ct', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
            options={
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoderedSessionFormSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('form_data', models.TextField()),
                ('submit_time', models.DateTimeField(auto_now_add=True, verbose_name='submit time')),
                ('session_key', models.CharField(default=None, max_length=40, null=True)),
                ('thumbnails_by_path', models.TextField(default='{}')),
                ('last_modification', models.DateTimeField(auto_now=True, verbose_name='last modification')),
                ('status', models.CharField(choices=[('incomplete', 'Not submitted'), ('complete', 'Complete'), ('reviewed', 'Under consideration'), ('approved', 'Approved'), ('rejected', 'Rejected')], default='incomplete', max_length=10)),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Page')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'form submission',
                'unique_together': {('page', 'session_key'), ('page', 'user')},
                'abstract': False,
                'verbose_name_plural': 'form submissions',
            },
        ),
    ]
