from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore

class vtkSocket(vtkmodules.vtkCommonCore.vtkObject):
    def CloseSocket(self) -> None: ...
    def GetConnected(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSocketDescriptor(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkSocket: ...
    def Receive(self, data:Pointer, length:int, readFully:int=1) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSocket: ...
    @staticmethod
    def SelectSockets(sockets_to_select:(int, ...), size:int, msec:int, selected_index:[int, ...]) -> int: ...
    def Send(self, data:Pointer, length:int) -> int: ...

class vtkClientSocket(vtkSocket):
    def ConnectToServer(self, hostname:str, port:int) -> int: ...
    def GetConnectingSide(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkClientSocket: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkClientSocket: ...

class vtkDirectory(vtkmodules.vtkCommonCore.vtkObject):
    @staticmethod
    def DeleteDirectory(dir:str) -> int: ...
    def FileIsDirectory(self, name:str) -> int: ...
    @staticmethod
    def GetCurrentWorkingDirectory(buf:str, len:int) -> str: ...
    def GetFile(self, index:int) -> str: ...
    def GetFiles(self) -> vtkStringArray: ...
    def GetNumberOfFiles(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeDirectory(dir:str) -> int: ...
    def NewInstance(self) -> vtkDirectory: ...
    def Open(self, dir:str) -> int: ...
    @staticmethod
    def Rename(oldname:str, newname:str) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDirectory: ...

class vtkExecutableRunner(vtkmodules.vtkCommonCore.vtkObject):
    def Execute(self) -> None: ...
    def GetCommand(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReturnValue(self) -> int: ...
    def GetRightTrimResult(self) -> bool: ...
    def GetStdErr(self) -> str: ...
    def GetStdOut(self) -> str: ...
    def GetTimeout(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExecutableRunner: ...
    def RightTrimResultOff(self) -> None: ...
    def RightTrimResultOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExecutableRunner: ...
    def SetCommand(self, arg:str) -> None: ...
    def SetRightTrimResult(self, _arg:bool) -> None: ...
    def SetTimeout(self, _arg:float) -> None: ...

class vtkServerSocket(vtkSocket):
    def CreateServer(self, port:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetServerPort(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkServerSocket: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkServerSocket: ...
    def WaitForConnection(self, msec:int=0) -> vtkClientSocket: ...

class vtkSocketCollection(vtkmodules.vtkCommonCore.vtkCollection):
    def AddItem(self, soc:vtkSocket) -> None: ...
    def GetLastSelectedSocket(self) -> vtkSocket: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkSocketCollection: ...
    def RemoveAllItems(self) -> None: ...
    @overload
    def RemoveItem(self, i:int) -> None: ...
    @overload
    def RemoveItem(self, __a:vtkObject) -> None: ...
    def ReplaceItem(self, i:int, __b:vtkObject) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSocketCollection: ...
    def SelectSockets(self, msec:int=0) -> int: ...

class vtkThreadMessager(vtkmodules.vtkCommonCore.vtkObject):
    def DisableWaitForReceiver(self) -> None: ...
    def EnableWaitForReceiver(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkThreadMessager: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkThreadMessager: ...
    def SendWakeMessage(self) -> None: ...
    def WaitForMessage(self) -> None: ...
    def WaitForReceiver(self) -> None: ...

class vtkTimerLog(vtkmodules.vtkCommonCore.vtkObject):
    @staticmethod
    def CleanupLog() -> None: ...
    @staticmethod
    def DumpLog(filename:str) -> None: ...
    @staticmethod
    def GetCPUTime() -> float: ...
    def GetElapsedTime(self) -> float: ...
    @staticmethod
    def GetEventIndent(i:int) -> int: ...
    @staticmethod
    def GetEventString(i:int) -> str: ...
    @staticmethod
    def GetEventType(i:int) -> vtkTimerLogEntry.LogEntryType: ...
    @staticmethod
    def GetEventWallTime(i:int) -> float: ...
    @staticmethod
    def GetLogging() -> int: ...
    @staticmethod
    def GetMaxEntries() -> int: ...
    @staticmethod
    def GetNumberOfEvents() -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetUniversalTime() -> float: ...
    @staticmethod
    def InsertTimedEvent(EventString:str, time:float, cpuTicks:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def LoggingOff() -> None: ...
    @staticmethod
    def LoggingOn() -> None: ...
    @staticmethod
    def MarkEndEvent(EventString:str) -> None: ...
    @staticmethod
    def MarkEvent(EventString:str) -> None: ...
    @staticmethod
    def MarkStartEvent(EventString:str) -> None: ...
    def NewInstance(self) -> vtkTimerLog: ...
    @staticmethod
    def ResetLog() -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTimerLog: ...
    @staticmethod
    def SetLogging(v:int) -> None: ...
    @staticmethod
    def SetMaxEntries(a:int) -> None: ...
    def StartTimer(self) -> None: ...
    def StopTimer(self) -> None: ...

class vtkTimerLogCleanup(object):
    def __init__(self) -> None: ...

class vtkTimerLogEntry(object):
    class LogEntryType(int): ...
    END:'LogEntryType'
    INSERTED:'LogEntryType'
    INVALID:'LogEntryType'
    STANDALONE:'LogEntryType'
    START:'LogEntryType'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:vtkTimerLogEntry) -> None: ...

class vtkTimerLogScope(object):
    def __init__(self, eventString:str) -> None: ...

