from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkFiltersCore
import vtkmodules.vtkFiltersExtraction
import vtkmodules.vtkFiltersGeneral
import vtkmodules.vtkFiltersGeometry
import vtkmodules.vtkFiltersHybrid
import vtkmodules.vtkFiltersModeling
import vtkmodules.vtkFiltersSources
import vtkmodules.vtkFiltersTexture

VTK_ITERATION_MODE_DIRECT_NB:int
VTK_ITERATION_MODE_MAX:int
VTK_ROTATION_MODE_ARRAY_VALUE:int
VTK_ROTATION_MODE_DIRECT_ANGLE:int

class vtkAdaptiveTemporalInterpolator(vtkmodules.vtkFiltersHybrid.vtkTemporalInterpolator):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAdaptiveTemporalInterpolator: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAdaptiveTemporalInterpolator: ...

class vtkAggregateDataSetFilter(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def GetMergePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTargetProcesses(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> vtkAggregateDataSetFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAggregateDataSetFilter: ...
    def SetMergePoints(self, _arg:bool) -> None: ...
    def SetNumberOfTargetProcesses(self, __a:int) -> None: ...

class vtkAlignImageDataSetFilter(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetMinimumExtent(self) -> (int, int, int): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAlignImageDataSetFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAlignImageDataSetFilter: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    @overload
    def SetMinimumExtent(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetMinimumExtent(self, _arg:(int, int, int)) -> None: ...

class vtkPeriodicFilter(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def AddIndex(self, index:int) -> None: ...
    def GetIterationMode(self) -> int: ...
    def GetIterationModeMaxValue(self) -> int: ...
    def GetIterationModeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPeriods(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPeriodicFilter: ...
    def RemoveAllIndices(self) -> None: ...
    def RemoveIndex(self, index:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPeriodicFilter: ...
    def SetIterationMode(self, _arg:int) -> None: ...
    def SetIterationModeToDirectNb(self) -> None: ...
    def SetIterationModeToMax(self) -> None: ...
    def SetNumberOfPeriods(self, _arg:int) -> None: ...

class vtkAngularPeriodicFilter(vtkPeriodicFilter):
    def ComputeRotationsOnTheFlyOff(self) -> None: ...
    def ComputeRotationsOnTheFlyOn(self) -> None: ...
    def GetCenter(self) -> (float, float, float): ...
    def GetComputeRotationsOnTheFly(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRotationAngle(self) -> float: ...
    def GetRotationArrayName(self) -> str: ...
    def GetRotationAxis(self) -> int: ...
    def GetRotationAxisMaxValue(self) -> int: ...
    def GetRotationAxisMinValue(self) -> int: ...
    def GetRotationMode(self) -> int: ...
    def GetRotationModeMaxValue(self) -> int: ...
    def GetRotationModeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAngularPeriodicFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAngularPeriodicFilter: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetComputeRotationsOnTheFly(self, _arg:bool) -> None: ...
    def SetRotationAngle(self, _arg:float) -> None: ...
    def SetRotationArrayName(self, _arg:str) -> None: ...
    def SetRotationAxis(self, _arg:int) -> None: ...
    def SetRotationAxisToX(self) -> None: ...
    def SetRotationAxisToY(self) -> None: ...
    def SetRotationAxisToZ(self) -> None: ...
    def SetRotationMode(self, _arg:int) -> None: ...
    def SetRotationModeToArrayValue(self) -> None: ...
    def SetRotationModeToDirectAngle(self) -> None: ...

class vtkBlockDistribution(object):
    @overload
    def __init__(self, N:int, P:int) -> None: ...
    @overload
    def __init__(self, __a:vtkBlockDistribution) -> None: ...
    def GetBlockSize(self, rank:int) -> int: ...
    def GetFirstGlobalIndexOnProcessor(self, rank:int) -> int: ...
    def GetGlobalIndex(self, localIndex:int, rank:int) -> int: ...
    def GetLocalIndexOfElement(self, globalIndex:int) -> int: ...
    def GetNumElements(self) -> int: ...
    def GetNumProcessors(self) -> int: ...
    def GetProcessorOfElement(self, globalIndex:int) -> int: ...

class vtkCollectGraph(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    DIRECTED_OUTPUT:int
    UNDIRECTED_OUTPUT:int
    USE_INPUT_TYPE:int
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputType(self) -> int: ...
    def GetPassThrough(self) -> int: ...
    def GetSocketController(self) -> vtkSocketController: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCollectGraph: ...
    def PassThroughOff(self) -> None: ...
    def PassThroughOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCollectGraph: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetOutputType(self, _arg:int) -> None: ...
    def SetPassThrough(self, _arg:int) -> None: ...
    def SetSocketController(self, __a:vtkSocketController) -> None: ...

class vtkCollectPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassThrough(self) -> int: ...
    def GetSocketController(self) -> vtkSocketController: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCollectPolyData: ...
    def PassThroughOff(self) -> None: ...
    def PassThroughOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCollectPolyData: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetPassThrough(self, _arg:int) -> None: ...
    def SetSocketController(self, __a:vtkSocketController) -> None: ...

class vtkCollectTable(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassThrough(self) -> int: ...
    def GetSocketController(self) -> vtkSocketController: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCollectTable: ...
    def PassThroughOff(self) -> None: ...
    def PassThroughOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCollectTable: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetPassThrough(self, _arg:int) -> None: ...
    def SetSocketController(self, __a:vtkSocketController) -> None: ...

class vtkCutMaterial(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetArrayName(self) -> str: ...
    def GetCenterPoint(self) -> (float, float, float): ...
    def GetMaterial(self) -> int: ...
    def GetMaterialArrayName(self) -> str: ...
    def GetMaximumPoint(self) -> (float, float, float): ...
    def GetNormal(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUpVector(self) -> (float, float, float): ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCutMaterial: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCutMaterial: ...
    def SetArrayName(self, _arg:str) -> None: ...
    def SetMaterial(self, _arg:int) -> None: ...
    def SetMaterialArrayName(self, _arg:str) -> None: ...
    @overload
    def SetUpVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetUpVector(self, _arg:(float, float, float)) -> None: ...

class vtkDistributedDataFilter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    class BoundaryModes(int): ...
    ASSIGN_TO_ALL_INTERSECTING_REGIONS:'BoundaryModes'
    ASSIGN_TO_ONE_REGION:'BoundaryModes'
    SPLIT_BOUNDARY_CELLS:'BoundaryModes'
    def ClipCellsOff(self) -> None: ...
    def ClipCellsOn(self) -> None: ...
    def GetBoundaryMode(self) -> int: ...
    def GetClipCells(self) -> int: ...
    def GetController(self) -> vtkMultiProcessController: ...
    def GetCuts(self) -> vtkBSPCuts: ...
    def GetIncludeAllIntersectingCells(self) -> int: ...
    def GetKdtree(self) -> vtkPKdTree: ...
    def GetMinimumGhostLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRetainKdtree(self) -> int: ...
    def GetTiming(self) -> int: ...
    def GetUseMinimalMemory(self) -> int: ...
    def IncludeAllIntersectingCellsOff(self) -> None: ...
    def IncludeAllIntersectingCellsOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDistributedDataFilter: ...
    def RetainKdtreeOff(self) -> None: ...
    def RetainKdtreeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDistributedDataFilter: ...
    def SetBoundaryMode(self, mode:int) -> None: ...
    def SetBoundaryModeToAssignToAllIntersectingRegions(self) -> None: ...
    def SetBoundaryModeToAssignToOneRegion(self) -> None: ...
    def SetBoundaryModeToSplitBoundaryCells(self) -> None: ...
    def SetClipCells(self, _arg:int) -> None: ...
    def SetController(self, c:vtkMultiProcessController) -> None: ...
    def SetCuts(self, cuts:vtkBSPCuts) -> None: ...
    def SetIncludeAllIntersectingCells(self, _arg:int) -> None: ...
    def SetMinimumGhostLevel(self, _arg:int) -> None: ...
    def SetRetainKdtree(self, _arg:int) -> None: ...
    def SetTiming(self, _arg:int) -> None: ...
    def SetUseMinimalMemory(self, _arg:int) -> None: ...
    def SetUserRegionAssignments(self, map:(int, ...), numRegions:int) -> None: ...
    def TimingOff(self) -> None: ...
    def TimingOn(self) -> None: ...
    def UseMinimalMemoryOff(self) -> None: ...
    def UseMinimalMemoryOn(self) -> None: ...

class vtkDuplicatePolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetClientFlag(self) -> int: ...
    def GetController(self) -> vtkMultiProcessController: ...
    def GetMemorySize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSocketController(self) -> vtkSocketController: ...
    def GetSynchronous(self) -> int: ...
    def InitializeSchedule(self, numProcs:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDuplicatePolyData: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDuplicatePolyData: ...
    def SetClientFlag(self, _arg:int) -> None: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetSocketController(self, controller:vtkSocketController) -> None: ...
    def SetSynchronous(self, _arg:int) -> None: ...
    def SynchronousOff(self) -> None: ...
    def SynchronousOn(self) -> None: ...

class vtkExtractCTHPart(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def AddVolumeArrayName(self, __a:str) -> None: ...
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def GenerateSolidGeometryOff(self) -> None: ...
    def GenerateSolidGeometryOn(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    def GetCapping(self) -> bool: ...
    def GetClipPlane(self) -> vtkPlane: ...
    def GetController(self) -> vtkMultiProcessController: ...
    def GetGenerateSolidGeometry(self) -> bool: ...
    def GetGenerateTriangles(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfVolumeArrayNames(self) -> int: ...
    def GetRemoveGhostCells(self) -> bool: ...
    def GetVolumeArrayName(self, idx:int) -> str: ...
    def GetVolumeFractionSurfaceValue(self) -> float: ...
    def GetVolumeFractionSurfaceValueMaxValue(self) -> float: ...
    def GetVolumeFractionSurfaceValueMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractCTHPart: ...
    def RemoveGhostCellsOff(self) -> None: ...
    def RemoveGhostCellsOn(self) -> None: ...
    def RemoveVolumeArrayNames(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractCTHPart: ...
    def SetCapping(self, _arg:bool) -> None: ...
    def SetClipPlane(self, clipPlane:vtkPlane) -> None: ...
    def SetController(self, controller:vtkMultiProcessController) -> None: ...
    def SetGenerateSolidGeometry(self, _arg:bool) -> None: ...
    def SetGenerateTriangles(self, _arg:bool) -> None: ...
    def SetRemoveGhostCells(self, _arg:bool) -> None: ...
    def SetVolumeFractionSurfaceValue(self, _arg:float) -> None: ...

class vtkExtractPolyDataPiece(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CreateGhostCellsOff(self) -> None: ...
    def CreateGhostCellsOn(self) -> None: ...
    def GetCreateGhostCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractPolyDataPiece: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractPolyDataPiece: ...
    def SetCreateGhostCells(self, _arg:int) -> None: ...

class vtkExtractUnstructuredGridPiece(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def CreateGhostCellsOff(self) -> None: ...
    def CreateGhostCellsOn(self) -> None: ...
    def GetCreateGhostCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractUnstructuredGridPiece: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractUnstructuredGridPiece: ...
    def SetCreateGhostCells(self, _arg:int) -> None: ...

class vtkExtractUserDefinedPiece(vtkExtractUnstructuredGridPiece):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractUserDefinedPiece: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractUserDefinedPiece: ...
    def SetConstantData(self, data:Pointer, len:int) -> None: ...

class vtkHyperTreeGridGhostCellsGenerator(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHyperTreeGridGhostCellsGenerator: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHyperTreeGridGhostCellsGenerator: ...

class vtkIntegrateAttributes(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    class CommunicationIds(int): ...
    IntegrateAttrData:'CommunicationIds'
    IntegrateAttrInfo:'CommunicationIds'
    def GetController(self) -> vtkMultiProcessController: ...
    def GetDivideAllCellDataByVolume(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkIntegrateAttributes: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkIntegrateAttributes: ...
    def SetController(self, controller:vtkMultiProcessController) -> None: ...
    def SetDivideAllCellDataByVolume(self, _arg:bool) -> None: ...

class vtkPCellDataToPointData(vtkmodules.vtkFiltersCore.vtkCellDataToPointData):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPieceInvariant(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPCellDataToPointData: ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPCellDataToPointData: ...
    def SetPieceInvariant(self, _arg:int) -> None: ...

class vtkPConvertToMultiBlockDataSet(vtkmodules.vtkFiltersCore.vtkConvertToMultiBlockDataSet):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPConvertToMultiBlockDataSet: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPConvertToMultiBlockDataSet: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...

class vtkPExtractDataArraysOverTime(vtkmodules.vtkFiltersExtraction.vtkExtractDataArraysOverTime):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPExtractDataArraysOverTime: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPExtractDataArraysOverTime: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...

class vtkPExtractExodusGlobalTemporalVariables(vtkmodules.vtkFiltersExtraction.vtkExtractExodusGlobalTemporalVariables):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPExtractExodusGlobalTemporalVariables: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPExtractExodusGlobalTemporalVariables: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...

class vtkPExtractSelectedArraysOverTime(vtkmodules.vtkFiltersExtraction.vtkExtractSelectedArraysOverTime):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPExtractSelectedArraysOverTime: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPExtractSelectedArraysOverTime: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...

class vtkPKdTree(vtkmodules.vtkCommonDataModel.vtkKdTree):
    def AssignRegions(self, map:[int, ...], numRegions:int) -> int: ...
    def AssignRegionsContiguous(self) -> int: ...
    def AssignRegionsRoundRobin(self) -> int: ...
    def BuildLocator(self) -> None: ...
    def CreateGlobalDataArrayBounds(self) -> int: ...
    def CreateProcessCellCountData(self) -> int: ...
    def GetAllProcessesBorderingOnPoint(self, x:float, y:float, z:float, list:vtkIntArray) -> None: ...
    @overload
    def GetCellArrayGlobalRange(self, name:str, range:[float, float]) -> int: ...
    @overload
    def GetCellArrayGlobalRange(self, arrayIndex:int, range:[float, float]) -> int: ...
    @overload
    def GetCellListsForProcessRegions(self, ProcessId:int, set:int, inRegionCells:vtkIdList, onBoundaryCells:vtkIdList) -> int: ...
    @overload
    def GetCellListsForProcessRegions(self, ProcessId:int, set:vtkDataSet, inRegionCells:vtkIdList, onBoundaryCells:vtkIdList) -> int: ...
    @overload
    def GetCellListsForProcessRegions(self, ProcessId:int, inRegionCells:vtkIdList, onBoundaryCells:vtkIdList) -> int: ...
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetPointArrayGlobalRange(self, name:str, range:[float, float]) -> int: ...
    @overload
    def GetPointArrayGlobalRange(self, arrayIndex:int, range:[float, float]) -> int: ...
    def GetProcessAssignedToRegion(self, regionId:int) -> int: ...
    def GetProcessCellCountForRegion(self, processId:int, regionId:int) -> int: ...
    def GetProcessListForRegion(self, regionId:int, processes:vtkIntArray) -> int: ...
    def GetProcessesCellCountForRegion(self, regionId:int, count:[int, ...], len:int) -> int: ...
    def GetRegionAssignment(self) -> int: ...
    def GetRegionAssignmentList(self, procId:int, list:vtkIntArray) -> int: ...
    def GetRegionAssignmentMap(self) -> Pointer: ...
    def GetRegionAssignmentMapLength(self) -> int: ...
    def GetRegionListForProcess(self, processId:int, regions:vtkIntArray) -> int: ...
    def GetRegionsCellCountForProcess(self, ProcessId:int, count:[int, ...], len:int) -> int: ...
    def GetTotalNumberOfCells(self) -> int: ...
    def GetTotalProcessesInRegion(self, regionId:int) -> int: ...
    def GetTotalRegionsForProcess(self, processId:int) -> int: ...
    def HasData(self, processId:int, regionId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPKdTree: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPKdTree: ...
    def SetController(self, c:vtkMultiProcessController) -> None: ...
    def ViewOrderAllProcessesFromPosition(self, cameraPosition:(float, float, float), orderedList:vtkIntArray) -> int: ...
    def ViewOrderAllProcessesInDirection(self, directionOfProjection:(float, float, float), orderedList:vtkIntArray) -> int: ...

class vtkPLinearExtrusionFilter(vtkmodules.vtkFiltersModeling.vtkLinearExtrusionFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPieceInvariant(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPLinearExtrusionFilter: ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPLinearExtrusionFilter: ...
    def SetPieceInvariant(self, _arg:int) -> None: ...

class vtkPMaskPoints(vtkmodules.vtkFiltersCore.vtkMaskPoints):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPMaskPoints: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPMaskPoints: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...

class vtkPMergeArrays(vtkmodules.vtkFiltersGeneral.vtkMergeArrays):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPMergeArrays: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPMergeArrays: ...

class vtkPOutlineCornerFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetCornerFactor(self) -> float: ...
    def GetCornerFactorMaxValue(self) -> float: ...
    def GetCornerFactorMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPOutlineCornerFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPOutlineCornerFilter: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetCornerFactor(self, cornerFactor:float) -> None: ...

class vtkPOutlineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPOutlineFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPOutlineFilter: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...

class vtkPOutlineFilterInternals(object):
    def __init__(self) -> None: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetCornerFactor(self, cornerFactor:float) -> None: ...
    def SetIsCornerSource(self, value:bool) -> None: ...

class vtkPPolyDataNormals(vtkmodules.vtkFiltersCore.vtkPolyDataNormals):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPieceInvariant(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPPolyDataNormals: ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPPolyDataNormals: ...
    def SetPieceInvariant(self, _arg:int) -> None: ...

class vtkPProbeFilter(vtkmodules.vtkFiltersCore.vtkCompositeDataProbeFilter):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPProbeFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPProbeFilter: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...

class vtkPProjectSphereFilter(vtkmodules.vtkFiltersGeometry.vtkProjectSphereFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPProjectSphereFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPProjectSphereFilter: ...

class vtkPReflectionFilter(vtkmodules.vtkFiltersGeneral.vtkReflectionFilter):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPReflectionFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPReflectionFilter: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...

class vtkPResampleFilter(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetCustomSamplingBounds(self) -> (float, float, float, float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSamplingDimension(self) -> (int, int, int): ...
    def GetUseInputBounds(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPResampleFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPResampleFilter: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    @overload
    def SetCustomSamplingBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetCustomSamplingBounds(self, _arg:(float, float, float, float, float, float)) -> None: ...
    @overload
    def SetSamplingDimension(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetSamplingDimension(self, _arg:(int, int, int)) -> None: ...
    def SetUseInputBounds(self, _arg:int) -> None: ...
    def UseInputBoundsOff(self) -> None: ...
    def UseInputBoundsOn(self) -> None: ...

class vtkPSphereSource(vtkmodules.vtkFiltersSources.vtkSphereSource):
    def GetEstimatedMemorySize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPSphereSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPSphereSource: ...

class vtkPTextureMapToSphere(vtkmodules.vtkFiltersTexture.vtkTextureMapToSphere):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPTextureMapToSphere: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPTextureMapToSphere: ...

class vtkPYoungsMaterialInterface(vtkmodules.vtkFiltersGeneral.vtkYoungsMaterialInterface):
    def Aggregate(self, __a:int, __b:[int, ...]) -> None: ...
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPYoungsMaterialInterface: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPYoungsMaterialInterface: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...

class vtkPartitionBalancer(vtkmodules.vtkCommonExecutionModel.vtkPartitionedDataSetAlgorithm):
    class Mode(int): ...
    Expand:'Mode'
    Squash:'Mode'
    def GetController(self) -> vtkMultiProcessController: ...
    def GetMode(self) -> int: ...
    def GetModeMaxValue(self) -> int: ...
    def GetModeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPartitionBalancer: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPartitionBalancer: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetMode(self, _arg:int) -> None: ...
    def SetModeToExpand(self) -> None: ...
    def SetModeToSquash(self) -> None: ...

class vtkPassThroughFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPassThroughFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPassThroughFilter: ...

class vtkPieceRequestFilter(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetNumberOfPiecesMaxValue(self) -> int: ...
    def GetNumberOfPiecesMinValue(self) -> int: ...
    @overload
    def GetOutput(self) -> vtkDataObject: ...
    @overload
    def GetOutput(self, __a:int) -> vtkDataObject: ...
    def GetPiece(self) -> int: ...
    def GetPieceMaxValue(self) -> int: ...
    def GetPieceMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPieceRequestFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPieceRequestFilter: ...
    @overload
    def SetInputData(self, __a:vtkDataObject) -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:vtkDataObject) -> None: ...
    def SetNumberOfPieces(self, _arg:int) -> None: ...
    def SetPiece(self, _arg:int) -> None: ...

class vtkPieceScalars(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomMode(self) -> int: ...
    def GetScalarMode(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPieceScalars: ...
    def RandomModeOff(self) -> None: ...
    def RandomModeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPieceScalars: ...
    def SetRandomMode(self, _arg:int) -> None: ...
    def SetScalarModeToCellData(self) -> None: ...
    def SetScalarModeToPointData(self) -> None: ...

class vtkPipelineSize(vtkmodules.vtkCommonCore.vtkObject):
    def GetEstimatedSize(self, input:vtkAlgorithm, inputPort:int, connection:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSubPieces(self, memoryLimit:int, mapper:vtkAlgorithm, piece:int, numPieces:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPipelineSize: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPipelineSize: ...

class vtkProcessIdScalars(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomMode(self) -> int: ...
    def GetScalarMode(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkProcessIdScalars: ...
    def RandomModeOff(self) -> None: ...
    def RandomModeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkProcessIdScalars: ...
    def SetCellScalarsFlag(self, _arg:int) -> None: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetRandomMode(self, _arg:int) -> None: ...
    def SetScalarModeToCellData(self) -> None: ...
    def SetScalarModeToPointData(self) -> None: ...

class vtkRectilinearGridOutlineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRectilinearGridOutlineFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRectilinearGridOutlineFilter: ...

class vtkRemoveGhosts(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRemoveGhosts: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRemoveGhosts: ...

class vtkTransmitPolyDataPiece(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CreateGhostCellsOff(self) -> None: ...
    def CreateGhostCellsOn(self) -> None: ...
    def GetController(self) -> vtkMultiProcessController: ...
    def GetCreateGhostCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTransmitPolyDataPiece: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTransmitPolyDataPiece: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetCreateGhostCells(self, _arg:int) -> None: ...

class vtkTransmitStructuredDataPiece(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def CreateGhostCellsOff(self) -> None: ...
    def CreateGhostCellsOn(self) -> None: ...
    def GetController(self) -> vtkMultiProcessController: ...
    def GetCreateGhostCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTransmitStructuredDataPiece: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTransmitStructuredDataPiece: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetCreateGhostCells(self, _arg:int) -> None: ...

class vtkTransmitRectilinearGridPiece(vtkTransmitStructuredDataPiece):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTransmitRectilinearGridPiece: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTransmitRectilinearGridPiece: ...

class vtkTransmitStructuredGridPiece(vtkTransmitStructuredDataPiece):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTransmitStructuredGridPiece: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTransmitStructuredGridPiece: ...

class vtkTransmitUnstructuredGridPiece(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def CreateGhostCellsOff(self) -> None: ...
    def CreateGhostCellsOn(self) -> None: ...
    def GetController(self) -> vtkMultiProcessController: ...
    def GetCreateGhostCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTransmitUnstructuredGridPiece: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTransmitUnstructuredGridPiece: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetCreateGhostCells(self, _arg:int) -> None: ...

class vtkUnstructuredGridGhostCellsGenerator(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def BuildIfRequiredOff(self) -> None: ...
    def BuildIfRequiredOn(self) -> None: ...
    def GetBuildIfRequired(self) -> bool: ...
    def GetGlobalCellIdsArrayName(self) -> str: ...
    def GetGlobalPointIdsArrayName(self) -> str: ...
    def GetHasGlobalCellIds(self) -> bool: ...
    def GetMinimumNumberOfGhostLevels(self) -> int: ...
    def GetMinimumNumberOfGhostLevelsMaxValue(self) -> int: ...
    def GetMinimumNumberOfGhostLevelsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseGlobalPointIds(self) -> bool: ...
    def HasGlobalCellIdsOff(self) -> None: ...
    def HasGlobalCellIdsOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkUnstructuredGridGhostCellsGenerator: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkUnstructuredGridGhostCellsGenerator: ...
    def SetBuildIfRequired(self, _arg:bool) -> None: ...
    def SetGlobalCellIdsArrayName(self, _arg:str) -> None: ...
    def SetGlobalPointIdsArrayName(self, _arg:str) -> None: ...
    def SetHasGlobalCellIds(self, _arg:bool) -> None: ...
    def SetMinimumNumberOfGhostLevels(self, _arg:int) -> None: ...
    def SetUseGlobalPointIds(self, _arg:bool) -> None: ...
    def UseGlobalPointIdsOff(self) -> None: ...
    def UseGlobalPointIdsOn(self) -> None: ...

