from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

VTK_ARROW_GLYPH:int
VTK_BOX_TYPE_AXIS_ALIGNED:int
VTK_BOX_TYPE_ORIENTED:int
VTK_CIRCLE_GLYPH:int
VTK_CROSS_GLYPH:int
VTK_DASH_GLYPH:int
VTK_DIAMOND_GLYPH:int
VTK_EDGEARROW_GLYPH:int
VTK_HOOKEDARROW_GLYPH:int
VTK_MAX_CIRCLE_RESOLUTION:int
VTK_MAX_SUPERQUADRIC_RESOLUTION:int
VTK_MIN_SUPERQUADRIC_ROUNDNESS:float
VTK_MIN_SUPERQUADRIC_THICKNESS:float
VTK_NO_GLYPH:int
VTK_POINT_EXPONENTIAL:int
VTK_POINT_SHELL:int
VTK_POINT_UNIFORM:int
VTK_SOLID_CUBE:int
VTK_SOLID_DODECAHEDRON:int
VTK_SOLID_ICOSAHEDRON:int
VTK_SOLID_OCTAHEDRON:int
VTK_SOLID_TETRAHEDRON:int
VTK_SQUARE_GLYPH:int
VTK_TEXTURE_STYLE_FIT_IMAGE:int
VTK_TEXTURE_STYLE_PROPORTIONAL:int
VTK_THICKARROW_GLYPH:int
VTK_THICKCROSS_GLYPH:int
VTK_TRIANGLE_GLYPH:int
VTK_VERTEX_GLYPH:int

class vtkArcSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetAngle(self) -> float: ...
    def GetAngleMaxValue(self) -> float: ...
    def GetAngleMinValue(self) -> float: ...
    def GetCenter(self) -> (float, float, float): ...
    def GetNegative(self) -> bool: ...
    def GetNormal(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPoint1(self) -> (float, float, float): ...
    def GetPoint2(self) -> (float, float, float): ...
    def GetPolarVector(self) -> (float, float, float): ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetUseNormalAndAngle(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NegativeOff(self) -> None: ...
    def NegativeOn(self) -> None: ...
    def NewInstance(self) -> vtkArcSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkArcSource: ...
    def SetAngle(self, _arg:float) -> None: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetNegative(self, _arg:bool) -> None: ...
    @overload
    def SetNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNormal(self, _arg:(float, float, float)) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    @overload
    def SetPoint1(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPoint1(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetPoint2(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPoint2(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetPolarVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPolarVector(self, _arg:(float, float, float)) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    def SetUseNormalAndAngle(self, _arg:bool) -> None: ...
    def UseNormalAndAngleOff(self) -> None: ...
    def UseNormalAndAngleOn(self) -> None: ...

class vtkArrowSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class ArrowOrigins(int):
        Center:'ArrowOrigins'
        Default:'ArrowOrigins'
    def GetArrowOrigin(self) -> ArrowOrigins: ...
    def GetArrowOriginAsString(self) -> str: ...
    def GetInvert(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShaftRadius(self) -> float: ...
    def GetShaftRadiusMaxValue(self) -> float: ...
    def GetShaftRadiusMinValue(self) -> float: ...
    def GetShaftResolution(self) -> int: ...
    def GetShaftResolutionMaxValue(self) -> int: ...
    def GetShaftResolutionMinValue(self) -> int: ...
    def GetTipLength(self) -> float: ...
    def GetTipLengthMaxValue(self) -> float: ...
    def GetTipLengthMinValue(self) -> float: ...
    def GetTipRadius(self) -> float: ...
    def GetTipRadiusMaxValue(self) -> float: ...
    def GetTipRadiusMinValue(self) -> float: ...
    def GetTipResolution(self) -> int: ...
    def GetTipResolutionMaxValue(self) -> int: ...
    def GetTipResolutionMinValue(self) -> int: ...
    def InvertOff(self) -> None: ...
    def InvertOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkArrowSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkArrowSource: ...
    def SetArrowOrigin(self, _arg:ArrowOrigins) -> None: ...
    def SetArrowOriginToCenter(self) -> None: ...
    def SetArrowOriginToDefault(self) -> None: ...
    def SetInvert(self, _arg:bool) -> None: ...
    def SetShaftRadius(self, _arg:float) -> None: ...
    def SetShaftResolution(self, _arg:int) -> None: ...
    def SetTipLength(self, _arg:float) -> None: ...
    def SetTipRadius(self, _arg:float) -> None: ...
    def SetTipResolution(self, _arg:int) -> None: ...

class vtkButtonSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetCenter(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShoulderTextureCoordinate(self) -> (float, float): ...
    def GetTextureDimensions(self) -> (int, int): ...
    def GetTextureStyle(self) -> int: ...
    def GetTextureStyleMaxValue(self) -> int: ...
    def GetTextureStyleMinValue(self) -> int: ...
    def GetTwoSided(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkButtonSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkButtonSource: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetShoulderTextureCoordinate(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetShoulderTextureCoordinate(self, _arg:(float, float)) -> None: ...
    @overload
    def SetTextureDimensions(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetTextureDimensions(self, _arg:(int, int)) -> None: ...
    def SetTextureStyle(self, _arg:int) -> None: ...
    def SetTextureStyleToFitImage(self) -> None: ...
    def SetTextureStyleToProportional(self) -> None: ...
    def SetTwoSided(self, _arg:int) -> None: ...
    def TwoSidedOff(self) -> None: ...
    def TwoSidedOn(self) -> None: ...

class vtkCapsuleSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetCenter(self) -> (float, float, float): ...
    def GetCylinderLength(self) -> float: ...
    def GetCylinderLengthMaxValue(self) -> float: ...
    def GetCylinderLengthMinValue(self) -> float: ...
    def GetLatLongTessellation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPhiResolution(self) -> int: ...
    def GetPhiResolutionMaxValue(self) -> int: ...
    def GetPhiResolutionMinValue(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetThetaResolution(self) -> int: ...
    def GetThetaResolutionMaxValue(self) -> int: ...
    def GetThetaResolutionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LatLongTessellationOff(self) -> None: ...
    def LatLongTessellationOn(self) -> None: ...
    def NewInstance(self) -> vtkCapsuleSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCapsuleSource: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetCylinderLength(self, _arg:float) -> None: ...
    def SetLatLongTessellation(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPhiResolution(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetThetaResolution(self, _arg:int) -> None: ...

class vtkCellTypeSource(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def CompleteQuadraticSimplicialElementsOff(self) -> None: ...
    def CompleteQuadraticSimplicialElementsOn(self) -> None: ...
    def GetBlocksDimensions(self) -> (int, int, int): ...
    def GetCellDimension(self) -> int: ...
    def GetCellOrder(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetCompleteQuadraticSimplicialElements(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPrecision(self) -> int: ...
    def GetOutputPrecisionMaxValue(self) -> int: ...
    def GetOutputPrecisionMinValue(self) -> int: ...
    def GetPolynomialFieldOrder(self) -> int: ...
    def GetPolynomialFieldOrderMaxValue(self) -> int: ...
    def GetPolynomialFieldOrderMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCellTypeSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCellTypeSource: ...
    @overload
    def SetBlocksDimensions(self, __a:[int, ...]) -> None: ...
    @overload
    def SetBlocksDimensions(self, __a:int, __b:int, __c:int) -> None: ...
    def SetCellOrder(self, _arg:int) -> None: ...
    def SetCellType(self, cellType:int) -> None: ...
    def SetCompleteQuadraticSimplicialElements(self, _arg:bool) -> None: ...
    def SetOutputPrecision(self, _arg:int) -> None: ...
    def SetPolynomialFieldOrder(self, _arg:int) -> None: ...

class vtkConeSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def GetAngle(self) -> float: ...
    def GetCapping(self) -> int: ...
    def GetCenter(self) -> (float, float, float): ...
    def GetDirection(self) -> (float, float, float): ...
    def GetHeight(self) -> float: ...
    def GetHeightMaxValue(self) -> float: ...
    def GetHeightMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkConeSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkConeSource: ...
    def SetAngle(self, angle:float) -> None: ...
    def SetCapping(self, _arg:int) -> None: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetDirection(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDirection(self, _arg:(float, float, float)) -> None: ...
    def SetHeight(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...

class vtkCubeSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetCenter(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetXLength(self) -> float: ...
    def GetXLengthMaxValue(self) -> float: ...
    def GetXLengthMinValue(self) -> float: ...
    def GetYLength(self) -> float: ...
    def GetYLengthMaxValue(self) -> float: ...
    def GetYLengthMinValue(self) -> float: ...
    def GetZLength(self) -> float: ...
    def GetZLengthMaxValue(self) -> float: ...
    def GetZLengthMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCubeSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCubeSource: ...
    @overload
    def SetBounds(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    @overload
    def SetBounds(self, bounds:(float, float, float, float, float, float)) -> None: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetXLength(self, _arg:float) -> None: ...
    def SetYLength(self, _arg:float) -> None: ...
    def SetZLength(self, _arg:float) -> None: ...

class vtkCylinderSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def GetCapping(self) -> int: ...
    def GetCenter(self) -> (float, float, float): ...
    def GetHeight(self) -> float: ...
    def GetHeightMaxValue(self) -> float: ...
    def GetHeightMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCylinderSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCylinderSource: ...
    def SetCapping(self, _arg:int) -> None: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetHeight(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...

class vtkDiagonalMatrixSource(vtkmodules.vtkCommonExecutionModel.vtkArrayDataAlgorithm):
    class StorageType(int): ...
    DENSE:'StorageType'
    SPARSE:'StorageType'
    def GetArrayType(self) -> int: ...
    def GetColumnLabel(self) -> str: ...
    def GetDiagonal(self) -> float: ...
    def GetExtents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRowLabel(self) -> str: ...
    def GetSubDiagonal(self) -> float: ...
    def GetSuperDiagonal(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDiagonalMatrixSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDiagonalMatrixSource: ...
    def SetArrayType(self, _arg:int) -> None: ...
    def SetColumnLabel(self, _arg:str) -> None: ...
    def SetDiagonal(self, _arg:float) -> None: ...
    def SetExtents(self, _arg:int) -> None: ...
    def SetRowLabel(self, _arg:str) -> None: ...
    def SetSubDiagonal(self, _arg:float) -> None: ...
    def SetSuperDiagonal(self, _arg:float) -> None: ...

class vtkDiskSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetCenter(self) -> (float, float, float): ...
    def GetCircumferentialResolution(self) -> int: ...
    def GetCircumferentialResolutionMaxValue(self) -> int: ...
    def GetCircumferentialResolutionMinValue(self) -> int: ...
    def GetInnerRadius(self) -> float: ...
    def GetInnerRadiusMaxValue(self) -> float: ...
    def GetInnerRadiusMinValue(self) -> float: ...
    def GetNormal(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOuterRadius(self) -> float: ...
    def GetOuterRadiusMaxValue(self) -> float: ...
    def GetOuterRadiusMinValue(self) -> float: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRadialResolution(self) -> int: ...
    def GetRadialResolutionMaxValue(self) -> int: ...
    def GetRadialResolutionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDiskSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDiskSource: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetCircumferentialResolution(self, _arg:int) -> None: ...
    def SetInnerRadius(self, _arg:float) -> None: ...
    @overload
    def SetNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNormal(self, _arg:(float, float, float)) -> None: ...
    def SetOuterRadius(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRadialResolution(self, _arg:int) -> None: ...

class vtkEllipseArcSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CloseOff(self) -> None: ...
    def CloseOn(self) -> None: ...
    def GetCenter(self) -> (float, float, float): ...
    def GetClose(self) -> bool: ...
    def GetMajorRadiusVector(self) -> (float, float, float): ...
    def GetNormal(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRatio(self) -> float: ...
    def GetRatioMaxValue(self) -> float: ...
    def GetRatioMinValue(self) -> float: ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetSegmentAngle(self) -> float: ...
    def GetSegmentAngleMaxValue(self) -> float: ...
    def GetSegmentAngleMinValue(self) -> float: ...
    def GetStartAngle(self) -> float: ...
    def GetStartAngleMaxValue(self) -> float: ...
    def GetStartAngleMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkEllipseArcSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkEllipseArcSource: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetClose(self, _arg:bool) -> None: ...
    @overload
    def SetMajorRadiusVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetMajorRadiusVector(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNormal(self, _arg:(float, float, float)) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRatio(self, _arg:float) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    def SetSegmentAngle(self, _arg:float) -> None: ...
    def SetStartAngle(self, _arg:float) -> None: ...

class vtkEllipticalButtonSource(vtkButtonSource):
    def GetCircumferentialResolution(self) -> int: ...
    def GetCircumferentialResolutionMaxValue(self) -> int: ...
    def GetCircumferentialResolutionMinValue(self) -> int: ...
    def GetDepth(self) -> float: ...
    def GetDepthMaxValue(self) -> float: ...
    def GetDepthMinValue(self) -> float: ...
    def GetHeight(self) -> float: ...
    def GetHeightMaxValue(self) -> float: ...
    def GetHeightMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRadialRatio(self) -> float: ...
    def GetRadialRatioMaxValue(self) -> float: ...
    def GetRadialRatioMinValue(self) -> float: ...
    def GetShoulderResolution(self) -> int: ...
    def GetShoulderResolutionMaxValue(self) -> int: ...
    def GetShoulderResolutionMinValue(self) -> int: ...
    def GetTextureResolution(self) -> int: ...
    def GetTextureResolutionMaxValue(self) -> int: ...
    def GetTextureResolutionMinValue(self) -> int: ...
    def GetWidth(self) -> float: ...
    def GetWidthMaxValue(self) -> float: ...
    def GetWidthMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkEllipticalButtonSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkEllipticalButtonSource: ...
    def SetCircumferentialResolution(self, _arg:int) -> None: ...
    def SetDepth(self, _arg:float) -> None: ...
    def SetHeight(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRadialRatio(self, _arg:float) -> None: ...
    def SetShoulderResolution(self, _arg:int) -> None: ...
    def SetTextureResolution(self, _arg:int) -> None: ...
    def SetWidth(self, _arg:float) -> None: ...

class vtkFrustumSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetLinesLength(self) -> float: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPlanes(self) -> vtkPlanes: ...
    def GetShowLines(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkFrustumSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkFrustumSource: ...
    def SetLinesLength(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPlanes(self, planes:vtkPlanes) -> None: ...
    def SetShowLines(self, _arg:bool) -> None: ...
    def ShowLinesOff(self) -> None: ...
    def ShowLinesOn(self) -> None: ...

class vtkGlyphSource2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CrossOff(self) -> None: ...
    def CrossOn(self) -> None: ...
    def DashOff(self) -> None: ...
    def DashOn(self) -> None: ...
    def FilledOff(self) -> None: ...
    def FilledOn(self) -> None: ...
    def GetCenter(self) -> (float, float, float): ...
    def GetColor(self) -> (float, float, float): ...
    def GetCross(self) -> int: ...
    def GetDash(self) -> int: ...
    def GetFilled(self) -> int: ...
    def GetGlyphType(self) -> int: ...
    def GetGlyphTypeMaxValue(self) -> int: ...
    def GetGlyphTypeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetRotationAngle(self) -> float: ...
    def GetScale(self) -> float: ...
    def GetScale2(self) -> float: ...
    def GetScale2MaxValue(self) -> float: ...
    def GetScale2MinValue(self) -> float: ...
    def GetScaleMaxValue(self) -> float: ...
    def GetScaleMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGlyphSource2D: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGlyphSource2D: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetColor(self, _arg:(float, float, float)) -> None: ...
    def SetCross(self, _arg:int) -> None: ...
    def SetDash(self, _arg:int) -> None: ...
    def SetFilled(self, _arg:int) -> None: ...
    def SetGlyphType(self, _arg:int) -> None: ...
    def SetGlyphTypeToArrow(self) -> None: ...
    def SetGlyphTypeToCircle(self) -> None: ...
    def SetGlyphTypeToCross(self) -> None: ...
    def SetGlyphTypeToDash(self) -> None: ...
    def SetGlyphTypeToDiamond(self) -> None: ...
    def SetGlyphTypeToEdgeArrow(self) -> None: ...
    def SetGlyphTypeToHookedArrow(self) -> None: ...
    def SetGlyphTypeToNone(self) -> None: ...
    def SetGlyphTypeToSquare(self) -> None: ...
    def SetGlyphTypeToThickArrow(self) -> None: ...
    def SetGlyphTypeToThickCross(self) -> None: ...
    def SetGlyphTypeToTriangle(self) -> None: ...
    def SetGlyphTypeToVertex(self) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    def SetRotationAngle(self, _arg:float) -> None: ...
    def SetScale(self, _arg:float) -> None: ...
    def SetScale2(self, _arg:float) -> None: ...

class vtkGraphToPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def EdgeGlyphOutputOff(self) -> None: ...
    def EdgeGlyphOutputOn(self) -> None: ...
    def GetEdgeGlyphOutput(self) -> bool: ...
    def GetEdgeGlyphPosition(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGraphToPolyData: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGraphToPolyData: ...
    def SetEdgeGlyphOutput(self, _arg:bool) -> None: ...
    def SetEdgeGlyphPosition(self, _arg:float) -> None: ...

class vtkHandleSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def DirectionalOff(self) -> None: ...
    def DirectionalOn(self) -> None: ...
    @overload
    def GetDirection(self, dir:[float, float, float]) -> None: ...
    @overload
    def GetDirection(self) -> Pointer: ...
    def GetDirectional(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetPosition(self, pos:[float, float, float]) -> None: ...
    @overload
    def GetPosition(self) -> Pointer: ...
    def GetSize(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHandleSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHandleSource: ...
    @overload
    def SetDirection(self, dir:(float, float, float)) -> None: ...
    @overload
    def SetDirection(self, xDir:float, yDir:float, zDir:float) -> None: ...
    def SetDirectional(self, _arg:bool) -> None: ...
    @overload
    def SetPosition(self, pos:(float, float, float)) -> None: ...
    @overload
    def SetPosition(self, xPos:float, yPos:float, zPos:float) -> None: ...
    def SetSize(self, _arg:float) -> None: ...

class vtkHyperTreeGridPreConfiguredSource(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    class HTGArchitecture(int): ...
    class HTGType(int): ...
    BALANCED:'HTGArchitecture'
    BALANCED_2DEPTH_3BRANCH_3X3X2:'HTGType'
    BALANCED_3DEPTH_2BRANCH_2X3:'HTGType'
    BALANCED_4DEPTH_3BRANCH_2X2:'HTGType'
    CUSTOM:'HTGType'
    UNBALANCED:'HTGArchitecture'
    UNBALANCED_2DEPTH_3BRANCH_3X3:'HTGType'
    UNBALANCED_3DEPTH_2BRANCH_2X3:'HTGType'
    UNBALANCED_3DEPTH_2BRANCH_3X2X3:'HTGType'
    def GenerateBalanced(self, HTG:vtkHyperTreeGrid, dim:int, factor:int, depth:int, extent:(float, ...), subdivisions:(int, ...)) -> None: ...
    def GenerateBalanced2Depth3BranchTree3x3x2(self, HTG:vtkHyperTreeGrid) -> None: ...
    def GenerateBalanced3DepthQuadTree2x3(self, HTG:vtkHyperTreeGrid) -> None: ...
    def GenerateBalanced4Depth3BranchTree2x2(self, HTG:vtkHyperTreeGrid) -> None: ...
    def GenerateCustom(self, HTG:vtkHyperTreeGrid) -> int: ...
    def GenerateUnbalanced(self, HTG:vtkHyperTreeGrid, dim:int, factor:int, depth:int, extent:(float, ...), subdivisions:(int, ...)) -> None: ...
    def GenerateUnbalanced2Depth3BranchTree3x3(self, HTG:vtkHyperTreeGrid) -> None: ...
    def GenerateUnbalanced3DepthOctTree3x2x3(self, HTG:vtkHyperTreeGrid) -> None: ...
    def GenerateUnbalanced3DepthQuadTree2x3(self, HTG:vtkHyperTreeGrid) -> None: ...
    def GetCustomArchitecture(self) -> HTGArchitecture: ...
    def GetCustomDepth(self) -> int: ...
    def GetCustomDim(self) -> int: ...
    def GetCustomExtent(self) -> (float, float, float, float, float, float): ...
    def GetCustomFactor(self) -> int: ...
    def GetCustomSubdivisions(self) -> (int, int, int): ...
    def GetHTGMode(self) -> HTGType: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHyperTreeGridPreConfiguredSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHyperTreeGridPreConfiguredSource: ...
    def SetCustomArchitecture(self, _arg:HTGArchitecture) -> None: ...
    def SetCustomDepth(self, _arg:int) -> None: ...
    def SetCustomDim(self, _arg:int) -> None: ...
    @overload
    def SetCustomExtent(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetCustomExtent(self, _arg:(float, float, float, float, float, float)) -> None: ...
    def SetCustomFactor(self, _arg:int) -> None: ...
    @overload
    def SetCustomSubdivisions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetCustomSubdivisions(self, _arg:(int, int, int)) -> None: ...
    def SetHTGMode(self, _arg:HTGType) -> None: ...

class vtkHyperTreeGridSource(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    def ConvertDescriptorStringToBitArray(self, __a:str) -> vtkBitArray: ...
    def ConvertMaskStringToBitArray(self, __a:str) -> vtkBitArray: ...
    def GenerateInterfaceFieldsOff(self) -> None: ...
    def GenerateInterfaceFieldsOn(self) -> None: ...
    def GetBranchFactor(self) -> int: ...
    def GetBranchFactorMaxValue(self) -> int: ...
    def GetBranchFactorMinValue(self) -> int: ...
    def GetDescriptor(self) -> str: ...
    def GetDescriptorBits(self) -> vtkBitArray: ...
    def GetDimensions(self) -> (int, int, int): ...
    def GetGenerateInterfaceFields(self) -> bool: ...
    def GetGridScale(self) -> (float, float, float): ...
    def GetMTime(self) -> int: ...
    def GetMask(self) -> str: ...
    def GetMaskBits(self) -> vtkBitArray: ...
    def GetMaxDepth(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetOrigin(self) -> (float, float, float): ...
    def GetQuadric(self) -> vtkQuadric: ...
    @overload
    def GetQuadricCoefficients(self, __a:[float, float, float, float, float, float, float, float, float, float]) -> None: ...
    @overload
    def GetQuadricCoefficients(self) -> Pointer: ...
    def GetTransposedRootIndexing(self) -> bool: ...
    def GetUseDescriptor(self) -> bool: ...
    def GetUseMask(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHyperTreeGridSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHyperTreeGridSource: ...
    def SetBranchFactor(self, _arg:int) -> None: ...
    def SetDescriptor(self, _arg:str) -> None: ...
    def SetDescriptorBits(self, __a:vtkBitArray) -> None: ...
    @overload
    def SetDimensions(self, dims:(int, ...)) -> None: ...
    @overload
    def SetDimensions(self, __a:int, __b:int, __c:int) -> None: ...
    def SetGenerateInterfaceFields(self, _arg:bool) -> None: ...
    @overload
    def SetGridScale(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetGridScale(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetGridScale(self, scale:float) -> None: ...
    def SetIndexingModeToIJK(self) -> None: ...
    def SetIndexingModeToKJI(self) -> None: ...
    def SetLevelZeroMaterialIndex(self, __a:vtkIdTypeArray) -> None: ...
    def SetMask(self, _arg:str) -> None: ...
    def SetMaskBits(self, __a:vtkBitArray) -> None: ...
    def SetMaxDepth(self, levels:int) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:(float, float, float)) -> None: ...
    def SetQuadric(self, __a:vtkQuadric) -> None: ...
    def SetQuadricCoefficients(self, __a:[float, float, float, float, float, float, float, float, float, float]) -> None: ...
    def SetTransposedRootIndexing(self, _arg:bool) -> None: ...
    def SetUseDescriptor(self, _arg:bool) -> None: ...
    def SetUseMask(self, _arg:bool) -> None: ...
    def UseDescriptorOff(self) -> None: ...
    def UseDescriptorOn(self) -> None: ...
    def UseMaskOff(self) -> None: ...
    def UseMaskOn(self) -> None: ...

class vtkLineSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfRefinementRatios(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPoint1(self) -> (float, float, float): ...
    def GetPoint2(self) -> (float, float, float): ...
    def GetPoints(self) -> vtkPoints: ...
    def GetRefinementRatio(self, index:int) -> float: ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetUseRegularRefinement(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLineSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLineSource: ...
    def SetNumberOfRefinementRatios(self, __a:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    @overload
    def SetPoint1(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPoint1(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetPoint2(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPoint2(self, _arg:(float, float, float)) -> None: ...
    def SetPoints(self, __a:vtkPoints) -> None: ...
    def SetRefinementRatio(self, index:int, value:float) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    def SetUseRegularRefinement(self, _arg:bool) -> None: ...
    def UseRegularRefinementOff(self) -> None: ...
    def UseRegularRefinementOn(self) -> None: ...

class vtkOutlineCornerFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetCornerFactor(self) -> float: ...
    def GetCornerFactorMaxValue(self) -> float: ...
    def GetCornerFactorMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkOutlineCornerFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkOutlineCornerFilter: ...
    def SetCornerFactor(self, _arg:float) -> None: ...

class vtkOutlineSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GenerateFacesOff(self) -> None: ...
    def GenerateFacesOn(self) -> None: ...
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    def GetBoxType(self) -> int: ...
    def GetCorners(self) -> (float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float): ...
    def GetGenerateFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkOutlineSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkOutlineSource: ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:(float, float, float, float, float, float)) -> None: ...
    def SetBoxType(self, _arg:int) -> None: ...
    def SetBoxTypeToAxisAligned(self) -> None: ...
    def SetBoxTypeToOriented(self) -> None: ...
    def SetCorners(self, data:(float, ...)) -> None: ...
    def SetGenerateFaces(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...

class vtkOutlineCornerSource(vtkOutlineSource):
    def GetCornerFactor(self) -> float: ...
    def GetCornerFactorMaxValue(self) -> float: ...
    def GetCornerFactorMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkOutlineCornerSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkOutlineCornerSource: ...
    def SetCornerFactor(self, _arg:float) -> None: ...

class vtkParametricFunctionSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class SCALAR_MODE(int): ...
    SCALAR_DISTANCE:'SCALAR_MODE'
    SCALAR_FUNCTION_DEFINED:'SCALAR_MODE'
    SCALAR_MODULUS:'SCALAR_MODE'
    SCALAR_NONE:'SCALAR_MODE'
    SCALAR_PHASE:'SCALAR_MODE'
    SCALAR_QUADRANT:'SCALAR_MODE'
    SCALAR_U:'SCALAR_MODE'
    SCALAR_U0:'SCALAR_MODE'
    SCALAR_U0V0:'SCALAR_MODE'
    SCALAR_V:'SCALAR_MODE'
    SCALAR_V0:'SCALAR_MODE'
    SCALAR_X:'SCALAR_MODE'
    SCALAR_Y:'SCALAR_MODE'
    SCALAR_Z:'SCALAR_MODE'
    def GenerateNormalsOff(self) -> None: ...
    def GenerateNormalsOn(self) -> None: ...
    def GenerateTextureCoordinatesOff(self) -> None: ...
    def GenerateTextureCoordinatesOn(self) -> None: ...
    def GetGenerateNormals(self) -> int: ...
    def GetGenerateNormalsMaxValue(self) -> int: ...
    def GetGenerateNormalsMinValue(self) -> int: ...
    def GetGenerateTextureCoordinates(self) -> int: ...
    def GetGenerateTextureCoordinatesMaxValue(self) -> int: ...
    def GetGenerateTextureCoordinatesMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetParametricFunction(self) -> vtkParametricFunction: ...
    def GetScalarMode(self) -> int: ...
    def GetScalarModeMaxValue(self) -> int: ...
    def GetScalarModeMinValue(self) -> int: ...
    def GetUResolution(self) -> int: ...
    def GetUResolutionMaxValue(self) -> int: ...
    def GetUResolutionMinValue(self) -> int: ...
    def GetVResolution(self) -> int: ...
    def GetVResolutionMaxValue(self) -> int: ...
    def GetVResolutionMinValue(self) -> int: ...
    def GetWResolution(self) -> int: ...
    def GetWResolutionMaxValue(self) -> int: ...
    def GetWResolutionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkParametricFunctionSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkParametricFunctionSource: ...
    def SetGenerateNormals(self, _arg:int) -> None: ...
    def SetGenerateTextureCoordinates(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetParametricFunction(self, __a:vtkParametricFunction) -> None: ...
    def SetScalarMode(self, _arg:int) -> None: ...
    def SetScalarModeToDistance(self) -> None: ...
    def SetScalarModeToFunctionDefined(self) -> None: ...
    def SetScalarModeToModulus(self) -> None: ...
    def SetScalarModeToNone(self) -> None: ...
    def SetScalarModeToPhase(self) -> None: ...
    def SetScalarModeToQuadrant(self) -> None: ...
    def SetScalarModeToU(self) -> None: ...
    def SetScalarModeToU0(self) -> None: ...
    def SetScalarModeToU0V0(self) -> None: ...
    def SetScalarModeToV(self) -> None: ...
    def SetScalarModeToV0(self) -> None: ...
    def SetScalarModeToX(self) -> None: ...
    def SetScalarModeToY(self) -> None: ...
    def SetScalarModeToZ(self) -> None: ...
    def SetUResolution(self, _arg:int) -> None: ...
    def SetVResolution(self, _arg:int) -> None: ...
    def SetWResolution(self, _arg:int) -> None: ...

class vtkPartitionedDataSetCollectionSource(vtkmodules.vtkCommonExecutionModel.vtkPartitionedDataSetCollectionAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfShapes(self) -> int: ...
    def GetNumberOfShapesMaxValue(self) -> int: ...
    def GetNumberOfShapesMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPartitionedDataSetCollectionSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPartitionedDataSetCollectionSource: ...
    def SetNumberOfShapes(self, _arg:int) -> None: ...

class vtkPartitionedDataSetSource(vtkmodules.vtkCommonExecutionModel.vtkPartitionedDataSetAlgorithm):
    def DisableAllRanks(self) -> None: ...
    def DisableRank(self, rank:int) -> None: ...
    def EnableAllRanks(self) -> None: ...
    def EnableRank(self, rank:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPartitions(self) -> int: ...
    def GetNumberOfPartitionsMaxValue(self) -> int: ...
    def GetNumberOfPartitionsMinValue(self) -> int: ...
    def GetParametricFunction(self) -> vtkParametricFunction: ...
    def IsA(self, type:str) -> int: ...
    def IsEnabledRank(self, rank:int) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPartitionedDataSetSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPartitionedDataSetSource: ...
    def SetNumberOfPartitions(self, _arg:int) -> None: ...
    def SetParametricFunction(self, __a:vtkParametricFunction) -> None: ...

class vtkPlaneSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetAxis1(self, a1:[float, float, float]) -> None: ...
    def GetAxis2(self, a2:[float, float, float]) -> None: ...
    def GetCenter(self) -> (float, float, float): ...
    def GetNormal(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> (float, float, float): ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPoint1(self) -> (float, float, float): ...
    def GetPoint2(self) -> (float, float, float): ...
    def GetResolution(self, xR:int, yR:int) -> None: ...
    def GetXResolution(self) -> int: ...
    def GetYResolution(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPlaneSource: ...
    def Push(self, distance:float) -> None: ...
    def Rotate(self, angle:float, rotationAxis:[float, float, float]) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPlaneSource: ...
    @overload
    def SetCenter(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetCenter(self, center:[float, float, float]) -> None: ...
    @overload
    def SetNormal(self, nx:float, ny:float, nz:float) -> None: ...
    @overload
    def SetNormal(self, n:[float, float, float]) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:(float, float, float)) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    @overload
    def SetPoint1(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPoint1(self, pnt:[float, float, float]) -> None: ...
    @overload
    def SetPoint2(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPoint2(self, pnt:[float, float, float]) -> None: ...
    def SetResolution(self, xR:int, yR:int) -> None: ...
    def SetXResolution(self, _arg:int) -> None: ...
    def SetYResolution(self, _arg:int) -> None: ...

class vtkPlatonicSolidSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetSolidType(self) -> int: ...
    def GetSolidTypeMaxValue(self) -> int: ...
    def GetSolidTypeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPlatonicSolidSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPlatonicSolidSource: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetSolidType(self, _arg:int) -> None: ...
    def SetSolidTypeToCube(self) -> None: ...
    def SetSolidTypeToDodecahedron(self) -> None: ...
    def SetSolidTypeToIcosahedron(self) -> None: ...
    def SetSolidTypeToOctahedron(self) -> None: ...
    def SetSolidTypeToTetrahedron(self) -> None: ...

class vtkPointHandleSource(vtkHandleSource):
    @overload
    def GetDirection(self) -> Pointer: ...
    @overload
    def GetDirection(self, dir:[float, float, float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetPosition(self) -> Pointer: ...
    @overload
    def GetPosition(self, pos:[float, float, float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPointHandleSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPointHandleSource: ...
    @overload
    def SetDirection(self, xDir:float, yDir:float, zDir:float) -> None: ...
    @overload
    def SetDirection(self, dir:(float, float, float)) -> None: ...
    @overload
    def SetPosition(self, xPos:float, yPos:float, zPos:float) -> None: ...
    @overload
    def SetPosition(self, pos:(float, float, float)) -> None: ...

class vtkPointSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetCenter(self) -> (float, float, float): ...
    def GetDistribution(self) -> int: ...
    def GetDistributionMaxValue(self) -> int: ...
    def GetDistributionMinValue(self) -> int: ...
    def GetLambda(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetNumberOfPointsMaxValue(self) -> int: ...
    def GetNumberOfPointsMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetRandomSequence(self) -> vtkRandomSequence: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPointSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPointSource: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetDistribution(self, _arg:int) -> None: ...
    def SetDistributionToExponential(self) -> None: ...
    def SetDistributionToShell(self) -> None: ...
    def SetDistributionToUniform(self) -> None: ...
    def SetLambda(self, _arg:float) -> None: ...
    def SetNumberOfPoints(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetRandomSequence(self, randomSequence:vtkRandomSequence) -> None: ...

class vtkPolyPointSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetPoints(self) -> vtkPoints: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPolyPointSource: ...
    def Resize(self, numPoints:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPolyPointSource: ...
    def SetNumberOfPoints(self, numPoints:int) -> None: ...
    def SetPoint(self, id:int, x:float, y:float, z:float) -> None: ...
    def SetPoints(self, points:vtkPoints) -> None: ...

class vtkPolyLineSource(vtkPolyPointSource):
    def ClosedOff(self) -> None: ...
    def ClosedOn(self) -> None: ...
    def GetClosed(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPolyLineSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPolyLineSource: ...
    def SetClosed(self, _arg:int) -> None: ...

class vtkProgrammableDataObjectSource(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkProgrammableDataObjectSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkProgrammableDataObjectSource: ...
    def SetExecuteMethod(self, f:Callback) -> None: ...

class vtkProgrammableSource(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    def GetGraphOutput(self) -> vtkGraph: ...
    def GetMoleculeOutput(self) -> vtkMolecule: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyDataOutput(self) -> vtkPolyData: ...
    def GetRectilinearGridOutput(self) -> vtkRectilinearGrid: ...
    def GetStructuredGridOutput(self) -> vtkStructuredGrid: ...
    def GetStructuredPointsOutput(self) -> vtkStructuredPoints: ...
    def GetTableOutput(self) -> vtkTable: ...
    def GetUnstructuredGridOutput(self) -> vtkUnstructuredGrid: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkProgrammableSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkProgrammableSource: ...
    def SetExecuteMethod(self, f:Callback) -> None: ...

class vtkRandomHyperTreeGridSource(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    def GetDimensions(self) -> (int, int, int): ...
    def GetMaxDepth(self) -> int: ...
    def GetMaxDepthMaxValue(self) -> int: ...
    def GetMaxDepthMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputBounds(self) -> (float, float, float, float, float, float): ...
    def GetSeed(self) -> int: ...
    def GetSplitFraction(self) -> float: ...
    def GetSplitFractionMaxValue(self) -> float: ...
    def GetSplitFractionMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRandomHyperTreeGridSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRandomHyperTreeGridSource: ...
    @overload
    def SetDimensions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetDimensions(self, _arg:(int, int, int)) -> None: ...
    def SetMaxDepth(self, _arg:int) -> None: ...
    @overload
    def SetOutputBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetOutputBounds(self, _arg:(float, float, float, float, float, float)) -> None: ...
    def SetSeed(self, _arg:int) -> None: ...
    def SetSplitFraction(self, _arg:float) -> None: ...

class vtkRectangularButtonSource(vtkButtonSource):
    def GetBoxRatio(self) -> float: ...
    def GetBoxRatioMaxValue(self) -> float: ...
    def GetBoxRatioMinValue(self) -> float: ...
    def GetDepth(self) -> float: ...
    def GetDepthMaxValue(self) -> float: ...
    def GetDepthMinValue(self) -> float: ...
    def GetHeight(self) -> float: ...
    def GetHeightMaxValue(self) -> float: ...
    def GetHeightMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetTextureHeightRatio(self) -> float: ...
    def GetTextureHeightRatioMaxValue(self) -> float: ...
    def GetTextureHeightRatioMinValue(self) -> float: ...
    def GetTextureRatio(self) -> float: ...
    def GetTextureRatioMaxValue(self) -> float: ...
    def GetTextureRatioMinValue(self) -> float: ...
    def GetWidth(self) -> float: ...
    def GetWidthMaxValue(self) -> float: ...
    def GetWidthMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRectangularButtonSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRectangularButtonSource: ...
    def SetBoxRatio(self, _arg:float) -> None: ...
    def SetDepth(self, _arg:float) -> None: ...
    def SetHeight(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetTextureHeightRatio(self, _arg:float) -> None: ...
    def SetTextureRatio(self, _arg:float) -> None: ...
    def SetWidth(self, _arg:float) -> None: ...

class vtkRegularPolygonSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GeneratePolygonOff(self) -> None: ...
    def GeneratePolygonOn(self) -> None: ...
    def GeneratePolylineOff(self) -> None: ...
    def GeneratePolylineOn(self) -> None: ...
    def GetCenter(self) -> (float, float, float): ...
    def GetGeneratePolygon(self) -> int: ...
    def GetGeneratePolyline(self) -> int: ...
    def GetNormal(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSides(self) -> int: ...
    def GetNumberOfSidesMaxValue(self) -> int: ...
    def GetNumberOfSidesMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRadius(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRegularPolygonSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRegularPolygonSource: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetGeneratePolygon(self, _arg:int) -> None: ...
    def SetGeneratePolyline(self, _arg:int) -> None: ...
    @overload
    def SetNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNormal(self, _arg:(float, float, float)) -> None: ...
    def SetNumberOfSides(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkSelectionSource(vtkmodules.vtkCommonExecutionModel.vtkSelectionAlgorithm):
    class FieldTypeOptions(int): ...
    ELEMENT_TYPE:'FieldTypeOptions'
    FIELD_TYPE:'FieldTypeOptions'
    @overload
    def AddBlock(self, nodeId:int, block:int) -> None: ...
    @overload
    def AddBlock(self, blockno:int) -> None: ...
    @overload
    def AddBlockSelector(self, nodeId:int, block:str) -> None: ...
    @overload
    def AddBlockSelector(self, selector:str) -> None: ...
    @overload
    def AddID(self, nodeId:int, piece:int, id:int) -> None: ...
    @overload
    def AddID(self, piece:int, id:int) -> None: ...
    @overload
    def AddLocation(self, nodeId:int, x:float, y:float, z:float) -> None: ...
    @overload
    def AddLocation(self, x:float, y:float, z:float) -> None: ...
    @overload
    def AddSelector(self, nodeId:int, selector:str) -> None: ...
    @overload
    def AddSelector(self, selector:str) -> None: ...
    @overload
    def AddStringID(self, nodeId:int, piece:int, id:str) -> None: ...
    @overload
    def AddStringID(self, piece:int, id:str) -> None: ...
    @overload
    def AddThreshold(self, nodeId:int, min:float, max:float) -> None: ...
    @overload
    def AddThreshold(self, min:float, max:float) -> None: ...
    @overload
    def GetArrayComponent(self, nodeId:int) -> int: ...
    @overload
    def GetArrayComponent(self) -> int: ...
    @overload
    def GetArrayName(self, nodeId:int) -> str: ...
    @overload
    def GetArrayName(self) -> str: ...
    @overload
    def GetAssemblyName(self, nodeId:int) -> str: ...
    @overload
    def GetAssemblyName(self) -> str: ...
    @overload
    def GetCompositeIndex(self, nodeId:int) -> int: ...
    @overload
    def GetCompositeIndex(self) -> int: ...
    @overload
    def GetContainingCells(self, nodeId:int) -> int: ...
    @overload
    def GetContainingCells(self) -> int: ...
    @overload
    def GetContentType(self, nodeId:int) -> int: ...
    @overload
    def GetContentType(self) -> int: ...
    def GetContentTypeMaxValue(self) -> int: ...
    def GetContentTypeMinValue(self) -> int: ...
    def GetElementType(self) -> int: ...
    def GetElementTypeMaxValue(self) -> int: ...
    def GetElementTypeMinValue(self) -> int: ...
    def GetExpression(self) -> str: ...
    def GetFieldType(self) -> int: ...
    def GetFieldTypeMaxValue(self) -> int: ...
    def GetFieldTypeMinValue(self) -> int: ...
    def GetFieldTypeOption(self) -> int: ...
    def GetFieldTypeOptionMaxValue(self) -> int: ...
    def GetFieldTypeOptionMinValue(self) -> int: ...
    @overload
    def GetHierarchicalIndex(self, nodeId:int) -> int: ...
    @overload
    def GetHierarchicalIndex(self) -> int: ...
    @overload
    def GetHierarchicalLevel(self, nodeId:int) -> int: ...
    @overload
    def GetHierarchicalLevel(self) -> int: ...
    @overload
    def GetInverse(self, nodeId:int) -> int: ...
    @overload
    def GetInverse(self) -> int: ...
    @overload
    def GetNodeName(self, nodeId:int) -> str: ...
    @overload
    def GetNodeName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetNumberOfLayers(self, nodeId:int) -> int: ...
    @overload
    def GetNumberOfLayers(self) -> int: ...
    def GetNumberOfLayersMaxValue(self) -> int: ...
    def GetNumberOfLayersMinValue(self) -> int: ...
    def GetNumberOfNodes(self) -> int: ...
    def GetProcessID(self) -> int: ...
    def GetProcessIDMaxValue(self) -> int: ...
    def GetProcessIDMinValue(self) -> int: ...
    @overload
    def GetQueryString(self, nodeId:int) -> str: ...
    @overload
    def GetQueryString(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkSelectionSource: ...
    @overload
    def RemoveAllBlockSelectors(self, nodeId:int) -> None: ...
    @overload
    def RemoveAllBlockSelectors(self) -> None: ...
    @overload
    def RemoveAllBlocks(self, nodeId:int) -> None: ...
    @overload
    def RemoveAllBlocks(self) -> None: ...
    @overload
    def RemoveAllIDs(self, nodeId:int) -> None: ...
    @overload
    def RemoveAllIDs(self) -> None: ...
    @overload
    def RemoveAllLocations(self, nodeId:int) -> None: ...
    @overload
    def RemoveAllLocations(self) -> None: ...
    def RemoveAllNodes(self) -> None: ...
    @overload
    def RemoveAllSelectors(self, nodeId:int) -> None: ...
    @overload
    def RemoveAllSelectors(self) -> None: ...
    @overload
    def RemoveAllStringIDs(self, nodeId:int) -> None: ...
    @overload
    def RemoveAllStringIDs(self) -> None: ...
    @overload
    def RemoveAllThresholds(self, nodeId:int) -> None: ...
    @overload
    def RemoveAllThresholds(self) -> None: ...
    @overload
    def RemoveNode(self, idx:int) -> None: ...
    @overload
    def RemoveNode(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSelectionSource: ...
    @overload
    def SetArrayComponent(self, nodeId:int, component:int) -> None: ...
    @overload
    def SetArrayComponent(self, component:int) -> None: ...
    @overload
    def SetArrayName(self, nodeId:int, name:str) -> None: ...
    @overload
    def SetArrayName(self, name:str) -> None: ...
    @overload
    def SetAssemblyName(self, nodeId:int, name:str) -> None: ...
    @overload
    def SetAssemblyName(self, name:str) -> None: ...
    @overload
    def SetCompositeIndex(self, nodeId:int, index:int) -> None: ...
    @overload
    def SetCompositeIndex(self, compositeIndex:int) -> None: ...
    @overload
    def SetContainingCells(self, nodeId:int, containingCells:int) -> None: ...
    @overload
    def SetContainingCells(self, containingCells:int) -> None: ...
    @overload
    def SetContentType(self, nodeId:int, type:int) -> None: ...
    @overload
    def SetContentType(self, contentType:int) -> None: ...
    def SetElementType(self, _arg:int) -> None: ...
    def SetExpression(self, arg:str) -> None: ...
    def SetFieldType(self, _arg:int) -> None: ...
    def SetFieldTypeOption(self, _arg:int) -> None: ...
    def SetFieldTypeOptionToElementType(self) -> None: ...
    def SetFieldTypeOptionToFieldType(self) -> None: ...
    @overload
    def SetFrustum(self, nodeId:int, vertices:[float, ...]) -> None: ...
    @overload
    def SetFrustum(self, vertices:[float, ...]) -> None: ...
    @overload
    def SetHierarchicalIndex(self, nodeId:int, index:int) -> None: ...
    @overload
    def SetHierarchicalIndex(self, index:int) -> None: ...
    @overload
    def SetHierarchicalLevel(self, nodeId:int, level:int) -> None: ...
    @overload
    def SetHierarchicalLevel(self, level:int) -> None: ...
    @overload
    def SetInverse(self, nodeId:int, inverse:int) -> None: ...
    @overload
    def SetInverse(self, inverse:int) -> None: ...
    @overload
    def SetNodeName(self, nodeId:int, name:str) -> None: ...
    @overload
    def SetNodeName(self, name:str) -> None: ...
    @overload
    def SetNumberOfLayers(self, nodeId:int, numberOfLayers:int) -> None: ...
    @overload
    def SetNumberOfLayers(self, numberOfLayers:int) -> None: ...
    def SetNumberOfNodes(self, numberOfNodes:int) -> None: ...
    def SetProcessID(self, _arg:int) -> None: ...
    @overload
    def SetQueryString(self, nodeId:int, queryString:str) -> None: ...
    @overload
    def SetQueryString(self, query:str) -> None: ...

class vtkSphereSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GenerateNormalsOff(self) -> None: ...
    def GenerateNormalsOn(self) -> None: ...
    def GetCenter(self) -> (float, float, float): ...
    def GetEndPhi(self) -> float: ...
    def GetEndPhiMaxValue(self) -> float: ...
    def GetEndPhiMinValue(self) -> float: ...
    def GetEndTheta(self) -> float: ...
    def GetEndThetaMaxValue(self) -> float: ...
    def GetEndThetaMinValue(self) -> float: ...
    def GetGenerateNormals(self) -> int: ...
    def GetLatLongTessellation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPhiResolution(self) -> int: ...
    def GetPhiResolutionMaxValue(self) -> int: ...
    def GetPhiResolutionMinValue(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetStartPhi(self) -> float: ...
    def GetStartPhiMaxValue(self) -> float: ...
    def GetStartPhiMinValue(self) -> float: ...
    def GetStartTheta(self) -> float: ...
    def GetStartThetaMaxValue(self) -> float: ...
    def GetStartThetaMinValue(self) -> float: ...
    def GetThetaResolution(self) -> int: ...
    def GetThetaResolutionMaxValue(self) -> int: ...
    def GetThetaResolutionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LatLongTessellationOff(self) -> None: ...
    def LatLongTessellationOn(self) -> None: ...
    def NewInstance(self) -> vtkSphereSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSphereSource: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetEndPhi(self, _arg:float) -> None: ...
    def SetEndTheta(self, _arg:float) -> None: ...
    def SetGenerateNormals(self, _arg:int) -> None: ...
    def SetLatLongTessellation(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPhiResolution(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetStartPhi(self, _arg:float) -> None: ...
    def SetStartTheta(self, _arg:float) -> None: ...
    def SetThetaResolution(self, _arg:int) -> None: ...

class vtkSuperquadricSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetAxisOfSymmetry(self) -> int: ...
    def GetCenter(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPhiResolution(self) -> int: ...
    def GetPhiRoundness(self) -> float: ...
    def GetScale(self) -> (float, float, float): ...
    def GetSize(self) -> float: ...
    def GetThetaResolution(self) -> int: ...
    def GetThetaRoundness(self) -> float: ...
    def GetThickness(self) -> float: ...
    def GetThicknessMaxValue(self) -> float: ...
    def GetThicknessMinValue(self) -> float: ...
    def GetToroidal(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkSuperquadricSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSuperquadricSource: ...
    def SetAxisOfSymmetry(self, _arg:int) -> None: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPhiResolution(self, i:int) -> None: ...
    def SetPhiRoundness(self, e:float) -> None: ...
    @overload
    def SetScale(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetScale(self, _arg:(float, float, float)) -> None: ...
    def SetSize(self, _arg:float) -> None: ...
    def SetThetaResolution(self, i:int) -> None: ...
    def SetThetaRoundness(self, e:float) -> None: ...
    def SetThickness(self, _arg:float) -> None: ...
    def SetToroidal(self, _arg:int) -> None: ...
    def SetXAxisOfSymmetry(self) -> None: ...
    def SetYAxisOfSymmetry(self) -> None: ...
    def SetZAxisOfSymmetry(self) -> None: ...
    def ToroidalOff(self) -> None: ...
    def ToroidalOn(self) -> None: ...

class vtkTessellatedBoxSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def DuplicateSharedPointsOff(self) -> None: ...
    def DuplicateSharedPointsOn(self) -> None: ...
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    def GetDuplicateSharedPoints(self) -> int: ...
    def GetLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetQuads(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTessellatedBoxSource: ...
    def QuadsOff(self) -> None: ...
    def QuadsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTessellatedBoxSource: ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:(float, float, float, float, float, float)) -> None: ...
    def SetDuplicateSharedPoints(self, _arg:int) -> None: ...
    def SetLevel(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetQuads(self, _arg:int) -> None: ...

class vtkTextSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def BackingOff(self) -> None: ...
    def BackingOn(self) -> None: ...
    def GetBackgroundColor(self) -> (float, float, float): ...
    def GetBacking(self) -> int: ...
    def GetForegroundColor(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetText(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTextSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTextSource: ...
    @overload
    def SetBackgroundColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg:(float, float, float)) -> None: ...
    def SetBacking(self, _arg:int) -> None: ...
    @overload
    def SetForegroundColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetForegroundColor(self, _arg:(float, float, float)) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetText(self, _arg:str) -> None: ...

class vtkTexturedSphereSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPhi(self) -> float: ...
    def GetPhiMaxValue(self) -> float: ...
    def GetPhiMinValue(self) -> float: ...
    def GetPhiResolution(self) -> int: ...
    def GetPhiResolutionMaxValue(self) -> int: ...
    def GetPhiResolutionMinValue(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetTheta(self) -> float: ...
    def GetThetaMaxValue(self) -> float: ...
    def GetThetaMinValue(self) -> float: ...
    def GetThetaResolution(self) -> int: ...
    def GetThetaResolutionMaxValue(self) -> int: ...
    def GetThetaResolutionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTexturedSphereSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTexturedSphereSource: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPhi(self, _arg:float) -> None: ...
    def SetPhiResolution(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetTheta(self, _arg:float) -> None: ...
    def SetThetaResolution(self, _arg:int) -> None: ...

class vtkUniformHyperTreeGridSource(vtkHyperTreeGridSource):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkUniformHyperTreeGridSource: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkUniformHyperTreeGridSource: ...

