"""
    University Photo API

     ## Introduction  The Photo API allows access to Photos of members of the University. The Photos exposed by this API are expected to be a good representation of the person they relate to.  The API broadly follows the principles of REST and strives to provide an interface that can be easily consumed by downstream systems.  ### Stability  This release of the Photo API is a `beta` offering: a service we are moving towards live but which requires wider testing with a broader group of users.  ### Versioning  The Photo API is versioned using URL path prefixes in the format: `/v1beta1/photos`. This follows the pattern established by the [GCP API](https://cloud.google.com/apis/design/versioning). Breaking changes will not be made without a change in API major version, however non-breaking changes will be introduced without changes to the version path prefix. All changes will be documented in the project's [CHANGELOG](https://gitlab.developers.cam.ac.uk/uis/devops/iam/photo-api/-/blob/master/CHANGELOG.md)  The available versions of the API are listed at the API's root.  ### Domain  The Photo API serves Photos of members of the University, linking a Photo to an individual through `PhotoIdentifiers` (see below) which pertain to a person record within an external system.  The Photos served by the Photo API are expected to be of sufficient quality to identify the person they represent. Photos which have been reviewed and determined to be sufficient quality are marked as having the status `approved` and exposed through the `approved-photos` endpoints.  ### Data source  The Photos exposed by the Photo API are currently a mirror of card Photos contained within the [Card Database](https://webservices.admin.cam.ac.uk/uc/). With Photos being synced from the Card Database to the Photo API hourly.  In future, the Photo API will be extended to allow Photos to be created and 'approved' using the API.  ## Core entities  ### The `Photo` Entity  The `Photo` entity contains information and metadata about a Photo of a member of the university. The `status` field on a Photo indicates whether this Photo has been reviewed and approved. Only Photos which have the status `approved` are exposed through the `approved-photos` endpoints. Each photo entity has a unique identifier - termed UUID - which is used in the system to refer to the specific photo entity. The UUID is provided in JSON documents as the `id` property.   Each Photo entity contains a link to the image data itself and a thumbnail for this Photo, which is guaranteed to be less than 128x128 pixels. Images are served by redirecting to a temporary URL provided by the service used to host images. These temporary URLs will expire after an hour and should not be retained for long-lasting access to a given Photo.  Each Photo may contain a block of JSON metadata recording information about the Photo. Photos cannot be updated once created (apart from to move their status to `approved`) hence this metadata should not be used to store application state or any other information which is not related to the content of the Photo.  Each Photo will have a set of `PhotoIdentifier` which allow the Photo to be linked to a person record within another system.  ### The `PhotoIdentifier` Entity  The `PhotoIdentifier` entity holds the `value` and `scheme` of a given identifier. The `value` field of a `PhotoIdentifier` is a simple ID string - e.g. `wgd23` or `000001`. The `scheme` field of a `PhotoIdentifier` indicates what system this identifier relates to or was issued by. This allows many identifiers which relate to different systems to be recorded against a single `Photo`.  The supported schemes are: * `v1.person.identifiers.cam.ac.uk`: The CRSID of the person represented by this Photo * `person.v1.student-records.university.identifiers.cam.ac.uk`: The CamSIS identifier (USN) of the person represented by this Photo * `person.v1.human-resources.university.identifiers.cam.ac.uk`: The CHRIS identifier (staff number) of the person represented by this Photo * `photo.v1.legacy-card.university.identifiers.cam.ac.uk`: The id of this Photo within the legacy card system  ## Using the API  ### Auth  To authenticate against the Photo API, an application must be registered within the API Gateway and granted access to the `University Photo` product. Details of how to register an application and grant access to products can be found in the [API Gateway Getting Started Guide](https://developer.api.apps.cam.ac.uk/start-using-an-api).    # noqa: E501

    The version of the OpenAPI document: v1beta1
    Contact: devops+photoapi@uis.cam.ac.uk
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from identitylib.photo_client.api_client import ApiClient, Endpoint as _Endpoint
from identitylib.photo_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from identitylib.photo_client.model.bad_request import BadRequest
from identitylib.photo_client.model.forbidden import Forbidden
from identitylib.photo_client.model.internal_server_error import InternalServerError
from identitylib.photo_client.model.not_found import NotFound
from identitylib.photo_client.model.paginated_v1_beta1_photo_identifier_summary_list import PaginatedV1Beta1PhotoIdentifierSummaryList
from identitylib.photo_client.model.paginated_v1_beta1_photo_list import PaginatedV1Beta1PhotoList
from identitylib.photo_client.model.photo_identifier import PhotoIdentifier
from identitylib.photo_client.model.photo_identifier_bulk_update_request_request import PhotoIdentifierBulkUpdateRequestRequest
from identitylib.photo_client.model.transient_image_url import TransientImageUrl
from identitylib.photo_client.model.unauthorized import Unauthorized
from identitylib.photo_client.model.v1_beta1_photo import V1Beta1Photo


class V1beta1Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1beta1_all_photos_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedV1Beta1PhotoList,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/all-photos',
                'operation_id': 'v1beta1_all_photos_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cursor',
                    'page_size',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cursor':
                        (str,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'cursor': 'cursor',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'cursor': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_approved_photos_content_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/approved-photos/{identifier}/content',
                'operation_id': 'v1beta1_approved_photos_content_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'identifier',
                ],
                'required': [
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identifier':
                        (str,),
                },
                'attribute_map': {
                    'identifier': 'identifier',
                },
                'location_map': {
                    'identifier': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'image/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_approved_photos_content_transient_url_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (TransientImageUrl,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/approved-photos/{identifier}/content/transient-url',
                'operation_id': 'v1beta1_approved_photos_content_transient_url_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'identifier',
                ],
                'required': [
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identifier':
                        (str,),
                },
                'attribute_map': {
                    'identifier': 'identifier',
                },
                'location_map': {
                    'identifier': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_approved_photos_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedV1Beta1PhotoList,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/approved-photos',
                'operation_id': 'v1beta1_approved_photos_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'approved_since',
                    'cursor',
                    'page_size',
                ],
                'required': [
                    'approved_since',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'approved_since':
                        (str,),
                    'cursor':
                        (str,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'approved_since': 'approvedSince',
                    'cursor': 'cursor',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'approved_since': 'query',
                    'cursor': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_approved_photos_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (V1Beta1Photo,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/approved-photos/{identifier}',
                'operation_id': 'v1beta1_approved_photos_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'identifier',
                ],
                'required': [
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identifier':
                        (str,),
                },
                'attribute_map': {
                    'identifier': 'identifier',
                },
                'location_map': {
                    'identifier': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_approved_photos_thumbnail_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/approved-photos/{identifier}/thumbnail',
                'operation_id': 'v1beta1_approved_photos_thumbnail_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'identifier',
                ],
                'required': [
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identifier':
                        (str,),
                },
                'attribute_map': {
                    'identifier': 'identifier',
                },
                'location_map': {
                    'identifier': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'image/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_approved_photos_thumbnail_transient_url_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (TransientImageUrl,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/approved-photos/{identifier}/thumbnail/transient-url',
                'operation_id': 'v1beta1_approved_photos_thumbnail_transient_url_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'identifier',
                ],
                'required': [
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identifier':
                        (str,),
                },
                'attribute_map': {
                    'identifier': 'identifier',
                },
                'location_map': {
                    'identifier': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photo_identifiers_destroy_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photo-identifiers/{id}',
                'operation_id': 'v1beta1_photo_identifiers_destroy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photo_identifiers_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedV1Beta1PhotoIdentifierSummaryList,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photo-identifiers',
                'operation_id': 'v1beta1_photo_identifiers_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cursor',
                    'deleted_at__gte',
                    'deleted_at__is_null',
                    'deleted_at__isnull',
                    'deleted_at__lte',
                    'identifier',
                    'is_deleted',
                    'is_highest_primary_identifier',
                    'page_size',
                    'retain_until__gte',
                    'retain_until__is_null',
                    'retain_until__isnull',
                    'retain_until__lte',
                    'scheme',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cursor':
                        (str,),
                    'deleted_at__gte':
                        (str,),
                    'deleted_at__is_null':
                        (bool,),
                    'deleted_at__isnull':
                        (bool,),
                    'deleted_at__lte':
                        (str,),
                    'identifier':
                        (str,),
                    'is_deleted':
                        (bool,),
                    'is_highest_primary_identifier':
                        (bool,),
                    'page_size':
                        (int,),
                    'retain_until__gte':
                        (str,),
                    'retain_until__is_null':
                        (bool,),
                    'retain_until__isnull':
                        (bool,),
                    'retain_until__lte':
                        (str,),
                    'scheme':
                        (str,),
                },
                'attribute_map': {
                    'cursor': 'cursor',
                    'deleted_at__gte': 'deleted_at__gte',
                    'deleted_at__is_null': 'deleted_at__isNull',
                    'deleted_at__isnull': 'deleted_at__isnull',
                    'deleted_at__lte': 'deleted_at__lte',
                    'identifier': 'identifier',
                    'is_deleted': 'is_deleted',
                    'is_highest_primary_identifier': 'is_highest_primary_identifier',
                    'page_size': 'pageSize',
                    'retain_until__gte': 'retain_until__gte',
                    'retain_until__is_null': 'retain_until__isNull',
                    'retain_until__isnull': 'retain_until__isnull',
                    'retain_until__lte': 'retain_until__lte',
                    'scheme': 'scheme',
                },
                'location_map': {
                    'cursor': 'query',
                    'deleted_at__gte': 'query',
                    'deleted_at__is_null': 'query',
                    'deleted_at__isnull': 'query',
                    'deleted_at__lte': 'query',
                    'identifier': 'query',
                    'is_deleted': 'query',
                    'is_highest_primary_identifier': 'query',
                    'page_size': 'query',
                    'retain_until__gte': 'query',
                    'retain_until__is_null': 'query',
                    'retain_until__isnull': 'query',
                    'retain_until__lte': 'query',
                    'scheme': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photo_identifiers_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (PhotoIdentifier,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photo-identifiers/{id}',
                'operation_id': 'v1beta1_photo_identifiers_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photo_identifiers_update_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photo-identifiers/{id}',
                'operation_id': 'v1beta1_photo_identifiers_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'action',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'action',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('action',): {

                        "HARD_DELETE": "hard_delete",
                        "REPAIR": "repair",
                        "RESTORE": "restore",
                        "SOFT_DELETE": "soft_delete"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'action':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'action': 'action',
                },
                'location_map': {
                    'id': 'path',
                    'action': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photo_identifiers_update_update_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photo-identifiers/update',
                'operation_id': 'v1beta1_photo_identifiers_update_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'photo_identifier_bulk_update_request_request',
                ],
                'required': [
                    'photo_identifier_bulk_update_request_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'photo_identifier_bulk_update_request_request':
                        (PhotoIdentifierBulkUpdateRequestRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'photo_identifier_bulk_update_request_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.v1beta1_photos_content_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photos/{id}/content',
                'operation_id': 'v1beta1_photos_content_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'image/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photos_create_endpoint = _Endpoint(
            settings={
                'response_type': (V1Beta1Photo,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photos',
                'operation_id': 'v1beta1_photos_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'identifiers',
                    'status',
                    'body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "APPROVED": "APPROVED",
                        "INVALIDATED": "INVALIDATED",
                        "UNAPPROVED": "UNAPPROVED"
                    },
                },
                'openapi_types': {
                    'identifiers':
                        (str,),
                    'status':
                        (str,),
                    'body':
                        (file_type,),
                },
                'attribute_map': {
                    'identifiers': 'identifiers',
                    'status': 'status',
                },
                'location_map': {
                    'identifiers': 'query',
                    'status': 'query',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'image/heic',
                    'image/heif',
                    'image/jpeg',
                    'image/png'
                ]
            },
            api_client=api_client
        )
        self.v1beta1_photos_destroy_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photos/{id}',
                'operation_id': 'v1beta1_photos_destroy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'reason',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'reason':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'reason': 'reason',
                },
                'location_map': {
                    'id': 'path',
                    'reason': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photos_list_endpoint = _Endpoint(
            settings={
                'response_type': ([V1Beta1Photo],),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photos',
                'operation_id': 'v1beta1_photos_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'identifier',
                    'status',
                ],
                'required': [
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "APPROVED": "APPROVED",
                        "INVALIDATED": "INVALIDATED",
                        "UNAPPROVED": "UNAPPROVED"
                    },
                },
                'openapi_types': {
                    'identifier':
                        (str,),
                    'status':
                        (str,),
                },
                'attribute_map': {
                    'identifier': 'identifier',
                    'status': 'status',
                },
                'location_map': {
                    'identifier': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photos_no_primary_identifier_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedV1Beta1PhotoList,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photos/no-primary-identifier',
                'operation_id': 'v1beta1_photos_no_primary_identifier_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cursor',
                    'page_size',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cursor':
                        (str,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'cursor': 'cursor',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'cursor': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photos_original_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photos/{id}/original',
                'operation_id': 'v1beta1_photos_original_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'image/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photos_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (V1Beta1Photo,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photos/{id}',
                'operation_id': 'v1beta1_photos_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'identifiers',
                    'postpone_review',
                    'status',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "APPROVED": "APPROVED",
                        "INVALIDATED": "INVALIDATED"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'identifiers':
                        (str,),
                    'postpone_review':
                        (bool,),
                    'status':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'identifiers': 'identifiers',
                    'postpone_review': 'postponeReview',
                    'status': 'status',
                },
                'location_map': {
                    'id': 'path',
                    'identifiers': 'query',
                    'postpone_review': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photos_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (V1Beta1Photo,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photos/{id}',
                'operation_id': 'v1beta1_photos_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_photos_thumbnail_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/photos/{id}/thumbnail',
                'operation_id': 'v1beta1_photos_thumbnail_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'image/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1beta1_unapproved_photos_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedV1Beta1PhotoList,),
                'auth': [
                    'apiGatewayAuthorizationCodeSecurityScheme',
                    'apiGatewayClientCredentialsSecurityScheme'
                ],
                'endpoint_path': '/v1beta1/unapproved-photos',
                'operation_id': 'v1beta1_unapproved_photos_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cursor',
                    'page_size',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cursor':
                        (str,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'cursor': 'cursor',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'cursor': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def v1beta1_all_photos_list(
        self,
        **kwargs
    ):
        """List all photos  # noqa: E501

         # List all Photos  This endpoint allows information and metadata about all Photos to be fetched.  Results are ordered by `createdAt` ascending, and may be split over multiple 'pages'. Where more results exist a `next` URL will be provided which can be used to fetch the next page of results. The `previous` URL can be used to navigate backwards through the result pages. The `pageSize` query parameter can be used to request a specific amount of results per page. If not provided the `pageSize` is set to `200`. The amount of results per page is limited to `500`, if a number greater than `500` is specified in the `pageSize` parameter no error is returned but the number of results will be capped at 500 per page.  Only principals with the `PHOTO_ADMIN` permission can list all photos.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_all_photos_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cursor (str): The pagination cursor value.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedV1Beta1PhotoList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.v1beta1_all_photos_list_endpoint.call_with_http_info(**kwargs)

    def v1beta1_approved_photos_content_retrieve(
        self,
        identifier,
        **kwargs
    ):
        """Get the image content of an approved photo using a person identifier  # noqa: E501

         # Get image content of an approved Photo  This endpoint redirects to the image content of the single, most recently approved, Photo for the given PhotoIdentifier.  The PhotoIdentifier should be included in the URL params in the format `<value>@<scheme>` - see the introduction to this API for a list of supported schemes. If the scheme is not provided it is assumed to be a CRSid (v1.person.identifiers.cam.ac.uk).  A given PhotoIdentifier may link to many approved Photos, in which case the most recently approved Photo is returned here. If a PhotoIdentifier does not link to an approved Photo a `404` response will be returned.  The Photo returned may change over time if a new Photo is approved for a given PhotoIdentifier. If you want to keep a reference to an exact Photo you can use the Photo's `id` (the UUID), or `contentLink` of the Photo returned from the `Get approved Photo` endpoint above, which is guaranteed to always give back the same Photo, regardless of whether a new Photo is approved for a given PhotoIdentifier.  This endpoint redirects to a temporary URL provided by the storage service used by this API. This temporary URL will expire after a short period of time and therefore should not be recorded or used as a permanent reference to this Photo.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_approved_photos_content_retrieve(identifier, async_req=True)
        >>> result = thread.get()

        Args:
            identifier (str): The PhotoIdentifier to get an approved photo for in the format `<value>@<scheme>`

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['identifier'] = \
            identifier
        return self.v1beta1_approved_photos_content_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_approved_photos_content_transient_url_retrieve(
        self,
        identifier,
        **kwargs
    ):
        """Get the transient url of the content of this approved photo  # noqa: E501

         # Get transient URL of the content of an approved Photo  This endpoint returns a transient URL which can be used to fetch the most recently approved Photo's content for a PhotoIdentifier.  The PhotoIdentifier should be included in the URL params in the format `<value>@<scheme>` - see the introduction to this API for a list of supported schemes. If the scheme is not provided it is assumed to be a CRSid (v1.person.identifiers.cam.ac.uk).  A given PhotoIdentifier may link to many approved Photos, in which case the most recently approved Photo is returned here. If a PhotoIdentifier does not link to an approved Photo a `404` response will be returned.  The Photo returned may change over time if a new Photo is approved for a given PhotoIdentifier. If you want to keep a reference to an exact Photo you can use the Photo's `id` (the UUID), or `contentLink` of the Photo returned from the `Get approved Photo` endpoint above, which is guaranteed to always give back the same Photo, regardless of whether a new Photo is approved for a given PhotoIdentifier.  This endpoint returns both a publicly accessible URL and the expiry time of that URL in seconds.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_approved_photos_content_transient_url_retrieve(identifier, async_req=True)
        >>> result = thread.get()

        Args:
            identifier (str): The PhotoIdentifier to get an approved photo for in the format `<value>@<scheme>`

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransientImageUrl
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['identifier'] = \
            identifier
        return self.v1beta1_approved_photos_content_transient_url_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_approved_photos_list(
        self,
        approved_since,
        **kwargs
    ):
        """List approved photos  # noqa: E501

         # List approved Photos  Return list of approved photos.  This endpoint allows information and metadata about approved Photos to be fetched. Approved photos must be filtered by approvedSince - which returns only photos which have been approved after a given point in time. This is to allow for incremental export of data, where the approvedSince can be specified as the point of the last export and only an increment of approved photo data queried.  Results are ordered by `approvedAt` ascending and may be split over multiple 'pages'. Where more results exist a `next` URL will be provided which can be used to fetch the next page of results. The `previous` URL can be used to navigate backwards through the result pages. The `pageSize` query parameter can be used to request a specific amount of results per page. If not provided the `pageSize` is set to `200`. The amount of results per page is limited to `500`, if a number greater than `500` is specified in the `pageSize` parameter no error is returned but the number of results will be capped at 500 per page.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_approved_photos_list(approved_since, async_req=True)
        >>> result = thread.get()

        Args:
            approved_since (str): Specify the earliest datetime at which approved photos should be returned in ISO datetime format.

        Keyword Args:
            cursor (str): The pagination cursor value.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedV1Beta1PhotoList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['approved_since'] = \
            approved_since
        return self.v1beta1_approved_photos_list_endpoint.call_with_http_info(**kwargs)

    def v1beta1_approved_photos_retrieve(
        self,
        identifier,
        **kwargs
    ):
        """Get an approved photo of a person using a person identifier  # noqa: E501

         # Get approved Photo  Return the single, most recently approved, photo for a given PhotoIdentifier.  This endpoint allows information and metadata about an approved Photo to be fetched using a PhotoIdentifier. The PhotoIdentifier should be included in the URL params in the format `<value>@<scheme>` - see the introduction to this API for a list of supported schemes. If the scheme is not provided it is assumed to be a CRSid (v1.person.identifiers.cam.ac.uk).  A given PhotoIdentifier may link to many approved Photos, in which case the most recently approved Photo is returned here. If a PhotoIdentifier does not link to an approved Photo a `404` response is returned.  The Photo returned may change over time if a new Photo is approved for a given PhotoIdentifier. If you want to keep a reference to an exact Photo, you can use the Photo's `id` (the UUID), or `selfLink` returned to directly reference an instance of an immutable Photo.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_approved_photos_retrieve(identifier, async_req=True)
        >>> result = thread.get()

        Args:
            identifier (str): The PhotoIdentifier to get an approved photo for in the format `<value>@<scheme>`

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            V1Beta1Photo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['identifier'] = \
            identifier
        return self.v1beta1_approved_photos_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_approved_photos_thumbnail_retrieve(
        self,
        identifier,
        **kwargs
    ):
        """Get the thumbnail of an approved photo using a person identifier  # noqa: E501

         # Get thumbnail of an approved Photo  This endpoint redirects to the thumbnail of the most recently approved Photo for the given PhotoIdentifier.  This thumbnail is guaranteed to be smaller than 128x128 pixels and will be in png format.  The documentation for the `Get image content of an approved Photo` additionally applies to this endpoint, as all constraints are the same between the two endpoints.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_approved_photos_thumbnail_retrieve(identifier, async_req=True)
        >>> result = thread.get()

        Args:
            identifier (str): The PhotoIdentifier to get an approved photo for in the format `<value>@<scheme>`

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['identifier'] = \
            identifier
        return self.v1beta1_approved_photos_thumbnail_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_approved_photos_thumbnail_transient_url_retrieve(
        self,
        identifier,
        **kwargs
    ):
        """Get the transient url of an the thumbnail of an approved photo using a person identifier  # noqa: E501

         # Get transient URL of the thumbnail of an approved Photo  This endpoint returns a transient URL which can be used to fetch the most recently approved Photo's thumbnail for a given PhotoIdentifier.  This endpoint returns both a publically accessible URL and the expiry time of that URL in seconds.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_approved_photos_thumbnail_transient_url_retrieve(identifier, async_req=True)
        >>> result = thread.get()

        Args:
            identifier (str): The PhotoIdentifier to get an approved photo for in the format `<value>@<scheme>`

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransientImageUrl
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['identifier'] = \
            identifier
        return self.v1beta1_approved_photos_thumbnail_transient_url_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photo_identifiers_destroy(
        self,
        id,
        **kwargs
    ):
        """Remove a photo identifier and associated photos by photo identifier UUID.  # noqa: E501

         ## Remove photo identifier  This method allows a client to remove a photo identifier and in the process delete all associated identifiers and photos.  ### Permissions  Principals with the `PHOTO_ADMIN` permission are able to affect this endpoint.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photo_identifiers_destroy(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this photo identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.v1beta1_photo_identifiers_destroy_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photo_identifiers_list(
        self,
        **kwargs
    ):
        """List photo identifiers  # noqa: E501

         ## List photo identifiers  Returns a list of photo identifiers associated with the photos.  ### Permissions  Principals with the `PHOTO_VIEWER` permission are able to view all photo identifiers contained within the photo system.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photo_identifiers_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cursor (str): The pagination cursor value.. [optional]
            deleted_at__gte (str): Filter deletedAt by IsoDateTime greater than. [optional]
            deleted_at__is_null (bool): Filter deletedAt by IsoDateTime is Null. [optional]
            deleted_at__isnull (bool): [optional]
            deleted_at__lte (str): Filter deletedAt by IsoDateTime less than. [optional]
            identifier (str): PhotoIdentifier to get photos for using format `<value>@<scheme>`. [optional]
            is_deleted (bool): Filter isDeleted. [optional]
            is_highest_primary_identifier (bool): Filter is_highest_primary_identifier. [optional]
            page_size (int): Number of results to return per page.. [optional]
            retain_until__gte (str): Filter retainUntil by IsoDateTime greater than. [optional]
            retain_until__is_null (bool): Filter retainUntil by IsoDateTime is Null. [optional]
            retain_until__isnull (bool): [optional]
            retain_until__lte (str): Filter retainUntil by IsoDateTime less than. [optional]
            scheme (str): PhotoIdentifier scheme to get photos for using format `<scheme>`. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedV1Beta1PhotoIdentifierSummaryList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.v1beta1_photo_identifiers_list_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photo_identifiers_retrieve(
        self,
        id,
        **kwargs
    ):
        """Get a photo identifier by identifier UUID.  # noqa: E501

         ## Get photo identifier detail  Allows the detail of a single Photo Identifier to be retrieved by UUID. The Photo Identifier entity returned contains the information as presented in the list operation above plus additional fields.  ### Permissions  Principals with the `PHOTO_VIEWER` permission are able to view the photo identifier detail of any photo identifier contained within the photo system.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photo_identifiers_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this photo identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PhotoIdentifier
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.v1beta1_photo_identifiers_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photo_identifiers_update(
        self,
        id,
        **kwargs
    ):
        """Update a photo identifier by photo identifier UUID.  # noqa: E501

         ## Update the photo identifier  This method allows a client to submit an action in the request query for a given photo identifier. The allowed actions are `repair`, `restore`, `soft_delete` and `hard_delete`.  ### Permissions  Principals with the `CARD_ADMIN` permission will be able to affect this endpoint.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photo_identifiers_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this photo identifier.

        Keyword Args:
            action (str): Action applied to the photo identifier.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.v1beta1_photo_identifiers_update_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photo_identifiers_update_update(
        self,
        photo_identifier_bulk_update_request_request,
        **kwargs
    ):
        """Bulk update photo identifiers by photo identifier UUID.  # noqa: E501

         ## Bulk update the photo identifier  This method allows a client to submit a list of photo identifiers and corresponding action to apply to the photo identifier. The allowed actions are `repair`, `restore`, `soft_delete` and `hard_delete`.  ### Permissions  Principals with the `CARD_ADMIN` permission will be able to affect this endpoint.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photo_identifiers_update_update(photo_identifier_bulk_update_request_request, async_req=True)
        >>> result = thread.get()

        Args:
            photo_identifier_bulk_update_request_request (PhotoIdentifierBulkUpdateRequestRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['photo_identifier_bulk_update_request_request'] = \
            photo_identifier_bulk_update_request_request
        return self.v1beta1_photo_identifiers_update_update_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photos_content_retrieve(
        self,
        id,
        **kwargs
    ):
        """Get the image content of a photo by photo UUID  # noqa: E501

         # Get Photo content  This endpoint redirects to the image content of a Photo by Photo `id`. Note that this `id` is the UUID field included on a Photo, not a PhotoIdentifier. To get the Photo content for an identifier either filter for a Photo by PhotoIdentifier using the `Get Photo List by PhotoIdentifier` endpoint above and then call this endpoint with the Photo's `id` field, or use the `Get image content of an approved Photo` endpoint documented above if you only want to fetch approved Photos.  Unlike the `Get image content of an approved Photo` which may return a different images if a new Photo is approved, this endpoint will always return the same Photo content for a given Photo UUID.  This endpoint redirects to a temporary URL provided by the storage service used by this API. This temporary URL will expire after a short period of time and therefore should not be recorded or used as a permanent reference to this Photo.  This endpoint will return a `404` status code if a Photo cannot be found by the UUID provided.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photos_content_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this photo.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.v1beta1_photos_content_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photos_create(
        self,
        **kwargs
    ):
        """Create a new photo with a set of identifiers  # noqa: E501

         # Create a new Photo  This endpoint allows a new photo to be created and associated with a given set of PhotoIdentifiers.  At present only principals with the `PHOTO_CREATOR` permission are granted access to create new photos.  The image should be provided as a file upload on the request body and should be in any of the following formats:  * image/png, * image/jpeg, * image/heic, * image/heif,  Images should be at minimum 640 x 480 pixels, maximum 124174999 total pixels, and should not exceed 10MB in file size.  If the principal has the permission `PHOTO_CREATOR`, a list of PhotoIdentifiers for the person represented by a given photo can be provided on the request's query parameters in the `<value>@<scheme>` format, with each PhotoIdentifier separated by a comma. This is to allow an authorized client to create photos of other members of the University, linking a photo to an identity record held in another service. If PhotoIdentifiers are not provided, a PhotoIdentifier with the current principal's CRSid as the value and 'v1.person.identifiers.cam.ac.uk' as the scheme will be attached to the photo, as it is assumed that the given photo represents the current principal.  Principals with the `PHOTO_REVIEWER` permission can additionally provide the `status` query parameter which allows the photo to either be set as `APPROVED` or `UNAPPROVED`. If not provided or the principal does not have the `PHOTO_REVIEWER` permission the photo's status will be `UNAPPROVED`.  When a photo is created with the `UNAPPROVED` status, any existing photos with the `UNAPPROVED` status that match the PhotoIdentifiers provided on the request's query parameters will be deleted from the Photo API, with the photos no longer being available for query from the API.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photos_create(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            identifiers (str): A comma (urlencoded as `%2C`) separated list of identifiers in the format `<value>@<scheme>` to attach to this photo. Only principals with `PHOTO_CREATOR` permission are permitted to specify identifiers. If identifiers are provided by a client without the `PHOTO_CREATOR` permission a Forbidden (403) response will be returned.. [optional]
            status (str): The status of this photo. Only principals with the `PHOTO_REVIEWER` permission can set the status to `APPROVED`. Defaults to `UNAPPROVED`.. [optional]
            body (file_type): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            V1Beta1Photo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.v1beta1_photos_create_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photos_destroy(
        self,
        id,
        **kwargs
    ):
        """Remove a photo  # noqa: E501

         # Remove a photo by UUID  This endpoint allows an unapproved photo to be deleted from the Photo API, with the photo no longer being available for query from the API. Removing a photo is not reversible, once a photo has been removed it cannot be restored.  Only principals with the `PHOTO_REVIEWER` permission can remove photos.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photos_destroy(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this photo.

        Keyword Args:
            reason (str): The reason the photo was rejected, to be sent to the photo uploader in an email.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.v1beta1_photos_destroy_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photos_list(
        self,
        identifier,
        **kwargs
    ):
        """Get the photos related to a given photo identifier  # noqa: E501

         # Get Photo List by PhotoIdentifier  This endpoint returns the details and metadata of all Photos related to a given PhotoIdentifier. This endpoint will return all Photos regardless of whether they have been approved - so Photos returned are not guaranteed to be good quality.  The PhotoIdentifier should be provided on the query string in the format of `<value>@<scheme>`, see the introduction to this API for a list of supported schemes. If the scheme is not provided the it is assumed to be a CRSid (v1.person.identifiers.cam.ac.uk).  By default all Photos related to a given PhotoIdentifier are included in the responses. Photos can be filtered by `status` using the `status` query parameter.  Each Photo contains a link to the content and thumbnail which can be used to fetch the content of the Photo itself.  If no Photos can be found for a given identifier an empty array will be returned.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photos_list(identifier, async_req=True)
        >>> result = thread.get()

        Args:
            identifier (str): PhotoIdentifier to get photos for using format `<value>@<scheme>`

        Keyword Args:
            status (str): Photo status to filter by (defaults to all statuses). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [V1Beta1Photo]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['identifier'] = \
            identifier
        return self.v1beta1_photos_list_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photos_no_primary_identifier_list(
        self,
        **kwargs
    ):
        """Get list of all photos missing a primary identifier  # noqa: E501

         # Get a list of photos without a primary identifier (CRSid)  This endpoint returns a list of all photos which do not have an associated PhotoIdentifier with the CRSid scheme. This endpoint will return all Photos regardless of whether they have been approved - so Photos returned are not guaranteed to be good quality.  Each Photo contains a link to the content and thumbnail which can be used to fetch the content of the Photo itself.  If no Photos are found without CRSids an empty array will be returned.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photos_no_primary_identifier_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cursor (str): The pagination cursor value.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedV1Beta1PhotoList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.v1beta1_photos_no_primary_identifier_list_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photos_original_retrieve(
        self,
        id,
        **kwargs
    ):
        """Get the original (uncropped) image uploaded when this photo was created  # noqa: E501

         # Get Photo original  This endpoint redirects to the original version of a Photo (as uploaded) by UUID.  This image will be uncropped and in whatever format was originally uploaded.  This endpoint redirects to a temporary URL provided by the storage service used by this API. This temporary URL will expire after a short period of time and therefore should not be recorded or used as a permanent reference to this Photo.  This endpoint will return a `404` status code if a Photo cannot be found by the UUID provided or if the original image is not available - which will be the case for photos synced from the legacy card system.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photos_original_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this photo.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.v1beta1_photos_original_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photos_partial_update(
        self,
        id,
        **kwargs
    ):
        """Update a photo  # noqa: E501

         # Update a photo by UUID  This endpoint allows a photo to be updated from the Photo API. The modifications that can be made are: to approve an unapproved photo by changing the `status` of the photo to the value `APPROVED`, and to modify the list of PhotoIdentifiers associated with the photo.  Only principals with the `PHOTO_REVIEWER` permission can set the status of photos. Only principals with the `PHOTO_ADMIN` permission can set the PhotoIdentifiers associated with the photo.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photos_partial_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this photo.

        Keyword Args:
            identifiers (str): A comma (urlencoded as `%2C`) separated list of identifiers in the format `<value>@<scheme>` to attach to this photo. Only principals with `PHOTO_REVIEWER` permission are permitted to change a photo's identifiers. If identifiers are updated by a client without the `PHOTO_REVIEWER` permission a Forbidden (403) response will be returned.. [optional]
            postpone_review (bool): If set to true, postpone the review of this photo.. [optional]
            status (str): The status to assign to this photo. This can be `APPROVED` or `INVALIDATED` and only principals with the `PHOTO_REVIEWER` permission  can set this status.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            V1Beta1Photo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.v1beta1_photos_partial_update_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photos_retrieve(
        self,
        id,
        **kwargs
    ):
        """Get a photo by photo UUID  # noqa: E501

         # Get Photo  This endpoint returns the details and metadata for a single Photo by Photo `id`. Note that this `id` is the UUID field included on a Photo, not a PhotoIdentifier. To get Photos related to a PhotoIdentifier use the `Get Photo List by PhotoIdentifier` endpoint documented above.  This endpoint will return a `404` status code if a Photo cannot be found by the UUID provided.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photos_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this photo.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            V1Beta1Photo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.v1beta1_photos_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_photos_thumbnail_retrieve(
        self,
        id,
        **kwargs
    ):
        """Get the thumbnail of a photo by photo UUID  # noqa: E501

         # Get Photo thumbnail  This endpoint redirects to the thumbnail of a Photo by UUID.  This thumbnail is guaranteed to be smaller than 128x128 pixels and will be in png format.  The documentation for the `Get Photo content` additionally applies to this endpoint, as all constraints are the same between the two endpoints.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_photos_thumbnail_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): A UUID string identifying this photo.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.v1beta1_photos_thumbnail_retrieve_endpoint.call_with_http_info(**kwargs)

    def v1beta1_unapproved_photos_list(
        self,
        **kwargs
    ):
        """List unapproved photos  # noqa: E501

         # List unapproved Photos  This endpoint allows information and metadata about all unapproved Photos to be fetched.  Results are ordered by `createdAt` ascending, and may be split over multiple 'pages'. Where more results exist a `next` URL will be provided which can be used to fetch the next page of results. The `previous` URL can be used to navigate backwards through the result pages. The `pageSize` query parameter can be used to request a specific amount of results per page. If not provided the `pageSize` is set to `200`. The amount of results per page is limited to `500`, if a number greater than `500` is specified in the `pageSize` parameter no error is returned but the number of results will be capped at 500 per page.  Only principals with the `PHOTO_REVIEWER` permission can list all unapproved photos.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1beta1_unapproved_photos_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cursor (str): The pagination cursor value.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedV1Beta1PhotoList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.v1beta1_unapproved_photos_list_endpoint.call_with_http_info(**kwargs)

