"""
    University Student API

    This API exposes identity information about university students. The purpose of this API is to give access to basic identity information about university students for use by downstream systems, therefore the data exposed is limited to basic information about who a student is and which institutions they are affiliated with.  This API uses the following identifiers to link people to person-records held within different systems:  * `person.v1.student-records.university.identifiers.cam.ac.uk` - the university student (ust) identifier of this person -   also referred to as USN  Additionally this API uses the following identifiers to link people to institutions or entities which a person may have an affiliation to:  * `institution.v1.student-records.university.identifiers.cam.ac.uk` - the university student (ust) institution identifier.     This encompasses colleges, departments and faculties. The     [CamSIS Coding Manual](https://www.camsis.cam.ac.uk/technical/camsis-coding-manual)     lists the available values for this affiliation (under A01 and M01). * `academic-plan.v1.student-records.university.identifiers.cam.ac.uk` - the university student (ust) academic plan     identifier. The     [CamSIS Coding Manual](https://www.camsis.cam.ac.uk/technical/camsis-coding-manual)     lists the available values for this affiliation (under D07).  Both affiliations provide a `status` field which indicate a student's status within an affiliated entity. This `status` field is the short representation of the academic career field held in CamSIS. The [CamSIS Coding Manual](https://www.camsis.cam.ac.uk/technical/camsis-coding-manual) lists the available values for the `status` field (under D05).  This API is currently backed by data from CamSIS, exposing a view of data that is refreshed nightly.    # noqa: E501

    The version of the OpenAPI document: v1alpha2
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from identitylib.student_client.api_client import ApiClient, Endpoint as _Endpoint
from identitylib.student_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from identitylib.student_client.model.http_exception import HTTPException
from identitylib.student_client.model.http_validation_error import HTTPValidationError
from identitylib.student_client.model.paginated_results_student import PaginatedResultsStudent
from identitylib.student_client.model.student import Student


class StudentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_v1alpha2_student_students_identifier_get_endpoint = _Endpoint(
            settings={
                'response_type': (Student,),
                'auth': [
                    'ApiGatewayOAuthClientCredentials'
                ],
                'endpoint_path': '/students/{identifier}',
                'operation_id': 'get_v1alpha2_student_students_identifier_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'identifier',
                ],
                'required': [
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'identifier':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'identifier': 'identifier',
                },
                'location_map': {
                    'identifier': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_v1alpha2_recent_graduates_recent_graduates_get_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedResultsStudent,),
                'auth': [
                    'ApiGatewayOAuthClientCredentials'
                ],
                'endpoint_path': '/recent-graduates',
                'operation_id': 'list_v1alpha2_recent_graduates_recent_graduates_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'affiliation',
                    'cursor',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'affiliation':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'cursor':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'affiliation': 'affiliation',
                    'cursor': 'cursor',
                },
                'location_map': {
                    'affiliation': 'query',
                    'cursor': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_v1alpha2_students_students_get_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedResultsStudent,),
                'auth': [
                    'ApiGatewayOAuthClientCredentials'
                ],
                'endpoint_path': '/students',
                'operation_id': 'list_v1alpha2_students_students_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'affiliation',
                    'cursor',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'affiliation':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'cursor':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'affiliation': 'affiliation',
                    'cursor': 'cursor',
                },
                'location_map': {
                    'affiliation': 'query',
                    'cursor': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_v1alpha2_student_students_identifier_get(
        self,
        identifier,
        **kwargs
    ):
        """Get a single student  # noqa: E501

        Returns a single student based on the identifier provided. The identifier can be provided in the format `<value>@<scheme>`, if the scheme is omitted it shall be assumed that the scheme is `person.v1.student-records.university.identifiers.cam.ac.uk` (also know as the USN).   Currently this endpoint only supports querying by `person.v1.student-records.university.identifiers.cam.ac.uk` identifiers, but may be extended to allow querying by additional identifier schemes in future.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_v1alpha2_student_students_identifier_get(identifier, async_req=True)
        >>> result = thread.get()

        Args:
            identifier (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Student
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['identifier'] = \
            identifier
        return self.get_v1alpha2_student_students_identifier_get_endpoint.call_with_http_info(**kwargs)

    def list_v1alpha2_recent_graduates_recent_graduates_get(
        self,
        **kwargs
    ):
        """List students who have completed a course within the last six months  # noqa: E501

        Returns students who have ended their affiliation with an institution or academic plan within the last six months, indicating that they have recently completed their studies. This is to allow downstream systems access to data on students who may in-practice continue to have an affiliation with the University, even though their course has technically ended.  Affiliations populated on each recent graduate are limited to the affiliations which have ended within the last six months. Graduates may have additional affiliations which are not represented here. These affiliations can be accessed by querying the `/students` endpoint.  Students who have either been removed or withdrawn from a course are not returned.  To avoid returning very large responses, this endpoint produces a paged response. Where there are additional results which cannot be returned on a single page, a `next` field will be populated with a url containing the next page of results. These `next` urls should be followed until a page is returned with no `next` field, indicating that there are no further results. Each page returned will hold a maximum of 1000 results.  Graduates can be filtered by affiliation, by providing an `affiliation` query parameter. This affiliation should be provided in the format `<value>@<scheme>`. Graduates will only be returned if their affiliation with an institution or academic plan has ended within the last six months.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_v1alpha2_recent_graduates_recent_graduates_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            affiliation (bool, date, datetime, dict, float, int, list, str, none_type): An affiliation to filter by, in the format `<value>@<scheme>`. When included only graduates with a matching affiliation are returned.. [optional]
            cursor (bool, date, datetime, dict, float, int, list, str, none_type): The cursor indicating a unique page of results - this should be auto generated on the `next` and `previous` fields and does not need to be manually added / updated.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedResultsStudent
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_v1alpha2_recent_graduates_recent_graduates_get_endpoint.call_with_http_info(**kwargs)

    def list_v1alpha2_students_students_get(
        self,
        **kwargs
    ):
        """List students  # noqa: E501

        Lists all students held within the University Student management system, allowing basic filtering by affiliation.  To avoid returning very large responses, this endpoint produces a paged response. Where there are additional results which cannot be returned on a single page, a `next` field will be populated with a url containing the next page of results. These `next` urls should be followed until a page is returned with no `next` field, indicating that there are no further results. Each page returned will hold a maximum of 1000 results.  Students can be filtered by affiliation, by providing an `affiliation` query parameter. This affiliation should be provided in the format `<value>@<scheme>`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_v1alpha2_students_students_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            affiliation (bool, date, datetime, dict, float, int, list, str, none_type): An affiliation to filter by, in the format `<value>@<scheme>`. When included only the students with a matching affiliation are returned.. [optional]
            cursor (bool, date, datetime, dict, float, int, list, str, none_type): The cursor indicating a unique page of results - this should be auto generated on the `next` and `previous` fields and does not need to be manually added / updated.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedResultsStudent
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_v1alpha2_students_students_get_endpoint.call_with_http_info(**kwargs)

