INTERESTING_PARAMETERS = {
    "Mass Parameters": ["mass_1", "mass_2", "chirp_mass", "mass_ratio"],
    "Spin Parameters": ["a_1", "a_2", "tilt_1", "tilt_2", "chi_eff", "chi_p"],
    "Localisation Parameters": [
        "ra",
        "dec",
        "geocent_time",
        "luminosity_distance",
    ],
    "Other Parameters": [
        "phase",
        "azimuth",
        "zenith",
        "psi",
        "phi_jl",
        "phi_12",
        "theta_jn",
    ],
    "Remnant Parameters": ["final_mass", "final_spin", "final_kick"],
}


CATALOG_MAIN_COLOR = "tab:orange"

LATEX_LABELS = dict(
    mass_1=r"$m_1\ [M_{\odot}]$",
    mass_2=r"$m_2\ [M_{\odot}]$",
    chirp_mass=r"$\mathcal{M}\ [M_{\odot}]$",
    mass_ratio=r"$q$",
    a_1=r"$a_1$",
    a_2=r"$a_2$",
    tilt_1=r"$\theta_1$",
    tilt_2=r"$\theta_2$",
    chi_eff=r"$\chi_{\mathrm{eff}}$",
    chi_p=r"$\chi_{\mathrm{p}}$",
    ra=r"$\alpha$",
    dec=r"$\delta$",
    geocent_time=r"$t_c\ [s]$",
    luminosity_distance=r"$d_L\ [Mpc]$",
    phase=r"$\phi$",
    azimuth=r"$\phi$",
    zenith=r"$\theta$",
    psi=r"$\psi$",
    phi_jl=r"$\phi_{\mathrm{JL}}$",
    phi_12=r"$\phi_{12}$",
    theta_jn=r"$\theta_{\mathrm{JN}}$",
    final_mass=r"$m_f\ [M_{\odot}]$",
    final_spin=r"$\chi_f$",
    final_kick=r"$v_{\rm kick}\ [{\rm km/s}]$",
)


LOG_PARAMS = ["mass_1", "mass_2"]
