from typing import Final

LETTERS_TO_LONG_BRANC_MAPPING: Final = {
    "a": "ᛅ",
    "á": "ᛅ",
    "b": "ᛒ",
    "c": "ᛋ",
    "d": "ᛏ",
    "ð": "ᚦ",
    "e": "ᛁ",
    "é": "ᛁ",
    "f": "ᚠ",
    "g": "ᚴ",
    "h": "ᚼ",
    "i": "ᛁ",
    "í": "ᛁ",
    "j": "ᛁ",
    "k": "ᚴ",
    "l": "ᛚ",
    "m": "ᛘ",
    "n": "ᚾ",
    "o": "ᚢ",
    "ó": "ᚢ",
    "p": "ᛒ",
    "q": "ᚴ",
    "r": "ᚱ",
    "s": "ᛋ",
    "t": "ᛏ",
    "þ": "ᚦ",
    "u": "ᚢ",
    "ú": "ᚢ",
    "v": "ᚢ",
    "w": "ᚢ",
    "x": "ᛋ",
    "y": "ᚢ",
    "ý": "ᚢ",
    "z": "ᛋ",
    "å": "ᚢ",
    "ä": "ᛅ",
    "æ": "ᛅ",
    "ö": "ᚢ",
    "ø": "ᚢ",
    "ǫ": "ᚢ",
    " ": ":",
}

LETTERS_TO_SHORT_TWIG_MAPPING: Final = {
    "a": "ᛆ",
    "á": "ᛆ",
    "b": "ᛒ",
    "c": "ᛌ",
    "d": "ᛐ",
    "ð": "ᚦ",
    "e": "ᛁ",
    "é": "ᛁ",
    "f": "ᚠ",
    "g": "ᚴ",
    "h": "ᚽ",
    "i": "ᛁ",
    "í": "ᛁ",
    "j": "ᛁ",
    "k": "ᚴ",
    "l": "ᛚ",
    "m": "ᛘ",
    "n": "ᚿ",
    "o": "ᚢ",
    "ó": "ᚢ",
    "p": "ᛒ",
    "q": "ᚴ",
    "r": "ᚱ",
    "s": "ᛌ",
    "t": "ᛐ",
    "þ": "ᚦ",
    "u": "ᚢ",
    "ú": "ᚢ",
    "v": "ᚢ",
    "w": "ᚢ",
    "x": "ᛌ",
    "y": "ᚢ",
    "ý": "ᚢ",
    "z": "ᛌ",
    "å": "ᚢ",
    "ä": "ᛆ",
    "æ": "ᛆ",
    "ö": "ᚢ",
    "ø": "ᚢ",
    "ǫ": "ᚢ",
    " ": ":",
}


def get_letter_mapping() -> dict[str, str]:
    return get_letters_to_long_branch_mapping()


def get_letters_to_long_branch_mapping() -> dict[str, str]:
    return LETTERS_TO_LONG_BRANC_MAPPING


def get_letters_to_short_twig_mapping() -> dict[str, str]:
    return LETTERS_TO_SHORT_TWIG_MAPPING
