"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.MetricsLevel = exports.LogLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Available log levels for Flink applications.
 */
var LogLevel;
(function (LogLevel) {
    /** Debug level logging */
    LogLevel["DEBUG"] = "DEBUG";
    /** Info level logging */
    LogLevel["INFO"] = "INFO";
    /** Warn level logging */
    LogLevel["WARN"] = "WARN";
    /** Error level logging */
    LogLevel["ERROR"] = "ERROR";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
/**
 * Granularity of metrics sent to CloudWatch.
 */
var MetricsLevel;
(function (MetricsLevel) {
    /** Application sends the least metrics to CloudWatch */
    MetricsLevel["APPLICATION"] = "APPLICATION";
    /** Task includes task-level metrics sent to CloudWatch */
    MetricsLevel["TASK"] = "TASK";
    /** Operator includes task-level and operator-level metrics sent to CloudWatch */
    MetricsLevel["OPERATOR"] = "OPERATOR";
    /** Send all metrics including metrics per task thread */
    MetricsLevel["PARALLELISM"] = "PARALLELISM";
})(MetricsLevel = exports.MetricsLevel || (exports.MetricsLevel = {}));
/**
 * Available Flink runtimes for Kinesis Analytics.
 */
class Runtime {
    constructor(value) {
        this.value = value;
    }
    /** Create a new Runtime with with an arbitrary Flink version string */
    static of(value) {
        return new Runtime(value);
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-kinesisanalytics-flink-alpha.Runtime", version: "2.63.0-alpha.0" };
/** Flink Version 1.6 */
Runtime.FLINK_1_6 = Runtime.of('FLINK-1_6');
/** Flink Version 1.8 */
Runtime.FLINK_1_8 = Runtime.of('FLINK-1_8');
/** Flink Version 1.11 */
Runtime.FLINK_1_11 = Runtime.of('FLINK-1_11');
/** Flink Version 1.13 */
Runtime.FLINK_1_13 = Runtime.of('FLINK-1_13');
/** Flink Version 1.15 */
Runtime.FLINK_1_15 = Runtime.of('FLINK-1_15');
//# sourceMappingURL=data:application/json;base64,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