# Generated by Django 4.0.1 on 2022-01-21 17:19
import uuid

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Standard',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32, unique=True)),
                ('is_public', models.BooleanField(default=True,
                                                  help_text='Indicates whether or not the standard is public or for internal use')),
            ],
        ),
        migrations.CreateModel(
            name='EconomySector',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('standard', models.ForeignKey(help_text='The standard this code is defined by.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='economy_sectors', to='economy_sectors.standard')),
                ('level', models.PositiveSmallIntegerField()),
                ('standard_label', models.CharField(max_length=256)),
                ('english_label', models.CharField(max_length=256, null=True)),
                ('code', models.CharField(help_text='Code as defined by the standard.', max_length=16)),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='economy_sectors.economysector')),
                ('top_parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='bottom_children', to='economy_sectors.economysector')),
            ],
            options={
                'unique_together': {('standard', 'code')},
            },
        ),
        migrations.CreateModel(
            name='EconomySectorRelation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('to_standard', models.ForeignKey(help_text='The standard to which the conversion is happening.', on_delete=django.db.models.deletion.CASCADE, related_name='economy_sectors_relations', to='economy_sectors.standard')),
                ('from_sector', models.ForeignKey(help_text='The economy sector we want to convert.', on_delete=django.db.models.deletion.CASCADE, related_name='relations_as_from', to='economy_sectors.economysector')),
                ('to_sector', models.ForeignKey(help_text='The corresponding sector in the required standard.', on_delete=django.db.models.deletion.CASCADE, related_name='relations_as_to', to='economy_sectors.economysector')),
            ],
            options={
                'unique_together': {('from_sector', 'to_standard', 'to_sector')},
            },
        ),
    ]
