# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetMigrationPlanResult',
    'AwaitableGetMigrationPlanResult',
    'get_migration_plan',
    'get_migration_plan_output',
]

@pulumi.output_type
class GetMigrationPlanResult:
    """
    A collection of values returned by getMigrationPlan.
    """
    def __init__(__self__, calculated_limits=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, migration_id=None, migration_plan_id=None, migration_plan_stats=None, reference_to_rms_stack=None, source_migration_plan_id=None, state=None, strategies=None, system_tags=None, target_environments=None, time_created=None, time_updated=None):
        if calculated_limits and not isinstance(calculated_limits, dict):
            raise TypeError("Expected argument 'calculated_limits' to be a dict")
        pulumi.set(__self__, "calculated_limits", calculated_limits)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if migration_id and not isinstance(migration_id, str):
            raise TypeError("Expected argument 'migration_id' to be a str")
        pulumi.set(__self__, "migration_id", migration_id)
        if migration_plan_id and not isinstance(migration_plan_id, str):
            raise TypeError("Expected argument 'migration_plan_id' to be a str")
        pulumi.set(__self__, "migration_plan_id", migration_plan_id)
        if migration_plan_stats and not isinstance(migration_plan_stats, list):
            raise TypeError("Expected argument 'migration_plan_stats' to be a list")
        pulumi.set(__self__, "migration_plan_stats", migration_plan_stats)
        if reference_to_rms_stack and not isinstance(reference_to_rms_stack, str):
            raise TypeError("Expected argument 'reference_to_rms_stack' to be a str")
        pulumi.set(__self__, "reference_to_rms_stack", reference_to_rms_stack)
        if source_migration_plan_id and not isinstance(source_migration_plan_id, str):
            raise TypeError("Expected argument 'source_migration_plan_id' to be a str")
        pulumi.set(__self__, "source_migration_plan_id", source_migration_plan_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if strategies and not isinstance(strategies, list):
            raise TypeError("Expected argument 'strategies' to be a list")
        pulumi.set(__self__, "strategies", strategies)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_environments and not isinstance(target_environments, list):
            raise TypeError("Expected argument 'target_environments' to be a list")
        pulumi.set(__self__, "target_environments", target_environments)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="calculatedLimits")
    def calculated_limits(self) -> Mapping[str, Any]:
        """
        Limits of the resources that are needed for migration. Example: {"BlockVolume": 2, "VCN": 1}
        """
        return pulumi.get(self, "calculated_limits")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the migration plan.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. It exists only for cross-compatibility. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique Oracle ID (OCID) that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> str:
        """
        The OCID of the associated migration.
        """
        return pulumi.get(self, "migration_id")

    @property
    @pulumi.getter(name="migrationPlanId")
    def migration_plan_id(self) -> str:
        return pulumi.get(self, "migration_plan_id")

    @property
    @pulumi.getter(name="migrationPlanStats")
    def migration_plan_stats(self) -> Sequence['outputs.GetMigrationPlanMigrationPlanStatResult']:
        """
        Status of the migration plan.
        """
        return pulumi.get(self, "migration_plan_stats")

    @property
    @pulumi.getter(name="referenceToRmsStack")
    def reference_to_rms_stack(self) -> str:
        """
        OCID of the referenced ORM job.
        """
        return pulumi.get(self, "reference_to_rms_stack")

    @property
    @pulumi.getter(name="sourceMigrationPlanId")
    def source_migration_plan_id(self) -> str:
        """
        Source migraiton plan ID to be cloned.
        """
        return pulumi.get(self, "source_migration_plan_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the migration plan.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def strategies(self) -> Sequence['outputs.GetMigrationPlanStrategyResult']:
        """
        List of strategies for the resources to be migrated.
        """
        return pulumi.get(self, "strategies")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetEnvironments")
    def target_environments(self) -> Sequence['outputs.GetMigrationPlanTargetEnvironmentResult']:
        """
        List of target environments.
        """
        return pulumi.get(self, "target_environments")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when the migration plan was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time when the migration plan was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMigrationPlanResult(GetMigrationPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMigrationPlanResult(
            calculated_limits=self.calculated_limits,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            migration_id=self.migration_id,
            migration_plan_id=self.migration_plan_id,
            migration_plan_stats=self.migration_plan_stats,
            reference_to_rms_stack=self.reference_to_rms_stack,
            source_migration_plan_id=self.source_migration_plan_id,
            state=self.state,
            strategies=self.strategies,
            system_tags=self.system_tags,
            target_environments=self.target_environments,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_migration_plan(migration_plan_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMigrationPlanResult:
    """
    This data source provides details about a specific Migration Plan resource in Oracle Cloud Infrastructure Cloud Migrations service.

    Gets a migration plan by identifier.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_migration_plan = oci.CloudMigrations.get_migration_plan(migration_plan_id=oci_cloud_migrations_migration_plan["test_migration_plan"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str migration_plan_id: Unique migration plan identifier
    """
    __args__ = dict()
    __args__['migrationPlanId'] = migration_plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudMigrations/getMigrationPlan:getMigrationPlan', __args__, opts=opts, typ=GetMigrationPlanResult).value

    return AwaitableGetMigrationPlanResult(
        calculated_limits=pulumi.get(__ret__, 'calculated_limits'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        migration_id=pulumi.get(__ret__, 'migration_id'),
        migration_plan_id=pulumi.get(__ret__, 'migration_plan_id'),
        migration_plan_stats=pulumi.get(__ret__, 'migration_plan_stats'),
        reference_to_rms_stack=pulumi.get(__ret__, 'reference_to_rms_stack'),
        source_migration_plan_id=pulumi.get(__ret__, 'source_migration_plan_id'),
        state=pulumi.get(__ret__, 'state'),
        strategies=pulumi.get(__ret__, 'strategies'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_environments=pulumi.get(__ret__, 'target_environments'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_migration_plan)
def get_migration_plan_output(migration_plan_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMigrationPlanResult]:
    """
    This data source provides details about a specific Migration Plan resource in Oracle Cloud Infrastructure Cloud Migrations service.

    Gets a migration plan by identifier.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_migration_plan = oci.CloudMigrations.get_migration_plan(migration_plan_id=oci_cloud_migrations_migration_plan["test_migration_plan"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str migration_plan_id: Unique migration plan identifier
    """
    ...
