# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVolumeGroupBackupsResult',
    'AwaitableGetVolumeGroupBackupsResult',
    'get_volume_group_backups',
    'get_volume_group_backups_output',
]

@pulumi.output_type
class GetVolumeGroupBackupsResult:
    """
    A collection of values returned by getVolumeGroupBackups.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, volume_group_backups=None, volume_group_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if volume_group_backups and not isinstance(volume_group_backups, list):
            raise TypeError("Expected argument 'volume_group_backups' to be a list")
        pulumi.set(__self__, "volume_group_backups", volume_group_backups)
        if volume_group_id and not isinstance(volume_group_id, str):
            raise TypeError("Expected argument 'volume_group_id' to be a str")
        pulumi.set(__self__, "volume_group_id", volume_group_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the volume group backup.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVolumeGroupBackupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="volumeGroupBackups")
    def volume_group_backups(self) -> Sequence['outputs.GetVolumeGroupBackupsVolumeGroupBackupResult']:
        """
        The list of volume_group_backups.
        """
        return pulumi.get(self, "volume_group_backups")

    @property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> Optional[str]:
        """
        The OCID of the source volume group.
        """
        return pulumi.get(self, "volume_group_id")


class AwaitableGetVolumeGroupBackupsResult(GetVolumeGroupBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeGroupBackupsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            volume_group_backups=self.volume_group_backups,
            volume_group_id=self.volume_group_id)


def get_volume_group_backups(compartment_id: Optional[str] = None,
                             display_name: Optional[str] = None,
                             filters: Optional[Sequence[pulumi.InputType['GetVolumeGroupBackupsFilterArgs']]] = None,
                             volume_group_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeGroupBackupsResult:
    """
    This data source provides the list of Volume Group Backups in Oracle Cloud Infrastructure Core service.

    Lists the volume group backups in the specified compartment. You can filter the results by volume group.
    For more information, see [Volume Groups](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/volumegroups.htm).

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_group_backups = oci.Core.get_volume_group_backups(compartment_id=var["compartment_id"],
        display_name=var["volume_group_backup_display_name"],
        volume_group_id=oci_core_volume_group["test_volume_group"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str volume_group_id: The OCID of the volume group.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['volumeGroupId'] = volume_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getVolumeGroupBackups:getVolumeGroupBackups', __args__, opts=opts, typ=GetVolumeGroupBackupsResult).value

    return AwaitableGetVolumeGroupBackupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        volume_group_backups=pulumi.get(__ret__, 'volume_group_backups'),
        volume_group_id=pulumi.get(__ret__, 'volume_group_id'))


@_utilities.lift_output_func(get_volume_group_backups)
def get_volume_group_backups_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                    display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetVolumeGroupBackupsFilterArgs']]]]] = None,
                                    volume_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVolumeGroupBackupsResult]:
    """
    This data source provides the list of Volume Group Backups in Oracle Cloud Infrastructure Core service.

    Lists the volume group backups in the specified compartment. You can filter the results by volume group.
    For more information, see [Volume Groups](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/volumegroups.htm).

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_group_backups = oci.Core.get_volume_group_backups(compartment_id=var["compartment_id"],
        display_name=var["volume_group_backup_display_name"],
        volume_group_id=oci_core_volume_group["test_volume_group"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str volume_group_id: The OCID of the volume group.
    """
    ...
