# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AutonomousVmClusterOrdsCertificateManagementArgs', 'AutonomousVmClusterOrdsCertificateManagement']

@pulumi.input_type
class AutonomousVmClusterOrdsCertificateManagementArgs:
    def __init__(__self__, *,
                 autonomous_vm_cluster_id: pulumi.Input[str],
                 certificate_generation_type: pulumi.Input[str],
                 ca_bundle_id: Optional[pulumi.Input[str]] = None,
                 certificate_authority_id: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AutonomousVmClusterOrdsCertificateManagement resource.
        :param pulumi.Input[str] autonomous_vm_cluster_id: The autonomous VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] certificate_generation_type: Specify SYSTEM for using Oracle managed certificates. Specify BYOC when you want to bring your own certificate.
        :param pulumi.Input[str] ca_bundle_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate bundle.
        :param pulumi.Input[str] certificate_authority_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate authority.
        :param pulumi.Input[str] certificate_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate to use. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "autonomous_vm_cluster_id", autonomous_vm_cluster_id)
        pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        if ca_bundle_id is not None:
            pulumi.set(__self__, "ca_bundle_id", ca_bundle_id)
        if certificate_authority_id is not None:
            pulumi.set(__self__, "certificate_authority_id", certificate_authority_id)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)

    @property
    @pulumi.getter(name="autonomousVmClusterId")
    def autonomous_vm_cluster_id(self) -> pulumi.Input[str]:
        """
        The autonomous VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_vm_cluster_id")

    @autonomous_vm_cluster_id.setter
    def autonomous_vm_cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> pulumi.Input[str]:
        """
        Specify SYSTEM for using Oracle managed certificates. Specify BYOC when you want to bring your own certificate.
        """
        return pulumi.get(self, "certificate_generation_type")

    @certificate_generation_type.setter
    def certificate_generation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_generation_type", value)

    @property
    @pulumi.getter(name="caBundleId")
    def ca_bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate bundle.
        """
        return pulumi.get(self, "ca_bundle_id")

    @ca_bundle_id.setter
    def ca_bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_bundle_id", value)

    @property
    @pulumi.getter(name="certificateAuthorityId")
    def certificate_authority_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate authority.
        """
        return pulumi.get(self, "certificate_authority_id")

    @certificate_authority_id.setter
    def certificate_authority_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_authority_id", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate to use. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)


@pulumi.input_type
class _AutonomousVmClusterOrdsCertificateManagementState:
    def __init__(__self__, *,
                 autonomous_vm_cluster_id: Optional[pulumi.Input[str]] = None,
                 ca_bundle_id: Optional[pulumi.Input[str]] = None,
                 certificate_authority_id: Optional[pulumi.Input[str]] = None,
                 certificate_generation_type: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AutonomousVmClusterOrdsCertificateManagement resources.
        :param pulumi.Input[str] autonomous_vm_cluster_id: The autonomous VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] ca_bundle_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate bundle.
        :param pulumi.Input[str] certificate_authority_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate authority.
        :param pulumi.Input[str] certificate_generation_type: Specify SYSTEM for using Oracle managed certificates. Specify BYOC when you want to bring your own certificate.
        :param pulumi.Input[str] certificate_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate to use. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "autonomous_vm_cluster_id", autonomous_vm_cluster_id)
        if ca_bundle_id is not None:
            pulumi.set(__self__, "ca_bundle_id", ca_bundle_id)
        if certificate_authority_id is not None:
            pulumi.set(__self__, "certificate_authority_id", certificate_authority_id)
        if certificate_generation_type is not None:
            pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)

    @property
    @pulumi.getter(name="autonomousVmClusterId")
    def autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The autonomous VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_vm_cluster_id")

    @autonomous_vm_cluster_id.setter
    def autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="caBundleId")
    def ca_bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate bundle.
        """
        return pulumi.get(self, "ca_bundle_id")

    @ca_bundle_id.setter
    def ca_bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_bundle_id", value)

    @property
    @pulumi.getter(name="certificateAuthorityId")
    def certificate_authority_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate authority.
        """
        return pulumi.get(self, "certificate_authority_id")

    @certificate_authority_id.setter
    def certificate_authority_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_authority_id", value)

    @property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specify SYSTEM for using Oracle managed certificates. Specify BYOC when you want to bring your own certificate.
        """
        return pulumi.get(self, "certificate_generation_type")

    @certificate_generation_type.setter
    def certificate_generation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_generation_type", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate to use. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)


class AutonomousVmClusterOrdsCertificateManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_vm_cluster_id: Optional[pulumi.Input[str]] = None,
                 ca_bundle_id: Optional[pulumi.Input[str]] = None,
                 certificate_authority_id: Optional[pulumi.Input[str]] = None,
                 certificate_generation_type: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Autonomous Vm Cluster Ords Certificate Management resource in Oracle Cloud Infrastructure Database service.

        Rotates the Oracle REST Data Services (ORDS) certificates for Autonomous Exadata VM cluster.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_vm_cluster_ords_certificate_management = oci.database.AutonomousVmClusterOrdsCertificateManagement("testAutonomousVmClusterOrdsCertificateManagement",
            autonomous_vm_cluster_id=oci_database_autonomous_vm_cluster["test_autonomous_vm_cluster"]["id"],
            certificate_generation_type=var["autonomous_vm_cluster_ords_certificate_management_certificate_generation_type"],
            ca_bundle_id=oci_certificates_management_ca_bundle["test_ca_bundle"]["id"],
            certificate_authority_id=oci_certificates_management_certificate_authority["test_certificate_authority"]["id"],
            certificate_id=oci_apigateway_certificate["test_certificate"]["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] autonomous_vm_cluster_id: The autonomous VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] ca_bundle_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate bundle.
        :param pulumi.Input[str] certificate_authority_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate authority.
        :param pulumi.Input[str] certificate_generation_type: Specify SYSTEM for using Oracle managed certificates. Specify BYOC when you want to bring your own certificate.
        :param pulumi.Input[str] certificate_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate to use. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousVmClusterOrdsCertificateManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Autonomous Vm Cluster Ords Certificate Management resource in Oracle Cloud Infrastructure Database service.

        Rotates the Oracle REST Data Services (ORDS) certificates for Autonomous Exadata VM cluster.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_vm_cluster_ords_certificate_management = oci.database.AutonomousVmClusterOrdsCertificateManagement("testAutonomousVmClusterOrdsCertificateManagement",
            autonomous_vm_cluster_id=oci_database_autonomous_vm_cluster["test_autonomous_vm_cluster"]["id"],
            certificate_generation_type=var["autonomous_vm_cluster_ords_certificate_management_certificate_generation_type"],
            ca_bundle_id=oci_certificates_management_ca_bundle["test_ca_bundle"]["id"],
            certificate_authority_id=oci_certificates_management_certificate_authority["test_certificate_authority"]["id"],
            certificate_id=oci_apigateway_certificate["test_certificate"]["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param AutonomousVmClusterOrdsCertificateManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousVmClusterOrdsCertificateManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_vm_cluster_id: Optional[pulumi.Input[str]] = None,
                 ca_bundle_id: Optional[pulumi.Input[str]] = None,
                 certificate_authority_id: Optional[pulumi.Input[str]] = None,
                 certificate_generation_type: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousVmClusterOrdsCertificateManagementArgs.__new__(AutonomousVmClusterOrdsCertificateManagementArgs)

            if autonomous_vm_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'autonomous_vm_cluster_id'")
            __props__.__dict__["autonomous_vm_cluster_id"] = autonomous_vm_cluster_id
            __props__.__dict__["ca_bundle_id"] = ca_bundle_id
            __props__.__dict__["certificate_authority_id"] = certificate_authority_id
            if certificate_generation_type is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_generation_type'")
            __props__.__dict__["certificate_generation_type"] = certificate_generation_type
            __props__.__dict__["certificate_id"] = certificate_id
        super(AutonomousVmClusterOrdsCertificateManagement, __self__).__init__(
            'oci:Database/autonomousVmClusterOrdsCertificateManagement:AutonomousVmClusterOrdsCertificateManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autonomous_vm_cluster_id: Optional[pulumi.Input[str]] = None,
            ca_bundle_id: Optional[pulumi.Input[str]] = None,
            certificate_authority_id: Optional[pulumi.Input[str]] = None,
            certificate_generation_type: Optional[pulumi.Input[str]] = None,
            certificate_id: Optional[pulumi.Input[str]] = None) -> 'AutonomousVmClusterOrdsCertificateManagement':
        """
        Get an existing AutonomousVmClusterOrdsCertificateManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] autonomous_vm_cluster_id: The autonomous VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] ca_bundle_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate bundle.
        :param pulumi.Input[str] certificate_authority_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate authority.
        :param pulumi.Input[str] certificate_generation_type: Specify SYSTEM for using Oracle managed certificates. Specify BYOC when you want to bring your own certificate.
        :param pulumi.Input[str] certificate_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate to use. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousVmClusterOrdsCertificateManagementState.__new__(_AutonomousVmClusterOrdsCertificateManagementState)

        __props__.__dict__["autonomous_vm_cluster_id"] = autonomous_vm_cluster_id
        __props__.__dict__["ca_bundle_id"] = ca_bundle_id
        __props__.__dict__["certificate_authority_id"] = certificate_authority_id
        __props__.__dict__["certificate_generation_type"] = certificate_generation_type
        __props__.__dict__["certificate_id"] = certificate_id
        return AutonomousVmClusterOrdsCertificateManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autonomousVmClusterId")
    def autonomous_vm_cluster_id(self) -> pulumi.Output[str]:
        """
        The autonomous VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="caBundleId")
    def ca_bundle_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate bundle.
        """
        return pulumi.get(self, "ca_bundle_id")

    @property
    @pulumi.getter(name="certificateAuthorityId")
    def certificate_authority_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate authority.
        """
        return pulumi.get(self, "certificate_authority_id")

    @property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> pulumi.Output[str]:
        """
        Specify SYSTEM for using Oracle managed certificates. Specify BYOC when you want to bring your own certificate.
        """
        return pulumi.get(self, "certificate_generation_type")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the certificate to use. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "certificate_id")

