# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudVmClusterArgs', 'CloudVmCluster']

@pulumi.input_type
class CloudVmClusterArgs:
    def __init__(__self__, *,
                 backup_subnet_id: pulumi.Input[str],
                 cloud_exadata_infrastructure_id: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 cpu_core_count: pulumi.Input[int],
                 display_name: pulumi.Input[str],
                 gi_version: pulumi.Input[str],
                 hostname: pulumi.Input[str],
                 ssh_public_keys: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_id: pulumi.Input[str],
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 data_collection_options: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']] = None,
                 data_storage_percentage: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocpu_count: Optional[pulumi.Input[float]] = None,
                 private_zone_id: Optional[pulumi.Input[str]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tcp_ssl: Optional[pulumi.Input[int]] = None,
                 system_version: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CloudVmCluster resource.
        :param pulumi.Input[str] backup_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet associated with the cloud VM cluster.
        :param pulumi.Input[str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to enable for a cloud VM cluster. Valid values depend on the specified shape:
               * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
               * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
               * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
               * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
               * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
               * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
               * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud VM cluster. The name does not need to be unique.
        :param pulumi.Input[str] gi_version: A valid Oracle Grid Infrastructure (GI) software version.
        :param pulumi.Input[str] hostname: The hostname for the cloud VM cluster. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata systems.
               
               The maximum length of the combined hostname and domain is 63 characters.
               
               **Note:** The hostname must be unique within the subnet. If it is not unique, the cloud VM Cluster will fail to provision.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: (Updatable) The public key portion of one or more key pairs used for SSH access to the cloud VM cluster.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the cloud VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[str] cluster_name: The cluster name for cloud VM cluster. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        :param pulumi.Input['CloudVmClusterDataCollectionOptionsArgs'] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent assigned to DATA storage. See [Storage Configuration](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaoverview.htm#Exadata) in the Exadata documentation for details on the impact of the configuration settings on storage.
        :param pulumi.Input[float] data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated in TBs.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: (Updatable) The local node storage to be allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of DB servers.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] domain: A domain name used for the cloud VM cluster. If the Oracle-provided internet and VCN resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted. Applies to Exadata Cloud Service instances only.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the cloud VM cluster. If false, database backup on local Exadata storage is not available in the cloud VM cluster.
        :param pulumi.Input[bool] is_sparse_diskgroup_enabled: If true, the sparse disk group is configured for the cloud VM cluster. If false, the sparse disk group is not created.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the cloud VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[int] memory_size_in_gbs: (Updatable) The memory to be allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[float] ocpu_count: (Updatable) The number of OCPU cores to enable for a cloud VM cluster. Only 1 decimal place is allowed for the fractional part.
        :param pulumi.Input[str] private_zone_id: The private zone id in which DNS records need to be created.
        :param pulumi.Input[int] scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default port is 1521.
        :param pulumi.Input[int] scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The default port is 2484.
        :param pulumi.Input[str] system_version: Operating system version of the image.
        :param pulumi.Input[str] time_zone: The time zone to use for the cloud VM cluster. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "backup_subnet_id", backup_subnet_id)
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gi_version", gi_version)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if backup_network_nsg_ids is not None:
            pulumi.set(__self__, "backup_network_nsg_ids", backup_network_nsg_ids)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if create_async is not None:
            pulumi.set(__self__, "create_async", create_async)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_percentage is not None:
            pulumi.set(__self__, "data_storage_percentage", data_storage_percentage)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers is not None:
            pulumi.set(__self__, "db_servers", db_servers)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_local_backup_enabled is not None:
            pulumi.set(__self__, "is_local_backup_enabled", is_local_backup_enabled)
        if is_sparse_diskgroup_enabled is not None:
            pulumi.set(__self__, "is_sparse_diskgroup_enabled", is_sparse_diskgroup_enabled)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if ocpu_count is not None:
            pulumi.set(__self__, "ocpu_count", ocpu_count)
        if private_zone_id is not None:
            pulumi.set(__self__, "private_zone_id", private_zone_id)
        if scan_listener_port_tcp is not None:
            pulumi.set(__self__, "scan_listener_port_tcp", scan_listener_port_tcp)
        if scan_listener_port_tcp_ssl is not None:
            pulumi.set(__self__, "scan_listener_port_tcp_ssl", scan_listener_port_tcp_ssl)
        if system_version is not None:
            pulumi.set(__self__, "system_version", system_version)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="backupSubnetId")
    def backup_subnet_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet associated with the cloud VM cluster.
        """
        return pulumi.get(self, "backup_subnet_id")

    @backup_subnet_id.setter
    def backup_subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_subnet_id", value)

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Input[int]:
        """
        (Updatable) The number of CPU cores to enable for a cloud VM cluster. Valid values depend on the specified shape:
        * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
        * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
        * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
        * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
        * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
        * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
        * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The user-friendly name for the cloud VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> pulumi.Input[str]:
        """
        A valid Oracle Grid Infrastructure (GI) software version.
        """
        return pulumi.get(self, "gi_version")

    @gi_version.setter
    def gi_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "gi_version", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        The hostname for the cloud VM cluster. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata systems.

        The maximum length of the combined hostname and domain is 63 characters.

        **Note:** The hostname must be unique within the subnet. If it is not unique, the cloud VM Cluster will fail to provision.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) The public key portion of one or more key pairs used for SSH access to the cloud VM cluster.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the cloud VM cluster.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @backup_network_nsg_ids.setter
    def backup_network_nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_network_nsg_ids", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster name for cloud VM cluster. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "create_async")

    @create_async.setter
    def create_async(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_async", value)

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]:
        """
        (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent assigned to DATA storage. See [Storage Configuration](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaoverview.htm#Exadata) in the Exadata documentation for details on the impact of the configuration settings on storage.
        """
        return pulumi.get(self, "data_storage_percentage")

    @data_storage_percentage.setter
    def data_storage_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_percentage", value)

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The data disk group size to be allocated in TBs.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The local node storage to be allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of DB servers.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_servers", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        A domain name used for the cloud VM cluster. If the Oracle-provided internet and VCN resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted. Applies to Exadata Cloud Service instances only.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, database backup on local Exadata storage is configured for the cloud VM cluster. If false, database backup on local Exadata storage is not available in the cloud VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @is_local_backup_enabled.setter
    def is_local_backup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_local_backup_enabled", value)

    @property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the sparse disk group is configured for the cloud VM cluster. If false, the sparse disk group is not created.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @is_sparse_diskgroup_enabled.setter
    def is_sparse_diskgroup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_sparse_diskgroup_enabled", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to the cloud VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The memory to be allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The number of OCPU cores to enable for a cloud VM cluster. Only 1 decimal place is allowed for the fractional part.
        """
        return pulumi.get(self, "ocpu_count")

    @ocpu_count.setter
    def ocpu_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpu_count", value)

    @property
    @pulumi.getter(name="privateZoneId")
    def private_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The private zone id in which DNS records need to be created.
        """
        return pulumi.get(self, "private_zone_id")

    @private_zone_id.setter
    def private_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_zone_id", value)

    @property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP Single Client Access Name (SCAN) port. The default port is 1521.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @scan_listener_port_tcp.setter
    def scan_listener_port_tcp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_tcp", value)

    @property
    @pulumi.getter(name="scanListenerPortTcpSsl")
    def scan_listener_port_tcp_ssl(self) -> Optional[pulumi.Input[int]]:
        """
        The TCPS Single Client Access Name (SCAN) port. The default port is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tcp_ssl")

    @scan_listener_port_tcp_ssl.setter
    def scan_listener_port_tcp_ssl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_tcp_ssl", value)

    @property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> Optional[pulumi.Input[str]]:
        """
        Operating system version of the image.
        """
        return pulumi.get(self, "system_version")

    @system_version.setter
    def system_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_version", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone to use for the cloud VM cluster. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _CloudVmClusterState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_subnet_id: Optional[pulumi.Input[str]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 data_collection_options: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']] = None,
                 data_storage_percentage: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 disk_redundancy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gi_version: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 iorm_config_caches: Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterIormConfigCachArgs']]]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[bool]] = None,
                 last_update_history_entry_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocpu_count: Optional[pulumi.Input[float]] = None,
                 private_zone_id: Optional[pulumi.Input[str]] = None,
                 scan_dns_name: Optional[pulumi.Input[str]] = None,
                 scan_dns_record_id: Optional[pulumi.Input[str]] = None,
                 scan_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tcp_ssl: Optional[pulumi.Input[int]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 system_version: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 vip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CloudVmCluster resources.
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the cloud Exadata infrastructure resource is located in.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[str] backup_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet associated with the cloud VM cluster.
        :param pulumi.Input[str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure resource.
        :param pulumi.Input[str] cluster_name: The cluster name for cloud VM cluster. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to enable for a cloud VM cluster. Valid values depend on the specified shape:
               * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
               * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
               * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
               * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
               * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
               * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
               * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
        :param pulumi.Input['CloudVmClusterDataCollectionOptionsArgs'] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent assigned to DATA storage. See [Storage Configuration](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaoverview.htm#Exadata) in the Exadata documentation for details on the impact of the configuration settings on storage.
        :param pulumi.Input[float] data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated in TBs.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: (Updatable) The local node storage to be allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of DB servers.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disk_redundancy: The type of redundancy configured for the cloud Vm cluster. NORMAL is 2-way redundancy. HIGH is 3-way redundancy.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud VM cluster. The name does not need to be unique.
        :param pulumi.Input[str] domain: A domain name used for the cloud VM cluster. If the Oracle-provided internet and VCN resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted. Applies to Exadata Cloud Service instances only.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gi_version: A valid Oracle Grid Infrastructure (GI) software version.
        :param pulumi.Input[str] hostname: The hostname for the cloud VM cluster. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata systems.
               
               The maximum length of the combined hostname and domain is 63 characters.
               
               **Note:** The hostname must be unique within the subnet. If it is not unique, the cloud VM Cluster will fail to provision.
        :param pulumi.Input[Sequence[pulumi.Input['CloudVmClusterIormConfigCachArgs']]] iorm_config_caches: The IORM settings of the Exadata DB system.
        :param pulumi.Input[bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the cloud VM cluster. If false, database backup on local Exadata storage is not available in the cloud VM cluster.
        :param pulumi.Input[bool] is_sparse_diskgroup_enabled: If true, the sparse disk group is configured for the cloud VM cluster. If false, the sparse disk group is not created.
        :param pulumi.Input[str] last_update_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance update history entry. This value is updated when a maintenance update starts.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the cloud VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] listener_port: The port number configured for the listener on the cloud VM cluster.
        :param pulumi.Input[int] memory_size_in_gbs: (Updatable) The memory to be allocated in GBs.
        :param pulumi.Input[int] node_count: The number of nodes in the cloud VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[float] ocpu_count: (Updatable) The number of OCPU cores to enable for a cloud VM cluster. Only 1 decimal place is allowed for the fractional part.
        :param pulumi.Input[str] private_zone_id: The private zone id in which DNS records need to be created.
        :param pulumi.Input[str] scan_dns_name: The FQDN of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster.
        :param pulumi.Input[str] scan_dns_record_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scan_ip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IP addresses associated with the cloud VM cluster. SCAN IP addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        :param pulumi.Input[int] scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default port is 1521.
        :param pulumi.Input[int] scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The default port is 2484.
        :param pulumi.Input[str] shape: The model name of the Exadata hardware running the cloud VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: (Updatable) The public key portion of one or more key pairs used for SSH access to the cloud VM cluster.
        :param pulumi.Input[str] state: The current state of the cloud VM cluster.
        :param pulumi.Input[int] storage_size_in_gbs: The storage allocation for the disk group, in gigabytes (GB).
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the cloud VM cluster.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] system_version: Operating system version of the image.
        :param pulumi.Input[str] time_created: The date and time that the cloud VM cluster was created.
        :param pulumi.Input[str] time_zone: The time zone to use for the cloud VM cluster. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IP (VIP) addresses associated with the cloud VM cluster. The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the Exadata Cloud Service instance to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        :param pulumi.Input[str] zone_id: The OCID of the zone the cloud VM cluster is associated with.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_network_nsg_ids is not None:
            pulumi.set(__self__, "backup_network_nsg_ids", backup_network_nsg_ids)
        if backup_subnet_id is not None:
            pulumi.set(__self__, "backup_subnet_id", backup_subnet_id)
        if cloud_exadata_infrastructure_id is not None:
            pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if create_async is not None:
            pulumi.set(__self__, "create_async", create_async)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_percentage is not None:
            pulumi.set(__self__, "data_storage_percentage", data_storage_percentage)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers is not None:
            pulumi.set(__self__, "db_servers", db_servers)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if disk_redundancy is not None:
            pulumi.set(__self__, "disk_redundancy", disk_redundancy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gi_version is not None:
            pulumi.set(__self__, "gi_version", gi_version)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if iorm_config_caches is not None:
            pulumi.set(__self__, "iorm_config_caches", iorm_config_caches)
        if is_local_backup_enabled is not None:
            pulumi.set(__self__, "is_local_backup_enabled", is_local_backup_enabled)
        if is_sparse_diskgroup_enabled is not None:
            pulumi.set(__self__, "is_sparse_diskgroup_enabled", is_sparse_diskgroup_enabled)
        if last_update_history_entry_id is not None:
            pulumi.set(__self__, "last_update_history_entry_id", last_update_history_entry_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if ocpu_count is not None:
            pulumi.set(__self__, "ocpu_count", ocpu_count)
        if private_zone_id is not None:
            pulumi.set(__self__, "private_zone_id", private_zone_id)
        if scan_dns_name is not None:
            pulumi.set(__self__, "scan_dns_name", scan_dns_name)
        if scan_dns_record_id is not None:
            pulumi.set(__self__, "scan_dns_record_id", scan_dns_record_id)
        if scan_ip_ids is not None:
            pulumi.set(__self__, "scan_ip_ids", scan_ip_ids)
        if scan_listener_port_tcp is not None:
            pulumi.set(__self__, "scan_listener_port_tcp", scan_listener_port_tcp)
        if scan_listener_port_tcp_ssl is not None:
            pulumi.set(__self__, "scan_listener_port_tcp_ssl", scan_listener_port_tcp_ssl)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if ssh_public_keys is not None:
            pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_size_in_gbs is not None:
            pulumi.set(__self__, "storage_size_in_gbs", storage_size_in_gbs)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if system_version is not None:
            pulumi.set(__self__, "system_version", system_version)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if vip_ids is not None:
            pulumi.set(__self__, "vip_ids", vip_ids)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the availability domain that the cloud Exadata infrastructure resource is located in.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @backup_network_nsg_ids.setter
    def backup_network_nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_network_nsg_ids", value)

    @property
    @pulumi.getter(name="backupSubnetId")
    def backup_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet associated with the cloud VM cluster.
        """
        return pulumi.get(self, "backup_subnet_id")

    @backup_subnet_id.setter
    def backup_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_subnet_id", value)

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster name for cloud VM cluster. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of CPU cores to enable for a cloud VM cluster. Valid values depend on the specified shape:
        * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
        * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
        * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
        * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
        * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
        * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
        * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "create_async")

    @create_async.setter
    def create_async(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_async", value)

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]:
        """
        (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent assigned to DATA storage. See [Storage Configuration](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaoverview.htm#Exadata) in the Exadata documentation for details on the impact of the configuration settings on storage.
        """
        return pulumi.get(self, "data_storage_percentage")

    @data_storage_percentage.setter
    def data_storage_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_percentage", value)

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The data disk group size to be allocated in TBs.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The local node storage to be allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of DB servers.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_servers", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="diskRedundancy")
    def disk_redundancy(self) -> Optional[pulumi.Input[str]]:
        """
        The type of redundancy configured for the cloud Vm cluster. NORMAL is 2-way redundancy. HIGH is 3-way redundancy.
        """
        return pulumi.get(self, "disk_redundancy")

    @disk_redundancy.setter
    def disk_redundancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_redundancy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly name for the cloud VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        A domain name used for the cloud VM cluster. If the Oracle-provided internet and VCN resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted. Applies to Exadata Cloud Service instances only.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> Optional[pulumi.Input[str]]:
        """
        A valid Oracle Grid Infrastructure (GI) software version.
        """
        return pulumi.get(self, "gi_version")

    @gi_version.setter
    def gi_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gi_version", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for the cloud VM cluster. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata systems.

        The maximum length of the combined hostname and domain is 63 characters.

        **Note:** The hostname must be unique within the subnet. If it is not unique, the cloud VM Cluster will fail to provision.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="iormConfigCaches")
    def iorm_config_caches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterIormConfigCachArgs']]]]:
        """
        The IORM settings of the Exadata DB system.
        """
        return pulumi.get(self, "iorm_config_caches")

    @iorm_config_caches.setter
    def iorm_config_caches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterIormConfigCachArgs']]]]):
        pulumi.set(self, "iorm_config_caches", value)

    @property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, database backup on local Exadata storage is configured for the cloud VM cluster. If false, database backup on local Exadata storage is not available in the cloud VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @is_local_backup_enabled.setter
    def is_local_backup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_local_backup_enabled", value)

    @property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the sparse disk group is configured for the cloud VM cluster. If false, the sparse disk group is not created.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @is_sparse_diskgroup_enabled.setter
    def is_sparse_diskgroup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_sparse_diskgroup_enabled", value)

    @property
    @pulumi.getter(name="lastUpdateHistoryEntryId")
    def last_update_history_entry_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance update history entry. This value is updated when a maintenance update starts.
        """
        return pulumi.get(self, "last_update_history_entry_id")

    @last_update_history_entry_id.setter
    def last_update_history_entry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_update_history_entry_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to the cloud VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[str]]:
        """
        The port number configured for the listener on the cloud VM cluster.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_port", value)

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The memory to be allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes in the cloud VM cluster.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The number of OCPU cores to enable for a cloud VM cluster. Only 1 decimal place is allowed for the fractional part.
        """
        return pulumi.get(self, "ocpu_count")

    @ocpu_count.setter
    def ocpu_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpu_count", value)

    @property
    @pulumi.getter(name="privateZoneId")
    def private_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The private zone id in which DNS records need to be created.
        """
        return pulumi.get(self, "private_zone_id")

    @private_zone_id.setter
    def private_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_zone_id", value)

    @property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster.
        """
        return pulumi.get(self, "scan_dns_name")

    @scan_dns_name.setter
    def scan_dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_dns_name", value)

    @property
    @pulumi.getter(name="scanDnsRecordId")
    def scan_dns_record_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster.
        """
        return pulumi.get(self, "scan_dns_record_id")

    @scan_dns_record_id.setter
    def scan_dns_record_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_dns_record_id", value)

    @property
    @pulumi.getter(name="scanIpIds")
    def scan_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IP addresses associated with the cloud VM cluster. SCAN IP addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        """
        return pulumi.get(self, "scan_ip_ids")

    @scan_ip_ids.setter
    def scan_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scan_ip_ids", value)

    @property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP Single Client Access Name (SCAN) port. The default port is 1521.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @scan_listener_port_tcp.setter
    def scan_listener_port_tcp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_tcp", value)

    @property
    @pulumi.getter(name="scanListenerPortTcpSsl")
    def scan_listener_port_tcp_ssl(self) -> Optional[pulumi.Input[int]]:
        """
        The TCPS Single Client Access Name (SCAN) port. The default port is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tcp_ssl")

    @scan_listener_port_tcp_ssl.setter
    def scan_listener_port_tcp_ssl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_tcp_ssl", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The model name of the Exadata hardware running the cloud VM cluster.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The public key portion of one or more key pairs used for SSH access to the cloud VM cluster.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the cloud VM cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageSizeInGbs")
    def storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The storage allocation for the disk group, in gigabytes (GB).
        """
        return pulumi.get(self, "storage_size_in_gbs")

    @storage_size_in_gbs.setter
    def storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the cloud VM cluster.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> Optional[pulumi.Input[str]]:
        """
        Operating system version of the image.
        """
        return pulumi.get(self, "system_version")

    @system_version.setter
    def system_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_version", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the cloud VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone to use for the cloud VM cluster. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="vipIds")
    def vip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IP (VIP) addresses associated with the cloud VM cluster. The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the Exadata Cloud Service instance to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        """
        return pulumi.get(self, "vip_ids")

    @vip_ids.setter
    def vip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vip_ids", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the zone the cloud VM cluster is associated with.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class CloudVmCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_subnet_id: Optional[pulumi.Input[str]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 data_collection_options: Optional[pulumi.Input[pulumi.InputType['CloudVmClusterDataCollectionOptionsArgs']]] = None,
                 data_storage_percentage: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gi_version: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocpu_count: Optional[pulumi.Input[float]] = None,
                 private_zone_id: Optional[pulumi.Input[str]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tcp_ssl: Optional[pulumi.Input[int]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_version: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Cloud Vm Cluster resource in Oracle Cloud Infrastructure Database service.

        Creates a cloud VM cluster.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_cloud_vm_cluster = oci.database.CloudVmCluster("testCloudVmCluster",
            backup_subnet_id=oci_core_subnet["test_subnet"]["id"],
            cloud_exadata_infrastructure_id=oci_database_cloud_exadata_infrastructure["test_cloud_exadata_infrastructure"]["id"],
            compartment_id=var["compartment_id"],
            cpu_core_count=var["cloud_vm_cluster_cpu_core_count"],
            display_name=var["cloud_vm_cluster_display_name"],
            gi_version=var["cloud_vm_cluster_gi_version"],
            hostname=var["cloud_vm_cluster_hostname"],
            ssh_public_keys=var["cloud_vm_cluster_ssh_public_keys"],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            backup_network_nsg_ids=var["cloud_vm_cluster_backup_network_nsg_ids"],
            cluster_name=var["cloud_vm_cluster_cluster_name"],
            data_collection_options=oci.database.CloudVmClusterDataCollectionOptionsArgs(
                is_diagnostics_events_enabled=var["cloud_vm_cluster_data_collection_options_is_diagnostics_events_enabled"],
                is_health_monitoring_enabled=var["cloud_vm_cluster_data_collection_options_is_health_monitoring_enabled"],
                is_incident_logs_enabled=var["cloud_vm_cluster_data_collection_options_is_incident_logs_enabled"],
            ),
            data_storage_percentage=var["cloud_vm_cluster_data_storage_percentage"],
            data_storage_size_in_tbs=var["cloud_vm_cluster_data_storage_size_in_tbs"],
            db_node_storage_size_in_gbs=var["cloud_vm_cluster_db_node_storage_size_in_gbs"],
            db_servers=var["cloud_vm_cluster_db_servers"],
            defined_tags=var["cloud_vm_cluster_defined_tags"],
            domain=var["cloud_vm_cluster_domain"],
            freeform_tags={
                "Department": "Finance",
            },
            is_local_backup_enabled=var["cloud_vm_cluster_is_local_backup_enabled"],
            is_sparse_diskgroup_enabled=var["cloud_vm_cluster_is_sparse_diskgroup_enabled"],
            license_model=var["cloud_vm_cluster_license_model"],
            memory_size_in_gbs=var["cloud_vm_cluster_memory_size_in_gbs"],
            nsg_ids=var["cloud_vm_cluster_nsg_ids"],
            ocpu_count=var["cloud_vm_cluster_ocpu_count"],
            private_zone_id=oci_dns_zone["test_zone"]["id"],
            scan_listener_port_tcp=var["cloud_vm_cluster_scan_listener_port_tcp"],
            scan_listener_port_tcp_ssl=var["cloud_vm_cluster_scan_listener_port_tcp_ssl"],
            system_version=var["cloud_vm_cluster_system_version"],
            time_zone=var["cloud_vm_cluster_time_zone"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        CloudVmClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/cloudVmCluster:CloudVmCluster test_cloud_vm_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[str] backup_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet associated with the cloud VM cluster.
        :param pulumi.Input[str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure resource.
        :param pulumi.Input[str] cluster_name: The cluster name for cloud VM cluster. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to enable for a cloud VM cluster. Valid values depend on the specified shape:
               * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
               * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
               * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
               * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
               * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
               * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
               * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
        :param pulumi.Input[pulumi.InputType['CloudVmClusterDataCollectionOptionsArgs']] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent assigned to DATA storage. See [Storage Configuration](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaoverview.htm#Exadata) in the Exadata documentation for details on the impact of the configuration settings on storage.
        :param pulumi.Input[float] data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated in TBs.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: (Updatable) The local node storage to be allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of DB servers.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud VM cluster. The name does not need to be unique.
        :param pulumi.Input[str] domain: A domain name used for the cloud VM cluster. If the Oracle-provided internet and VCN resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted. Applies to Exadata Cloud Service instances only.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gi_version: A valid Oracle Grid Infrastructure (GI) software version.
        :param pulumi.Input[str] hostname: The hostname for the cloud VM cluster. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata systems.
               
               The maximum length of the combined hostname and domain is 63 characters.
               
               **Note:** The hostname must be unique within the subnet. If it is not unique, the cloud VM Cluster will fail to provision.
        :param pulumi.Input[bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the cloud VM cluster. If false, database backup on local Exadata storage is not available in the cloud VM cluster.
        :param pulumi.Input[bool] is_sparse_diskgroup_enabled: If true, the sparse disk group is configured for the cloud VM cluster. If false, the sparse disk group is not created.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the cloud VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[int] memory_size_in_gbs: (Updatable) The memory to be allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[float] ocpu_count: (Updatable) The number of OCPU cores to enable for a cloud VM cluster. Only 1 decimal place is allowed for the fractional part.
        :param pulumi.Input[str] private_zone_id: The private zone id in which DNS records need to be created.
        :param pulumi.Input[int] scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default port is 1521.
        :param pulumi.Input[int] scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The default port is 2484.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: (Updatable) The public key portion of one or more key pairs used for SSH access to the cloud VM cluster.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the cloud VM cluster.
        :param pulumi.Input[str] system_version: Operating system version of the image.
        :param pulumi.Input[str] time_zone: The time zone to use for the cloud VM cluster. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudVmClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Cloud Vm Cluster resource in Oracle Cloud Infrastructure Database service.

        Creates a cloud VM cluster.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_cloud_vm_cluster = oci.database.CloudVmCluster("testCloudVmCluster",
            backup_subnet_id=oci_core_subnet["test_subnet"]["id"],
            cloud_exadata_infrastructure_id=oci_database_cloud_exadata_infrastructure["test_cloud_exadata_infrastructure"]["id"],
            compartment_id=var["compartment_id"],
            cpu_core_count=var["cloud_vm_cluster_cpu_core_count"],
            display_name=var["cloud_vm_cluster_display_name"],
            gi_version=var["cloud_vm_cluster_gi_version"],
            hostname=var["cloud_vm_cluster_hostname"],
            ssh_public_keys=var["cloud_vm_cluster_ssh_public_keys"],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            backup_network_nsg_ids=var["cloud_vm_cluster_backup_network_nsg_ids"],
            cluster_name=var["cloud_vm_cluster_cluster_name"],
            data_collection_options=oci.database.CloudVmClusterDataCollectionOptionsArgs(
                is_diagnostics_events_enabled=var["cloud_vm_cluster_data_collection_options_is_diagnostics_events_enabled"],
                is_health_monitoring_enabled=var["cloud_vm_cluster_data_collection_options_is_health_monitoring_enabled"],
                is_incident_logs_enabled=var["cloud_vm_cluster_data_collection_options_is_incident_logs_enabled"],
            ),
            data_storage_percentage=var["cloud_vm_cluster_data_storage_percentage"],
            data_storage_size_in_tbs=var["cloud_vm_cluster_data_storage_size_in_tbs"],
            db_node_storage_size_in_gbs=var["cloud_vm_cluster_db_node_storage_size_in_gbs"],
            db_servers=var["cloud_vm_cluster_db_servers"],
            defined_tags=var["cloud_vm_cluster_defined_tags"],
            domain=var["cloud_vm_cluster_domain"],
            freeform_tags={
                "Department": "Finance",
            },
            is_local_backup_enabled=var["cloud_vm_cluster_is_local_backup_enabled"],
            is_sparse_diskgroup_enabled=var["cloud_vm_cluster_is_sparse_diskgroup_enabled"],
            license_model=var["cloud_vm_cluster_license_model"],
            memory_size_in_gbs=var["cloud_vm_cluster_memory_size_in_gbs"],
            nsg_ids=var["cloud_vm_cluster_nsg_ids"],
            ocpu_count=var["cloud_vm_cluster_ocpu_count"],
            private_zone_id=oci_dns_zone["test_zone"]["id"],
            scan_listener_port_tcp=var["cloud_vm_cluster_scan_listener_port_tcp"],
            scan_listener_port_tcp_ssl=var["cloud_vm_cluster_scan_listener_port_tcp_ssl"],
            system_version=var["cloud_vm_cluster_system_version"],
            time_zone=var["cloud_vm_cluster_time_zone"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        CloudVmClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/cloudVmCluster:CloudVmCluster test_cloud_vm_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param CloudVmClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudVmClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_subnet_id: Optional[pulumi.Input[str]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 data_collection_options: Optional[pulumi.Input[pulumi.InputType['CloudVmClusterDataCollectionOptionsArgs']]] = None,
                 data_storage_percentage: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gi_version: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocpu_count: Optional[pulumi.Input[float]] = None,
                 private_zone_id: Optional[pulumi.Input[str]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tcp_ssl: Optional[pulumi.Input[int]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_version: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudVmClusterArgs.__new__(CloudVmClusterArgs)

            __props__.__dict__["backup_network_nsg_ids"] = backup_network_nsg_ids
            if backup_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_subnet_id'")
            __props__.__dict__["backup_subnet_id"] = backup_subnet_id
            if cloud_exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_exadata_infrastructure_id'")
            __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
            __props__.__dict__["cluster_name"] = cluster_name
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if cpu_core_count is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_core_count'")
            __props__.__dict__["cpu_core_count"] = cpu_core_count
            __props__.__dict__["create_async"] = create_async
            __props__.__dict__["data_collection_options"] = data_collection_options
            __props__.__dict__["data_storage_percentage"] = data_storage_percentage
            __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
            __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
            __props__.__dict__["db_servers"] = db_servers
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["domain"] = domain
            __props__.__dict__["freeform_tags"] = freeform_tags
            if gi_version is None and not opts.urn:
                raise TypeError("Missing required property 'gi_version'")
            __props__.__dict__["gi_version"] = gi_version
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["is_local_backup_enabled"] = is_local_backup_enabled
            __props__.__dict__["is_sparse_diskgroup_enabled"] = is_sparse_diskgroup_enabled
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
            __props__.__dict__["nsg_ids"] = nsg_ids
            __props__.__dict__["ocpu_count"] = ocpu_count
            __props__.__dict__["private_zone_id"] = private_zone_id
            __props__.__dict__["scan_listener_port_tcp"] = scan_listener_port_tcp
            __props__.__dict__["scan_listener_port_tcp_ssl"] = scan_listener_port_tcp_ssl
            if ssh_public_keys is None and not opts.urn:
                raise TypeError("Missing required property 'ssh_public_keys'")
            __props__.__dict__["ssh_public_keys"] = ssh_public_keys
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["system_version"] = system_version
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["disk_redundancy"] = None
            __props__.__dict__["iorm_config_caches"] = None
            __props__.__dict__["last_update_history_entry_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["listener_port"] = None
            __props__.__dict__["node_count"] = None
            __props__.__dict__["scan_dns_name"] = None
            __props__.__dict__["scan_dns_record_id"] = None
            __props__.__dict__["scan_ip_ids"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["storage_size_in_gbs"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["vip_ids"] = None
            __props__.__dict__["zone_id"] = None
        super(CloudVmCluster, __self__).__init__(
            'oci:Database/cloudVmCluster:CloudVmCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backup_subnet_id: Optional[pulumi.Input[str]] = None,
            cloud_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            cpu_core_count: Optional[pulumi.Input[int]] = None,
            create_async: Optional[pulumi.Input[bool]] = None,
            data_collection_options: Optional[pulumi.Input[pulumi.InputType['CloudVmClusterDataCollectionOptionsArgs']]] = None,
            data_storage_percentage: Optional[pulumi.Input[int]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
            db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            disk_redundancy: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            gi_version: Optional[pulumi.Input[str]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            iorm_config_caches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudVmClusterIormConfigCachArgs']]]]] = None,
            is_local_backup_enabled: Optional[pulumi.Input[bool]] = None,
            is_sparse_diskgroup_enabled: Optional[pulumi.Input[bool]] = None,
            last_update_history_entry_id: Optional[pulumi.Input[str]] = None,
            license_model: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            listener_port: Optional[pulumi.Input[str]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ocpu_count: Optional[pulumi.Input[float]] = None,
            private_zone_id: Optional[pulumi.Input[str]] = None,
            scan_dns_name: Optional[pulumi.Input[str]] = None,
            scan_dns_record_id: Optional[pulumi.Input[str]] = None,
            scan_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            scan_listener_port_tcp: Optional[pulumi.Input[int]] = None,
            scan_listener_port_tcp_ssl: Optional[pulumi.Input[int]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            system_version: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            vip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'CloudVmCluster':
        """
        Get an existing CloudVmCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the cloud Exadata infrastructure resource is located in.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[str] backup_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet associated with the cloud VM cluster.
        :param pulumi.Input[str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure resource.
        :param pulumi.Input[str] cluster_name: The cluster name for cloud VM cluster. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to enable for a cloud VM cluster. Valid values depend on the specified shape:
               * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
               * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
               * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
               * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
               * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
               * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
               * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
        :param pulumi.Input[pulumi.InputType['CloudVmClusterDataCollectionOptionsArgs']] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent assigned to DATA storage. See [Storage Configuration](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaoverview.htm#Exadata) in the Exadata documentation for details on the impact of the configuration settings on storage.
        :param pulumi.Input[float] data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated in TBs.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: (Updatable) The local node storage to be allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of DB servers.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disk_redundancy: The type of redundancy configured for the cloud Vm cluster. NORMAL is 2-way redundancy. HIGH is 3-way redundancy.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud VM cluster. The name does not need to be unique.
        :param pulumi.Input[str] domain: A domain name used for the cloud VM cluster. If the Oracle-provided internet and VCN resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted. Applies to Exadata Cloud Service instances only.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gi_version: A valid Oracle Grid Infrastructure (GI) software version.
        :param pulumi.Input[str] hostname: The hostname for the cloud VM cluster. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata systems.
               
               The maximum length of the combined hostname and domain is 63 characters.
               
               **Note:** The hostname must be unique within the subnet. If it is not unique, the cloud VM Cluster will fail to provision.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudVmClusterIormConfigCachArgs']]]] iorm_config_caches: The IORM settings of the Exadata DB system.
        :param pulumi.Input[bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the cloud VM cluster. If false, database backup on local Exadata storage is not available in the cloud VM cluster.
        :param pulumi.Input[bool] is_sparse_diskgroup_enabled: If true, the sparse disk group is configured for the cloud VM cluster. If false, the sparse disk group is not created.
        :param pulumi.Input[str] last_update_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance update history entry. This value is updated when a maintenance update starts.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the cloud VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] listener_port: The port number configured for the listener on the cloud VM cluster.
        :param pulumi.Input[int] memory_size_in_gbs: (Updatable) The memory to be allocated in GBs.
        :param pulumi.Input[int] node_count: The number of nodes in the cloud VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[float] ocpu_count: (Updatable) The number of OCPU cores to enable for a cloud VM cluster. Only 1 decimal place is allowed for the fractional part.
        :param pulumi.Input[str] private_zone_id: The private zone id in which DNS records need to be created.
        :param pulumi.Input[str] scan_dns_name: The FQDN of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster.
        :param pulumi.Input[str] scan_dns_record_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scan_ip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IP addresses associated with the cloud VM cluster. SCAN IP addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        :param pulumi.Input[int] scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default port is 1521.
        :param pulumi.Input[int] scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The default port is 2484.
        :param pulumi.Input[str] shape: The model name of the Exadata hardware running the cloud VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: (Updatable) The public key portion of one or more key pairs used for SSH access to the cloud VM cluster.
        :param pulumi.Input[str] state: The current state of the cloud VM cluster.
        :param pulumi.Input[int] storage_size_in_gbs: The storage allocation for the disk group, in gigabytes (GB).
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the cloud VM cluster.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] system_version: Operating system version of the image.
        :param pulumi.Input[str] time_created: The date and time that the cloud VM cluster was created.
        :param pulumi.Input[str] time_zone: The time zone to use for the cloud VM cluster. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IP (VIP) addresses associated with the cloud VM cluster. The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the Exadata Cloud Service instance to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        :param pulumi.Input[str] zone_id: The OCID of the zone the cloud VM cluster is associated with.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudVmClusterState.__new__(_CloudVmClusterState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["backup_network_nsg_ids"] = backup_network_nsg_ids
        __props__.__dict__["backup_subnet_id"] = backup_subnet_id
        __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["create_async"] = create_async
        __props__.__dict__["data_collection_options"] = data_collection_options
        __props__.__dict__["data_storage_percentage"] = data_storage_percentage
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_servers"] = db_servers
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["disk_redundancy"] = disk_redundancy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain"] = domain
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gi_version"] = gi_version
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["iorm_config_caches"] = iorm_config_caches
        __props__.__dict__["is_local_backup_enabled"] = is_local_backup_enabled
        __props__.__dict__["is_sparse_diskgroup_enabled"] = is_sparse_diskgroup_enabled
        __props__.__dict__["last_update_history_entry_id"] = last_update_history_entry_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["listener_port"] = listener_port
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["ocpu_count"] = ocpu_count
        __props__.__dict__["private_zone_id"] = private_zone_id
        __props__.__dict__["scan_dns_name"] = scan_dns_name
        __props__.__dict__["scan_dns_record_id"] = scan_dns_record_id
        __props__.__dict__["scan_ip_ids"] = scan_ip_ids
        __props__.__dict__["scan_listener_port_tcp"] = scan_listener_port_tcp
        __props__.__dict__["scan_listener_port_tcp_ssl"] = scan_listener_port_tcp_ssl
        __props__.__dict__["shape"] = shape
        __props__.__dict__["ssh_public_keys"] = ssh_public_keys
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_size_in_gbs"] = storage_size_in_gbs
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["system_version"] = system_version
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["vip_ids"] = vip_ids
        __props__.__dict__["zone_id"] = zone_id
        return CloudVmCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The name of the availability domain that the cloud Exadata infrastructure resource is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @property
    @pulumi.getter(name="backupSubnetId")
    def backup_subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet associated with the cloud VM cluster.
        """
        return pulumi.get(self, "backup_subnet_id")

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        The cluster name for cloud VM cluster. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of CPU cores to enable for a cloud VM cluster. Valid values depend on the specified shape:
        * Exadata.Base.48 - Specify a multiple of 2, from 0 to 48.
        * Exadata.Quarter1.84 - Specify a multiple of 2, from 22 to 84.
        * Exadata.Half1.168 - Specify a multiple of 4, from 44 to 168.
        * Exadata.Full1.336 - Specify a multiple of 8, from 88 to 336.
        * Exadata.Quarter2.92 - Specify a multiple of 2, from 0 to 92.
        * Exadata.Half2.184 - Specify a multiple of 4, from 0 to 184.
        * Exadata.Full2.368 - Specify a multiple of 8, from 0 to 368.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "create_async")

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> pulumi.Output['outputs.CloudVmClusterDataCollectionOptions']:
        """
        (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> pulumi.Output[int]:
        """
        The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent assigned to DATA storage. See [Storage Configuration](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaoverview.htm#Exadata) in the Exadata documentation for details on the impact of the configuration settings on storage.
        """
        return pulumi.get(self, "data_storage_percentage")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        (Updatable) The data disk group size to be allocated in TBs.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[int]:
        """
        (Updatable) The local node storage to be allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of DB servers.
        """
        return pulumi.get(self, "db_servers")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="diskRedundancy")
    def disk_redundancy(self) -> pulumi.Output[str]:
        """
        The type of redundancy configured for the cloud Vm cluster. NORMAL is 2-way redundancy. HIGH is 3-way redundancy.
        """
        return pulumi.get(self, "disk_redundancy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The user-friendly name for the cloud VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        A domain name used for the cloud VM cluster. If the Oracle-provided internet and VCN resolver is enabled for the specified subnet, the domain name for the subnet is used (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted. Applies to Exadata Cloud Service instances only.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> pulumi.Output[str]:
        """
        A valid Oracle Grid Infrastructure (GI) software version.
        """
        return pulumi.get(self, "gi_version")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The hostname for the cloud VM cluster. The hostname must begin with an alphabetic character, and can contain alphanumeric characters and hyphens (-). The maximum length of the hostname is 16 characters for bare metal and virtual machine DB systems, and 12 characters for Exadata systems.

        The maximum length of the combined hostname and domain is 63 characters.

        **Note:** The hostname must be unique within the subnet. If it is not unique, the cloud VM Cluster will fail to provision.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="iormConfigCaches")
    def iorm_config_caches(self) -> pulumi.Output[Sequence['outputs.CloudVmClusterIormConfigCach']]:
        """
        The IORM settings of the Exadata DB system.
        """
        return pulumi.get(self, "iorm_config_caches")

    @property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> pulumi.Output[bool]:
        """
        If true, database backup on local Exadata storage is configured for the cloud VM cluster. If false, database backup on local Exadata storage is not available in the cloud VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> pulumi.Output[bool]:
        """
        If true, the sparse disk group is configured for the cloud VM cluster. If false, the sparse disk group is not created.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @property
    @pulumi.getter(name="lastUpdateHistoryEntryId")
    def last_update_history_entry_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance update history entry. This value is updated when a maintenance update starts.
        """
        return pulumi.get(self, "last_update_history_entry_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[str]:
        """
        (Updatable) The Oracle license model that applies to the cloud VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Output[str]:
        """
        The port number configured for the listener on the cloud VM cluster.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[int]:
        """
        (Updatable) The memory to be allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[int]:
        """
        The number of nodes in the cloud VM cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> pulumi.Output[float]:
        """
        (Updatable) The number of OCPU cores to enable for a cloud VM cluster. Only 1 decimal place is allowed for the fractional part.
        """
        return pulumi.get(self, "ocpu_count")

    @property
    @pulumi.getter(name="privateZoneId")
    def private_zone_id(self) -> pulumi.Output[str]:
        """
        The private zone id in which DNS records need to be created.
        """
        return pulumi.get(self, "private_zone_id")

    @property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> pulumi.Output[str]:
        """
        The FQDN of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster.
        """
        return pulumi.get(self, "scan_dns_name")

    @property
    @pulumi.getter(name="scanDnsRecordId")
    def scan_dns_record_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster.
        """
        return pulumi.get(self, "scan_dns_record_id")

    @property
    @pulumi.getter(name="scanIpIds")
    def scan_ip_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IP addresses associated with the cloud VM cluster. SCAN IP addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        """
        return pulumi.get(self, "scan_ip_ids")

    @property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> pulumi.Output[int]:
        """
        The TCP Single Client Access Name (SCAN) port. The default port is 1521.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @property
    @pulumi.getter(name="scanListenerPortTcpSsl")
    def scan_listener_port_tcp_ssl(self) -> pulumi.Output[int]:
        """
        The TCPS Single Client Access Name (SCAN) port. The default port is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tcp_ssl")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        The model name of the Exadata hardware running the cloud VM cluster.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The public key portion of one or more key pairs used for SSH access to the cloud VM cluster.
        """
        return pulumi.get(self, "ssh_public_keys")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the cloud VM cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageSizeInGbs")
    def storage_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The storage allocation for the disk group, in gigabytes (GB).
        """
        return pulumi.get(self, "storage_size_in_gbs")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the cloud VM cluster.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> pulumi.Output[str]:
        """
        Operating system version of the image.
        """
        return pulumi.get(self, "system_version")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time that the cloud VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        The time zone to use for the cloud VM cluster. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="vipIds")
    def vip_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IP (VIP) addresses associated with the cloud VM cluster. The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the Exadata Cloud Service instance to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        """
        return pulumi.get(self, "vip_ids")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The OCID of the zone the cloud VM cluster is associated with.
        """
        return pulumi.get(self, "zone_id")

