# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudVmClusterResult',
    'AwaitableGetCloudVmClusterResult',
    'get_cloud_vm_cluster',
    'get_cloud_vm_cluster_output',
]

@pulumi.output_type
class GetCloudVmClusterResult:
    """
    A collection of values returned by getCloudVmCluster.
    """
    def __init__(__self__, availability_domain=None, backup_network_nsg_ids=None, backup_subnet_id=None, cloud_exadata_infrastructure_id=None, cloud_vm_cluster_id=None, cluster_name=None, compartment_id=None, cpu_core_count=None, create_async=None, data_collection_options=None, data_storage_percentage=None, data_storage_size_in_tbs=None, db_node_storage_size_in_gbs=None, db_servers=None, defined_tags=None, disk_redundancy=None, display_name=None, domain=None, freeform_tags=None, gi_version=None, hostname=None, id=None, iorm_config_caches=None, is_local_backup_enabled=None, is_sparse_diskgroup_enabled=None, last_update_history_entry_id=None, license_model=None, lifecycle_details=None, listener_port=None, memory_size_in_gbs=None, node_count=None, nsg_ids=None, ocpu_count=None, private_zone_id=None, scan_dns_name=None, scan_dns_record_id=None, scan_ip_ids=None, scan_listener_port_tcp=None, scan_listener_port_tcp_ssl=None, shape=None, ssh_public_keys=None, state=None, storage_size_in_gbs=None, subnet_id=None, system_tags=None, system_version=None, time_created=None, time_zone=None, vip_ids=None, zone_id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_network_nsg_ids and not isinstance(backup_network_nsg_ids, list):
            raise TypeError("Expected argument 'backup_network_nsg_ids' to be a list")
        pulumi.set(__self__, "backup_network_nsg_ids", backup_network_nsg_ids)
        if backup_subnet_id and not isinstance(backup_subnet_id, str):
            raise TypeError("Expected argument 'backup_subnet_id' to be a str")
        pulumi.set(__self__, "backup_subnet_id", backup_subnet_id)
        if cloud_exadata_infrastructure_id and not isinstance(cloud_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'cloud_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if cloud_vm_cluster_id and not isinstance(cloud_vm_cluster_id, str):
            raise TypeError("Expected argument 'cloud_vm_cluster_id' to be a str")
        pulumi.set(__self__, "cloud_vm_cluster_id", cloud_vm_cluster_id)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if create_async and not isinstance(create_async, bool):
            raise TypeError("Expected argument 'create_async' to be a bool")
        pulumi.set(__self__, "create_async", create_async)
        if data_collection_options and not isinstance(data_collection_options, list):
            raise TypeError("Expected argument 'data_collection_options' to be a list")
        pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_percentage and not isinstance(data_storage_percentage, int):
            raise TypeError("Expected argument 'data_storage_percentage' to be a int")
        pulumi.set(__self__, "data_storage_percentage", data_storage_percentage)
        if data_storage_size_in_tbs and not isinstance(data_storage_size_in_tbs, float):
            raise TypeError("Expected argument 'data_storage_size_in_tbs' to be a float")
        pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs and not isinstance(db_node_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'db_node_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers and not isinstance(db_servers, list):
            raise TypeError("Expected argument 'db_servers' to be a list")
        pulumi.set(__self__, "db_servers", db_servers)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if disk_redundancy and not isinstance(disk_redundancy, str):
            raise TypeError("Expected argument 'disk_redundancy' to be a str")
        pulumi.set(__self__, "disk_redundancy", disk_redundancy)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gi_version and not isinstance(gi_version, str):
            raise TypeError("Expected argument 'gi_version' to be a str")
        pulumi.set(__self__, "gi_version", gi_version)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iorm_config_caches and not isinstance(iorm_config_caches, list):
            raise TypeError("Expected argument 'iorm_config_caches' to be a list")
        pulumi.set(__self__, "iorm_config_caches", iorm_config_caches)
        if is_local_backup_enabled and not isinstance(is_local_backup_enabled, bool):
            raise TypeError("Expected argument 'is_local_backup_enabled' to be a bool")
        pulumi.set(__self__, "is_local_backup_enabled", is_local_backup_enabled)
        if is_sparse_diskgroup_enabled and not isinstance(is_sparse_diskgroup_enabled, bool):
            raise TypeError("Expected argument 'is_sparse_diskgroup_enabled' to be a bool")
        pulumi.set(__self__, "is_sparse_diskgroup_enabled", is_sparse_diskgroup_enabled)
        if last_update_history_entry_id and not isinstance(last_update_history_entry_id, str):
            raise TypeError("Expected argument 'last_update_history_entry_id' to be a str")
        pulumi.set(__self__, "last_update_history_entry_id", last_update_history_entry_id)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if listener_port and not isinstance(listener_port, str):
            raise TypeError("Expected argument 'listener_port' to be a str")
        pulumi.set(__self__, "listener_port", listener_port)
        if memory_size_in_gbs and not isinstance(memory_size_in_gbs, int):
            raise TypeError("Expected argument 'memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if node_count and not isinstance(node_count, int):
            raise TypeError("Expected argument 'node_count' to be a int")
        pulumi.set(__self__, "node_count", node_count)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if ocpu_count and not isinstance(ocpu_count, float):
            raise TypeError("Expected argument 'ocpu_count' to be a float")
        pulumi.set(__self__, "ocpu_count", ocpu_count)
        if private_zone_id and not isinstance(private_zone_id, str):
            raise TypeError("Expected argument 'private_zone_id' to be a str")
        pulumi.set(__self__, "private_zone_id", private_zone_id)
        if scan_dns_name and not isinstance(scan_dns_name, str):
            raise TypeError("Expected argument 'scan_dns_name' to be a str")
        pulumi.set(__self__, "scan_dns_name", scan_dns_name)
        if scan_dns_record_id and not isinstance(scan_dns_record_id, str):
            raise TypeError("Expected argument 'scan_dns_record_id' to be a str")
        pulumi.set(__self__, "scan_dns_record_id", scan_dns_record_id)
        if scan_ip_ids and not isinstance(scan_ip_ids, list):
            raise TypeError("Expected argument 'scan_ip_ids' to be a list")
        pulumi.set(__self__, "scan_ip_ids", scan_ip_ids)
        if scan_listener_port_tcp and not isinstance(scan_listener_port_tcp, int):
            raise TypeError("Expected argument 'scan_listener_port_tcp' to be a int")
        pulumi.set(__self__, "scan_listener_port_tcp", scan_listener_port_tcp)
        if scan_listener_port_tcp_ssl and not isinstance(scan_listener_port_tcp_ssl, int):
            raise TypeError("Expected argument 'scan_listener_port_tcp_ssl' to be a int")
        pulumi.set(__self__, "scan_listener_port_tcp_ssl", scan_listener_port_tcp_ssl)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if ssh_public_keys and not isinstance(ssh_public_keys, list):
            raise TypeError("Expected argument 'ssh_public_keys' to be a list")
        pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if storage_size_in_gbs and not isinstance(storage_size_in_gbs, int):
            raise TypeError("Expected argument 'storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "storage_size_in_gbs", storage_size_in_gbs)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if system_version and not isinstance(system_version, str):
            raise TypeError("Expected argument 'system_version' to be a str")
        pulumi.set(__self__, "system_version", system_version)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)
        if vip_ids and not isinstance(vip_ids, list):
            raise TypeError("Expected argument 'vip_ids' to be a list")
        pulumi.set(__self__, "vip_ids", vip_ids)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The name of the availability domain that the cloud Exadata infrastructure resource is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> Sequence[str]:
        """
        A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @property
    @pulumi.getter(name="backupSubnetId")
    def backup_subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet associated with the cloud VM cluster.
        """
        return pulumi.get(self, "backup_subnet_id")

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> str:
        return pulumi.get(self, "cloud_vm_cluster_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        The cluster name for cloud VM cluster. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> int:
        """
        The number of CPU cores enabled on the cloud VM cluster.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> bool:
        return pulumi.get(self, "create_async")

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Sequence['outputs.GetCloudVmClusterDataCollectionOptionResult']:
        """
        Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> int:
        """
        The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent assigned to DATA storage. See [Storage Configuration](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaoverview.htm#Exadata) in the Exadata documentation for details on the impact of the configuration settings on storage.
        """
        return pulumi.get(self, "data_storage_percentage")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> float:
        """
        The data disk group size to be allocated in TBs.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> int:
        """
        The local node storage to be allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Sequence[str]:
        """
        The list of DB servers.
        """
        return pulumi.get(self, "db_servers")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="diskRedundancy")
    def disk_redundancy(self) -> str:
        """
        The type of redundancy configured for the cloud Vm cluster. NORMAL is 2-way redundancy. HIGH is 3-way redundancy.
        """
        return pulumi.get(self, "disk_redundancy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the cloud VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain name for the cloud VM cluster.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> str:
        """
        A valid Oracle Grid Infrastructure (GI) software version.
        """
        return pulumi.get(self, "gi_version")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The hostname for the cloud VM cluster.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="iormConfigCaches")
    def iorm_config_caches(self) -> Sequence['outputs.GetCloudVmClusterIormConfigCachResult']:
        """
        The IORM settings of the Exadata DB system.
        """
        return pulumi.get(self, "iorm_config_caches")

    @property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> bool:
        """
        If true, database backup on local Exadata storage is configured for the cloud VM cluster. If false, database backup on local Exadata storage is not available in the cloud VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> bool:
        """
        If true, sparse disk group is configured for the cloud VM cluster. If false, sparse disk group is not created.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @property
    @pulumi.getter(name="lastUpdateHistoryEntryId")
    def last_update_history_entry_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance update history entry. This value is updated when a maintenance update starts.
        """
        return pulumi.get(self, "last_update_history_entry_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> str:
        """
        The Oracle license model that applies to the cloud VM cluster. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> str:
        """
        The port number configured for the listener on the cloud VM cluster.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> int:
        """
        The memory to be allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        The number of nodes in the cloud VM cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> float:
        """
        The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal place is allowed for the fractional part.
        """
        return pulumi.get(self, "ocpu_count")

    @property
    @pulumi.getter(name="privateZoneId")
    def private_zone_id(self) -> str:
        return pulumi.get(self, "private_zone_id")

    @property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> str:
        """
        The FQDN of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster.
        """
        return pulumi.get(self, "scan_dns_name")

    @property
    @pulumi.getter(name="scanDnsRecordId")
    def scan_dns_record_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster.
        """
        return pulumi.get(self, "scan_dns_record_id")

    @property
    @pulumi.getter(name="scanIpIds")
    def scan_ip_ids(self) -> Sequence[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IP addresses associated with the cloud VM cluster. SCAN IP addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        """
        return pulumi.get(self, "scan_ip_ids")

    @property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> int:
        """
        The TCP Single Client Access Name (SCAN) port. The default port is 1521.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @property
    @pulumi.getter(name="scanListenerPortTcpSsl")
    def scan_listener_port_tcp_ssl(self) -> int:
        """
        The TCPS Single Client Access Name (SCAN) port. The default port is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tcp_ssl")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        The model name of the Exadata hardware running the cloud VM cluster.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Sequence[str]:
        """
        The public key portion of one or more key pairs used for SSH access to the cloud VM cluster.
        """
        return pulumi.get(self, "ssh_public_keys")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the cloud VM cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageSizeInGbs")
    def storage_size_in_gbs(self) -> int:
        """
        The storage allocation for the disk group, in gigabytes (GB).
        """
        return pulumi.get(self, "storage_size_in_gbs")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the cloud VM cluster.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> str:
        """
        Operating system version of the image.
        """
        return pulumi.get(self, "system_version")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time that the cloud VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        The time zone of the cloud VM cluster. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="vipIds")
    def vip_ids(self) -> Sequence[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IP (VIP) addresses associated with the cloud VM cluster. The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the Exadata Cloud Service instance to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        """
        return pulumi.get(self, "vip_ids")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The OCID of the zone the cloud VM cluster is associated with.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetCloudVmClusterResult(GetCloudVmClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudVmClusterResult(
            availability_domain=self.availability_domain,
            backup_network_nsg_ids=self.backup_network_nsg_ids,
            backup_subnet_id=self.backup_subnet_id,
            cloud_exadata_infrastructure_id=self.cloud_exadata_infrastructure_id,
            cloud_vm_cluster_id=self.cloud_vm_cluster_id,
            cluster_name=self.cluster_name,
            compartment_id=self.compartment_id,
            cpu_core_count=self.cpu_core_count,
            create_async=self.create_async,
            data_collection_options=self.data_collection_options,
            data_storage_percentage=self.data_storage_percentage,
            data_storage_size_in_tbs=self.data_storage_size_in_tbs,
            db_node_storage_size_in_gbs=self.db_node_storage_size_in_gbs,
            db_servers=self.db_servers,
            defined_tags=self.defined_tags,
            disk_redundancy=self.disk_redundancy,
            display_name=self.display_name,
            domain=self.domain,
            freeform_tags=self.freeform_tags,
            gi_version=self.gi_version,
            hostname=self.hostname,
            id=self.id,
            iorm_config_caches=self.iorm_config_caches,
            is_local_backup_enabled=self.is_local_backup_enabled,
            is_sparse_diskgroup_enabled=self.is_sparse_diskgroup_enabled,
            last_update_history_entry_id=self.last_update_history_entry_id,
            license_model=self.license_model,
            lifecycle_details=self.lifecycle_details,
            listener_port=self.listener_port,
            memory_size_in_gbs=self.memory_size_in_gbs,
            node_count=self.node_count,
            nsg_ids=self.nsg_ids,
            ocpu_count=self.ocpu_count,
            private_zone_id=self.private_zone_id,
            scan_dns_name=self.scan_dns_name,
            scan_dns_record_id=self.scan_dns_record_id,
            scan_ip_ids=self.scan_ip_ids,
            scan_listener_port_tcp=self.scan_listener_port_tcp,
            scan_listener_port_tcp_ssl=self.scan_listener_port_tcp_ssl,
            shape=self.shape,
            ssh_public_keys=self.ssh_public_keys,
            state=self.state,
            storage_size_in_gbs=self.storage_size_in_gbs,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            system_version=self.system_version,
            time_created=self.time_created,
            time_zone=self.time_zone,
            vip_ids=self.vip_ids,
            zone_id=self.zone_id)


def get_cloud_vm_cluster(cloud_vm_cluster_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudVmClusterResult:
    """
    This data source provides details about a specific Cloud Vm Cluster resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified cloud VM cluster. Applies to Exadata Cloud Service instances and Autonomous Database on dedicated Exadata infrastructure only.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_vm_cluster = oci.Database.get_cloud_vm_cluster(cloud_vm_cluster_id=oci_database_cloud_vm_cluster["test_cloud_vm_cluster"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str cloud_vm_cluster_id: The cloud VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['cloudVmClusterId'] = cloud_vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getCloudVmCluster:getCloudVmCluster', __args__, opts=opts, typ=GetCloudVmClusterResult).value

    return AwaitableGetCloudVmClusterResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        backup_network_nsg_ids=pulumi.get(__ret__, 'backup_network_nsg_ids'),
        backup_subnet_id=pulumi.get(__ret__, 'backup_subnet_id'),
        cloud_exadata_infrastructure_id=pulumi.get(__ret__, 'cloud_exadata_infrastructure_id'),
        cloud_vm_cluster_id=pulumi.get(__ret__, 'cloud_vm_cluster_id'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        create_async=pulumi.get(__ret__, 'create_async'),
        data_collection_options=pulumi.get(__ret__, 'data_collection_options'),
        data_storage_percentage=pulumi.get(__ret__, 'data_storage_percentage'),
        data_storage_size_in_tbs=pulumi.get(__ret__, 'data_storage_size_in_tbs'),
        db_node_storage_size_in_gbs=pulumi.get(__ret__, 'db_node_storage_size_in_gbs'),
        db_servers=pulumi.get(__ret__, 'db_servers'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        disk_redundancy=pulumi.get(__ret__, 'disk_redundancy'),
        display_name=pulumi.get(__ret__, 'display_name'),
        domain=pulumi.get(__ret__, 'domain'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        gi_version=pulumi.get(__ret__, 'gi_version'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        iorm_config_caches=pulumi.get(__ret__, 'iorm_config_caches'),
        is_local_backup_enabled=pulumi.get(__ret__, 'is_local_backup_enabled'),
        is_sparse_diskgroup_enabled=pulumi.get(__ret__, 'is_sparse_diskgroup_enabled'),
        last_update_history_entry_id=pulumi.get(__ret__, 'last_update_history_entry_id'),
        license_model=pulumi.get(__ret__, 'license_model'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        listener_port=pulumi.get(__ret__, 'listener_port'),
        memory_size_in_gbs=pulumi.get(__ret__, 'memory_size_in_gbs'),
        node_count=pulumi.get(__ret__, 'node_count'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        ocpu_count=pulumi.get(__ret__, 'ocpu_count'),
        private_zone_id=pulumi.get(__ret__, 'private_zone_id'),
        scan_dns_name=pulumi.get(__ret__, 'scan_dns_name'),
        scan_dns_record_id=pulumi.get(__ret__, 'scan_dns_record_id'),
        scan_ip_ids=pulumi.get(__ret__, 'scan_ip_ids'),
        scan_listener_port_tcp=pulumi.get(__ret__, 'scan_listener_port_tcp'),
        scan_listener_port_tcp_ssl=pulumi.get(__ret__, 'scan_listener_port_tcp_ssl'),
        shape=pulumi.get(__ret__, 'shape'),
        ssh_public_keys=pulumi.get(__ret__, 'ssh_public_keys'),
        state=pulumi.get(__ret__, 'state'),
        storage_size_in_gbs=pulumi.get(__ret__, 'storage_size_in_gbs'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        system_version=pulumi.get(__ret__, 'system_version'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_zone=pulumi.get(__ret__, 'time_zone'),
        vip_ids=pulumi.get(__ret__, 'vip_ids'),
        zone_id=pulumi.get(__ret__, 'zone_id'))


@_utilities.lift_output_func(get_cloud_vm_cluster)
def get_cloud_vm_cluster_output(cloud_vm_cluster_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCloudVmClusterResult]:
    """
    This data source provides details about a specific Cloud Vm Cluster resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified cloud VM cluster. Applies to Exadata Cloud Service instances and Autonomous Database on dedicated Exadata infrastructure only.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_vm_cluster = oci.Database.get_cloud_vm_cluster(cloud_vm_cluster_id=oci_database_cloud_vm_cluster["test_cloud_vm_cluster"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str cloud_vm_cluster_id: The cloud VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
