# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabasePdbConversionHistoryEntriesResult',
    'AwaitableGetDatabasePdbConversionHistoryEntriesResult',
    'get_database_pdb_conversion_history_entries',
    'get_database_pdb_conversion_history_entries_output',
]

@pulumi.output_type
class GetDatabasePdbConversionHistoryEntriesResult:
    """
    A collection of values returned by getDatabasePdbConversionHistoryEntries.
    """
    def __init__(__self__, database_id=None, filters=None, id=None, pdb_conversion_action=None, pdb_conversion_history_entries=None, state=None):
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pdb_conversion_action and not isinstance(pdb_conversion_action, str):
            raise TypeError("Expected argument 'pdb_conversion_action' to be a str")
        pulumi.set(__self__, "pdb_conversion_action", pdb_conversion_action)
        if pdb_conversion_history_entries and not isinstance(pdb_conversion_history_entries, list):
            raise TypeError("Expected argument 'pdb_conversion_history_entries' to be a list")
        pulumi.set(__self__, "pdb_conversion_history_entries", pdb_conversion_history_entries)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabasePdbConversionHistoryEntriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="pdbConversionAction")
    def pdb_conversion_action(self) -> Optional[str]:
        return pulumi.get(self, "pdb_conversion_action")

    @property
    @pulumi.getter(name="pdbConversionHistoryEntries")
    def pdb_conversion_history_entries(self) -> Sequence['outputs.GetDatabasePdbConversionHistoryEntriesPdbConversionHistoryEntryResult']:
        """
        The list of pdb_conversion_history_entries.
        """
        return pulumi.get(self, "pdb_conversion_history_entries")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Status of an operation performed during the conversion of a non-container database to a pluggable database.
        """
        return pulumi.get(self, "state")


class AwaitableGetDatabasePdbConversionHistoryEntriesResult(GetDatabasePdbConversionHistoryEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabasePdbConversionHistoryEntriesResult(
            database_id=self.database_id,
            filters=self.filters,
            id=self.id,
            pdb_conversion_action=self.pdb_conversion_action,
            pdb_conversion_history_entries=self.pdb_conversion_history_entries,
            state=self.state)


def get_database_pdb_conversion_history_entries(database_id: Optional[str] = None,
                                                filters: Optional[Sequence[pulumi.InputType['GetDatabasePdbConversionHistoryEntriesFilterArgs']]] = None,
                                                pdb_conversion_action: Optional[str] = None,
                                                state: Optional[str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabasePdbConversionHistoryEntriesResult:
    """
    This data source provides the list of Database Pdb Conversion History Entries in Oracle Cloud Infrastructure Database service.

    Gets the pluggable database conversion history for a specified database in a bare metal or virtual machine DB system.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_pdb_conversion_history_entries = oci.Database.get_database_pdb_conversion_history_entries(database_id=oci_database_database["test_database"]["id"],
        pdb_conversion_action=var["database_pdb_conversion_history_entry_pdb_conversion_action"],
        state=var["database_pdb_conversion_history_entry_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str pdb_conversion_action: A filter to return only the pluggable database conversion history entries that match the specified conversion action. For example, you can use this filter to return only entries for the precheck operation.
    :param str state: A filter to return only the pluggable database conversion history entries that match the specified lifecycle state. For example, you can use this filter to return only entries in the "failed" lifecycle state.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['filters'] = filters
    __args__['pdbConversionAction'] = pdb_conversion_action
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDatabasePdbConversionHistoryEntries:getDatabasePdbConversionHistoryEntries', __args__, opts=opts, typ=GetDatabasePdbConversionHistoryEntriesResult).value

    return AwaitableGetDatabasePdbConversionHistoryEntriesResult(
        database_id=pulumi.get(__ret__, 'database_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        pdb_conversion_action=pulumi.get(__ret__, 'pdb_conversion_action'),
        pdb_conversion_history_entries=pulumi.get(__ret__, 'pdb_conversion_history_entries'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_database_pdb_conversion_history_entries)
def get_database_pdb_conversion_history_entries_output(database_id: Optional[pulumi.Input[str]] = None,
                                                       filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDatabasePdbConversionHistoryEntriesFilterArgs']]]]] = None,
                                                       pdb_conversion_action: Optional[pulumi.Input[Optional[str]]] = None,
                                                       state: Optional[pulumi.Input[Optional[str]]] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabasePdbConversionHistoryEntriesResult]:
    """
    This data source provides the list of Database Pdb Conversion History Entries in Oracle Cloud Infrastructure Database service.

    Gets the pluggable database conversion history for a specified database in a bare metal or virtual machine DB system.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_pdb_conversion_history_entries = oci.Database.get_database_pdb_conversion_history_entries(database_id=oci_database_database["test_database"]["id"],
        pdb_conversion_action=var["database_pdb_conversion_history_entry_pdb_conversion_action"],
        state=var["database_pdb_conversion_history_entry_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str pdb_conversion_action: A filter to return only the pluggable database conversion history entries that match the specified conversion action. For example, you can use this filter to return only entries for the precheck operation.
    :param str state: A filter to return only the pluggable database conversion history entries that match the specified lifecycle state. For example, you can use this filter to return only entries in the "failed" lifecycle state.
    """
    ...
