# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExternalExadataInfrastructuresResult',
    'AwaitableGetExternalExadataInfrastructuresResult',
    'get_external_exadata_infrastructures',
    'get_external_exadata_infrastructures_output',
]

@pulumi.output_type
class GetExternalExadataInfrastructuresResult:
    """
    A collection of values returned by getExternalExadataInfrastructures.
    """
    def __init__(__self__, compartment_id=None, display_name=None, external_exadata_infrastructure_collections=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_exadata_infrastructure_collections and not isinstance(external_exadata_infrastructure_collections, list):
            raise TypeError("Expected argument 'external_exadata_infrastructure_collections' to be a list")
        pulumi.set(__self__, "external_exadata_infrastructure_collections", external_exadata_infrastructure_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the Exadata resource. English letters, numbers, "-", "_" and "." only.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalExadataInfrastructureCollections")
    def external_exadata_infrastructure_collections(self) -> Sequence['outputs.GetExternalExadataInfrastructuresExternalExadataInfrastructureCollectionResult']:
        """
        The list of external_exadata_infrastructure_collection.
        """
        return pulumi.get(self, "external_exadata_infrastructure_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExternalExadataInfrastructuresFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetExternalExadataInfrastructuresResult(GetExternalExadataInfrastructuresResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalExadataInfrastructuresResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            external_exadata_infrastructure_collections=self.external_exadata_infrastructure_collections,
            filters=self.filters,
            id=self.id)


def get_external_exadata_infrastructures(compartment_id: Optional[str] = None,
                                         display_name: Optional[str] = None,
                                         filters: Optional[Sequence[pulumi.InputType['GetExternalExadataInfrastructuresFilterArgs']]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalExadataInfrastructuresResult:
    """
    This data source provides the list of External Exadata Infrastructures in Oracle Cloud Infrastructure Database Management service.

    Lists the Exadata infrastructure resources in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_infrastructures = oci.DatabaseManagement.get_external_exadata_infrastructures(compartment_id=var["compartment_id"],
        display_name=var["external_exadata_infrastructure_display_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: The optional single value query filter parameter on the entity display name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalExadataInfrastructures:getExternalExadataInfrastructures', __args__, opts=opts, typ=GetExternalExadataInfrastructuresResult).value

    return AwaitableGetExternalExadataInfrastructuresResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_exadata_infrastructure_collections=pulumi.get(__ret__, 'external_exadata_infrastructure_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_external_exadata_infrastructures)
def get_external_exadata_infrastructures_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetExternalExadataInfrastructuresFilterArgs']]]]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalExadataInfrastructuresResult]:
    """
    This data source provides the list of External Exadata Infrastructures in Oracle Cloud Infrastructure Database Management service.

    Lists the Exadata infrastructure resources in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_infrastructures = oci.DatabaseManagement.get_external_exadata_infrastructures(compartment_id=var["compartment_id"],
        display_name=var["external_exadata_infrastructure_display_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: The optional single value query filter parameter on the entity display name.
    """
    ...
