# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCatalogPrivateEndpointsResult',
    'AwaitableGetCatalogPrivateEndpointsResult',
    'get_catalog_private_endpoints',
    'get_catalog_private_endpoints_output',
]

@pulumi.output_type
class GetCatalogPrivateEndpointsResult:
    """
    A collection of values returned by getCatalogPrivateEndpoints.
    """
    def __init__(__self__, catalog_private_endpoints=None, compartment_id=None, display_name=None, filters=None, id=None, state=None):
        if catalog_private_endpoints and not isinstance(catalog_private_endpoints, list):
            raise TypeError("Expected argument 'catalog_private_endpoints' to be a list")
        pulumi.set(__self__, "catalog_private_endpoints", catalog_private_endpoints)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="catalogPrivateEndpoints")
    def catalog_private_endpoints(self) -> Sequence['outputs.GetCatalogPrivateEndpointsCatalogPrivateEndpointResult']:
        """
        The list of catalog_private_endpoints.
        """
        return pulumi.get(self, "catalog_private_endpoints")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Identifier of the compartment this private endpoint belongs to
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Mutable name of the Private Reverse Connection Endpoint
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCatalogPrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the private endpoint resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetCatalogPrivateEndpointsResult(GetCatalogPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogPrivateEndpointsResult(
            catalog_private_endpoints=self.catalog_private_endpoints,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_catalog_private_endpoints(compartment_id: Optional[str] = None,
                                  display_name: Optional[str] = None,
                                  filters: Optional[Sequence[pulumi.InputType['GetCatalogPrivateEndpointsFilterArgs']]] = None,
                                  state: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogPrivateEndpointsResult:
    """
    This data source provides the list of Catalog Private Endpoints in Oracle Cloud Infrastructure Data Catalog service.

    Returns a list of all the catalog private endpoints in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog_private_endpoints = oci.DataCatalog.get_catalog_private_endpoints(compartment_id=var["compartment_id"],
        display_name=var["catalog_private_endpoint_display_name"],
        state=var["catalog_private_endpoint_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment where you want to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataCatalog/getCatalogPrivateEndpoints:getCatalogPrivateEndpoints', __args__, opts=opts, typ=GetCatalogPrivateEndpointsResult).value

    return AwaitableGetCatalogPrivateEndpointsResult(
        catalog_private_endpoints=pulumi.get(__ret__, 'catalog_private_endpoints'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_catalog_private_endpoints)
def get_catalog_private_endpoints_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                         display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetCatalogPrivateEndpointsFilterArgs']]]]] = None,
                                         state: Optional[pulumi.Input[Optional[str]]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCatalogPrivateEndpointsResult]:
    """
    This data source provides the list of Catalog Private Endpoints in Oracle Cloud Infrastructure Data Catalog service.

    Returns a list of all the catalog private endpoints in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog_private_endpoints = oci.DataCatalog.get_catalog_private_endpoints(compartment_id=var["compartment_id"],
        display_name=var["catalog_private_endpoint_display_name"],
        state=var["catalog_private_endpoint_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment where you want to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    """
    ...
