# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceApplicationTaskScheduleArgs', 'WorkspaceApplicationTaskSchedule']

@pulumi.input_type
class WorkspaceApplicationTaskScheduleArgs:
    def __init__(__self__, *,
                 application_key: pulumi.Input[str],
                 identifier: pulumi.Input[str],
                 workspace_id: pulumi.Input[str],
                 auth_mode: Optional[pulumi.Input[str]] = None,
                 config_provider_delegate: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 end_time_millis: Optional[pulumi.Input[str]] = None,
                 expected_duration: Optional[pulumi.Input[float]] = None,
                 expected_duration_unit: Optional[pulumi.Input[str]] = None,
                 is_backfill_enabled: Optional[pulumi.Input[bool]] = None,
                 is_concurrent_allowed: Optional[pulumi.Input[bool]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_run_time_millis: Optional[pulumi.Input[str]] = None,
                 number_of_retries: Optional[pulumi.Input[int]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 object_version: Optional[pulumi.Input[int]] = None,
                 parent_ref: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']] = None,
                 retry_delay: Optional[pulumi.Input[float]] = None,
                 retry_delay_unit: Optional[pulumi.Input[str]] = None,
                 schedule_ref: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']] = None,
                 start_time_millis: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WorkspaceApplicationTaskSchedule resource.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[str] identifier: (Updatable) The identifier of the aggregator.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] auth_mode: (Updatable) The authorization mode for the task.
        :param pulumi.Input[str] config_provider_delegate: (Updatable) The information about the configuration provider.
        :param pulumi.Input[str] description: (Updatable) The description of the aggregator.
        :param pulumi.Input[str] end_time_millis: (Updatable) The end time in milliseconds.
        :param pulumi.Input[float] expected_duration: (Updatable) The expected duration of the task execution.
        :param pulumi.Input[str] expected_duration_unit: (Updatable) The expected duration unit of the task execution.
        :param pulumi.Input[bool] is_backfill_enabled: (Updatable) Whether the backfill is enabled.
        :param pulumi.Input[bool] is_concurrent_allowed: (Updatable) Whether the same task can be executed concurrently.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the task schedule is enabled.
        :param pulumi.Input[str] key: (Updatable) The key of the aggregator object.
        :param pulumi.Input[str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] number_of_retries: (Updatable) The number of retries.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs'] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs'] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[float] retry_delay: (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        :param pulumi.Input[str] retry_delay_unit: (Updatable) The unit for the retry delay.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs'] schedule_ref: (Updatable) The schedule object
        :param pulumi.Input[str] start_time_millis: (Updatable) The start time in milliseconds.
        """
        pulumi.set(__self__, "application_key", application_key)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if config_provider_delegate is not None:
            pulumi.set(__self__, "config_provider_delegate", config_provider_delegate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time_millis is not None:
            pulumi.set(__self__, "end_time_millis", end_time_millis)
        if expected_duration is not None:
            pulumi.set(__self__, "expected_duration", expected_duration)
        if expected_duration_unit is not None:
            pulumi.set(__self__, "expected_duration_unit", expected_duration_unit)
        if is_backfill_enabled is not None:
            pulumi.set(__self__, "is_backfill_enabled", is_backfill_enabled)
        if is_concurrent_allowed is not None:
            pulumi.set(__self__, "is_concurrent_allowed", is_concurrent_allowed)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_run_time_millis is not None:
            pulumi.set(__self__, "next_run_time_millis", next_run_time_millis)
        if number_of_retries is not None:
            pulumi.set(__self__, "number_of_retries", number_of_retries)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)
        if parent_ref is not None:
            pulumi.set(__self__, "parent_ref", parent_ref)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)
        if retry_delay is not None:
            pulumi.set(__self__, "retry_delay", retry_delay)
        if retry_delay_unit is not None:
            pulumi.set(__self__, "retry_delay_unit", retry_delay_unit)
        if schedule_ref is not None:
            pulumi.set(__self__, "schedule_ref", schedule_ref)
        if start_time_millis is not None:
            pulumi.set(__self__, "start_time_millis", start_time_millis)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Input[str]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_key", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        (Updatable) The identifier of the aggregator.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The authorization mode for the task.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_mode", value)

    @property
    @pulumi.getter(name="configProviderDelegate")
    def config_provider_delegate(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The information about the configuration provider.
        """
        return pulumi.get(self, "config_provider_delegate")

    @config_provider_delegate.setter
    def config_provider_delegate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_provider_delegate", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the aggregator.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endTimeMillis")
    def end_time_millis(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The end time in milliseconds.
        """
        return pulumi.get(self, "end_time_millis")

    @end_time_millis.setter
    def end_time_millis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time_millis", value)

    @property
    @pulumi.getter(name="expectedDuration")
    def expected_duration(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The expected duration of the task execution.
        """
        return pulumi.get(self, "expected_duration")

    @expected_duration.setter
    def expected_duration(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "expected_duration", value)

    @property
    @pulumi.getter(name="expectedDurationUnit")
    def expected_duration_unit(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The expected duration unit of the task execution.
        """
        return pulumi.get(self, "expected_duration_unit")

    @expected_duration_unit.setter
    def expected_duration_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_duration_unit", value)

    @property
    @pulumi.getter(name="isBackfillEnabled")
    def is_backfill_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the backfill is enabled.
        """
        return pulumi.get(self, "is_backfill_enabled")

    @is_backfill_enabled.setter
    def is_backfill_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_backfill_enabled", value)

    @property
    @pulumi.getter(name="isConcurrentAllowed")
    def is_concurrent_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the same task can be executed concurrently.
        """
        return pulumi.get(self, "is_concurrent_allowed")

    @is_concurrent_allowed.setter
    def is_concurrent_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_concurrent_allowed", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the task schedule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The key of the aggregator object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextRunTimeMillis")
    def next_run_time_millis(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "next_run_time_millis")

    @next_run_time_millis.setter
    def next_run_time_millis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_run_time_millis", value)

    @property
    @pulumi.getter(name="numberOfRetries")
    def number_of_retries(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of retries.
        """
        return pulumi.get(self, "number_of_retries")

    @number_of_retries.setter
    def number_of_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_retries", value)

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_status", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_version", value)

    @property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']]:
        """
        (Updatable) A reference to the object's parent.
        """
        return pulumi.get(self, "parent_ref")

    @parent_ref.setter
    def parent_ref(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']]):
        pulumi.set(self, "parent_ref", value)

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']]:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)

    @property
    @pulumi.getter(name="retryDelay")
    def retry_delay(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        """
        return pulumi.get(self, "retry_delay")

    @retry_delay.setter
    def retry_delay(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "retry_delay", value)

    @property
    @pulumi.getter(name="retryDelayUnit")
    def retry_delay_unit(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The unit for the retry delay.
        """
        return pulumi.get(self, "retry_delay_unit")

    @retry_delay_unit.setter
    def retry_delay_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retry_delay_unit", value)

    @property
    @pulumi.getter(name="scheduleRef")
    def schedule_ref(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']]:
        """
        (Updatable) The schedule object
        """
        return pulumi.get(self, "schedule_ref")

    @schedule_ref.setter
    def schedule_ref(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']]):
        pulumi.set(self, "schedule_ref", value)

    @property
    @pulumi.getter(name="startTimeMillis")
    def start_time_millis(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The start time in milliseconds.
        """
        return pulumi.get(self, "start_time_millis")

    @start_time_millis.setter
    def start_time_millis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time_millis", value)


@pulumi.input_type
class _WorkspaceApplicationTaskScheduleState:
    def __init__(__self__, *,
                 application_key: Optional[pulumi.Input[str]] = None,
                 auth_mode: Optional[pulumi.Input[str]] = None,
                 config_provider_delegate: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 end_time_millis: Optional[pulumi.Input[str]] = None,
                 expected_duration: Optional[pulumi.Input[float]] = None,
                 expected_duration_unit: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 is_backfill_enabled: Optional[pulumi.Input[bool]] = None,
                 is_concurrent_allowed: Optional[pulumi.Input[bool]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 last_run_details: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleLastRunDetailArgs']]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleMetadataArgs']]]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_run_time_millis: Optional[pulumi.Input[str]] = None,
                 number_of_retries: Optional[pulumi.Input[int]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 object_version: Optional[pulumi.Input[int]] = None,
                 parent_ref: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']] = None,
                 retry_attempts: Optional[pulumi.Input[int]] = None,
                 retry_delay: Optional[pulumi.Input[float]] = None,
                 retry_delay_unit: Optional[pulumi.Input[str]] = None,
                 schedule_ref: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']] = None,
                 start_time_millis: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceApplicationTaskSchedule resources.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[str] auth_mode: (Updatable) The authorization mode for the task.
        :param pulumi.Input[str] config_provider_delegate: (Updatable) The information about the configuration provider.
        :param pulumi.Input[str] description: (Updatable) The description of the aggregator.
        :param pulumi.Input[str] end_time_millis: (Updatable) The end time in milliseconds.
        :param pulumi.Input[float] expected_duration: (Updatable) The expected duration of the task execution.
        :param pulumi.Input[str] expected_duration_unit: (Updatable) The expected duration unit of the task execution.
        :param pulumi.Input[str] identifier: (Updatable) The identifier of the aggregator.
        :param pulumi.Input[bool] is_backfill_enabled: (Updatable) Whether the backfill is enabled.
        :param pulumi.Input[bool] is_concurrent_allowed: (Updatable) Whether the same task can be executed concurrently.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the task schedule is enabled.
        :param pulumi.Input[str] key: (Updatable) The key of the aggregator object.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleLastRunDetailArgs']]] last_run_details: The last run details for the task run.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleMetadataArgs']]] metadatas: (Updatable) A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[str] model_type: (Updatable) The type of the object.
        :param pulumi.Input[str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] number_of_retries: (Updatable) The number of retries.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs'] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs'] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[int] retry_attempts: The number of retry attempts.
        :param pulumi.Input[float] retry_delay: (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        :param pulumi.Input[str] retry_delay_unit: (Updatable) The unit for the retry delay.
        :param pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs'] schedule_ref: (Updatable) The schedule object
        :param pulumi.Input[str] start_time_millis: (Updatable) The start time in milliseconds.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if application_key is not None:
            pulumi.set(__self__, "application_key", application_key)
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if config_provider_delegate is not None:
            pulumi.set(__self__, "config_provider_delegate", config_provider_delegate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time_millis is not None:
            pulumi.set(__self__, "end_time_millis", end_time_millis)
        if expected_duration is not None:
            pulumi.set(__self__, "expected_duration", expected_duration)
        if expected_duration_unit is not None:
            pulumi.set(__self__, "expected_duration_unit", expected_duration_unit)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if is_backfill_enabled is not None:
            pulumi.set(__self__, "is_backfill_enabled", is_backfill_enabled)
        if is_concurrent_allowed is not None:
            pulumi.set(__self__, "is_concurrent_allowed", is_concurrent_allowed)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if last_run_details is not None:
            pulumi.set(__self__, "last_run_details", last_run_details)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_run_time_millis is not None:
            pulumi.set(__self__, "next_run_time_millis", next_run_time_millis)
        if number_of_retries is not None:
            pulumi.set(__self__, "number_of_retries", number_of_retries)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)
        if parent_ref is not None:
            pulumi.set(__self__, "parent_ref", parent_ref)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)
        if retry_attempts is not None:
            pulumi.set(__self__, "retry_attempts", retry_attempts)
        if retry_delay is not None:
            pulumi.set(__self__, "retry_delay", retry_delay)
        if retry_delay_unit is not None:
            pulumi.set(__self__, "retry_delay_unit", retry_delay_unit)
        if schedule_ref is not None:
            pulumi.set(__self__, "schedule_ref", schedule_ref)
        if start_time_millis is not None:
            pulumi.set(__self__, "start_time_millis", start_time_millis)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> Optional[pulumi.Input[str]]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_key", value)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The authorization mode for the task.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_mode", value)

    @property
    @pulumi.getter(name="configProviderDelegate")
    def config_provider_delegate(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The information about the configuration provider.
        """
        return pulumi.get(self, "config_provider_delegate")

    @config_provider_delegate.setter
    def config_provider_delegate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_provider_delegate", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the aggregator.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endTimeMillis")
    def end_time_millis(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The end time in milliseconds.
        """
        return pulumi.get(self, "end_time_millis")

    @end_time_millis.setter
    def end_time_millis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time_millis", value)

    @property
    @pulumi.getter(name="expectedDuration")
    def expected_duration(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The expected duration of the task execution.
        """
        return pulumi.get(self, "expected_duration")

    @expected_duration.setter
    def expected_duration(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "expected_duration", value)

    @property
    @pulumi.getter(name="expectedDurationUnit")
    def expected_duration_unit(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The expected duration unit of the task execution.
        """
        return pulumi.get(self, "expected_duration_unit")

    @expected_duration_unit.setter
    def expected_duration_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_duration_unit", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The identifier of the aggregator.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="isBackfillEnabled")
    def is_backfill_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the backfill is enabled.
        """
        return pulumi.get(self, "is_backfill_enabled")

    @is_backfill_enabled.setter
    def is_backfill_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_backfill_enabled", value)

    @property
    @pulumi.getter(name="isConcurrentAllowed")
    def is_concurrent_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the same task can be executed concurrently.
        """
        return pulumi.get(self, "is_concurrent_allowed")

    @is_concurrent_allowed.setter
    def is_concurrent_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_concurrent_allowed", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the task schedule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The key of the aggregator object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="lastRunDetails")
    def last_run_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleLastRunDetailArgs']]]]:
        """
        The last run details for the task run.
        """
        return pulumi.get(self, "last_run_details")

    @last_run_details.setter
    def last_run_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleLastRunDetailArgs']]]]):
        pulumi.set(self, "last_run_details", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleMetadataArgs']]]]:
        """
        (Updatable) A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationTaskScheduleMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of the object.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextRunTimeMillis")
    def next_run_time_millis(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "next_run_time_millis")

    @next_run_time_millis.setter
    def next_run_time_millis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_run_time_millis", value)

    @property
    @pulumi.getter(name="numberOfRetries")
    def number_of_retries(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of retries.
        """
        return pulumi.get(self, "number_of_retries")

    @number_of_retries.setter
    def number_of_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_retries", value)

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_status", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_version", value)

    @property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']]:
        """
        (Updatable) A reference to the object's parent.
        """
        return pulumi.get(self, "parent_ref")

    @parent_ref.setter
    def parent_ref(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleParentRefArgs']]):
        pulumi.set(self, "parent_ref", value)

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']]:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)

    @property
    @pulumi.getter(name="retryAttempts")
    def retry_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        The number of retry attempts.
        """
        return pulumi.get(self, "retry_attempts")

    @retry_attempts.setter
    def retry_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry_attempts", value)

    @property
    @pulumi.getter(name="retryDelay")
    def retry_delay(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        """
        return pulumi.get(self, "retry_delay")

    @retry_delay.setter
    def retry_delay(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "retry_delay", value)

    @property
    @pulumi.getter(name="retryDelayUnit")
    def retry_delay_unit(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The unit for the retry delay.
        """
        return pulumi.get(self, "retry_delay_unit")

    @retry_delay_unit.setter
    def retry_delay_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retry_delay_unit", value)

    @property
    @pulumi.getter(name="scheduleRef")
    def schedule_ref(self) -> Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']]:
        """
        (Updatable) The schedule object
        """
        return pulumi.get(self, "schedule_ref")

    @schedule_ref.setter
    def schedule_ref(self, value: Optional[pulumi.Input['WorkspaceApplicationTaskScheduleScheduleRefArgs']]):
        pulumi.set(self, "schedule_ref", value)

    @property
    @pulumi.getter(name="startTimeMillis")
    def start_time_millis(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The start time in milliseconds.
        """
        return pulumi.get(self, "start_time_millis")

    @start_time_millis.setter
    def start_time_millis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time_millis", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


class WorkspaceApplicationTaskSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_key: Optional[pulumi.Input[str]] = None,
                 auth_mode: Optional[pulumi.Input[str]] = None,
                 config_provider_delegate: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 end_time_millis: Optional[pulumi.Input[str]] = None,
                 expected_duration: Optional[pulumi.Input[float]] = None,
                 expected_duration_unit: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 is_backfill_enabled: Optional[pulumi.Input[bool]] = None,
                 is_concurrent_allowed: Optional[pulumi.Input[bool]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_run_time_millis: Optional[pulumi.Input[str]] = None,
                 number_of_retries: Optional[pulumi.Input[int]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 object_version: Optional[pulumi.Input[int]] = None,
                 parent_ref: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleParentRefArgs']]] = None,
                 registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']]] = None,
                 retry_delay: Optional[pulumi.Input[float]] = None,
                 retry_delay_unit: Optional[pulumi.Input[str]] = None,
                 schedule_ref: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleScheduleRefArgs']]] = None,
                 start_time_millis: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Workspace Application Task Schedule resource in Oracle Cloud Infrastructure Data Integration service.

        Endpoint to be used create TaskSchedule.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_application_task_schedule = oci.data_integration.WorkspaceApplicationTaskSchedule("testWorkspaceApplicationTaskSchedule",
            application_key=var["workspace_application_task_schedule_application_key"],
            identifier=var["workspace_application_task_schedule_identifier"],
            workspace_id=oci_dataintegration_workspace["test_workspace"]["id"],
            auth_mode=var["workspace_application_task_schedule_auth_mode"],
            config_provider_delegate=var["workspace_application_task_schedule_config_provider_delegate"],
            description=var["workspace_application_task_schedule_description"],
            end_time_millis=var["workspace_application_task_schedule_end_time_millis"],
            expected_duration=var["workspace_application_task_schedule_expected_duration"],
            expected_duration_unit=var["workspace_application_task_schedule_expected_duration_unit"],
            is_backfill_enabled=var["workspace_application_task_schedule_is_backfill_enabled"],
            is_concurrent_allowed=var["workspace_application_task_schedule_is_concurrent_allowed"],
            is_enabled=var["workspace_application_task_schedule_is_enabled"],
            key=var["workspace_application_task_schedule_key"],
            model_version=var["workspace_application_task_schedule_model_version"],
            number_of_retries=var["workspace_application_task_schedule_number_of_retries"],
            object_status=var["workspace_application_task_schedule_object_status"],
            object_version=var["workspace_application_task_schedule_object_version"],
            parent_ref=oci.data_integration.WorkspaceApplicationTaskScheduleParentRefArgs(
                parent=var["workspace_application_task_schedule_parent_ref_parent"],
                root_doc_id=oci_dataintegration_root_doc["test_root_doc"]["id"],
            ),
            registry_metadata=oci.data_integration.WorkspaceApplicationTaskScheduleRegistryMetadataArgs(
                aggregator_key=var["workspace_application_task_schedule_registry_metadata_aggregator_key"],
                is_favorite=var["workspace_application_task_schedule_registry_metadata_is_favorite"],
                key=var["workspace_application_task_schedule_registry_metadata_key"],
                labels=var["workspace_application_task_schedule_registry_metadata_labels"],
                registry_version=var["workspace_application_task_schedule_registry_metadata_registry_version"],
            ),
            retry_delay=var["workspace_application_task_schedule_retry_delay"],
            retry_delay_unit=var["workspace_application_task_schedule_retry_delay_unit"],
            schedule_ref=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefArgs(
                description=var["workspace_application_task_schedule_schedule_ref_description"],
                frequency_details=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefFrequencyDetailsArgs(
                    model_type=var["workspace_application_task_schedule_schedule_ref_frequency_details_model_type"],
                    custom_expression=var["workspace_application_task_schedule_schedule_ref_frequency_details_custom_expression"],
                    day_of_week=var["workspace_application_task_schedule_schedule_ref_frequency_details_day_of_week"],
                    days=var["workspace_application_task_schedule_schedule_ref_frequency_details_days"],
                    frequency=var["workspace_application_task_schedule_schedule_ref_frequency_details_frequency"],
                    interval=var["workspace_application_task_schedule_schedule_ref_frequency_details_interval"],
                    time=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefFrequencyDetailsTimeArgs(
                        hour=var["workspace_application_task_schedule_schedule_ref_frequency_details_time_hour"],
                        minute=var["workspace_application_task_schedule_schedule_ref_frequency_details_time_minute"],
                        second=var["workspace_application_task_schedule_schedule_ref_frequency_details_time_second"],
                    ),
                    week_of_month=var["workspace_application_task_schedule_schedule_ref_frequency_details_week_of_month"],
                ),
                identifier=var["workspace_application_task_schedule_schedule_ref_identifier"],
                is_daylight_adjustment_enabled=var["workspace_application_task_schedule_schedule_ref_is_daylight_adjustment_enabled"],
                key=var["workspace_application_task_schedule_schedule_ref_key"],
                metadata=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefMetadataArgs(
                    aggregator=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefMetadataAggregatorArgs(
                        description=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_description"],
                        identifier=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_identifier"],
                        key=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_key"],
                        name=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_name"],
                        type=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_type"],
                    ),
                    aggregator_key=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_key"],
                    count_statistics=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefMetadataCountStatisticsArgs(
                        object_type_count_lists=[oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefMetadataCountStatisticsObjectTypeCountListArgs(
                            object_count=var["workspace_application_task_schedule_schedule_ref_metadata_count_statistics_object_type_count_list_object_count"],
                            object_type=var["workspace_application_task_schedule_schedule_ref_metadata_count_statistics_object_type_count_list_object_type"],
                        )],
                    ),
                    created_by=var["workspace_application_task_schedule_schedule_ref_metadata_created_by"],
                    created_by_name=var["workspace_application_task_schedule_schedule_ref_metadata_created_by_name"],
                    identifier_path=var["workspace_application_task_schedule_schedule_ref_metadata_identifier_path"],
                    info_fields=var["workspace_application_task_schedule_schedule_ref_metadata_info_fields"],
                    is_favorite=var["workspace_application_task_schedule_schedule_ref_metadata_is_favorite"],
                    labels=var["workspace_application_task_schedule_schedule_ref_metadata_labels"],
                    registry_version=var["workspace_application_task_schedule_schedule_ref_metadata_registry_version"],
                    time_created=var["workspace_application_task_schedule_schedule_ref_metadata_time_created"],
                    time_updated=var["workspace_application_task_schedule_schedule_ref_metadata_time_updated"],
                    updated_by=var["workspace_application_task_schedule_schedule_ref_metadata_updated_by"],
                    updated_by_name=var["workspace_application_task_schedule_schedule_ref_metadata_updated_by_name"],
                ),
                model_type=var["workspace_application_task_schedule_schedule_ref_model_type"],
                model_version=var["workspace_application_task_schedule_schedule_ref_model_version"],
                name=var["workspace_application_task_schedule_schedule_ref_name"],
                object_status=var["workspace_application_task_schedule_schedule_ref_object_status"],
                object_version=var["workspace_application_task_schedule_schedule_ref_object_version"],
                parent_ref=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefParentRefArgs(
                    parent=var["workspace_application_task_schedule_schedule_ref_parent_ref_parent"],
                    root_doc_id=oci_dataintegration_root_doc["test_root_doc"]["id"],
                ),
                timezone=var["workspace_application_task_schedule_schedule_ref_timezone"],
            ),
            start_time_millis=var["workspace_application_task_schedule_start_time_millis"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        WorkspaceApplicationTaskSchedules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceApplicationTaskSchedule:WorkspaceApplicationTaskSchedule test_workspace_application_task_schedule "workspaces/{workspaceId}/applications/{applicationKey}/taskSchedules/{taskScheduleKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[str] auth_mode: (Updatable) The authorization mode for the task.
        :param pulumi.Input[str] config_provider_delegate: (Updatable) The information about the configuration provider.
        :param pulumi.Input[str] description: (Updatable) The description of the aggregator.
        :param pulumi.Input[str] end_time_millis: (Updatable) The end time in milliseconds.
        :param pulumi.Input[float] expected_duration: (Updatable) The expected duration of the task execution.
        :param pulumi.Input[str] expected_duration_unit: (Updatable) The expected duration unit of the task execution.
        :param pulumi.Input[str] identifier: (Updatable) The identifier of the aggregator.
        :param pulumi.Input[bool] is_backfill_enabled: (Updatable) Whether the backfill is enabled.
        :param pulumi.Input[bool] is_concurrent_allowed: (Updatable) Whether the same task can be executed concurrently.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the task schedule is enabled.
        :param pulumi.Input[str] key: (Updatable) The key of the aggregator object.
        :param pulumi.Input[str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] number_of_retries: (Updatable) The number of retries.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleParentRefArgs']] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[float] retry_delay: (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        :param pulumi.Input[str] retry_delay_unit: (Updatable) The unit for the retry delay.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleScheduleRefArgs']] schedule_ref: (Updatable) The schedule object
        :param pulumi.Input[str] start_time_millis: (Updatable) The start time in milliseconds.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceApplicationTaskScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Workspace Application Task Schedule resource in Oracle Cloud Infrastructure Data Integration service.

        Endpoint to be used create TaskSchedule.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_application_task_schedule = oci.data_integration.WorkspaceApplicationTaskSchedule("testWorkspaceApplicationTaskSchedule",
            application_key=var["workspace_application_task_schedule_application_key"],
            identifier=var["workspace_application_task_schedule_identifier"],
            workspace_id=oci_dataintegration_workspace["test_workspace"]["id"],
            auth_mode=var["workspace_application_task_schedule_auth_mode"],
            config_provider_delegate=var["workspace_application_task_schedule_config_provider_delegate"],
            description=var["workspace_application_task_schedule_description"],
            end_time_millis=var["workspace_application_task_schedule_end_time_millis"],
            expected_duration=var["workspace_application_task_schedule_expected_duration"],
            expected_duration_unit=var["workspace_application_task_schedule_expected_duration_unit"],
            is_backfill_enabled=var["workspace_application_task_schedule_is_backfill_enabled"],
            is_concurrent_allowed=var["workspace_application_task_schedule_is_concurrent_allowed"],
            is_enabled=var["workspace_application_task_schedule_is_enabled"],
            key=var["workspace_application_task_schedule_key"],
            model_version=var["workspace_application_task_schedule_model_version"],
            number_of_retries=var["workspace_application_task_schedule_number_of_retries"],
            object_status=var["workspace_application_task_schedule_object_status"],
            object_version=var["workspace_application_task_schedule_object_version"],
            parent_ref=oci.data_integration.WorkspaceApplicationTaskScheduleParentRefArgs(
                parent=var["workspace_application_task_schedule_parent_ref_parent"],
                root_doc_id=oci_dataintegration_root_doc["test_root_doc"]["id"],
            ),
            registry_metadata=oci.data_integration.WorkspaceApplicationTaskScheduleRegistryMetadataArgs(
                aggregator_key=var["workspace_application_task_schedule_registry_metadata_aggregator_key"],
                is_favorite=var["workspace_application_task_schedule_registry_metadata_is_favorite"],
                key=var["workspace_application_task_schedule_registry_metadata_key"],
                labels=var["workspace_application_task_schedule_registry_metadata_labels"],
                registry_version=var["workspace_application_task_schedule_registry_metadata_registry_version"],
            ),
            retry_delay=var["workspace_application_task_schedule_retry_delay"],
            retry_delay_unit=var["workspace_application_task_schedule_retry_delay_unit"],
            schedule_ref=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefArgs(
                description=var["workspace_application_task_schedule_schedule_ref_description"],
                frequency_details=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefFrequencyDetailsArgs(
                    model_type=var["workspace_application_task_schedule_schedule_ref_frequency_details_model_type"],
                    custom_expression=var["workspace_application_task_schedule_schedule_ref_frequency_details_custom_expression"],
                    day_of_week=var["workspace_application_task_schedule_schedule_ref_frequency_details_day_of_week"],
                    days=var["workspace_application_task_schedule_schedule_ref_frequency_details_days"],
                    frequency=var["workspace_application_task_schedule_schedule_ref_frequency_details_frequency"],
                    interval=var["workspace_application_task_schedule_schedule_ref_frequency_details_interval"],
                    time=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefFrequencyDetailsTimeArgs(
                        hour=var["workspace_application_task_schedule_schedule_ref_frequency_details_time_hour"],
                        minute=var["workspace_application_task_schedule_schedule_ref_frequency_details_time_minute"],
                        second=var["workspace_application_task_schedule_schedule_ref_frequency_details_time_second"],
                    ),
                    week_of_month=var["workspace_application_task_schedule_schedule_ref_frequency_details_week_of_month"],
                ),
                identifier=var["workspace_application_task_schedule_schedule_ref_identifier"],
                is_daylight_adjustment_enabled=var["workspace_application_task_schedule_schedule_ref_is_daylight_adjustment_enabled"],
                key=var["workspace_application_task_schedule_schedule_ref_key"],
                metadata=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefMetadataArgs(
                    aggregator=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefMetadataAggregatorArgs(
                        description=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_description"],
                        identifier=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_identifier"],
                        key=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_key"],
                        name=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_name"],
                        type=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_type"],
                    ),
                    aggregator_key=var["workspace_application_task_schedule_schedule_ref_metadata_aggregator_key"],
                    count_statistics=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefMetadataCountStatisticsArgs(
                        object_type_count_lists=[oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefMetadataCountStatisticsObjectTypeCountListArgs(
                            object_count=var["workspace_application_task_schedule_schedule_ref_metadata_count_statistics_object_type_count_list_object_count"],
                            object_type=var["workspace_application_task_schedule_schedule_ref_metadata_count_statistics_object_type_count_list_object_type"],
                        )],
                    ),
                    created_by=var["workspace_application_task_schedule_schedule_ref_metadata_created_by"],
                    created_by_name=var["workspace_application_task_schedule_schedule_ref_metadata_created_by_name"],
                    identifier_path=var["workspace_application_task_schedule_schedule_ref_metadata_identifier_path"],
                    info_fields=var["workspace_application_task_schedule_schedule_ref_metadata_info_fields"],
                    is_favorite=var["workspace_application_task_schedule_schedule_ref_metadata_is_favorite"],
                    labels=var["workspace_application_task_schedule_schedule_ref_metadata_labels"],
                    registry_version=var["workspace_application_task_schedule_schedule_ref_metadata_registry_version"],
                    time_created=var["workspace_application_task_schedule_schedule_ref_metadata_time_created"],
                    time_updated=var["workspace_application_task_schedule_schedule_ref_metadata_time_updated"],
                    updated_by=var["workspace_application_task_schedule_schedule_ref_metadata_updated_by"],
                    updated_by_name=var["workspace_application_task_schedule_schedule_ref_metadata_updated_by_name"],
                ),
                model_type=var["workspace_application_task_schedule_schedule_ref_model_type"],
                model_version=var["workspace_application_task_schedule_schedule_ref_model_version"],
                name=var["workspace_application_task_schedule_schedule_ref_name"],
                object_status=var["workspace_application_task_schedule_schedule_ref_object_status"],
                object_version=var["workspace_application_task_schedule_schedule_ref_object_version"],
                parent_ref=oci.data_integration.WorkspaceApplicationTaskScheduleScheduleRefParentRefArgs(
                    parent=var["workspace_application_task_schedule_schedule_ref_parent_ref_parent"],
                    root_doc_id=oci_dataintegration_root_doc["test_root_doc"]["id"],
                ),
                timezone=var["workspace_application_task_schedule_schedule_ref_timezone"],
            ),
            start_time_millis=var["workspace_application_task_schedule_start_time_millis"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        WorkspaceApplicationTaskSchedules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceApplicationTaskSchedule:WorkspaceApplicationTaskSchedule test_workspace_application_task_schedule "workspaces/{workspaceId}/applications/{applicationKey}/taskSchedules/{taskScheduleKey}"
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceApplicationTaskScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceApplicationTaskScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_key: Optional[pulumi.Input[str]] = None,
                 auth_mode: Optional[pulumi.Input[str]] = None,
                 config_provider_delegate: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 end_time_millis: Optional[pulumi.Input[str]] = None,
                 expected_duration: Optional[pulumi.Input[float]] = None,
                 expected_duration_unit: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 is_backfill_enabled: Optional[pulumi.Input[bool]] = None,
                 is_concurrent_allowed: Optional[pulumi.Input[bool]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_run_time_millis: Optional[pulumi.Input[str]] = None,
                 number_of_retries: Optional[pulumi.Input[int]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 object_version: Optional[pulumi.Input[int]] = None,
                 parent_ref: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleParentRefArgs']]] = None,
                 registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']]] = None,
                 retry_delay: Optional[pulumi.Input[float]] = None,
                 retry_delay_unit: Optional[pulumi.Input[str]] = None,
                 schedule_ref: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleScheduleRefArgs']]] = None,
                 start_time_millis: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceApplicationTaskScheduleArgs.__new__(WorkspaceApplicationTaskScheduleArgs)

            if application_key is None and not opts.urn:
                raise TypeError("Missing required property 'application_key'")
            __props__.__dict__["application_key"] = application_key
            __props__.__dict__["auth_mode"] = auth_mode
            __props__.__dict__["config_provider_delegate"] = config_provider_delegate
            __props__.__dict__["description"] = description
            __props__.__dict__["end_time_millis"] = end_time_millis
            __props__.__dict__["expected_duration"] = expected_duration
            __props__.__dict__["expected_duration_unit"] = expected_duration_unit
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["is_backfill_enabled"] = is_backfill_enabled
            __props__.__dict__["is_concurrent_allowed"] = is_concurrent_allowed
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["key"] = key
            __props__.__dict__["model_version"] = model_version
            __props__.__dict__["name"] = name
            __props__.__dict__["next_run_time_millis"] = next_run_time_millis
            __props__.__dict__["number_of_retries"] = number_of_retries
            __props__.__dict__["object_status"] = object_status
            __props__.__dict__["object_version"] = object_version
            __props__.__dict__["parent_ref"] = parent_ref
            __props__.__dict__["registry_metadata"] = registry_metadata
            __props__.__dict__["retry_delay"] = retry_delay
            __props__.__dict__["retry_delay_unit"] = retry_delay_unit
            __props__.__dict__["schedule_ref"] = schedule_ref
            __props__.__dict__["start_time_millis"] = start_time_millis
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["last_run_details"] = None
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["model_type"] = None
            __props__.__dict__["retry_attempts"] = None
        super(WorkspaceApplicationTaskSchedule, __self__).__init__(
            'oci:DataIntegration/workspaceApplicationTaskSchedule:WorkspaceApplicationTaskSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_key: Optional[pulumi.Input[str]] = None,
            auth_mode: Optional[pulumi.Input[str]] = None,
            config_provider_delegate: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            end_time_millis: Optional[pulumi.Input[str]] = None,
            expected_duration: Optional[pulumi.Input[float]] = None,
            expected_duration_unit: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            is_backfill_enabled: Optional[pulumi.Input[bool]] = None,
            is_concurrent_allowed: Optional[pulumi.Input[bool]] = None,
            is_enabled: Optional[pulumi.Input[bool]] = None,
            key: Optional[pulumi.Input[str]] = None,
            last_run_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleLastRunDetailArgs']]]]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleMetadataArgs']]]]] = None,
            model_type: Optional[pulumi.Input[str]] = None,
            model_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            next_run_time_millis: Optional[pulumi.Input[str]] = None,
            number_of_retries: Optional[pulumi.Input[int]] = None,
            object_status: Optional[pulumi.Input[int]] = None,
            object_version: Optional[pulumi.Input[int]] = None,
            parent_ref: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleParentRefArgs']]] = None,
            registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']]] = None,
            retry_attempts: Optional[pulumi.Input[int]] = None,
            retry_delay: Optional[pulumi.Input[float]] = None,
            retry_delay_unit: Optional[pulumi.Input[str]] = None,
            schedule_ref: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleScheduleRefArgs']]] = None,
            start_time_millis: Optional[pulumi.Input[str]] = None,
            workspace_id: Optional[pulumi.Input[str]] = None) -> 'WorkspaceApplicationTaskSchedule':
        """
        Get an existing WorkspaceApplicationTaskSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[str] auth_mode: (Updatable) The authorization mode for the task.
        :param pulumi.Input[str] config_provider_delegate: (Updatable) The information about the configuration provider.
        :param pulumi.Input[str] description: (Updatable) The description of the aggregator.
        :param pulumi.Input[str] end_time_millis: (Updatable) The end time in milliseconds.
        :param pulumi.Input[float] expected_duration: (Updatable) The expected duration of the task execution.
        :param pulumi.Input[str] expected_duration_unit: (Updatable) The expected duration unit of the task execution.
        :param pulumi.Input[str] identifier: (Updatable) The identifier of the aggregator.
        :param pulumi.Input[bool] is_backfill_enabled: (Updatable) Whether the backfill is enabled.
        :param pulumi.Input[bool] is_concurrent_allowed: (Updatable) Whether the same task can be executed concurrently.
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether the task schedule is enabled.
        :param pulumi.Input[str] key: (Updatable) The key of the aggregator object.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleLastRunDetailArgs']]]] last_run_details: The last run details for the task run.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleMetadataArgs']]]] metadatas: (Updatable) A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[str] model_type: (Updatable) The type of the object.
        :param pulumi.Input[str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] number_of_retries: (Updatable) The number of retries.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleParentRefArgs']] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleRegistryMetadataArgs']] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[int] retry_attempts: The number of retry attempts.
        :param pulumi.Input[float] retry_delay: (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        :param pulumi.Input[str] retry_delay_unit: (Updatable) The unit for the retry delay.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationTaskScheduleScheduleRefArgs']] schedule_ref: (Updatable) The schedule object
        :param pulumi.Input[str] start_time_millis: (Updatable) The start time in milliseconds.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceApplicationTaskScheduleState.__new__(_WorkspaceApplicationTaskScheduleState)

        __props__.__dict__["application_key"] = application_key
        __props__.__dict__["auth_mode"] = auth_mode
        __props__.__dict__["config_provider_delegate"] = config_provider_delegate
        __props__.__dict__["description"] = description
        __props__.__dict__["end_time_millis"] = end_time_millis
        __props__.__dict__["expected_duration"] = expected_duration
        __props__.__dict__["expected_duration_unit"] = expected_duration_unit
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["is_backfill_enabled"] = is_backfill_enabled
        __props__.__dict__["is_concurrent_allowed"] = is_concurrent_allowed
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["key"] = key
        __props__.__dict__["last_run_details"] = last_run_details
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["model_type"] = model_type
        __props__.__dict__["model_version"] = model_version
        __props__.__dict__["name"] = name
        __props__.__dict__["next_run_time_millis"] = next_run_time_millis
        __props__.__dict__["number_of_retries"] = number_of_retries
        __props__.__dict__["object_status"] = object_status
        __props__.__dict__["object_version"] = object_version
        __props__.__dict__["parent_ref"] = parent_ref
        __props__.__dict__["registry_metadata"] = registry_metadata
        __props__.__dict__["retry_attempts"] = retry_attempts
        __props__.__dict__["retry_delay"] = retry_delay
        __props__.__dict__["retry_delay_unit"] = retry_delay_unit
        __props__.__dict__["schedule_ref"] = schedule_ref
        __props__.__dict__["start_time_millis"] = start_time_millis
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceApplicationTaskSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Output[str]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> pulumi.Output[str]:
        """
        (Updatable) The authorization mode for the task.
        """
        return pulumi.get(self, "auth_mode")

    @property
    @pulumi.getter(name="configProviderDelegate")
    def config_provider_delegate(self) -> pulumi.Output[str]:
        """
        (Updatable) The information about the configuration provider.
        """
        return pulumi.get(self, "config_provider_delegate")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the aggregator.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endTimeMillis")
    def end_time_millis(self) -> pulumi.Output[str]:
        """
        (Updatable) The end time in milliseconds.
        """
        return pulumi.get(self, "end_time_millis")

    @property
    @pulumi.getter(name="expectedDuration")
    def expected_duration(self) -> pulumi.Output[float]:
        """
        (Updatable) The expected duration of the task execution.
        """
        return pulumi.get(self, "expected_duration")

    @property
    @pulumi.getter(name="expectedDurationUnit")
    def expected_duration_unit(self) -> pulumi.Output[str]:
        """
        (Updatable) The expected duration unit of the task execution.
        """
        return pulumi.get(self, "expected_duration_unit")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        (Updatable) The identifier of the aggregator.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="isBackfillEnabled")
    def is_backfill_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether the backfill is enabled.
        """
        return pulumi.get(self, "is_backfill_enabled")

    @property
    @pulumi.getter(name="isConcurrentAllowed")
    def is_concurrent_allowed(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether the same task can be executed concurrently.
        """
        return pulumi.get(self, "is_concurrent_allowed")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether the task schedule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        (Updatable) The key of the aggregator object.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lastRunDetails")
    def last_run_details(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationTaskScheduleLastRunDetail']]:
        """
        The last run details for the task run.
        """
        return pulumi.get(self, "last_run_details")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationTaskScheduleMetadata']]:
        """
        (Updatable) A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of the object.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> pulumi.Output[str]:
        """
        (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextRunTimeMillis")
    def next_run_time_millis(self) -> pulumi.Output[str]:
        return pulumi.get(self, "next_run_time_millis")

    @property
    @pulumi.getter(name="numberOfRetries")
    def number_of_retries(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of retries.
        """
        return pulumi.get(self, "number_of_retries")

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> pulumi.Output[int]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> pulumi.Output[int]:
        """
        (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> pulumi.Output['outputs.WorkspaceApplicationTaskScheduleParentRef']:
        """
        (Updatable) A reference to the object's parent.
        """
        return pulumi.get(self, "parent_ref")

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> pulumi.Output['outputs.WorkspaceApplicationTaskScheduleRegistryMetadata']:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @property
    @pulumi.getter(name="retryAttempts")
    def retry_attempts(self) -> pulumi.Output[int]:
        """
        The number of retry attempts.
        """
        return pulumi.get(self, "retry_attempts")

    @property
    @pulumi.getter(name="retryDelay")
    def retry_delay(self) -> pulumi.Output[float]:
        """
        (Updatable) The retry delay, the unit for measurement is in the property retry delay unit.
        """
        return pulumi.get(self, "retry_delay")

    @property
    @pulumi.getter(name="retryDelayUnit")
    def retry_delay_unit(self) -> pulumi.Output[str]:
        """
        (Updatable) The unit for the retry delay.
        """
        return pulumi.get(self, "retry_delay_unit")

    @property
    @pulumi.getter(name="scheduleRef")
    def schedule_ref(self) -> pulumi.Output['outputs.WorkspaceApplicationTaskScheduleScheduleRef']:
        """
        (Updatable) The schedule object
        """
        return pulumi.get(self, "schedule_ref")

    @property
    @pulumi.getter(name="startTimeMillis")
    def start_time_millis(self) -> pulumi.Output[str]:
        """
        (Updatable) The start time in milliseconds.
        """
        return pulumi.get(self, "start_time_millis")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

