# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAlertPolicyRuleResult',
    'AwaitableGetAlertPolicyRuleResult',
    'get_alert_policy_rule',
    'get_alert_policy_rule_output',
]

@pulumi.output_type
class GetAlertPolicyRuleResult:
    """
    A collection of values returned by getAlertPolicyRule.
    """
    def __init__(__self__, alert_policy_id=None, id=None, items=None):
        if alert_policy_id and not isinstance(alert_policy_id, str):
            raise TypeError("Expected argument 'alert_policy_id' to be a str")
        pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> str:
        return pulumi.get(self, "alert_policy_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAlertPolicyRuleItemResult']:
        """
        Array of alert policy rules summary
        """
        return pulumi.get(self, "items")


class AwaitableGetAlertPolicyRuleResult(GetAlertPolicyRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertPolicyRuleResult(
            alert_policy_id=self.alert_policy_id,
            id=self.id,
            items=self.items)


def get_alert_policy_rule(alert_policy_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertPolicyRuleResult:
    """
    This data source provides details about a specific Alert Policy Rule resource in Oracle Cloud Infrastructure Data Safe service.

    Lists the rules of the specified alert policy. The alert policy is said to be satisfied when all rules in the policy evaulate to true.
    If there are three rules: rule1,rule2 and rule3, the policy is satisfied if rule1 AND rule2 AND rule3 is True.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_policy_rule = oci.DataSafe.get_alert_policy_rule(alert_policy_id=oci_data_safe_alert_policy["test_alert_policy"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str alert_policy_id: The OCID of the alert policy.
    """
    __args__ = dict()
    __args__['alertPolicyId'] = alert_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAlertPolicyRule:getAlertPolicyRule', __args__, opts=opts, typ=GetAlertPolicyRuleResult).value

    return AwaitableGetAlertPolicyRuleResult(
        alert_policy_id=pulumi.get(__ret__, 'alert_policy_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))


@_utilities.lift_output_func(get_alert_policy_rule)
def get_alert_policy_rule_output(alert_policy_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlertPolicyRuleResult]:
    """
    This data source provides details about a specific Alert Policy Rule resource in Oracle Cloud Infrastructure Data Safe service.

    Lists the rules of the specified alert policy. The alert policy is said to be satisfied when all rules in the policy evaulate to true.
    If there are three rules: rule1,rule2 and rule3, the policy is satisfied if rule1 AND rule2 AND rule3 is True.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_policy_rule = oci.DataSafe.get_alert_policy_rule(alert_policy_id=oci_data_safe_alert_policy["test_alert_policy"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str alert_policy_id: The OCID of the alert policy.
    """
    ...
