# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityPolicyReportDatabaseViewAccessEntriesResult',
    'AwaitableGetSecurityPolicyReportDatabaseViewAccessEntriesResult',
    'get_security_policy_report_database_view_access_entries',
    'get_security_policy_report_database_view_access_entries_output',
]

@pulumi.output_type
class GetSecurityPolicyReportDatabaseViewAccessEntriesResult:
    """
    A collection of values returned by getSecurityPolicyReportDatabaseViewAccessEntries.
    """
    def __init__(__self__, database_view_access_entry_collections=None, filters=None, id=None, scim_query=None, security_policy_report_id=None, target_id=None):
        if database_view_access_entry_collections and not isinstance(database_view_access_entry_collections, list):
            raise TypeError("Expected argument 'database_view_access_entry_collections' to be a list")
        pulumi.set(__self__, "database_view_access_entry_collections", database_view_access_entry_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scim_query and not isinstance(scim_query, str):
            raise TypeError("Expected argument 'scim_query' to be a str")
        pulumi.set(__self__, "scim_query", scim_query)
        if security_policy_report_id and not isinstance(security_policy_report_id, str):
            raise TypeError("Expected argument 'security_policy_report_id' to be a str")
        pulumi.set(__self__, "security_policy_report_id", security_policy_report_id)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="databaseViewAccessEntryCollections")
    def database_view_access_entry_collections(self) -> Sequence['outputs.GetSecurityPolicyReportDatabaseViewAccessEntriesDatabaseViewAccessEntryCollectionResult']:
        """
        The list of database_view_access_entry_collection.
        """
        return pulumi.get(self, "database_view_access_entry_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityPolicyReportDatabaseViewAccessEntriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="scimQuery")
    def scim_query(self) -> Optional[str]:
        return pulumi.get(self, "scim_query")

    @property
    @pulumi.getter(name="securityPolicyReportId")
    def security_policy_report_id(self) -> str:
        return pulumi.get(self, "security_policy_report_id")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        The OCID of the of the  target database.
        """
        return pulumi.get(self, "target_id")


class AwaitableGetSecurityPolicyReportDatabaseViewAccessEntriesResult(GetSecurityPolicyReportDatabaseViewAccessEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityPolicyReportDatabaseViewAccessEntriesResult(
            database_view_access_entry_collections=self.database_view_access_entry_collections,
            filters=self.filters,
            id=self.id,
            scim_query=self.scim_query,
            security_policy_report_id=self.security_policy_report_id,
            target_id=self.target_id)


def get_security_policy_report_database_view_access_entries(filters: Optional[Sequence[pulumi.InputType['GetSecurityPolicyReportDatabaseViewAccessEntriesFilterArgs']]] = None,
                                                            scim_query: Optional[str] = None,
                                                            security_policy_report_id: Optional[str] = None,
                                                            target_id: Optional[str] = None,
                                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityPolicyReportDatabaseViewAccessEntriesResult:
    """
    This data source provides the list of Security Policy Report Database View Access Entries in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all database view access entries in Data Safe.

    The ListDatabaseViewAccessEntries operation returns only the database view access objects for the specified security policy report.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy_report_database_view_access_entries = oci.DataSafe.get_security_policy_report_database_view_access_entries(security_policy_report_id=oci_data_safe_security_policy_report["test_security_policy_report"]["id"],
        scim_query=var["security_policy_report_database_view_access_entry_scim_query"],
        target_id=oci_cloud_guard_target["test_target"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str scim_query: The scimQuery query parameter accepts filter expressions that use the syntax described in Section 3.2.2.2 of the System for Cross-Domain Identity Management (SCIM) specification, which is available at [RFC3339](https://tools.ietf.org/html/draft-ietf-scim-api-12). In SCIM filtering expressions, text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format. (Numeric and boolean values should not be quoted.)
           
           **Example:** query=(accessType eq 'SELECT') and (grantee eq 'ADMIN')
    :param str security_policy_report_id: The OCID of the security policy report resource.
    :param str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['scimQuery'] = scim_query
    __args__['securityPolicyReportId'] = security_policy_report_id
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityPolicyReportDatabaseViewAccessEntries:getSecurityPolicyReportDatabaseViewAccessEntries', __args__, opts=opts, typ=GetSecurityPolicyReportDatabaseViewAccessEntriesResult).value

    return AwaitableGetSecurityPolicyReportDatabaseViewAccessEntriesResult(
        database_view_access_entry_collections=pulumi.get(__ret__, 'database_view_access_entry_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        scim_query=pulumi.get(__ret__, 'scim_query'),
        security_policy_report_id=pulumi.get(__ret__, 'security_policy_report_id'),
        target_id=pulumi.get(__ret__, 'target_id'))


@_utilities.lift_output_func(get_security_policy_report_database_view_access_entries)
def get_security_policy_report_database_view_access_entries_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSecurityPolicyReportDatabaseViewAccessEntriesFilterArgs']]]]] = None,
                                                                   scim_query: Optional[pulumi.Input[Optional[str]]] = None,
                                                                   security_policy_report_id: Optional[pulumi.Input[str]] = None,
                                                                   target_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecurityPolicyReportDatabaseViewAccessEntriesResult]:
    """
    This data source provides the list of Security Policy Report Database View Access Entries in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all database view access entries in Data Safe.

    The ListDatabaseViewAccessEntries operation returns only the database view access objects for the specified security policy report.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy_report_database_view_access_entries = oci.DataSafe.get_security_policy_report_database_view_access_entries(security_policy_report_id=oci_data_safe_security_policy_report["test_security_policy_report"]["id"],
        scim_query=var["security_policy_report_database_view_access_entry_scim_query"],
        target_id=oci_cloud_guard_target["test_target"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str scim_query: The scimQuery query parameter accepts filter expressions that use the syntax described in Section 3.2.2.2 of the System for Cross-Domain Identity Management (SCIM) specification, which is available at [RFC3339](https://tools.ietf.org/html/draft-ietf-scim-api-12). In SCIM filtering expressions, text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format. (Numeric and boolean values should not be quoted.)
           
           **Example:** query=(accessType eq 'SELECT') and (grantee eq 'ADMIN')
    :param str security_policy_report_id: The OCID of the security policy report resource.
    :param str target_id: A filter to return only items related to a specific target OCID.
    """
    ...
