# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFusionEnvironmentFamilyResult',
    'AwaitableGetFusionEnvironmentFamilyResult',
    'get_fusion_environment_family',
    'get_fusion_environment_family_output',
]

@pulumi.output_type
class GetFusionEnvironmentFamilyResult:
    """
    A collection of values returned by getFusionEnvironmentFamily.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, family_maintenance_policies=None, freeform_tags=None, fusion_environment_family_id=None, id=None, is_subscription_update_needed=None, lifecycle_details=None, state=None, subscription_ids=None, system_name=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if family_maintenance_policies and not isinstance(family_maintenance_policies, list):
            raise TypeError("Expected argument 'family_maintenance_policies' to be a list")
        pulumi.set(__self__, "family_maintenance_policies", family_maintenance_policies)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if fusion_environment_family_id and not isinstance(fusion_environment_family_id, str):
            raise TypeError("Expected argument 'fusion_environment_family_id' to be a str")
        pulumi.set(__self__, "fusion_environment_family_id", fusion_environment_family_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_subscription_update_needed and not isinstance(is_subscription_update_needed, bool):
            raise TypeError("Expected argument 'is_subscription_update_needed' to be a bool")
        pulumi.set(__self__, "is_subscription_update_needed", is_subscription_update_needed)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subscription_ids and not isinstance(subscription_ids, list):
            raise TypeError("Expected argument 'subscription_ids' to be a list")
        pulumi.set(__self__, "subscription_ids", subscription_ids)
        if system_name and not isinstance(system_name, str):
            raise TypeError("Expected argument 'system_name' to be a str")
        pulumi.set(__self__, "system_name", system_name)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment where the environment family is located.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A friendly name for the environment family. The name must contain only letters, numbers, dashes, and underscores. Can be changed later.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="familyMaintenancePolicies")
    def family_maintenance_policies(self) -> Sequence['outputs.GetFusionEnvironmentFamilyFamilyMaintenancePolicyResult']:
        """
        The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        """
        return pulumi.get(self, "family_maintenance_policies")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="fusionEnvironmentFamilyId")
    def fusion_environment_family_id(self) -> str:
        return pulumi.get(self, "fusion_environment_family_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier (OCID) of the environment family. Can't be changed after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSubscriptionUpdateNeeded")
    def is_subscription_update_needed(self) -> bool:
        """
        When set to True, a subscription update is required for the environment family.
        """
        return pulumi.get(self, "is_subscription_update_needed")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the FusionEnvironmentFamily.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionIds")
    def subscription_ids(self) -> Sequence[str]:
        """
        The list of the IDs of the applications subscriptions that are associated with the environment family.
        """
        return pulumi.get(self, "subscription_ids")

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> str:
        """
        Environment Specific Guid/ System Name
        """
        return pulumi.get(self, "system_name")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the FusionEnvironmentFamily was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        return pulumi.get(self, "time_updated")


class AwaitableGetFusionEnvironmentFamilyResult(GetFusionEnvironmentFamilyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFusionEnvironmentFamilyResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            family_maintenance_policies=self.family_maintenance_policies,
            freeform_tags=self.freeform_tags,
            fusion_environment_family_id=self.fusion_environment_family_id,
            id=self.id,
            is_subscription_update_needed=self.is_subscription_update_needed,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            subscription_ids=self.subscription_ids,
            system_name=self.system_name,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_fusion_environment_family(fusion_environment_family_id: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFusionEnvironmentFamilyResult:
    """
    This data source provides details about a specific Fusion Environment Family resource in Oracle Cloud Infrastructure Fusion Apps service.

    Retrieves a fusion environment family identified by its OCID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_family = oci.Functions.get_fusion_environment_family(fusion_environment_family_id=oci_fusion_apps_fusion_environment_family["test_fusion_environment_family"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str fusion_environment_family_id: The unique identifier (OCID) of the FusionEnvironmentFamily.
    """
    __args__ = dict()
    __args__['fusionEnvironmentFamilyId'] = fusion_environment_family_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getFusionEnvironmentFamily:getFusionEnvironmentFamily', __args__, opts=opts, typ=GetFusionEnvironmentFamilyResult).value

    return AwaitableGetFusionEnvironmentFamilyResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        family_maintenance_policies=pulumi.get(__ret__, 'family_maintenance_policies'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        fusion_environment_family_id=pulumi.get(__ret__, 'fusion_environment_family_id'),
        id=pulumi.get(__ret__, 'id'),
        is_subscription_update_needed=pulumi.get(__ret__, 'is_subscription_update_needed'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        subscription_ids=pulumi.get(__ret__, 'subscription_ids'),
        system_name=pulumi.get(__ret__, 'system_name'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_fusion_environment_family)
def get_fusion_environment_family_output(fusion_environment_family_id: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFusionEnvironmentFamilyResult]:
    """
    This data source provides details about a specific Fusion Environment Family resource in Oracle Cloud Infrastructure Fusion Apps service.

    Retrieves a fusion environment family identified by its OCID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_family = oci.Functions.get_fusion_environment_family(fusion_environment_family_id=oci_fusion_apps_fusion_environment_family["test_fusion_environment_family"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str fusion_environment_family_id: The unique identifier (OCID) of the FusionEnvironmentFamily.
    """
    ...
