# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFusionEnvironmentServiceAttachmentsResult',
    'AwaitableGetFusionEnvironmentServiceAttachmentsResult',
    'get_fusion_environment_service_attachments',
    'get_fusion_environment_service_attachments_output',
]

@pulumi.output_type
class GetFusionEnvironmentServiceAttachmentsResult:
    """
    A collection of values returned by getFusionEnvironmentServiceAttachments.
    """
    def __init__(__self__, display_name=None, filters=None, fusion_environment_id=None, id=None, service_attachment_collections=None, service_instance_type=None, state=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fusion_environment_id and not isinstance(fusion_environment_id, str):
            raise TypeError("Expected argument 'fusion_environment_id' to be a str")
        pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_attachment_collections and not isinstance(service_attachment_collections, list):
            raise TypeError("Expected argument 'service_attachment_collections' to be a list")
        pulumi.set(__self__, "service_attachment_collections", service_attachment_collections)
        if service_instance_type and not isinstance(service_instance_type, str):
            raise TypeError("Expected argument 'service_instance_type' to be a str")
        pulumi.set(__self__, "service_instance_type", service_instance_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Service Attachment Display name, can be renamed
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFusionEnvironmentServiceAttachmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> str:
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceAttachmentCollections")
    def service_attachment_collections(self) -> Sequence['outputs.GetFusionEnvironmentServiceAttachmentsServiceAttachmentCollectionResult']:
        """
        The list of service_attachment_collection.
        """
        return pulumi.get(self, "service_attachment_collections")

    @property
    @pulumi.getter(name="serviceInstanceType")
    def service_instance_type(self) -> Optional[str]:
        """
        Type of the serviceInstance.
        """
        return pulumi.get(self, "service_instance_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the ServiceInstance.
        """
        return pulumi.get(self, "state")


class AwaitableGetFusionEnvironmentServiceAttachmentsResult(GetFusionEnvironmentServiceAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFusionEnvironmentServiceAttachmentsResult(
            display_name=self.display_name,
            filters=self.filters,
            fusion_environment_id=self.fusion_environment_id,
            id=self.id,
            service_attachment_collections=self.service_attachment_collections,
            service_instance_type=self.service_instance_type,
            state=self.state)


def get_fusion_environment_service_attachments(display_name: Optional[str] = None,
                                               filters: Optional[Sequence[pulumi.InputType['GetFusionEnvironmentServiceAttachmentsFilterArgs']]] = None,
                                               fusion_environment_id: Optional[str] = None,
                                               service_instance_type: Optional[str] = None,
                                               state: Optional[str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFusionEnvironmentServiceAttachmentsResult:
    """
    This data source provides the list of Fusion Environment Service Attachments in Oracle Cloud Infrastructure Fusion Apps service.

    Returns a list of service attachments.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_service_attachments = oci.Functions.get_fusion_environment_service_attachments(fusion_environment_id=oci_fusion_apps_fusion_environment["test_fusion_environment"]["id"],
        display_name=var["fusion_environment_service_attachment_display_name"],
        service_instance_type=var["fusion_environment_service_attachment_service_instance_type"],
        state=var["fusion_environment_service_attachment_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fusion_environment_id: unique FusionEnvironment identifier
    :param str service_instance_type: A filter that returns all resources that match the specified lifecycle state.
    :param str state: A filter that returns all resources that match the specified lifecycle state.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fusionEnvironmentId'] = fusion_environment_id
    __args__['serviceInstanceType'] = service_instance_type
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getFusionEnvironmentServiceAttachments:getFusionEnvironmentServiceAttachments', __args__, opts=opts, typ=GetFusionEnvironmentServiceAttachmentsResult).value

    return AwaitableGetFusionEnvironmentServiceAttachmentsResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fusion_environment_id=pulumi.get(__ret__, 'fusion_environment_id'),
        id=pulumi.get(__ret__, 'id'),
        service_attachment_collections=pulumi.get(__ret__, 'service_attachment_collections'),
        service_instance_type=pulumi.get(__ret__, 'service_instance_type'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_fusion_environment_service_attachments)
def get_fusion_environment_service_attachments_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                      filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFusionEnvironmentServiceAttachmentsFilterArgs']]]]] = None,
                                                      fusion_environment_id: Optional[pulumi.Input[str]] = None,
                                                      service_instance_type: Optional[pulumi.Input[Optional[str]]] = None,
                                                      state: Optional[pulumi.Input[Optional[str]]] = None,
                                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFusionEnvironmentServiceAttachmentsResult]:
    """
    This data source provides the list of Fusion Environment Service Attachments in Oracle Cloud Infrastructure Fusion Apps service.

    Returns a list of service attachments.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_service_attachments = oci.Functions.get_fusion_environment_service_attachments(fusion_environment_id=oci_fusion_apps_fusion_environment["test_fusion_environment"]["id"],
        display_name=var["fusion_environment_service_attachment_display_name"],
        service_instance_type=var["fusion_environment_service_attachment_service_instance_type"],
        state=var["fusion_environment_service_attachment_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fusion_environment_id: unique FusionEnvironment identifier
    :param str service_instance_type: A filter that returns all resources that match the specified lifecycle state.
    :param str state: A filter that returns all resources that match the specified lifecycle state.
    """
    ...
