# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFusionEnvironmentTimeAvailableForRefreshsResult',
    'AwaitableGetFusionEnvironmentTimeAvailableForRefreshsResult',
    'get_fusion_environment_time_available_for_refreshs',
    'get_fusion_environment_time_available_for_refreshs_output',
]

@pulumi.output_type
class GetFusionEnvironmentTimeAvailableForRefreshsResult:
    """
    A collection of values returned by getFusionEnvironmentTimeAvailableForRefreshs.
    """
    def __init__(__self__, filters=None, fusion_environment_id=None, id=None, time_available_for_refresh_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fusion_environment_id and not isinstance(fusion_environment_id, str):
            raise TypeError("Expected argument 'fusion_environment_id' to be a str")
        pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if time_available_for_refresh_collections and not isinstance(time_available_for_refresh_collections, list):
            raise TypeError("Expected argument 'time_available_for_refresh_collections' to be a list")
        pulumi.set(__self__, "time_available_for_refresh_collections", time_available_for_refresh_collections)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFusionEnvironmentTimeAvailableForRefreshsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> str:
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="timeAvailableForRefreshCollections")
    def time_available_for_refresh_collections(self) -> Sequence['outputs.GetFusionEnvironmentTimeAvailableForRefreshsTimeAvailableForRefreshCollectionResult']:
        """
        The list of time_available_for_refresh_collection.
        """
        return pulumi.get(self, "time_available_for_refresh_collections")


class AwaitableGetFusionEnvironmentTimeAvailableForRefreshsResult(GetFusionEnvironmentTimeAvailableForRefreshsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFusionEnvironmentTimeAvailableForRefreshsResult(
            filters=self.filters,
            fusion_environment_id=self.fusion_environment_id,
            id=self.id,
            time_available_for_refresh_collections=self.time_available_for_refresh_collections)


def get_fusion_environment_time_available_for_refreshs(filters: Optional[Sequence[pulumi.InputType['GetFusionEnvironmentTimeAvailableForRefreshsFilterArgs']]] = None,
                                                       fusion_environment_id: Optional[str] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFusionEnvironmentTimeAvailableForRefreshsResult:
    """
    This data source provides the list of Fusion Environment Time Available For Refreshs in Oracle Cloud Infrastructure Fusion Apps service.

    Gets available refresh time for this fusion environment

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_time_available_for_refreshs = oci.Functions.get_fusion_environment_time_available_for_refreshs(fusion_environment_id=oci_fusion_apps_fusion_environment["test_fusion_environment"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str fusion_environment_id: unique FusionEnvironment identifier
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['fusionEnvironmentId'] = fusion_environment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getFusionEnvironmentTimeAvailableForRefreshs:getFusionEnvironmentTimeAvailableForRefreshs', __args__, opts=opts, typ=GetFusionEnvironmentTimeAvailableForRefreshsResult).value

    return AwaitableGetFusionEnvironmentTimeAvailableForRefreshsResult(
        filters=pulumi.get(__ret__, 'filters'),
        fusion_environment_id=pulumi.get(__ret__, 'fusion_environment_id'),
        id=pulumi.get(__ret__, 'id'),
        time_available_for_refresh_collections=pulumi.get(__ret__, 'time_available_for_refresh_collections'))


@_utilities.lift_output_func(get_fusion_environment_time_available_for_refreshs)
def get_fusion_environment_time_available_for_refreshs_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFusionEnvironmentTimeAvailableForRefreshsFilterArgs']]]]] = None,
                                                              fusion_environment_id: Optional[pulumi.Input[str]] = None,
                                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFusionEnvironmentTimeAvailableForRefreshsResult]:
    """
    This data source provides the list of Fusion Environment Time Available For Refreshs in Oracle Cloud Infrastructure Fusion Apps service.

    Gets available refresh time for this fusion environment

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_time_available_for_refreshs = oci.Functions.get_fusion_environment_time_available_for_refreshs(fusion_environment_id=oci_fusion_apps_fusion_environment["test_fusion_environment"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str fusion_environment_id: unique FusionEnvironment identifier
    """
    ...
