# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDedicatedAiClustersResult',
    'AwaitableGetDedicatedAiClustersResult',
    'get_dedicated_ai_clusters',
    'get_dedicated_ai_clusters_output',
]

@pulumi.output_type
class GetDedicatedAiClustersResult:
    """
    A collection of values returned by getDedicatedAiClusters.
    """
    def __init__(__self__, compartment_id=None, dedicated_ai_cluster_collections=None, display_name=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dedicated_ai_cluster_collections and not isinstance(dedicated_ai_cluster_collections, list):
            raise TypeError("Expected argument 'dedicated_ai_cluster_collections' to be a list")
        pulumi.set(__self__, "dedicated_ai_cluster_collections", dedicated_ai_cluster_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID to create the dedicated AI cluster in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dedicatedAiClusterCollections")
    def dedicated_ai_cluster_collections(self) -> Sequence['outputs.GetDedicatedAiClustersDedicatedAiClusterCollectionResult']:
        """
        The list of dedicated_ai_cluster_collection.
        """
        return pulumi.get(self, "dedicated_ai_cluster_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDedicatedAiClustersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated AI cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the dedicated AI cluster.
        """
        return pulumi.get(self, "state")


class AwaitableGetDedicatedAiClustersResult(GetDedicatedAiClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDedicatedAiClustersResult(
            compartment_id=self.compartment_id,
            dedicated_ai_cluster_collections=self.dedicated_ai_cluster_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_dedicated_ai_clusters(compartment_id: Optional[str] = None,
                              display_name: Optional[str] = None,
                              filters: Optional[Sequence[pulumi.InputType['GetDedicatedAiClustersFilterArgs']]] = None,
                              id: Optional[str] = None,
                              state: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDedicatedAiClustersResult:
    """
    This data source provides the list of Dedicated Ai Clusters in Oracle Cloud Infrastructure Generative Ai service.

    Lists the dedicated AI clusters in a specific compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_dedicated_ai_clusters = oci.GenerativeAi.get_dedicated_ai_clusters(compartment_id=var["compartment_id"],
        display_name=var["dedicated_ai_cluster_display_name"],
        id=var["dedicated_ai_cluster_id"],
        state=var["dedicated_ai_cluster_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated AI cluster.
    :param str state: A filter to return only the dedicated AI clusters that their lifecycle state matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GenerativeAi/getDedicatedAiClusters:getDedicatedAiClusters', __args__, opts=opts, typ=GetDedicatedAiClustersResult).value

    return AwaitableGetDedicatedAiClustersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dedicated_ai_cluster_collections=pulumi.get(__ret__, 'dedicated_ai_cluster_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_dedicated_ai_clusters)
def get_dedicated_ai_clusters_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                     display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDedicatedAiClustersFilterArgs']]]]] = None,
                                     id: Optional[pulumi.Input[Optional[str]]] = None,
                                     state: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDedicatedAiClustersResult]:
    """
    This data source provides the list of Dedicated Ai Clusters in Oracle Cloud Infrastructure Generative Ai service.

    Lists the dedicated AI clusters in a specific compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_dedicated_ai_clusters = oci.GenerativeAi.get_dedicated_ai_clusters(compartment_id=var["compartment_id"],
        display_name=var["dedicated_ai_cluster_display_name"],
        id=var["dedicated_ai_cluster_id"],
        state=var["dedicated_ai_cluster_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated AI cluster.
    :param str state: A filter to return only the dedicated AI clusters that their lifecycle state matches the given lifecycle state.
    """
    ...
