# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTrailFilesResult',
    'AwaitableGetTrailFilesResult',
    'get_trail_files',
    'get_trail_files_output',
]

@pulumi.output_type
class GetTrailFilesResult:
    """
    A collection of values returned by getTrailFiles.
    """
    def __init__(__self__, deployment_id=None, display_name=None, filters=None, id=None, trail_file_collections=None, trail_file_id=None):
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if trail_file_collections and not isinstance(trail_file_collections, list):
            raise TypeError("Expected argument 'trail_file_collections' to be a list")
        pulumi.set(__self__, "trail_file_collections", trail_file_collections)
        if trail_file_id and not isinstance(trail_file_id, str):
            raise TypeError("Expected argument 'trail_file_id' to be a str")
        pulumi.set(__self__, "trail_file_id", trail_file_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTrailFilesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="trailFileCollections")
    def trail_file_collections(self) -> Sequence['outputs.GetTrailFilesTrailFileCollectionResult']:
        """
        The list of trail_file_collection.
        """
        return pulumi.get(self, "trail_file_collections")

    @property
    @pulumi.getter(name="trailFileId")
    def trail_file_id(self) -> str:
        """
        The TrailFile Id.
        """
        return pulumi.get(self, "trail_file_id")


class AwaitableGetTrailFilesResult(GetTrailFilesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrailFilesResult(
            deployment_id=self.deployment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            trail_file_collections=self.trail_file_collections,
            trail_file_id=self.trail_file_id)


def get_trail_files(deployment_id: Optional[str] = None,
                    display_name: Optional[str] = None,
                    filters: Optional[Sequence[pulumi.InputType['GetTrailFilesFilterArgs']]] = None,
                    trail_file_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrailFilesResult:
    """
    This data source provides the list of Trail Files in Oracle Cloud Infrastructure Golden Gate service.

    Lists the TrailFiles for a deployment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_trail_files = oci.GoldenGate.get_trail_files(deployment_id=oci_golden_gate_deployment["test_deployment"]["id"],
        trail_file_id=oci_golden_gate_trail_file["test_trail_file"]["id"],
        display_name=var["trail_file_display_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str deployment_id: A unique Deployment identifier.
    :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param str trail_file_id: A Trail File identifier
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['trailFileId'] = trail_file_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getTrailFiles:getTrailFiles', __args__, opts=opts, typ=GetTrailFilesResult).value

    return AwaitableGetTrailFilesResult(
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        trail_file_collections=pulumi.get(__ret__, 'trail_file_collections'),
        trail_file_id=pulumi.get(__ret__, 'trail_file_id'))


@_utilities.lift_output_func(get_trail_files)
def get_trail_files_output(deployment_id: Optional[pulumi.Input[str]] = None,
                           display_name: Optional[pulumi.Input[Optional[str]]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetTrailFilesFilterArgs']]]]] = None,
                           trail_file_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTrailFilesResult]:
    """
    This data source provides the list of Trail Files in Oracle Cloud Infrastructure Golden Gate service.

    Lists the TrailFiles for a deployment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_trail_files = oci.GoldenGate.get_trail_files(deployment_id=oci_golden_gate_deployment["test_deployment"]["id"],
        trail_file_id=oci_golden_gate_trail_file["test_trail_file"]["id"],
        display_name=var["trail_file_display_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str deployment_id: A unique Deployment identifier.
    :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param str trail_file_id: A Trail File identifier
    """
    ...
