# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetLogAnalyticsLogGroupsSummaryResult',
    'AwaitableGetLogAnalyticsLogGroupsSummaryResult',
    'get_log_analytics_log_groups_summary',
    'get_log_analytics_log_groups_summary_output',
]

@pulumi.output_type
class GetLogAnalyticsLogGroupsSummaryResult:
    """
    A collection of values returned by getLogAnalyticsLogGroupsSummary.
    """
    def __init__(__self__, compartment_id=None, id=None, log_group_count=None, namespace=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_group_count and not isinstance(log_group_count, int):
            raise TypeError("Expected argument 'log_group_count' to be a int")
        pulumi.set(__self__, "log_group_count", log_group_count)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logGroupCount")
    def log_group_count(self) -> int:
        return pulumi.get(self, "log_group_count")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")


class AwaitableGetLogAnalyticsLogGroupsSummaryResult(GetLogAnalyticsLogGroupsSummaryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsLogGroupsSummaryResult(
            compartment_id=self.compartment_id,
            id=self.id,
            log_group_count=self.log_group_count,
            namespace=self.namespace)


def get_log_analytics_log_groups_summary(compartment_id: Optional[str] = None,
                                         namespace: Optional[str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsLogGroupsSummaryResult:
    """
    This data source provides details about a specific Log Analytics Log Groups Summary resource in Oracle Cloud Infrastructure Log Analytics service.

    Returns the count of log groups in a compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_log_groups_summary = oci.LogAnalytics.get_log_analytics_log_groups_summary(compartment_id=var["compartment_id"],
        namespace=var["log_analytics_log_groups_summary_namespace"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsLogGroupsSummary:getLogAnalyticsLogGroupsSummary', __args__, opts=opts, typ=GetLogAnalyticsLogGroupsSummaryResult).value

    return AwaitableGetLogAnalyticsLogGroupsSummaryResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        log_group_count=pulumi.get(__ret__, 'log_group_count'),
        namespace=pulumi.get(__ret__, 'namespace'))


@_utilities.lift_output_func(get_log_analytics_log_groups_summary)
def get_log_analytics_log_groups_summary_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                namespace: Optional[pulumi.Input[str]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLogAnalyticsLogGroupsSummaryResult]:
    """
    This data source provides details about a specific Log Analytics Log Groups Summary resource in Oracle Cloud Infrastructure Log Analytics service.

    Returns the count of log groups in a compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_log_groups_summary = oci.LogAnalytics.get_log_analytics_log_groups_summary(compartment_id=var["compartment_id"],
        namespace=var["log_analytics_log_groups_summary_namespace"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    ...
