# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetNamespaceResult',
    'AwaitableGetNamespaceResult',
    'get_namespace',
    'get_namespace_output',
]

@pulumi.output_type
class GetNamespaceResult:
    """
    A collection of values returned by getNamespace.
    """
    def __init__(__self__, compartment_id=None, id=None, is_onboarded=None, namespace=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_onboarded and not isinstance(is_onboarded, bool):
            raise TypeError("Expected argument 'is_onboarded' to be a bool")
        pulumi.set(__self__, "is_onboarded", is_onboarded)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The is the tenancy ID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isOnboarded")
    def is_onboarded(self) -> bool:
        """
        This indicates if the tenancy is onboarded to Logging Analytics
        """
        return pulumi.get(self, "is_onboarded")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        This is the namespace name of a tenancy
        """
        return pulumi.get(self, "namespace")


class AwaitableGetNamespaceResult(GetNamespaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceResult(
            compartment_id=self.compartment_id,
            id=self.id,
            is_onboarded=self.is_onboarded,
            namespace=self.namespace)


def get_namespace(namespace: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceResult:
    """
    This data source provides details about a specific Namespace resource in Oracle Cloud Infrastructure Log Analytics service.

    This API gets the namespace details of a tenancy already onboarded in Logging Analytics Application

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace = oci.LogAnalytics.get_namespace(namespace=var["namespace_namespace"])
    ```
    <!--End PulumiCodeChooser -->


    :param str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getNamespace:getNamespace', __args__, opts=opts, typ=GetNamespaceResult).value

    return AwaitableGetNamespaceResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_onboarded=pulumi.get(__ret__, 'is_onboarded'),
        namespace=pulumi.get(__ret__, 'namespace'))


@_utilities.lift_output_func(get_namespace)
def get_namespace_output(namespace: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNamespaceResult]:
    """
    This data source provides details about a specific Namespace resource in Oracle Cloud Infrastructure Log Analytics service.

    This API gets the namespace details of a tenancy already onboarded in Logging Analytics Application

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace = oci.LogAnalytics.get_namespace(namespace=var["namespace_namespace"])
    ```
    <!--End PulumiCodeChooser -->


    :param str namespace: The Logging Analytics namespace used for the request.
    """
    ...
