# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNamespacePropertiesMetadataResult',
    'AwaitableGetNamespacePropertiesMetadataResult',
    'get_namespace_properties_metadata',
    'get_namespace_properties_metadata_output',
]

@pulumi.output_type
class GetNamespacePropertiesMetadataResult:
    """
    A collection of values returned by getNamespacePropertiesMetadata.
    """
    def __init__(__self__, constraints=None, display_text=None, filters=None, id=None, level=None, name=None, namespace=None, property_metadata_summary_collections=None):
        if constraints and not isinstance(constraints, str):
            raise TypeError("Expected argument 'constraints' to be a str")
        pulumi.set(__self__, "constraints", constraints)
        if display_text and not isinstance(display_text, str):
            raise TypeError("Expected argument 'display_text' to be a str")
        pulumi.set(__self__, "display_text", display_text)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if level and not isinstance(level, str):
            raise TypeError("Expected argument 'level' to be a str")
        pulumi.set(__self__, "level", level)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if property_metadata_summary_collections and not isinstance(property_metadata_summary_collections, list):
            raise TypeError("Expected argument 'property_metadata_summary_collections' to be a list")
        pulumi.set(__self__, "property_metadata_summary_collections", property_metadata_summary_collections)

    @property
    @pulumi.getter
    def constraints(self) -> Optional[str]:
        """
        A string representation of constraints that apply at this level. For example, a property defined at SOURCE level could further be applicable only for SOURCE_TYPE:database_sql.
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter(name="displayText")
    def display_text(self) -> Optional[str]:
        return pulumi.get(self, "display_text")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNamespacePropertiesMetadataFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The property name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="propertyMetadataSummaryCollections")
    def property_metadata_summary_collections(self) -> Sequence['outputs.GetNamespacePropertiesMetadataPropertyMetadataSummaryCollectionResult']:
        """
        The list of property_metadata_summary_collection.
        """
        return pulumi.get(self, "property_metadata_summary_collections")


class AwaitableGetNamespacePropertiesMetadataResult(GetNamespacePropertiesMetadataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespacePropertiesMetadataResult(
            constraints=self.constraints,
            display_text=self.display_text,
            filters=self.filters,
            id=self.id,
            level=self.level,
            name=self.name,
            namespace=self.namespace,
            property_metadata_summary_collections=self.property_metadata_summary_collections)


def get_namespace_properties_metadata(constraints: Optional[str] = None,
                                      display_text: Optional[str] = None,
                                      filters: Optional[Sequence[pulumi.InputType['GetNamespacePropertiesMetadataFilterArgs']]] = None,
                                      level: Optional[str] = None,
                                      name: Optional[str] = None,
                                      namespace: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespacePropertiesMetadataResult:
    """
    This data source provides the list of Namespace Properties Metadata in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of properties along with their metadata.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_properties_metadata = oci.LogAnalytics.get_namespace_properties_metadata(namespace=var["namespace_properties_metadata_namespace"],
        constraints=var["namespace_properties_metadata_constraints"],
        display_text=var["namespace_properties_metadata_display_text"],
        level=var["namespace_properties_metadata_level"],
        name=var["namespace_properties_metadata_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str constraints: The constraints that apply to the properties at a certain level.
    :param str display_text: The property display text used for filtering. Only properties matching the specified display name or description will be returned.
    :param str level: The level for which applicable properties are to be listed.
    :param str name: The property name used for filtering.
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['constraints'] = constraints
    __args__['displayText'] = display_text
    __args__['filters'] = filters
    __args__['level'] = level
    __args__['name'] = name
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getNamespacePropertiesMetadata:getNamespacePropertiesMetadata', __args__, opts=opts, typ=GetNamespacePropertiesMetadataResult).value

    return AwaitableGetNamespacePropertiesMetadataResult(
        constraints=pulumi.get(__ret__, 'constraints'),
        display_text=pulumi.get(__ret__, 'display_text'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        level=pulumi.get(__ret__, 'level'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        property_metadata_summary_collections=pulumi.get(__ret__, 'property_metadata_summary_collections'))


@_utilities.lift_output_func(get_namespace_properties_metadata)
def get_namespace_properties_metadata_output(constraints: Optional[pulumi.Input[Optional[str]]] = None,
                                             display_text: Optional[pulumi.Input[Optional[str]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetNamespacePropertiesMetadataFilterArgs']]]]] = None,
                                             level: Optional[pulumi.Input[Optional[str]]] = None,
                                             name: Optional[pulumi.Input[Optional[str]]] = None,
                                             namespace: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNamespacePropertiesMetadataResult]:
    """
    This data source provides the list of Namespace Properties Metadata in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of properties along with their metadata.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_properties_metadata = oci.LogAnalytics.get_namespace_properties_metadata(namespace=var["namespace_properties_metadata_namespace"],
        constraints=var["namespace_properties_metadata_constraints"],
        display_text=var["namespace_properties_metadata_display_text"],
        level=var["namespace_properties_metadata_level"],
        name=var["namespace_properties_metadata_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str constraints: The constraints that apply to the properties at a certain level.
    :param str display_text: The property display text used for filtering. Only properties matching the specified display name or description will be returned.
    :param str level: The level for which applicable properties are to be listed.
    :param str name: The property name used for filtering.
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    ...
