# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetStreamPackagingConfigsResult',
    'AwaitableGetStreamPackagingConfigsResult',
    'get_stream_packaging_configs',
    'get_stream_packaging_configs_output',
]

@pulumi.output_type
class GetStreamPackagingConfigsResult:
    """
    A collection of values returned by getStreamPackagingConfigs.
    """
    def __init__(__self__, display_name=None, distribution_channel_id=None, filters=None, id=None, state=None, stream_packaging_config_collections=None, stream_packaging_config_id=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if distribution_channel_id and not isinstance(distribution_channel_id, str):
            raise TypeError("Expected argument 'distribution_channel_id' to be a str")
        pulumi.set(__self__, "distribution_channel_id", distribution_channel_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_packaging_config_collections and not isinstance(stream_packaging_config_collections, list):
            raise TypeError("Expected argument 'stream_packaging_config_collections' to be a list")
        pulumi.set(__self__, "stream_packaging_config_collections", stream_packaging_config_collections)
        if stream_packaging_config_id and not isinstance(stream_packaging_config_id, str):
            raise TypeError("Expected argument 'stream_packaging_config_id' to be a str")
        pulumi.set(__self__, "stream_packaging_config_id", stream_packaging_config_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the stream packaging configuration. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="distributionChannelId")
    def distribution_channel_id(self) -> str:
        """
        Unique identifier of the Distribution Channel that this stream packaging configuration belongs to.
        """
        return pulumi.get(self, "distribution_channel_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetStreamPackagingConfigsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Packaging Configuration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamPackagingConfigCollections")
    def stream_packaging_config_collections(self) -> Sequence['outputs.GetStreamPackagingConfigsStreamPackagingConfigCollectionResult']:
        """
        The list of stream_packaging_config_collection.
        """
        return pulumi.get(self, "stream_packaging_config_collections")

    @property
    @pulumi.getter(name="streamPackagingConfigId")
    def stream_packaging_config_id(self) -> Optional[str]:
        return pulumi.get(self, "stream_packaging_config_id")


class AwaitableGetStreamPackagingConfigsResult(GetStreamPackagingConfigsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamPackagingConfigsResult(
            display_name=self.display_name,
            distribution_channel_id=self.distribution_channel_id,
            filters=self.filters,
            id=self.id,
            state=self.state,
            stream_packaging_config_collections=self.stream_packaging_config_collections,
            stream_packaging_config_id=self.stream_packaging_config_id)


def get_stream_packaging_configs(display_name: Optional[str] = None,
                                 distribution_channel_id: Optional[str] = None,
                                 filters: Optional[Sequence[pulumi.InputType['GetStreamPackagingConfigsFilterArgs']]] = None,
                                 state: Optional[str] = None,
                                 stream_packaging_config_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamPackagingConfigsResult:
    """
    This data source provides the list of Stream Packaging Configs in Oracle Cloud Infrastructure Media Services service.

    Lists the Stream Packaging Configurations.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_packaging_configs = oci.MediaServices.get_stream_packaging_configs(distribution_channel_id=oci_mysql_channel["test_channel"]["id"],
        display_name=var["stream_packaging_config_display_name"],
        state=var["stream_packaging_config_state"],
        stream_packaging_config_id=oci_media_services_stream_packaging_config["test_stream_packaging_config"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str display_name: A filter to return only the resources that match the entire display name given.
    :param str distribution_channel_id: Unique Stream Distribution Channel identifier.
    :param str state: A filter to return only the resources with lifecycleState matching the given lifecycleState.
    :param str stream_packaging_config_id: Unique Stream Packaging Configuration identifier.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['distributionChannelId'] = distribution_channel_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['streamPackagingConfigId'] = stream_packaging_config_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MediaServices/getStreamPackagingConfigs:getStreamPackagingConfigs', __args__, opts=opts, typ=GetStreamPackagingConfigsResult).value

    return AwaitableGetStreamPackagingConfigsResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        distribution_channel_id=pulumi.get(__ret__, 'distribution_channel_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        stream_packaging_config_collections=pulumi.get(__ret__, 'stream_packaging_config_collections'),
        stream_packaging_config_id=pulumi.get(__ret__, 'stream_packaging_config_id'))


@_utilities.lift_output_func(get_stream_packaging_configs)
def get_stream_packaging_configs_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                        distribution_channel_id: Optional[pulumi.Input[str]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetStreamPackagingConfigsFilterArgs']]]]] = None,
                                        state: Optional[pulumi.Input[Optional[str]]] = None,
                                        stream_packaging_config_id: Optional[pulumi.Input[Optional[str]]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStreamPackagingConfigsResult]:
    """
    This data source provides the list of Stream Packaging Configs in Oracle Cloud Infrastructure Media Services service.

    Lists the Stream Packaging Configurations.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_packaging_configs = oci.MediaServices.get_stream_packaging_configs(distribution_channel_id=oci_mysql_channel["test_channel"]["id"],
        display_name=var["stream_packaging_config_display_name"],
        state=var["stream_packaging_config_state"],
        stream_packaging_config_id=oci_media_services_stream_packaging_config["test_stream_packaging_config"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str display_name: A filter to return only the resources that match the entire display name given.
    :param str distribution_channel_id: Unique Stream Distribution Channel identifier.
    :param str state: A filter to return only the resources with lifecycleState matching the given lifecycleState.
    :param str stream_packaging_config_id: Unique Stream Packaging Configuration identifier.
    """
    ...
