# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetScheduledRunsResult',
    'AwaitableGetScheduledRunsResult',
    'get_scheduled_runs',
    'get_scheduled_runs_output',
]

@pulumi.output_type
class GetScheduledRunsResult:
    """
    A collection of values returned by getScheduledRuns.
    """
    def __init__(__self__, filters=None, id=None, schedule_id=None, scheduled_run_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if schedule_id and not isinstance(schedule_id, str):
            raise TypeError("Expected argument 'schedule_id' to be a str")
        pulumi.set(__self__, "schedule_id", schedule_id)
        if scheduled_run_collections and not isinstance(scheduled_run_collections, list):
            raise TypeError("Expected argument 'scheduled_run_collections' to be a list")
        pulumi.set(__self__, "scheduled_run_collections", scheduled_run_collections)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetScheduledRunsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> str:
        """
        The ocid representing unique shedule
        """
        return pulumi.get(self, "schedule_id")

    @property
    @pulumi.getter(name="scheduledRunCollections")
    def scheduled_run_collections(self) -> Sequence['outputs.GetScheduledRunsScheduledRunCollectionResult']:
        """
        The list of scheduled_run_collection.
        """
        return pulumi.get(self, "scheduled_run_collections")


class AwaitableGetScheduledRunsResult(GetScheduledRunsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledRunsResult(
            filters=self.filters,
            id=self.id,
            schedule_id=self.schedule_id,
            scheduled_run_collections=self.scheduled_run_collections)


def get_scheduled_runs(filters: Optional[Sequence[pulumi.InputType['GetScheduledRunsFilterArgs']]] = None,
                       schedule_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledRunsResult:
    """
    This data source provides the list of Scheduled Runs in Oracle Cloud Infrastructure Metering Computation service.

    Returns schedule history list.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_runs = oci.MeteringComputation.get_scheduled_runs(schedule_id=oci_metering_computation_schedule["test_schedule"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str schedule_id: The unique ID of a schedule.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['scheduleId'] = schedule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getScheduledRuns:getScheduledRuns', __args__, opts=opts, typ=GetScheduledRunsResult).value

    return AwaitableGetScheduledRunsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        schedule_id=pulumi.get(__ret__, 'schedule_id'),
        scheduled_run_collections=pulumi.get(__ret__, 'scheduled_run_collections'))


@_utilities.lift_output_func(get_scheduled_runs)
def get_scheduled_runs_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetScheduledRunsFilterArgs']]]]] = None,
                              schedule_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetScheduledRunsResult]:
    """
    This data source provides the list of Scheduled Runs in Oracle Cloud Infrastructure Metering Computation service.

    Returns schedule history list.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_runs = oci.MeteringComputation.get_scheduled_runs(schedule_id=oci_metering_computation_schedule["test_schedule"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str schedule_id: The unique ID of a schedule.
    """
    ...
