# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetUsageStatementEmailRecipientsGroupResult',
    'AwaitableGetUsageStatementEmailRecipientsGroupResult',
    'get_usage_statement_email_recipients_group',
    'get_usage_statement_email_recipients_group_output',
]

@pulumi.output_type
class GetUsageStatementEmailRecipientsGroupResult:
    """
    A collection of values returned by getUsageStatementEmailRecipientsGroup.
    """
    def __init__(__self__, compartment_id=None, email_recipients_group_id=None, id=None, recipients_lists=None, state=None, subscription_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if email_recipients_group_id and not isinstance(email_recipients_group_id, str):
            raise TypeError("Expected argument 'email_recipients_group_id' to be a str")
        pulumi.set(__self__, "email_recipients_group_id", email_recipients_group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if recipients_lists and not isinstance(recipients_lists, list):
            raise TypeError("Expected argument 'recipients_lists' to be a list")
        pulumi.set(__self__, "recipients_lists", recipients_lists)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The customer tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="emailRecipientsGroupId")
    def email_recipients_group_id(self) -> str:
        return pulumi.get(self, "email_recipients_group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The usage statement email recipients group OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="recipientsLists")
    def recipients_lists(self) -> Sequence['outputs.GetUsageStatementEmailRecipientsGroupRecipientsListResult']:
        """
        The list of recipient will receive the usage statement email.
        """
        return pulumi.get(self, "recipients_lists")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The email recipient group lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        return pulumi.get(self, "subscription_id")


class AwaitableGetUsageStatementEmailRecipientsGroupResult(GetUsageStatementEmailRecipientsGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsageStatementEmailRecipientsGroupResult(
            compartment_id=self.compartment_id,
            email_recipients_group_id=self.email_recipients_group_id,
            id=self.id,
            recipients_lists=self.recipients_lists,
            state=self.state,
            subscription_id=self.subscription_id)


def get_usage_statement_email_recipients_group(compartment_id: Optional[str] = None,
                                               email_recipients_group_id: Optional[str] = None,
                                               subscription_id: Optional[str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsageStatementEmailRecipientsGroupResult:
    """
    This data source provides details about a specific Usage Statement Email Recipients Group resource in Oracle Cloud Infrastructure Metering Computation service.

    Return the saved usage statement email recipient group.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_statement_email_recipients_group = oci.MeteringComputation.get_usage_statement_email_recipients_group(compartment_id=var["compartment_id"],
        email_recipients_group_id=oci_identity_group["test_group"]["id"],
        subscription_id=oci_onesubscription_subscription["test_subscription"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The compartment ID in which to list resources.
    :param str email_recipients_group_id: The email recipient group OCID.
    :param str subscription_id: The UsageStatement Subscription unique OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['emailRecipientsGroupId'] = email_recipients_group_id
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getUsageStatementEmailRecipientsGroup:getUsageStatementEmailRecipientsGroup', __args__, opts=opts, typ=GetUsageStatementEmailRecipientsGroupResult).value

    return AwaitableGetUsageStatementEmailRecipientsGroupResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        email_recipients_group_id=pulumi.get(__ret__, 'email_recipients_group_id'),
        id=pulumi.get(__ret__, 'id'),
        recipients_lists=pulumi.get(__ret__, 'recipients_lists'),
        state=pulumi.get(__ret__, 'state'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'))


@_utilities.lift_output_func(get_usage_statement_email_recipients_group)
def get_usage_statement_email_recipients_group_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                      email_recipients_group_id: Optional[pulumi.Input[str]] = None,
                                                      subscription_id: Optional[pulumi.Input[str]] = None,
                                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUsageStatementEmailRecipientsGroupResult]:
    """
    This data source provides details about a specific Usage Statement Email Recipients Group resource in Oracle Cloud Infrastructure Metering Computation service.

    Return the saved usage statement email recipient group.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_statement_email_recipients_group = oci.MeteringComputation.get_usage_statement_email_recipients_group(compartment_id=var["compartment_id"],
        email_recipients_group_id=oci_identity_group["test_group"]["id"],
        subscription_id=oci_onesubscription_subscription["test_subscription"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The compartment ID in which to list resources.
    :param str email_recipients_group_id: The email recipient group OCID.
    :param str subscription_id: The UsageStatement Subscription unique OCID.
    """
    ...
