# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NetworkFirewallPolicyApplicationGroupArgs', 'NetworkFirewallPolicyApplicationGroup']

@pulumi.input_type
class NetworkFirewallPolicyApplicationGroupArgs:
    def __init__(__self__, *,
                 apps: pulumi.Input[Sequence[pulumi.Input[str]]],
                 network_firewall_policy_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NetworkFirewallPolicyApplicationGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apps: (Updatable) Collection of application names. The apps referenced in the application group must already be present in the policy before being used in the application group.
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] name: Name of the application group.
        """
        pulumi.set(__self__, "apps", apps)
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def apps(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) Collection of application names. The apps referenced in the application group must already be present in the policy before being used in the application group.
        """
        return pulumi.get(self, "apps")

    @apps.setter
    def apps(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "apps", value)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Input[str]:
        """
        Unique Network Firewall Policy identifier


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkFirewallPolicyApplicationGroupState:
    def __init__(__self__, *,
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 parent_resource_id: Optional[pulumi.Input[str]] = None,
                 total_apps: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering NetworkFirewallPolicyApplicationGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apps: (Updatable) Collection of application names. The apps referenced in the application group must already be present in the policy before being used in the application group.
        :param pulumi.Input[str] name: Name of the application group.
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] parent_resource_id: OCID of the Network Firewall Policy this application group belongs to.
        :param pulumi.Input[int] total_apps: Count of total applications in the given application group.
        """
        if apps is not None:
            pulumi.set(__self__, "apps", apps)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_id is not None:
            pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id is not None:
            pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if total_apps is not None:
            pulumi.set(__self__, "total_apps", total_apps)

    @property
    @pulumi.getter
    def apps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Collection of application names. The apps referenced in the application group must already be present in the policy before being used in the application group.
        """
        return pulumi.get(self, "apps")

    @apps.setter
    def apps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "apps", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique Network Firewall Policy identifier


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the Network Firewall Policy this application group belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @parent_resource_id.setter
    def parent_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_resource_id", value)

    @property
    @pulumi.getter(name="totalApps")
    def total_apps(self) -> Optional[pulumi.Input[int]]:
        """
        Count of total applications in the given application group.
        """
        return pulumi.get(self, "total_apps")

    @total_apps.setter
    def total_apps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_apps", value)


class NetworkFirewallPolicyApplicationGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Network Firewall Policy Application Group resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new ApplicationGroup inside the Network Firewall Policy.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_application_group = oci.network_firewall.NetworkFirewallPolicyApplicationGroup("testNetworkFirewallPolicyApplicationGroup",
            apps=var["network_firewall_policy_application_group_apps"],
            network_firewall_policy_id=oci_network_firewall_network_firewall_policy["test_network_firewall_policy"]["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        NetworkFirewallPolicyApplicationGroups can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyApplicationGroup:NetworkFirewallPolicyApplicationGroup test_network_firewall_policy_application_group "networkFirewallPolicies/{networkFirewallPolicyId}/applicationGroups/{applicationGroupName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apps: (Updatable) Collection of application names. The apps referenced in the application group must already be present in the policy before being used in the application group.
        :param pulumi.Input[str] name: Name of the application group.
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkFirewallPolicyApplicationGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Network Firewall Policy Application Group resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new ApplicationGroup inside the Network Firewall Policy.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_application_group = oci.network_firewall.NetworkFirewallPolicyApplicationGroup("testNetworkFirewallPolicyApplicationGroup",
            apps=var["network_firewall_policy_application_group_apps"],
            network_firewall_policy_id=oci_network_firewall_network_firewall_policy["test_network_firewall_policy"]["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        NetworkFirewallPolicyApplicationGroups can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyApplicationGroup:NetworkFirewallPolicyApplicationGroup test_network_firewall_policy_application_group "networkFirewallPolicies/{networkFirewallPolicyId}/applicationGroups/{applicationGroupName}"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkFirewallPolicyApplicationGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkFirewallPolicyApplicationGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkFirewallPolicyApplicationGroupArgs.__new__(NetworkFirewallPolicyApplicationGroupArgs)

            if apps is None and not opts.urn:
                raise TypeError("Missing required property 'apps'")
            __props__.__dict__["apps"] = apps
            __props__.__dict__["name"] = name
            if network_firewall_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_firewall_policy_id'")
            __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
            __props__.__dict__["parent_resource_id"] = None
            __props__.__dict__["total_apps"] = None
        super(NetworkFirewallPolicyApplicationGroup, __self__).__init__(
            'oci:NetworkFirewall/networkFirewallPolicyApplicationGroup:NetworkFirewallPolicyApplicationGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
            parent_resource_id: Optional[pulumi.Input[str]] = None,
            total_apps: Optional[pulumi.Input[int]] = None) -> 'NetworkFirewallPolicyApplicationGroup':
        """
        Get an existing NetworkFirewallPolicyApplicationGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] apps: (Updatable) Collection of application names. The apps referenced in the application group must already be present in the policy before being used in the application group.
        :param pulumi.Input[str] name: Name of the application group.
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] parent_resource_id: OCID of the Network Firewall Policy this application group belongs to.
        :param pulumi.Input[int] total_apps: Count of total applications in the given application group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkFirewallPolicyApplicationGroupState.__new__(_NetworkFirewallPolicyApplicationGroupState)

        __props__.__dict__["apps"] = apps
        __props__.__dict__["name"] = name
        __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
        __props__.__dict__["parent_resource_id"] = parent_resource_id
        __props__.__dict__["total_apps"] = total_apps
        return NetworkFirewallPolicyApplicationGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def apps(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Collection of application names. The apps referenced in the application group must already be present in the policy before being used in the application group.
        """
        return pulumi.get(self, "apps")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the application group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Output[str]:
        """
        Unique Network Firewall Policy identifier


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> pulumi.Output[str]:
        """
        OCID of the Network Firewall Policy this application group belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter(name="totalApps")
    def total_apps(self) -> pulumi.Output[int]:
        """
        Count of total applications in the given application group.
        """
        return pulumi.get(self, "total_apps")

