# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNetworkLoadBalancersResult',
    'AwaitableGetNetworkLoadBalancersResult',
    'get_network_load_balancers',
    'get_network_load_balancers_output',
]

@pulumi.output_type
class GetNetworkLoadBalancersResult:
    """
    A collection of values returned by getNetworkLoadBalancers.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, network_load_balancer_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_load_balancer_collections and not isinstance(network_load_balancer_collections, list):
            raise TypeError("Expected argument 'network_load_balancer_collections' to be a list")
        pulumi.set(__self__, "network_load_balancer_collections", network_load_balancer_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancer.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name, which does not have to be unique, and can be changed.  Example: `example_load_balancer`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNetworkLoadBalancersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkLoadBalancerCollections")
    def network_load_balancer_collections(self) -> Sequence['outputs.GetNetworkLoadBalancersNetworkLoadBalancerCollectionResult']:
        """
        The list of network_load_balancer_collection.
        """
        return pulumi.get(self, "network_load_balancer_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the network load balancer.
        """
        return pulumi.get(self, "state")


class AwaitableGetNetworkLoadBalancersResult(GetNetworkLoadBalancersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkLoadBalancersResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            network_load_balancer_collections=self.network_load_balancer_collections,
            state=self.state)


def get_network_load_balancers(compartment_id: Optional[str] = None,
                               display_name: Optional[str] = None,
                               filters: Optional[Sequence[pulumi.InputType['GetNetworkLoadBalancersFilterArgs']]] = None,
                               state: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkLoadBalancersResult:
    """
    This data source provides the list of Network Load Balancers in Oracle Cloud Infrastructure Network Load Balancer service.

    Returns a list of network load balancers.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_load_balancers = oci.NetworkLoadBalancer.get_network_load_balancers(compartment_id=var["compartment_id"],
        display_name=var["network_load_balancer_display_name"],
        state=var["network_load_balancer_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancers to list.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: A filter to return only resources that match the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkLoadBalancer/getNetworkLoadBalancers:getNetworkLoadBalancers', __args__, opts=opts, typ=GetNetworkLoadBalancersResult).value

    return AwaitableGetNetworkLoadBalancersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        network_load_balancer_collections=pulumi.get(__ret__, 'network_load_balancer_collections'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_network_load_balancers)
def get_network_load_balancers_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                      display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetNetworkLoadBalancersFilterArgs']]]]] = None,
                                      state: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkLoadBalancersResult]:
    """
    This data source provides the list of Network Load Balancers in Oracle Cloud Infrastructure Network Load Balancer service.

    Returns a list of network load balancers.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_load_balancers = oci.NetworkLoadBalancer.get_network_load_balancers(compartment_id=var["compartment_id"],
        display_name=var["network_load_balancer_display_name"],
        state=var["network_load_balancer_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancers to list.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: A filter to return only resources that match the given lifecycle state.
    """
    ...
