# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccessRequestHistoryResult',
    'AwaitableGetAccessRequestHistoryResult',
    'get_access_request_history',
    'get_access_request_history_output',
]

@pulumi.output_type
class GetAccessRequestHistoryResult:
    """
    A collection of values returned by getAccessRequestHistory.
    """
    def __init__(__self__, access_request_id=None, id=None, items=None):
        if access_request_id and not isinstance(access_request_id, str):
            raise TypeError("Expected argument 'access_request_id' to be a str")
        pulumi.set(__self__, "access_request_id", access_request_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="accessRequestId")
    def access_request_id(self) -> str:
        return pulumi.get(self, "access_request_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAccessRequestHistoryItemResult']:
        """
        contains AccessRequestHistorySummary
        """
        return pulumi.get(self, "items")


class AwaitableGetAccessRequestHistoryResult(GetAccessRequestHistoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessRequestHistoryResult(
            access_request_id=self.access_request_id,
            id=self.id,
            items=self.items)


def get_access_request_history(access_request_id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessRequestHistoryResult:
    """
    This data source provides details about a specific Access Request History resource in Oracle Cloud Infrastructure Operator Access Control service.

    Returns a history of all status associated with the accessRequestId.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_access_request_history = oci.OperatorAccessControl.get_access_request_history(access_request_id=oci_operator_access_control_access_request["test_access_request"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str access_request_id: unique AccessRequest identifier
    """
    __args__ = dict()
    __args__['accessRequestId'] = access_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OperatorAccessControl/getAccessRequestHistory:getAccessRequestHistory', __args__, opts=opts, typ=GetAccessRequestHistoryResult).value

    return AwaitableGetAccessRequestHistoryResult(
        access_request_id=pulumi.get(__ret__, 'access_request_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))


@_utilities.lift_output_func(get_access_request_history)
def get_access_request_history_output(access_request_id: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessRequestHistoryResult]:
    """
    This data source provides details about a specific Access Request History resource in Oracle Cloud Infrastructure Operator Access Control service.

    Returns a history of all status associated with the accessRequestId.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_access_request_history = oci.OperatorAccessControl.get_access_request_history(access_request_id=oci_operator_access_control_access_request["test_access_request"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str access_request_id: unique AccessRequest identifier
    """
    ...
