# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedInstanceModuleStreamsResult',
    'AwaitableGetManagedInstanceModuleStreamsResult',
    'get_managed_instance_module_streams',
    'get_managed_instance_module_streams_output',
]

@pulumi.output_type
class GetManagedInstanceModuleStreamsResult:
    """
    A collection of values returned by getManagedInstanceModuleStreams.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, managed_instance_id=None, module_name=None, module_stream_on_managed_instances=None, stream_name=None, stream_status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if module_name and not isinstance(module_name, str):
            raise TypeError("Expected argument 'module_name' to be a str")
        pulumi.set(__self__, "module_name", module_name)
        if module_stream_on_managed_instances and not isinstance(module_stream_on_managed_instances, list):
            raise TypeError("Expected argument 'module_stream_on_managed_instances' to be a list")
        pulumi.set(__self__, "module_stream_on_managed_instances", module_stream_on_managed_instances)
        if stream_name and not isinstance(stream_name, str):
            raise TypeError("Expected argument 'stream_name' to be a str")
        pulumi.set(__self__, "stream_name", stream_name)
        if stream_status and not isinstance(stream_status, str):
            raise TypeError("Expected argument 'stream_status' to be a str")
        pulumi.set(__self__, "stream_status", stream_status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedInstanceModuleStreamsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> str:
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> Optional[str]:
        """
        The name of the module that contains the stream profile
        """
        return pulumi.get(self, "module_name")

    @property
    @pulumi.getter(name="moduleStreamOnManagedInstances")
    def module_stream_on_managed_instances(self) -> Sequence['outputs.GetManagedInstanceModuleStreamsModuleStreamOnManagedInstanceResult']:
        """
        The list of module_stream_on_managed_instances.
        """
        return pulumi.get(self, "module_stream_on_managed_instances")

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[str]:
        """
        The name of the stream.
        """
        return pulumi.get(self, "stream_name")

    @property
    @pulumi.getter(name="streamStatus")
    def stream_status(self) -> Optional[str]:
        return pulumi.get(self, "stream_status")


class AwaitableGetManagedInstanceModuleStreamsResult(GetManagedInstanceModuleStreamsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstanceModuleStreamsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            module_name=self.module_name,
            module_stream_on_managed_instances=self.module_stream_on_managed_instances,
            stream_name=self.stream_name,
            stream_status=self.stream_status)


def get_managed_instance_module_streams(compartment_id: Optional[str] = None,
                                        filters: Optional[Sequence[pulumi.InputType['GetManagedInstanceModuleStreamsFilterArgs']]] = None,
                                        managed_instance_id: Optional[str] = None,
                                        module_name: Optional[str] = None,
                                        stream_name: Optional[str] = None,
                                        stream_status: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstanceModuleStreamsResult:
    """
    This data source provides the list of Managed Instance Module Streams in Oracle Cloud Infrastructure OS Management service.

    Retrieve a list of module streams, along with a summary of their
    status, from a managed instance.  Filters may be applied to select
    a subset of module streams based on the filter criteria.

    The 'moduleName' attribute filters against the name of a module.
    It accepts strings of the format "<module>".  If this attribute
    is defined, only streams that belong to the specified module are
    included in the result set.  If it is not defined, the request is
    not subject to this filter.

    The "status" attribute filters against the state of a module stream.
    Valid values are "ENABLED", "DISABLED", and "ACTIVE".  If the
    attribute is set to "ENABLED", only module streams that are enabled
    are included in the result set.  If the attribute is set to "DISABLED",
    only module streams that are not enabled are included in the result
    set.  If the attribute is set to "ACTIVE", only module streams that
    are active are included in the result set.  If the attribute is not
    defined, the request is not subject to this filter.

    When sorting by the display name, the result set is sorted first
    by the module name and then by the stream name.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_module_streams = oci.OsManagement.get_managed_instance_module_streams(managed_instance_id=var["managed_instance_id"],
        compartment_id=var["compartment_id"],
        module_name=var["managed_instance_module_name"],
        stream_name=var["managed_instance_module_stream_name"],
        stream_status=var["managed_instance_module_stream_status"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources. This parameter is optional and in some cases may have no effect.
    :param str managed_instance_id: OCID for the managed instance
    :param str module_name: The name of a module.  This parameter is required if a streamName is specified.
    :param str stream_name: The name of the stream of the containing module.  This parameter is required if a profileName is specified.
    :param str stream_status: The status of the stream
           
           A stream with the "ENABLED" status can be used as a source for installing profiles.  Streams with this status are also "ACTIVE".
           
           A stream with the "DISABLED" status cannot be the source for installing profiles.  To install profiles and packages from this stream, it must be enabled.
           
           A stream with the "ACTIVE" status can be used as a source for installing profiles.  The packages that comprise the stream are also used when a matching package is installed directly.  In general, a stream can have this status if it is the default stream for the module and no stream has been explicitly enabled.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['managedInstanceId'] = managed_instance_id
    __args__['moduleName'] = module_name
    __args__['streamName'] = stream_name
    __args__['streamStatus'] = stream_status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagement/getManagedInstanceModuleStreams:getManagedInstanceModuleStreams', __args__, opts=opts, typ=GetManagedInstanceModuleStreamsResult).value

    return AwaitableGetManagedInstanceModuleStreamsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        module_name=pulumi.get(__ret__, 'module_name'),
        module_stream_on_managed_instances=pulumi.get(__ret__, 'module_stream_on_managed_instances'),
        stream_name=pulumi.get(__ret__, 'stream_name'),
        stream_status=pulumi.get(__ret__, 'stream_status'))


@_utilities.lift_output_func(get_managed_instance_module_streams)
def get_managed_instance_module_streams_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                               filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedInstanceModuleStreamsFilterArgs']]]]] = None,
                                               managed_instance_id: Optional[pulumi.Input[str]] = None,
                                               module_name: Optional[pulumi.Input[Optional[str]]] = None,
                                               stream_name: Optional[pulumi.Input[Optional[str]]] = None,
                                               stream_status: Optional[pulumi.Input[Optional[str]]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedInstanceModuleStreamsResult]:
    """
    This data source provides the list of Managed Instance Module Streams in Oracle Cloud Infrastructure OS Management service.

    Retrieve a list of module streams, along with a summary of their
    status, from a managed instance.  Filters may be applied to select
    a subset of module streams based on the filter criteria.

    The 'moduleName' attribute filters against the name of a module.
    It accepts strings of the format "<module>".  If this attribute
    is defined, only streams that belong to the specified module are
    included in the result set.  If it is not defined, the request is
    not subject to this filter.

    The "status" attribute filters against the state of a module stream.
    Valid values are "ENABLED", "DISABLED", and "ACTIVE".  If the
    attribute is set to "ENABLED", only module streams that are enabled
    are included in the result set.  If the attribute is set to "DISABLED",
    only module streams that are not enabled are included in the result
    set.  If the attribute is set to "ACTIVE", only module streams that
    are active are included in the result set.  If the attribute is not
    defined, the request is not subject to this filter.

    When sorting by the display name, the result set is sorted first
    by the module name and then by the stream name.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_module_streams = oci.OsManagement.get_managed_instance_module_streams(managed_instance_id=var["managed_instance_id"],
        compartment_id=var["compartment_id"],
        module_name=var["managed_instance_module_name"],
        stream_name=var["managed_instance_module_stream_name"],
        stream_status=var["managed_instance_module_stream_status"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources. This parameter is optional and in some cases may have no effect.
    :param str managed_instance_id: OCID for the managed instance
    :param str module_name: The name of a module.  This parameter is required if a streamName is specified.
    :param str stream_name: The name of the stream of the containing module.  This parameter is required if a profileName is specified.
    :param str stream_status: The status of the stream
           
           A stream with the "ENABLED" status can be used as a source for installing profiles.  Streams with this status are also "ACTIVE".
           
           A stream with the "DISABLED" status cannot be the source for installing profiles.  To install profiles and packages from this stream, it must be enabled.
           
           A stream with the "ACTIVE" status can be used as a source for installing profiles.  The packages that comprise the stream are also used when a matching package is installed directly.  In general, a stream can have this status if it is the default stream for the module and no stream has been explicitly enabled.
    """
    ...
