# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SoftwareSourceArgs', 'SoftwareSource']

@pulumi.input_type
class SoftwareSourceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 software_source_type: pulumi.Input[str],
                 vendor_software_sources: pulumi.Input[Sequence[pulumi.Input['SoftwareSourceVendorSoftwareSourceArgs']]],
                 custom_software_source_filter: Optional[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_automatically_updated: Optional[pulumi.Input[bool]] = None,
                 software_source_version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SoftwareSource resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the tenancy containing the software source.
        :param pulumi.Input[str] display_name: (Updatable) User friendly name.
        :param pulumi.Input[str] software_source_type: (Updatable) Type of the software source.
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareSourceVendorSoftwareSourceArgs']]] vendor_software_sources: (Updatable) List of vendor software sources.
        :param pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterArgs'] custom_software_source_filter: (Updatable) Used to apply filters to a VendorSoftwareSource to create/update CustomSoftwareSources.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Information specified by the user about the software source.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_automatically_updated: (Updatable) Indicates whether service should automatically update the custom software source for the user.
        :param pulumi.Input[str] software_source_version: The version to assign to this custom software source.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "software_source_type", software_source_type)
        pulumi.set(__self__, "vendor_software_sources", vendor_software_sources)
        if custom_software_source_filter is not None:
            pulumi.set(__self__, "custom_software_source_filter", custom_software_source_filter)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_automatically_updated is not None:
            pulumi.set(__self__, "is_automatically_updated", is_automatically_updated)
        if software_source_version is not None:
            pulumi.set(__self__, "software_source_version", software_source_version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the tenancy containing the software source.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) User friendly name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="softwareSourceType")
    def software_source_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of the software source.
        """
        return pulumi.get(self, "software_source_type")

    @software_source_type.setter
    def software_source_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_source_type", value)

    @property
    @pulumi.getter(name="vendorSoftwareSources")
    def vendor_software_sources(self) -> pulumi.Input[Sequence[pulumi.Input['SoftwareSourceVendorSoftwareSourceArgs']]]:
        """
        (Updatable) List of vendor software sources.
        """
        return pulumi.get(self, "vendor_software_sources")

    @vendor_software_sources.setter
    def vendor_software_sources(self, value: pulumi.Input[Sequence[pulumi.Input['SoftwareSourceVendorSoftwareSourceArgs']]]):
        pulumi.set(self, "vendor_software_sources", value)

    @property
    @pulumi.getter(name="customSoftwareSourceFilter")
    def custom_software_source_filter(self) -> Optional[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterArgs']]:
        """
        (Updatable) Used to apply filters to a VendorSoftwareSource to create/update CustomSoftwareSources.
        """
        return pulumi.get(self, "custom_software_source_filter")

    @custom_software_source_filter.setter
    def custom_software_source_filter(self, value: Optional[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterArgs']]):
        pulumi.set(self, "custom_software_source_filter", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Information specified by the user about the software source.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutomaticallyUpdated")
    def is_automatically_updated(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether service should automatically update the custom software source for the user.
        """
        return pulumi.get(self, "is_automatically_updated")

    @is_automatically_updated.setter
    def is_automatically_updated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_automatically_updated", value)

    @property
    @pulumi.getter(name="softwareSourceVersion")
    def software_source_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version to assign to this custom software source.
        """
        return pulumi.get(self, "software_source_version")

    @software_source_version.setter
    def software_source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_source_version", value)


@pulumi.input_type
class _SoftwareSourceState:
    def __init__(__self__, *,
                 arch_type: Optional[pulumi.Input[str]] = None,
                 availability: Optional[pulumi.Input[str]] = None,
                 checksum_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 custom_software_source_filter: Optional[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gpg_key_fingerprint: Optional[pulumi.Input[str]] = None,
                 gpg_key_id: Optional[pulumi.Input[str]] = None,
                 gpg_key_url: Optional[pulumi.Input[str]] = None,
                 is_automatically_updated: Optional[pulumi.Input[bool]] = None,
                 os_family: Optional[pulumi.Input[str]] = None,
                 package_count: Optional[pulumi.Input[str]] = None,
                 repo_id: Optional[pulumi.Input[str]] = None,
                 software_source_type: Optional[pulumi.Input[str]] = None,
                 software_source_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 vendor_name: Optional[pulumi.Input[str]] = None,
                 vendor_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceVendorSoftwareSourceArgs']]]] = None):
        """
        Input properties used for looking up and filtering SoftwareSource resources.
        :param pulumi.Input[str] arch_type: The architecture type supported by the software source.
        :param pulumi.Input[str] availability: Possible availabilities of a software source.
        :param pulumi.Input[str] checksum_type: The yum repository checksum type used by this software source.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the tenancy containing the software source.
        :param pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterArgs'] custom_software_source_filter: (Updatable) Used to apply filters to a VendorSoftwareSource to create/update CustomSoftwareSources.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Information specified by the user about the software source.
        :param pulumi.Input[str] display_name: (Updatable) User friendly name.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gpg_key_fingerprint: Fingerprint of the GPG key for this software source.
        :param pulumi.Input[str] gpg_key_id: ID of the GPG key for this software source.
        :param pulumi.Input[str] gpg_key_url: URL of the GPG key for this software source.
        :param pulumi.Input[bool] is_automatically_updated: (Updatable) Indicates whether service should automatically update the custom software source for the user.
        :param pulumi.Input[str] os_family: The OS family the software source belongs to.
        :param pulumi.Input[str] package_count: Number of packages.
        :param pulumi.Input[str] repo_id: The Repo ID for the software source.
        :param pulumi.Input[str] software_source_type: (Updatable) Type of the software source.
        :param pulumi.Input[str] software_source_version: The version to assign to this custom software source.
        :param pulumi.Input[str] state: The current state of the software source.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the software source was created, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param pulumi.Input[str] url: URL for the repository.
        :param pulumi.Input[str] vendor_name: Name of the vendor providing the software source.
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareSourceVendorSoftwareSourceArgs']]] vendor_software_sources: (Updatable) List of vendor software sources.
        """
        if arch_type is not None:
            pulumi.set(__self__, "arch_type", arch_type)
        if availability is not None:
            pulumi.set(__self__, "availability", availability)
        if checksum_type is not None:
            pulumi.set(__self__, "checksum_type", checksum_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if custom_software_source_filter is not None:
            pulumi.set(__self__, "custom_software_source_filter", custom_software_source_filter)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gpg_key_fingerprint is not None:
            pulumi.set(__self__, "gpg_key_fingerprint", gpg_key_fingerprint)
        if gpg_key_id is not None:
            pulumi.set(__self__, "gpg_key_id", gpg_key_id)
        if gpg_key_url is not None:
            pulumi.set(__self__, "gpg_key_url", gpg_key_url)
        if is_automatically_updated is not None:
            pulumi.set(__self__, "is_automatically_updated", is_automatically_updated)
        if os_family is not None:
            pulumi.set(__self__, "os_family", os_family)
        if package_count is not None:
            pulumi.set(__self__, "package_count", package_count)
        if repo_id is not None:
            pulumi.set(__self__, "repo_id", repo_id)
        if software_source_type is not None:
            pulumi.set(__self__, "software_source_type", software_source_type)
        if software_source_version is not None:
            pulumi.set(__self__, "software_source_version", software_source_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if vendor_name is not None:
            pulumi.set(__self__, "vendor_name", vendor_name)
        if vendor_software_sources is not None:
            pulumi.set(__self__, "vendor_software_sources", vendor_software_sources)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[pulumi.Input[str]]:
        """
        The architecture type supported by the software source.
        """
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arch_type", value)

    @property
    @pulumi.getter
    def availability(self) -> Optional[pulumi.Input[str]]:
        """
        Possible availabilities of a software source.
        """
        return pulumi.get(self, "availability")

    @availability.setter
    def availability(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability", value)

    @property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> Optional[pulumi.Input[str]]:
        """
        The yum repository checksum type used by this software source.
        """
        return pulumi.get(self, "checksum_type")

    @checksum_type.setter
    def checksum_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checksum_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the tenancy containing the software source.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="customSoftwareSourceFilter")
    def custom_software_source_filter(self) -> Optional[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterArgs']]:
        """
        (Updatable) Used to apply filters to a VendorSoftwareSource to create/update CustomSoftwareSources.
        """
        return pulumi.get(self, "custom_software_source_filter")

    @custom_software_source_filter.setter
    def custom_software_source_filter(self, value: Optional[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterArgs']]):
        pulumi.set(self, "custom_software_source_filter", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Information specified by the user about the software source.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User friendly name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="gpgKeyFingerprint")
    def gpg_key_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Fingerprint of the GPG key for this software source.
        """
        return pulumi.get(self, "gpg_key_fingerprint")

    @gpg_key_fingerprint.setter
    def gpg_key_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gpg_key_fingerprint", value)

    @property
    @pulumi.getter(name="gpgKeyId")
    def gpg_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the GPG key for this software source.
        """
        return pulumi.get(self, "gpg_key_id")

    @gpg_key_id.setter
    def gpg_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gpg_key_id", value)

    @property
    @pulumi.getter(name="gpgKeyUrl")
    def gpg_key_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the GPG key for this software source.
        """
        return pulumi.get(self, "gpg_key_url")

    @gpg_key_url.setter
    def gpg_key_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gpg_key_url", value)

    @property
    @pulumi.getter(name="isAutomaticallyUpdated")
    def is_automatically_updated(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether service should automatically update the custom software source for the user.
        """
        return pulumi.get(self, "is_automatically_updated")

    @is_automatically_updated.setter
    def is_automatically_updated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_automatically_updated", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[pulumi.Input[str]]:
        """
        The OS family the software source belongs to.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter(name="packageCount")
    def package_count(self) -> Optional[pulumi.Input[str]]:
        """
        Number of packages.
        """
        return pulumi.get(self, "package_count")

    @package_count.setter
    def package_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_count", value)

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Repo ID for the software source.
        """
        return pulumi.get(self, "repo_id")

    @repo_id.setter
    def repo_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_id", value)

    @property
    @pulumi.getter(name="softwareSourceType")
    def software_source_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of the software source.
        """
        return pulumi.get(self, "software_source_type")

    @software_source_type.setter
    def software_source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_source_type", value)

    @property
    @pulumi.getter(name="softwareSourceVersion")
    def software_source_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version to assign to this custom software source.
        """
        return pulumi.get(self, "software_source_version")

    @software_source_version.setter
    def software_source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_source_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the software source.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the software source was created, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL for the repository.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the vendor providing the software source.
        """
        return pulumi.get(self, "vendor_name")

    @vendor_name.setter
    def vendor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor_name", value)

    @property
    @pulumi.getter(name="vendorSoftwareSources")
    def vendor_software_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceVendorSoftwareSourceArgs']]]]:
        """
        (Updatable) List of vendor software sources.
        """
        return pulumi.get(self, "vendor_software_sources")

    @vendor_software_sources.setter
    def vendor_software_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceVendorSoftwareSourceArgs']]]]):
        pulumi.set(self, "vendor_software_sources", value)


class SoftwareSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 custom_software_source_filter: Optional[pulumi.Input[pulumi.InputType['SoftwareSourceCustomSoftwareSourceFilterArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_automatically_updated: Optional[pulumi.Input[bool]] = None,
                 software_source_type: Optional[pulumi.Input[str]] = None,
                 software_source_version: Optional[pulumi.Input[str]] = None,
                 vendor_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SoftwareSourceVendorSoftwareSourceArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Software Source resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a new versioned or custom software source.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_software_source = oci.os_management_hub.SoftwareSource("testSoftwareSource",
            compartment_id=var["compartment_id"],
            display_name=var["software_source_display_name"],
            software_source_type=var["software_source_software_source_type"],
            vendor_software_sources=[oci.os_management_hub.SoftwareSourceVendorSoftwareSourceArgs(
                display_name=var["software_source_vendor_software_sources_display_name"],
                id=var["software_source_vendor_software_sources_id"],
            )],
            custom_software_source_filter=oci.os_management_hub.SoftwareSourceCustomSoftwareSourceFilterArgs(
                module_stream_profile_filters=[oci.os_management_hub.SoftwareSourceCustomSoftwareSourceFilterModuleStreamProfileFilterArgs(
                    filter_type=var["software_source_custom_software_source_filter_module_stream_profile_filters_filter_type"],
                    module_name=var["software_source_custom_software_source_filter_module_stream_profile_filters_module_name"],
                    profile_name=oci_os_management_hub_profile["test_profile"]["name"],
                    stream_name=oci_streaming_stream["test_stream"]["name"],
                )],
                package_filters=[oci.os_management_hub.SoftwareSourceCustomSoftwareSourceFilterPackageFilterArgs(
                    filter_type=var["software_source_custom_software_source_filter_package_filters_filter_type"],
                    package_name=var["software_source_custom_software_source_filter_package_filters_package_name"],
                    package_name_pattern=var["software_source_custom_software_source_filter_package_filters_package_name_pattern"],
                    package_version=var["software_source_custom_software_source_filter_package_filters_package_version"],
                )],
                package_group_filters=[oci.os_management_hub.SoftwareSourceCustomSoftwareSourceFilterPackageGroupFilterArgs(
                    filter_type=var["software_source_custom_software_source_filter_package_group_filters_filter_type"],
                    package_groups=var["software_source_custom_software_source_filter_package_group_filters_package_groups"],
                )],
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["software_source_description"],
            freeform_tags={
                "Department": "Finance",
            },
            is_automatically_updated=var["software_source_is_automatically_updated"],
            software_source_version=var["software_source_software_source_version"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        SoftwareSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/softwareSource:SoftwareSource test_software_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the tenancy containing the software source.
        :param pulumi.Input[pulumi.InputType['SoftwareSourceCustomSoftwareSourceFilterArgs']] custom_software_source_filter: (Updatable) Used to apply filters to a VendorSoftwareSource to create/update CustomSoftwareSources.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Information specified by the user about the software source.
        :param pulumi.Input[str] display_name: (Updatable) User friendly name.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_automatically_updated: (Updatable) Indicates whether service should automatically update the custom software source for the user.
        :param pulumi.Input[str] software_source_type: (Updatable) Type of the software source.
        :param pulumi.Input[str] software_source_version: The version to assign to this custom software source.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SoftwareSourceVendorSoftwareSourceArgs']]]] vendor_software_sources: (Updatable) List of vendor software sources.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SoftwareSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Software Source resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a new versioned or custom software source.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_software_source = oci.os_management_hub.SoftwareSource("testSoftwareSource",
            compartment_id=var["compartment_id"],
            display_name=var["software_source_display_name"],
            software_source_type=var["software_source_software_source_type"],
            vendor_software_sources=[oci.os_management_hub.SoftwareSourceVendorSoftwareSourceArgs(
                display_name=var["software_source_vendor_software_sources_display_name"],
                id=var["software_source_vendor_software_sources_id"],
            )],
            custom_software_source_filter=oci.os_management_hub.SoftwareSourceCustomSoftwareSourceFilterArgs(
                module_stream_profile_filters=[oci.os_management_hub.SoftwareSourceCustomSoftwareSourceFilterModuleStreamProfileFilterArgs(
                    filter_type=var["software_source_custom_software_source_filter_module_stream_profile_filters_filter_type"],
                    module_name=var["software_source_custom_software_source_filter_module_stream_profile_filters_module_name"],
                    profile_name=oci_os_management_hub_profile["test_profile"]["name"],
                    stream_name=oci_streaming_stream["test_stream"]["name"],
                )],
                package_filters=[oci.os_management_hub.SoftwareSourceCustomSoftwareSourceFilterPackageFilterArgs(
                    filter_type=var["software_source_custom_software_source_filter_package_filters_filter_type"],
                    package_name=var["software_source_custom_software_source_filter_package_filters_package_name"],
                    package_name_pattern=var["software_source_custom_software_source_filter_package_filters_package_name_pattern"],
                    package_version=var["software_source_custom_software_source_filter_package_filters_package_version"],
                )],
                package_group_filters=[oci.os_management_hub.SoftwareSourceCustomSoftwareSourceFilterPackageGroupFilterArgs(
                    filter_type=var["software_source_custom_software_source_filter_package_group_filters_filter_type"],
                    package_groups=var["software_source_custom_software_source_filter_package_group_filters_package_groups"],
                )],
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["software_source_description"],
            freeform_tags={
                "Department": "Finance",
            },
            is_automatically_updated=var["software_source_is_automatically_updated"],
            software_source_version=var["software_source_software_source_version"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        SoftwareSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/softwareSource:SoftwareSource test_software_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param SoftwareSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SoftwareSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 custom_software_source_filter: Optional[pulumi.Input[pulumi.InputType['SoftwareSourceCustomSoftwareSourceFilterArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_automatically_updated: Optional[pulumi.Input[bool]] = None,
                 software_source_type: Optional[pulumi.Input[str]] = None,
                 software_source_version: Optional[pulumi.Input[str]] = None,
                 vendor_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SoftwareSourceVendorSoftwareSourceArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SoftwareSourceArgs.__new__(SoftwareSourceArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["custom_software_source_filter"] = custom_software_source_filter
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_automatically_updated"] = is_automatically_updated
            if software_source_type is None and not opts.urn:
                raise TypeError("Missing required property 'software_source_type'")
            __props__.__dict__["software_source_type"] = software_source_type
            __props__.__dict__["software_source_version"] = software_source_version
            if vendor_software_sources is None and not opts.urn:
                raise TypeError("Missing required property 'vendor_software_sources'")
            __props__.__dict__["vendor_software_sources"] = vendor_software_sources
            __props__.__dict__["arch_type"] = None
            __props__.__dict__["availability"] = None
            __props__.__dict__["checksum_type"] = None
            __props__.__dict__["gpg_key_fingerprint"] = None
            __props__.__dict__["gpg_key_id"] = None
            __props__.__dict__["gpg_key_url"] = None
            __props__.__dict__["os_family"] = None
            __props__.__dict__["package_count"] = None
            __props__.__dict__["repo_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["url"] = None
            __props__.__dict__["vendor_name"] = None
        super(SoftwareSource, __self__).__init__(
            'oci:OsManagementHub/softwareSource:SoftwareSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arch_type: Optional[pulumi.Input[str]] = None,
            availability: Optional[pulumi.Input[str]] = None,
            checksum_type: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            custom_software_source_filter: Optional[pulumi.Input[pulumi.InputType['SoftwareSourceCustomSoftwareSourceFilterArgs']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            gpg_key_fingerprint: Optional[pulumi.Input[str]] = None,
            gpg_key_id: Optional[pulumi.Input[str]] = None,
            gpg_key_url: Optional[pulumi.Input[str]] = None,
            is_automatically_updated: Optional[pulumi.Input[bool]] = None,
            os_family: Optional[pulumi.Input[str]] = None,
            package_count: Optional[pulumi.Input[str]] = None,
            repo_id: Optional[pulumi.Input[str]] = None,
            software_source_type: Optional[pulumi.Input[str]] = None,
            software_source_version: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            vendor_name: Optional[pulumi.Input[str]] = None,
            vendor_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SoftwareSourceVendorSoftwareSourceArgs']]]]] = None) -> 'SoftwareSource':
        """
        Get an existing SoftwareSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arch_type: The architecture type supported by the software source.
        :param pulumi.Input[str] availability: Possible availabilities of a software source.
        :param pulumi.Input[str] checksum_type: The yum repository checksum type used by this software source.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the tenancy containing the software source.
        :param pulumi.Input[pulumi.InputType['SoftwareSourceCustomSoftwareSourceFilterArgs']] custom_software_source_filter: (Updatable) Used to apply filters to a VendorSoftwareSource to create/update CustomSoftwareSources.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Information specified by the user about the software source.
        :param pulumi.Input[str] display_name: (Updatable) User friendly name.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gpg_key_fingerprint: Fingerprint of the GPG key for this software source.
        :param pulumi.Input[str] gpg_key_id: ID of the GPG key for this software source.
        :param pulumi.Input[str] gpg_key_url: URL of the GPG key for this software source.
        :param pulumi.Input[bool] is_automatically_updated: (Updatable) Indicates whether service should automatically update the custom software source for the user.
        :param pulumi.Input[str] os_family: The OS family the software source belongs to.
        :param pulumi.Input[str] package_count: Number of packages.
        :param pulumi.Input[str] repo_id: The Repo ID for the software source.
        :param pulumi.Input[str] software_source_type: (Updatable) Type of the software source.
        :param pulumi.Input[str] software_source_version: The version to assign to this custom software source.
        :param pulumi.Input[str] state: The current state of the software source.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the software source was created, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param pulumi.Input[str] url: URL for the repository.
        :param pulumi.Input[str] vendor_name: Name of the vendor providing the software source.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SoftwareSourceVendorSoftwareSourceArgs']]]] vendor_software_sources: (Updatable) List of vendor software sources.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SoftwareSourceState.__new__(_SoftwareSourceState)

        __props__.__dict__["arch_type"] = arch_type
        __props__.__dict__["availability"] = availability
        __props__.__dict__["checksum_type"] = checksum_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["custom_software_source_filter"] = custom_software_source_filter
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gpg_key_fingerprint"] = gpg_key_fingerprint
        __props__.__dict__["gpg_key_id"] = gpg_key_id
        __props__.__dict__["gpg_key_url"] = gpg_key_url
        __props__.__dict__["is_automatically_updated"] = is_automatically_updated
        __props__.__dict__["os_family"] = os_family
        __props__.__dict__["package_count"] = package_count
        __props__.__dict__["repo_id"] = repo_id
        __props__.__dict__["software_source_type"] = software_source_type
        __props__.__dict__["software_source_version"] = software_source_version
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["url"] = url
        __props__.__dict__["vendor_name"] = vendor_name
        __props__.__dict__["vendor_software_sources"] = vendor_software_sources
        return SoftwareSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> pulumi.Output[str]:
        """
        The architecture type supported by the software source.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter
    def availability(self) -> pulumi.Output[str]:
        """
        Possible availabilities of a software source.
        """
        return pulumi.get(self, "availability")

    @property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> pulumi.Output[str]:
        """
        The yum repository checksum type used by this software source.
        """
        return pulumi.get(self, "checksum_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the tenancy containing the software source.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="customSoftwareSourceFilter")
    def custom_software_source_filter(self) -> pulumi.Output['outputs.SoftwareSourceCustomSoftwareSourceFilter']:
        """
        (Updatable) Used to apply filters to a VendorSoftwareSource to create/update CustomSoftwareSources.
        """
        return pulumi.get(self, "custom_software_source_filter")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Information specified by the user about the software source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) User friendly name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gpgKeyFingerprint")
    def gpg_key_fingerprint(self) -> pulumi.Output[str]:
        """
        Fingerprint of the GPG key for this software source.
        """
        return pulumi.get(self, "gpg_key_fingerprint")

    @property
    @pulumi.getter(name="gpgKeyId")
    def gpg_key_id(self) -> pulumi.Output[str]:
        """
        ID of the GPG key for this software source.
        """
        return pulumi.get(self, "gpg_key_id")

    @property
    @pulumi.getter(name="gpgKeyUrl")
    def gpg_key_url(self) -> pulumi.Output[str]:
        """
        URL of the GPG key for this software source.
        """
        return pulumi.get(self, "gpg_key_url")

    @property
    @pulumi.getter(name="isAutomaticallyUpdated")
    def is_automatically_updated(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether service should automatically update the custom software source for the user.
        """
        return pulumi.get(self, "is_automatically_updated")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Output[str]:
        """
        The OS family the software source belongs to.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="packageCount")
    def package_count(self) -> pulumi.Output[str]:
        """
        Number of packages.
        """
        return pulumi.get(self, "package_count")

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> pulumi.Output[str]:
        """
        The Repo ID for the software source.
        """
        return pulumi.get(self, "repo_id")

    @property
    @pulumi.getter(name="softwareSourceType")
    def software_source_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Type of the software source.
        """
        return pulumi.get(self, "software_source_type")

    @property
    @pulumi.getter(name="softwareSourceVersion")
    def software_source_version(self) -> pulumi.Output[str]:
        """
        The version to assign to this custom software source.
        """
        return pulumi.get(self, "software_source_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the software source.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the software source was created, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        URL for the repository.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> pulumi.Output[str]:
        """
        Name of the vendor providing the software source.
        """
        return pulumi.get(self, "vendor_name")

    @property
    @pulumi.getter(name="vendorSoftwareSources")
    def vendor_software_sources(self) -> pulumi.Output[Sequence['outputs.SoftwareSourceVendorSoftwareSource']]:
        """
        (Updatable) List of vendor software sources.
        """
        return pulumi.get(self, "vendor_software_sources")

