# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVirtualServicesResult',
    'AwaitableGetVirtualServicesResult',
    'get_virtual_services',
    'get_virtual_services_output',
]

@pulumi.output_type
class GetVirtualServicesResult:
    """
    A collection of values returned by getVirtualServices.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, mesh_id=None, name=None, state=None, virtual_service_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mesh_id and not isinstance(mesh_id, str):
            raise TypeError("Expected argument 'mesh_id' to be a str")
        pulumi.set(__self__, "mesh_id", mesh_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if virtual_service_collections and not isinstance(virtual_service_collections, list):
            raise TypeError("Expected argument 'virtual_service_collections' to be a list")
        pulumi.set(__self__, "virtual_service_collections", virtual_service_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVirtualServicesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="meshId")
    def mesh_id(self) -> Optional[str]:
        """
        The OCID of the service mesh in which this virtual service is created.
        """
        return pulumi.get(self, "mesh_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A user-friendly name. The name has to be unique within the same service mesh and cannot be changed after creation. Avoid entering confidential information.  Example: `My unique resource name`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="virtualServiceCollections")
    def virtual_service_collections(self) -> Sequence['outputs.GetVirtualServicesVirtualServiceCollectionResult']:
        """
        The list of virtual_service_collection.
        """
        return pulumi.get(self, "virtual_service_collections")


class AwaitableGetVirtualServicesResult(GetVirtualServicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualServicesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            mesh_id=self.mesh_id,
            name=self.name,
            state=self.state,
            virtual_service_collections=self.virtual_service_collections)


def get_virtual_services(compartment_id: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetVirtualServicesFilterArgs']]] = None,
                         id: Optional[str] = None,
                         mesh_id: Optional[str] = None,
                         name: Optional[str] = None,
                         state: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualServicesResult:
    """
    This data source provides the list of Virtual Services in Oracle Cloud Infrastructure Service Mesh service.

    Returns a list of VirtualService objects.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_virtual_services = oci.ServiceMesh.get_virtual_services(compartment_id=var["compartment_id"],
        id=var["virtual_service_id"],
        mesh_id=oci_service_mesh_mesh["test_mesh"]["id"],
        name=var["virtual_service_name"],
        state=var["virtual_service_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str id: Unique VirtualService identifier.
    :param str mesh_id: Unique Mesh identifier.
    :param str name: A filter to return only resources that match the entire name given.
    :param str state: A filter to return only resources that match the life cycle state given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['meshId'] = mesh_id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ServiceMesh/getVirtualServices:getVirtualServices', __args__, opts=opts, typ=GetVirtualServicesResult).value

    return AwaitableGetVirtualServicesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        mesh_id=pulumi.get(__ret__, 'mesh_id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        virtual_service_collections=pulumi.get(__ret__, 'virtual_service_collections'))


@_utilities.lift_output_func(get_virtual_services)
def get_virtual_services_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetVirtualServicesFilterArgs']]]]] = None,
                                id: Optional[pulumi.Input[Optional[str]]] = None,
                                mesh_id: Optional[pulumi.Input[Optional[str]]] = None,
                                name: Optional[pulumi.Input[Optional[str]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVirtualServicesResult]:
    """
    This data source provides the list of Virtual Services in Oracle Cloud Infrastructure Service Mesh service.

    Returns a list of VirtualService objects.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_virtual_services = oci.ServiceMesh.get_virtual_services(compartment_id=var["compartment_id"],
        id=var["virtual_service_id"],
        mesh_id=oci_service_mesh_mesh["test_mesh"]["id"],
        name=var["virtual_service_name"],
        state=var["virtual_service_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str id: Unique VirtualService identifier.
    :param str mesh_id: Unique Mesh identifier.
    :param str name: A filter to return only resources that match the entire name given.
    :param str state: A filter to return only resources that match the life cycle state given.
    """
    ...
