# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiscoveryJobArgs', 'DiscoveryJob']

@pulumi.input_type
class DiscoveryJobArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 discovery_details: pulumi.Input['DiscoveryJobDiscoveryDetailsArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_client: Optional[pulumi.Input[str]] = None,
                 discovery_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 should_propagate_tags_to_discovered_resources: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a DiscoveryJob resource.
        :param pulumi.Input[str] compartment_id: The OCID of Compartment
        :param pulumi.Input['DiscoveryJobDiscoveryDetailsArgs'] discovery_details: The request of DiscoveryJob Resource details.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] discovery_client: Client who submits discovery job.
        :param pulumi.Input[str] discovery_type: Add option submits new discovery Job. Add with retry option to re-submit failed discovery job. Refresh option refreshes the existing discovered resources.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] should_propagate_tags_to_discovered_resources: If this parameter set to true, the specified tags will be applied  to all resources discovered in the current request.  Default is true. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "discovery_details", discovery_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if discovery_client is not None:
            pulumi.set(__self__, "discovery_client", discovery_client)
        if discovery_type is not None:
            pulumi.set(__self__, "discovery_type", discovery_type)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if should_propagate_tags_to_discovered_resources is not None:
            pulumi.set(__self__, "should_propagate_tags_to_discovered_resources", should_propagate_tags_to_discovered_resources)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of Compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="discoveryDetails")
    def discovery_details(self) -> pulumi.Input['DiscoveryJobDiscoveryDetailsArgs']:
        """
        The request of DiscoveryJob Resource details.
        """
        return pulumi.get(self, "discovery_details")

    @discovery_details.setter
    def discovery_details(self, value: pulumi.Input['DiscoveryJobDiscoveryDetailsArgs']):
        pulumi.set(self, "discovery_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="discoveryClient")
    def discovery_client(self) -> Optional[pulumi.Input[str]]:
        """
        Client who submits discovery job.
        """
        return pulumi.get(self, "discovery_client")

    @discovery_client.setter
    def discovery_client(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_client", value)

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> Optional[pulumi.Input[str]]:
        """
        Add option submits new discovery Job. Add with retry option to re-submit failed discovery job. Refresh option refreshes the existing discovered resources.
        """
        return pulumi.get(self, "discovery_type")

    @discovery_type.setter
    def discovery_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_type", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="shouldPropagateTagsToDiscoveredResources")
    def should_propagate_tags_to_discovered_resources(self) -> Optional[pulumi.Input[bool]]:
        """
        If this parameter set to true, the specified tags will be applied  to all resources discovered in the current request.  Default is true. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_propagate_tags_to_discovered_resources")

    @should_propagate_tags_to_discovered_resources.setter
    def should_propagate_tags_to_discovered_resources(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_propagate_tags_to_discovered_resources", value)


@pulumi.input_type
class _DiscoveryJobState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_client: Optional[pulumi.Input[str]] = None,
                 discovery_details: Optional[pulumi.Input['DiscoveryJobDiscoveryDetailsArgs']] = None,
                 discovery_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 should_propagate_tags_to_discovered_resources: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 status_message: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DiscoveryJob resources.
        :param pulumi.Input[str] compartment_id: The OCID of Compartment
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] discovery_client: Client who submits discovery job.
        :param pulumi.Input['DiscoveryJobDiscoveryDetailsArgs'] discovery_details: The request of DiscoveryJob Resource details.
        :param pulumi.Input[str] discovery_type: Add option submits new discovery Job. Add with retry option to re-submit failed discovery job. Refresh option refreshes the existing discovered resources.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] should_propagate_tags_to_discovered_resources: If this parameter set to true, the specified tags will be applied  to all resources discovered in the current request.  Default is true. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the DiscoveryJob Resource.
        :param pulumi.Input[str] status: Specifies the status of the discovery job
        :param pulumi.Input[str] status_message: The short summary of the status of the discovery job
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] tenant_id: The OCID of Tenant
        :param pulumi.Input[str] time_updated: The time the discovery Job was updated.
        :param pulumi.Input[str] user_id: The OCID of user in which the job is submitted
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if discovery_client is not None:
            pulumi.set(__self__, "discovery_client", discovery_client)
        if discovery_details is not None:
            pulumi.set(__self__, "discovery_details", discovery_details)
        if discovery_type is not None:
            pulumi.set(__self__, "discovery_type", discovery_type)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if should_propagate_tags_to_discovered_resources is not None:
            pulumi.set(__self__, "should_propagate_tags_to_discovered_resources", should_propagate_tags_to_discovered_resources)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of Compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="discoveryClient")
    def discovery_client(self) -> Optional[pulumi.Input[str]]:
        """
        Client who submits discovery job.
        """
        return pulumi.get(self, "discovery_client")

    @discovery_client.setter
    def discovery_client(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_client", value)

    @property
    @pulumi.getter(name="discoveryDetails")
    def discovery_details(self) -> Optional[pulumi.Input['DiscoveryJobDiscoveryDetailsArgs']]:
        """
        The request of DiscoveryJob Resource details.
        """
        return pulumi.get(self, "discovery_details")

    @discovery_details.setter
    def discovery_details(self, value: Optional[pulumi.Input['DiscoveryJobDiscoveryDetailsArgs']]):
        pulumi.set(self, "discovery_details", value)

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> Optional[pulumi.Input[str]]:
        """
        Add option submits new discovery Job. Add with retry option to re-submit failed discovery job. Refresh option refreshes the existing discovered resources.
        """
        return pulumi.get(self, "discovery_type")

    @discovery_type.setter
    def discovery_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_type", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="shouldPropagateTagsToDiscoveredResources")
    def should_propagate_tags_to_discovered_resources(self) -> Optional[pulumi.Input[bool]]:
        """
        If this parameter set to true, the specified tags will be applied  to all resources discovered in the current request.  Default is true. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_propagate_tags_to_discovered_resources")

    @should_propagate_tags_to_discovered_resources.setter
    def should_propagate_tags_to_discovered_resources(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_propagate_tags_to_discovered_resources", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the DiscoveryJob Resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the status of the discovery job
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[pulumi.Input[str]]:
        """
        The short summary of the status of the discovery job
        """
        return pulumi.get(self, "status_message")

    @status_message.setter
    def status_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_message", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of Tenant
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the discovery Job was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of user in which the job is submitted
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class DiscoveryJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_client: Optional[pulumi.Input[str]] = None,
                 discovery_details: Optional[pulumi.Input[pulumi.InputType['DiscoveryJobDiscoveryDetailsArgs']]] = None,
                 discovery_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 should_propagate_tags_to_discovered_resources: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource provides the Discovery Job resource in Oracle Cloud Infrastructure Stack Monitoring service.

        API to create discovery Job and submit discovery Details to agent.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_discovery_job = oci.stack_monitoring.DiscoveryJob("testDiscoveryJob",
            compartment_id=var["compartment_id"],
            discovery_details=oci.stack_monitoring.DiscoveryJobDiscoveryDetailsArgs(
                agent_id=var["management_agent_id"],
                properties=oci.stack_monitoring.DiscoveryJobDiscoveryDetailsPropertiesArgs(
                    properties_map=var["discovery_job_discovery_details_properties_properties_map"],
                ),
                resource_name=var["discovery_job_discovery_details_resource_name"],
                resource_type=var["discovery_job_discovery_details_resource_type"],
                credentials=oci.stack_monitoring.DiscoveryJobDiscoveryDetailsCredentialsArgs(
                    items=[oci.stack_monitoring.DiscoveryJobDiscoveryDetailsCredentialsItemArgs(
                        credential_name=var["discovery_job_discovery_details_credentials_items_credential_name"],
                        credential_type=var["discovery_job_discovery_details_credentials_items_credential_type"],
                        properties=oci.stack_monitoring.DiscoveryJobDiscoveryDetailsCredentialsItemPropertiesArgs(
                            properties_map=var["discovery_job_discovery_details_credentials_items_properties_properties_map"],
                        ),
                    )],
                ),
                license=var["discovery_job_discovery_details_license"],
                tags=oci.stack_monitoring.DiscoveryJobDiscoveryDetailsTagsArgs(
                    properties_map=var["discovery_job_discovery_details_tags_properties_map"],
                ),
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            discovery_client=var["discovery_job_discovery_client"],
            discovery_type=var["discovery_job_discovery_type"],
            freeform_tags={
                "bar-key": "value",
            },
            should_propagate_tags_to_discovered_resources=var["discovery_job_should_propagate_tags_to_discovered_resources"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        DiscoveryJobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/discoveryJob:DiscoveryJob test_discovery_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of Compartment
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] discovery_client: Client who submits discovery job.
        :param pulumi.Input[pulumi.InputType['DiscoveryJobDiscoveryDetailsArgs']] discovery_details: The request of DiscoveryJob Resource details.
        :param pulumi.Input[str] discovery_type: Add option submits new discovery Job. Add with retry option to re-submit failed discovery job. Refresh option refreshes the existing discovered resources.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] should_propagate_tags_to_discovered_resources: If this parameter set to true, the specified tags will be applied  to all resources discovered in the current request.  Default is true. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiscoveryJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Discovery Job resource in Oracle Cloud Infrastructure Stack Monitoring service.

        API to create discovery Job and submit discovery Details to agent.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_discovery_job = oci.stack_monitoring.DiscoveryJob("testDiscoveryJob",
            compartment_id=var["compartment_id"],
            discovery_details=oci.stack_monitoring.DiscoveryJobDiscoveryDetailsArgs(
                agent_id=var["management_agent_id"],
                properties=oci.stack_monitoring.DiscoveryJobDiscoveryDetailsPropertiesArgs(
                    properties_map=var["discovery_job_discovery_details_properties_properties_map"],
                ),
                resource_name=var["discovery_job_discovery_details_resource_name"],
                resource_type=var["discovery_job_discovery_details_resource_type"],
                credentials=oci.stack_monitoring.DiscoveryJobDiscoveryDetailsCredentialsArgs(
                    items=[oci.stack_monitoring.DiscoveryJobDiscoveryDetailsCredentialsItemArgs(
                        credential_name=var["discovery_job_discovery_details_credentials_items_credential_name"],
                        credential_type=var["discovery_job_discovery_details_credentials_items_credential_type"],
                        properties=oci.stack_monitoring.DiscoveryJobDiscoveryDetailsCredentialsItemPropertiesArgs(
                            properties_map=var["discovery_job_discovery_details_credentials_items_properties_properties_map"],
                        ),
                    )],
                ),
                license=var["discovery_job_discovery_details_license"],
                tags=oci.stack_monitoring.DiscoveryJobDiscoveryDetailsTagsArgs(
                    properties_map=var["discovery_job_discovery_details_tags_properties_map"],
                ),
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            discovery_client=var["discovery_job_discovery_client"],
            discovery_type=var["discovery_job_discovery_type"],
            freeform_tags={
                "bar-key": "value",
            },
            should_propagate_tags_to_discovered_resources=var["discovery_job_should_propagate_tags_to_discovered_resources"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        DiscoveryJobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/discoveryJob:DiscoveryJob test_discovery_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param DiscoveryJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiscoveryJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_client: Optional[pulumi.Input[str]] = None,
                 discovery_details: Optional[pulumi.Input[pulumi.InputType['DiscoveryJobDiscoveryDetailsArgs']]] = None,
                 discovery_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 should_propagate_tags_to_discovered_resources: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiscoveryJobArgs.__new__(DiscoveryJobArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["discovery_client"] = discovery_client
            if discovery_details is None and not opts.urn:
                raise TypeError("Missing required property 'discovery_details'")
            __props__.__dict__["discovery_details"] = discovery_details
            __props__.__dict__["discovery_type"] = discovery_type
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["should_propagate_tags_to_discovered_resources"] = should_propagate_tags_to_discovered_resources
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_message"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["user_id"] = None
        super(DiscoveryJob, __self__).__init__(
            'oci:StackMonitoring/discoveryJob:DiscoveryJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            discovery_client: Optional[pulumi.Input[str]] = None,
            discovery_details: Optional[pulumi.Input[pulumi.InputType['DiscoveryJobDiscoveryDetailsArgs']]] = None,
            discovery_type: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            should_propagate_tags_to_discovered_resources: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            status_message: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'DiscoveryJob':
        """
        Get an existing DiscoveryJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of Compartment
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] discovery_client: Client who submits discovery job.
        :param pulumi.Input[pulumi.InputType['DiscoveryJobDiscoveryDetailsArgs']] discovery_details: The request of DiscoveryJob Resource details.
        :param pulumi.Input[str] discovery_type: Add option submits new discovery Job. Add with retry option to re-submit failed discovery job. Refresh option refreshes the existing discovered resources.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] should_propagate_tags_to_discovered_resources: If this parameter set to true, the specified tags will be applied  to all resources discovered in the current request.  Default is true. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the DiscoveryJob Resource.
        :param pulumi.Input[str] status: Specifies the status of the discovery job
        :param pulumi.Input[str] status_message: The short summary of the status of the discovery job
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] tenant_id: The OCID of Tenant
        :param pulumi.Input[str] time_updated: The time the discovery Job was updated.
        :param pulumi.Input[str] user_id: The OCID of user in which the job is submitted
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiscoveryJobState.__new__(_DiscoveryJobState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["discovery_client"] = discovery_client
        __props__.__dict__["discovery_details"] = discovery_details
        __props__.__dict__["discovery_type"] = discovery_type
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["should_propagate_tags_to_discovered_resources"] = should_propagate_tags_to_discovered_resources
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["status_message"] = status_message
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["user_id"] = user_id
        return DiscoveryJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of Compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="discoveryClient")
    def discovery_client(self) -> pulumi.Output[str]:
        """
        Client who submits discovery job.
        """
        return pulumi.get(self, "discovery_client")

    @property
    @pulumi.getter(name="discoveryDetails")
    def discovery_details(self) -> pulumi.Output['outputs.DiscoveryJobDiscoveryDetails']:
        """
        The request of DiscoveryJob Resource details.
        """
        return pulumi.get(self, "discovery_details")

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> pulumi.Output[Optional[str]]:
        """
        Add option submits new discovery Job. Add with retry option to re-submit failed discovery job. Refresh option refreshes the existing discovered resources.
        """
        return pulumi.get(self, "discovery_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="shouldPropagateTagsToDiscoveredResources")
    def should_propagate_tags_to_discovered_resources(self) -> pulumi.Output[bool]:
        """
        If this parameter set to true, the specified tags will be applied  to all resources discovered in the current request.  Default is true. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_propagate_tags_to_discovered_resources")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the DiscoveryJob Resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Specifies the status of the discovery job
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[str]:
        """
        The short summary of the status of the discovery job
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The OCID of Tenant
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the discovery Job was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The OCID of user in which the job is submitted
        """
        return pulumi.get(self, "user_id")

