# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CellularControllerFeatureTemplateArgs', 'CellularControllerFeatureTemplate']

@pulumi.input_type
class CellularControllerFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 cellular_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cellular_interface_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 data_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['CellularControllerFeatureTemplateDataProfileArgs']]]] = None,
                 firmware_auto_sim: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware_auto_sim_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_sim_slot: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_sim_slot_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_retries_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CellularControllerFeatureTemplate resource.
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.str] cellular_interface_id: Cellular interface name
        :param pulumi.Input[_builtins.str] cellular_interface_id_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CellularControllerFeatureTemplateDataProfileArgs']]] data_profiles: Data Profile List
        :param pulumi.Input[_builtins.bool] firmware_auto_sim: Enable/Disable Firmware Auto Sim
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] firmware_auto_sim_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[_builtins.int] primary_sim_slot: Set primary SIM slot
                 - Range: `0`-`255`
        :param pulumi.Input[_builtins.str] primary_sim_slot_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_retries: Set SIM failover retries
                 - Range: `0`-`65535`
        :param pulumi.Input[_builtins.str] sim_failover_retries_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_timeout: Set SIM failover timeout in minutes
                 - Range: `3`-`7`
        :param pulumi.Input[_builtins.str] sim_failover_timeout_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if cellular_interface_id is not None:
            pulumi.set(__self__, "cellular_interface_id", cellular_interface_id)
        if cellular_interface_id_variable is not None:
            pulumi.set(__self__, "cellular_interface_id_variable", cellular_interface_id_variable)
        if data_profiles is not None:
            pulumi.set(__self__, "data_profiles", data_profiles)
        if firmware_auto_sim is not None:
            pulumi.set(__self__, "firmware_auto_sim", firmware_auto_sim)
        if firmware_auto_sim_variable is not None:
            pulumi.set(__self__, "firmware_auto_sim_variable", firmware_auto_sim_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_sim_slot is not None:
            pulumi.set(__self__, "primary_sim_slot", primary_sim_slot)
        if primary_sim_slot_variable is not None:
            pulumi.set(__self__, "primary_sim_slot_variable", primary_sim_slot_variable)
        if sim_failover_retries is not None:
            pulumi.set(__self__, "sim_failover_retries", sim_failover_retries)
        if sim_failover_retries_variable is not None:
            pulumi.set(__self__, "sim_failover_retries_variable", sim_failover_retries_variable)
        if sim_failover_timeout is not None:
            pulumi.set(__self__, "sim_failover_timeout", sim_failover_timeout)
        if sim_failover_timeout_variable is not None:
            pulumi.set(__self__, "sim_failover_timeout_variable", sim_failover_timeout_variable)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @_builtins.property
    @pulumi.getter(name="cellularInterfaceId")
    def cellular_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cellular interface name
        """
        return pulumi.get(self, "cellular_interface_id")

    @cellular_interface_id.setter
    def cellular_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cellular_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="cellularInterfaceIdVariable")
    def cellular_interface_id_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "cellular_interface_id_variable")

    @cellular_interface_id_variable.setter
    def cellular_interface_id_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cellular_interface_id_variable", value)

    @_builtins.property
    @pulumi.getter(name="dataProfiles")
    def data_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CellularControllerFeatureTemplateDataProfileArgs']]]]:
        """
        Data Profile List
        """
        return pulumi.get(self, "data_profiles")

    @data_profiles.setter
    def data_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CellularControllerFeatureTemplateDataProfileArgs']]]]):
        pulumi.set(self, "data_profiles", value)

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSim")
    def firmware_auto_sim(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable/Disable Firmware Auto Sim
          - Default value: `true`
        """
        return pulumi.get(self, "firmware_auto_sim")

    @firmware_auto_sim.setter
    def firmware_auto_sim(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "firmware_auto_sim", value)

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSimVariable")
    def firmware_auto_sim_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "firmware_auto_sim_variable")

    @firmware_auto_sim_variable.setter
    def firmware_auto_sim_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firmware_auto_sim_variable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primarySimSlot")
    def primary_sim_slot(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set primary SIM slot
          - Range: `0`-`255`
        """
        return pulumi.get(self, "primary_sim_slot")

    @primary_sim_slot.setter
    def primary_sim_slot(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "primary_sim_slot", value)

    @_builtins.property
    @pulumi.getter(name="primarySimSlotVariable")
    def primary_sim_slot_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_sim_slot_variable")

    @primary_sim_slot_variable.setter
    def primary_sim_slot_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_sim_slot_variable", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverRetries")
    def sim_failover_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set SIM failover retries
          - Range: `0`-`65535`
        """
        return pulumi.get(self, "sim_failover_retries")

    @sim_failover_retries.setter
    def sim_failover_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sim_failover_retries", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverRetriesVariable")
    def sim_failover_retries_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_retries_variable")

    @sim_failover_retries_variable.setter
    def sim_failover_retries_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sim_failover_retries_variable", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeout")
    def sim_failover_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set SIM failover timeout in minutes
          - Range: `3`-`7`
        """
        return pulumi.get(self, "sim_failover_timeout")

    @sim_failover_timeout.setter
    def sim_failover_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sim_failover_timeout", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeoutVariable")
    def sim_failover_timeout_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_timeout_variable")

    @sim_failover_timeout_variable.setter
    def sim_failover_timeout_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sim_failover_timeout_variable", value)


@pulumi.input_type
class _CellularControllerFeatureTemplateState:
    def __init__(__self__, *,
                 cellular_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cellular_interface_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 data_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['CellularControllerFeatureTemplateDataProfileArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 firmware_auto_sim: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware_auto_sim_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_sim_slot: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_sim_slot_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_retries_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CellularControllerFeatureTemplate resources.
        :param pulumi.Input[_builtins.str] cellular_interface_id: Cellular interface name
        :param pulumi.Input[_builtins.str] cellular_interface_id_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CellularControllerFeatureTemplateDataProfileArgs']]] data_profiles: Data Profile List
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.bool] firmware_auto_sim: Enable/Disable Firmware Auto Sim
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] firmware_auto_sim_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[_builtins.int] primary_sim_slot: Set primary SIM slot
                 - Range: `0`-`255`
        :param pulumi.Input[_builtins.str] primary_sim_slot_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_retries: Set SIM failover retries
                 - Range: `0`-`65535`
        :param pulumi.Input[_builtins.str] sim_failover_retries_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_timeout: Set SIM failover timeout in minutes
                 - Range: `3`-`7`
        :param pulumi.Input[_builtins.str] sim_failover_timeout_variable: Variable name
        :param pulumi.Input[_builtins.str] template_type: The template type
        :param pulumi.Input[_builtins.int] version: The version of the feature template
        """
        if cellular_interface_id is not None:
            pulumi.set(__self__, "cellular_interface_id", cellular_interface_id)
        if cellular_interface_id_variable is not None:
            pulumi.set(__self__, "cellular_interface_id_variable", cellular_interface_id_variable)
        if data_profiles is not None:
            pulumi.set(__self__, "data_profiles", data_profiles)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if firmware_auto_sim is not None:
            pulumi.set(__self__, "firmware_auto_sim", firmware_auto_sim)
        if firmware_auto_sim_variable is not None:
            pulumi.set(__self__, "firmware_auto_sim_variable", firmware_auto_sim_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_sim_slot is not None:
            pulumi.set(__self__, "primary_sim_slot", primary_sim_slot)
        if primary_sim_slot_variable is not None:
            pulumi.set(__self__, "primary_sim_slot_variable", primary_sim_slot_variable)
        if sim_failover_retries is not None:
            pulumi.set(__self__, "sim_failover_retries", sim_failover_retries)
        if sim_failover_retries_variable is not None:
            pulumi.set(__self__, "sim_failover_retries_variable", sim_failover_retries_variable)
        if sim_failover_timeout is not None:
            pulumi.set(__self__, "sim_failover_timeout", sim_failover_timeout)
        if sim_failover_timeout_variable is not None:
            pulumi.set(__self__, "sim_failover_timeout_variable", sim_failover_timeout_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="cellularInterfaceId")
    def cellular_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cellular interface name
        """
        return pulumi.get(self, "cellular_interface_id")

    @cellular_interface_id.setter
    def cellular_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cellular_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="cellularInterfaceIdVariable")
    def cellular_interface_id_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "cellular_interface_id_variable")

    @cellular_interface_id_variable.setter
    def cellular_interface_id_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cellular_interface_id_variable", value)

    @_builtins.property
    @pulumi.getter(name="dataProfiles")
    def data_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CellularControllerFeatureTemplateDataProfileArgs']]]]:
        """
        Data Profile List
        """
        return pulumi.get(self, "data_profiles")

    @data_profiles.setter
    def data_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CellularControllerFeatureTemplateDataProfileArgs']]]]):
        pulumi.set(self, "data_profiles", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSim")
    def firmware_auto_sim(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable/Disable Firmware Auto Sim
          - Default value: `true`
        """
        return pulumi.get(self, "firmware_auto_sim")

    @firmware_auto_sim.setter
    def firmware_auto_sim(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "firmware_auto_sim", value)

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSimVariable")
    def firmware_auto_sim_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "firmware_auto_sim_variable")

    @firmware_auto_sim_variable.setter
    def firmware_auto_sim_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firmware_auto_sim_variable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primarySimSlot")
    def primary_sim_slot(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set primary SIM slot
          - Range: `0`-`255`
        """
        return pulumi.get(self, "primary_sim_slot")

    @primary_sim_slot.setter
    def primary_sim_slot(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "primary_sim_slot", value)

    @_builtins.property
    @pulumi.getter(name="primarySimSlotVariable")
    def primary_sim_slot_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_sim_slot_variable")

    @primary_sim_slot_variable.setter
    def primary_sim_slot_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_sim_slot_variable", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverRetries")
    def sim_failover_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set SIM failover retries
          - Range: `0`-`65535`
        """
        return pulumi.get(self, "sim_failover_retries")

    @sim_failover_retries.setter
    def sim_failover_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sim_failover_retries", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverRetriesVariable")
    def sim_failover_retries_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_retries_variable")

    @sim_failover_retries_variable.setter
    def sim_failover_retries_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sim_failover_retries_variable", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeout")
    def sim_failover_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set SIM failover timeout in minutes
          - Range: `3`-`7`
        """
        return pulumi.get(self, "sim_failover_timeout")

    @sim_failover_timeout.setter
    def sim_failover_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sim_failover_timeout", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeoutVariable")
    def sim_failover_timeout_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_timeout_variable")

    @sim_failover_timeout_variable.setter
    def sim_failover_timeout_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sim_failover_timeout_variable", value)

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/cellularControllerFeatureTemplate:CellularControllerFeatureTemplate")
class CellularControllerFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cellular_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cellular_interface_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 data_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CellularControllerFeatureTemplateDataProfileArgs', 'CellularControllerFeatureTemplateDataProfileArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 firmware_auto_sim: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware_auto_sim_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_sim_slot: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_sim_slot_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_retries_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Cellular Controller feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/cellularControllerFeatureTemplate:CellularControllerFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cellular_interface_id: Cellular interface name
        :param pulumi.Input[_builtins.str] cellular_interface_id_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CellularControllerFeatureTemplateDataProfileArgs', 'CellularControllerFeatureTemplateDataProfileArgsDict']]]] data_profiles: Data Profile List
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.bool] firmware_auto_sim: Enable/Disable Firmware Auto Sim
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] firmware_auto_sim_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[_builtins.int] primary_sim_slot: Set primary SIM slot
                 - Range: `0`-`255`
        :param pulumi.Input[_builtins.str] primary_sim_slot_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_retries: Set SIM failover retries
                 - Range: `0`-`65535`
        :param pulumi.Input[_builtins.str] sim_failover_retries_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_timeout: Set SIM failover timeout in minutes
                 - Range: `3`-`7`
        :param pulumi.Input[_builtins.str] sim_failover_timeout_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CellularControllerFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cellular Controller feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/cellularControllerFeatureTemplate:CellularControllerFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CellularControllerFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CellularControllerFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cellular_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cellular_interface_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 data_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CellularControllerFeatureTemplateDataProfileArgs', 'CellularControllerFeatureTemplateDataProfileArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 firmware_auto_sim: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware_auto_sim_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_sim_slot: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_sim_slot_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_retries_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CellularControllerFeatureTemplateArgs.__new__(CellularControllerFeatureTemplateArgs)

            __props__.__dict__["cellular_interface_id"] = cellular_interface_id
            __props__.__dict__["cellular_interface_id_variable"] = cellular_interface_id_variable
            __props__.__dict__["data_profiles"] = data_profiles
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["firmware_auto_sim"] = firmware_auto_sim
            __props__.__dict__["firmware_auto_sim_variable"] = firmware_auto_sim_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["primary_sim_slot"] = primary_sim_slot
            __props__.__dict__["primary_sim_slot_variable"] = primary_sim_slot_variable
            __props__.__dict__["sim_failover_retries"] = sim_failover_retries
            __props__.__dict__["sim_failover_retries_variable"] = sim_failover_retries_variable
            __props__.__dict__["sim_failover_timeout"] = sim_failover_timeout
            __props__.__dict__["sim_failover_timeout_variable"] = sim_failover_timeout_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CellularControllerFeatureTemplate, __self__).__init__(
            'sdwan:index/cellularControllerFeatureTemplate:CellularControllerFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cellular_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            cellular_interface_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
            data_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CellularControllerFeatureTemplateDataProfileArgs', 'CellularControllerFeatureTemplateDataProfileArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            firmware_auto_sim: Optional[pulumi.Input[_builtins.bool]] = None,
            firmware_auto_sim_variable: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_sim_slot: Optional[pulumi.Input[_builtins.int]] = None,
            primary_sim_slot_variable: Optional[pulumi.Input[_builtins.str]] = None,
            sim_failover_retries: Optional[pulumi.Input[_builtins.int]] = None,
            sim_failover_retries_variable: Optional[pulumi.Input[_builtins.str]] = None,
            sim_failover_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            sim_failover_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
            template_type: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'CellularControllerFeatureTemplate':
        """
        Get an existing CellularControllerFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cellular_interface_id: Cellular interface name
        :param pulumi.Input[_builtins.str] cellular_interface_id_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CellularControllerFeatureTemplateDataProfileArgs', 'CellularControllerFeatureTemplateDataProfileArgsDict']]]] data_profiles: Data Profile List
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.bool] firmware_auto_sim: Enable/Disable Firmware Auto Sim
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] firmware_auto_sim_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[_builtins.int] primary_sim_slot: Set primary SIM slot
                 - Range: `0`-`255`
        :param pulumi.Input[_builtins.str] primary_sim_slot_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_retries: Set SIM failover retries
                 - Range: `0`-`65535`
        :param pulumi.Input[_builtins.str] sim_failover_retries_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_timeout: Set SIM failover timeout in minutes
                 - Range: `3`-`7`
        :param pulumi.Input[_builtins.str] sim_failover_timeout_variable: Variable name
        :param pulumi.Input[_builtins.str] template_type: The template type
        :param pulumi.Input[_builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CellularControllerFeatureTemplateState.__new__(_CellularControllerFeatureTemplateState)

        __props__.__dict__["cellular_interface_id"] = cellular_interface_id
        __props__.__dict__["cellular_interface_id_variable"] = cellular_interface_id_variable
        __props__.__dict__["data_profiles"] = data_profiles
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["firmware_auto_sim"] = firmware_auto_sim
        __props__.__dict__["firmware_auto_sim_variable"] = firmware_auto_sim_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_sim_slot"] = primary_sim_slot
        __props__.__dict__["primary_sim_slot_variable"] = primary_sim_slot_variable
        __props__.__dict__["sim_failover_retries"] = sim_failover_retries
        __props__.__dict__["sim_failover_retries_variable"] = sim_failover_retries_variable
        __props__.__dict__["sim_failover_timeout"] = sim_failover_timeout
        __props__.__dict__["sim_failover_timeout_variable"] = sim_failover_timeout_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return CellularControllerFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cellularInterfaceId")
    def cellular_interface_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cellular interface name
        """
        return pulumi.get(self, "cellular_interface_id")

    @_builtins.property
    @pulumi.getter(name="cellularInterfaceIdVariable")
    def cellular_interface_id_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "cellular_interface_id_variable")

    @_builtins.property
    @pulumi.getter(name="dataProfiles")
    def data_profiles(self) -> pulumi.Output[Optional[Sequence['outputs.CellularControllerFeatureTemplateDataProfile']]]:
        """
        Data Profile List
        """
        return pulumi.get(self, "data_profiles")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSim")
    def firmware_auto_sim(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable/Disable Firmware Auto Sim
          - Default value: `true`
        """
        return pulumi.get(self, "firmware_auto_sim")

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSimVariable")
    def firmware_auto_sim_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "firmware_auto_sim_variable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primarySimSlot")
    def primary_sim_slot(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set primary SIM slot
          - Range: `0`-`255`
        """
        return pulumi.get(self, "primary_sim_slot")

    @_builtins.property
    @pulumi.getter(name="primarySimSlotVariable")
    def primary_sim_slot_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_sim_slot_variable")

    @_builtins.property
    @pulumi.getter(name="simFailoverRetries")
    def sim_failover_retries(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set SIM failover retries
          - Range: `0`-`65535`
        """
        return pulumi.get(self, "sim_failover_retries")

    @_builtins.property
    @pulumi.getter(name="simFailoverRetriesVariable")
    def sim_failover_retries_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_retries_variable")

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeout")
    def sim_failover_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set SIM failover timeout in minutes
          - Range: `3`-`7`
        """
        return pulumi.get(self, "sim_failover_timeout")

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeoutVariable")
    def sim_failover_timeout_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_timeout_variable")

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[_builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

