# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCiscoBfdFeatureTemplateResult',
    'AwaitableGetCiscoBfdFeatureTemplateResult',
    'get_cisco_bfd_feature_template',
    'get_cisco_bfd_feature_template_output',
]

@pulumi.output_type
class GetCiscoBfdFeatureTemplateResult:
    """
    A collection of values returned by getCiscoBfdFeatureTemplate.
    """
    def __init__(__self__, colors=None, default_dscp=None, default_dscp_variable=None, description=None, device_types=None, id=None, multiplier=None, multiplier_variable=None, name=None, poll_interval=None, poll_interval_variable=None, template_type=None, version=None):
        if colors and not isinstance(colors, list):
            raise TypeError("Expected argument 'colors' to be a list")
        pulumi.set(__self__, "colors", colors)
        if default_dscp and not isinstance(default_dscp, int):
            raise TypeError("Expected argument 'default_dscp' to be a int")
        pulumi.set(__self__, "default_dscp", default_dscp)
        if default_dscp_variable and not isinstance(default_dscp_variable, str):
            raise TypeError("Expected argument 'default_dscp_variable' to be a str")
        pulumi.set(__self__, "default_dscp_variable", default_dscp_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if multiplier and not isinstance(multiplier, int):
            raise TypeError("Expected argument 'multiplier' to be a int")
        pulumi.set(__self__, "multiplier", multiplier)
        if multiplier_variable and not isinstance(multiplier_variable, str):
            raise TypeError("Expected argument 'multiplier_variable' to be a str")
        pulumi.set(__self__, "multiplier_variable", multiplier_variable)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if poll_interval and not isinstance(poll_interval, int):
            raise TypeError("Expected argument 'poll_interval' to be a int")
        pulumi.set(__self__, "poll_interval", poll_interval)
        if poll_interval_variable and not isinstance(poll_interval_variable, str):
            raise TypeError("Expected argument 'poll_interval_variable' to be a str")
        pulumi.set(__self__, "poll_interval_variable", poll_interval_variable)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def colors(self) -> Sequence['outputs.GetCiscoBfdFeatureTemplateColorResult']:
        """
        Set color that identifies the WAN transport tunnel
        """
        return pulumi.get(self, "colors")

    @_builtins.property
    @pulumi.getter(name="defaultDscp")
    def default_dscp(self) -> _builtins.int:
        """
        Set default DSCP value for BFD packets
        """
        return pulumi.get(self, "default_dscp")

    @_builtins.property
    @pulumi.getter(name="defaultDscpVariable")
    def default_dscp_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "default_dscp_variable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[_builtins.str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def multiplier(self) -> _builtins.int:
        """
        Set the number of polling intervals used to determine tunnel SLA class
        """
        return pulumi.get(self, "multiplier")

    @_builtins.property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> _builtins.int:
        """
        Set how often BFD polls tunnels to collect packet latency, loss, and statistics
        """
        return pulumi.get(self, "poll_interval")

    @_builtins.property
    @pulumi.getter(name="pollIntervalVariable")
    def poll_interval_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "poll_interval_variable")

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> _builtins.str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")


class AwaitableGetCiscoBfdFeatureTemplateResult(GetCiscoBfdFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCiscoBfdFeatureTemplateResult(
            colors=self.colors,
            default_dscp=self.default_dscp,
            default_dscp_variable=self.default_dscp_variable,
            description=self.description,
            device_types=self.device_types,
            id=self.id,
            multiplier=self.multiplier,
            multiplier_variable=self.multiplier_variable,
            name=self.name,
            poll_interval=self.poll_interval,
            poll_interval_variable=self.poll_interval_variable,
            template_type=self.template_type,
            version=self.version)


def get_cisco_bfd_feature_template(id: Optional[_builtins.str] = None,
                                   name: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCiscoBfdFeatureTemplateResult:
    """
    This data source can read the Cisco BFD feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_bfd_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param _builtins.str id: The id of the feature template
    :param _builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCiscoBfdFeatureTemplate:getCiscoBfdFeatureTemplate', __args__, opts=opts, typ=GetCiscoBfdFeatureTemplateResult).value

    return AwaitableGetCiscoBfdFeatureTemplateResult(
        colors=pulumi.get(__ret__, 'colors'),
        default_dscp=pulumi.get(__ret__, 'default_dscp'),
        default_dscp_variable=pulumi.get(__ret__, 'default_dscp_variable'),
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        id=pulumi.get(__ret__, 'id'),
        multiplier=pulumi.get(__ret__, 'multiplier'),
        multiplier_variable=pulumi.get(__ret__, 'multiplier_variable'),
        name=pulumi.get(__ret__, 'name'),
        poll_interval=pulumi.get(__ret__, 'poll_interval'),
        poll_interval_variable=pulumi.get(__ret__, 'poll_interval_variable'),
        template_type=pulumi.get(__ret__, 'template_type'),
        version=pulumi.get(__ret__, 'version'))
def get_cisco_bfd_feature_template_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCiscoBfdFeatureTemplateResult]:
    """
    This data source can read the Cisco BFD feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_bfd_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param _builtins.str id: The id of the feature template
    :param _builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getCiscoBfdFeatureTemplate:getCiscoBfdFeatureTemplate', __args__, opts=opts, typ=GetCiscoBfdFeatureTemplateResult)
    return __ret__.apply(lambda __response__: GetCiscoBfdFeatureTemplateResult(
        colors=pulumi.get(__response__, 'colors'),
        default_dscp=pulumi.get(__response__, 'default_dscp'),
        default_dscp_variable=pulumi.get(__response__, 'default_dscp_variable'),
        description=pulumi.get(__response__, 'description'),
        device_types=pulumi.get(__response__, 'device_types'),
        id=pulumi.get(__response__, 'id'),
        multiplier=pulumi.get(__response__, 'multiplier'),
        multiplier_variable=pulumi.get(__response__, 'multiplier_variable'),
        name=pulumi.get(__response__, 'name'),
        poll_interval=pulumi.get(__response__, 'poll_interval'),
        poll_interval_variable=pulumi.get(__response__, 'poll_interval_variable'),
        template_type=pulumi.get(__response__, 'template_type'),
        version=pulumi.get(__response__, 'version')))
