# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCiscoOspfFeatureTemplateResult',
    'AwaitableGetCiscoOspfFeatureTemplateResult',
    'get_cisco_ospf_feature_template',
    'get_cisco_ospf_feature_template_output',
]

@pulumi.output_type
class GetCiscoOspfFeatureTemplateResult:
    """
    A collection of values returned by getCiscoOspfFeatureTemplate.
    """
    def __init__(__self__, areas=None, auto_cost_reference_bandwidth=None, auto_cost_reference_bandwidth_variable=None, compatible_rfc1583=None, compatible_rfc1583_variable=None, default_information_originate=None, default_information_originate_always=None, default_information_originate_always_variable=None, default_information_originate_metric=None, default_information_originate_metric_type=None, default_information_originate_metric_type_variable=None, default_information_originate_metric_variable=None, description=None, device_types=None, distance_external=None, distance_external_variable=None, distance_inter_area=None, distance_inter_area_variable=None, distance_intra_area=None, distance_intra_area_variable=None, id=None, max_metric_router_lsas=None, name=None, redistributes=None, route_policies=None, router_id=None, router_id_variable=None, template_type=None, timers_spf_delay=None, timers_spf_delay_variable=None, timers_spf_initial_hold=None, timers_spf_initial_hold_variable=None, timers_spf_max_hold=None, timers_spf_max_hold_variable=None, version=None):
        if areas and not isinstance(areas, list):
            raise TypeError("Expected argument 'areas' to be a list")
        pulumi.set(__self__, "areas", areas)
        if auto_cost_reference_bandwidth and not isinstance(auto_cost_reference_bandwidth, int):
            raise TypeError("Expected argument 'auto_cost_reference_bandwidth' to be a int")
        pulumi.set(__self__, "auto_cost_reference_bandwidth", auto_cost_reference_bandwidth)
        if auto_cost_reference_bandwidth_variable and not isinstance(auto_cost_reference_bandwidth_variable, str):
            raise TypeError("Expected argument 'auto_cost_reference_bandwidth_variable' to be a str")
        pulumi.set(__self__, "auto_cost_reference_bandwidth_variable", auto_cost_reference_bandwidth_variable)
        if compatible_rfc1583 and not isinstance(compatible_rfc1583, bool):
            raise TypeError("Expected argument 'compatible_rfc1583' to be a bool")
        pulumi.set(__self__, "compatible_rfc1583", compatible_rfc1583)
        if compatible_rfc1583_variable and not isinstance(compatible_rfc1583_variable, str):
            raise TypeError("Expected argument 'compatible_rfc1583_variable' to be a str")
        pulumi.set(__self__, "compatible_rfc1583_variable", compatible_rfc1583_variable)
        if default_information_originate and not isinstance(default_information_originate, bool):
            raise TypeError("Expected argument 'default_information_originate' to be a bool")
        pulumi.set(__self__, "default_information_originate", default_information_originate)
        if default_information_originate_always and not isinstance(default_information_originate_always, bool):
            raise TypeError("Expected argument 'default_information_originate_always' to be a bool")
        pulumi.set(__self__, "default_information_originate_always", default_information_originate_always)
        if default_information_originate_always_variable and not isinstance(default_information_originate_always_variable, str):
            raise TypeError("Expected argument 'default_information_originate_always_variable' to be a str")
        pulumi.set(__self__, "default_information_originate_always_variable", default_information_originate_always_variable)
        if default_information_originate_metric and not isinstance(default_information_originate_metric, int):
            raise TypeError("Expected argument 'default_information_originate_metric' to be a int")
        pulumi.set(__self__, "default_information_originate_metric", default_information_originate_metric)
        if default_information_originate_metric_type and not isinstance(default_information_originate_metric_type, str):
            raise TypeError("Expected argument 'default_information_originate_metric_type' to be a str")
        pulumi.set(__self__, "default_information_originate_metric_type", default_information_originate_metric_type)
        if default_information_originate_metric_type_variable and not isinstance(default_information_originate_metric_type_variable, str):
            raise TypeError("Expected argument 'default_information_originate_metric_type_variable' to be a str")
        pulumi.set(__self__, "default_information_originate_metric_type_variable", default_information_originate_metric_type_variable)
        if default_information_originate_metric_variable and not isinstance(default_information_originate_metric_variable, str):
            raise TypeError("Expected argument 'default_information_originate_metric_variable' to be a str")
        pulumi.set(__self__, "default_information_originate_metric_variable", default_information_originate_metric_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if distance_external and not isinstance(distance_external, int):
            raise TypeError("Expected argument 'distance_external' to be a int")
        pulumi.set(__self__, "distance_external", distance_external)
        if distance_external_variable and not isinstance(distance_external_variable, str):
            raise TypeError("Expected argument 'distance_external_variable' to be a str")
        pulumi.set(__self__, "distance_external_variable", distance_external_variable)
        if distance_inter_area and not isinstance(distance_inter_area, int):
            raise TypeError("Expected argument 'distance_inter_area' to be a int")
        pulumi.set(__self__, "distance_inter_area", distance_inter_area)
        if distance_inter_area_variable and not isinstance(distance_inter_area_variable, str):
            raise TypeError("Expected argument 'distance_inter_area_variable' to be a str")
        pulumi.set(__self__, "distance_inter_area_variable", distance_inter_area_variable)
        if distance_intra_area and not isinstance(distance_intra_area, int):
            raise TypeError("Expected argument 'distance_intra_area' to be a int")
        pulumi.set(__self__, "distance_intra_area", distance_intra_area)
        if distance_intra_area_variable and not isinstance(distance_intra_area_variable, str):
            raise TypeError("Expected argument 'distance_intra_area_variable' to be a str")
        pulumi.set(__self__, "distance_intra_area_variable", distance_intra_area_variable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_metric_router_lsas and not isinstance(max_metric_router_lsas, list):
            raise TypeError("Expected argument 'max_metric_router_lsas' to be a list")
        pulumi.set(__self__, "max_metric_router_lsas", max_metric_router_lsas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if redistributes and not isinstance(redistributes, list):
            raise TypeError("Expected argument 'redistributes' to be a list")
        pulumi.set(__self__, "redistributes", redistributes)
        if route_policies and not isinstance(route_policies, list):
            raise TypeError("Expected argument 'route_policies' to be a list")
        pulumi.set(__self__, "route_policies", route_policies)
        if router_id and not isinstance(router_id, str):
            raise TypeError("Expected argument 'router_id' to be a str")
        pulumi.set(__self__, "router_id", router_id)
        if router_id_variable and not isinstance(router_id_variable, str):
            raise TypeError("Expected argument 'router_id_variable' to be a str")
        pulumi.set(__self__, "router_id_variable", router_id_variable)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if timers_spf_delay and not isinstance(timers_spf_delay, int):
            raise TypeError("Expected argument 'timers_spf_delay' to be a int")
        pulumi.set(__self__, "timers_spf_delay", timers_spf_delay)
        if timers_spf_delay_variable and not isinstance(timers_spf_delay_variable, str):
            raise TypeError("Expected argument 'timers_spf_delay_variable' to be a str")
        pulumi.set(__self__, "timers_spf_delay_variable", timers_spf_delay_variable)
        if timers_spf_initial_hold and not isinstance(timers_spf_initial_hold, int):
            raise TypeError("Expected argument 'timers_spf_initial_hold' to be a int")
        pulumi.set(__self__, "timers_spf_initial_hold", timers_spf_initial_hold)
        if timers_spf_initial_hold_variable and not isinstance(timers_spf_initial_hold_variable, str):
            raise TypeError("Expected argument 'timers_spf_initial_hold_variable' to be a str")
        pulumi.set(__self__, "timers_spf_initial_hold_variable", timers_spf_initial_hold_variable)
        if timers_spf_max_hold and not isinstance(timers_spf_max_hold, int):
            raise TypeError("Expected argument 'timers_spf_max_hold' to be a int")
        pulumi.set(__self__, "timers_spf_max_hold", timers_spf_max_hold)
        if timers_spf_max_hold_variable and not isinstance(timers_spf_max_hold_variable, str):
            raise TypeError("Expected argument 'timers_spf_max_hold_variable' to be a str")
        pulumi.set(__self__, "timers_spf_max_hold_variable", timers_spf_max_hold_variable)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def areas(self) -> Sequence['outputs.GetCiscoOspfFeatureTemplateAreaResult']:
        """
        Configure OSPF area
        """
        return pulumi.get(self, "areas")

    @_builtins.property
    @pulumi.getter(name="autoCostReferenceBandwidth")
    def auto_cost_reference_bandwidth(self) -> _builtins.int:
        """
        Set reference bandwidth method to assign OSPF cost
        """
        return pulumi.get(self, "auto_cost_reference_bandwidth")

    @_builtins.property
    @pulumi.getter(name="autoCostReferenceBandwidthVariable")
    def auto_cost_reference_bandwidth_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "auto_cost_reference_bandwidth_variable")

    @_builtins.property
    @pulumi.getter(name="compatibleRfc1583")
    def compatible_rfc1583(self) -> _builtins.bool:
        """
        Calculate summary route cost based on RFC 1583
        """
        return pulumi.get(self, "compatible_rfc1583")

    @_builtins.property
    @pulumi.getter(name="compatibleRfc1583Variable")
    def compatible_rfc1583_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "compatible_rfc1583_variable")

    @_builtins.property
    @pulumi.getter(name="defaultInformationOriginate")
    def default_information_originate(self) -> _builtins.bool:
        """
        Distribute default external route into OSPF
        """
        return pulumi.get(self, "default_information_originate")

    @_builtins.property
    @pulumi.getter(name="defaultInformationOriginateAlways")
    def default_information_originate_always(self) -> _builtins.bool:
        """
        Always advertise default route
        """
        return pulumi.get(self, "default_information_originate_always")

    @_builtins.property
    @pulumi.getter(name="defaultInformationOriginateAlwaysVariable")
    def default_information_originate_always_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_always_variable")

    @_builtins.property
    @pulumi.getter(name="defaultInformationOriginateMetric")
    def default_information_originate_metric(self) -> _builtins.int:
        """
        Set metric used to generate default route \\n\\n
        """
        return pulumi.get(self, "default_information_originate_metric")

    @_builtins.property
    @pulumi.getter(name="defaultInformationOriginateMetricType")
    def default_information_originate_metric_type(self) -> _builtins.str:
        """
        Set default route type
        """
        return pulumi.get(self, "default_information_originate_metric_type")

    @_builtins.property
    @pulumi.getter(name="defaultInformationOriginateMetricTypeVariable")
    def default_information_originate_metric_type_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_metric_type_variable")

    @_builtins.property
    @pulumi.getter(name="defaultInformationOriginateMetricVariable")
    def default_information_originate_metric_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_metric_variable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[_builtins.str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @_builtins.property
    @pulumi.getter(name="distanceExternal")
    def distance_external(self) -> _builtins.int:
        """
        Set distance for external routes
        """
        return pulumi.get(self, "distance_external")

    @_builtins.property
    @pulumi.getter(name="distanceExternalVariable")
    def distance_external_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "distance_external_variable")

    @_builtins.property
    @pulumi.getter(name="distanceInterArea")
    def distance_inter_area(self) -> _builtins.int:
        """
        Set distance for inter-area routes
        """
        return pulumi.get(self, "distance_inter_area")

    @_builtins.property
    @pulumi.getter(name="distanceInterAreaVariable")
    def distance_inter_area_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "distance_inter_area_variable")

    @_builtins.property
    @pulumi.getter(name="distanceIntraArea")
    def distance_intra_area(self) -> _builtins.int:
        """
        Set distance for intra-area routes
        """
        return pulumi.get(self, "distance_intra_area")

    @_builtins.property
    @pulumi.getter(name="distanceIntraAreaVariable")
    def distance_intra_area_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "distance_intra_area_variable")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxMetricRouterLsas")
    def max_metric_router_lsas(self) -> Sequence['outputs.GetCiscoOspfFeatureTemplateMaxMetricRouterLsaResult']:
        """
        Advertise own router LSA with infinite distance
        """
        return pulumi.get(self, "max_metric_router_lsas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def redistributes(self) -> Sequence['outputs.GetCiscoOspfFeatureTemplateRedistributeResult']:
        """
        Redistribute routes
        """
        return pulumi.get(self, "redistributes")

    @_builtins.property
    @pulumi.getter(name="routePolicies")
    def route_policies(self) -> Sequence['outputs.GetCiscoOspfFeatureTemplateRoutePolicyResult']:
        """
        Set route policy to apply
        """
        return pulumi.get(self, "route_policies")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> _builtins.str:
        """
        Set OSPF router ID to override system IP address
        """
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter(name="routerIdVariable")
    def router_id_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "router_id_variable")

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> _builtins.str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @_builtins.property
    @pulumi.getter(name="timersSpfDelay")
    def timers_spf_delay(self) -> _builtins.int:
        """
        Set delay from first change received until performing SPF calculation
        """
        return pulumi.get(self, "timers_spf_delay")

    @_builtins.property
    @pulumi.getter(name="timersSpfDelayVariable")
    def timers_spf_delay_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_delay_variable")

    @_builtins.property
    @pulumi.getter(name="timersSpfInitialHold")
    def timers_spf_initial_hold(self) -> _builtins.int:
        """
        Set initial hold time between consecutive SPF calculations
        """
        return pulumi.get(self, "timers_spf_initial_hold")

    @_builtins.property
    @pulumi.getter(name="timersSpfInitialHoldVariable")
    def timers_spf_initial_hold_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_initial_hold_variable")

    @_builtins.property
    @pulumi.getter(name="timersSpfMaxHold")
    def timers_spf_max_hold(self) -> _builtins.int:
        """
        Set maximum hold time between consecutive SPF calculations
        """
        return pulumi.get(self, "timers_spf_max_hold")

    @_builtins.property
    @pulumi.getter(name="timersSpfMaxHoldVariable")
    def timers_spf_max_hold_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_max_hold_variable")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")


class AwaitableGetCiscoOspfFeatureTemplateResult(GetCiscoOspfFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCiscoOspfFeatureTemplateResult(
            areas=self.areas,
            auto_cost_reference_bandwidth=self.auto_cost_reference_bandwidth,
            auto_cost_reference_bandwidth_variable=self.auto_cost_reference_bandwidth_variable,
            compatible_rfc1583=self.compatible_rfc1583,
            compatible_rfc1583_variable=self.compatible_rfc1583_variable,
            default_information_originate=self.default_information_originate,
            default_information_originate_always=self.default_information_originate_always,
            default_information_originate_always_variable=self.default_information_originate_always_variable,
            default_information_originate_metric=self.default_information_originate_metric,
            default_information_originate_metric_type=self.default_information_originate_metric_type,
            default_information_originate_metric_type_variable=self.default_information_originate_metric_type_variable,
            default_information_originate_metric_variable=self.default_information_originate_metric_variable,
            description=self.description,
            device_types=self.device_types,
            distance_external=self.distance_external,
            distance_external_variable=self.distance_external_variable,
            distance_inter_area=self.distance_inter_area,
            distance_inter_area_variable=self.distance_inter_area_variable,
            distance_intra_area=self.distance_intra_area,
            distance_intra_area_variable=self.distance_intra_area_variable,
            id=self.id,
            max_metric_router_lsas=self.max_metric_router_lsas,
            name=self.name,
            redistributes=self.redistributes,
            route_policies=self.route_policies,
            router_id=self.router_id,
            router_id_variable=self.router_id_variable,
            template_type=self.template_type,
            timers_spf_delay=self.timers_spf_delay,
            timers_spf_delay_variable=self.timers_spf_delay_variable,
            timers_spf_initial_hold=self.timers_spf_initial_hold,
            timers_spf_initial_hold_variable=self.timers_spf_initial_hold_variable,
            timers_spf_max_hold=self.timers_spf_max_hold,
            timers_spf_max_hold_variable=self.timers_spf_max_hold_variable,
            version=self.version)


def get_cisco_ospf_feature_template(id: Optional[_builtins.str] = None,
                                    name: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCiscoOspfFeatureTemplateResult:
    """
    This data source can read the Cisco OSPF feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_ospf_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param _builtins.str id: The id of the feature template
    :param _builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCiscoOspfFeatureTemplate:getCiscoOspfFeatureTemplate', __args__, opts=opts, typ=GetCiscoOspfFeatureTemplateResult).value

    return AwaitableGetCiscoOspfFeatureTemplateResult(
        areas=pulumi.get(__ret__, 'areas'),
        auto_cost_reference_bandwidth=pulumi.get(__ret__, 'auto_cost_reference_bandwidth'),
        auto_cost_reference_bandwidth_variable=pulumi.get(__ret__, 'auto_cost_reference_bandwidth_variable'),
        compatible_rfc1583=pulumi.get(__ret__, 'compatible_rfc1583'),
        compatible_rfc1583_variable=pulumi.get(__ret__, 'compatible_rfc1583_variable'),
        default_information_originate=pulumi.get(__ret__, 'default_information_originate'),
        default_information_originate_always=pulumi.get(__ret__, 'default_information_originate_always'),
        default_information_originate_always_variable=pulumi.get(__ret__, 'default_information_originate_always_variable'),
        default_information_originate_metric=pulumi.get(__ret__, 'default_information_originate_metric'),
        default_information_originate_metric_type=pulumi.get(__ret__, 'default_information_originate_metric_type'),
        default_information_originate_metric_type_variable=pulumi.get(__ret__, 'default_information_originate_metric_type_variable'),
        default_information_originate_metric_variable=pulumi.get(__ret__, 'default_information_originate_metric_variable'),
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        distance_external=pulumi.get(__ret__, 'distance_external'),
        distance_external_variable=pulumi.get(__ret__, 'distance_external_variable'),
        distance_inter_area=pulumi.get(__ret__, 'distance_inter_area'),
        distance_inter_area_variable=pulumi.get(__ret__, 'distance_inter_area_variable'),
        distance_intra_area=pulumi.get(__ret__, 'distance_intra_area'),
        distance_intra_area_variable=pulumi.get(__ret__, 'distance_intra_area_variable'),
        id=pulumi.get(__ret__, 'id'),
        max_metric_router_lsas=pulumi.get(__ret__, 'max_metric_router_lsas'),
        name=pulumi.get(__ret__, 'name'),
        redistributes=pulumi.get(__ret__, 'redistributes'),
        route_policies=pulumi.get(__ret__, 'route_policies'),
        router_id=pulumi.get(__ret__, 'router_id'),
        router_id_variable=pulumi.get(__ret__, 'router_id_variable'),
        template_type=pulumi.get(__ret__, 'template_type'),
        timers_spf_delay=pulumi.get(__ret__, 'timers_spf_delay'),
        timers_spf_delay_variable=pulumi.get(__ret__, 'timers_spf_delay_variable'),
        timers_spf_initial_hold=pulumi.get(__ret__, 'timers_spf_initial_hold'),
        timers_spf_initial_hold_variable=pulumi.get(__ret__, 'timers_spf_initial_hold_variable'),
        timers_spf_max_hold=pulumi.get(__ret__, 'timers_spf_max_hold'),
        timers_spf_max_hold_variable=pulumi.get(__ret__, 'timers_spf_max_hold_variable'),
        version=pulumi.get(__ret__, 'version'))
def get_cisco_ospf_feature_template_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCiscoOspfFeatureTemplateResult]:
    """
    This data source can read the Cisco OSPF feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_ospf_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param _builtins.str id: The id of the feature template
    :param _builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getCiscoOspfFeatureTemplate:getCiscoOspfFeatureTemplate', __args__, opts=opts, typ=GetCiscoOspfFeatureTemplateResult)
    return __ret__.apply(lambda __response__: GetCiscoOspfFeatureTemplateResult(
        areas=pulumi.get(__response__, 'areas'),
        auto_cost_reference_bandwidth=pulumi.get(__response__, 'auto_cost_reference_bandwidth'),
        auto_cost_reference_bandwidth_variable=pulumi.get(__response__, 'auto_cost_reference_bandwidth_variable'),
        compatible_rfc1583=pulumi.get(__response__, 'compatible_rfc1583'),
        compatible_rfc1583_variable=pulumi.get(__response__, 'compatible_rfc1583_variable'),
        default_information_originate=pulumi.get(__response__, 'default_information_originate'),
        default_information_originate_always=pulumi.get(__response__, 'default_information_originate_always'),
        default_information_originate_always_variable=pulumi.get(__response__, 'default_information_originate_always_variable'),
        default_information_originate_metric=pulumi.get(__response__, 'default_information_originate_metric'),
        default_information_originate_metric_type=pulumi.get(__response__, 'default_information_originate_metric_type'),
        default_information_originate_metric_type_variable=pulumi.get(__response__, 'default_information_originate_metric_type_variable'),
        default_information_originate_metric_variable=pulumi.get(__response__, 'default_information_originate_metric_variable'),
        description=pulumi.get(__response__, 'description'),
        device_types=pulumi.get(__response__, 'device_types'),
        distance_external=pulumi.get(__response__, 'distance_external'),
        distance_external_variable=pulumi.get(__response__, 'distance_external_variable'),
        distance_inter_area=pulumi.get(__response__, 'distance_inter_area'),
        distance_inter_area_variable=pulumi.get(__response__, 'distance_inter_area_variable'),
        distance_intra_area=pulumi.get(__response__, 'distance_intra_area'),
        distance_intra_area_variable=pulumi.get(__response__, 'distance_intra_area_variable'),
        id=pulumi.get(__response__, 'id'),
        max_metric_router_lsas=pulumi.get(__response__, 'max_metric_router_lsas'),
        name=pulumi.get(__response__, 'name'),
        redistributes=pulumi.get(__response__, 'redistributes'),
        route_policies=pulumi.get(__response__, 'route_policies'),
        router_id=pulumi.get(__response__, 'router_id'),
        router_id_variable=pulumi.get(__response__, 'router_id_variable'),
        template_type=pulumi.get(__response__, 'template_type'),
        timers_spf_delay=pulumi.get(__response__, 'timers_spf_delay'),
        timers_spf_delay_variable=pulumi.get(__response__, 'timers_spf_delay_variable'),
        timers_spf_initial_hold=pulumi.get(__response__, 'timers_spf_initial_hold'),
        timers_spf_initial_hold_variable=pulumi.get(__response__, 'timers_spf_initial_hold_variable'),
        timers_spf_max_hold=pulumi.get(__response__, 'timers_spf_max_hold'),
        timers_spf_max_hold_variable=pulumi.get(__response__, 'timers_spf_max_hold_variable'),
        version=pulumi.get(__response__, 'version')))
