# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDnsSecurityPolicyResult',
    'AwaitableGetDnsSecurityPolicyResult',
    'get_dns_security_policy',
    'get_dns_security_policy_output',
]

@pulumi.output_type
class GetDnsSecurityPolicyResult:
    """
    A collection of values returned by getDnsSecurityPolicy.
    """
    def __init__(__self__, child_org_id=None, description=None, dns_crypt=None, dns_server_ip=None, feature_profile_id=None, id=None, local_domain_bypass_enabled=None, local_domain_bypass_list_id=None, match_all_vpn=None, name=None, target_vpns=None, umbrella_default=None, version=None):
        if child_org_id and not isinstance(child_org_id, str):
            raise TypeError("Expected argument 'child_org_id' to be a str")
        pulumi.set(__self__, "child_org_id", child_org_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dns_crypt and not isinstance(dns_crypt, bool):
            raise TypeError("Expected argument 'dns_crypt' to be a bool")
        pulumi.set(__self__, "dns_crypt", dns_crypt)
        if dns_server_ip and not isinstance(dns_server_ip, str):
            raise TypeError("Expected argument 'dns_server_ip' to be a str")
        pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        if feature_profile_id and not isinstance(feature_profile_id, str):
            raise TypeError("Expected argument 'feature_profile_id' to be a str")
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_domain_bypass_enabled and not isinstance(local_domain_bypass_enabled, bool):
            raise TypeError("Expected argument 'local_domain_bypass_enabled' to be a bool")
        pulumi.set(__self__, "local_domain_bypass_enabled", local_domain_bypass_enabled)
        if local_domain_bypass_list_id and not isinstance(local_domain_bypass_list_id, str):
            raise TypeError("Expected argument 'local_domain_bypass_list_id' to be a str")
        pulumi.set(__self__, "local_domain_bypass_list_id", local_domain_bypass_list_id)
        if match_all_vpn and not isinstance(match_all_vpn, bool):
            raise TypeError("Expected argument 'match_all_vpn' to be a bool")
        pulumi.set(__self__, "match_all_vpn", match_all_vpn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if target_vpns and not isinstance(target_vpns, list):
            raise TypeError("Expected argument 'target_vpns' to be a list")
        pulumi.set(__self__, "target_vpns", target_vpns)
        if umbrella_default and not isinstance(umbrella_default, bool):
            raise TypeError("Expected argument 'umbrella_default' to be a bool")
        pulumi.set(__self__, "umbrella_default", umbrella_default)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="childOrgId")
    def child_org_id(self) -> _builtins.str:
        """
        String that is a number that corresponds to Umbrella Multi Org, can be empty if not using Umbrella Multi Org
        """
        return pulumi.get(self, "child_org_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Policy
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsCrypt")
    def dns_crypt(self) -> _builtins.bool:
        """
        If matchAllVpn is false, this field is only true if at least one of the targetVpns entires contains an umbrellaDefault true
        """
        return pulumi.get(self, "dns_crypt")

    @_builtins.property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> _builtins.str:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        """
        return pulumi.get(self, "dns_server_ip")

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> _builtins.str:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Policy
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localDomainBypassEnabled")
    def local_domain_bypass_enabled(self) -> _builtins.bool:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        """
        return pulumi.get(self, "local_domain_bypass_enabled")

    @_builtins.property
    @pulumi.getter(name="localDomainBypassListId")
    def local_domain_bypass_list_id(self) -> _builtins.str:
        return pulumi.get(self, "local_domain_bypass_list_id")

    @_builtins.property
    @pulumi.getter(name="matchAllVpn")
    def match_all_vpn(self) -> _builtins.bool:
        """
        If this is true, there shouldn't be a targetVpns field, if false then targetVpns field should be there
        """
        return pulumi.get(self, "match_all_vpn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Policy
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> Sequence['outputs.GetDnsSecurityPolicyTargetVpnResult']:
        """
        Will be under data field only if matchAllVpn is false, if matchAllVpn is true field should not be in payload
        """
        return pulumi.get(self, "target_vpns")

    @_builtins.property
    @pulumi.getter(name="umbrellaDefault")
    def umbrella_default(self) -> _builtins.bool:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        """
        return pulumi.get(self, "umbrella_default")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The version of the Policy
        """
        return pulumi.get(self, "version")


class AwaitableGetDnsSecurityPolicyResult(GetDnsSecurityPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsSecurityPolicyResult(
            child_org_id=self.child_org_id,
            description=self.description,
            dns_crypt=self.dns_crypt,
            dns_server_ip=self.dns_server_ip,
            feature_profile_id=self.feature_profile_id,
            id=self.id,
            local_domain_bypass_enabled=self.local_domain_bypass_enabled,
            local_domain_bypass_list_id=self.local_domain_bypass_list_id,
            match_all_vpn=self.match_all_vpn,
            name=self.name,
            target_vpns=self.target_vpns,
            umbrella_default=self.umbrella_default,
            version=self.version)


def get_dns_security_policy(feature_profile_id: Optional[_builtins.str] = None,
                            id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsSecurityPolicyResult:
    """
    This data source can read the DNS Security Policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_dns_security_policy(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param _builtins.str feature_profile_id: Feature Profile ID
    :param _builtins.str id: The id of the Policy
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getDnsSecurityPolicy:getDnsSecurityPolicy', __args__, opts=opts, typ=GetDnsSecurityPolicyResult).value

    return AwaitableGetDnsSecurityPolicyResult(
        child_org_id=pulumi.get(__ret__, 'child_org_id'),
        description=pulumi.get(__ret__, 'description'),
        dns_crypt=pulumi.get(__ret__, 'dns_crypt'),
        dns_server_ip=pulumi.get(__ret__, 'dns_server_ip'),
        feature_profile_id=pulumi.get(__ret__, 'feature_profile_id'),
        id=pulumi.get(__ret__, 'id'),
        local_domain_bypass_enabled=pulumi.get(__ret__, 'local_domain_bypass_enabled'),
        local_domain_bypass_list_id=pulumi.get(__ret__, 'local_domain_bypass_list_id'),
        match_all_vpn=pulumi.get(__ret__, 'match_all_vpn'),
        name=pulumi.get(__ret__, 'name'),
        target_vpns=pulumi.get(__ret__, 'target_vpns'),
        umbrella_default=pulumi.get(__ret__, 'umbrella_default'),
        version=pulumi.get(__ret__, 'version'))
def get_dns_security_policy_output(feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsSecurityPolicyResult]:
    """
    This data source can read the DNS Security Policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_dns_security_policy(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param _builtins.str feature_profile_id: Feature Profile ID
    :param _builtins.str id: The id of the Policy
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getDnsSecurityPolicy:getDnsSecurityPolicy', __args__, opts=opts, typ=GetDnsSecurityPolicyResult)
    return __ret__.apply(lambda __response__: GetDnsSecurityPolicyResult(
        child_org_id=pulumi.get(__response__, 'child_org_id'),
        description=pulumi.get(__response__, 'description'),
        dns_crypt=pulumi.get(__response__, 'dns_crypt'),
        dns_server_ip=pulumi.get(__response__, 'dns_server_ip'),
        feature_profile_id=pulumi.get(__response__, 'feature_profile_id'),
        id=pulumi.get(__response__, 'id'),
        local_domain_bypass_enabled=pulumi.get(__response__, 'local_domain_bypass_enabled'),
        local_domain_bypass_list_id=pulumi.get(__response__, 'local_domain_bypass_list_id'),
        match_all_vpn=pulumi.get(__response__, 'match_all_vpn'),
        name=pulumi.get(__response__, 'name'),
        target_vpns=pulumi.get(__response__, 'target_vpns'),
        umbrella_default=pulumi.get(__response__, 'umbrella_default'),
        version=pulumi.get(__response__, 'version')))
