# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/dashboard/lookerConnection.json
#   timestamp: 2022-07-27T11:44:16+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class LookerType(Enum):
    Looker = 'Looker'


class LookerConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[LookerType] = Field(
        LookerType.Looker, description='Service Type', title='Service Type'
    )
    username: str = Field(
        ...,
        description='Username to connect to Looker. This user should have privileges to read all the metadata in Looker.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='Password to connect to Looker.', title='Password'
    )
    hostPort: AnyUrl = Field(
        ..., description='URL to the Looker instance.', title='Host and Port'
    )
    env: Optional[str] = Field(
        None, description='Looker Environment', title='Looker Environment'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
