(function(){"use strict";suite("rb/admin/views/relatedGroupSelectorView",function(){describe("Rendering",function(){it("when empty",function(){let view=new RB.RelatedGroupSelectorView({$input:$('<input id="id_groups" type="hidden">'),initialOptions:[],multivalued:true,inviteOnly:false});expect(view.options.multivalued).toBe(true);expect(view.options.inviteOnly).toBe(false);view.render();expect(view.$el.find(".related-object-selected li").length).toBe(0)})});describe("Rendering",function(){it("with inital options",function(){let view=new RB.RelatedGroupSelectorView({$input:$('<input id="id_groups" type="hidden">'),initialOptions:[{id:1,display_name:"Test Repository 1",name:"test_repo_1",invite_only:false},{id:2,display_name:"Test Repository 2",name:"test_repo_2",invite_only:true}],multivalued:true,inviteOnly:true});view.render();expect(view.options.multivalued).toBe(true);expect(view.options.inviteOnly).toBe(true);expect(view.$el.find(".related-object-selected li").length).toBe(2);expect(view.$el.siblings("#id_groups").val()).toBe("");expect(view._selectedIDs.size).toBe(2)})});describe("Select item",function(){let view;beforeEach(function(done){$testsScratch.append('<input id="id_groups" type="hidden">');view=new RB.RelatedGroupSelectorView({$input:$("#id_groups"),initialOptions:[],multivalued:true});view.render();spyOn(view,"loadOptions").and.callFake(function(query,callback){callback([{id:1,display_name:"Test Repository 1",name:"test_repo_1",invite_only:false},{id:2,display_name:"Test Repository 2",name:"test_repo_2",invite_only:true}])});$("select")[0].selectize.focus();setTimeout(function(){$testsScratch.find("div .selectize-input.items.not-full input").click();done()},4e3)});it("from dropdown",function(done){expect(view.loadOptions).toHaveBeenCalled();$("div[data-value='test_repo_1']").click();$("div[data-value='test_repo_2']").click();expect(view.$el.siblings("#id_groups").val()).toBe("1,2");done()})})});"use strict";suite("rb/admin/views/relatedRepoSelectorView",function(){describe("Rendering",function(){it("when empty",function(){let view=new RB.RelatedRepoSelectorView({$input:$('<input id="id_repos" type="hidden">'),initialOptions:[],multivalued:true});expect(view.options.multivalued).toBe(true);view.render();expect(view.$el.find(".related-object-selected li").length).toBe(0)})});describe("Rendering",function(){it("with inital options",function(){let view=new RB.RelatedRepoSelectorView({$input:$('<input id="id_repos" type="hidden">'),initialOptions:[{id:1,name:"Test Repository 1"},{id:2,name:"Test Repository 2"}],multivalued:true});view.render();expect(view.options.multivalued).toBe(true);expect(view.$el.find(".related-object-selected li").length).toBe(2);expect(view.$el.siblings("#id_repos").val()).toBe("");expect(view._selectedIDs.size).toBe(2)})});describe("Select item",function(){let view;beforeEach(function(done){$testsScratch.append('<input id="id_repos" type="hidden">');view=new RB.RelatedRepoSelectorView({$input:$("#id_repos"),initialOptions:[],multivalued:true});view.render();spyOn(view,"loadOptions").and.callFake(function(query,callback){callback([{id:1,name:"Test Repository 1"},{id:2,name:"Test Repository 2"}])});$("select")[0].selectize.focus();setTimeout(function(){$testsScratch.find("div .selectize-input.items.not-full input").click();done()},4e3)});it("from dropdown",function(done){expect(view.loadOptions).toHaveBeenCalled();$("div[data-value='Test Repository 1']").click();$("div[data-value='Test Repository 2']").click();expect(view.$el.siblings("#id_repos").val()).toBe("1,2");done()})})});"use strict";suite("rb/admin/views/relatedUserSelectorView",function(){describe("Rendering",function(){it("when empty",function(){let view=new RB.RelatedUserSelectorView({$input:$('<input id="id_people" type="hidden">'),initialOptions:[],useAvatars:true,multivalued:true});expect(view.options.useAvatars).toBe(true);expect(view.options.multivalued).toBe(true);view.render();expect(view.$el.find(".related-object-selected li").length).toBe(0)})});describe("Rendering",function(){it("with inital options",function(){let view=new RB.RelatedUserSelectorView({$input:$('<input id="id_people" type="hidden">'),initialOptions:[{username:"admin",fullname:"Admin User",id:1,avatarHTML:{20:'<div class="avatar" alt="Admin User"></div>'}},{username:"doc",fullname:"Doc Dwarf",id:2,avatarHTML:{20:'<div class="avatar" alt="Doc Dwarf"></div>'}},{username:"dopey",fullname:"Dopey Dwarf",id:3,avatarHTML:{20:'<div class="avatar" alt="Dopey Dwarf"></div>'}}],useAvatars:true,multivalued:true});view.render();expect(view.options.useAvatars).toBe(true);expect(view.options.multivalued).toBe(true);expect(view.$el.find(".related-object-selected li").length).toBe(3);expect(view.$el.siblings("#id_people").val()).toBe("");expect(view._selectedIDs.size).toBe(3)})});describe("Select item",function(){let view;beforeEach(function(done){$testsScratch.append('<input id="id_people" type="hidden">');view=new RB.RelatedUserSelectorView({$input:$("#id_people"),initialOptions:[],useAvatars:true,multivalued:true});view.render();spyOn(view,"loadOptions").and.callFake(function(query,callback){callback([{avatarHTML:{20:'<div class="avatar" alt="Admin User"></div>'},fullname:"Admin User",id:1,username:"admin"},{avatarHTML:{20:'<div class="avatar" alt="Doc Dwarf"></div>'},fullname:"Doc Dwarf",id:2,username:"doc"}])});$("select")[0].selectize.focus();setTimeout(function(){$testsScratch.find("div .selectize-input.items.not-full input").click();done()},4e3)});it("from dropdown",function(done){expect(view.loadOptions).toHaveBeenCalled();$("div[data-value='admin']").click();$("div[data-value='doc']").click();expect(view.$el.siblings("#id_people").val()).toBe("1,2");done()})})});"use strict";suite("rb/admin/models/DashboardPage",function(){let page;beforeEach(function(){page=new RB.Admin.DashboardPage});describe("Widgets",function(){it("Loading",function(){page.set("widgetsData",[{id:"widget-1",domID:"widget-1",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget",modelAttrs:{myAttr:1},viewOptions:{myOption:true}},{id:"widget-2",domID:"widget-2",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget",modelAttrs:{myAttr:2},viewOptions:{myOption:false}}]);const onWidgetLoaded=jasmine.createSpy();page.loadWidgets(onWidgetLoaded);expect(page.widgets.length).toBe(2);const model1=page.widgets.at(0);const model2=page.widgets.at(1);expect(model1).toBeInstanceOf(RB.Admin.Widget);expect(model1.get("myAttr")).toBe(1);expect(model2).toBeInstanceOf(RB.Admin.Widget);expect(model2.get("myAttr")).toBe(2);expect(onWidgetLoaded).toHaveBeenCalledTimes(2);expect(onWidgetLoaded).toHaveBeenCalledWith({domID:"widget-1",ViewType:RB.Admin.WidgetView,viewOptions:{myOption:true},widgetModel:model1});expect(onWidgetLoaded).toHaveBeenCalledWith({domID:"widget-2",ViewType:RB.Admin.WidgetView,viewOptions:{myOption:false},widgetModel:model2})});it("Loading errors sandboxed",function(){spyOn(console,"error");page.set("widgetsData",[{id:"widget-1",domID:"widget-1",viewClass:"BadViewClass",modelClass:"BadModelClass"},{id:"widget-2",domID:"widget-2",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget",modelAttrs:{myAttr:2},viewOptions:{myOption:false}}]);const onWidgetLoaded=jasmine.createSpy();page.loadWidgets(onWidgetLoaded);expect(page.widgets.length).toBe(1);const model1=page.widgets.at(0);expect(model1).toBeInstanceOf(RB.Admin.Widget);expect(onWidgetLoaded).toHaveBeenCalledTimes(1);expect(onWidgetLoaded).toHaveBeenCalledWith({domID:"widget-2",ViewType:RB.Admin.WidgetView,viewOptions:{myOption:false},widgetModel:model1});expect(console.error).toHaveBeenCalled();const args=console.error.calls.argsFor(0);expect(args[0]).toBe('Unable to render administration widget "%s": %s');expect(args[1]).toBe("widget-1")})})});"use strict";suite("rb/admin/models/InlineFormGroup",function(){let model;beforeEach(function(){model=new RB.Admin.InlineFormGroup});describe("Methods",function(){describe("canAddInline",function(){it("With no limit",function(){model.set("maxInlines",null);expect(model.canAddInline()).toBeTrue()});it("With limit not reached",function(){model.set("maxInlines",2);model.inlines.add({});expect(model.canAddInline()).toBeTrue()});it("With limit reached",function(){model.set("maxInlines",2);model.inlines.add([{},{}]);expect(model.canAddInline()).toBeFalse()})})})});"use strict";suite("rb/admin/models/NewsWidget",function(){let model;beforeEach(function(){model=new RB.Admin.NewsWidget({rssURL:"http://example.com/news/rss"})});describe("Methods",function(){describe("loadNews",function(){it("Success",function(){function _loadNews(url,options){expect(url).toBe("http://example.com/news/rss");const payload=`<?xml version="1.0" encoding="utf-8"?>

<rss xmlns:atom="http://www.w3.org/2005/Atom"
     version="2.0">
 <channel>
  <title>Channel Name</title>
  <link>http://example.com/news/</link>
  <description>Channel description...</description>
  <atom:link href="http://example.com/news/rss"
             rel="self"></atom:link>
  <language>en-us</language>
  <lastBuildDate>Sun, 20 Oct 2019 17:26:32 -0700</lastBuildDate>
  <item>
   <title>Headline 6</title>
   <pubDate>Sun, 20 Oct 2019 17:26:32 -0700</pubDate>
   <link>http://example.com/news/post6</link>
   <description>Brief summary of 6</description>
   <author>user1@example.com</author>
   <guid>http://example.com/news/post6</guid>
  </item>
  <item>
   <title>Headline 5</title>
   <pubDate>Tue, 01 Oct 2019 13:29:00 -0700</pubDate>
   <link>http://example.com/news/post5</link>
   <description>Brief summary of 5</description>
   <author>user2@example.com</author>
   <guid>http://example.com/news/post5</guid>
  </item>
  <item>
   <title>Headline 4</title>
   <pubDate>Thu, 26 Sep 2019 19:29:33 -0700</pubDate>
   <link>http://example.com/news/post4</link>
   <description>Brief summary of 4</description>
   <author>user1@example.com</author>
   <guid>http://example.com/news/post4</guid>
  </item>
  <item>
   <title>Headline 3</title>
   <pubDate>Sun, 08 Sep 2019 11:27:05 -0700</pubDate>
   <link>http://example.com/news/post3</link>
   <description>Brief summary of 3</description>
   <author>user2@example.com</author>
   <guid>http://example.com/news/post3</guid>
  </item>
  <item>
   <title>Headline 2</title>
   <pubDate>Fri, 30 Aug 2019 23:15:01 -0700</pubDate>
   <link>http://example.com/news/post2</link>
   <description>Brief summary of 2</description>
   <author>user1@example.com</author>
   <guid>http://example.com/news/post2</guid>
  </item>
  <item>
   <title>Headline 1</title>
   <pubDate>Thu, 29 Aug 2019 14:30:00 -0700</pubDate>
   <link>http://example.com/news/post1</link>
   <description>Brief summary of 1</description>
   <author>user2@example.com</author>
   <guid>http://example.com/news/post1</guid>
  </item>
 </channel>
</rss>`;const parser=new DOMParser;options.success(parser.parseFromString(payload,"application/xml"))}const loadingNewsEventHandler=jasmine.createSpy();spyOn($,"ajax").and.callFake(_loadNews);model.on("loadingNews",loadingNewsEventHandler);model.loadNews();expect(loadingNewsEventHandler).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();const newsItems=model.get("newsItems");expect(newsItems.length).toBe(5);let newsItem=newsItems[0];expect(newsItem.date.isSame(Date.UTC(2019,9,21,0,26,32))).toBeTrue();expect(newsItem.title).toBe("Headline 6");expect(newsItem.url).toBe("http://example.com/news/post6");newsItem=newsItems[1];expect(newsItem.date.isSame(Date.UTC(2019,9,1,20,29,0))).toBeTrue();expect(newsItem.title).toBe("Headline 5");expect(newsItem.url).toBe("http://example.com/news/post5");newsItem=newsItems[2];expect(newsItem.date.isSame(Date.UTC(2019,8,27,2,29,33))).toBeTrue();expect(newsItem.title).toBe("Headline 4");expect(newsItem.url).toBe("http://example.com/news/post4");newsItem=newsItems[3];expect(newsItem.date.isSame(Date.UTC(2019,8,8,18,27,5))).toBeTrue();expect(newsItem.title).toBe("Headline 3");expect(newsItem.url).toBe("http://example.com/news/post3");newsItem=newsItems[4];expect(newsItem.date.isSame(Date.UTC(2019,7,31,6,15,1))).toBeTrue();expect(newsItem.title).toBe("Headline 2");expect(newsItem.url).toBe("http://example.com/news/post2")});it("Error loading feed",function(){function _loadNews(url,options){expect(url).toBe("http://example.com/news/rss");options.error()}const loadingNewsEventHandler=jasmine.createSpy();spyOn($,"ajax").and.callFake(_loadNews);model.on("loadingNews",loadingNewsEventHandler);model.loadNews();expect(loadingNewsEventHandler).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();const newsItems=model.get("newsItems");expect(newsItems.length).toBe(0)})})})});"use strict";suite("rb/admin/views/DashboardPageView",function(){const pageTemplate=`<div>
 <div id="admin-dashboard" style="visibility: hidden">
  <div class="rb-c-admin-widgets">
   <div class="rb-c-admin-widgets__sizer-gutter"></div>
   <div class="rb-c-admin-widgets__sizer-column"></div>
   <div class="rb-c-admin-widgets__main"></div>
  </div>
 </div>
</div>`;const widgetTemplate=_.template(`<div class="rb-c-admin-widget <%- cssClasses %>" id="<%- domID %>"
 <header class="rb-c-admin-widget__header">
  <h1><%- name %></h1>
  <ul class="rb-c-admin-widget__actions"></ul>
 </header>
 <div class="rb-c-admin-widget__content"></div>
 <footer class="rb-c-admin-widget__footer">
  <ul class="rb-c-admin-widget__actions"></ul>
 </footer>
</div>`);let page;let pageView;beforeEach(function(){page=new RB.Admin.DashboardPage;pageView=new RB.Admin.DashboardPageView({el:$(pageTemplate).appendTo($testsScratch),model:page})});describe("Widgets",function(){it("Loading",function(){const $main=pageView.$(".rb-c-admin-widgets__main");$main.append(widgetTemplate({domID:"widget-1",name:"Widget 1",cssClasses:"-is-small"}),widgetTemplate({domID:"widget-2",name:"Widget 2",cssClasses:""}),widgetTemplate({domID:"widget-3",name:"Widget 3",cssClasses:"-is-large"}),widgetTemplate({domID:"widget-4",name:"Widget 4",cssClasses:"-is-small"}),widgetTemplate({domID:"widget-5",name:"Widget 5",cssClasses:""}),widgetTemplate({domID:"widget-6",name:"Widget 6",cssClasses:"-is-full-size"}));page.set("widgetsData",[{id:"widget-1",domID:"widget-1",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"},{id:"widget-2",domID:"widget-2",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"},{id:"widget-3",domID:"widget-3",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"},{id:"widget-4",domID:"widget-4",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"},{id:"widget-5",domID:"widget-5",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"},{id:"widget-6",domID:"widget-6",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"}]);pageView.render();const $widgets=pageView._$widgets;expect($widgets.length).toBe(6);expect($widgets[0].id).toBe("widget-1");expect($widgets[1].id).toBe("widget-2");expect($widgets[2].id).toBe("widget-3");expect($widgets[3].id).toBe("widget-4");expect($widgets[4].id).toBe("widget-5");expect($widgets[5].id).toBe("widget-6");expect($widgets[0]).toHaveClass("js-masonry-item");expect($widgets[1]).toHaveClass("js-masonry-item");expect($widgets[2]).toHaveClass("js-masonry-item");expect($widgets[3]).toHaveClass("js-masonry-item");expect($widgets[4]).toHaveClass("js-masonry-item");expect($widgets[5]).toHaveClass("js-masonry-item");const items=pageView._masonry.items;expect(items.length).toBe(6);expect(items[0].element).toBe($widgets[5]);expect(items[1].element).toBe($widgets[2]);expect(items[2].element).toBe($widgets[1]);expect(items[3].element).toBe($widgets[4]);expect(items[4].element).toBe($widgets[0]);expect(items[5].element).toBe($widgets[3]);expect(pageView.$el.css("visibility")).toBe("visible")});describe("sizeChanged event",function(){let widgetView;beforeEach(function(){const $main=pageView.$(".rb-c-admin-widgets__main");$main.append(widgetTemplate({domID:"widget-1",name:"Widget 1",cssClasses:""}));page.set("widgetsData",[{id:"widget-1",domID:"widget-1",viewClass:"RB.Admin.WidgetView",modelClass:"RB.Admin.Widget"}]);pageView.render();widgetView=pageView._widgetViews["widget-1"];expect(widgetView).not.toBeUndefined();spyOn(pageView._masonry,"layout")});it("Causes re-layout on element size change",function(){const $widget=widgetView.$el;$widget.width($widget.width()+100);widgetView.trigger("sizeChanged");expect(pageView._masonry.layout).toHaveBeenCalled()});it("Ignored when element size does not change",function(){pageView._widgetWidths["widget-1"]=widgetView.$el.width();widgetView.trigger("sizeChanged");expect(pageView._masonry.layout).not.toHaveBeenCalled()})})})});"use strict";suite("rb/admin/views/NewsWidgetView",function(){const template=`<div class="rb-c-admin-widget rb-c-news-admin-widget">
 <header class="rb-c-admin-widget__header">
  <ul class="rb-c-admin-widget__actions"></ul>
 </header>
 <div class="rb-c-admin-widget__content"></div>
 <footer class="rb-c-admin-widget__footer">
  <ul class="rb-c-admin-widget__actions"></ul>
 </footer>
</div>`;let model;let view;beforeEach(function(){model=new RB.Admin.NewsWidget({newsURL:"http://example.com/news/"});view=new RB.Admin.NewsWidgetView({el:$(template),model:model});spyOn(model,"loadNews")});describe("Rendering",function(){describe("Actions",function(){it("More News",function(){view.render();const $actions=view.$footerActions.children();expect($actions.length).toBe(1);const $action=$actions.eq(0);expect($action.hasClass("js-action-more-news")).toBeTrue();expect($action.children("a").attr("href")).toBe("http://example.com/news/")});it("Subscribe",function(){model.set("subscribeURL","http://example.com/news/subscribe/");view.render();const $actions=view.$footerActions.children();expect($actions.length).toBe(2);const $action=$actions.eq(1);expect($action.hasClass("js-action-subscribe")).toBeTrue();expect($action.children("a").attr("href")).toBe("http://example.com/news/subscribe/")});describe("Reload",function(){it("On loadingNews event",function(){view.render();const $action=view.$headerActions.children(".js-action-reload");expect($action.hasClass("fa-spin")).toBeFalse();model.trigger("loadingNews");expect($action.hasClass("fa-spin")).toBeTrue()});it("On change:newsItems event",function(){view.render();const $action=view.$headerActions.children(".js-action-reload");view.setReloading(true);expect($action.hasClass("fa-spin")).toBeTrue();model.set("newsItems",[]);expect($action.hasClass("fa-spin")).toBeFalse()})})});it("News items",function(){view.render();model.set("newsItems",[{date:moment(Date.UTC(2019,9,21,0,26,32)),title:"Headline 6",url:"http://example.com/news/post6"},{date:moment(Date.UTC(2019,9,1,20,29,0)),title:"Headline 5",url:"http://example.com/news/post5"},{date:moment(Date.UTC(2019,8,27,2,29,33)),title:"Headline 4",url:"http://example.com/news/post4"}]);const $items=view.$content.children();expect($items.length).toBe(3);let $item=$items.eq(0);expect($item.attr("href")).toBe("http://example.com/news/post6");expect($item.find(".rb-c-admin-news-widget__item-date").text().strip()).toBe("Oct 20");expect($item.find(".rb-c-admin-news-widget__item-title").text().strip()).toBe("Headline 6");$item=$items.eq(1);expect($item.attr("href")).toBe("http://example.com/news/post5");expect($item.find(".rb-c-admin-news-widget__item-date").text().strip()).toBe("Oct 01");expect($item.find(".rb-c-admin-news-widget__item-title").text().strip()).toBe("Headline 5");$item=$items.eq(2);expect($item.attr("href")).toBe("http://example.com/news/post4");expect($item.find(".rb-c-admin-news-widget__item-date").text().strip()).toBe("Sep 26");expect($item.find(".rb-c-admin-news-widget__item-title").text().strip()).toBe("Headline 4")});it("Load errors",function(){view.render();model.set("newsItems",[]);const $els=view.$content.children();expect($els.length).toBe(1);const $error=$els.eq(0);expect($error.hasClass("rb-c-admin-news-widget__error")).toBeTrue();expect($error.html().strip()).toBe("There was an error loading the news. Please "+'<a href="http://example.com/news/">visit the news page</a> '+"directly, or try again later.")})})});"use strict";suite("rb/admin/views/InlineFormGroupView",function(){const inlineTemplate=_.template(`<div class="rb-c-admin-form-inline <%- classes || '' %>">
 <h3 class="rb-c-admin-form-inline__title">
  <span class="rb-c-admin-form-inline__title-prefix"></span>
  <span class="rb-c-admin-form-inline__title-object"></span>
  <span class="rb-c-admin-form-inline__title-index"></span>
  <span class="rb-c-admin-form-inline__actions">
   <span class="rb-c-admin-form-inline__delete-action"></span>
  </span>
 </h3>
 <fieldset>
  <div>
   <label for="myprefix-<%- index %>-foo"></label>
   <input id="myprefix-<%- index %>-foo"
          name="myprefix-<%- index %>-foo">
  </div>
  <div>
   <label for="myprefix-<%- index %>-bar"></label>
   <input id="myprefix-<%- index %>-bar"
          name="myprefix-<%- index %>-bar">
  </div>
 </fieldset>
</div>`);const template=_.template(`<div class="rb-c-admin-form-inline-group">
 <h2 class="rb-c-admin-form-inline-group__title"></h2>
 <div class="rb-c-admin-form-inline-group__inlines">
  <input type="hidden"
         id="id_myprefix-TOTAL_FORMS"
         name="myprefix-TOTAL_FORMS"
         value="<%- totalForms %>">
  <input type="hidden"
         id="id_myprefix-INITIAL_FORMS"
         name="myprefix-INITIAL_FORMS"
         value="<%- initialForms %>">
  <input type="hidden"
         id="id_myprefix-MIN_NUM_FORMS"
         name="myprefix-MIN_NUM_FORMS"
         value="<%- minNumForms %>">
  <input type="hidden"
         id="id_myprefix-MAX_NUM_FORMS"
         name="myprefix-MAX_NUM_FORMS"
         value="<%- maxNumForms %>">

  <% for (let i = 0; i < numInlines; i++) { %>
   <%= inlineTemplate({
       classes: '',
       index: i
   }) %>
  <% } %>
  <%= inlineTemplate({
      classes: '-is-template',
      index: '__prefix__'
  }) %>
 </div>
 <div class="rb-c-admin-form-inline-group__actions">
  <a href="#" class="rb-c-admin-form-inline-group__add-action"></a>
 </div>
</div>`);let $el;let model;let view;function buildView(options){$el=$(template(_.extend({initialForms:0,inlineTemplate:inlineTemplate,maxNumForms:"",minNumForms:0,numInlines:0,totalForms:0},options))).appendTo($testsScratch);view=new RB.Admin.InlineFormGroupView({el:$el,model:model});view.render()}beforeEach(function(){model=new RB.Admin.InlineFormGroup({prefix:"myprefix"})});describe("State",function(){it("Populated on render",function(){buildView({numInlines:2,initialForms:2,minNumForms:1,maxNumForms:5,totalForms:2});expect($el.find(".rb-c-admin-form-inline").length).toBe(2);expect(view._$inlineTemplate.length).toBe(1);expect(view._$inlineTemplate.hasClass("-is-template")).toBeFalse();expect(model.get("initialInlines")).toBe(2);expect(model.get("maxInlines")).toBe(5);expect(model.get("minInlines")).toBe(1);expect(model.inlines.length).toBe(2);expect(view._inlineViews.length).toBe(2);let inline=model.inlines.at(0);expect(inline.get("index")).toBe(0);expect(inline.get("isInitial")).toBeTrue();expect(view._inlineViews[0].model).toBe(inline);inline=model.inlines.at(1);expect(inline.get("index")).toBe(1);expect(inline.get("isInitial")).toBeTrue();expect(view._inlineViews[1].model).toBe(inline)});it("Updated when inlines added",function(){buildView({numInlines:1,initialForms:1,totalForms:1});const $totalForms=$el.find("#id_myprefix-TOTAL_FORMS");const $addButton=$el.find(".rb-c-admin-form-inline-group__add-action");expect($el.find(".rb-c-admin-form-inline").length).toBe(1);expect($totalForms.val()).toBe("1");$addButton.click();expect($el.find(".rb-c-admin-form-inline").length).toBe(2);expect($totalForms.val()).toBe("2");$addButton.click();expect($el.find(".rb-c-admin-form-inline").length).toBe(3);expect($totalForms.val()).toBe("3")});it("Updated when inlines added",function(){buildView({numInlines:2,initialForms:2,totalForms:2});const $totalForms=$el.find("#id_myprefix-TOTAL_FORMS");expect(model.inlines.length).toBe(2);expect($totalForms.val()).toBe("2");model.inlines.at(0).destroy();const $inlines=$el.find(".rb-c-admin-form-inline");expect($inlines.length).toBe(1);expect(model.inlines.length).toBe(1);expect($totalForms.val()).toBe("1");expect($inlines[0].id).toBe("myprefix-0")})});describe("UI",function(){describe("Add Button",function(){let $addButton;beforeEach(function(){buildView({numInlines:1,initialForms:1,minNumForms:0,maxNumForms:3,totalForms:1});$addButton=$el.find(".rb-c-admin-form-inline-group__add-action");expect($addButton.length).toBe(1)});it("When under limit",function(){expect($addButton.is(":visible")).toBeTrue();view.addInlineForm();expect($addButton.is(":visible")).toBeTrue()});it("When limit hit",function(){expect($addButton.is(":visible")).toBeTrue();view.addInlineForm();view.addInlineForm();expect($addButton.is(":visible")).toBeFalse()})})})});"use strict";suite("rb/admin/views/InlineFormView",function(){const template=_.template(`<div class="rb-c-admin-form-inline">
 <h3 class="rb-c-admin-form-inline__title">
  <span class="rb-c-admin-form-inline__title-prefix"></span>
  <span class="rb-c-admin-form-inline__title-object"></span>
  <span class="rb-c-admin-form-inline__title-index"></span>
  <span class="rb-c-admin-form-inline__actions">
   <span class="rb-c-admin-form-inline__delete-action"></span>
  </span>
 </h3>
 <fieldset>
  <div>
   <label for="id_myprefix-<%- index %>-foo"></label>
   <input id="id_myprefix-<%- index %>-foo"
          name="myprefix-<%- index %>-foo">
  </div>
  <div>
   <label for="id_myprefix-<%- index %>-bar"></label>
   <input id="id_myprefix-<%- index %>-bar"
          name="myprefix-<%- index %>-bar">
  </div>
 </fieldset>
</div>`);let $el;let model;let view;beforeEach(function(){$el=$(template({index:"__prefix__"}));model=new RB.Admin.InlineForm({prefix:"myprefix"});view=new RB.Admin.InlineFormView({el:$el,model:model});view.render()});describe("Events",function(){describe("Delete clicked",function(){let $delete;beforeEach(function(){spyOn(window,"confirm").and.returnValue(true);spyOn(model,"destroy");$delete=$el.find(".rb-c-admin-form-inline__delete-action")});it("With isInitial=true",function(){model.set("isInitial",true);$delete.click();expect(window.confirm).not.toHaveBeenCalled();expect(model.destroy).not.toHaveBeenCalled()});it("With isInitial=false",function(){model.set("isInitial",false);$delete.click();expect(window.confirm).toHaveBeenCalled();expect(model.destroy).toHaveBeenCalled()})});describe("Index changed",function(){let $labels;let $inputs;let $titleIndex;beforeEach(function(){$labels=$el.find("label");$inputs=$el.find("input");$titleIndex=$el.find(".rb-c-admin-form-inline__title-index");expect($labels.length).toBe(2);expect($inputs.length).toBe(2);expect($titleIndex.length).toBe(1)});it("From __prefix__ to index",function(){model.set("index",0);expect($el[0].id).toBe("myprefix-0");expect($titleIndex.text()).toBe("#1");expect($labels[0].htmlFor).toBe("id_myprefix-0-foo");expect($labels[1].htmlFor).toBe("id_myprefix-0-bar");let inputEl=$inputs[0];expect(inputEl.id).toBe("id_myprefix-0-foo");expect(inputEl.name).toBe("myprefix-0-foo");inputEl=$inputs[1];expect(inputEl.id).toBe("id_myprefix-0-bar");expect(inputEl.name).toBe("myprefix-0-bar")});it("From index to index",function(){model.set("index",0);model.set("index",1);expect($el[0].id).toBe("myprefix-1");expect($titleIndex.text()).toBe("#2");expect($labels[0].htmlFor).toBe("id_myprefix-1-foo");expect($labels[1].htmlFor).toBe("id_myprefix-1-bar");let inputEl=$inputs[0];expect(inputEl.id).toBe("id_myprefix-1-foo");expect(inputEl.name).toBe("myprefix-1-foo");inputEl=$inputs[1];expect(inputEl.id).toBe("id_myprefix-1-bar");expect(inputEl.name).toBe("myprefix-1-bar")})})})});"use strict";suite("rb/collections/FilteredCollection",function(){let mainCollection;beforeEach(function(){mainCollection=new Backbone.Collection([{id:1,label:"One",bool:true},{id:2,label:"Two",bool:false},{id:3,label:"Three",bool:true}])});describe("Initialization",function(){it("Defaults to full contents",function(){const filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection});expect(filteredCollection.length).toBe(mainCollection.length)});it("Respects provided filter",function(){const filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection,filters:{label:"T"}});expect(filteredCollection.length).toBe(2);expect(filteredCollection.at(0).id).toBe(2);expect(filteredCollection.at(1).id).toBe(3)})});describe("Methods",function(){let filteredCollection;beforeEach(function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection,filters:{label:"T"}});expect(filteredCollection.length).toBe(2)});describe("setFilters",function(){it("With new filter",function(){filteredCollection.setFilters({label:"O"});expect(filteredCollection.length).toBe(1);expect(filteredCollection.at(0).id).toBe(1)});it("With multiple filters",function(){filteredCollection.setFilters({label:"T",bool:false});expect(filteredCollection.length).toBe(1);expect(filteredCollection.at(0).id).toBe(2)});it("{}",function(){filteredCollection.setFilters({});expect(filteredCollection.length).toBe(3)});it("null",function(){filteredCollection.setFilters(null);expect(filteredCollection.length).toBe(3)});it("undefined",function(){filteredCollection.setFilters();expect(filteredCollection.length).toBe(3)})})});describe("Main collection events",function(){describe("With filters",function(){let filteredCollection;beforeEach(function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection,filters:{label:"T"}});expect(filteredCollection.length).toBe(2)});it("reset",function(){mainCollection.reset([{id:10,label:"Monday"},{id:11,label:"Tuesday"}]);expect(filteredCollection.length).toBe(1);expect(filteredCollection.at(0).id).toBe(11)});describe("add",function(){it("Matching filter",function(){mainCollection.add({id:4,label:"Test"});expect(filteredCollection.length).toBe(3);expect(filteredCollection.at(2).id).toBe(4)});it("Not matching filter",function(){mainCollection.add({id:4,label:"Four"});expect(filteredCollection.length).toBe(2)})});describe("remove",function(){it("Matching filter",function(){mainCollection.remove(mainCollection.get(2));expect(filteredCollection.length).toBe(1)});it("Not matching filter",function(){mainCollection.remove(mainCollection.get(0));expect(filteredCollection.length).toBe(2)})})});describe("Without filters",function(){let filteredCollection;beforeEach(function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection});expect(filteredCollection.length).toBe(3)});it("reset",function(){mainCollection.reset([{id:10,label:"Monday"},{id:11,label:"Tuesday"}]);expect(filteredCollection.length).toBe(2)});it("add",function(){mainCollection.add({id:4,label:"Four"});expect(filteredCollection.length).toBe(4);expect(filteredCollection.at(3).id).toBe(4)});it("remove",function(){mainCollection.remove(mainCollection.get(1));expect(filteredCollection.length).toBe(2)})})})});"use strict";suite("rb/configForms/models/ResourceListItem",function(){const TestListItem=RB.Config.ResourceListItem.extend({syncAttrs:["name","fileRegex"],createResource:attrs=>new RB.DefaultReviewer(attrs)});let resource;beforeEach(function(){resource=new RB.DefaultReviewer({name:"my-name",fileRegex:".*"})});describe("Synchronizing attributes",function(){it("On resource attribute change",function(){const listItem=new TestListItem({resource:resource});resource.set("name","foo");expect(listItem.get("name")).toBe("foo")});describe("On creation",function(){it("With existing resource",function(){const listItem=new TestListItem({resource:resource,name:"dummy",fileRegex:"/foo/.*"});expect(listItem.get("name")).toBe("my-name");expect(listItem.get("fileRegex")).toBe(".*")});it("With created resource",function(){const listItem=new TestListItem({id:123,name:"new-name",fileRegex:"/foo/.*"});expect(listItem.get("name")).toBe("new-name");expect(listItem.get("fileRegex")).toBe("/foo/.*");resource=listItem.get("resource");expect(resource.id).toBe(123);expect(resource.get("name")).toBe("new-name");expect(resource.get("fileRegex")).toBe("/foo/.*")})})});describe("Event mirroring",function(){let listItem;beforeEach(function(){listItem=new TestListItem({resource:resource});spyOn(listItem,"trigger")});it("destroy",function(){resource.trigger("destroy");expect(listItem.trigger).toHaveBeenCalledWith("destroy",listItem,undefined,{})});it("request",function(){resource.trigger("request");expect(listItem.trigger).toHaveBeenCalledWith("request")});it("sync",function(){resource.trigger("sync");expect(listItem.trigger).toHaveBeenCalledWith("sync")})})});"use strict";suite("rb/diffviewer/collections/DiffReviewableCollection",function(){describe("Construction",function(){it("Sets reviewRequest",function(){const reviewRequest=new RB.ReviewRequest;const collection=new RB.DiffReviewableCollection([],{reviewRequest:reviewRequest});expect(collection.reviewRequest).toBe(reviewRequest)})});describe("watchFiles",function(){let collection;let files;beforeEach(function(){collection=new RB.DiffReviewableCollection([],{reviewRequest:new RB.ReviewRequest});files=new RB.DiffFileCollection});it("Initially populates",function(){spyOn(collection,"_populateFromFiles");collection.watchFiles(files);expect(collection._populateFromFiles).toHaveBeenCalled()});it("Populates on files.reset",function(){spyOn(collection,"trigger");spyOn(collection,"reset");collection.watchFiles(files);files.reset([new RB.DiffFile({filediff:{id:300,revision:1},index:1,id:100}),new RB.DiffFile({filediff:{id:301,revision:1},interfilediff:{id:400,revision:2},index:2,id:101,commentCounts:[1]}),new RB.DiffFile({baseFileDiffID:123,filediff:{id:302,revision:2},forceInterdiff:true,forceInterdiffRevision:1,index:3,id:102})]);expect(collection.reset).toHaveBeenCalled();expect(collection.trigger).toHaveBeenCalledWith("populating");expect(collection.trigger).toHaveBeenCalledWith("populated");expect(collection.length).toBe(3);let diffReviewable=collection.at(0);expect(diffReviewable.get("baseFileDiffID")).toBe(null);expect(diffReviewable.get("file").id).toBe(100);expect(diffReviewable.get("reviewRequest")).toBe(collection.reviewRequest);expect(diffReviewable.get("fileDiffID")).toBe(300);expect(diffReviewable.get("interFileDiffID")).toBe(null);expect(diffReviewable.get("revision")).toBe(1);expect(diffReviewable.get("interdiffRevision")).toBe(null);diffReviewable=collection.at(1);expect(diffReviewable.get("baseFileDiffID")).toBe(null);expect(diffReviewable.get("file").id).toBe(101);expect(diffReviewable.get("reviewRequest")).toBe(collection.reviewRequest);expect(diffReviewable.get("fileDiffID")).toBe(301);expect(diffReviewable.get("interFileDiffID")).toBe(400);expect(diffReviewable.get("revision")).toBe(1);expect(diffReviewable.get("interdiffRevision")).toBe(2);expect(diffReviewable.get("serializedCommentBlocks")).toEqual([1]);diffReviewable=collection.at(2);expect(diffReviewable.get("baseFileDiffID")).toBe(123);expect(diffReviewable.get("file").id).toBe(102);expect(diffReviewable.get("reviewRequest")).toBe(collection.reviewRequest);expect(diffReviewable.get("fileDiffID")).toBe(302);expect(diffReviewable.get("interFileDiffID")).toBe(null);expect(diffReviewable.get("revision")).toBe(2);expect(diffReviewable.get("interdiffRevision")).toBe(1)})})});"use strict";suite("rb/diffviewer/models/DiffCommit",function(){describe("parse",function(){it("Short commit message",function(){const model=new RB.DiffCommit({author_name:"Author Name",commit_id:"r123",commit_message:"A commit message.\n",id:1,parent_id:"r122"},{parse:true});expect(model).toBeTruthy();expect(model.attributes).not.toBe(undefined);expect(model.attributes).toEqual({authorName:"Author Name",commitID:"r123",commitMessage:"A commit message.",id:1,parentID:"r122",summary:"A commit message."});expect(model.hasSummary()).toBe(false)});it("Long commit message",function(){const model=new RB.DiffCommit({author_name:"Author Name",commit_id:"r123",commit_message:`This is a long commit message.

It spans several lines.
It has trailing newlines as well.

`,id:2,parent_id:"r122"},{parse:true});expect(model).toBeTruthy();expect(model.attributes).not.toBe(undefined);expect(model.attributes).toEqual({authorName:"Author Name",commitID:"r123",commitMessage:"This is a long commit message.\n\n"+"It spans several lines.\n"+"It has trailing newlines as well.",id:2,parentID:"r122",summary:"This is a long commit message."});expect(model.hasSummary()).toBe(true)});it("Commit message with overlong first line",function(){const message="abcd".repeat(100);const summary=message.substr(0,77)+"...";const model=new RB.DiffCommit({author_name:"Author Name",commit_id:"r234",commit_message:message,id:3,parent_id:"r233"},{parse:true});expect(model).toBeTruthy();expect(model.attributes).not.toBe(undefined);expect(model.attributes).toEqual({authorName:"Author Name",commitID:"r234",commitMessage:message,id:3,parentID:"r233",summary:summary});expect(model.hasSummary()).toBe(true)})})});"use strict";suite("rb/diffviewer/models/DiffFile",function(){describe("parse",function(){it("API payloads",function(){const data=RB.DiffFile.prototype.parse.call(undefined,{base_filediff_id:12,binary:false,comment_counts:[1],deleted:true,depot_filename:"foo",dest_filename:"bar",filediff:{id:38,revision:2},id:28,index:3,interfilediff:{id:23,revision:4},newfile:true,revision:3});expect(data).not.toBe(undefined);expect(data.baseFileDiffID).toBe(12);expect(data.binary).toBe(false);expect(data.commentCounts).toEqual([1]);expect(data.deleted).toBe(true);expect(data.depotFilename).toBe("foo");expect(data.destFilename).toBe("bar");expect(data.filediff).not.toBe(undefined);expect(data.filediff.id).toBe(38);expect(data.filediff.revision).toBe(2);expect(data.id).toBe(28);expect(data.index).toBe(3);expect(data.interfilediff).not.toBe(undefined);expect(data.interfilediff.id).toBe(23);expect(data.interfilediff.revision).toBe(4);expect(data.newfile).toBe(true);expect(data.revision).toBe(3)})})});"use strict";suite("rb/diffviewer/models/DiffReviewable",function(){let callbacks;let reviewRequest;beforeEach(function(){callbacks={success:function(){},error:function(){},complete:function(){}};reviewRequest=new RB.ReviewRequest({reviewURL:"/r/1/"});spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(callbacks,"complete")});describe("getRenderedDiff",function(){it("Without interdiffs",function(){const diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,revision:2,file:new RB.DiffFile({index:4})});spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2/fragment/3/?index=4&_="+TEMPLATE_SERIAL);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiff(callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()});it("With interdiffs",function(){const diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,revision:2,interdiffRevision:3,file:new RB.DiffFile({index:4})});spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2-3/fragment/3/?index=4&_="+TEMPLATE_SERIAL);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiff(callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()});it("With base FileDiff",function(){const diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,revision:2,baseFileDiffID:1,file:new RB.DiffFile({index:4})});spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2/fragment/3/?base-filediff-id=1&index=4&_="+TEMPLATE_SERIAL);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiff(callbacks);expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()})});describe("getRenderedDiffFragment",function(){it("Without interdiffs",function(){const diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,revision:2,file:new RB.DiffFile({index:5})});spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2/fragment/3/chunk/4/?index=5&"+"lines-of-context=6&_="+TEMPLATE_SERIAL);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiffFragment({chunkIndex:4,linesOfContext:6},callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()});it("With interdiffs",function(){const diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,revision:2,interdiffRevision:3,interFileDiffID:4,file:new RB.DiffFile({index:5})});spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2-3/fragment/3-4/chunk/4/?index=5&"+"lines-of-context=6&_="+TEMPLATE_SERIAL);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiffFragment({chunkIndex:4,linesOfContext:6},callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()});it("With base filediff ID",function(){const diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,baseFileDiffID:123,fileDiffID:3,revision:2,interdiffRevision:3,interFileDiffID:4,file:new RB.DiffFile({index:5})});spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2-3/fragment/3-4/chunk/4/"+"?base-filediff-id=123&index=5&"+"lines-of-context=6&_="+TEMPLATE_SERIAL);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiffFragment({chunkIndex:4,linesOfContext:6},callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()});it("With base filediff ID",function(){const diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,baseFileDiffID:123,fileDiffID:3,revision:2,interdiffRevision:3,interFileDiffID:4,file:new RB.DiffFile({index:5})});spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2-3/fragment/3-4/chunk/4/"+"?base-filediff-id=123&index=5&"+"lines-of-context=6&_="+TEMPLATE_SERIAL);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiffFragment({chunkIndex:4,linesOfContext:6},callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()})})});"use strict";suite("rb/diffviewer/models/DiffRevision",function(){describe("parse",function(){it("API payloads",function(){const data=RB.DiffRevision.prototype.parse.call(undefined,{revision:2,latest_revision:3,interdiff_revision:4,is_interdiff:true,is_draft_diff:true});expect(data).not.toBe(undefined);expect(data.revision).toBe(2);expect(data.latestRevision).toBe(3);expect(data.interdiffRevision).toBe(4);expect(data.isInterdiff).toBe(true);expect(data.isDraftDiff).toBe(true);expect(data.baseCommitID).toBe(null);expect(data.tipCommitID).toBe(null)});it("API payloads with base/tip commit IDs",function(){const data=RB.DiffRevision.prototype.parse.call(undefined,{revision:4,latest_revision:7,interdiff_revision:null,is_interdiff:false,is_draft_diff:false,base_commit_id:3,tip_commit_id:4});expect(data).not.toBe(undefined);expect(data.revision).toBe(4);expect(data.latestRevision).toBe(7);expect(data.interdiffRevision).toBe(null);expect(data.isInterdiff).toBe(false);expect(data.isDraftDiff).toBe(false);expect(data.baseCommitID).toBe(3);expect(data.tipCommitID).toBe(4)})})});"use strict";suite("rb/diffviewer/models/Pagination",function(){let model;beforeEach(function(){model=new RB.Pagination});describe("parse",function(){it("API payloads",function(){var data=model.parse({is_paginated:true,pages:4,has_previous:true,has_next:true,page_numbers:[1,2,3,4],previous_page:1,next_page:3,current_page:2});expect(data).not.toBe(undefined);expect(data.isPaginated).toBe(true);expect(data.pages).toBe(4);expect(data.pageNumbers).toEqual([1,2,3,4]);expect(data.hasPrevious).toBe(true);expect(data.hasNext).toBe(true);expect(data.previousPage).toBe(1);expect(data.nextPage).toBe(3);expect(data.currentPage).toBe(2)})})});"use strict";suite("rb/diffviewer/views/DiffCommitListView",function(){function testRows($rows,options){expect($rows.length).toEqual(options.rowOptions.length);const linkIndex=(options.haveHistory?1:0)+(options.haveInterCommitDiffControls?2:0);const valueStartIndex=linkIndex+(options.haveExpandCollapse?1:0);for(let i=0;i<$rows.length;i++){const $row=$rows.eq(i).find("td");const rowOptions=options.rowOptions[i];const values=rowOptions.values;expect($row.length).toEqual(values.length+valueStartIndex);if(options.haveHistory){expect($row.eq(0).text().trim()).toEqual(rowOptions.historySymbol.trim())}if(options.haveInterCommitDiffControls){const $baseSelector=$row.eq(0).find("input");expect($baseSelector.length).toEqual(1);expect($baseSelector.attr("value")).toEqual((i+1).toString());expect($baseSelector.prop("checked")).toEqual(!!rowOptions.baseSelected);expect($baseSelector.prop("disabled")).toEqual(!!rowOptions.baseDisabled);const $tipSelector=$row.eq(1).find("input");expect($tipSelector.length).toEqual(1);expect($tipSelector.attr("value")).toEqual((i+1).toString());expect($tipSelector.prop("checked")).toEqual(rowOptions.tipSelected?true:false);expect($tipSelector.prop("disabled")).toEqual(!!rowOptions.tipDisabled)}if(options.haveExpandCollapse){const $link=$row.eq(linkIndex).find("a");if(rowOptions.haveExpandCollapse){expect($link.length).toEqual(1);const $span=$link.find("span");if(rowOptions.expanded){expect($span.attr("class")).toEqual("fa fa-minus");expect($span.attr("title")).toEqual(gettext("Collapse commit message."))}else{expect($span.attr("class")).toEqual("fa fa-plus");expect($span.attr("title")).toEqual(gettext("Expand commit message."))}}}for(let j=0;j<values;j++){expect($row.eq(valueStartIndex+j).text().trim()).toEqual(values[j])}}}let view;let $container;beforeEach(function(){$container=$('<div class="diff-commit-list" />').appendTo($testsScratch)});afterEach(function(){view.remove();view=null;$container=null});describe("Render",function(){let model;beforeEach(function(){let commits=new RB.DiffCommitCollection([{id:1,commit_id:"r1",parent_id:"r0",author_name:"Example Author",commit_message:"Commit message 1"},{id:2,commit_id:"r2",parent_id:"r1",author_name:"Example Author",commit_message:"Commit message 2"}],{parse:true});model=new RB.DiffCommitList({commits:commits,historyDiff:new RB.CommitHistoryDiffEntryCollection,isInterdiff:false,baseCommitID:null,tipCommitID:null})});it("Without expand/collapse column",function(){view=new RB.DiffCommitListView({model:model,el:$container});view.render();const $table=$container.find("table");const $cols=$table.find("thead th");expect($cols.length).toEqual(2);expect($cols.eq(0).text().trim()).toEqual(gettext("Summary"));expect($cols.eq(1).text().trim()).toEqual(gettext("Author"));testRows($table.find("tbody tr"),{haveExpandCollapse:false,rowOptions:[{values:["Commit message 1","Example Author"]},{values:["Commit message 2","Example Author"]}]})});it("With expand/collapse column",function(){model.get("commits").models[0].set({commitMessage:"Long commit message\n\n"+"This is a long message.\n",summary:"Long commit message"});view=new RB.DiffCommitListView({model:model,el:$container});view.render();const $table=$container.find("table");const $cols=$table.find("thead th");expect($cols.length).toEqual(2);expect($cols.eq(0).text().trim()).toEqual(gettext("Summary"));expect($cols.eq(1).text().trim()).toEqual(gettext("Author"));testRows($table.find("tbody tr"),{haveExpandCollapse:true,rowOptions:[{haveExpandCollapse:true,expanded:false,values:["Long commit message","Example Author"]},{haveExpandCollapse:false,values:["Commit message 2","Example Author"]}]})});it("Updates when collection reset",function(){view=new RB.DiffCommitListView({model:model,el:$container});view.render();let $table=$container.find("table");let $cols=$table.find("thead th");expect($cols.length).toEqual(2);expect($cols.eq(0).text().trim()).toEqual(gettext("Summary"));expect($cols.eq(1).text().trim()).toEqual(gettext("Author"));testRows($table.find("tbody tr"),{haveExpandCollapse:false,rowOptions:[{values:["Commit message 1","Example Author"]},{values:["Commit message 2","Example Author"]}]});model.get("commits").reset([{commit_id:"r4",author_name:"Example Author",commit_message:"Commit message 4\n\nIt is very long"}],{parse:true});$table=$container.find("table");$cols=$table.find("thead th");expect($cols.length).toEqual(2);expect($cols.eq(0).text().trim()).toEqual(gettext("Summary"));expect($cols.eq(1).text().trim()).toEqual(gettext("Author"));testRows($table.find("tbody tr"),{haveExpandCollapse:true,rowOptions:[{haveExpandCollapse:true,expanded:false,values:["Commit message 4","Example Author"]}]})});it("Interdiff",function(){model.get("historyDiff").reset([{entry_type:RB.CommitHistoryDiffEntry.REMOVED,old_commit_id:1},{entry_type:RB.CommitHistoryDiffEntry.ADDED,new_commit_id:2}],{parse:true});view=new RB.DiffCommitListView({model:model,el:$container});view.render();const $table=$container.find("table");const $cols=$table.find("thead th");expect($cols.length).toEqual(3);expect($cols.eq(0).text().trim()).toEqual("");expect($cols.eq(1).text().trim()).toEqual(gettext("Summary"));expect($cols.eq(2).text().trim()).toEqual(gettext("Author"));testRows($table.find("tbody tr"),{haveExpandCollapse:false,haveHistory:true,rowOptions:[{historySymbol:"-",values:["Commit message 1","Example Author"]},{historySymbol:"+",values:["Commit message 2","Example Author"]}]})});it("With Inter-Commit Diff Controls",function(){view=new RB.DiffCommitListView({el:$container,model:model,showInterCommitDiffControls:true});view.render();const $table=$container.find("table");const $cols=$table.find("thead th");expect($cols.length).toEqual(4);expect($cols.eq(0).text().trim()).toEqual(gettext("First"));expect($cols.eq(1).text().trim()).toEqual(gettext("Last"));expect($cols.eq(2).text().trim()).toEqual(gettext("Summary"));expect($cols.eq(3).text().trim()).toEqual(gettext("Author"));testRows($table.find("tbody tr"),{haveInterCommitDiffControls:true,rowOptions:[{baseSelected:true,values:["Commit message 1","Example Author"]},{tipSelected:true,values:["Commit message 2","Example Author"]}]})});it("With Inter-Commit Diff and Expand/Collapse Controls",function(){model.get("commits").get(1).set({commitMessage:"Long commit message\n"+"\nThis is a long message.\n",summary:"Long commit message"});view=new RB.DiffCommitListView({el:$container,model:model,showInterCommitDiffControls:true});view.render();const $table=$container.find("table");const $cols=$table.find("thead th");expect($cols.length).toEqual(4);expect($cols.eq(0).text().trim()).toEqual(gettext("First"));expect($cols.eq(1).text().trim()).toEqual(gettext("Last"));expect($cols.eq(2).text().trim()).toEqual(gettext("Summary"));expect($cols.eq(3).text().trim()).toEqual(gettext("Author"));testRows($table.find("tbody tr"),{haveExpandCollapse:true,haveInterCommitDiffControls:true,rowOptions:[{baseSelected:true,haveExpandCollapse:true,values:["Long commit message","Example Author"]},{tipSelected:true,values:["Commit message 2","Example Author"]}]})});it("With base and tip commit IDs set",function(){const commits=model.get("commits");commits.add([{id:3,commit_id:"r3",parent_id:"r2",author_name:"Example Author",commit_message:"Commit message 3"},{id:4,commit_id:"r4",parent_id:"r3",author_name:"Example Author",commit_message:"Commit message 4"}],{parse:true});model.set({baseCommitID:commits.findWhere({commitID:"r2"}).id,tipCommitID:commits.findWhere({commitID:"r3"}).id});view=new RB.DiffCommitListView({el:$container,model:model,showInterCommitDiffControls:true});view.render();const $table=$container.find("table");const $cols=$table.find("thead th");expect($cols.length).toEqual(4);expect($cols.eq(0).text().trim()).toEqual(gettext("First"));expect($cols.eq(1).text().trim()).toEqual(gettext("Last"));expect($cols.eq(2).text().trim()).toEqual(gettext("Summary"));expect($cols.eq(3).text().trim()).toEqual(gettext("Author"));testRows($table.find("tbody tr"),{haveInterCommitDiffControls:true,rowOptions:[{tipDisabled:true,values:["Long commit message","Example Author"]},{tipDisabled:true,values:["Commit message 2","Example Author"]},{baseSelected:true,tipSelected:true,values:["Commit message 3","Example Author"]},{baseDisabled:true,values:["Commit message 4","Example Author"]}]})})});describe("Event handlers",function(){let model;beforeEach(function(){let commits=new RB.DiffCommitCollection([{id:1,commit_id:"r1",parent_id:"r0",author_name:"Example Author",commit_message:"Long commit message\n\n"+"This is a long message.\n"},{id:2,commit_id:"r2",parent_id:"r1",author_name:"Example Author",commit_message:"Super long\n\nSo very long."}],{parse:true});model=new RB.DiffCommitList({commits:commits,isInterdiff:false})});it("Expand/collapse",function(){view=new RB.DiffCommitListView({model:model,el:$container});view.render();const $table=$container.find("table");const $cols=$table.find("thead th");expect($cols.length).toEqual(2);expect($cols.eq(0).text().trim()).toEqual(gettext("Summary"));expect($cols.eq(1).text().trim()).toEqual(gettext("Author"));testRows($table.find("tbody tr"),{haveExpandCollapse:true,rowOptions:[{haveExpandCollapse:true,expanded:false,values:["Long commit message","Example Author"]},{haveExpandCollapse:true,expanded:false,values:["Super long","Example Author"]}]});const $links=$table.find("a");$links.eq(0).click();testRows($table.find("tbody tr"),{haveExpandCollapse:true,rowOptions:[{haveExpandCollapse:true,expanded:true,values:["Long commit message\n\nThis is a long message.","Example Author"]},{haveExpandCollapse:true,expanded:false,values:["Super long","Example Author"]}]});$links.eq(0).click();testRows($table.find("tbody tr"),{haveExpandCollapse:true,rowOptions:[{haveExpandCollapse:true,iconClass:"fa-plus",values:["Long commit message","Example Author"]},{haveExpandCollapse:true,iconClass:"fa-plus",values:["Super long","Example Author"]}]});$links.eq(1).click();testRows($table.find("tbody tr"),{haveExpandCollapse:true,rowOptions:[{haveExpandCollapse:true,expanded:false,values:["Long commit message","Example Author"]},{haveExpandCollapse:true,expanded:true,values:["Super long\n\nSo very long.","Example Author"]}]});$links.eq(1).click();testRows($table.find("tbody tr"),{haveExpandCollapse:true,rowOptions:[{haveExpandCollapse:true,expanded:false,values:["Long commit message","Example Author"]},{haveExpandCollapse:true,expanded:false,values:["Super long","Example Author"]}]})});it("Select base/tip",function(){model.get("commits").add([{id:3,commit_id:"r3",parent_id:"r2",author_name:"Example Author",commit_message:"Commit message 3"},{id:4,commit_id:"r4",parent_id:"r3",author_name:"Example Author",commit_message:"Commit message 4"}],{parse:true});view=new RB.DiffCommitListView({el:$container,showInterCommitDiffControls:true,model:model});view.render();const $baseSelectors=$container.find(".base-commit-selector");const $tipSelectors=$container.find(".tip-commit-selector");expect($baseSelectors.length).toEqual(4);expect($tipSelectors.length).toEqual(4);$baseSelectors.eq(3).click();expect($baseSelectors.eq(0).prop("disabled")).toEqual(false);expect($baseSelectors.eq(1).prop("disabled")).toEqual(false);expect($baseSelectors.eq(2).prop("disabled")).toEqual(false);expect($baseSelectors.eq(3).prop("disabled")).toEqual(false);expect($tipSelectors.eq(0).prop("disabled")).toEqual(true);expect($tipSelectors.eq(1).prop("disabled")).toEqual(true);expect($tipSelectors.eq(2).prop("disabled")).toEqual(true);expect($tipSelectors.eq(3).prop("disabled")).toEqual(false);expect(model.get("baseCommitID")).toEqual(3);expect(model.get("tipCommitID")).toEqual(null);$baseSelectors.eq(0).click();for(let i=0;i<4;i++){expect($baseSelectors.eq(i).prop("disabled")).toEqual(false);expect($tipSelectors.eq(i).prop("disabled")).toEqual(false)}expect(model.get("baseCommitID")).toEqual(null);expect(model.get("tipCommitID")).toEqual(null);$tipSelectors.eq(0).click();expect($baseSelectors.eq(0).prop("disabled")).toEqual(false);expect($baseSelectors.eq(1).prop("disabled")).toEqual(true);expect($baseSelectors.eq(2).prop("disabled")).toEqual(true);expect($baseSelectors.eq(3).prop("disabled")).toEqual(true);expect($tipSelectors.eq(0).prop("disabled")).toEqual(false);expect($tipSelectors.eq(1).prop("disabled")).toEqual(false);expect($tipSelectors.eq(2).prop("disabled")).toEqual(false);expect($tipSelectors.eq(3).prop("disabled")).toEqual(false);expect(model.get("baseCommitID")).toEqual(null);expect(model.get("tipCommitID")).toEqual(1);$tipSelectors.eq(2).click();$baseSelectors.eq(2).click();expect($baseSelectors.eq(0).prop("disabled")).toEqual(false);expect($baseSelectors.eq(1).prop("disabled")).toEqual(false);expect($baseSelectors.eq(2).prop("disabled")).toEqual(false);expect($baseSelectors.eq(3).prop("disabled")).toEqual(true);expect($tipSelectors.eq(0).prop("disabled")).toEqual(true);expect($tipSelectors.eq(1).prop("disabled")).toEqual(true);expect($tipSelectors.eq(2).prop("disabled")).toEqual(false);expect($tipSelectors.eq(2).prop("disabled")).toEqual(false);expect(model.get("baseCommitID")).toEqual(2);expect(model.get("tipCommitID")).toEqual(3)})})});"use strict";suite("rb/diffviewer/views/DiffReviewableView",function(){const diffTableTemplate=_.template(`<table class="sidebyside">
 <thead>
  <tr>
   <th colspan="2">
    <a name="1" class="file-anchor"></a> my-file.txt
   </th>
  </tr>
  <tr>
   <th class="rev">Revision 1</th>
   <th class="rev">Revision 2</th>
  </tr>
 </thead>
 <% _.each(chunks, function(chunk, index) { %>
  <% if (chunk.type === "collapsed") { %>
   <tbody class="diff-header">
    <tr>
     <th>
      <a href="#" class="diff-expand-btn tests-expand-above"
         data-chunk-index="<%= index %>"
         data-lines-of-context="20,0"><img /></a>
     </th>
     <th colspan="3">
      <a href="#" class="diff-expand-btn tests-expand-chunk"
         data-chunk-index="<%= index %>"><img /> Expand</a>
     </th>
    </tr>
    <tr>
     <th>
      <a href="#" class="diff-expand-btn tests-expand-below"
         data-chunk-index="<%= index %>"
         data-lines-of-context="0,20"><img /></a>
     </th>
     <th colspan="3">
      <a href="#" class="diff-expand-btn tests-expand-header"
         data-chunk-index="<%= index %>"
         data-lines-of-context="0,<%= chunk.expandHeaderLines %>">
       <img /> <code>Some Function</code>
      </a>
     </th>
    </tr>
   </tbody>
  <% } else { %>
   <tbody class="<%= chunk.type %>
                 <% if (chunk.expanded) { %>loaded<% } %>
                 <%= chunk.extraClass || "" %>"
          id="chunk0.<%= index %>">
    <% for (var i = 0; i < chunk.numRows; i++) { %>
     <tr line="<%= i + chunk.startRow %>">
      <th></th>
      <td>
       <% if (chunk.expanded && i === 0) { %>
        <div class="collapse-floater">
         <img class="diff-collapse-btn"
              data-chunk-index="<%= index %>"
              data-lines-of-context="0" />
        </div>
       <% } %>
      </td>
      <th></th>
      <td></td>
     </tr>
    <% } %>
   </tbody>
  <% } %>
 <% }); %>
</table>`);let reviewRequest;let $container;let view;beforeEach(function(){$container=$("<div/>").appendTo($testsScratch);reviewRequest=new RB.ReviewRequest});afterEach(function(){view.remove()});describe("CommentRowSelector",function(){let selector;let $rows;beforeEach(function(){view=new RB.DiffReviewableView({model:new RB.DiffReviewable({reviewRequest:reviewRequest}),el:$(diffTableTemplate({chunks:[{type:"equal",startRow:1,numRows:5},{type:"delete",startRow:6,numRows:10}]}))});view.render().$el.appendTo($container);selector=view._selector;$rows=view.$el.find("tbody tr")});describe("Selecting range",function(){let $startRow;let startCell;beforeEach(function(){$startRow=$rows.eq(4);startCell=$startRow[0].cells[0]});it("Beginning selection",function(){selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});expect($startRow.hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($startRow[0].rowIndex)});describe("Adding rows to selection",function(){it("Above",function(){const $prevRow=$rows.eq(3);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:$prevRow[0].cells[0]});expect($startRow.hasClass("selected")).toBe(true);expect($prevRow.hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($prevRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(4);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($prevRow[0].rowIndex)});it("Below",function(){const $nextRow=$rows.eq(5);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:$nextRow[0].cells[0]});expect($startRow.hasClass("selected")).toBe(true);expect($nextRow.hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($nextRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(6);expect(selector._lastSeenIndex).toBe($nextRow[0].rowIndex)});it("Rows inbetween two events",function(){const $laterRow=$rows.eq(7);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:$laterRow[0].cells[0]});expect($($rows[4]).hasClass("selected")).toBe(true);expect($($rows[5]).hasClass("selected")).toBe(true);expect($($rows[6]).hasClass("selected")).toBe(true);expect($($rows[7]).hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($laterRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(8);expect(selector._lastSeenIndex).toBe($laterRow[0].rowIndex)})});describe("Removing rows from selection",function(){it("Above",function(){const $prevRow=$rows.eq(3);const prevCell=$prevRow[0].cells[0];selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:prevCell});selector._onMouseOut({relatedTarget:startCell,target:prevCell});selector._onMouseOver({target:startCell});expect($startRow.hasClass("selected")).toBe(true);expect($prevRow.hasClass("selected")).toBe(false);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($startRow[0].rowIndex)});it("Below",function(){const $nextRow=$rows.eq(5);const nextCell=$nextRow[0].cells[0];selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:nextCell});selector._onMouseOut({relatedTarget:startCell,target:nextCell});selector._onMouseOver({target:startCell});expect($startRow.hasClass("selected")).toBe(true);expect($nextRow.hasClass("selected")).toBe(false);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($startRow[0].rowIndex)})});describe("Finishing selection",function(){beforeEach(function(){spyOn(view,"createAndEditCommentBlock")});describe("With single line",function(){let $row;let cell;beforeEach(function(){$row=$($rows[4]);cell=$row[0].cells[0]});it("And existing comment",function(){var onClick=jasmine.createSpy("onClick");$('<a class="commentflag" />').click(onClick).appendTo(cell);selector._onMouseOver({target:cell});selector._onMouseDown({target:cell});selector._onMouseUp({target:cell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).not.toHaveBeenCalled();expect(onClick).toHaveBeenCalled();expect($row.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)});it("And no existing comment",function(){selector._onMouseOver({target:cell});selector._onMouseDown({target:cell});selector._onMouseUp({target:cell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:$row,$endRow:$row,beginLineNum:5,endLineNum:5});expect($row.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)})});describe("With multiple lines",function(){let $startRow;let $endRow;let startCell;let endCell;beforeEach(function(){$startRow=$rows.eq(4);$endRow=$rows.eq(5);startCell=$startRow[0].cells[0];endCell=$endRow[0].cells[0]});xit("And existing comment",function(){const onClick=jasmine.createSpy("onClick");$('<a class="commentflag" />').click(onClick).appendTo(startCell);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:endCell});expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($endRow[0]);$startRow=selector._$begin;$endRow=selector._$end;selector._onMouseUp({target:endCell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:$startRow,$endRow:$endRow,beginLineNum:5,endLineNum:6});expect(onClick).not.toHaveBeenCalled();expect($startRow.hasClass("selected")).toBe(false);expect($endRow.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)});it("And no existing comment",function(){selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:endCell});expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($endRow[0]);$startRow=selector._$begin;$endRow=selector._$end;selector._onMouseUp({target:endCell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:$startRow,$endRow:$endRow,beginLineNum:5,endLineNum:6});expect($startRow.hasClass("selected")).toBe(false);expect($endRow.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)})})})});describe("Hovering",function(){describe("Over line",function(){let $row;let cell;beforeEach(function(){$row=$rows.eq(4)});it("Contents cell",function(){cell=$row[0].cells[1];selector._onMouseOver({target:cell});expect($row.hasClass("selected")).toBe(false);expect(selector._$ghostCommentFlag.css("display")).toBe("none")});describe("Line number cell",function(){beforeEach(function(){cell=$row[0].cells[0]});it("With existing comment on row",function(){$(cell).append('<a class="commentflag" />');selector._onMouseOver({target:cell});expect($row.hasClass("selected")).toBe(true);expect(selector._$ghostCommentFlag.css("display")).toBe("none")});it("With no column flag",function(){selector._onMouseOver({target:cell});expect($row.hasClass("selected")).toBe(true);expect(selector._$ghostCommentFlag.css("display")).not.toBe("none")})})});describe("Out of line",function(){it("Contents cell",function(){var $row=$rows.eq(0);selector._onMouseOver({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).not.toBe("none");selector._onMouseOut({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).toBe("none")});it("Line number cell",function(){var $row=$rows.eq(0);selector._onMouseOver({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).not.toBe("none");expect($row.hasClass("selected")).toBe(true);selector._onMouseOut({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).toBe("none");expect($row.hasClass("selected")).toBe(false)})})})});describe("Incremental expansion",function(){let model;beforeEach(function(){model=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:10,revision:1,file:new RB.DiffFile({index:1})})});describe("Expanding",function(){beforeEach(function(){view=new RB.DiffReviewableView({model:model,el:$(diffTableTemplate({chunks:[{type:"equal",startRow:1,numRows:5},{type:"collapsed",expandHeaderLines:7},{type:"delete",startRow:10,numRows:5}]}))});view.render().$el.appendTo($container)});describe("Fetching fragment",function(){beforeEach(function(){spyOn(model,"getRenderedDiffFragment")});it("Full chunk",function(){view.$(".tests-expand-chunk").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();const options=model.getRenderedDiffFragment.calls.argsFor(0)[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe(undefined)});it("+20 above",function(){view.$(".tests-expand-above").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();const options=model.getRenderedDiffFragment.calls.argsFor(0)[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe("20,0")});it("+20 below",function(){view.$(".tests-expand-below").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();const options=model.getRenderedDiffFragment.calls.argsFor(0)[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe("0,20")});it("Function/class",function(){view.$(".tests-expand-header").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();const options=model.getRenderedDiffFragment.calls.argsFor(0)[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe("0,7")})});describe("Injecting HTML",function(){it("Whole chunk",function(){spyOn(model,"getRenderedDiffFragment").and.callFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td>",'   <div class="collapse-floater">','    <img class="diff-collapse-btn"','         data-chunk-index="1"','         data-lines-of-context="0" />',"   </div>","  </td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").and.callThrough();view.$(".tests-expand-chunk").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();const $tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._centered._elements.size).toBe(1);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")});it("Merging adjacent expanded chunks",function(){spyOn(model,"getRenderedDiffFragment").and.callFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td>",'   <div class="collapse-floater">','    <img class="diff-collapse-btn"','         data-chunk-index="1"','         data-lines-of-context="0" />',"   </div>","  </td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").and.callThrough();$('<tbody class="equal loaded"/>').append($('<img class="diff-collapse-btn" />')).insertAfter(view.$("tbody")[1]).clone().insertBefore(view.$("tbody")[1]);expect(view.$("tbody").length).toBe(5);view.$(".tests-expand-chunk").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();const $tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._centered._elements.size).toBe(1);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")})})});describe("Collapsing",function(){let $collapseButton;beforeEach(function(){view=new RB.DiffReviewableView({model:model,el:$(diffTableTemplate({chunks:[{type:"equal",startRow:1,numRows:5},{type:"equal",expanded:true,startRow:6,numRows:2},{type:"delete",startRow:10,numRows:5}]}))});view.render().$el.appendTo($container);$collapseButton=view.$(".diff-collapse-btn")});it("Fetching fragment",function(){spyOn(model,"getRenderedDiffFragment");$collapseButton.click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();const options=model.getRenderedDiffFragment.calls.argsFor(0)[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe(0)});describe("Injecting HTML",function(){it("Single expanded chunk",function(){spyOn(model,"getRenderedDiffFragment").and.callFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td></td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").and.callThrough();$collapseButton.click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();const $tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._centered._elements.size).toBe(0);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")});it("Merging adjacent expanded chunks",function(){var $tbodies;spyOn(model,"getRenderedDiffFragment").and.callFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td></td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").and.callThrough();$('<tbody class="equal loaded"/>').append($('<img class="diff-collapse-btn" />')).insertAfter(view.$("tbody")[1]).clone().insertBefore(view.$("tbody")[1]);$collapseButton.click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();$tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._centered._elements.size).toBe(0);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")})})})});describe("Comment flags",function(){describe("Placing visible comments",function(){const expandedDiffFragmentHTML=`<tbody class="equal tests-new-chunk">
 <tr line="11">
  <th></th>
  <td>
   <div class="collapse-floater">
    <img class="diff-collapse-btn"
         data-chunk-index="1"
         data-lines-of-context="0" />
   </div>
  </td>
  <th></th>
  <td></td>
 </tr>
</tbody>`;let $commentFlag;let $commentFlags;let $rows;let diffFragmentHTML;beforeEach(function(){view=new RB.DiffReviewableView({model:new RB.DiffReviewable({reviewRequest:reviewRequest,serializedCommentBlocks:[{linenum:2,num_lines:2,comments:[{issue_opened:false,review_id:1,localdraft:false,text:"Comment 1",comment_id:1,user:{name:"testuser"},line:2}]},{linenum:4,num_lines:1,comments:[{issue_opened:false,review_id:1,localdraft:false,text:"Comment 2",comment_id:1,user:{name:"testuser"},line:4},{issue_opened:false,review_id:1,localdraft:false,text:"Comment 3",comment_id:1,user:{name:"testuser"},line:4}]},{linenum:11,num_lines:1,comments:[{issue_opened:false,review_id:1,localdraft:false,text:"Comment 4",comment_id:1,user:{name:"testuser"},line:12}]}]}),el:$(diffTableTemplate({chunks:[{type:"insert",startRow:1,numRows:10},{type:"collapsed",expandHeaderLines:7}]}))});view.render().$el.appendTo($container);diffFragmentHTML=expandedDiffFragmentHTML;spyOn(view.model,"getRenderedDiffFragment").and.callFake(function(options,callbacks,context){callbacks.success.call(context,diffFragmentHTML)});$commentFlags=view.$(".commentflag");$rows=view.$el.find("tbody tr")});it("On initial render",function(){expect($commentFlags.length).toBe(2);expect($($commentFlags[0]).find(".commentflag-count").text()).toBe("1");expect($($commentFlags[1]).find(".commentflag-count").text()).toBe("2");$commentFlag=$($rows[1]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[0]);expect($commentFlag.parents("tr").attr("line")).toBe("2");$commentFlag=$($rows[3]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[1]);expect($commentFlag.parents("tr").attr("line")).toBe("4")});it("On chunk expand",function(){expect($commentFlags.length).toBe(2);view.$(".tests-expand-chunk").click();$commentFlags=view.$(".commentflag");$rows=view.$el.find("tbody tr");expect($commentFlags.length).toBe(3);expect($($commentFlags[2]).find(".commentflag-count").text()).toBe("1");$commentFlag=$($rows[10]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[2]);expect($commentFlag.parents("tr").attr("line")).toBe("11")});it("On chunk re-expand (after collapsing)",function(){const collapsedDiffFragmentHTML=['<tbody class="diff-header">',$(view.$("tbody")[1]).html(),"</tbody>"].join("");expect($commentFlags.length).toBe(2);view.$(".tests-expand-chunk").click();expect(view.$(".commentflag").length).toBe(3);diffFragmentHTML=collapsedDiffFragmentHTML;view.$(".diff-collapse-btn").click();expect(view.$(".commentflag").length).toBe(2);diffFragmentHTML=expandedDiffFragmentHTML;view.$(".tests-expand-chunk").click();expect(view.$(".commentflag").length).toBe(3);$commentFlags=view.$(".commentflag");$rows=view.$el.find("tbody tr");expect($commentFlags.length).toBe(3);expect($($commentFlags[2]).find(".commentflag-count").text()).toBe("1");$commentFlag=$($rows[10]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[2]);expect($commentFlag.parents("tr").attr("line")).toBe("11")})})});describe("Methods",function(){describe("toggleWhitespaceOnlyChunks",function(){beforeEach(function(){view=new RB.DiffReviewableView({model:new RB.DiffReviewable({reviewRequest:reviewRequest}),el:$(diffTableTemplate({chunks:[{type:"replace",startRow:1,numRows:5,extraClass:"whitespace-chunk"}]}))});view.render().$el.appendTo($container)});describe("Toggle on",function(){it("Chunk classes",function(){let $tbodies;let $tbody;let $children;view.toggleWhitespaceOnlyChunks();$tbodies=view.$("tbody");$tbody=$($tbodies[0]);$children=$tbody.children();expect($tbody.hasClass("replace")).toBe(false);expect($($children[0]).hasClass("first")).toBe(true);expect($($children[$children.length-1]).hasClass("last")).toBe(true)});it("chunkDimmed event triggered",function(){spyOn(view,"trigger");view.toggleWhitespaceOnlyChunks();expect(view.trigger).toHaveBeenCalledWith("chunkDimmed","0.0")});it("Whitespace-only file classes",function(){const $tbodies=view.$el.children("tbody");const $whitespaceChunk=$("<tbody/>").addClass("whitespace-file").hide().html("<tr><td></td></tr>").appendTo(view.$el);expect($whitespaceChunk.is(":visible")).toBe(false);expect($tbodies.is(":visible")).toBe(true);view.toggleWhitespaceOnlyChunks();expect($whitespaceChunk.is(":visible")).toBe(true);expect($tbodies.is(":visible")).toBe(false)})});describe("Toggle off",function(){it("Chunk classes",function(){let $tbodies;let $tbody;let $children;view.toggleWhitespaceOnlyChunks();view.toggleWhitespaceOnlyChunks();$tbodies=view.$("tbody");$tbody=$($tbodies[0]);$children=$tbody.children();expect($tbody.hasClass("replace")).toBe(true);expect($($children[0]).hasClass("first")).toBe(false);expect($($children[$children.length-1]).hasClass("last")).toBe(false)});it("chunkDimmed event triggered",function(){view.toggleWhitespaceOnlyChunks();spyOn(view,"trigger");view.toggleWhitespaceOnlyChunks();expect(view.trigger).toHaveBeenCalledWith("chunkUndimmed","0.0")});it("Whitespace-only file classes",function(){const $tbodies=view.$el.children("tbody");const $whitespaceChunk=$("<tbody/>").addClass("whitespace-file").html("<tr><td></td></tr>").hide().appendTo(view.$el);expect($whitespaceChunk.is(":visible")).toBe(false);expect($tbodies.is(":visible")).toBe(true);view.toggleWhitespaceOnlyChunks();view.toggleWhitespaceOnlyChunks();expect($whitespaceChunk.is(":visible")).toBe(false);expect($tbodies.is(":visible")).toBe(true)})})})})});"use strict";suite("rb/models/CommentEditor",function(){let editor;let reviewRequest;let comment;function createComment(){return new RB.BaseComment({parentObject:new RB.BaseResource({public:true})})}beforeEach(function(){reviewRequest=new RB.ReviewRequest;editor=new RB.CommentEditor({canEdit:true,reviewRequest:reviewRequest})});describe("Attribute defaults",function(){describe("canEdit",function(){it("When logged in and hasDraft=false",function(){RB.UserSession.instance.set("authenticated",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(true)});it("When logged in and hasDraft=true",function(){RB.UserSession.instance.set("authenticated",true);reviewRequest.set("hasDraft",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(false)});it("When logged out",function(){RB.UserSession.instance.set("authenticated",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(false)});it("With explicitly set value",function(){RB.UserSession.instance.set("authenticated",false);editor=new RB.CommentEditor({canEdit:true,reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(true)})});describe("openIssue",function(){it("When user preference is true",function(){RB.UserSession.instance.set("commentsOpenAnIssue",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(true)});it("When user preference is false",function(){RB.UserSession.instance.set("commentsOpenAnIssue",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(false)});it("With explicitly set value",function(){RB.UserSession.instance.set("commentsOpenAnIssue",false);editor=new RB.CommentEditor({openIssue:true,reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(true)});it("When reloading the page with explicitly set value",function(){RB.UserSession.instance.set("commentsOpenAnIssue",true);comment=createComment();comment.set({loaded:false,issueOpened:false});editor=new RB.CommentEditor({comment:comment,reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(false)})});describe("richText",function(){it("When user preference is true",function(){RB.UserSession.instance.set("defaultUseRichText",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("richText")).toBe(true)});it("When user preference is false",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("richText")).toBe(false)});it("With explicitly set value",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor=new RB.CommentEditor({richText:true,reviewRequest:reviewRequest});expect(editor.get("richText")).toBe(true)})})});describe("Loading comment",function(){describe("With comment richText=true",function(){let comment;beforeEach(function(){comment=createComment();comment.set({id:123,loaded:true,richText:true,text:"<p>this _is_ a <em>test</em></p>",rawTextFields:{text:"this \\_is\\_ a _test_"},markdownTextFields:{text:"this \\_is\\_ a _test_"}})});it("When defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(true);expect(editor.get("text")).toBe("this \\_is\\_ a _test_")});it("When defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(true);expect(editor.get("text")).toBe("this \\_is\\_ a _test_")})});describe("With comment richText=false",function(){let comment;beforeEach(function(){comment=createComment();comment.set({id:123,loaded:true,richText:false,text:"<p>this _is_ a test</p>",rawTextFields:{text:"this _is_ a _test_"},markdownTextFields:{text:"this \\_is\\_ a \\_test\\_"}})});it("When defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(true);expect(editor.get("text")).toBe("this \\_is\\_ a \\_test\\_")});it("When defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(false);expect(editor.get("text")).toBe("this _is_ a _test_")})})});describe("Capability states",function(){describe("canDelete",function(){it("When not editing",function(){expect(editor.get("editing")).toBe(false);expect(editor.get("canDelete")).toBe(false)});it("When editing new comment",function(){editor.set("comment",createComment());editor.beginEdit();expect(editor.get("canDelete")).toBe(false)});it("When editing existing comment",function(){const comment=createComment();comment.set({id:123,loaded:true});editor.set("comment",comment);editor.beginEdit();expect(editor.get("canDelete")).toBe(true)});it("When editing existing comment with canEdit=false",function(){const comment=createComment();comment.set({id:123,loaded:true});editor.set({canEdit:false,comment:comment});expect(()=>editor.beginEdit()).toThrow();expect(console.assert).toHaveBeenCalled();expect(editor.get("canDelete")).toBe(false)})});describe("canSave",function(){it("When not editing",function(){expect(editor.get("editing")).toBe(false);expect(editor.get("canSave")).toBe(false)});it("When editing comment with text",function(){const comment=createComment();editor.set("comment",comment);editor.beginEdit();editor.set("text","Foo");expect(editor.get("canSave")).toBe(true)});it("When editing comment with initial state",function(){const comment=createComment();editor.set("comment",comment);editor.beginEdit();expect(editor.get("canSave")).toBe(false)});it("When editing comment without text",function(){const comment=createComment();editor.set("comment",comment);editor.beginEdit();editor.set("text","");expect(editor.get("canSave")).toBe(false)})})});describe("States",function(){describe("dirty",function(){it("Initial state",function(){expect(editor.get("dirty")).toBe(false)});it("After new comment",function(){const comment=createComment();editor.set("dirty",true);editor.set("comment",comment);expect(editor.get("dirty")).toBe(false)});it("After text change",function(){editor.set("comment",createComment());editor.beginEdit();editor.set("text","abc");expect(editor.get("dirty")).toBe(true)});it("After toggling Open Issue",function(){editor.set("comment",createComment());editor.beginEdit();editor.set("openIssue","true");expect(editor.get("dirty")).toBe(true)});it("After saving",function(){const comment=createComment();editor.set("comment",comment);editor.beginEdit();editor.set("text","abc");expect(editor.get("dirty")).toBe(true);spyOn(comment,"save").and.callFake((callbacks,context)=>callbacks.success.call(context));editor.save();expect(editor.get("dirty")).toBe(false)});it("After deleting",function(){const comment=createComment();comment.set({id:123,loaded:true});editor.set("comment",comment);editor.beginEdit();editor.set("text","abc");expect(editor.get("dirty")).toBe(true);spyOn(comment,"destroy").and.callFake((callbacks,context)=>{if(callbacks&&callbacks.success){callbacks.success.call(context)}});editor.deleteComment();expect(editor.get("dirty")).toBe(false)})})});describe("Operations",function(){it("setExtraData",function(){editor.setExtraData("key1","strvalue");editor.setExtraData("key2",42);expect(editor.get("extraData")).toEqual({key1:"strvalue",key2:42})});it("getExtraData",function(){editor.set("extraData",{mykey:"value"});expect(editor.getExtraData("mykey")).toBe("value")});describe("beginEdit",function(){it("With canEdit=true",function(){editor.set({comment:createComment(),canEdit:true});editor.beginEdit();expect(console.assert.calls.argsFor(0)[0]).toBeTruthy()});it("With canEdit=false",function(){editor.set({comment:createComment(),canEdit:false});expect(function(){editor.beginEdit()}).toThrow();expect(console.assert.calls.argsFor(0)[0]).toBeFalsy()});it("With no comment",function(){expect(function(){editor.beginEdit()}).toThrow();expect(console.assert.calls.argsFor(0)[0]).toBeTruthy();expect(console.assert.calls.argsFor(1)[0]).toBeFalsy()})});describe("cancel",function(){beforeEach(function(){spyOn(editor,"close");spyOn(editor,"trigger")});it("With comment",function(){const comment=createComment();spyOn(comment,"destroyIfEmpty");editor.set("comment",comment);editor.cancel();expect(comment.destroyIfEmpty).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("canceled");expect(editor.close).toHaveBeenCalled()});it("Without comment",function(){editor.cancel();expect(editor.trigger).not.toHaveBeenCalledWith("canceled");expect(editor.close).toHaveBeenCalled()})});describe("destroy",function(){let comment;beforeEach(function(){comment=createComment();spyOn(comment,"destroy").and.callFake((callbacks,context)=>{if(callbacks&&callbacks.success){callbacks.success.call(context)}});spyOn(editor,"close");spyOn(editor,"trigger")});it("With canDelete=false",function(){editor.set("comment",comment);editor.set("canDelete",false);expect(()=>editor.deleteComment()).toThrow();expect(console.assert.calls.argsFor(0)[0]).toBeFalsy();expect(comment.destroy).not.toHaveBeenCalled();expect(editor.trigger).not.toHaveBeenCalledWith("deleted");expect(editor.close).not.toHaveBeenCalled()});it("With canDelete=true",function(){editor.set("comment",comment);editor.set("canDelete",true);editor.deleteComment();expect(console.assert.calls.argsFor(0)[0]).toBeTruthy();expect(comment.destroy).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("deleted");expect(editor.close).toHaveBeenCalled()})});describe("save",function(){let comment;beforeEach(function(){comment=createComment();spyOn(comment,"save").and.callFake(options=>{if(options&&options.success){options.success()}});spyOn(editor,"trigger")});it("With canSave=false",function(){editor.set("comment",comment);editor.set("canSave",false);expect(()=>editor.save()).toThrow();expect(console.assert.calls.argsFor(0)[0]).toBeFalsy();expect(comment.save).not.toHaveBeenCalled();expect(editor.trigger).not.toHaveBeenCalledWith("saved")});it("With canSave=true",function(){const text="My text";const issueOpened=true;comment.set("issueOpened",false);editor.set("comment",comment);editor.set({text:text,issue_opened:issueOpened,canSave:true,richText:true});editor.setExtraData("mykey","myvalue");editor.save();expect(console.assert.calls.argsFor(0)[0]).toBeTruthy();expect(comment.save).toHaveBeenCalled();expect(comment.get("text")).toBe(text);expect(comment.get("issueOpened")).toBe(issueOpened);expect(comment.get("richText")).toBe(true);expect(comment.get("extraData")).toEqual({mykey:"myvalue",require_verification:false});expect(editor.get("dirty")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("saved")})})})});"use strict";suite("rb/models/ExtraData",function(){let model;beforeEach(function(){const Resource=Backbone.Model.extend(_.defaults({defaults(){return{extraData:{}}},initialize(){this._setupExtraData()}},RB.ExtraDataMixin));model=new Resource});it("change events fired",function(){const callbacks={change:function(){},"change:extraData":function(){}};spyOn(callbacks,"change");spyOn(callbacks,"change:extraData");model.on("change",callbacks.change);model.on("change:extraData",callbacks["change:extraData"]);model.setExtraData("foo",1);expect(callbacks.change).toHaveBeenCalled();expect(callbacks["change:extraData"]).toHaveBeenCalled()});it("attributes updated",function(){const oldExtraData=model.attributes.extraData;expect(model.extraData.attributes).toBe(oldExtraData);model.set({extraData:{foo:1}});expect(model.attributes.extraData).toEqual({foo:1});expect(model.extraData.attributes).toEqual({foo:1});expect(model.extraData.attributes).not.toBe(oldExtraData);expect(model.attributes.extraData).not.toBe(oldExtraData);expect(model.extraData.attributes).toBe(model.attributes.extraData)})});"use strict";suite("rb/models/ReviewRequestEditor",function(){let reviewRequest;let editor;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:1});editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest})});describe("Methods",function(){describe("createFileAttachment",function(){it("With new FileAttachment",function(){const fileAttachments=editor.get("fileAttachments");expect(fileAttachments.length).toBe(0);const fileAttachment=editor.createFileAttachment();expect(fileAttachments.length).toBe(1);expect(fileAttachments.at(0)).toBe(fileAttachment)})});describe("decr",function(){it("With integer attribute",function(){editor.set("myint",1);editor.decr("myint");expect(editor.get("myint")).toBe(0)});it("With non-integer attribute",function(){editor.set("foo","abc");expect(()=>editor.decr("foo")).toThrow();expect(console.assert).toHaveBeenCalled();expect(console.assert.calls.mostRecent().args[0]).toBe(false);expect(editor.get("foo")).toBe("abc")});describe("editCount",function(){it("When > 0",function(){editor.set("editCount",1);editor.decr("editCount");expect(editor.get("editCount")).toBe(0);expect(editor.validationError).toBe(null)});it("When 0",function(){editor.set("editCount",0);editor.decr("editCount");expect(editor.get("editCount")).toBe(0);expect(editor.validationError).toBe(RB.ReviewRequestEditor.strings.UNBALANCED_EDIT_COUNT)})})});describe("incr",function(){it("With integer attribute",function(){editor.set("myint",0);editor.incr("myint");expect(editor.get("myint")).toBe(1)});it("With non-integer attribute",function(){editor.set("foo","abc");expect(()=>editor.incr("foo")).toThrow();expect(console.assert).toHaveBeenCalled();expect(console.assert.calls.mostRecent().args[0]).toBe(false);expect(editor.get("foo")).toBe("abc")})});describe("getDraftField",function(){it("For closeDescription",function(){reviewRequest.set("closeDescription","Test");const value=editor.getDraftField("closeDescription");expect(value).toBe("Test")});it("For closeDescriptionRichText",function(){reviewRequest.set("closeDescriptionRichText",true);const value=editor.getDraftField("closeDescriptionRichText");expect(value).toBe(true)});it("For draft fields",function(){reviewRequest.draft.set("description","Test");const value=editor.getDraftField("description");expect(value).toBe("Test")});it("With useExtraData",function(){const extraData=reviewRequest.draft.get("extraData");extraData.foo="**Test**";const value=editor.getDraftField("foo",{useExtraData:true});expect(value).toBe("**Test**")});describe("With useExtraData and useRawTextValue",function(){it("With field in rawTextFields",function(){const draft=reviewRequest.draft;const extraData=reviewRequest.draft.get("extraData");extraData.foo="<b>Test</b>";draft.set("rawTextFields",{extra_data:{foo:"**Test**"}});const value=editor.getDraftField("foo",{useExtraData:true,useRawTextValue:true});expect(value).toBe("**Test**")});it("With field not in rawTextFields",function(){const extraData=reviewRequest.draft.get("extraData");extraData.foo="<b>Test</b>";const value=editor.getDraftField("foo",{useExtraData:true,useRawTextValue:true});expect(value).toBe("<b>Test</b>")})})});describe("setDraftField",function(){let callbacks;let draft;beforeEach(function(){callbacks={error:function(){},success:function(){}};spyOn(callbacks,"error");spyOn(callbacks,"success");draft=editor.get("reviewRequest").draft});describe("When publishing",function(){beforeEach(function(){spyOn(editor,"publishDraft");editor.set({publishing:true,pendingSaveCount:1})});it("Successful saves",function(){spyOn(draft,"save").and.callFake((options,context)=>options.success.call(context));editor.setDraftField("summary","My Summary",_.defaults({jsonFieldName:"summary"},callbacks));expect(callbacks.success).toHaveBeenCalled();expect(editor.get("publishing")).toBe(false);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled()});it("Field set errors",function(){spyOn(draft,"save").and.callFake((options,context)=>options.error.call(context,draft,{errorPayload:{fields:{summary:["Something went wrong"]}}}));editor.setDraftField("summary","My Summary",_.defaults({jsonFieldName:"summary"},callbacks));expect(callbacks.error).toHaveBeenCalled();expect(editor.get("publishing")).toBe(false);expect(editor.get("pendingSaveCount")).toBe(1);expect(editor.publishDraft).not.toHaveBeenCalled()})});describe("Rich text fields",function(){describe("changeDescription",function(){describe("Draft description",function(){function testDraftDescription(richText,textType){spyOn(reviewRequest,"close");spyOn(reviewRequest.draft,"save");editor.setDraftField("changeDescription","My description",{allowMarkdown:true,fieldID:"changedescription",richText:richText,jsonFieldName:"changedescription",jsonTextTypeFieldName:"changedescription_text_type"});expect(reviewRequest.close).not.toHaveBeenCalled();expect(reviewRequest.draft.save).toHaveBeenCalled();expect(reviewRequest.draft.save.calls.argsFor(0)[0].data).toEqual({changedescription_text_type:textType,changedescription:"My description",force_text_type:"html",include_text_types:"raw"})}it("For Markdown",function(){testDraftDescription(true,"markdown")});it("For plain text",function(){testDraftDescription(false,"plain")})})})});describe("Special list fields",function(){describe("targetGroups",function(){it("Empty",function(){spyOn(draft,"save").and.callFake((options,context)=>options.success.call(context));editor.setDraftField("targetGroups","",_.defaults({jsonFieldName:"target_groups"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With values",function(){spyOn(draft,"save").and.callFake((options,context)=>options.success.call(context));editor.setDraftField("targetGroups","group1, group2",_.defaults({jsonFieldName:"target_groups"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With invalid groups",function(){spyOn(draft,"save").and.callFake((options,context)=>options.error.call(context,draft,{errorPayload:{fields:{target_groups:["group1","group2"]}}}));editor.setDraftField("targetGroups","group1, group2",_.defaults({jsonFieldName:"target_groups"},callbacks));expect(callbacks.error).toHaveBeenCalledWith({errorText:'Groups "group1" and "group2" do '+"not exist."})})});describe("targetPeople",function(){it("Empty",function(){spyOn(draft,"save").and.callFake((options,context)=>options.success.call(context));editor.setDraftField("targetPeople","",_.defaults({jsonFieldName:"target_people"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With values",function(){spyOn(draft,"save").and.callFake((options,context)=>options.success.call(context));editor.setDraftField("targetPeople","user1, user2",_.defaults({jsonFieldName:"target_people"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With invalid users",function(){spyOn(draft,"save").and.callFake((options,context)=>options.error.call(context,draft,{errorPayload:{fields:{target_people:["user1","user2"]}}}));editor.setDraftField("targetPeople","user1, user2",_.defaults({jsonFieldName:"target_people"},callbacks));expect(callbacks.error).toHaveBeenCalledWith({errorText:'Users "user1" and "user2" do not exist.'})})});describe("submitter",function(){it("Empty",function(){spyOn(draft,"save").and.callFake((options,context)=>options.success.call(context));editor.setDraftField("submitter","",_.defaults({jsonFieldName:"submitter"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With value",function(){spyOn(draft,"save").and.callFake((options,context)=>options.success.call(context));editor.setDraftField("submitter","user1",_.defaults({jsonFieldName:"submitter"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With invalid user",function(){spyOn(draft,"save").and.callFake((options,context)=>options.error.call(context,draft,{errorPayload:{fields:{submitter:["user1"]}}}));editor.setDraftField("submitter","user1",_.defaults({jsonFieldName:"submitter"},callbacks));expect(callbacks.error).toHaveBeenCalledWith({errorText:'User "user1" does not exist.'})})})});describe("Custom fields",function(){describe("Rich text fields",function(){function testFields(richText,textType){spyOn(reviewRequest.draft,"save");editor.setDraftField("myField","Test text.",{allowMarkdown:true,useExtraData:true,fieldID:"myfield",richText:richText,jsonFieldName:"myfield",jsonTextTypeFieldName:"myfield_text_type"});expect(reviewRequest.draft.save).toHaveBeenCalled();expect(reviewRequest.draft.save.calls.argsFor(0)[0].data).toEqual({"extra_data.myfield_text_type":textType,"extra_data.myfield":"Test text.",force_text_type:"html",include_text_types:"raw"})}it("For Markdown",function(){testFields(true,"markdown")});it("For plain text",function(){testFields(false,"plain")})})})})});describe("Reviewed objects",function(){describe("File attachments",function(){it("Removed when destroyed",function(done){const fileAttachments=editor.get("fileAttachments");const fileAttachment=editor.createFileAttachment();const draft=editor.get("reviewRequest").draft;spyOn(draft,"ensureCreated").and.callFake((options,context)=>options.success.call(context));expect(fileAttachments.at(0)).toBe(fileAttachment);fileAttachment.destroy({success:function(){expect(fileAttachments.length).toBe(0);done()}})})});describe("Screenshots",function(){it("Removed when destroyed",function(done){const screenshots=editor.get("screenshots");const screenshot=reviewRequest.createScreenshot();screenshots.add(screenshot);expect(screenshots.at(0)).toBe(screenshot);screenshot.destroy({success:()=>{expect(screenshots.length).toBe(0);done()}})})})});describe("Events",function(){describe("saved",function(){it("When new file attachment saved",function(){const fileAttachment=editor.createFileAttachment();spyOn(editor,"trigger");fileAttachment.trigger("saved");expect(editor.trigger).toHaveBeenCalledWith("saved")});it("When new file attachment destroyed",function(done){const fileAttachment=editor.createFileAttachment();const draft=editor.get("reviewRequest").draft;spyOn(draft,"ensureCreated").and.callFake((options,context)=>options.success.call(context));spyOn(editor,"trigger");fileAttachment.destroy({success:()=>{expect(editor.trigger).toHaveBeenCalledWith("saved");done()}})});it("When existing file attachment saved",function(){const fileAttachment=reviewRequest.draft.createFileAttachment();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,fileAttachments:new Backbone.Collection([fileAttachment])});spyOn(editor,"trigger");fileAttachment.trigger("saved");expect(editor.trigger).toHaveBeenCalledWith("saved")});it("When existing file attachment destroyed",function(done){const fileAttachment=reviewRequest.draft.createFileAttachment();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,fileAttachments:new Backbone.Collection([fileAttachment])});spyOn(reviewRequest.draft,"ensureCreated").and.callFake((options,context)=>options.success.call(context));spyOn(editor,"trigger");fileAttachment.destroy({success:()=>{expect(editor.trigger).toHaveBeenCalledWith("saved");done()}})});it("When existing screenshot saved",function(){const screenshot=reviewRequest.createScreenshot();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,screenshots:new Backbone.Collection([screenshot])});spyOn(editor,"trigger");screenshot.trigger("saved");expect(editor.trigger).toHaveBeenCalledWith("saved")});it("When existing screenshot destroyed",function(done){const screenshot=reviewRequest.createScreenshot();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,screenshots:new Backbone.Collection([screenshot])});spyOn(reviewRequest.draft,"ensureCreated").and.callFake((options,context)=>options.success.call(context));spyOn(editor,"trigger");screenshot.destroy({success:()=>{expect(editor.trigger).toHaveBeenCalledWith("saved");done()}})})});describe("saving",function(){it("When new file attachment saving",function(){const fileAttachment=editor.createFileAttachment();spyOn(editor,"trigger");fileAttachment.trigger("saving");expect(editor.trigger).toHaveBeenCalledWith("saving")});it("When existing file attachment saving",function(){const fileAttachment=reviewRequest.draft.createFileAttachment();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,fileAttachments:new Backbone.Collection([fileAttachment])});spyOn(editor,"trigger");fileAttachment.trigger("saving");expect(editor.trigger).toHaveBeenCalledWith("saving")});it("When screenshot saving",function(){const screenshot=reviewRequest.createScreenshot();editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest,screenshots:new Backbone.Collection([screenshot])});spyOn(editor,"trigger");screenshot.trigger("saving");expect(editor.trigger).toHaveBeenCalledWith("saving")})})})});"use strict";suite("rb/models/uploadDiffModel",function(){let reviewRequest;let updateDiffView;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:123});updateDiffView=new RB.UpdateDiffView({model:new RB.UploadDiffModel({changeNumber:reviewRequest.get("commitID"),repository:reviewRequest.get("repository"),reviewRequest:reviewRequest}),el:$("#scratch")})});describe("Updating Review Requests",function(){it('"Start Over" doesn\'t change reviewRequest attribute',function(){spyOn(updateDiffView.model,"startOver").and.callThrough();updateDiffView.model.startOver();expect(updateDiffView.model.attributes.reviewRequest).toBe(reviewRequest)})})});"use strict";suite("rb/models/UserSession",function(){describe("create",function(){it("Instance is set",function(){RB.UserSession.instance=null;const session=RB.UserSession.create({username:"testuser"});expect(session).toBe(RB.UserSession.instance)});it("Second attempt fails",function(){RB.UserSession.instance=null;RB.UserSession.create({username:"testuser"});expect(console.assert).toHaveBeenCalled();expect(console.assert.calls.argsFor(0)[0]).toBeTruthy();expect(()=>RB.UserSession.create({username:"foo"})).toThrow();expect(console.assert).toHaveBeenCalled();expect(console.assert.calls.argsFor(1)[0]).toBeFalsy()})});describe("Attributes",function(){let session;beforeEach(function(){session=RB.UserSession.instance});describe("diffsShowExtraWhitespace",function(){describe("Loads from cookie",function(){it('When "true"',function(){spyOn($,"cookie").and.returnValue("true");RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser"});expect($.cookie).toHaveBeenCalledWith("show_ew");expect(session.get("diffsShowExtraWhitespace")).toBe(true)});it('When "false"',function(){spyOn($,"cookie").and.returnValue("false");RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser"});expect($.cookie).toHaveBeenCalledWith("show_ew");expect(session.get("diffsShowExtraWhitespace")).toBe(false)})});describe("Sets cookie",function(){beforeEach(function(){spyOn($,"cookie")});it("When true",function(){session.attributes.diffsShowExtraWhitespace=false;session.set("diffsShowExtraWhitespace",true);expect($.cookie).toHaveBeenCalledWith("show_ew","true",{path:SITE_ROOT})});it("When false",function(){session.attributes.diffsShowExtraWhitespace=true;session.set("diffsShowExtraWhitespace",false);expect($.cookie).toHaveBeenCalledWith("show_ew","false",{path:SITE_ROOT})})})})})});"use strict";suite("rb/newReviewRequest/views/BranchesView",function(){let collection;let view;beforeEach(function(){collection=new RB.RepositoryBranches([{name:"master",commit:"8088295174d8d46af7700ddf4522e3a703724106",isDefault:true},{name:"release-1.7.x",commit:"5e6707050f7cb29ed50fafd3b92bffb1e15df19f",isDefault:false},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64",isDefault:false}]);view=new RB.BranchesView({collection:collection})});describe("Rendering",function(){it("With items",function(){view.render();expect(view.$el.html()).toBe('<option selected="selected">master</option>'+"<option>release-1.7.x</option>"+"<option>release-1.6.x</option>")})});describe("Selected event",function(){it("When clicked",function(){view.render();view.on("selected",branch=>{expect(branch.get("name")).toBe("release-1.7.x")});const children=view.$el.children();$(children[0]).attr("selected",false);$(children[1]).attr("selected",true);view.$el.change();expect(view.$el.html()).toBe("<option>master</option>"+'<option selected="selected">release-1.7.x</option>'+"<option>release-1.6.x</option>")})})});"use strict";suite("rb/newReviewRequest/views/PostCommitView",function(){let repository;let commits;let model;let view;beforeEach(function(){repository=new RB.Repository({name:"Repo",supportsPostCommit:true});spyOn(repository.branches,"sync").and.callFake((method,collection,options)=>{options.success({stat:"ok",branches:[{name:"master",commit:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",default:true},{name:"release-1.7.x",commit:"92463764015ef463b4b6d1a1825fee7aeec8cb15",default:false},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64",default:false}]})});spyOn(repository,"getCommits").and.callFake(options=>{commits=new RB.RepositoryCommits([],{urlBase:_.result(this,"url")+"commits/",start:options.start,branch:options.branch});spyOn(commits,"sync").and.callFake((method,collection,options)=>{options.success({stat:"ok",commits:[{authorName:"Author 1",date:"2013-07-22T03:51:50Z",id:"3",message:"Summary 1\n\nMessage 1",parent:"2"},{authorName:"Author 2",date:"2013-07-22T03:50:46Z",id:"2",message:"Summary 2\n\nMessage 2",parent:"1"},{authorName:"Author 3",date:"2013-07-21T08:05:45Z",id:"1",message:"Summary 3\n\nMessage 3",parent:""}]})});return commits});model=new RB.PostCommitModel({repository:repository});view=new RB.PostCommitView({model:model,$scrollContainer:$("<div>")});spyOn(RB.PostCommitView.prototype,"_onCreateReviewRequest").and.callThrough();expect(repository.branches.sync).toHaveBeenCalled()});it("Render",function(){view.render();expect(commits.sync).toHaveBeenCalled();expect(view._branchesView.$el.children().length).toBe(3);expect(view._commitsView.$el.children().length).toBe(3)});it("Create",function(){view.render();spyOn(RB.ReviewRequest.prototype,"save").and.returnValue();const commit=commits.models[1];commit.trigger("create",commit);expect(RB.PostCommitView.prototype._onCreateReviewRequest).toHaveBeenCalled();expect(RB.ReviewRequest.prototype.save).toHaveBeenCalled();expect(RB.ReviewRequest.prototype.save.calls.count()).toBe(1);const call=RB.ReviewRequest.prototype.save.calls.mostRecent();expect(call.object.get("commitID")).toBe(commit.get("id"))});describe("Error handling",function(){describe("Branches",function(){const xhr={errorText:"Oh no"};let returnError;beforeEach(function(){spyOn(repository.branches,"fetch").and.callFake((options,context)=>{if(returnError){options.error.call(context,repository.branches,xhr)}else{options.success.call(context)}});returnError=true;spyOn(RB.PostCommitView.prototype,"_showLoadError").and.callThrough();view._loadBranches()});it("UI state",function(){expect(repository.branches.fetch).toHaveBeenCalled();expect(view._showLoadError).toHaveBeenCalledWith("branches",xhr);expect(view._branchesView.$el.css("display")).toBe("none");expect(view._$error).toBeTruthy();expect(view._$error.length).toBe(1);expect(view._commitsView).toBeFalsy();expect(view._$error.find(".error-text").text().strip()).toBe("Oh no");expect(view._$error.find("a")[0].id).toBe("reload_branches")});it("Reloading",function(){spyOn(view,"_loadBranches").and.callThrough();view.delegateEvents();returnError=false;expect(view._$error).toBeTruthy();const $reload=view._$error.find("#reload_branches");expect($reload.length).toBe(1);$reload.click();expect(view._loadBranches).toHaveBeenCalled();expect(view._$error).toBe(null);expect(view._branchesView.$el.css("display")).not.toBe("none")})});describe("Commits",function(){const xhr={errorText:"Oh no"};let returnError;beforeEach(function(){view.render();spyOn(RB.RepositoryCommits.prototype,"fetch").and.callFake((options,context)=>{if(returnError){options.error.call(context,repository.commits,xhr)}else{options.success.call(context)}});returnError=true;spyOn(RB.PostCommitView.prototype,"_showLoadError").and.callThrough();view._loadCommits()});it("UI state",function(){expect(view._commitsCollection.fetch).toHaveBeenCalled();expect(view._showLoadError).toHaveBeenCalledWith("commits",xhr);expect(view._commitsView.$el.css("display")).toBe("none");expect(view._$error).toBeTruthy();expect(view._$error.length).toBe(1);expect(view._commitsView).toBeTruthy();expect(view._commitsView.$el.css("display")).toBe("none");expect(view._$error.find(".error-text").text().strip()).toBe("Oh no");expect(view._$error.find("a")[0].id).toBe("reload_commits")});it("Reloading",function(){spyOn(view,"_loadCommits").and.callThrough();view.delegateEvents();returnError=false;expect(view._$error).toBeTruthy();const $reload=view._$error.find("#reload_commits");expect($reload.length).toBe(1);$reload.click();expect(view._loadCommits).toHaveBeenCalled();expect(view._$error).toBe(null);const display=view._commitsView.$el.css("display");expect(display==="block"||display==="").toBe(true)})})})});"use strict";suite("rb/newReviewRequest/views/RepositorySelectionView",function(){let collection;let view;beforeEach(function(){collection=new Backbone.Collection([{name:"Bitbucket Test"},{name:"GitHub Test"},{name:"GitLab Test"},{name:"Local Git Test"}],{model:RB.Repository});view=new RB.RepositorySelectionView({collection:collection})});describe("Rendering",function(){it("With items",function(){view.render();const children=view.$el.find(".repository");expect(children.length).toBe(collection.models.length);for(let i=0;i<children.length;i++){const name=collection.models[i].get("name");expect($(children[i]).text().strip()).toBe(name)}})});describe("Selected event",function(){it("When clicked",function(){let handlerCalled=false;view.render();view.on("selected",repository=>{expect(repository.get("name")).toBe("GitHub Test");handlerCalled=true});const children=view.$el.find(".repository");$(children[1]).click();expect(handlerCalled).toBe(true)})})});"use strict";suite("rb/pages/models/DiffViewerPage",function(){describe("parse",function(){it("{}",function(){const page=new RB.DiffViewerPage({},{parse:true});expect(page.get("reviewRequest")).toBeTruthy();expect(page.get("pendingReview")).toBeTruthy();expect(page.get("lastActivityTimestamp")).toBe(null);expect(page.get("checkForUpdates")).toBe(false);expect(page.get("checkUpdatesType")).toBe(null);expect(page.get("numDiffs")).toBe(0);expect(page.commentsHint).not.toBe(null);expect(page.files).not.toBe(null);expect(page.pagination).not.toBe(null);expect(page.revision).not.toBe(null);expect(page.get("editorData")).toBe(undefined);expect(page.get("reviewRequestData")).toBe(undefined)});it("reviewRequestData",function(){const page=new RB.DiffViewerPage({reviewRequestData:{bugTrackerURL:"http://bugs.example.com/--bug_id--/",id:123,localSitePrefix:"s/foo/",branch:"my-branch",bugsClosed:[101,102,103],closeDescription:"This is closed",closeDescriptionRichText:true,description:"This is a description",descriptionRichText:true,hasDraft:true,lastUpdatedTimestamp:"2017-08-23T15:10:20Z",public:true,repository:{id:200,name:"My repo",requiresBasedir:true,requiresChangeNumber:true,scmtoolName:"My Tool",supportsPostCommit:true},reviewURL:"/s/foo/r/123/",state:"CLOSE_SUBMITTED",summary:"This is a summary",targetGroups:[{name:"Some group",url:"/s/foo/groups/some-group/"}],targetPeople:[{username:"some-user",url:"/s/foo/users/some-user/"}],testingDone:"This is testing done",testingDoneRichText:true,visibility:"ARCHIVED"}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("reviewRequestData")).toBe(undefined);const reviewRequest=page.get("reviewRequest");expect(reviewRequest).toBeTruthy();expect(reviewRequest.id).toBe(123);expect(reviewRequest.url()).toBe("/s/foo/api/review-requests/123/");expect(reviewRequest.get("bugTrackerURL")).toBe("http://bugs.example.com/--bug_id--/");expect(reviewRequest.get("localSitePrefix")).toBe("s/foo/");expect(reviewRequest.get("branch")).toBe("my-branch");expect(reviewRequest.get("bugsClosed")).toEqual([101,102,103]);expect(reviewRequest.get("closeDescription")).toBe("This is closed");expect(reviewRequest.get("closeDescriptionRichText")).toBe(true);expect(reviewRequest.get("description")).toBe("This is a description");expect(reviewRequest.get("descriptionRichText")).toBe(true);expect(reviewRequest.get("hasDraft")).toBe(true);expect(reviewRequest.get("lastUpdatedTimestamp")).toBe("2017-08-23T15:10:20Z");expect(reviewRequest.get("public")).toBe(true);expect(reviewRequest.get("reviewURL")).toBe("/s/foo/r/123/");expect(reviewRequest.get("state")).toBe(RB.ReviewRequest.CLOSE_SUBMITTED);expect(reviewRequest.get("summary")).toBe("This is a summary");expect(reviewRequest.get("targetGroups")).toEqual([{name:"Some group",url:"/s/foo/groups/some-group/"}]);expect(reviewRequest.get("targetPeople")).toEqual([{username:"some-user",url:"/s/foo/users/some-user/"}]);expect(reviewRequest.get("testingDone")).toBe("This is testing done");expect(reviewRequest.get("testingDoneRichText")).toBe(true);expect(reviewRequest.get("visibility")).toBe(RB.ReviewRequest.VISIBILITY_ARCHIVED);const repository=reviewRequest.get("repository");expect(repository.id).toBe(200);expect(repository.get("name")).toBe("My repo");expect(repository.get("requiresBasedir")).toBe(true);expect(repository.get("requiresChangeNumber")).toBe(true);expect(repository.get("scmtoolName")).toBe("My Tool");expect(repository.get("supportsPostCommit")).toBe(true)});it("extraReviewRequestDraftData",function(){const page=new RB.DiffViewerPage({extraReviewRequestDraftData:{changeDescription:"Draft change description",changeDescriptionRichText:true,interdiffLink:"/s/foo/r/123/diff/1-2/"}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("reviewRequestData")).toBe(undefined);const draft=page.get("reviewRequest").draft;expect(draft.get("changeDescription")).toBe("Draft change description");expect(draft.get("changeDescriptionRichText")).toBe(true);expect(draft.get("interdiffLink")).toBe("/s/foo/r/123/diff/1-2/")});it("editorData",function(){const page=new RB.DiffViewerPage({editorData:{changeDescriptionRenderedText:"Change description",closeDescriptionRenderedText:"This is closed",hasDraft:true,mutableByUser:true,showSendEmail:true,statusMutableByUser:true}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("editorData")).toBe(undefined);const editor=page.reviewRequestEditor;expect(editor.get("changeDescriptionRenderedText")).toBe("Change description");expect(editor.get("closeDescriptionRenderedText")).toBe("This is closed");expect(editor.get("hasDraft")).toBe(true);expect(editor.get("mutableByUser")).toBe(true);expect(editor.get("showSendEmail")).toBe(true);expect(editor.get("statusMutableByUser")).toBe(true)});it("lastActivityTimestamp",function(){const page=new RB.DiffViewerPage({lastActivityTimestamp:"2017-08-22T18:20:30Z",checkUpdatesType:"diff"},{parse:true});expect(page.get("lastActivityTimestamp")).toBe("2017-08-22T18:20:30Z")});it("checkUpdatesType",function(){const page=new RB.DiffViewerPage({checkUpdatesType:"diff"},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkUpdatesType")).toBe("diff")});it("comments_hint",function(){const page=new RB.DiffViewerPage({comments_hint:{diffsets_with_comments:[{revision:1,is_current:false}],has_other_comments:true,interdiffs_with_comments:[{old_revision:1,new_revision:2,is_current:true}]}},{parse:true});const commentsHint=page.commentsHint;expect(commentsHint.get("hasOtherComments")).toBe(true);expect(commentsHint.get("diffsetsWithComments")).toEqual([{revision:1,isCurrent:false}]);expect(commentsHint.get("interdiffsWithComments")).toEqual([{oldRevision:1,newRevision:2,isCurrent:true}])})});describe("loadDiffRevision",function(){let page;beforeEach(function(){page=new RB.DiffViewerPage({reviewRequestData:{id:123}},{parse:true});spyOn($,"ajax").and.callFake(url=>{const query={};const queryParams=url.split("?")[1].split("&");for(let i=0;i<queryParams.length;i++){const pair=queryParams[i].split("=");query[decodeURIComponent(pair[0])]=decodeURIComponent(pair[1])}return{done:cb=>cb({diff_context:{revision:{revision:query.revision,interdiff_revision:query["interdiff-revision"]||null}}})}})});describe("Generates URL for",function(){it("First page, normal diffs",function(){page.loadDiffRevision({page:1,revision:1});expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/?revision=1")});it("Other page, normal diffs",function(){page.loadDiffRevision({page:2,revision:1});expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/"+"?revision=1&page=2")});it("First page, interdiffs",function(){page.loadDiffRevision({page:1,revision:1,interdiffRevision:2});expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/"+"?revision=1&interdiff-revision=2")});it("Other page, interdiffs",function(){page.loadDiffRevision({page:2,revision:1,interdiffRevision:2});expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/"+"?revision=1&interdiff-revision=2&page=2")});it("Filename patterns",function(){page.loadDiffRevision({page:2,revision:1,filenamePatterns:"*.txt,src/*"});expect($.ajax).toHaveBeenCalledWith("/api/review-requests/123/diff-context/"+"?revision=1&page=2&filenames=*.txt%2Csrc%2F*")})});describe("Sets canDownloadDiff to",function(){it("true for normal diffs",function(){page.loadDiffRevision({revision:1});expect(page.get("canDownloadDiff")).toBe(true)});it("false for interdiffs",function(){page.loadDiffRevision({revision:1,interdiffRevision:2});expect(page.get("canDownloadDiff")).toBe(false)})})})});"use strict";suite("rb/pages/models/PageManager",function(){let pageManager;let page;beforeEach(function(){pageManager=new RB.PageManager;page=new Backbone.View;spyOn(page,"render")});describe("Instance",function(){let callbacks;let expectedRender;beforeEach(function(){expectedRender=false;callbacks={cb:_page=>{expect(_page).toBe(page);expect(pageManager.get("rendered")).toBe(expectedRender)}};spyOn(callbacks,"cb")});describe("Methods",function(){describe("beforeReady",function(){it("Without page set",function(){pageManager.beforeRender(callbacks.cb);expect(callbacks.cb).not.toHaveBeenCalled();pageManager.set("page",page);expect(callbacks.cb).toHaveBeenCalled()});it("With page set, not rendered",function(){pageManager.set("page",page);pageManager.set("rendered",false);pageManager.beforeRender(callbacks.cb);expect(callbacks.cb).toHaveBeenCalled()});it("With page set, rendered",function(){pageManager.set({page:page,rendered:true});expect(()=>pageManager.beforeRender(callbacks.cb)).toThrow();expect(callbacks.cb).not.toHaveBeenCalled()})});describe("ready",function(){it("Without page set",function(){pageManager.ready(callbacks.cb);expect(callbacks.cb).not.toHaveBeenCalled();pageManager.set("page",page);expect(pageManager.get("rendered")).toBe(true);expect(page.render).toHaveBeenCalled();expect(callbacks.cb).toHaveBeenCalled()});it("With page set, not rendered",function(){spyOn(pageManager,"_renderPage");pageManager.set("page",page);expect(pageManager.get("rendered")).toBe(false);expect(page.render).not.toHaveBeenCalled();pageManager.ready(callbacks.cb);expect(callbacks.cb).not.toHaveBeenCalled()});it("With page set, rendered",function(){pageManager.set("page",page);expect(pageManager.get("rendered")).toBe(true);expect(page.render).toHaveBeenCalled();pageManager.ready(callbacks.cb);expect(callbacks.cb).toHaveBeenCalled()})})})});describe("Class methods",function(){let oldInstance;beforeEach(function(){oldInstance=RB.PageManager.instance;RB.PageManager.instance=pageManager});afterEach(function(){RB.PageManager.instance=oldInstance});it("beforeRender",function(){spyOn(RB.PageManager.instance,"beforeRender");RB.PageManager.beforeRender(1,2);expect(RB.PageManager.instance.beforeRender).toHaveBeenCalledWith(1,2)});it("ready",function(){spyOn(RB.PageManager.instance,"ready");RB.PageManager.ready(1,2);expect(RB.PageManager.instance.ready).toHaveBeenCalledWith(1,2)});it("setPage",function(){const page=new Backbone.View;RB.PageManager.setPage(page);expect(pageManager.get("page")).toBe(page)});it("getPage",function(){const page=new Backbone.View;pageManager.set("page",page);expect(RB.PageManager.getPage()).toBe(page)})})});"use strict";suite("rb/pages/models/ReviewablePage",function(){describe("Construction",function(){it("Child objects created",function(){const reviewRequest=new RB.ReviewRequest;const page=new RB.ReviewablePage({reviewRequest:reviewRequest,pendingReview:new RB.Review,editorData:{showSendEmail:false,hasDraft:true}});expect(page.commentIssueManager).toBeTruthy();expect(page.commentIssueManager.get("reviewRequest")).toBe(reviewRequest);expect(page.reviewRequestEditor.get("commentIssueManager")).toBe(page.commentIssueManager);expect(page.reviewRequestEditor.get("reviewRequest")).toBe(reviewRequest);expect(page.reviewRequestEditor.get("showSendEmail")).toBe(false);expect(page.reviewRequestEditor.get("hasDraft")).toBe(true)})});describe("parse",function(){it("{}",function(){const page=new RB.ReviewablePage({},{parse:true});expect(page.get("reviewRequest")).toBeTruthy();expect(page.get("pendingReview")).toBeTruthy();expect(page.get("lastActivityTimestamp")).toBe(null);expect(page.get("checkForUpdates")).toBe(false);expect(page.get("checkUpdatesType")).toBe(null);expect(page.get("editorData")).toBe(undefined);expect(page.get("reviewRequestData")).toBe(undefined)});it("reviewRequestData",function(){const page=new RB.ReviewablePage({reviewRequestData:{bugTrackerURL:"http://bugs.example.com/--bug_id--/",id:123,localSitePrefix:"s/foo/",branch:"my-branch",bugsClosed:[101,102,103],closeDescription:"This is closed",closeDescriptionRichText:true,description:"This is a description",descriptionRichText:true,hasDraft:true,lastUpdatedTimestamp:"2017-08-23T15:10:20Z",public:true,repository:{id:200,name:"My repo",requiresBasedir:true,requiresChangeNumber:true,scmtoolName:"My Tool",supportsPostCommit:true},reviewURL:"/s/foo/r/123/",state:"CLOSE_SUBMITTED",summary:"This is a summary",targetGroups:[{name:"Some group",url:"/s/foo/groups/some-group/"}],targetPeople:[{username:"some-user",url:"/s/foo/users/some-user/"}],testingDone:"This is testing done",testingDoneRichText:true,visibility:"ARCHIVED"}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("reviewRequestData")).toBe(undefined);const reviewRequest=page.get("reviewRequest");expect(reviewRequest).toBeTruthy();expect(reviewRequest.id).toBe(123);expect(reviewRequest.url()).toBe("/s/foo/api/review-requests/123/");expect(reviewRequest.get("bugTrackerURL")).toBe("http://bugs.example.com/--bug_id--/");expect(reviewRequest.get("localSitePrefix")).toBe("s/foo/");expect(reviewRequest.get("branch")).toBe("my-branch");expect(reviewRequest.get("bugsClosed")).toEqual([101,102,103]);expect(reviewRequest.get("closeDescription")).toBe("This is closed");expect(reviewRequest.get("closeDescriptionRichText")).toBe(true);expect(reviewRequest.get("description")).toBe("This is a description");expect(reviewRequest.get("descriptionRichText")).toBe(true);expect(reviewRequest.get("hasDraft")).toBe(true);expect(reviewRequest.get("lastUpdatedTimestamp")).toBe("2017-08-23T15:10:20Z");expect(reviewRequest.get("public")).toBe(true);expect(reviewRequest.get("reviewURL")).toBe("/s/foo/r/123/");expect(reviewRequest.get("state")).toBe(RB.ReviewRequest.CLOSE_SUBMITTED);expect(reviewRequest.get("summary")).toBe("This is a summary");expect(reviewRequest.get("targetGroups")).toEqual([{name:"Some group",url:"/s/foo/groups/some-group/"}]);expect(reviewRequest.get("targetPeople")).toEqual([{username:"some-user",url:"/s/foo/users/some-user/"}]);expect(reviewRequest.get("testingDone")).toBe("This is testing done");expect(reviewRequest.get("testingDoneRichText")).toBe(true);expect(reviewRequest.get("visibility")).toBe(RB.ReviewRequest.VISIBILITY_ARCHIVED);const repository=reviewRequest.get("repository");expect(repository.id).toBe(200);expect(repository.get("name")).toBe("My repo");expect(repository.get("requiresBasedir")).toBe(true);expect(repository.get("requiresChangeNumber")).toBe(true);expect(repository.get("scmtoolName")).toBe("My Tool");expect(repository.get("supportsPostCommit")).toBe(true)});it("extraReviewRequestDraftData",function(){const page=new RB.ReviewablePage({extraReviewRequestDraftData:{changeDescription:"Draft change description",changeDescriptionRichText:true,interdiffLink:"/s/foo/r/123/diff/1-2/"}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("reviewRequestData")).toBe(undefined);const draft=page.get("reviewRequest").draft;expect(draft.get("changeDescription")).toBe("Draft change description");expect(draft.get("changeDescriptionRichText")).toBe(true);expect(draft.get("interdiffLink")).toBe("/s/foo/r/123/diff/1-2/")});it("editorData",function(){const page=new RB.ReviewablePage({editorData:{changeDescriptionRenderedText:"Change description",closeDescriptionRenderedText:"This is closed",hasDraft:true,mutableByUser:true,showSendEmail:true,statusMutableByUser:true}},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkForUpdates")).toBe(false);expect(page.get("editorData")).toBe(undefined);const editor=page.reviewRequestEditor;expect(editor.get("changeDescriptionRenderedText")).toBe("Change description");expect(editor.get("closeDescriptionRenderedText")).toBe("This is closed");expect(editor.get("hasDraft")).toBe(true);expect(editor.get("mutableByUser")).toBe(true);expect(editor.get("showSendEmail")).toBe(true);expect(editor.get("statusMutableByUser")).toBe(true)});it("lastActivityTimestamp",function(){const page=new RB.ReviewablePage({lastActivityTimestamp:"2017-08-22T18:20:30Z",checkUpdatesType:"diff"},{parse:true});expect(page.get("lastActivityTimestamp")).toBe("2017-08-22T18:20:30Z")});it("checkUpdatesType",function(){const page=new RB.ReviewablePage({checkUpdatesType:"diff"},{parse:true});expect(page.get("pendingReview")).toBeTruthy();expect(page.get("checkUpdatesType")).toBe("diff")})});describe("Actions",function(){it("markShipIt",function(){const page=new RB.ReviewablePage({},{parse:true});const pendingReview=page.get("pendingReview");spyOn(pendingReview,"ready").and.callFake(callbacks=>callbacks.ready());spyOn(pendingReview,"publish");page.markShipIt();expect(pendingReview.publish).toHaveBeenCalled();expect(pendingReview.get("shipIt")).toBe(true);expect(pendingReview.get("bodyTop")).toBe("Ship It!")})})});"use strict";suite("rb/pages/views/PageView",function(){const pageSidebarTemplate=`<div class="rb-c-page-sidebar test-page-sidebar">
 <div class="rb-c-page-sidebar__panes">
  <div class="rb-c-page-sidebar__pane -is-shown">
   <div class="rb-c-page-sidebar__pane-content"></div>
  </div>
 </div>
</div>`;let $body;let $headerBar;let $pageSidebar;let $pageContainer;let $pageContent;let pageView;beforeEach(function(){$body=$("<div/>").appendTo($testsScratch);$headerBar=$("<div/>").appendTo($body);$pageContainer=$("<div/>").appendTo($body);$pageContent=$("<div/>").appendTo($pageContainer);$pageSidebar=$(pageSidebarTemplate).appendTo($body);pageView=new RB.PageView({$body:$body,$headerBar:$headerBar,$pageContainer:$pageContainer,$pageContent:$pageContent,$pageSidebar:$pageSidebar})});afterEach(function(){pageView.remove()});describe("Rendering",function(){it("Default state",function(){expect(pageView.isPageRendered).toBe(false);pageView.render();expect(pageView.hasSidebar).toBe(false);expect(pageView.isFullPage).toBe(false);expect(pageView.isPageRendered).toBe(true);expect(pageView.inMobileMode).toBe(false);expect(pageView.headerView).not.toBe(null);expect(pageView.$mainSidebar.length).toBe(1);expect(pageView.$pageContainer.length).toBe(1);expect(pageView.$pageContent.length).toBe(1);expect(pageView._$pageSidebar.length).toBe(1);expect(pageView._$pageSidebarPanes.length).toBe(1);expect(pageView._$mainSidebarPane.length).toBe(1)});describe("With full-page-content",function(){let $mainSidebarPane;beforeEach(function(){$pageContainer.css("display","none");$mainSidebarPane=$pageSidebar.find(".-is-shown").css("display","none")});it("Using body.-is-content-full-page",function(){$body.addClass("-is-content-full-page");pageView.render();expect(pageView.isFullPage).toBe(true);expect($mainSidebarPane.css("display")).toBe("block");expect($pageContainer.css("display")).toBe("block")});it("Using legacy body.full-page-content",function(){$body.addClass("full-page-content");pageView.render();expect(pageView.isFullPage).toBe(true);expect($mainSidebarPane.css("display")).toBe("block");expect($pageContainer.css("display")).toBe("block")})});describe("With sidebar",function(){it("Using body.-has-sidebar",function(){$body.addClass("-has-sidebar");pageView.render();expect(pageView.hasSidebar).toBe(true)});it("Using legacy body.has-sidebar",function(){$body.addClass("has-sidebar");pageView.render();expect(pageView.hasSidebar).toBe(true)})})});describe("Drawers",function(){beforeEach(function(){$body.addClass("-has-sidebar")});describe("Setting drawer",function(){it("In mobile mode",function(){pageView.render();pageView.inMobileMode=true;pageView.setDrawer(new RB.DrawerView);expect($body.children(".rb-c-drawer").length).toBe(1)});it("In desktop mode",function(){pageView.render();pageView.inMobileMode=false;pageView.setDrawer(new RB.DrawerView);const $panes=$pageSidebar.children(".rb-c-page-sidebar__panes");expect($panes.children(".rb-c-drawer").length).toBe(1)})});describe("State changes",function(){let drawer;beforeEach(function(){drawer=new RB.DrawerView;pageView.render();spyOn(pageView,"_updateSize");pageView.setDrawer(drawer);expect(pageView._updateSize).not.toHaveBeenCalled()});it("Showing",function(){drawer.show();expect(pageView._updateSize).toHaveBeenCalled()});it("Hiding",function(){drawer.show();expect(pageView._updateSize).toHaveBeenCalled()})})});describe("Events",function(){describe("mobileModeChanged",function(){let eventHandler;beforeEach(function(){eventHandler=jasmine.createSpy("handler");pageView.render();pageView.on("inMobileModeChanged",eventHandler);spyOn(pageView,"_updateSize");spyOn(pageView,"onMobileModeChanged")});it("To mobile mode",function(){pageView.inMobileMode=false;pageView.headerView.trigger("mobileModeChanged",true);expect(pageView.inMobileMode).toBe(true);expect(pageView._updateSize).toHaveBeenCalled();expect(pageView.onMobileModeChanged).toHaveBeenCalledWith(true);expect(eventHandler).toHaveBeenCalledWith(true)});it("To desktop mode",function(){pageView.inMobileMode=true;pageView.headerView.trigger("mobileModeChanged",false);expect(pageView.inMobileMode).toBe(false);expect(pageView._updateSize).toHaveBeenCalled();expect(pageView.onMobileModeChanged).toHaveBeenCalledWith(false);expect(eventHandler).toHaveBeenCalledWith(false)})});describe("resize",function(){beforeEach(function(){pageView.render();spyOn(pageView,"_updateSize").and.callThrough();spyOn(pageView,"onResize");$pageContainer.css("height","auto");$pageSidebar.css("height","auto");spyOn(pageView.$window,"height").and.callFake(()=>1e3);spyOn($pageContainer,"offset").and.callFake(()=>({top:20,left:0}));spyOn($pageSidebar,"offset").and.callFake(()=>({top:10,left:0}))});describe("In mobile mode",function(){beforeEach(function(){pageView.inMobileMode=true});it("Default state",function(){pageView.$window.triggerHandler("resize");expect(pageView._updateSize).toHaveBeenCalled();expect($pageContainer[0].style.height).toBe("");expect($pageSidebar[0].style.height).toBe("");expect(pageView.onResize).toHaveBeenCalled()});describe("In full-page content mode",function(){let drawer;beforeEach(function(){pageView.isFullPage=true;drawer=new RB.DrawerView;drawer.$el.outerHeight(300)});it("Without drawer",function(){pageView.$window.triggerHandler("resize");expect(pageView._updateSize).toHaveBeenCalled();expect($pageContainer[0].style.height).toBe("980px");expect($pageSidebar[0].style.height).toBe("");expect(pageView.onResize).toHaveBeenCalled()});it("With open drawer",function(){pageView.hasSidebar=true;pageView.setDrawer(drawer);drawer.show();pageView.$window.triggerHandler("resize");expect(pageView._updateSize).toHaveBeenCalled();expect($pageContainer[0].style.height).toBe("680px");expect($pageSidebar[0].style.height).toBe("");expect(pageView.onResize).toHaveBeenCalled()});it("With closed drawer",function(){pageView.hasSidebar=true;pageView.setDrawer(drawer);pageView.$window.triggerHandler("resize");expect(pageView._updateSize).toHaveBeenCalled();expect($pageContainer[0].style.height).toBe("980px");expect($pageSidebar[0].style.height).toBe("");expect(pageView.onResize).toHaveBeenCalled()})})});describe("In desktop mode",function(){beforeEach(function(){pageView.inMobileMode=false});it("Default state",function(){pageView.$window.triggerHandler("resize");expect(pageView._updateSize).toHaveBeenCalled();expect($pageContainer[0].style.height).toBe("");expect($pageSidebar[0].style.height).toBe("");expect(pageView.onResize).toHaveBeenCalled()});it("In full-page content mode",function(){pageView.isFullPage=true;pageView.$window.triggerHandler("resize");expect(pageView._updateSize).toHaveBeenCalled();expect($pageContainer[0].style.height).toBe("980px");expect($pageSidebar[0].style.height).toBe("990px");expect(pageView.onResize).toHaveBeenCalled()})})})})});"use strict";suite("rb/pages/views/DiffViewerPageView",function(){function makeAjaxFn(url,rsp){return function(url){expect(url).toBe(url);return{done(cb){cb(rsp)}}}}const tableTemplate=_.template(`<div class="diff-container">
 <table class="sidebyside">
  <thead>
   <tr class="filename-row">
    <th colspan="4">
     <a name="<%- fileID %>" class="file-anchor"></a>
    </th>
   </tr>
  </thead>
  <% _.each(chunks, function(chunk) { %>
   <tbody class="<%- chunk.type %>">
    <% _.each(chunk.lines, function(line, i) { %>
     <tr line="<%- line.vNumber %>">
      <th>
       <% if (i === 0 && chunk.type !== "equal") { %>
        <a name="<%- chunk.id %>" class="chunk-anchor"></a>
       <% } %>
       <%- line.leftNumber || "" %>
      </th>
      <td class="l"></td>
      <th><%- line.rightNumber || "" %></th>
      <td class="r"></td>
     </tr>
    <% }); %>
   </tbody>
  <% }); %>
 </table>
</div>`);const pageTemplate=`<div>
 <div id="review-banner"></div>
 <div id="diff_commit_list">
  <div class="commit-list-container">
  </div>
 </div>
 <div id="diffs"></div>
</div>`;let page;let pageView;let $diffs;beforeEach(function(){spyOn(window.history,"pushState");spyOn(window.history,"replaceState")});afterEach(function(){RB.DnDUploader.instance=null;Backbone.history.stop()});describe("Without commits",function(){beforeEach(function(){page=new RB.DiffViewerPage({checkForUpdates:false,pagination:{current_page:1},reviewRequestData:{id:123,loaded:true,state:RB.ReviewRequest.PENDING},revision:{revision:1,interdiff_revision:null,is_interdiff:false},editorData:{mutableByUser:true,statusMutableByUser:true}},{parse:true});pageView=new RB.DiffViewerPageView({el:$(pageTemplate).appendTo($testsScratch),model:page});$diffs=pageView.$el.children("#diffs");spyOn(page.get("reviewRequest"),"ready").and.callFake((options,context)=>options.ready.call(context))});describe("Anchors",function(){it("Tracks all types",function(){$diffs.html(tableTemplate({fileID:"file1",chunks:[{id:"1.1",lines:[{type:"insert",vNumber:100,leftNumber:100,rightNumber:101}]},{id:"1.2",lines:[{type:"equal",vNumber:101,leftNumber:101,rightNumber:101}]},{id:"1.3",lines:[{type:"delete",vNumber:102,leftNumber:102,rightNumber:101}]}]}));pageView.render();pageView._updateAnchors(pageView.$el.find("table").eq(0));expect(pageView._$anchors.length).toBe(4);expect(pageView._$anchors[0].name).toBe("file1");expect(pageView._$anchors[1].name).toBe("1.1");expect(pageView._$anchors[2].name).toBe("1.2");expect(pageView._$anchors[3].name).toBe("1.3");expect(pageView._selectedAnchorIndex).toBe(0)});describe("Navigation",function(){beforeEach(function(){$diffs.html([tableTemplate({fileID:"file1",chunks:[{id:"1.1",lines:[{type:"insert",vNumber:100,leftNumber:100,rightNumber:101}]},{id:"1.2",lines:[{type:"equal",vNumber:101,leftNumber:101,rightNumber:101}]}]}),tableTemplate({fileID:"file2",chunks:[]}),tableTemplate({fileID:"file3",chunks:[{id:"2.1",lines:[{type:"insert",vNumber:100,leftNumber:100,rightNumber:101}]},{id:"2.2",lines:[{type:"equal",vNumber:101,leftNumber:101,rightNumber:101}]}]})]);pageView.render();pageView.$el.find("table").each(function(){pageView._updateAnchors($(this))})});describe("Previous file",function(){it("From file",function(){pageView.selectAnchorByName("file2");expect(pageView._selectedAnchorIndex).toBe(3);pageView._selectPreviousFile();expect(pageView._selectedAnchorIndex).toBe(0)});it("From chunk",function(){pageView.selectAnchorByName("2.2");expect(pageView._selectedAnchorIndex).toBe(6);pageView._selectPreviousFile();expect(pageView._selectedAnchorIndex).toBe(4)});it("On first file",function(){pageView.selectAnchorByName("file1");expect(pageView._selectedAnchorIndex).toBe(0);pageView._selectPreviousFile();expect(pageView._selectedAnchorIndex).toBe(0)})});describe("Next file",function(){it("From file",function(){pageView.selectAnchorByName("file1");expect(pageView._selectedAnchorIndex).toBe(0);pageView._selectNextFile();expect(pageView._selectedAnchorIndex).toBe(3)});it("From chunk",function(){pageView.selectAnchorByName("1.1");expect(pageView._selectedAnchorIndex).toBe(1);pageView._selectNextFile();expect(pageView._selectedAnchorIndex).toBe(3)});it("On last file",function(){pageView.selectAnchorByName("file3");expect(pageView._selectedAnchorIndex).toBe(4);pageView._selectNextFile();expect(pageView._selectedAnchorIndex).toBe(4)})});describe("Previous anchor",function(){it("From file to file",function(){pageView.selectAnchorByName("file3");expect(pageView._selectedAnchorIndex).toBe(4);pageView._selectPreviousDiff();expect(pageView._selectedAnchorIndex).toBe(3)});it("From file to chunk",function(){pageView.selectAnchorByName("file2");expect(pageView._selectedAnchorIndex).toBe(3);pageView._selectPreviousDiff();expect(pageView._selectedAnchorIndex).toBe(2)});it("From chunk to file",function(){pageView.selectAnchorByName("2.1");expect(pageView._selectedAnchorIndex).toBe(5);pageView._selectPreviousDiff();expect(pageView._selectedAnchorIndex).toBe(4)});it("From chunk to chunk",function(){pageView.selectAnchorByName("2.2");expect(pageView._selectedAnchorIndex).toBe(6);pageView._selectPreviousDiff();expect(pageView._selectedAnchorIndex).toBe(5)});it("On first file",function(){pageView.selectAnchorByName("file1");expect(pageView._selectedAnchorIndex).toBe(0);pageView._selectPreviousDiff();expect(pageView._selectedAnchorIndex).toBe(0)})});describe("Next anchor",function(){it("From file to file",function(){pageView.selectAnchorByName("file2");expect(pageView._selectedAnchorIndex).toBe(3);pageView._selectNextDiff();expect(pageView._selectedAnchorIndex).toBe(4)});it("From file to chunk",function(){pageView.selectAnchorByName("file1");expect(pageView._selectedAnchorIndex).toBe(0);pageView._selectNextDiff();expect(pageView._selectedAnchorIndex).toBe(1)});it("From chunk to file",function(){pageView.selectAnchorByName("1.2");expect(pageView._selectedAnchorIndex).toBe(2);pageView._selectNextDiff();expect(pageView._selectedAnchorIndex).toBe(3)});it("From chunk to chunk",function(){pageView.selectAnchorByName("2.1");expect(pageView._selectedAnchorIndex).toBe(5);pageView._selectNextDiff();expect(pageView._selectedAnchorIndex).toBe(6)});it("On last chunk",function(){pageView.selectAnchorByName("2.2");expect(pageView._selectedAnchorIndex).toBe(6);pageView._selectNextDiff();expect(pageView._selectedAnchorIndex).toBe(6)})})})});describe("Key bindings",function(){function triggerKeyPress(c){const evt=$.Event("keypress");evt.which=c.charCodeAt(0);pageView.$el.trigger(evt)}function testKeys(description,funcName,keyList){describe(description,function(){keyList.forEach(key=>{let label;let c;if(key.length===2){label=key[0];c=key[1]}else{label="'"+key+"'";c=key}it(label,function(){pageView.render();spyOn(pageView,funcName);triggerKeyPress(c);expect(pageView[funcName]).toHaveBeenCalled()})})})}testKeys("Previous file","_selectPreviousFile",["a","A","K","P","<","m"]);testKeys("Next file","_selectNextFile",["f","F","J","N",">"]);testKeys("Previous anchor","_selectPreviousDiff",["s","S","k","p",","]);testKeys("Next anchor","_selectNextDiff",["d","D","j","n","."]);testKeys("Previous comment","_selectPreviousComment",["[","x"]);testKeys("Next comment","_selectNextComment",["]","c"]);testKeys("Recenter selected","_recenterSelected",[["Enter","\r"]]);testKeys("Create comment","_createComment",["r","R"])});describe("Reviewable Management",function(){beforeEach(function(){spyOn(pageView,"queueLoadDiff");pageView.render()});it("File added",function(){expect($diffs.find(".diff-container").length).toBe(0);expect(pageView.queueLoadDiff.calls.count()).toBe(0);page.files.reset([new RB.DiffFile({id:100,filediff:{id:200,revision:1}})]);expect($diffs.find(".diff-container").length).toBe(1);expect(pageView.queueLoadDiff.calls.count()).toBe(1)});it("Files reset",function(){expect($diffs.find(".diff-container").length).toBe(0);expect(pageView.queueLoadDiff.calls.count()).toBe(0);page.files.reset([new RB.DiffFile({id:100,filediff:{id:200,revision:1}})]);expect($diffs.find(".diff-container").length).toBe(1);expect(pageView.queueLoadDiff.calls.count()).toBe(1);page.files.reset([new RB.DiffFile({id:101,filediff:{id:201,revision:2}})]);const $containers=$diffs.find(".diff-container");expect($containers.length).toBe(1);expect($containers.find(".sidebyside")[0].id).toBe("file_container_101");expect(pageView.queueLoadDiff.calls.count()).toBe(2)})});describe("Page view/URL state",function(){let router;beforeEach(function(){spyOn(page,"loadDiffRevision");spyOn(Backbone.history,"matchRoot").and.returnValue(true);router=pageView.router;spyOn(router,"navigate").and.callFake((url,options)=>{if(!options||options.trigger!==false){Backbone.history.loadUrl(url)}})});describe("Initial URL",function(){it("Initial default load",function(){pageView._setInitialURL("","index_header");expect(router.navigate).toHaveBeenCalledWith("1/#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("Initial load of first page explicit",function(){pageView._setInitialURL("?page=1","index_header");expect(router.navigate).toHaveBeenCalledWith("1/?page=1#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("Initial load of page > 1",function(){pageView._setInitialURL("?page=2","index_header");expect(router.navigate).toHaveBeenCalledWith("1/?page=2#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("Initial load of interdiff",function(){page.revision.set("revision",2);page.revision.set("interdiffRevision",3);pageView._setInitialURL("?page=2","index_header");expect(router.navigate).toHaveBeenCalledWith("2-3/?page=2#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("Initial load with filename patterns",function(){pageView._setInitialURL("?filenames=*.js,src/*","index_header");expect(router.navigate).toHaveBeenCalledWith("1/?filenames=*.js,src/*#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()})});describe("_navigate",function(){beforeEach(function(){page.set("filenamePatterns","*.js,src/*")});it("With page == 1",function(){pageView._navigate({page:1});expect(router.navigate).toHaveBeenCalledWith("1/?filenames=*.js%2Csrc%2F*",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:"*.js,src/*",interdiffRevision:null,page:1,revision:1,tipCommitID:null})});it("With page > 1",function(){pageView._navigate({page:2});expect(router.navigate).toHaveBeenCalledWith("1/?page=2&filenames=*.js%2Csrc%2F*",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:"*.js,src/*",interdiffRevision:null,page:2,revision:1,tipCommitID:null})});it("New revision on page > 1",function(){page.pagination.set("currentPage",2);pageView._onRevisionSelected([0,2]);expect(router.navigate).toHaveBeenCalledWith("2/?filenames=*.js%2Csrc%2F*",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:"*.js,src/*",interdiffRevision:null,page:1,revision:2,tipCommitID:null})});it("Same revision on page > 1",function(){page.pagination.set("currentPage",2);pageView._navigate({revision:1});expect(router.navigate).toHaveBeenCalledWith("1/?page=2&filenames=*.js%2Csrc%2F*",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:"*.js,src/*",interdiffRevision:null,page:2,revision:1,tipCommitID:null})});it("With updateURLOnly",function(){page.pagination.set("currentPage",2);pageView._navigate({revision:2,interdiffRevision:3,updateURLOnly:true});expect(router.navigate).toHaveBeenCalledWith("2-3/?filenames=*.js%2Csrc%2F*",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("With anchor",function(){pageView._navigate({anchor:"test"});expect(router.navigate).toHaveBeenCalledWith("1/?filenames=*.js%2Csrc%2F*#test",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:"*.js,src/*",interdiffRevision:null,page:1,revision:1,tipCommitID:null})})});describe("Revision selector",function(){describe("New diff revision selected",function(){it("From single revision",function(){pageView._onRevisionSelected([0,2]);expect(router.navigate).toHaveBeenCalledWith("2/",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:2,tipCommitID:null})});it("From interdiff revision",function(){page.revision.set("interdiffRevision",2);pageView._onRevisionSelected([0,2]);expect(router.navigate).toHaveBeenCalledWith("2/",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:2,tipCommitID:null})})});it("New interdiff revision selected",function(){pageView._onRevisionSelected([2,5]);expect(router.navigate).toHaveBeenCalledWith("2-5/",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:5,page:1,revision:2,tipCommitID:null})})});describe("Page selector",function(){it("With page == 1",function(){pageView._onPageSelected(true,1);expect(router.navigate).toHaveBeenCalledWith("1/",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,page:1,revision:1,interdiffRevision:null,filenamePatterns:null,tipCommitID:null})});it("With page > 1",function(){pageView._onPageSelected(true,2);expect(router.navigate).toHaveBeenCalledWith("1/?page=2",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,page:2,revision:1,interdiffRevision:null,filenamePatterns:null,tipCommitID:null})})});it("Anchor selection",function(){const $anchor=$('<a name="test"/>');pageView.render();pageView.selectAnchor($anchor);expect(router.navigate).toHaveBeenCalledWith("1/#test",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()})})});describe("With commits",function(){let $commitList;beforeEach(function(){page=new RB.DiffViewerPage({checkForUpdates:false,pagination:{current_page:1},reviewRequestData:{id:123,loaded:true,state:RB.ReviewRequest.PENDING},revision:{revision:1,interdiff_revision:null,is_interdiff:false},editorData:{mutableByUser:true,statusMutableByUser:true},commits:[{author_name:"Author Name",commit_id:"r123",commit_message:"Commit message 1",id:1,parent_id:"r122"},{author_name:"Author Name",commit_id:"r124",commit_message:"Commit message 2",id:2,parent_id:"r123"},{author_name:"Author Name",commit_id:"r125",commit_message:"Commit message 3",id:3,parent_id:"r124"}]},{parse:true});pageView=new RB.DiffViewerPageView({el:$(pageTemplate).appendTo($testsScratch),model:page});$commitList=$testsScratch.find("#diff_commit_list");spyOn(page.get("reviewRequest"),"ready").and.callFake((options,context)=>options.ready.call(context))});describe("Render",function(){it("Initial render (without interdiff)",function(){pageView.render();const $table=$commitList.find("table");expect($table.length).toBe(1);expect($table.find("tbody tr").length).toBe(3)});it("Initial render (with interdiff)",function(){page.revision.set("interdiffRevision",456);page.commitHistoryDiff.reset([{entry_type:RB.CommitHistoryDiffEntry.REMOVED,old_commit_id:1},{entry_type:RB.CommitHistoryDiffEntry.ADDED,new_commit_id:2},{entry_type:RB.CommitHistoryDiffEntry.ADDED,new_commit_id:3}],{parse:true});pageView.render();const $table=$commitList.find("table");expect($table.length).toBe(1);expect($table.find("tbody tr").length).toBe(3)});it("Subsequent render (without interdiff)",function(){pageView.render();spyOn($,"ajax").and.callFake(makeAjaxFn("/api/review-requests/123/diff-context/?revision=2",{diff_context:{revision:{revision:2,interdiff_revision:null,is_interdiff:false},commits:[{author_name:"Author Name",commit_id:"r125",commit_message:"Commit message",id:4,parent_id:"r124"}]}}));page.loadDiffRevision({revision:2});expect($.ajax).toHaveBeenCalled();const $table=$commitList.find("table");expect($table.length).toBe(1);expect($table.find("tbody tr").length).toBe(1)});it("Subsequent render (with interdiff)",function(){pageView.render();const rspPayload={diff_context:{revision:{revision:2,interdiff_revision:3,is_interdiff:true},commits:[{author_name:"Author Name",commit_id:"r124",commit_message:"Commit message",id:1},{author_name:"Author Name",commit_id:"r125",commit_message:"Commit message",id:2}],commit_history_diff:[{entry_type:RB.CommitHistoryDiffEntry.REMOVED,old_commit_id:1},{entry_type:RB.CommitHistoryDiffEntry.ADDED,new_commit_id:2}]}};spyOn($,"ajax").and.callFake(makeAjaxFn("/api/review-requests/123/diff-context/"+"?revision=2&interdiff-revision=3",rspPayload));page.loadDiffRevision({revision:2,interdiffRevision:3});expect($.ajax).toHaveBeenCalled();const $table=$commitList.find("table");expect($table.length).toBe(1);expect($table.find("tbody tr").length).toBe(2)});it("Initial render with base commit ID",function(){page.revision.set("baseCommitID",1);pageView.render();const commitListModel=pageView._commitListView.model;expect(commitListModel.get("baseCommitID")).toBe(1);expect(commitListModel.get("tipCommitID")).toBe(null)});it("Initial render with tip commit ID",function(){page.revision.set("tipCommitID",2);pageView.render();const commitListModel=pageView._commitListView.model;expect(commitListModel.get("baseCommitID")).toBe(null);expect(commitListModel.get("tipCommitID")).toBe(2)});it("Initial render with base commit ID and tip commit ID",function(){page.revision.set({baseCommitID:1,tipCommitID:2});pageView.render();const commitListModel=pageView._commitListView.model;expect(commitListModel.get("baseCommitID")).toBe(1);expect(commitListModel.get("tipCommitID")).toBe(2)})});describe("Page view/URL state",function(){beforeEach(function(){spyOn(page,"loadDiffRevision").and.callThrough();spyOn(Backbone.history,"matchRoot").and.returnValue(true);spyOn(pageView.router,"navigate").and.callFake((url,options)=>{if(!options||options.trigger!==false){Backbone.history.loadUrl(url)}})});describe("Initial URL",function(){it("With base-commit-id",function(){pageView._setInitialURL("?base-commit-id=2","index_header");expect(pageView.router.navigate).toHaveBeenCalledWith("1/?base-commit-id=2#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("With tip-commit-id",function(){pageView._setInitialURL("?tip-commit-id=2","index_header");expect(pageView.router.navigate).toHaveBeenCalledWith("1/?tip-commit-id=2#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()});it("With base-commit-id and tip-commit-id",function(){pageView._setInitialURL("?base-commit-id=1&tip-commit-id=2","index_header");expect(pageView.router.navigate).toHaveBeenCalledWith("1/?base-commit-id=1&tip-commit-id=2#index_header",{replace:true,trigger:false});expect(page.loadDiffRevision).not.toHaveBeenCalled()})});describe("Commit range controls",function(){it("Selecting initial base commit ID",function(){pageView.render();const $table=$commitList.find("table");const $rows=$table.find("tbody tr");expect($table.length).toBe(1);expect($rows.length).toBe(3);spyOn($,"ajax").and.callFake(makeAjaxFn("/api/review-requests/123/diff-context/"+"?revision=1&base-commit-id=1",{diff_context:{revision:{revision:1,interdiff_revision:null,is_interdiff:false,base_commit_id:1,tip_commit_id:null}}}));$rows.eq(1).find(".base-commit-selector").click();expect(pageView.router.navigate).toHaveBeenCalledWith("1/?base-commit-id=1",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:1,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:null});expect(page.revision.get("baseCommitID")).toBe(1);expect(page.revision.get("tipCommitID")).toBe(null);const diffCommitListModel=pageView._commitListView.model;expect(diffCommitListModel.get("baseCommitID")).toBe(1);expect(diffCommitListModel.get("tipCommitID")).toBe(null)});it("Selecting initial tip commit ID",function(){pageView.render();const $table=$commitList.find("table");const $rows=$table.find("tbody tr");expect($table.length).toBe(1);expect($rows.length).toBe(3);spyOn($,"ajax").and.callFake(makeAjaxFn("/api/review-requests/123/diff-context/"+"?revision=1&tip-commit-id=2",{diff_context:{revision:{base_commit_id:null,interdiff_revision:null,is_interdiff:false,revision:1,tip_commit_id:2}}}));$rows.eq(1).find(".tip-commit-selector").click();expect(pageView.router.navigate).toHaveBeenCalledWith("1/?tip-commit-id=2",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:2});expect(page.revision.get("baseCommitID")).toBe(null);expect(page.revision.get("tipCommitID")).toBe(2);const diffCommitListModel=pageView._commitListView.model;expect(diffCommitListModel.get("baseCommitID")).toBe(null);expect(diffCommitListModel.get("tipCommitID")).toBe(2)});it("Selecting new base commit ID",function(){page.revision.set("baseCommitID",3);pageView.render();const $table=$commitList.find("table");const $rows=$table.find("tbody tr");expect($table.length).toBe(1);expect($rows.length).toBe(3);spyOn($,"ajax").and.callFake(makeAjaxFn("/api/review-requests/123/diff-context/"+"?revision=1&base-commit-id=1",{diff_context:{revision:{base_commit_id:1,interdiff_revision:null,is_interdiff:false,revision:1,tip_commit_id:null}}}));$rows.eq(1).find(".base-commit-selector").click();expect(pageView.router.navigate).toHaveBeenCalledWith("1/?base-commit-id=1",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:1,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:null});expect(page.revision.get("baseCommitID")).toBe(1);expect(page.revision.get("tipCommitID")).toBe(null);const diffCommitListModel=pageView._commitListView.model;expect(diffCommitListModel.get("baseCommitID")).toBe(1);expect(diffCommitListModel.get("tipCommitID")).toBe(null)});it("Selecting new tip commit ID",function(){page.revision.set("tipCommitID",2);pageView.render();const $table=$commitList.find("table");const $rows=$table.find("tbody tr");expect($table.length).toBe(1);expect($rows.length).toBe(3);spyOn($,"ajax").and.callFake(makeAjaxFn("/api/review-requests/123/diff-context/"+"?revision=1&tip-commit-id=1",{diff_context:{revision:{base_commit_id:null,interdiff_revision:null,is_interdiff:false,revision:1,tip_commit_id:1}}}));$rows.eq(0).find(".tip-commit-selector").click();expect(pageView.router.navigate).toHaveBeenCalledWith("1/?tip-commit-id=1",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:1});expect(page.revision.get("baseCommitID")).toBe(null);expect(page.revision.get("tipCommitID")).toBe(1);const diffCommitListModel=pageView._commitListView.model;expect(diffCommitListModel.get("baseCommitID")).toBe(null);expect(diffCommitListModel.get("tipCommitID")).toBe(1)});it("Selecting blank base commit ID",function(){page.revision.set("baseCommitID",2);pageView.render();const $table=$commitList.find("table");const $rows=$table.find("tbody tr");expect($table.length).toBe(1);expect($rows.length).toBe(3);spyOn($,"ajax").and.callFake(makeAjaxFn("/api/review-requests/123/diff-context/"+"?revision=1",{diff_context:{revision:{base_commit_id:null,interdiff_revision:null,is_interdiff:false,revision:1,tip_commit_id:null}}}));$rows.eq(0).find(".base-commit-selector").click();expect(pageView.router.navigate).toHaveBeenCalledWith("1/",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:null});expect(page.revision.get("baseCommitID")).toBe(null);expect(page.revision.get("tipCommitID")).toBe(null);const diffCommitListModel=pageView._commitListView.model;expect(diffCommitListModel.get("baseCommitID")).toBe(null);expect(diffCommitListModel.get("tipCommitID")).toBe(null)});it("Selecting blank tip commit ID",function(){page.revision.set("tipCommitID",2);pageView.render();const $table=$commitList.find("table");const $rows=$table.find("tbody tr");expect($table.length).toBe(1);expect($rows.length).toBe(3);spyOn($,"ajax").and.callFake(makeAjaxFn("/api/review-requests/123/diff-context/"+"?revision=1",{diff_context:{revision:{base_commit_id:null,interdiff_revision:null,is_interdiff:false,revision:1,tip_commit_id:null}}}));$rows.eq(2).find(".tip-commit-selector").click();expect(pageView.router.navigate).toHaveBeenCalledWith("1/",{trigger:true});expect(page.loadDiffRevision).toHaveBeenCalledWith({baseCommitID:null,filenamePatterns:null,interdiffRevision:null,page:1,revision:1,tipCommitID:null});expect(page.revision.get("baseCommitID")).toBe(null);expect(page.revision.get("tipCommitID")).toBe(null);const diffCommitListModel=pageView._commitListView.model;expect(diffCommitListModel.get("baseCommitID")).toBe(null);expect(diffCommitListModel.get("tipCommitID")).toBe(null)})})})})});"use strict";suite("rb/pages/views/ReviewablePageView",function(){const pageTemplate=`<div id="review-banner"></div>
<a href="#" id="review-action">Edit Review</a>
<a href="#" id="ship-it-action">Ship It</a>`;let $editReview;let $shipIt;let page;let pageView;beforeEach(function(){const $container=$("<div/>").html(pageTemplate).appendTo($testsScratch);RB.DnDUploader.instance=null;$editReview=$container.find("#review-action");$shipIt=$container.find("#ship-it-action");page=new RB.ReviewablePage({checkForUpdates:false,reviewRequestData:{id:123,loaded:true,state:RB.ReviewRequest.PENDING},editorData:{mutableByUser:true,statusMutableByUser:true}},{parse:true});pageView=new RB.ReviewablePageView({el:$container,model:page});const reviewRequest=page.get("reviewRequest");spyOn(reviewRequest,"ready").and.callFake((options,context)=>options.ready.call(context));pageView.render()});afterEach(function(){RB.DnDUploader.instance=null;pageView.remove()});describe("Public objects",function(){it("reviewRequest",function(){expect(page.get("reviewRequest")).not.toBe(undefined)});it("pendingReview",function(){const pendingReview=page.get("pendingReview");expect(pendingReview).not.toBe(undefined);expect(pendingReview.get("parentObject")).toBe(page.get("reviewRequest"))});it("commentIssueManager",function(){expect(page.commentIssueManager).not.toBe(undefined);expect(page.commentIssueManager.get("reviewRequest")).toBe(page.get("reviewRequest"))});it("reviewRequestEditor",function(){const reviewRequestEditor=page.reviewRequestEditor;expect(reviewRequestEditor).not.toBe(undefined);expect(reviewRequestEditor.get("reviewRequest")).toBe(page.get("reviewRequest"));expect(reviewRequestEditor.get("commentIssueManager")).toBe(page.commentIssueManager);expect(reviewRequestEditor.get("editable")).toBe(true)});it("reviewRequestEditorView",function(){expect(pageView.reviewRequestEditorView).not.toBe(undefined);expect(pageView.reviewRequestEditorView.model).toBe(page.reviewRequestEditor)})});describe("Actions",function(){it("Edit Review",function(){spyOn(RB.ReviewDialogView,"create");$editReview.click();expect(RB.ReviewDialogView.create).toHaveBeenCalled();const options=RB.ReviewDialogView.create.calls.argsFor(0)[0];expect(options.review).toBe(page.get("pendingReview"));expect(options.reviewRequestEditor).toBe(page.reviewRequestEditor)});describe("Ship It",function(){let pendingReview;beforeEach(function(){pendingReview=page.get("pendingReview")});it("Confirmed",function(){spyOn(window,"confirm").and.returnValue(true);spyOn(pendingReview,"ready").and.callFake((options,context)=>options.ready.call(context));spyOn(pendingReview,"save").and.callFake((options,context)=>options.success.call(context));spyOn(pendingReview,"publish").and.callThrough();spyOn(pageView.draftReviewBanner,"hideAndReload");$shipIt.click();expect(window.confirm).toHaveBeenCalled();expect(pendingReview.ready).toHaveBeenCalled();expect(pendingReview.publish).toHaveBeenCalled();expect(pendingReview.save).toHaveBeenCalled();expect(pageView.draftReviewBanner.hideAndReload).toHaveBeenCalled();expect(pendingReview.get("shipIt")).toBe(true);expect(pendingReview.get("bodyTop")).toBe("Ship It!")});it("Canceled",function(){spyOn(window,"confirm").and.returnValue(false);spyOn(pendingReview,"ready");$shipIt.click();expect(window.confirm).toHaveBeenCalled();expect(pendingReview.ready).not.toHaveBeenCalled()})})});describe("Update bubble",function(){const summary="My summary";const user={url:"/users/foo/",fullname:"Mr. User",username:"user"};let $bubble;let bubbleView;beforeEach(function(){page.get("reviewRequest").trigger("updated",{summary:summary,user:user});$bubble=$("#updates-bubble");bubbleView=pageView._updatesBubble});it("Displays",function(){expect($bubble.length).toBe(1);expect(bubbleView.$el[0]).toBe($bubble[0]);expect($bubble.is(":visible")).toBe(true);expect($bubble.find("#updates-bubble-summary").text()).toBe(summary);expect($bubble.find("#updates-bubble-user").text()).toBe(user.fullname);expect($bubble.find("#updates-bubble-user").attr("href")).toBe(user.url)});describe("Actions",function(){it("Ignore",function(){spyOn(bubbleView,"close").and.callThrough();spyOn(bubbleView,"trigger").and.callThrough();spyOn(bubbleView,"remove").and.callThrough();$bubble.find(".ignore").click();expect(bubbleView.close).toHaveBeenCalled();expect(bubbleView.remove).toHaveBeenCalled();expect(bubbleView.trigger).toHaveBeenCalledWith("closed")});it("Update Page displays Updates Bubble",function(){spyOn(bubbleView,"trigger");$bubble.find(".update-page").click();expect(bubbleView.trigger).toHaveBeenCalledWith("updatePage")});it("Update Page calls notify if shouldNotify",function(){const info={user:{fullname:"Hello"}};RB.NotificationManager.instance._canNotify=true;spyOn(RB.NotificationManager.instance,"notify");spyOn(RB.NotificationManager.instance,"_haveNotificationPermissions").and.returnValue(true);spyOn(pageView,"_showUpdatesBubble");pageView._onReviewRequestUpdated(info);expect(RB.NotificationManager.instance.notify).toHaveBeenCalled();expect(pageView._showUpdatesBubble).toHaveBeenCalled()})})})});"use strict";suite("rb/resources/collections/RepositoryBranches",function(){let collection;beforeEach(function(){collection=new RB.RepositoryBranches;collection.url="/api/repositories/123/branches/"});describe("Methods",function(){it("fetch",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.url).toBe("/api/repositories/123/branches/");expect(request.type).toBe("GET");request.success({stat:"ok",branches:[{name:"master",commit:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",default:true},{name:"release-1.7.x",commit:"92463764015ef463b4b6d1a1825fee7aeec8cb15",default:false},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64",default:false}]})});collection.fetch();expect($.ajax).toHaveBeenCalled();expect(collection.length).toBe(3);expect(collection.at(0).get("name")).toBe("master");expect(collection.at(1).get("commit")).toBe("92463764015ef463b4b6d1a1825fee7aeec8cb15");expect(collection.at(2).get("isDefault")).toBe(false);expect(collection.reduce((memo,item)=>memo+item.get("isDefault")?1:0,0)).toBe(1)})})});"use strict";suite("rb/resources/collections/RepositoryCommits",function(){const url="/api/repositories/123/commits/";const start="859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817";let collection;beforeEach(function(){collection=new RB.RepositoryCommits([],{urlBase:url,start:start})});describe("Methods",function(){it("fetch",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.url).toBe(`${url}?start=${start}`);expect(request.type).toBe("GET");request.success({stat:"ok",commits:[{author_name:"Christian Hammond",date:"2013-06-25T23:31:22Z",id:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",message:"Merge branch 'release-1.7.x'",parent:"92463764015ef463b4b6d1a1825fee7aeec8cb15",review_request_url:""},{author_name:"Christian Hammond",date:"2013-06-25T23:30:59Z",id:"92463764015ef463b4b6d1a1825fee7aeec8cb15",message:"Fixed the bug number for the "+"blacktriangledown bug.",parent:"84c730c7823b653a5bbcc007188d5c85a7c4ac58",review_request_url:"http://example.com/r/18274/"},{author_name:"Christian Hammond",date:"2013-06-25T22:53:32Z",id:"84c730c7823b653a5bbcc007188d5c85a7c4ac58",message:["Don't expose child resources in ","ValidateDiffResource.\n\nFor convenience, ","ValidateDiffResource inherited from ","DiffResource.\nThis brought along the child ","resources, which weren't valid to have.\n","That ended up breaking docs, which tried ","to traverse them."].join(""),parent:"",review_request_url:""}]})});collection.fetch();expect($.ajax).toHaveBeenCalled();expect(collection.length).toBe(3);expect(collection.at(0).get("authorName")).toBe("Christian Hammond");expect(collection.at(1).get("date").getUTCHours()).toBe(23);expect(collection.at(2).get("summary")).toBe("Don't expose child resources in ValidateDiffResource.");expect(collection.at(1).get("reviewRequestURL")).toBe("http://example.com/r/18274/")});it("url",function(){expect(_.result(collection,"url")).toBe(`${url}?start=${start}`)})})});"use strict";suite("rb/resources/collections/ResourceCollection",function(){let collection;let reviewRequest;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:123,loaded:true,links:{reviews:{href:"/api/review-requests/123/reviews/"}}});spyOn(reviewRequest,"ready").and.callFake((options,context)=>options.ready.call(context));collection=new RB.ResourceCollection([],{model:RB.Review,parentResource:reviewRequest})});describe("Methods",function(){describe("fetch",function(){it("Populates collection",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.url).toBe("/api/review-requests/123/reviews/");expect(request.type).toBe("GET");request.success({stat:"ok",total_results:2,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})});collection.fetch();expect($.ajax).toHaveBeenCalled();expect(collection.length).toBe(2);expect(collection.at(0).id).toBe(1);expect(collection.at(1).id).toBe(2);expect(collection.hasPrev).toBe(false);expect(collection.hasNext).toBe(true)});it("With start=",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.url).toBe("/api/review-requests/123/reviews/");expect(request.data).not.toBe(undefined);expect(request.data.start).toBe(100)});collection.fetch({start:100});expect($.ajax).toHaveBeenCalled()});describe("With parentResource",function(){it("Calls parentResource.ready",function(){spyOn(RB.BaseCollection.prototype,"fetch");collection.fetch();expect(reviewRequest.ready).toHaveBeenCalled();expect(RB.BaseCollection.prototype.fetch).toHaveBeenCalled()})})});describe("fetchAll",function(){it("Spanning pages",function(){let numFetches=0;spyOn($,"ajax").and.callFake(request=>{console.assert(numFetches<2);expect(request.type).toBe("GET");numFetches++;if(numFetches===1){expect(request.url).toBe("/api/review-requests/123/reviews/");request.success({stat:"ok",total_results:4,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})}else if(numFetches===2){expect(request.url).toBe("/api/review-requests/123/reviews/?start=25");request.success({stat:"ok",total_results:4,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"},prev:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=0"}},reviews:[{id:3,links:{}},{id:4,links:{}}]})}});const result=collection.fetchAll();expect(result).toBe(true);expect($.ajax).toHaveBeenCalled();expect(numFetches).toBe(2);expect(collection.hasPrev).toBe(false);expect(collection.hasNext).toBe(false);expect(collection.totalResults).toBe(4);expect(collection.currentPage).toBe(0);expect(collection.length).toBe(4);expect(collection.at(0).id).toBe(1);expect(collection.at(1).id).toBe(2);expect(collection.at(2).id).toBe(3);expect(collection.at(3).id).toBe(4)})});describe("fetchNext",function(){it("With hasNext == false",function(){collection.hasNext=false;spyOn(collection,"fetch");const result=collection.fetchNext();expect(result).toBe(false);expect(collection.fetch).not.toHaveBeenCalled()});it("With hasNext == true",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.url).toBe("/api/review-requests/123/reviews/?start=25");expect(request.type).toBe("GET");request.success({stat:"ok",total_results:2,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},prev:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=0"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=50"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})});collection.hasNext=true;collection.currentPage=2;collection._links={next:{method:"GET",href:"/api/review-requests/123/reviews/?start=25"}};spyOn(collection,"fetch").and.callThrough();const result=collection.fetchNext();expect(result).toBe(true);expect(collection.fetch).toHaveBeenCalled();expect(collection.hasPrev).toBe(true);expect(collection.hasNext).toBe(true);expect(collection.currentPage).toBe(3);expect(collection.models.length).toBe(2)})});describe("fetchPrev",function(){it("With hasPrev == false",function(){collection.hasPrev=false;spyOn(collection,"fetch");const result=collection.fetchPrev();expect(result).toBe(false);expect(collection.fetch).not.toHaveBeenCalled()});it("With hasPrev == true",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.url).toBe("/api/review-requests/123/reviews/?start=25");expect(request.type).toBe("GET");request.success({stat:"ok",total_results:2,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},prev:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=0"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})});collection.hasPrev=true;collection.currentPage=2;collection._links={prev:{method:"GET",href:"/api/review-requests/123/reviews/?start=25"}};spyOn(collection,"fetch").and.callThrough();const result=collection.fetchPrev();expect(result).toBe(true);expect(collection.fetch).toHaveBeenCalled();expect(collection.hasPrev).toBe(true);expect(collection.hasNext).toBe(true);expect(collection.currentPage).toBe(1);expect(collection.models.length).toBe(2)})});describe("parse",function(){let payload;beforeEach(function(){payload={links:{},total_results:5,reviews:[]}});it("Resources returned",function(){payload.reviews=[{id:1},{id:2},{id:3}];const results=collection.parse(payload);expect(results.length).toBe(3);expect(results[0].id).toBe(1);expect(results[1].id).toBe(2);expect(results[2].id).toBe(3)});it("totalResults set",function(){collection.parse(payload);expect(collection.totalResults).toBe(5)});describe("With fetchingAll",function(){const options={fetchingAll:true};it("currentPage = 0",function(){collection.parse(payload,options);expect(collection.currentPage).toBe(0)});it("hasPrev disabled",function(){collection.parse(payload,options);expect(collection.hasPrev).toBe(false)});it("hasNext disabled",function(){collection.parse(payload,options);expect(collection.hasNext).toBe(false)})});describe("Without fetchingAll",function(){describe("currentPage",function(){it("undefined when not options.page",function(){collection.parse(payload);expect(collection.currentPage).toBe(undefined)});it("Set when options.page",function(){collection.parse(payload,{page:4});expect(collection.currentPage).toBe(4)})});describe("hasPrev",function(){it("true with rsp.links.prev",function(){payload.links={prev:{href:"blah"}};collection.parse(payload);expect(collection.hasPrev).toBe(true)});it("false without rsp.links.prev",function(){collection.parse(payload);expect(collection.hasPrev).toBe(false)})});describe("hasNext",function(){it("true with rsp.links.next",function(){payload.links={next:{href:"blah"}};collection.parse(payload);expect(collection.hasNext).toBe(true)});it("false without rsp.links.next",function(){collection.parse(payload);expect(collection.hasNext).toBe(false)})})})});describe("url",function(){it("With parentResource",function(){expect(collection.url()).toBe("/api/review-requests/123/reviews/")});it("With _fetchURL",function(){collection._fetchURL="/api/foo/";expect(collection.url()).toBe("/api/foo/")});it("Without _fetchURL or parentResource",function(){collection.parentResource=null;expect(collection.url()).toBe(null)})})})});"use strict";suite("rb/resources/models/BaseComment",function(){const strings=RB.BaseComment.strings;let parentObject;let model;beforeEach(function(){parentObject=new RB.BaseResource({public:true});model=new RB.BaseComment({parentObject:parentObject});expect(model.validate(model.attributes)).toBe(undefined)});describe("State values",function(){it("STATE_DROPPED",function(){expect(RB.BaseComment.STATE_DROPPED).toBe("dropped")});it("STATE_OPEN",function(){expect(RB.BaseComment.STATE_OPEN).toBe("open")});it("STATE_RESOLVED",function(){expect(RB.BaseComment.STATE_RESOLVED).toBe("resolved")})});describe("destroyIfEmpty",function(){beforeEach(function(){spyOn(model,"destroy")});it("Destroying when text is empty",function(){model.set("text","");model.destroyIfEmpty();expect(model.destroy).toHaveBeenCalled()});it("Not destroying when text is not empty",function(){model.set("text","foo");model.destroyIfEmpty();expect(model.destroy).not.toHaveBeenCalled()})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_comment"});it("API payloads",function(){const data=model.parse({stat:"ok",my_comment:{id:42,issue_opened:true,issue_status:"resolved",text:"foo"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.text).toBe("foo")})});describe("toJSON",function(){describe("force_text_type field",function(){it("With value",function(){model.set("forceTextType","html");const data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){model.set("includeTextTypes","html");const data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("issue_opened field",function(){it("Default",function(){const data=model.toJSON();expect(data.issue_opened).toBe(null)});it("With value",function(){model.set("issueOpened",false);let data=model.toJSON();expect(data.issue_opened).toBe(false);model.set("issueOpened",true);data=model.toJSON();expect(data.issue_opened).toBe(true)})});describe("issue_status field",function(){it("When not loaded",function(){model.set("issueStatus",RB.BaseComment.STATE_DROPPED);const data=model.toJSON();expect(data.issue_status).toBe(undefined)});it("When loaded and parent is not public",function(){parentObject.set("public",false);model.set({loaded:true,issueStatus:RB.BaseComment.STATE_DROPPED,parentObject:parentObject});const data=model.toJSON();expect(data.issue_status).toBe(undefined)});it("When loaded and parent is public",function(){parentObject.set("public",true);model.set({loaded:true,issueStatus:RB.BaseComment.STATE_DROPPED,parentObject:parentObject});const data=model.toJSON();expect(data.issue_status).toBe(RB.BaseComment.STATE_DROPPED)})});describe("richText field",function(){it("With true",function(){model.set("richText",true);const data=model.toJSON();expect(data.text_type).toBe("markdown")});it("With false",function(){model.set("richText",false);const data=model.toJSON();expect(data.text_type).toBe("plain")})});describe("text field",function(){it("With value",function(){model.set("text","foo");const data=model.toJSON();expect(data.text).toBe("foo")})})});describe("validate",function(){describe("issueState",function(){it("STATE_DROPPED",function(){expect(model.validate({issueStatus:RB.BaseComment.STATE_DROPPED})).toBe(undefined)});it("STATE_OPEN",function(){expect(model.validate({issueStatus:RB.BaseComment.STATE_OPEN})).toBe(undefined)});it("STATE_RESOLVED",function(){expect(model.validate({issueStatus:RB.BaseComment.STATE_RESOLVED})).toBe(undefined)});it("Unset",function(){expect(model.validate({issueStatus:""})).toBe(undefined);expect(model.validate({issueStatus:undefined})).toBe(undefined);expect(model.validate({issueStatus:null})).toBe(undefined)});it("Invalid values",function(){expect(model.validate({issueStatus:"foobar"})).toBe(strings.INVALID_ISSUE_STATUS)})});describe("parentObject",function(){it("With value",function(){expect(model.validate({parentObject:parentObject})).toBe(undefined)});it("Unset",function(){expect(model.validate({parentObject:null})).toBe(RB.BaseResource.strings.UNSET_PARENT_OBJECT)})})})});"use strict";suite("rb/resources/models/BaseCommentReply",function(){let parentObject;let model;beforeEach(function(){parentObject=new RB.BaseResource({public:true});model=new RB.BaseCommentReply({parentObject:parentObject});expect(model.validate(model.attributes)).toBe(undefined)});describe("destroyIfEmpty",function(){beforeEach(function(){spyOn(model,"destroy")});it("Destroying when text is empty",function(){model.set("text","");model.destroyIfEmpty();expect(model.destroy).toHaveBeenCalled()});it("Not destroying when text is not empty",function(){model.set("text","foo");model.destroyIfEmpty();expect(model.destroy).not.toHaveBeenCalled()})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_comment"});it("API payloads",function(){const data=model.parse({stat:"ok",my_comment:{id:42,text:"foo",text_type:"markdown"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.text).toBe("foo");expect(data.richText).toBe(true)})});describe("toJSON",function(){describe("force_text_type field",function(){it("With value",function(){model.set("forceTextType","html");const data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){model.set("includeTextTypes","html");const data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("reply_to_id field",function(){it("When loaded",function(){model.set({replyToID:10,loaded:true});const data=model.toJSON();expect(data.reply_to_id).toBe(undefined)});it("When not loaded",function(){model.set({replyToID:10,loaded:false});const data=model.toJSON();expect(data.reply_to_id).toBe(10)})});describe("richText field",function(){it("With true",function(){model.set("richText",true);const data=model.toJSON();expect(data.text_type).toBe("markdown")});it("With false",function(){model.set("richText",false);const data=model.toJSON();expect(data.text_type).toBe("plain")})});describe("text field",function(){it("With value",function(){model.set("text","foo");const data=model.toJSON();expect(data.text).toBe("foo")})})});describe("validate",function(){describe("parentObject",function(){it("With value",function(){expect(model.validate({parentObject:parentObject})).toBe(undefined)});it("Unset",function(){expect(model.validate({parentObject:null})).toBe(RB.BaseResource.strings.UNSET_PARENT_OBJECT)})})})});"use strict";suite("rb/resources/models/BaseResource",function(){let model;let parentObject;beforeEach(function(){model=new RB.BaseResource;model.rspNamespace="foo";parentObject=new RB.BaseResource({links:{foos:{href:"/api/foos/"}}})});describe("ensureCreated",function(){let callbacks;describe("Callback handling",function(){beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(model,"save").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"fetch").and.callFake((options,context)=>{options.success.call(context)});spyOn(model,"ready").and.callThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});describe("With loaded=true",function(){beforeEach(function(){model.set("loaded",true)});it("With callbacks",function(){model.ensureCreated(callbacks);expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Without callbacks",function(){model.ensureCreated();expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).not.toHaveBeenCalled()})});describe("With loaded=false, isNew=true",function(){beforeEach(function(){model.set("loaded",false)});it("With callbacks",function(){model.ensureCreated(callbacks);expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Without callbacks",function(){model.ensureCreated();expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).toHaveBeenCalled()})});describe("With loaded=false, isNew=false",function(){beforeEach(function(){model.set({loaded:false,id:1})});it("With callbacks",function(){model.ensureCreated(callbacks);expect(model.ready).toHaveBeenCalled();expect(model.fetch).toHaveBeenCalled();expect(model.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Without callbacks",function(){model.ensureCreated();expect(model.ready).toHaveBeenCalled();expect(model.fetch).toHaveBeenCalled();expect(model.save).toHaveBeenCalled()})})})});describe("fetch",function(){let callbacks;describe("Callback handling",function(){beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(Backbone.Model.prototype,"fetch").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.success()}});spyOn(callbacks,"success");spyOn(callbacks,"error")});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true)});it("With callbacks",function(){model.fetch(callbacks);expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled()})});describe("With isNew=false and no parentObject",function(){beforeEach(function(){model.set("id",123)});it("With callbacks",function(){model.fetch(callbacks);expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled()})});describe("With isNew=false and parentObject",function(){beforeEach(function(){model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").and.callFake((options,context)=>{options.ready.call(context)})});it("With callbacks",function(){model.fetch(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled()})});describe("With isNew=false and parentObject with error",function(){beforeEach(function(){model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").and.callFake((options,context)=>{if(options&&_.isFunction(options.error)){options.error.call(context,"Oh nosers.")}})});it("With callbacks",function(){model.fetch(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled()})})});describe("Response handling",function(){beforeEach(function(){model.set({id:123,links:{self:{href:"/api/foo/"}}})});it("Custom response parsing",function(){spyOn(model,"parse").and.callFake(rsp=>({a:rsp.a+1,b:rsp.b,c:true}));spyOn($,"ajax").and.callFake(request=>{request.success({a:10,b:20,d:30})});model.fetch();expect(model.get("a")).toBe(11);expect(model.get("b")).toBe(20);expect(model.get("c")).toBe(true);expect(model.get("d")).toBe(undefined)});it("Default response parsing",function(){spyOn(model,"parse").and.callThrough();spyOn($,"ajax").and.callFake(request=>{request.success({stat:"ok",foo:{id:42,links:{foo:{href:"bar"}},a:20}})});model.fetch();expect(model.get("a")).toBe(undefined);expect(model.id).toBe(42);expect(model.get("links").foo).not.toBe(undefined);expect(model.get("loaded")).toBe(true)})});describe("Request payload",function(){beforeEach(function(){model.set({id:123,links:{self:{href:"/api/foo/"}}})});describe("GET",function(){it("No contentType sent",function(){spyOn(Backbone,"sync").and.callFake((method,model,options)=>{expect(options.contentType).toBe(undefined)});model.fetch();expect(Backbone.sync).toHaveBeenCalled()});it("No model data sent",function(){spyOn(Backbone,"sync").and.callFake((method,model,options)=>{expect(_.isEmpty(options.data)).toBe(true)});model.toJSON=()=>({a:1,b:2});model.fetch();expect(Backbone.sync).toHaveBeenCalled()});it("Query attributes sent",function(){spyOn(Backbone,"sync").and.callFake((method,model,options)=>{expect(_.isEmpty(options.data)).toBe(false);expect(options.data.foo).toBe("bar")});model.toJSON=()=>({a:1,b:2});model.fetch({data:{foo:"bar"}});expect(Backbone.sync).toHaveBeenCalled()})})})});describe("ready",function(){let callbacks;beforeEach(function(){callbacks={ready:function(){},error:function(){}};spyOn(model,"fetch").and.callFake(options=>options.success());spyOn(callbacks,"ready");spyOn(callbacks,"error")});it("With loaded=true",function(){model.set("loaded",true);model.ready(callbacks);expect(model.fetch).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With loaded=false and isNew=true",function(){model.set("loaded",false);expect(model.isNew()).toBe(true);model.ready(callbacks);expect(model.fetch).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With loaded=false and isNew=false",function(){model.set({loaded:false,id:123});expect(model.isNew()).toBe(false);model.ready(callbacks);expect(model.fetch).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})});describe("save",function(){let callbacks;describe("Callback handling",function(){beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(Backbone.Model.prototype,"fetch").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.success()}});spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(model,"trigger")});describe("With isNew=true and parentObject",function(){const responseData={foo:{},stat:"ok"};beforeEach(function(){spyOn(parentObject,"ensureCreated").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.success()}});spyOn(parentObject,"ready").and.callFake((options,context)=>{options.ready.call(context)});spyOn(Backbone.Model.prototype,"save").and.callThrough();model.set("parentObject",parentObject);spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("POST");request.success(responseData)})});it("With callbacks",function(){model.save(callbacks);expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(parentObject.ensureCreated).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();const args=callbacks.success.calls.argsFor(0);expect(args[0]).toBe(model);expect(args[1]).toBe(responseData);expect(callbacks.error).not.toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(parentObject.ensureCreated).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",{})})});describe("With isNew=true and no parentObject",function(){beforeEach(function(){spyOn(Backbone.Model.prototype,"save").and.callThrough();spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(function(){})});it("With callbacks",function(){model.save(callbacks);expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved")})});describe("With isNew=false and no parentObject",function(){beforeEach(function(){model.set("id",123);model.url="/api/foos/1/";spyOn(Backbone.Model.prototype,"save").and.callFake((attrs,options)=>{if(options&&_.isFunction(options.success)){options.success()}})});it("With callbacks",function(){model.save(callbacks);expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",{})})});describe("With isNew=false and parentObject",function(){beforeEach(function(){spyOn(parentObject,"ensureCreated").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.success()}});spyOn(Backbone.Model.prototype,"save").and.callThrough();model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").and.callFake((options,context)=>options.ready.call(context));spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("PUT");request.success({foo:{},stat:"ok"})})});it("With callbacks",function(){model.save(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",{})})});describe("With isNew=false and parentObject with error",function(){beforeEach(function(){model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").and.callFake((options,context)=>{if(options&&_.isFunction(options.error)){options.error.call(context,"Oh nosers.")}});spyOn(Backbone.Model.prototype,"save").and.callFake((attrs,options)=>{if(options&&_.isFunction(options.success)){options.success()}})});it("With callbacks",function(){model.save(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved")});it("Without callbacks",function(){model.save();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved")})})});describe("Request payload",function(){it("Saved data",function(){model.set("id",1);model.url="/api/foos/";expect(model.isNew()).toBe(false);spyOn(model,"toJSON").and.callFake(()=>({a:10,b:20,c:30}));spyOn(model,"ready").and.callFake((options,context)=>options.ready.call(context));spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(request=>{expect(request.url).toBe(model.url);expect(request.contentType).toBe("application/x-www-form-urlencoded");expect(request.processData).toBe(true);expect(request.data.a).toBe(10);expect(request.data.b).toBe(20);expect(request.data.c).toBe(30);request.success({stat:"ok",foo:{id:1,a:10,b:20,c:30,links:{}}})});model.save();expect(model.toJSON).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled()})});describe("With file upload support",function(){beforeEach(function(){model.payloadFileKeys=["file"];model.url="/api/foos/";model.toJSON=function(){return{file:this.get("file"),myfield:"myvalue"}};spyOn(Backbone.Model.prototype,"save").and.callThrough();spyOn(RB,"apiCall").and.callThrough()});it("With file",function(done){const boundary="-----multipartformboundary";const blob=new Blob(["Hello world!"],{type:"text/plain"});blob.name="myfile";spyOn($,"ajax").and.callFake(request=>{const fileReader=new FileReader;expect(request.type).toBe("POST");expect(request.processData).toBe(false);expect(request.contentType.indexOf("multipart/form-data; boundary=")).toBe(0);fileReader.onload=function(){const array=new Uint8Array(this.result);const data=[];for(let i=0;i<array.length;i++){data.push(String.fromCharCode(array[i]))}expect(data.join("")).toBe("--"+boundary+"\r\n"+'Content-Disposition: form-data; name="file"'+'; filename="myfile"\r\n'+"Content-Type: text/plain\r\n\r\n"+"Hello world!"+"\r\n"+"--"+boundary+"\r\n"+"Content-Disposition: form-data; "+'name="myfield"\r\n\r\n'+"myvalue\r\n"+"--"+boundary+"--\r\n\r\n");request.success({stat:"ok",foo:{id:42}})};fileReader.readAsArrayBuffer(request.data)});model.set("file",blob);model.save({success:()=>{expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();done()},boundary:boundary})});it("With multiple files",function(done){const boundary="-----multipartformboundary";const blob1=new Blob(["Hello world!"],{type:"text/plain"});blob1.name="myfile1";const blob2=new Blob(["Goodbye world!"],{type:"text/plain"});blob2.name="myfile2";model.payloadFileKeys=["file1","file2"];model.toJSON=function(){return{file1:this.get("file1"),file2:this.get("file2"),myfield:"myvalue"}};spyOn($,"ajax").and.callFake(request=>{const fileReader=new FileReader;expect(request.type).toBe("POST");expect(request.processData).toBe(false);expect(request.contentType.indexOf("multipart/form-data; boundary=")).toBe(0);fileReader.onload=function(){const array=new Uint8Array(this.result);const data=[];for(let i=0;i<array.length;i++){data.push(String.fromCharCode(array[i]))}expect(data.join("")).toBe("--"+boundary+"\r\n"+'Content-Disposition: form-data; name="file1"'+'; filename="myfile1"\r\n'+"Content-Type: text/plain\r\n\r\n"+"Hello world!"+"\r\n"+"--"+boundary+"\r\n"+'Content-Disposition: form-data; name="file2"'+'; filename="myfile2"\r\n'+"Content-Type: text/plain\r\n\r\n"+"Goodbye world!"+"\r\n"+"--"+boundary+"\r\n"+"Content-Disposition: form-data; "+'name="myfield"\r\n\r\n'+"myvalue\r\n"+"--"+boundary+"--\r\n\r\n");request.success({stat:"ok",foo:{id:42}})};fileReader.readAsArrayBuffer(request.data)});model.set("file1",blob1);model.set("file2",blob2);model.save({success:()=>{expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();done()},boundary:boundary})});it("Without file",function(done){spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("POST");expect(request.processData).toBe(true);expect(request.contentType).toBe("application/x-www-form-urlencoded");request.success({stat:"ok",foo:{id:42}})});model.save({success:()=>{expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();done()}})})});describe("With form upload support",function(){beforeEach(function(){model.url="/api/foos/"});it("Overriding toJSON attributes",function(){const form=$("<form/>").append($('<input name="foo"/>'));model.toJSON=()=>({myfield:"myvalue"});spyOn(Backbone,"sync").and.callThrough();spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax");spyOn(form,"ajaxSubmit");model.save({form:form});expect(RB.apiCall).toHaveBeenCalled();expect(form.ajaxSubmit).toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(Backbone.sync.calls.argsFor(0)[2].data).toBe(null);expect(RB.apiCall.calls.argsFor(0)[0].data).toBe(null)});it("Overriding file attributes",function(){const form=$("<form/>").append($('<input name="foo"/>'));model.payloadFileKey="file";model.toJSON=function(){return{file:this.get("file")}};spyOn(model,"_saveWithFiles").and.callThrough();spyOn(Backbone,"sync").and.callThrough();spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax");spyOn(form,"ajaxSubmit");model.save({form:form});expect(model._saveWithFiles).not.toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect(form.ajaxSubmit).toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(Backbone.sync.calls.argsFor(0)[2].data).toBe(null);expect(RB.apiCall.calls.argsFor(0)[0].data).toBe(null)})})});describe("url",function(){it("With self link",function(){const url="/api/base-resource/";model.set("links",{self:{href:url}});expect(model.url()).toBe(url)});it("With parentObject and model ID",function(){model.set({parentObject:parentObject,id:123});expect(model.url()).toBe("/api/foos/123/")});it("With parentObject, no links",function(){model.set("parentObject",parentObject);expect(model.url()).toBe("/api/foos/")});it("With no parentObject, no links",function(){expect(model.url()).toBe(null)})})});"use strict";suite("rb/resources/models/DefaultReviewer",function(){let model;beforeEach(function(){model=new RB.DefaultReviewer});describe("parse",function(){it("API payloads",function(){const data=model.parse({stat:"ok",default_reviewer:{id:42,name:"my-default-reviewer",file_regex:"/foo/.*"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.name).toBe("my-default-reviewer");expect(data.fileRegex).toBe("/foo/.*")})});describe("toJSON",function(){describe("name field",function(){it("With value",function(){model.set("name","foo");const data=model.toJSON();expect(data.name).toBe("foo")})});describe("fileRegex field",function(){it("With value",function(){model.set("fileRegex","/foo/.*");const data=model.toJSON();expect(data.file_regex).toBe("/foo/.*")})})})});"use strict";suite("rb/resources/models/DiffComment",function(){let model;beforeEach(function(){model=new RB.DiffComment({fileDiffID:16,parentObject:new RB.BaseResource({public:true})})});it("getNumLines",function(){model.set({beginLineNum:5,endLineNum:10});expect(model.getNumLines()).toBe(6)});describe("parse",function(){it("API payloads",function(){const data=model.parse({stat:"ok",diff_comment:{id:42,issue_opened:true,issue_status:"resolved",text_type:"markdown",text:"foo",first_line:10,num_lines:5,filediff:{id:1,source_file:"my-file"},interfilediff:{id:2,source_file:"my-file"}}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.richText).toBe(true);expect(data.text).toBe("foo");expect(data.beginLineNum).toBe(10);expect(data.endLineNum).toBe(14);expect(data.fileDiff).not.toBe(undefined);expect(data.fileDiff.id).toBe(1);expect(data.fileDiff.get("sourceFilename")).toBe("my-file");expect(data.interFileDiff).not.toBe(undefined);expect(data.interFileDiff.id).toBe(2);expect(data.interFileDiff.get("sourceFilename")).toBe("my-file")})});describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough();model.toJSON();expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()});it("first_line field",function(){model.set({beginLineNum:100,endLineNum:100});const data=model.toJSON();expect(data.first_line).toBe(100)});it("num_lines field",function(){model.set({beginLineNum:100,endLineNum:105});const data=model.toJSON();expect(data.num_lines).toBe(6)});describe("force_text_type field",function(){it("With value",function(){model.set("forceTextType","html");const data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){model.set("includeTextTypes","html");const data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("filediff_id field",function(){it("When loaded",function(){model.set("loaded",true);const data=model.toJSON();expect(data.filediff_id).toBe(undefined)});it("When not loaded",function(){const data=model.toJSON();expect(data.filediff_id).toBe(16)})});describe("interfilediff_id field",function(){it("When loaded",function(){model.set("loaded",true);const data=model.toJSON();expect(data.interfilediff_id).toBe(undefined)});it("When not loaded",function(){model.set("interFileDiffID",50);const data=model.toJSON();expect(data.interfilediff_id).toBe(50)});it("When not loaded and unset",function(){const data=model.toJSON();expect(data.interfilediff_id).toBe(undefined)})})});describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate");model.validate({});expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()});describe("beginLineNum/endLineNum",function(){describe("Valid values",function(){it("beginLineNum == 0, endLineNum == 0",function(){expect(model.validate({beginLineNum:0,endLineNum:0})).toBe(undefined)});it("beginLineNum > 0, endLineNum == beginLineNum",function(){expect(model.validate({beginLineNum:10,endLineNum:10})).toBe(undefined)});it("beginLineNum > 0, endLineNum > 0",function(){expect(model.validate({beginLineNum:10,endLineNum:11})).toBe(undefined)})});describe("Invalid values",function(){it("beginLineNum < 0",function(){expect(model.validate({beginLineNum:-1})).toBe(RB.DiffComment.strings.BEGINLINENUM_GTE_0)});it("endLineNum < 0",function(){expect(model.validate({endLineNum:-1})).toBe(RB.DiffComment.strings.ENDLINENUM_GTE_0)});it("endLineNum < beginLineNum",function(){expect(model.validate({beginLineNum:20,endLineNum:10})).toBe(RB.DiffComment.strings.BEGINLINENUM_LTE_ENDLINENUM)})})});describe("fileDiffID",function(){it("With value",function(){expect(model.validate({fileDiffID:42})).toBe(undefined)});it("Unset",function(){expect(model.validate({fileDiffID:null})).toBe(RB.DiffComment.strings.INVALID_FILEDIFF_ID)})})})});"use strict";suite("rb/resources/models/DraftReview",function(){let model;let parentObject;beforeEach(function(){parentObject=new RB.BaseResource({links:{reviews:{href:"/api/foos/"}}});model=new RB.DraftReview({parentObject:parentObject});model.rspNamespace="foo"});describe("Methods",function(){let callbacks;beforeEach(function(){callbacks={ready:function(){},success:function(){},error:function(){}};spyOn(callbacks,"ready");spyOn(callbacks,"success");spyOn(callbacks,"error")});describe("ready",function(){beforeEach(function(){spyOn(Backbone.Model.prototype,"fetch").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.success()}});spyOn(parentObject,"ready").and.callFake((options,context)=>{if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(model,"_retrieveDraft").and.callFake((options,context)=>{if(options&&_.isFunction(options.ready)){options.ready.call(context)}})});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false)});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})});describe("With isNew=false",function(){beforeEach(function(){model.set({id:123})});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})})});describe("publish",function(){beforeEach(function(){spyOn(model,"save").and.callFake((options,context)=>{options.success.call(context)})});it('Triggers "publishing" event before publish',function(){spyOn(model,"trigger");spyOn(model,"ready");model.publish();expect(model.trigger).toHaveBeenCalledWith("publishing")});it('Triggers "published" event after publish',function(){spyOn(model,"trigger");spyOn(model,"ready").and.callFake((options,context)=>{options.ready.call(context)});model.publish(callbacks);expect(callbacks.success).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("published")});it('Sets "public" to true',function(){spyOn(model,"ready").and.callFake((options,context)=>{options.ready.call(context)});expect(model.get("public")).toBe(false);model.publish(callbacks);expect(callbacks.success).toHaveBeenCalled();expect(model.get("public")).toBe(true)})})})});"use strict";suite("rb/resources/models/DraftReviewRequest",function(){let draft;let callbacks;beforeEach(function(){const reviewRequest=new RB.ReviewRequest({id:1,links:{draft:{href:"/api/review-requests/123/draft/"}}});draft=reviewRequest.draft;callbacks={success:function(){},error:function(){}};spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(reviewRequest,"ready").and.callFake((options,context)=>options.ready.call(context));spyOn(reviewRequest,"ensureCreated").and.callFake((options,context)=>options.success.call(context));spyOn(draft,"ready").and.callFake((options,context)=>options.ready.call(context))});it("url",function(){expect(draft.url()).toBe("/api/review-requests/123/draft/")});it("publish",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(request=>{expect(request.data.public).toBe(1);request.success({stat:"ok",draft:{id:1,links:{}}})});draft.set({targetGroups:[{name:"mygroup",url:"/groups/mygroup"}],summary:"My summary",description:"My description"});draft.publish({success:callbacks.success,error:callbacks.error});expect(callbacks.error).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled()});it("parse",function(){const data=draft.parse({stat:"ok",draft:{id:1,branch:"branch",bugs_closed:"bugsClosed",changedescription:"changeDescription",changedescription_text_type:"markdown",description:"description",public:"public",description_text_type:"markdown",summary:"summary",target_groups:"targetGroups",target_people:"targetPeople",testing_done:"testingDone",testing_done_text_type:"plain",links:{submitter:"submitter"}}});expect(data).not.toBe(undefined);expect(data.id).toBe(1);expect(data.branch).toBe("branch");expect(data.bugsClosed).toBe("bugsClosed");expect(data.changeDescription).toBe("changeDescription");expect(data.changeDescriptionRichText).toBe(true);expect(data.description).toBe("description");expect(data.descriptionRichText).toBe(true);expect(data.public).toBe("public");expect(data.summary).toBe("summary");expect(data.submitter).toBe("submitter");expect(data.targetGroups).toBe("targetGroups");expect(data.targetPeople).toBe("targetPeople");expect(data.testingDone).toBe("testingDone");expect(data.testingDoneRichText).toBe(false)})});"use strict";suite("rb/resources/models/FileAttachment",function(){let model;beforeEach(function(){model=new RB.FileAttachment({parentObject:new RB.BaseResource({public:true})})});describe("toJSON",function(){describe("caption field",function(){it("With value",function(){model.set("caption","foo");const data=model.toJSON();expect(data.caption).toBe("foo")})});describe("file field",function(){it("With new file attachment",function(){expect(model.isNew()).toBe(true);model.set("file","abc");const data=model.toJSON();expect(data.path).toBe("abc")});it("With existing file attachment",function(){model.id=123;model.attributes.id=123;expect(model.isNew()).toBe(false);model.set("file","abc");const data=model.toJSON();expect(data.path).toBe(undefined)})})});describe("parse",function(){it("API payloads",function(){const data=model.parse({stat:"ok",file_attachment:{id:42,caption:"caption",url:"downloadURL",filename:"filename",review_url:"reviewURL",revision:123,thumbnail:"thumbnailHTML"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.caption).toBe("caption");expect(data.downloadURL).toBe("downloadURL");expect(data.filename).toBe("filename");expect(data.reviewURL).toBe("reviewURL");expect(data.revision).toBe(123);expect(data.thumbnailHTML).toBe("thumbnailHTML")})})});"use strict";suite("rb/resources/models/FileAttachmentComment",function(){const baseStrings=RB.BaseResource.strings;let model;beforeEach(function(){model=new RB.FileAttachmentComment({fileAttachmentID:16,parentObject:new RB.BaseResource({public:true})})});describe("parse",function(){it("API payloads",function(){const data=model.parse({stat:"ok",file_attachment_comment:{id:42,issue_opened:true,issue_status:"resolved",text_type:"markdown",text:"foo",extra_data:{my_int:123,my_bool:true,my_str:"strvalue",my_null:null},link_text:"my-link-text",thumbnail_html:"<blink>Boo</blink>",review_url:"/review-ui/",file_attachment:{id:10,filename:"file.txt"}}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.richText).toBe(true);expect(data.text).toBe("foo");expect(data.extraData).not.toBe(undefined);expect(data.extraData.my_int).toBe(123);expect(data.extraData.my_bool).toBe(true);expect(data.extraData.my_str).toBe("strvalue");expect(data.extraData.my_null).toBe(null);expect(data.linkText).toBe("my-link-text");expect(data.thumbnailHTML).toBe("<blink>Boo</blink>");expect(data.reviewURL).toBe("/review-ui/");expect(data.fileAttachment).not.toBe(undefined);expect(data.fileAttachment.id).toBe(10);expect(data.fileAttachment.get("filename")).toBe("file.txt");expect(data.fileAttachmentID).toBe(10)})});describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough();model.toJSON();expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()});describe("diff_against_file_attachment_id field",function(){it("When loaded",function(){model.set({loaded:true,diffAgainstFileAttachmentID:123});const data=model.toJSON();expect(data.diff_against_file_attachment_id).toBe(undefined)});describe("When not loaded",function(){it("With value",function(){model.set("diffAgainstFileAttachmentID",123);const data=model.toJSON();expect(data.diff_against_file_attachment_id).toBe(123)});it("Without value",function(){const data=model.toJSON();expect(data.diff_against_file_attachment_id).toBe(undefined)})})});describe("file_attachment_id field",function(){it("When loaded",function(){model.set({loaded:true,fileAttachmentID:123});const data=model.toJSON();expect(data.file_attachment_id).toBe(undefined)});it("When not loaded",function(){model.set("fileAttachmentID",123);const data=model.toJSON();expect(data.file_attachment_id).toBe(123)})});describe("force_text_type field",function(){it("With value",function(){model.set("forceTextType","html");const data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){model.set("includeTextTypes","html");const data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});it("extra_data field",function(){model.set({extraData:{my_int:123,my_bool:true,my_str:"strvalue",my_null:null}});const data=model.toJSON();expect(data["extra_data.my_int"]).toBe(123);expect(data["extra_data.my_bool"]).toBe(true);expect(data["extra_data.my_str"]).toBe("strvalue");expect(data["extra_data.my_null"]).toBe(null)})});describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate");model.validate({});expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()});describe("extraData",function(){describe("Valid values",function(){it("Empty object",function(){expect(model.validate({extraData:{}})).toBe(undefined)});it("Populated object",function(){expect(model.validate({extraData:{a:42}})).toBe(undefined)});it("Undefined",function(){expect(model.validate({extraData:undefined})).toBe(undefined)})});describe("Invalid values",function(){const errStr=baseStrings.INVALID_EXTRADATA_TYPE;it("Array",function(){expect(model.validate({extraData:""})).toBe(errStr)});it("Boolean",function(){expect(model.validate({extraData:false})).toBe(errStr)});it("Integer",function(){expect(model.validate({extraData:0})).toBe(errStr)});it("Null",function(){expect(model.validate({extraData:null})).toBe(errStr)});it("String",function(){expect(model.validate({extraData:""})).toBe(errStr)})})});describe("extraData entries",function(){describe("Valid values",function(){it("Booleans",function(){expect(model.validate({extraData:{value:true}})).toBe(undefined)});it("Integers",function(){expect(model.validate({extraData:{value:42}})).toBe(undefined)});it("Null",function(){expect(model.validate({extraData:{value:null}})).toBe(undefined)});it("Strings",function(){expect(model.validate({extraData:{value:"foo"}})).toBe(undefined)})});describe("Invalid values",function(){const errStr=baseStrings.INVALID_EXTRADATA_VALUE_TYPE.replace("{key}","value");it("Arrays",function(){expect(model.validate({extraData:{value:[1,2,3]}})).toBe(errStr)});it("NaN",function(){expect(model.validate({extraData:{value:NaN}})).toBe(errStr)});it("Objects",function(){expect(model.validate({extraData:{value:{a:1}}})).toBe(errStr)});it("Undefined",function(){expect(model.validate({extraData:{value:undefined}})).toBe(errStr)})})})})});"use strict";suite("rb/resources/models/FileDiff",function(){let model;beforeEach(function(){model=new RB.FileDiff({destFilename:"dest-file",sourceFilename:"source-file",sourceRevision:"source-revision"})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",filediff:{id:42,dest_file:"my-dest-file",source_file:"my-source-file",source_revision:"my-source-revision"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.destFilename).toBe("my-dest-file");expect(data.sourceFilename).toBe("my-source-file");expect(data.sourceRevision).toBe("my-source-revision")})})});"use strict";suite("rb/resources/models/GeneralComment",function(){let model;beforeEach(function(){model=new RB.GeneralComment({parentObject:new RB.BaseResource({public:true})})});describe("parse",function(){it("API payloads",function(){const data=model.parse({stat:"ok",general_comment:{id:42,issue_opened:true,issue_status:"resolved",text_type:"markdown",text:"foo"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.richText).toBe(true);expect(data.text).toBe("foo")})});describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough();model.toJSON();expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()})});describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate");model.validate({});expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()})})});"use strict";suite("rb/resources/models/Screenshot",function(){let model;beforeEach(function(){model=new RB.Screenshot({parentObject:new RB.BaseResource({public:true})})});describe("getDisplayName",function(){it("With caption",function(){model.set("caption","My Caption");expect(model.getDisplayName()).toBe("My Caption")});it("With filename",function(){model.set("filename","myfile.png");expect(model.getDisplayName()).toBe("myfile.png")});it("With caption and filename",function(){model.set({caption:"My Caption",filename:"myfile.png"});expect(model.getDisplayName()).toBe("My Caption")})});describe("parse",function(){it("API payloads",function(){const data=model.parse({stat:"ok",screenshot:{id:42,caption:"my-caption",filename:"my-filename",review_url:"/review-ui/"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.caption).toBe("my-caption");expect(data.filename).toBe("my-filename");expect(data.reviewURL).toBe("/review-ui/")})});describe("toJSON",function(){describe("caption field",function(){it("With value",function(){model.set("caption","foo");const data=model.toJSON();expect(data.caption).toBe("foo")})})})});"use strict";suite("rb/resources/models/ScreenshotComment",function(){const strings=RB.ScreenshotComment.strings;let model;beforeEach(function(){model=new RB.ScreenshotComment({screenshotID:16,parentObject:new RB.BaseResource({public:true}),x:0,y:0,width:1,height:1})});describe("parse",function(){it("API payloads",function(){const data=model.parse({stat:"ok",screenshot_comment:{id:42,issue_opened:true,issue_status:"resolved",text_type:"markdown",text:"foo",x:10,y:20,w:30,h:40,thumbnail_url:"/thumbnail.png",screenshot:{id:10,filename:"image.png"}}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.richText).toBe(true);expect(data.text).toBe("foo");expect(data.x).toBe(10);expect(data.y).toBe(20);expect(data.width).toBe(30);expect(data.height).toBe(40);expect(data.thumbnailURL).toBe("/thumbnail.png");expect(data.screenshot).not.toBe(undefined);expect(data.screenshot.id).toBe(10);expect(data.screenshot.get("filename")).toBe("image.png");expect(data.screenshotID).toBe(10)})});describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").and.callThrough();model.toJSON();expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()});it("x field",function(){model.set("x",10);const data=model.toJSON();expect(data.x).toBe(10)});it("y field",function(){model.set("y",10);const data=model.toJSON();expect(data.y).toBe(10)});it("w field",function(){model.set("width",10);const data=model.toJSON();expect(data.w).toBe(10)});it("h field",function(){model.set("height",10);const data=model.toJSON();expect(data.h).toBe(10)});describe("force_text_type field",function(){it("With value",function(){model.set("forceTextType","html");const data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){model.set("includeTextTypes","html");const data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.include_text_types).toBe(undefined)})})});describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate");model.validate({});expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()});describe("x",function(){describe("Valid values",function(){it("0",function(){expect(model.validate({x:0})).toBe(undefined)});it("> 0",function(){expect(model.validate({x:10})).toBe(undefined)})});describe("Invalid values",function(){it("< 0",function(){expect(model.validate({x:-1})).toBe(strings.INVALID_X)})})});describe("y",function(){describe("Valid values",function(){it("0",function(){expect(model.validate({y:0})).toBe(undefined)});it("> 0",function(){expect(model.validate({y:10})).toBe(undefined)})});describe("Invalid values",function(){it("< 0",function(){expect(model.validate({y:-1})).toBe(strings.INVALID_Y)})})});describe("width",function(){describe("Valid values",function(){it("> 0",function(){expect(model.validate({width:10})).toBe(undefined)})});describe("Invalid values",function(){it("0",function(){expect(model.validate({width:0})).toBe(strings.INVALID_WIDTH)});it("< 0",function(){expect(model.validate({width:-1})).toBe(strings.INVALID_WIDTH)})})});describe("height",function(){describe("Valid values",function(){it("> 0",function(){expect(model.validate({height:10})).toBe(undefined)})});describe("Invalid values",function(){it("0",function(){expect(model.validate({height:0})).toBe(strings.INVALID_HEIGHT)});it("< 0",function(){expect(model.validate({height:-1})).toBe(strings.INVALID_HEIGHT)})})})})});"use strict";suite("rb/resources/models/RepositoryBranch",function(){let model;beforeEach(function(){model=new RB.RepositoryBranch});describe("parse",function(){it("API payloads",function(){const data=model.parse({name:"master",commit:"c8ffef025488802a77f499d7f0d24579d858b07e",default:true});expect(data).not.toBe(undefined);expect(data.name).toBe("master");expect(data.commit).toBe("c8ffef025488802a77f499d7f0d24579d858b07e");expect(data.isDefault).toBe(true)})})});"use strict";suite("rb/resources/models/RepositoryCommit",function(){let model;beforeEach(function(){model=new RB.RepositoryCommit});describe("parse",function(){it("API payloads",function(){const data=model.parse({author_name:"Sneezy",date:"2013-06-25T23:31:22Z",id:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",message:"Here's a commit message\n\nWith a description",review_request_url:"http://example.com/r/12/"});expect(data).not.toBe(undefined);expect(data.authorName).toBe("Sneezy");expect(data.id).toBe("859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817");expect(data.date.getUTCFullYear()).toBe(2013);expect(data.date.getUTCDate()).toBe(25);expect(data.message).toBe("Here's a commit message\n\nWith a description");expect(data.summary).toBe("Here's a commit message");expect(data.reviewRequestURL).toBe("http://example.com/r/12/")})})});"use strict";suite("rb/resources/models/ReviewGroup",function(){describe("setStarred",function(){const url="/api/users/testuser/watched/groups/";let callbacks;let group;let session;beforeEach(function(){RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser",watchedReviewGroupsURL:url});group=new RB.ReviewGroup({id:1});callbacks={success:function(){},error:function(){}};spyOn(session.watchedGroups,"addImmediately").and.callThrough();spyOn(session.watchedGroups,"removeImmediately").and.callThrough();spyOn(RB,"apiCall").and.callThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});it("true",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("POST");expect(request.url).toBe(url);request.success({stat:"ok"})});group.setStarred(true,callbacks);expect(session.watchedGroups.addImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("false",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("DELETE");expect(request.url).toBe(url+"1/");request.success({stat:"ok"})});group.setStarred(false,callbacks);expect(session.watchedGroups.removeImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})});describe("addUser",function(){let callbacks;let group;beforeEach(function(){group=new RB.ReviewGroup({id:1,name:"test-group"});callbacks={success:function(){},error:function(){}};spyOn(RB,"apiCall").and.callThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});it("Loaded group",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("POST");expect(request.data.username).toBe("my-user");request.success({stat:"ok"})});group.addUser("my-user",callbacks);expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Unloaded group",function(){spyOn($,"ajax");group.set("id",null);expect(group.isNew()).toBe(true);group.addUser("my-user",callbacks);expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()})});describe("removeUser",function(){let callbacks;let group;beforeEach(function(){group=new RB.ReviewGroup({id:1,name:"test-group"});callbacks={success:function(){},error:function(){}};spyOn(RB,"apiCall").and.callThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});it("Loaded group",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("DELETE");request.success()});group.removeUser("my-user",callbacks);expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Unloaded group",function(){spyOn($,"ajax");group.set("id",null);expect(group.isNew()).toBe(true);group.removeUser("my-user",callbacks);expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()})})});"use strict";suite("rb/resources/models/Review",function(){let model;beforeEach(function(){model=new RB.Review({parentObject:new RB.ReviewRequest})});describe("createReply",function(){it("Returns cached draft reply",function(){expect(model.get("draftReply")).toBe(null);const reviewReply=model.createReply();expect(model.get("draftReply")).toBe(reviewReply);const reviewReply2=model.createReply();expect(reviewReply).toBe(reviewReply2)});it("Cached draft reply resets on publish",function(){const reviewReply=model.createReply();expect(model.get("draftReply")).toBe(reviewReply);reviewReply.trigger("published");expect(model.get("draftReply")).toBe(null)})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_review"});it("Common API payloads",function(){const data=model.parse({stat:"ok",my_review:{id:42,body_top:"my body top",body_bottom:"my body bottom",public:false,body_top_text_type:"markdown",body_bottom_text_type:"plain",ship_it:false}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.bodyTop).toBe("my body top");expect(data.bodyBottom).toBe("my body bottom");expect(data.public).toBe(false);expect(data.bodyTopRichText).toBe(true);expect(data.bodyBottomRichText).toBe(false);expect(data.shipIt).toBe(false)});it("With raw_text_fields",function(){const data=model.parse({stat:"ok",my_review:{body_top:"my body top",body_bottom:"my body bottom",body_top_text_type:"markdown",body_bottom_text_type:"plain",raw_text_fields:{body_top:"raw body top",body_top_text_type:"raw",body_bottom:"raw body bottom",body_bottom_text_type:"raw"}}});expect(data).not.toBe(undefined);expect(data.bodyTop).toBe("my body top");expect(data.bodyBottom).toBe("my body bottom");expect(data.bodyTopRichText).toBe(false);expect(data.bodyBottomRichText).toBe(false);expect(data.rawTextFields).toBeTruthy();expect(data.rawTextFields.bodyTop).toBe("raw body top");expect(data.rawTextFields.bodyBottom).toBe("raw body bottom")});it("With markdown_text_fields",function(){const data=model.parse({stat:"ok",my_review:{body_top:"my body top",body_bottom:"my body bottom",body_top_text_type:"markdown",body_bottom_text_type:"plain",markdown_text_fields:{body_top:"Markdown body top",body_top_text_type:"markdown",body_bottom:"Markdown body bottom",body_bottom_text_type:"markdown"}}});expect(data).not.toBe(undefined);expect(data.bodyTop).toBe("my body top");expect(data.bodyBottom).toBe("my body bottom");expect(data.bodyTopRichText).toBe(true);expect(data.bodyBottomRichText).toBe(false);expect(data.markdownTextFields).toBeTruthy();expect(data.markdownTextFields.bodyTop).toBe("Markdown body top");expect(data.markdownTextFields.bodyBottom).toBe("Markdown body bottom")});it("With html_text_fields",function(){const data=model.parse({stat:"ok",my_review:{body_top:"my body top",body_bottom:"my body bottom",body_top_text_type:"markdown",body_bottom_text_type:"plain",html_text_fields:{body_top:"HTML body top",body_top_text_type:"html",body_bottom:"HTML body bottom",body_bottom_text_type:"html"}}});expect(data).not.toBe(undefined);expect(data.bodyTop).toBe("my body top");expect(data.bodyBottom).toBe("my body bottom");expect(data.bodyTopRichText).toBe(true);expect(data.bodyBottomRichText).toBe(false);expect(data.htmlTextFields).toBeTruthy();expect(data.htmlTextFields.bodyTop).toBe("HTML body top");expect(data.htmlTextFields.bodyBottom).toBe("HTML body bottom")})});describe("toJSON",function(){describe("bodyTop field",function(){it("With value",function(){model.set("bodyTop","foo");const data=model.toJSON();expect(data.body_top).toBe("foo")})});describe("bodyBottom field",function(){it("With value",function(){model.set("bodyBottom","foo");const data=model.toJSON();expect(data.body_bottom).toBe("foo")})});describe("force_text_type field",function(){it("With value",function(){model.set("forceTextType","html");const data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){model.set("includeTextTypes","html");const data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("public field",function(){it("With value",function(){model.set("public",true);const data=model.toJSON();expect(data.public).toBe(1)});it("Without value",function(){const data=model.toJSON();expect(data.public).toBe(undefined)})});describe("bodyTopRichText field",function(){it("With true",function(){model.set("bodyTopRichText",true);const data=model.toJSON();expect(data.body_top_text_type).toBe("markdown")});it("With false",function(){model.set("bodyTopRichText",false);const data=model.toJSON();expect(data.body_top_text_type).toBe("plain")})});describe("bodyBottomRichText field",function(){it("With true",function(){model.set("bodyBottomRichText",true);const data=model.toJSON();expect(data.body_bottom_text_type).toBe("markdown")});it("With false",function(){model.set("bodyBottomRichText",false);const data=model.toJSON();expect(data.body_bottom_text_type).toBe("plain")})});describe("shipIt field",function(){it("With value",function(){model.set("shipIt",true);const data=model.toJSON();expect(data.ship_it).toBe(true)})})})});"use strict";suite("rb/resources/models/ReviewReply",function(){let parentObject;let model;beforeEach(function(){parentObject=new RB.BaseResource({public:true,links:{replies:{href:"/api/foos/replies/"}}});model=new RB.ReviewReply({parentObject:parentObject})});describe("destroy",function(){let callbacks;beforeEach(function(){callbacks={ready:function(){},error:function(){}};spyOn(Backbone.Model.prototype,"destroy").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"_retrieveDraft").and.callThrough();spyOn(parentObject,"ready").and.callFake((options,context)=>{if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(callbacks,"ready");spyOn(callbacks,"error")});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);spyOn(Backbone.Model.prototype,"fetch").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.error(model,{status:404})}})});it("With callbacks",function(){model.destroy(callbacks);expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(Backbone.Model.prototype.destroy).toHaveBeenCalled()})});describe("With isNew=false",function(){beforeEach(function(){model.set({id:123,loaded:true});spyOn(Backbone.Model.prototype,"fetch")});it("With callbacks",function(){model.destroy(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).not.toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled();expect(Backbone.Model.prototype.destroy).toHaveBeenCalled()})})});describe("discardIfEmpty",function(){let callbacks;beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(model,"destroy").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.success()}});spyOn(parentObject,"ready").and.callFake((options,context)=>{if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(model,"ready").and.callFake((options,context)=>{if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(callbacks,"success");spyOn(callbacks,"error")});it("With isNew=true",function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled()});describe("With isNew=false",function(){const commentsData={};beforeEach(function(){model.set({id:123,loaded:true,links:{self:{href:"/api/foos/replies/123/"},diff_comments:{href:"/api/diff-comments/"},screenshot_comments:{href:"/api/screenshot-comments/"},file_attachment_comments:{href:"/api/file-attachment-comments/"},general_comments:{href:"/api/general-comments/"}}});spyOn(RB,"apiCall").and.callFake(options=>{const links=model.get("links");const data={};const key=_.find(RB.ReviewReply.prototype.COMMENT_LINK_NAMES,name=>options.url===links[name].href);if(key){data[key]=commentsData[key]||[];options.success(data)}else{options.error({status:404})}});spyOn(Backbone.Model.prototype,"fetch").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.success()}})});it("With no comments or body replies",function(){model.discardIfEmpty(callbacks);expect(model.destroy).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(true)});it("With bodyTop",function(){model.set({bodyTop:"hi"});model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With bodyBottom",function(){model.set({bodyBottom:"hi"});model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With diff comment",function(){commentsData.diff_comments=[{id:1}];model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With screenshot comment",function(){commentsData.screenshot_comments=[{id:1}];model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With file attachment comment",function(){commentsData.file_attachment_comments=[{id:1}];model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With general comment",function(){commentsData.general_comments=[{id:1}];model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)})})});describe("ready",function(){let callbacks;beforeEach(function(){callbacks={ready:function(){},error:function(){}};spyOn(parentObject,"ready").and.callFake((options,context)=>{if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(callbacks,"ready");spyOn(callbacks,"error")});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);spyOn(Backbone.Model.prototype,"fetch").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"_retrieveDraft").and.callFake((options,context)=>{if(options&&_.isFunction(options.ready)){options.ready.call(context)}})});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})});describe("With isNew=false",function(){beforeEach(function(){model.set({id:123});spyOn(Backbone.Model.prototype,"fetch").and.callFake(options=>{if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"_retrieveDraft").and.callFake((options,context)=>{if(options&&_.isFunction(options.ready)){options.ready.call(context)}})});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})});it("After destruction",function(){spyOn(model,"_retrieveDraft").and.callThrough();spyOn(Backbone.Model.prototype,"fetch").and.callFake(options=>{model.set({id:123,links:{self:{href:"/api/foos/replies/123/"}},loaded:true});options.success()});spyOn(Backbone.Model.prototype,"destroy").and.callFake(options=>options.success());expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);expect(model._needDraft).toBe(undefined);model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(model.isNew()).toBe(false);expect(model.get("loaded")).toBe(true);expect(model._needDraft).toBe(false);model.destroy(callbacks);expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);expect(model._needDraft).toBe(true);parentObject.ready.calls.reset();model._retrieveDraft.calls.reset();callbacks.ready.calls.reset();model.ready(callbacks);expect(model._retrieveDraft).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(model._needDraft).toBe(false)})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_reply"});it("API payloads",function(){var data=model.parse({stat:"ok",my_reply:{id:42,body_top:"foo",body_bottom:"bar",public:false,body_top_text_type:"markdown",body_bottom_text_type:"plain"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.bodyTop).toBe("foo");expect(data.bodyBottom).toBe("bar");expect(data.public).toBe(false);expect(data.bodyTopRichText).toBe(true);expect(data.bodyBottomRichText).toBe(false)})});describe("toJSON",function(){describe("bodyTop field",function(){it("With value",function(){model.set("bodyTop","foo");const data=model.toJSON();expect(data.body_top).toBe("foo")})});describe("bodyBottom field",function(){it("With value",function(){model.set("bodyBottom","foo");const data=model.toJSON();expect(data.body_bottom).toBe("foo")})});describe("bodyTopRichText field",function(){it("With true",function(){model.set("bodyTopRichText",true);const data=model.toJSON();expect(data.body_top_text_type).toBe("markdown")});it("With false",function(){model.set("bodyTopRichText",false);const data=model.toJSON();expect(data.body_top_text_type).toBe("plain")})});describe("bodyBottomRichText field",function(){it("With true",function(){model.set("bodyBottomRichText",true);const data=model.toJSON();expect(data.body_bottom_text_type).toBe("markdown")});it("With false",function(){model.set("bodyBottomRichText",false);const data=model.toJSON();expect(data.body_bottom_text_type).toBe("plain")})});describe("force_text_type field",function(){it("With value",function(){model.set("forceTextType","html");const data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){model.set("includeTextTypes","html");const data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){const data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("public field",function(){it("With value",function(){model.set("public",true);const data=model.toJSON();expect(data.public).toBe(true)})})})});"use strict";suite("rb/resources/models/ReviewRequest",function(){let reviewRequest;let callbacks;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:1});callbacks={success:()=>{},error:()=>{}};spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(reviewRequest,"ready").and.callFake((options,context)=>options.ready.call(context))});it("createDiff",function(){const diff=reviewRequest.createDiff();expect(diff.get("parentObject")).toBe(reviewRequest)});it("createScreenshot",function(){const screenshot=reviewRequest.createScreenshot(42);expect(screenshot.get("parentObject")).toBe(reviewRequest);expect(screenshot.id).toBe(42)});it("createFileAttachment",function(){const fileAttachment=reviewRequest.createFileAttachment({id:42});expect(fileAttachment.get("parentObject")).toBe(reviewRequest);expect(fileAttachment.id).toBe(42)});it("parse",function(){const data=reviewRequest.parse({stat:"ok",review_request:{id:1,branch:"branch",bugs_closed:"bugsClosed",close_description:"closeDescription",close_description_text_type:"markdown",description:"description",description_text_type:"markdown",last_updated:"lastUpdated",public:"public",summary:"summary",target_groups:"targetGroups",target_people:"targetPeople",testing_done:"testingDone",testing_done_text_type:"plain"}});expect(data).not.toBe(undefined);expect(data.id).toBe(1);expect(data.branch).toBe("branch");expect(data.bugsClosed).toBe("bugsClosed");expect(data.closeDescription).toBe("closeDescription");expect(data.closeDescriptionRichText).toBe(true);expect(data.description).toBe("description");expect(data.descriptionRichText).toBe(true);expect(data.lastUpdated).toBe("lastUpdated");expect(data.public).toBe("public");expect(data.summary).toBe("summary");expect(data.targetGroups).toBe("targetGroups");expect(data.targetPeople).toBe("targetPeople");expect(data.testingDone).toBe("testingDone");expect(data.testingDoneRichText).toBe(false)});it("reopen",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("PUT");expect(request.data.status).toBe("pending");request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.reopen({success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});describe("createReview",function(){it("With review ID",function(){const review=reviewRequest.createReview(42);expect(review.get("parentObject")).toBe(reviewRequest);expect(review.get("id")).toBe(42);expect(reviewRequest.get("draftReview")).toBe(null);expect(reviewRequest.reviews.length).toBe(1);expect(reviewRequest.reviews.get(42)).toBe(review)});it("Without review ID",function(){const review1=reviewRequest.createReview();const review2=reviewRequest.createReview();expect(review1.get("parentObject")).toBe(reviewRequest);expect(review1.id).toBeFalsy();expect(reviewRequest.get("draftReview")).toBe(review1);expect(review1).toBe(review2);expect(reviewRequest.reviews.length).toBe(0)})});describe("setStarred",function(){const url="/api/users/testuser/watched/review-requests/";let session;beforeEach(function(){RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser",watchedReviewRequestsURL:url});spyOn(session.watchedReviewRequests,"addImmediately").and.callThrough();spyOn(session.watchedReviewRequests,"removeImmediately").and.callThrough();spyOn(RB,"apiCall").and.callThrough()});it("true",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("POST");expect(request.url).toBe(url);request.success({stat:"ok"})});reviewRequest.setStarred(true,callbacks);expect(session.watchedReviewRequests.addImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("false",function(){spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("DELETE");expect(request.url).toBe(url+"1/");request.success({stat:"ok"})});reviewRequest.setStarred(false,callbacks);expect(session.watchedReviewRequests.removeImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})});describe("close",function(){it("With type=CLOSE_DISCARDED",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("PUT");expect(request.data.status).toBe("discarded");expect(request.data.description).toBe(undefined);request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.close({type:RB.ReviewRequest.CLOSE_DISCARDED,success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With type=CLOSE_SUBMITTED",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("PUT");expect(request.data.status).toBe("submitted");expect(request.data.description).toBe(undefined);request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.close({type:RB.ReviewRequest.CLOSE_SUBMITTED,success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With invalid type",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax");reviewRequest.close({type:"foo",success:callbacks.success,error:callbacks.error});expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()});it("With description",function(){spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("PUT");expect(request.data.status).toBe("submitted");expect(request.data.close_description).toBe("test");request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.close({type:RB.ReviewRequest.CLOSE_SUBMITTED,description:"test",success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})})});"use strict";suite("rb/resources/models/UserFileAttachment",function(){let model;beforeEach(function(){model=new RB.UserFileAttachment});describe("toJSON",function(){describe("caption field",function(){it("With value",function(){model.set("caption","foo");const data=model.toJSON();expect(data.caption).toBe("foo")})});describe("file field",function(){it("With no file attachment",function(){model.id=123;model.attributes.id=123;expect(model.isNew()).toBe(false);const data=model.toJSON();expect(data.path).toBe(undefined)});it("With file attachment",function(){model.id=123;model.attributes.id=123;expect(model.isNew()).toBe(false);model.set("file","abc");const data=model.toJSON();expect(data.path).toBe("abc")})})});describe("parse",function(){it("API payloads",function(){const data=model.parse({stat:"ok",user_file_attachment:{id:42,caption:"caption",absolute_url:"downloadURL",filename:"filename"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.caption).toBe("caption");expect(data.downloadURL).toBe("downloadURL");expect(data.filename).toBe("filename")})})});"use strict";suite("rb/resources/models/ValidateDiffModel",function(){let model;beforeEach(function(){model=new RB.ValidateDiffModel});describe("methods",function(){describe("url",function(){it("Without local site",function(){expect(_.result(model,"url")).toBe("/api/validation/diffs/")});it("With local site",function(){model.set("localSitePrefix","s/test-site/");expect(_.result(model,"url")).toBe("/s/test-site/api/validation/diffs/")})})});describe("toJSON",function(){it("repository field",function(){model.set("repository",123);const data=model.toJSON();expect(data.repository).toBe(123)})})});"use strict";suite("rb/reviewRequestPage/models/ChangeEntry",function(){it("parse",function(){const diffCommentsData=[["1","100"],["2","100-101"]];const reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest});const entry=new RB.ReviewRequestPage.ChangeEntry({diffCommentsData:diffCommentsData,id:"100",typeID:"changedesc",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",pendingStatusUpdates:true,reviewsData:[{id:123,bodyTop:"My body top",bodyBottom:"My body bottom",public:true,shipIt:false}],reviewRequestEditor:reviewRequestEditor,ignoredAttr:"ignored"},{parse:true});expect(entry.id).toBe("100");expect(entry.get("diffCommentsData")).toBe(diffCommentsData);expect(entry.get("reviewRequestEditor")).toBe(reviewRequestEditor);expect(entry.get("typeID")).toBe("changedesc");expect(entry.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25)));expect(entry.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0)));expect(entry.get("pendingStatusUpdates")).toBe(true);expect(entry.get("ignoredAttr")).toBe(undefined);const reviews=entry.get("reviews");expect(reviews.length).toBe(1);const review=reviews[0];expect(review.get("id")).toBe(123);expect(review.get("bodyTop")).toBe("My body top");expect(review.get("bodyBottom")).toBe("My body bottom");expect(review.get("public")).toBe(true);expect(review.get("shipIt")).toBe(false)})});"use strict";suite("rb/reviewRequestPage/models/Entry",function(){let reviewRequestEditor;let entry;beforeEach(function(){reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest});entry=new RB.ReviewRequestPage.Entry({reviewRequestEditor:reviewRequestEditor,id:"123",typeID:"some_type",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",ignoredAttr:"ignored"},{parse:true})});it("parse",function(){expect(entry.id).toBe("123");expect(entry.get("reviewRequestEditor")).toBe(reviewRequestEditor);expect(entry.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25)));expect(entry.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0)));expect(entry.get("typeID")).toBe("some_type")});describe("isUpdated",function(){it("With newer updateTimestamp only",function(){const metadata={updatedTimestamp:"2017-08-20T23:10:12Z"};expect(entry.isUpdated(metadata)).toBe(true)});it("With older updateTimestamp only",function(){const metadata={updatedTimestamp:"2017-08-18T12:10:12Z"};expect(entry.isUpdated(metadata)).toBe(false)});it("With changed etag",function(){const metadata={etag:"new-etag",updatedTimestamp:"2017-08-18T16:20:00Z"};expect(entry.isUpdated(metadata)).toBe(true)});it("With same updateTimestamp and etag",function(){entry.set("etag","old-etag");const metadata={etag:"old-etag",updatedTimestamp:"2017-08-18T16:20:00Z"};expect(entry.isUpdated(metadata)).toBe(false)})})});"use strict";suite("rb/reviewRequestPage/models/ReviewEntry",function(){it("parse",function(){const diffCommentsData=[["1","100"],["2","100-101"]];const reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest});const entry=new RB.ReviewRequestPage.ReviewEntry({diffCommentsData:diffCommentsData,id:"100",typeID:"review",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",reviewData:{id:123,bodyTop:"My body top",bodyBottom:"My body bottom",public:true,shipIt:false},reviewRequestEditor:reviewRequestEditor,ignoredAttr:"ignored"},{parse:true});expect(entry.id).toBe("100");expect(entry.get("diffCommentsData")).toBe(diffCommentsData);expect(entry.get("reviewRequestEditor")).toBe(reviewRequestEditor);expect(entry.get("typeID")).toBe("review");expect(entry.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25)));expect(entry.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0)));expect(entry.get("ignoredAttr")).toBe(undefined);const review=entry.get("review");expect(review).toBeTruthy();expect(review.get("id")).toBe(123);expect(review.get("bodyTop")).toBe("My body top");expect(review.get("bodyBottom")).toBe("My body bottom");expect(review.get("public")).toBe(true);expect(review.get("shipIt")).toBe(false)})});"use strict";suite("rb/reviewRequestPage/models/ReviewReplyEditor",function(){let reviewReply;let review;let editor;beforeEach(function(){review=new RB.Review({loaded:true,links:{replies:{href:"/api/review/123/replies/"}}});reviewReply=review.createReply();spyOn(review,"ready").and.callFake((options,context)=>options.ready.call(context));spyOn(reviewReply,"ensureCreated").and.callFake((options,context)=>options.success.call(context));spyOn(reviewReply,"ready").and.callFake((options,context)=>options.ready.call(context))});describe("Event handling",function(){describe("reviewReply changes",function(){beforeEach(function(){editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"body_top",review:review,reviewReply:reviewReply,text:"My Text"})});it("Sets up events on new reviewReply",function(){spyOn(editor,"listenTo").and.callThrough();const reviewReply=new RB.ReviewReply;editor.set("reviewReply",reviewReply);expect(editor.listenTo.calls.count()).toEqual(2);expect(editor.listenTo.calls.argsFor(0)[1]).toEqual("destroyed");expect(editor.listenTo.calls.argsFor(1)[1]).toEqual("published")});it("Removes events from old reviewReply",function(){editor.set("reviewReply",new RB.ReviewReply);expect(editor._listeningTo.hasOwnProperty(reviewReply._listenId)).toBe(false)})})});describe("Methods",function(){describe("save",function(){function testBodySave(options){editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:options.contextType,review:review,reviewReply:reviewReply,richText:options.richText,text:"My Text"});spyOn(editor,"trigger");spyOn(reviewReply,"save").and.callFake((options,context)=>options.success.call(context));editor.save();expect(editor.get("replyObject")).toBe(reviewReply);expect(editor.get("hasDraft")).toBe(true);expect(editor.get("text")).toBe("My Text");expect(editor.get("richText")).toBe(true);expect(reviewReply.get(options.textAttr)).toBe("My Text");expect(reviewReply.get(options.richTextAttr)).toBe(options.richText);expect(reviewReply.ready).toHaveBeenCalled();expect(reviewReply.save).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving");expect(editor.trigger).toHaveBeenCalledWith("saved")}function testCommentSave(options){editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:options.contextType,hasDraft:false,review:review,reviewReply:reviewReply,richText:options.richText,text:"My Text"});spyOn(editor,"trigger");spyOn(options.model.prototype,"ready").and.callFake((options,context)=>options.ready.call(context));spyOn(options.model.prototype,"save").and.callFake((options,context)=>options.success.call(context));editor.save();const replyObject=editor.get("replyObject");expect(editor.get("hasDraft")).toBe(true);expect(editor.get("text")).toBe("My Text");expect(editor.get("richText")).toBe(true);expect(replyObject instanceof options.model).toBe(true);expect(replyObject.get("text")).toBe("My Text");expect(replyObject.get("richText")).toBe(options.richText);expect(options.model.prototype.ready).toHaveBeenCalled();expect(options.model.prototype.save).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving");expect(editor.trigger).toHaveBeenCalledWith("saved")}it("With existing reply object",function(){const replyObject=new RB.DiffCommentReply;editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"diff_comments",hasDraft:false,replyObject:replyObject,review:review,reviewReply:reviewReply,text:"My Text"});spyOn(editor,"trigger");spyOn(replyObject,"ready").and.callFake((options,context)=>options.ready.call(context));spyOn(replyObject,"save").and.callFake((options,context)=>options.success.call(context));editor.save();expect(editor.get("hasDraft")).toBe(true);expect(editor.get("replyObject")).toBe(replyObject);expect(replyObject.get("text")).toBe("My Text");expect(replyObject.ready).toHaveBeenCalled();expect(replyObject.save).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving");expect(editor.trigger).toHaveBeenCalledWith("saved")});it("With empty text",function(){const replyObject=new RB.DiffCommentReply({text:"Orig Text"});editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"diff_comments",review:review,reviewReply:reviewReply});spyOn(editor,"trigger");spyOn(editor,"resetStateIfEmpty");spyOn(replyObject,"ready").and.callFake((options,context)=>options.ready.call(context));spyOn(replyObject,"save");editor.set({hasDraft:false,replyObject:replyObject,text:""});editor.save();expect(editor.get("hasDraft")).toBe(false);expect(editor.get("replyObject")).toBe(replyObject);expect(replyObject.get("text")).toBe("Orig Text");expect(replyObject.ready).toHaveBeenCalled();expect(replyObject.save).not.toHaveBeenCalled();expect(editor.resetStateIfEmpty).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving")});describe("With body_top",function(){function testSave(richText){testBodySave({contextType:"body_top",textAttr:"bodyTop",richTextAttr:"bodyTopRichText",richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With body_bottom",function(){function testSave(richText){testBodySave({contextType:"body_bottom",textAttr:"bodyBottom",richTextAttr:"bodyBottomRichText",richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With diff comments",function(){function testSave(richText){testCommentSave({contextType:"diff_comments",model:RB.DiffCommentReply,richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With file attachment comments",function(){function testSave(richText){testCommentSave({contextType:"file_attachment_comments",model:RB.FileAttachmentCommentReply,richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With general comments",function(){function testSave(richText){testCommentSave({contextType:"general_comments",model:RB.GeneralCommentReply,richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With screenshot comments",function(){function testSave(richText){testCommentSave({contextType:"screenshot_comments",model:RB.ScreenshotCommentReply,richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})})});describe("resetStateIfEmpty",function(){let replyObject;beforeEach(function(){replyObject=new RB.DiffCommentReply;editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextType:"diff_comments",hasDraft:true,replyObject:replyObject,review:review,reviewReply:reviewReply});spyOn(editor,"trigger");spyOn(replyObject,"destroy").and.callFake((options,context)=>options.success.call(context))});it("Without empty text",function(){editor.set("text","My Text");editor.resetStateIfEmpty();expect(replyObject.destroy).not.toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(true);expect(editor.trigger).not.toHaveBeenCalledWith("resetState")});describe("With empty text",function(){it("With no reply object",function(){editor.set("replyObject",null);editor.resetStateIfEmpty();expect(replyObject.destroy).not.toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("resetState")});it("With new reply object",function(){replyObject.set("id",null);editor.resetStateIfEmpty();expect(replyObject.destroy).not.toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("resetState")});it("With existing reply object",function(){replyObject.set("id",123);editor.resetStateIfEmpty();expect(replyObject.destroy).toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("resetState")});describe("With context type",function(){beforeEach(function(){replyObject.set("id",123);spyOn(editor,"_resetState");spyOn(reviewReply,"discardIfEmpty")});it("body_top",function(){editor.set("contextType","body_top");editor.resetStateIfEmpty();expect(replyObject.destroy).not.toHaveBeenCalled();expect(editor._resetState).toHaveBeenCalledWith(true)});it("body_bottom",function(){editor.set("contextType","body_bottom");editor.resetStateIfEmpty();expect(replyObject.destroy).not.toHaveBeenCalled();expect(editor._resetState).toHaveBeenCalledWith(true)});it("diff_comments",function(){editor.set("contextType","diff_comments");editor.resetStateIfEmpty();expect(replyObject.destroy).toHaveBeenCalled();expect(editor._resetState).toHaveBeenCalledWith()});it("file_attachment_comments",function(){editor.set("contextType","file_attachment_comments");editor.resetStateIfEmpty();expect(replyObject.destroy).toHaveBeenCalled();expect(editor._resetState).toHaveBeenCalledWith()});it("general_comments",function(){editor.set("contextType","general_comments");editor.resetStateIfEmpty();expect(replyObject.destroy).toHaveBeenCalled();expect(editor._resetState).toHaveBeenCalledWith()});it("screenshot_comments",function(){editor.set("contextType","screenshot_comments");editor.resetStateIfEmpty();expect(replyObject.destroy).toHaveBeenCalled();expect(editor._resetState).toHaveBeenCalledWith()})})})})})});"use strict";suite("rb/reviewRequestPage/models/ReviewRequestPage",function(){let page;beforeEach(function(){page=new RB.ReviewRequestPage.ReviewRequestPage({updatesURL:"/r/123/_updates/",checkForUpdates:false,reviewRequestData:{},editorData:{fileAttachments:[],mutableByUser:true,showSendEmail:false}},{parse:true})});describe("Methods",function(){it("addEntry",function(){const entry=new RB.ReviewRequestPage.Entry;page.addEntry(entry);expect(entry.get("page")).toBe(page);expect(page.entries.at(0)).toBe(entry)});describe("parse",function(){it("Parent called",function(){const attrs=page.parse({reviewRequestData:{summary:"Test summary"}});expect(attrs.reviewRequest).toBeTruthy();expect(attrs.reviewRequest.get("summary")).toBe("Test summary")});it("updatesURL",function(){const attrs=page.parse({updatesURL:"https://example.com/"});expect(attrs.updatesURL).toBe("https://example.com/")})});describe("watchEntryUpdates",function(){let entry;beforeEach(function(){spyOn(page,"_scheduleCheckUpdates");entry=new RB.ReviewRequestPage.Entry({id:"my-entry"})});it("First call",function(){page.watchEntryUpdates(entry,1e3);expect(page._watchedUpdatesPeriodMS).toBe(1e3);expect(page._watchedEntries[entry.id]).toEqual({entry:entry,periodMS:1e3});expect(page._scheduleCheckUpdates).toHaveBeenCalled()});it("Shorter watch periods take precedent",function(){page._watchedUpdatesPeriodMS=5e3;page.watchEntryUpdates(entry,1e3);expect(page._watchedUpdatesPeriodMS).toBe(1e3);expect(page._watchedEntries[entry.id]).toEqual({entry:entry,periodMS:1e3});expect(page._scheduleCheckUpdates).toHaveBeenCalled()});it("Subsequent call with longer watch period",function(){page._watchedUpdatesPeriodMS=1e3;page.watchEntryUpdates(entry,5e3);expect(page._watchedUpdatesPeriodMS).toBe(1e3);expect(page._watchedEntries[entry.id]).toEqual({entry:entry,periodMS:5e3});expect(page._scheduleCheckUpdates).toHaveBeenCalled()})});describe("stopWatchingEntryUpdates",function(){beforeEach(function(){spyOn(page,"_scheduleCheckUpdates")});it("Switches to next-shortest update period",function(){const entry1=new RB.ReviewRequestPage.Entry({id:"1"});const entry2=new RB.ReviewRequestPage.Entry({id:"2"});page.watchEntryUpdates(entry1,2e3);page.watchEntryUpdates(entry2,1e3);expect(page._watchedUpdatesPeriodMS).toBe(1e3);page.stopWatchingEntryUpdates(entry2);expect(page._watchedUpdatesPeriodMS).toBe(2e3)});it("Last entry being watched",function(){const entry=new RB.ReviewRequestPage.Entry({id:"1"});page.watchEntryUpdates(entry,1e3);page.stopWatchingEntryUpdates(entry);expect(_.isEmpty(page._watchedEntries)).toBe(true);expect(page._watchedUpdatesTimeout).toBe(null);expect(page._watchedUpdatesPeriodMS).toBe(null);expect(page._watchedUpdatesLastScheduleTime).toBe(null)})})});describe("Dynamic updating",function(){it("Scheduled check for update",function(){let scheduledCallback=null;spyOn(page,"_scheduleCheckUpdates").and.callThrough();spyOn(window,"setTimeout").and.callFake((cb,ms)=>{scheduledCallback=cb;return"dummy value"});spyOn(page,"_loadUpdates").and.callThrough();spyOn(Backbone,"sync");const entry1=new RB.ReviewRequestPage.Entry({typeID:"my-entry",id:"100"});const entry2=new RB.ReviewRequestPage.Entry({typeID:"my-entry",id:"200"});const entry3=new RB.ReviewRequestPage.Entry({typeID:"another-entry",id:"foo"});page.watchEntryUpdates(entry1,2e3);page.watchEntryUpdates(entry2,1e3);page.watchEntryUpdates(entry3,2e3);expect(scheduledCallback).not.toBe(null);expect(page._scheduleCheckUpdates).toHaveBeenCalled();expect(page._watchedUpdatesLastScheduleTime).not.toBe(null);expect(page._watchedUpdatesTimeout).not.toBe(null);scheduledCallback();expect(page._watchedUpdatesLastScheduleTime).not.toBe(null);expect(page._watchedUpdatesTimeout).toBe(null);expect(page._loadUpdates.calls.count()).toBe(1);expect(page._loadUpdates.calls.mostRecent().args[0].entries).toEqual([entry1,entry2,entry3]);expect(Backbone.sync.calls.count()).toBe(1);const callOptions=Backbone.sync.calls.mostRecent().args[2];expect(callOptions.url).toBe("/r/123/_updates/?entries=my-entry:100,200"+";another-entry:foo");expect(callOptions.noActivityIndicator).toBe(true);expect(callOptions.dataType).toBe("arraybuffer")});describe("Response parsing",function(){const TestEntry=RB.ReviewRequestPage.Entry.extend({parse(rsp){return _.extend({myAttr:rsp.myAttr},RB.ReviewRequestPage.Entry.prototype.parse.call(this,rsp))}});let entry1;let entry2;beforeEach(function(){spyOn(page,"trigger").and.callThrough();entry1=new TestEntry({typeID:"my-entry",id:"1",addedTimestamp:new Date(Date.UTC(2017,7,1,0,0,0)),updatedTimestamp:new Date(Date.UTC(2017,7,1,12,0,0))});entry2=new TestEntry({typeID:"my-entry",id:"2",addedTimestamp:new Date(Date.UTC(2017,7,1,0,0,0)),updatedTimestamp:new Date(Date.UTC(2017,7,1,12,0,0))});page.addEntry(entry1);page.addEntry(entry2)});it("Updates to outdated entries using timetamps",function(done){spyOn(entry1,"beforeApplyUpdate");spyOn(entry1,"afterApplyUpdate");spyOn(entry2,"beforeApplyUpdate");spyOn(entry2,"afterApplyUpdate");spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");expect(options.url).toBe("/r/123/_updates/");const metadata1=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "1", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-04T14:30:20", ','"modelData": {"myAttr": "value1"}}']);const metadata2=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "2", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-03T14:30:20", ','"modelData": {"myAttr": "value2"}}']);const html1=new Blob(["<p>My HTML!</p>"]);const html2=new Blob(["<p>Oh hi!</p>"]);const blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[177]}],metadata1,[{type:"uint32",values:[15]}],html1,[{type:"uint32",values:[177]}],metadata2,[{type:"uint32",values:[13]}],html2]);RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});page._loadUpdates({onDone:()=>{const metadata1={type:"entry",entryType:"my-entry",entryID:"1",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-04T14:30:20",modelData:{myAttr:"value1"}};const html1="<p>My HTML!</p>";expect(entry1.get("myAttr")).toBe("value1");expect(entry1.get("etag")).toBe(null);expect(entry1.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,8,4,14,30,20)));expect(entry1.beforeApplyUpdate).toHaveBeenCalledWith(metadata1);expect(entry1.afterApplyUpdate).toHaveBeenCalledWith(metadata1);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry",metadata1,html1);const metadata2={type:"entry",entryType:"my-entry",entryID:"2",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-03T14:30:20",modelData:{myAttr:"value2"}};const html2="<p>Oh hi!</p>";expect(entry2.get("myAttr")).toBe("value2");expect(entry2.get("etag")).toBe(null);expect(entry2.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,8,3,14,30,20)));expect(entry2.beforeApplyUpdate).toHaveBeenCalledWith(metadata2);expect(entry2.afterApplyUpdate).toHaveBeenCalledWith(metadata2);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("updatesProcessed");done()}})});it("Updates to outdated entries using etags",function(done){entry1.set("etag","old-etag");entry2.set("etag","old-etag");spyOn(entry1,"beforeApplyUpdate");spyOn(entry1,"afterApplyUpdate");spyOn(entry2,"beforeApplyUpdate");spyOn(entry2,"afterApplyUpdate");spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");expect(options.url).toBe("/r/123/_updates/");const metadata1=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "1", ','"etag": "new-etag", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-07-01T12:00:00", ','"modelData": {"myAttr": "value1"}}']);const metadata2=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "2", ','"etag": "new-etag", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-07-01T12:00:00", ','"modelData": {"myAttr": "value2"}}']);const html1=new Blob(["<p>My HTML!</p>"]);const html2=new Blob(["<p>Oh hi!</p>"]);const blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[197]}],metadata1,[{type:"uint32",values:[15]}],html1,[{type:"uint32",values:[197]}],metadata2,[{type:"uint32",values:[13]}],html2]);RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});page._loadUpdates({onDone:()=>{const metadata1={type:"entry",entryType:"my-entry",entryID:"1",etag:"new-etag",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-07-01T12:00:00",modelData:{myAttr:"value1"}};const html1="<p>My HTML!</p>";expect(entry1.get("myAttr")).toBe("value1");expect(entry1.get("etag")).toBe("new-etag");expect(entry1.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,6,1,12,0,0)));expect(entry1.beforeApplyUpdate).toHaveBeenCalledWith(metadata1);expect(entry1.afterApplyUpdate).toHaveBeenCalledWith(metadata1);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry",metadata1,html1);const metadata2={type:"entry",entryType:"my-entry",entryID:"2",etag:"new-etag",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-07-01T12:00:00",modelData:{myAttr:"value2"}};const html2="<p>Oh hi!</p>";expect(entry2.get("myAttr")).toBe("value2");expect(entry2.get("etag")).toBe("new-etag");expect(entry2.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,6,1,12,0,0)));expect(entry2.beforeApplyUpdate).toHaveBeenCalledWith(metadata2);expect(entry2.afterApplyUpdate).toHaveBeenCalledWith(metadata2);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("updatesProcessed");done()}})});it("Updates to up-to-date entries",function(done){entry1.set({etag:"old-etag",myAttr:"existing-value"});spyOn(entry1,"beforeApplyUpdate");spyOn(entry1,"afterApplyUpdate");spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");expect(options.url).toBe("/r/123/_updates/");const metadata=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "1", ','"etag": "old-etag", ','"addedTimestamp": "2016-09-04T14:30:20", ','"updatedTimestamp": "2016-12-10T12:24:14", ','"modelData": {"myAttr": "value1"}}']);const html=new Blob(["<p>My HTML!</p>"]);let blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[metadata.size]}],metadata,[{type:"uint32",values:[html.size]}],html]);RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});page._loadUpdates({onDone:()=>{const metadata1={type:"entry",entryType:"my-entry",entryID:"1",etag:"old-etag",addedTimestamp:"2016-09-04T14:30:20",updatedTimestamp:"2016-09-04T14:30:20",modelData:{myAttr:"value1"}};const html1="<p>My HTML!</p>";expect(entry1.get("myAttr")).toBe("existing-value");expect(entry1.get("etag")).toBe("old-etag");expect(entry1.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,1,12,0,0)));expect(entry1.beforeApplyUpdate).not.toHaveBeenCalled();expect(entry1.afterApplyUpdate).not.toHaveBeenCalled();expect(page.trigger).not.toHaveBeenCalledWith("applyingUpdate:entry",metadata1,html1);expect(page.trigger).not.toHaveBeenCalledWith("applyingUpdate:entry:1",metadata1,html1);expect(page.trigger).not.toHaveBeenCalledWith("appliedModelUpdate:entry:1",metadata1,html1);expect(page.trigger).not.toHaveBeenCalledWith("appliedUpdate:entry:1",metadata1,html1);expect(page.trigger).not.toHaveBeenCalledWith("appliedUpdate:entry",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("updatesProcessed");done()}})});it("Updates to non-entries",function(done){spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");expect(options.url).toBe("/r/123/_updates/");const metadata=new Blob(['{"type": "something", "foo": "bar"}']);const html=new Blob(["<div>Something</div>"]);let blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[metadata.size]}],metadata,[{type:"uint32",values:[html.size]}],html]);RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});page._loadUpdates({onDone:()=>{const metadata={type:"something",foo:"bar"};const html="<div>Something</div>";expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:something",metadata,html);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:something",metadata,html);expect(page.trigger).toHaveBeenCalledWith("updatesProcessed");done()}})});it("Updates containing Unicode in HTML",function(done){spyOn(entry1,"beforeApplyUpdate");spyOn(entry1,"afterApplyUpdate");spyOn(entry2,"beforeApplyUpdate");spyOn(entry2,"afterApplyUpdate");spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");expect(options.url).toBe("/r/123/_updates/");const metadata1=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "1", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-04T14:30:20", ','"modelData": {"myAttr": "value1"}}']);const metadata2=new Blob(['{"type": "entry", ','"entryType": "my-entry", ','"entryID": "2", ','"addedTimestamp": "2017-07-01T00:00:00", ','"updatedTimestamp": "2017-09-03T14:30:20", ','"modelData": {"myAttr": "value2"}}']);const html1=[60,115,112,97,110,62,195,161,195,169,195,173,195,179,195,186,32,240,159,148,165,60,47,115,112,97,110,62];const html2=[60,115,112,97,110,62,195,132,195,139,195,143,195,150,195,156,197,184,32,240,159,152,177,60,47,115,112,97,110,62];expect(html1.length).toBe(28);expect(html2.length).toBe(30);let blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[metadata1.size]}],metadata1,[{type:"uint32",values:[html1.length]},{type:"uint8",values:html1},{type:"uint32",values:[metadata2.size]}],metadata2,[{type:"uint32",values:[html2.length]},{type:"uint8",values:html2}]]);RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});page._loadUpdates({onDone:()=>{const metadata1={type:"entry",entryType:"my-entry",entryID:"1",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-04T14:30:20",modelData:{myAttr:"value1"}};const html1="<span>áéíóú 🔥</span>";expect(entry1.get("myAttr")).toBe("value1");expect(entry1.get("etag")).toBe(null);expect(entry1.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,8,4,14,30,20)));expect(entry1.beforeApplyUpdate).toHaveBeenCalledWith(metadata1);expect(entry1.afterApplyUpdate).toHaveBeenCalledWith(metadata1);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry:1",metadata1,html1);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry",metadata1,html1);const metadata2={type:"entry",entryType:"my-entry",entryID:"2",addedTimestamp:"2017-07-01T00:00:00",updatedTimestamp:"2017-09-03T14:30:20",modelData:{myAttr:"value2"}};const html2="<span>ÄËÏÖÜŸ 😱</span>";expect(entry2.get("myAttr")).toBe("value2");expect(entry2.get("etag")).toBe(null);expect(entry2.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,8,3,14,30,20)));expect(entry2.beforeApplyUpdate).toHaveBeenCalledWith(metadata2);expect(entry2.afterApplyUpdate).toHaveBeenCalledWith(metadata2);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("applyingUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedModelUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry:2",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("appliedUpdate:entry",metadata2,html2);expect(page.trigger).toHaveBeenCalledWith("updatesProcessed");done()}})})})})});"use strict";suite("rb/reviewRequestPage/models/StatusUpdatesEntry",function(){it("parse",function(){const diffCommentsData=[["1","100"],["2","100-101"]];const reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest({id:5})});const entry=new RB.ReviewRequestPage.StatusUpdatesEntry({diffCommentsData:diffCommentsData,id:"0",typeID:"initial_status_updates",addedTimestamp:"2017-08-18T13:40:25Z",updatedTimestamp:"2017-08-18T16:20:00Z",pendingStatusUpdates:true,reviewsData:[{id:123,bodyTop:"My body top",bodyBottom:"My body bottom",public:true,shipIt:false}],reviewRequestEditor:reviewRequestEditor,ignoredAttr:"ignored"},{parse:true});expect(entry.id).toBe("0");expect(entry.get("diffCommentsData")).toBe(diffCommentsData);expect(entry.get("reviewRequestEditor")).toBe(reviewRequestEditor);expect(entry.get("typeID")).toBe("initial_status_updates");expect(entry.get("addedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,13,40,25)));expect(entry.get("updatedTimestamp")).toEqual(new Date(Date.UTC(2017,7,18,16,20,0)));expect(entry.get("pendingStatusUpdates")).toBe(true);expect(entry.get("ignoredAttr")).toBe(undefined);expect(entry.get("reviewRequestId")).toBe(5);const reviews=entry.get("reviews");expect(reviews.length).toBe(1);const review=reviews[0];expect(review.get("id")).toBe(123);expect(review.get("bodyTop")).toBe("My body top");expect(review.get("bodyBottom")).toBe("My body bottom");expect(review.get("public")).toBe(true);expect(review.get("shipIt")).toBe(false)})});"use strict";suite("rb/reviewRequestPage/views/BaseStatusUpdatesEntryView",function(){const TestPage=Backbone.View.extend({stopWatchingEntryUpdates(){},watchEntryUpdates(){},queueLoadDiff(){}});const statusUpdateHTML=`<div id="initial_status_updates"
     class="review-request-page-entry status-updates">
 <a name="initial_status_updates"></a>
 <div class="review-request-page-entry-contents">
  <div class="header status-update-state-pending">
   <div class="collapse-button btn">
    <div class="rb-icon rb-icon-collapse-review"></div>
   </div>
   <div class="header-details">
    <div class="summary">
     <span class="review-request-page-entry-title">
      Checks run (1 waiting to run)
     </span>
    </div>
    <a href="#initial_status_updates" class="timestamp">
     <time class="timesince"
           datetime="2018-11-27T00:18:43.664524+00:00"
           title="Nov. 27, 2018, 12:18 a.m.">0 minutes ago</time>
    </a>
   </div>
  </div>
  <div class="banners"></div>
  <div class="body">
   <section class="status-update-summary">
    <div class="status-update-summary-entry
     status-update-state-not-yet-run">
     <span class="summary">nyc</span>
     Waiting to run
     <input type="button" value="Run" class="status-update-request-run"
            data-status-update-id="1">
    </div>
   </section>
  </div>
 </div>
</div>`;let entryView;let page;let entry;beforeEach(function(){const reviewRequest=new RB.ReviewRequest({id:5});const editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest});entry=new RB.ReviewRequestPage.StatusUpdatesEntry({reviews:[reviewRequest.createReview(100,{loaded:true,links:{replies:{href:"/api/review/100/replies/"}}}),reviewRequest.createReview(101,{loaded:true,links:{replies:{href:"/api/review/101/replies/"}}})],localSitePrefix:null,reviewRequest:reviewRequest,reviewRequestEditor:editor,reviewRequestId:5,id:"0",typeID:"initial_status_updates",addedTimestamp:new Date(Date.UTC(2017,7,18,13,40,25)),updatedTimestamp:new Date(Date.UTC(2017,7,18,16,20,0)),pendingStatusUpdates:true,diffCommentsData:[["1","100"],["2","100-101"]]});const $el=$(statusUpdateHTML).appendTo($testsScratch);entryView=new RB.ReviewRequestPage.BaseStatusUpdatesEntryView({el:$el,model:entry});page=new TestPage;page.diffFragmentQueue=new RB.DiffFragmentQueueView({containerPrefix:"comment"});entry.set("page",page);RB.PageManager.setPage(page)});afterEach(function(){RB.PageManager.setPage(null)});describe("Dynamic Updating",function(){describe("Update checking",function(){it("Enabled when pendingStatusUpdates=true",function(){spyOn(entry,"watchUpdates");entry.set("pendingStatusUpdates",true);entryView.render();expect(entry.watchUpdates).toHaveBeenCalled()});it("Disabled when pendingStatusUpdates=false",function(){spyOn(entry,"watchUpdates");entry.set("pendingStatusUpdates",false);entryView.render();expect(entry.watchUpdates).not.toHaveBeenCalled()})});it("Saves fragments on beforeApplyUpdate",function(){spyOn(page.diffFragmentQueue,"saveFragment");spyOn(page,"stopWatchingEntryUpdates");entryView.beforeApplyUpdate();expect(page.diffFragmentQueue.saveFragment.calls.count()).toBe(2);expect(page.diffFragmentQueue.saveFragment.calls.argsFor(0)).toEqual(["1"]);expect(page.diffFragmentQueue.saveFragment.calls.argsFor(1)).toEqual(["2"]);expect(page.stopWatchingEntryUpdates).toHaveBeenCalled()})});describe("render",function(){it("Creates ReviewViews",function(){entryView.render();expect(entryView._reviewViews.length).toBe(2)})});describe("Run status update",function(){it("Runs and checks for updates when button is clicked",function(){spyOn(entryView.model,"stopWatchingUpdates");spyOn(entryView.model,"watchUpdates");spyOn(RB,"apiCall").and.callThrough();spyOn($,"ajax").and.callFake(request=>{expect(request.type).toBe("PUT");expect(request.url).toBe("/api/review-requests/5/status-updates/1/");request.success()});entryView.$el.find(".status-update-request-run").first().click();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(entryView.model.stopWatchingUpdates).toHaveBeenCalled();expect(entryView.model.watchUpdates).toHaveBeenCalled()})})});"use strict";suite("rb/reviewRequestPage/views/IssueSummaryTable",function(){const issueSummaryTableTemplate=_.template(`<div>
 <div class="rb-c-review-request-field-tabular
             rb-c-issue-summary-table">
  <header class="rb-c-review-request-field-tabular__header">
   <div class="rb-c-review-request-field-tabular__filters">
    <select class="rb-c-issue-summary-table__reviewer-filter">
     <option value="all"></option>
    </select>
   </div>
   <ul class="rb-c-tabs">
    <li class="rb-c-tabs__tab -is-active" data-issue-state="open">
     <label class="rb-c-tabs__tab-label">
      <span id="open-counter"
            class="rb-c-issue-summary-table__counter">2</span>
     </label>
    </li>
    <li class="rb-c-tabs__tab" data-issue-state="verifying">
     <label class="rb-c-tabs__tab-label">
      <span id="verifying-counter"
            class="rb-c-issue-summary-table__counter">3</span>
     </label>
    </li>
    <li class="rb-c-tabs__tab" data-issue-state="resolved">
     <label class="rb-c-tabs__tab-label">
      <span id="resolved-counter"
            class="rb-c-issue-summary-table__counter">3</span>
     </label>
    </li>
    <li class="rb-c-tabs__tab" data-issue-state="dropped">
     <label class="rb-c-tabs__tab-label">
      <span id="dropped-counter"
            class="rb-c-issue-summary-table__counter">1</span>
     </label>
    </li>
    <li class="rb-c-tabs__tab" data-issue-state="all">
     <label class="rb-c-tabs__tab-label">
      <span id="total-counter"
            class="rb-c-issue-summary-table__counter">6</span>
     </label>
    </li>
   </ul>
  </header>
  <table class="rb-c-review-request-field-tabular__data">
   <thead>
    <tr>
     <th class="-is-sortable"></th>
     <th class="-is-sortable"></th>
     <th class="-is-sortable"></th>
    </tr>
   </thead>
   <tbody>
    <tr class="-is-resolved -is-hidden"
        data-issue-id="1"
        data-reviewer="user1"
        data-comment-type="diff"
        data-comment-href="#comment1">
     <td>
      <span class="rb-icon rb-icon-issue-resolved"></span>
      <p>Resolved comment 1</p>
     </td>
     <td>user1</td>
     <td>
      <time class="timesince" datetime="2017-02-01T20:30:00-07:00">
       February 1, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-resolved -is-hidden"
        data-issue-id="2"
        data-reviewer="user2"
        data-comment-type="diff"
        data-comment-href="#comment2">
     <td>
      <span class="rb-icon rb-icon-issue-resolved"></span>
      <p>Resolved comment 2</p>
     </td>
     <td>user2</td>
     <td>
      <time class="timesince" datetime="2017-02-02T20:30:00-07:00">
       February 2, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-resolved -is-hidden"
        data-issue-id="3"
        data-reviewer="user3"
        data-comment-type="diff"
        data-comment-href="#comment3">
     <td>
      <span class="rb-icon rb-icon-issue-resolved"></span>
      <p>Resolved comment 3</p>
     </td>
     <td>user3</td>
     <td>
      <time class="timesince" datetime="2017-02-03T20:30:00-07:00">
       February 3, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-open"
        data-issue-id="4"
        data-reviewer="user1"
        data-comment-type="diff"
        data-comment-href="#comment4">
     <td>
      <span class="rb-icon rb-icon-issue-open"></span>
      <p>Open comment 4</p>
     </td>
     <td>user1</td>
     <td>
      <time class="timesince" datetime="2017-02-01T20:30:00-07:00">
       February 1, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-open"
        data-issue-id="5"
        data-reviewer="user2"
        data-comment-type="diff"
        data-comment-href="#comment5">
     <td>
      <span class="rb-icon rb-icon-issue-open"></span>
      <p>Open comment 5</p>
     </td>
     <td>user2</td>
     <td>
      <time class="timesince" datetime="2017-02-02T20:30:00-07:00">
       February 2, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-dropped -is-hidden"
        data-issue-id="6"
        data-reviewer="user1"
        data-comment-type="diff"
        data-comment-href="#comment6">
     <td>
      <span class="rb-icon rb-icon-issue-dropped"></span>
      <p>Dropped comment 6</p>
     </td>
     <td>user1</td>
     <td>
      <time class="timesince" datetime="2017-02-01T20:30:00-07:00">
       February 1, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-verifying-dropped -is-hidden"
        data-issue-id="7"
        data-reviewer="user3"
        data-comment-type="diff"
        data-comment-href="#comment7">
     <td>
      <span class="rb-icon rb-icon-issue-dropped"></span>
      <p>Verifying comment 7</p>
     </td>
     <td>user3</td>
     <td>
      <time class="timesince" datetime="2017-02-03T18:30:00-07:00">
       February 3, 2017, 6:30 p.m.
      </time>
     </td>
    </tr>
    <tr class="-is-verifying-resolved -is-hidden"
        data-issue-id="8"
        data-reviewer="user2"
        data-comment-type="diff"
        data-comment-href="#comment8">
     <td>
      <span class="rb-icon rb-icon-issue-dropped"></span>
      <p>Verifying comment 8 - resolved</p>
     </td>
     <td>user2</td>
     <td>
      <time class="timesince" datetime="2017-02-04T20:30:00-07:00">
       February 4, 2017, 8:30 p.m.
      </time>
     </td>
    </tr>
   </tbody>
  </table>
 </div>
</div>`);const TAB_SEL=".rb-c-tabs__tab";const NO_ISSUES_SEL=".rb-c-issue-summary-table__no-issues";const ISSUE_ROW_SEL=`tbody tr:not(${NO_ISSUES_SEL})`;const DESCRIPTION_HEADER_SEL="th:nth-child(1)";const REVIEWER_HEADER_SEL="th:nth-child(2)";const LAST_UPDATED_HEADER_SEL="th:nth-child(3)";const LAST_UPDATED_CELL_SEL="td:nth-child(3)";let view;function getTab(state){return view.$(`${TAB_SEL}[data-issue-state="${state}"]`)}beforeEach(function(){view=new RB.ReviewRequestPage.IssueSummaryTableView({el:$(issueSummaryTableTemplate()),model:new RB.CommentIssueManager});view.$el.appendTo($testsScratch)});describe("render",function(){it("Initial state",function(){view.render();expect(view.statusFilterState).toBe("open");expect(view.reviewerFilterState).toBe("all");expect(view.reviewerToSelectorMap).toEqual({all:"",user1:'[data-reviewer="user1"]',user2:'[data-reviewer="user2"]',user3:'[data-reviewer="user3"]'});const $reviewers=view._$reviewerFilter.children();expect($reviewers.length).toBe(4);expect($reviewers.eq(0).val()).toBe("all");expect($reviewers.eq(1).val()).toBe("user1");expect($reviewers.eq(2).val()).toBe("user2");expect($reviewers.eq(3).val()).toBe("user3")});it("With existing state",function(){view.render();view.statusFilterState="dropped";view.reviewerFilterState="user1";const $oldEl=view.$el;view.setElement($(issueSummaryTableTemplate()));$oldEl.replaceWith(view.$el);view.render();expect(view.statusFilterState).toBe("dropped");expect(view.reviewerFilterState).toBe("user1");expect(view.reviewerToSelectorMap).toEqual({all:"",user1:'[data-reviewer="user1"]',user2:'[data-reviewer="user2"]',user3:'[data-reviewer="user3"]'});const $activeTab=view.$(".rb-c-tabs__tab.-is-active");expect($activeTab.length).toBe(1);expect($activeTab.data("issue-state")).toBe("dropped");expect($activeTab[0]).toBe(view._$currentTab[0]);const $reviewer=view.$(".rb-c-issue-summary-table__reviewer-filter");expect($reviewer.length).toBe(1);expect($reviewer[0]).toBe(view._$reviewerFilter[0]);expect($reviewer.val()).toBe("user1");const $issues=view.$el.find(ISSUE_ROW_SEL).not(".-is-hidden");expect($issues.length).toBe(1);const $issue=$issues.eq(0);expect($issue.hasClass("-is-dropped")).toBe(true);expect($issue.data("reviewer")).toBe("user1")})});describe("Filters",function(){describe("Reviewer filter",function(){describe("To all",function(){it("With issues",function(){view.render();view._$reviewerFilter.val("user1");view._$reviewerFilter.trigger("change");view._$reviewerFilter.val("all");view._$reviewerFilter.trigger("change");const $issues=view.$el.find(ISSUE_ROW_SEL).not(".-is-hidden");expect($issues.length).toBe(2);expect($issues.eq(0).data("issue-id")).toBe(4);expect($issues.eq(1).data("issue-id")).toBe(5)});it("Without issues",function(){view.$el.find(ISSUE_ROW_SEL).remove();view.render();view._$reviewerFilter.val("user1");view._$reviewerFilter.trigger("change");view._$reviewerFilter.val("all");view._$reviewerFilter.trigger("change");expect(view.$el.find(ISSUE_ROW_SEL).not(".-is-hidden").length).toBe(0);const $noIssues=view.$(NO_ISSUES_SEL);expect($noIssues.length).toBe(1)})});describe("To user",function(){it("With issues",function(){view.render();view._$reviewerFilter.val("user1");view._$reviewerFilter.trigger("change");const $issues=view.$el.find(ISSUE_ROW_SEL).not(".-is-hidden");expect($issues.length).toBe(1);expect($issues.eq(0).data("issue-id")).toBe(4)});describe("Without issues",function(){function testByUserWithoutIssues(state){it(`And filtered by ${state} issues`,function(){view.$el.find(`${ISSUE_ROW_SEL}.-is-${state}`+'[data-reviewer="user1"]').remove();view.render();view._$reviewerFilter.val("user1");view._$reviewerFilter.trigger("change");const $tab=getTab(state);$tab.click();expect(view.$el.find(ISSUE_ROW_SEL).not(".-is-hidden").length).toBe(0);const $noIssues=view.$(NO_ISSUES_SEL);expect($noIssues.length).toBe(1);expect($noIssues.text().strip()).toBe(`There are no ${state} issues from user1`)})}testByUserWithoutIssues("open");testByUserWithoutIssues("resolved");testByUserWithoutIssues("dropped")})})});describe("Status filters",function(){function testStatusFilters(options){const state=options.state;describe(options.description,function(){it("With issues",function(){const expectedIDs=options.expectedIDs;view.render();const $tab=getTab(state);$tab.click();expect($tab.hasClass("-is-active")).toBe(true);const $allIssues=view.$el.find(ISSUE_ROW_SEL);const $issues=$allIssues.not(".-is-hidden");expect(view.$el.find(`${ISSUE_ROW_SEL}.-is-hidden`).length).toBe($allIssues.length-expectedIDs.length);expect($issues.length).toBe(expectedIDs.length);expect(view.$(NO_ISSUES_SEL).length).toBe(0);for(let i=0;i<expectedIDs.length;i++){expect($issues.eq(i).data("issue-id")).toBe(expectedIDs[i])}});it("Without issues",function(){const stateSel=view.stateToSelectorMap[state];view.$el.find(`${ISSUE_ROW_SEL}${stateSel}`).remove();view.render();const $tab=getTab(state);$tab.click();expect($tab.hasClass("-is-active")).toBe(true);expect(view.$el.find(ISSUE_ROW_SEL).not(".-is-hidden").length).toBe(0);const $noIssues=view.$(NO_ISSUES_SEL);expect($noIssues.length).toBe(1);expect($noIssues.text().strip()).toBe(options.noIssuesText)})})}testStatusFilters({description:"All",state:"all",expectedIDs:[1,2,3,4,5,6,7,8],noIssuesText:""});testStatusFilters({description:"Verifying",state:"verifying",expectedIDs:[7,8],noIssuesText:"There are no issues waiting for verification"});testStatusFilters({description:"Open",state:"open",expectedIDs:[4,5],noIssuesText:"There are no open issues"});testStatusFilters({description:"Resolved",state:"resolved",expectedIDs:[1,2,3],noIssuesText:"There are no resolved issues"});testStatusFilters({description:"Dropped",state:"dropped",expectedIDs:[6],noIssuesText:"There are no dropped issues"})})});describe("Events",function(){it('"No Issues" row clicked',function(){const cb=jasmine.createSpy();view.$el.find(ISSUE_ROW_SEL).remove();view.render();view.on("issueClicked",cb);view._$reviewerFilter.val("user1");view._$reviewerFilter.trigger("change");view.$(NO_ISSUES_SEL).click();expect(cb).not.toHaveBeenCalled()});it("Issue clicked",function(){const cb=jasmine.createSpy();view.render();view.on("issueClicked",cb);view.commentIDToRowMap["4"].click();expect(cb).toHaveBeenCalledWith({commentType:"diff",commentID:4,commentURL:"#comment4"})});describe("Issue status updated",function(){const date=new Date(2017,7,6,1,4,30);let $issue;let $icon;let comment;beforeEach(function(){comment=new RB.DiffComment({id:4});view.render();expect(view.$("#resolved-counter").text()).toBe("3");expect(view.$("#open-counter").text()).toBe("2");expect(view.$("#dropped-counter").text()).toBe("1");expect(view.$("#total-counter").text()).toBe("6");$issue=view.commentIDToRowMap["4"];$icon=$issue.find(".rb-icon")});it("To dropped",function(){comment.set("issueStatus","dropped");view.model.trigger("issueStatusUpdated",comment,"open",date);expect(view.$("#open-counter").text()).toBe("1");expect(view.$("#dropped-counter").text()).toBe("2");expect(view.$("#total-counter").text()).toBe("6");expect($icon.hasClass("rb-icon-issue-open")).toBe(false);expect($icon.hasClass("rb-icon-issue-dropped")).toBe(true)});it("To resolved",function(){comment.set("issueStatus","resolved");view.model.trigger("issueStatusUpdated",comment,"open",date);expect(view.$("#resolved-counter").text()).toBe("4");expect(view.$("#open-counter").text()).toBe("1");expect(view.$("#total-counter").text()).toBe("6");expect($icon.hasClass("rb-icon-issue-open")).toBe(false);expect($icon.hasClass("rb-icon-issue-resolved")).toBe(true)});it("To open",function(){comment.set({issueStatus:"open",id:1});view.model.trigger("issueStatusUpdated",comment,"resolved",date);$issue=view.commentIDToRowMap["1"];$icon=$issue.find(".rb-icon");expect(view.$("#resolved-counter").text()).toBe("2");expect(view.$("#open-counter").text()).toBe("3");expect(view.$("#total-counter").text()).toBe("6");expect($icon.hasClass("rb-icon-issue-resolved")).toBe(false);expect($icon.hasClass("rb-icon-issue-open")).toBe(true)});it("After re-renders",function(){view.render();view.render();comment.set("issueStatus","resolved");view.model.trigger("issueStatusUpdated",comment,"open",date);expect(view.$("#resolved-counter").text()).toBe("4");expect(view.$("#open-counter").text()).toBe("1");expect(view.$("#total-counter").text()).toBe("6");expect($icon.hasClass("rb-icon-issue-open")).toBe(false);expect($icon.hasClass("rb-icon-issue-resolved")).toBe(true)});afterEach(function(){expect($issue.find(`${LAST_UPDATED_CELL_SEL} time`).attr("datetime")).toBe(date.toISOString())})});describe("Header clicked",function(){function testHeaderSorting(options){it(options.description,function(){view.render();const event=$.Event("click");event.shiftKey=!!options.shiftKey;const $header=view.$(options.headerSel);console.assert($header.length===1);$header.trigger(event);const $issues=view.$(ISSUE_ROW_SEL);expect($issues.length).toBe(8);const foundIDs=[];for(let i=0;i<$issues.length;i++){foundIDs.push($issues.eq(i).data("issue-id"))}expect(foundIDs).toEqual(options.expectedIDs)})}describe("Ascending",function(){testHeaderSorting({description:"Description",headerSel:DESCRIPTION_HEADER_SEL,expectedIDs:[6,4,5,1,2,3,7,8]});testHeaderSorting({description:"From",headerSel:REVIEWER_HEADER_SEL,expectedIDs:[1,4,6,2,5,8,3,7]});testHeaderSorting({description:"Last Updated",headerSel:LAST_UPDATED_HEADER_SEL,expectedIDs:[8,3,7,2,5,1,4,6]})});describe("Descending",function(){testHeaderSorting({description:"Description",headerSel:DESCRIPTION_HEADER_SEL,expectedIDs:[8,7,3,2,1,5,4,6],shiftKey:true});testHeaderSorting({description:"From",headerSel:REVIEWER_HEADER_SEL,expectedIDs:[3,7,2,5,8,1,4,6],shiftKey:true});testHeaderSorting({description:"Last Updated",headerSel:LAST_UPDATED_HEADER_SEL,expectedIDs:[1,4,6,2,5,7,3,8],shiftKey:true})})})})});"use strict";suite("rb/reviewRequestPage/views/ReviewEntryView",function(){const template=`<div class="review review-request-page-entry">
 <div class="review-request-page-entry-contents">
  <div class="collapse-button"></div>
  <div class="banners">
   <input type="button" value="Publish" />
   <input type="button" value="Discard" />
  </div>
  <div class="comment-section" data-context-type="body_top">
   <a class="add_comment_link"></a>
   <ul class="reply-comments">
    <li class="draft" data-comment-id="456">
     <pre class="reviewtext"></pre>
    </li>
   </ul>
  </div>
  <div class="comment-section" data-context-id="123"
       data-context-type="diff_comments">
   <a class="add_comment_link"></a>
   <ul class="reply-comments"></ul>
  </div>
  <div class="comment-section" data-context-type="body_bottom">
   <a class="add_comment_link"></a>
   <ul class="reply-comments"></ul>
  </div>
 </div>
</div>`;let view;let reviewView;let reviewReply;beforeEach(function(){const reviewRequest=new RB.ReviewRequest;const editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest});const review=reviewRequest.createReview({loaded:true,links:{replies:{href:"/api/review/123/replies/"}}});const model=new RB.ReviewRequestPage.ReviewEntry({review:review,reviewRequest:reviewRequest,reviewRequestEditor:editor});const $el=$(template).appendTo($testsScratch);reviewReply=review.createReply();view=new RB.ReviewRequestPage.ReviewEntryView({el:$el,model:model});view.render();reviewView=view._reviewView;spyOn(reviewView,"_showReplyDraftBanner");spyOn(reviewView,"trigger").and.callThrough();reviewView._setupNewReply(reviewReply)});describe("Actions",function(){it("Toggle collapse",function(){const $box=view.$(".review-request-page-entry-contents");const $collapseButton=view.$(".collapse-button");$collapseButton.click();expect($box.hasClass("collapsed")).toBe(true);$collapseButton.click();expect($box.hasClass("collapsed")).toBe(false)})});describe("Draft banner",function(){describe("Visibility",function(){it("Shown on hasDraft",function(){const editor=reviewView._replyEditorViews[1].model;reviewView._showReplyDraftBanner.calls.reset();expect(editor.get("hasDraft")).toBe(false);expect(reviewView._showReplyDraftBanner).not.toHaveBeenCalled();editor.set("hasDraft",true);expect(reviewView._showReplyDraftBanner).toHaveBeenCalled()})})});describe("Methods",function(){it("collapse",function(){view.collapse();expect(view.$(".review-request-page-entry-contents").hasClass("collapsed")).toBe(true)});it("expand",function(){const $box=view.$(".review-request-page-entry-contents").addClass("collapsed");view.expand();expect($box.hasClass("collapsed")).toBe(false)});describe("getReviewReplyEditorView",function(){it("With body_top",function(){const editorView=view.getReviewReplyEditorView("body_top");expect(editorView).not.toBe(undefined);expect(editorView).toBe(reviewView._replyEditorViews[0])});it("With body_bottom",function(){const editorView=view.getReviewReplyEditorView("body_bottom");expect(editorView).not.toBe(undefined);expect(editorView).toBe(reviewView._replyEditorViews[2])});it("With comments",function(){const editorView=view.getReviewReplyEditorView("diff_comments",123);expect(editorView).not.toBe(undefined);expect(editorView).toBe(reviewView._replyEditorViews[1])})})})});"use strict";suite("rb/reviewRequestPage/views/ReviewReplyDraftBannerView",function(){let reviewReply;let view;beforeEach(function(){reviewReply=new RB.ReviewReply;view=new RB.ReviewRequestPage.ReviewReplyDraftBannerView({model:reviewReply,$floatContainer:$testsScratch,reviewRequestEditor:new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest})});view.render().$el.appendTo($testsScratch)});describe("Actions",function(){it("Discard",function(){spyOn(reviewReply,"destroy");view.$(".discard-button").click();expect(reviewReply.destroy).toHaveBeenCalled()});it("Publish",function(){spyOn(reviewReply,"publish");view.$(".publish-button").click();expect(reviewReply.publish).toHaveBeenCalled()})});describe("Event Handling",function(){describe("Buttons",function(){let $buttons;beforeEach(function(){$buttons=view.$("input")});describe("Disabled",function(){it("When saving",function(){expect($buttons.prop("disabled")).toBe(false);reviewReply.trigger("saving");expect($buttons.prop("disabled")).toBe(true)});it("When destroying",function(){expect($buttons.prop("disabled")).toBe(false);reviewReply.trigger("destroying");expect($buttons.prop("disabled")).toBe(true)})});describe("Enabled",function(){it("When saved",function(){$buttons.prop("disabled",true);reviewReply.trigger("saved");expect($buttons.prop("disabled")).toBe(false)})})})});describe("Publish",function(){beforeEach(function(){spyOn(reviewReply,"ensureCreated").and.callFake((options,context)=>options.success.call(context));spyOn(reviewReply,"publish")});describe("With Send E-Mail shown",function(){beforeEach(function(){view.remove();view=new RB.ReviewRequestPage.ReviewReplyDraftBannerView({model:reviewReply,$floatContainer:$testsScratch,reviewRequestEditor:new RB.ReviewRequestEditor({reviewRequest:new RB.ReviewRequest,showSendEmail:true})});view.render().$el.appendTo($testsScratch)});it("Send E-Mail true",function(){$(".send-email").prop("checked",true);$(".publish-button").click();expect(reviewReply.publish).toHaveBeenCalled();expect(reviewReply.publish.calls.argsFor(0)[0].trivial).toBe(false)});it("Send E-Mail false",function(){$(".send-email").prop("checked",false);$(".publish-button").click();expect(reviewReply.publish).toHaveBeenCalled();expect(reviewReply.publish.calls.argsFor(0)[0].trivial).toBe(true)})});it("Without Send E-Mail shown",function(){$(".publish-button").click();expect($(".send-email").length).toEqual(0);expect(reviewReply.publish).toHaveBeenCalled();expect(reviewReply.publish.calls.argsFor(0)[0].trivial).toBe(false)})})});"use strict";suite("rb/reviewRequestPage/views/ReviewReplyEditorView",function(){let reviewReply;let editor;let view;beforeEach(function(){const $container=$("<div/>").appendTo($testsScratch);reviewReply=new RB.ReviewReply({id:121});spyOn(reviewReply,"discardIfEmpty").and.callFake((options,context)=>options.success.call(context));editor=new RB.ReviewRequestPage.ReviewReplyEditor({anchorPrefix:"header-reply",replyObject:reviewReply,review:new RB.Review({id:42,parentObject:new RB.ReviewRequest}),reviewReply:reviewReply,contextType:"rcbt",contextID:"100"});view=new RB.ReviewRequestPage.ReviewReplyEditorView({model:editor,el:$testsScratch});view._$commentsList=$('<ul class="reply-comments"/>');$container.append(view._$commentsList).append($('<a href="#" class="add_comment_link">New Comment</a>'))});describe("Construction",function(){it("Populate from draft comment",function(){const commentText="Test comment";const now=moment();const $el=view._makeCommentElement({commentID:16,now:now,text:commentText});view.render();expect(editor.get("commentID")).toBe(16);expect(editor.get("text")).toBe(commentText);expect(editor.get("hasDraft")).toBe(true);expect(editor.get("timestamp").valueOf()).toBe(now.milliseconds(0).valueOf());expect(view._$draftComment[0]).toBe($el[0]);expect(view._$addCommentLink.is(":visible")).toBe(false)})});describe("Actions",function(){it("Add comment link",function(){view.render();expect(view._$addCommentLink.is(":visible")).toBe(true);view._$addCommentLink.click();expect(view._$addCommentLink.is(":visible")).toBe(false);expect(view._$draftComment).not.toBe(null);expect(view._$draftComment.hasClass("draft")).toBe(true)})});describe("Event handling",function(){it("Comment discarded",function(){view._makeCommentElement({text:"Test comment"});view.render();let $el=view.$(".reply-comments li");expect($el.length).toBe(1);reviewReply.trigger("destroyed");$el=view.$(".reply-comments li");expect($el.length).toBe(0);expect(view._$draftComment).toBe(null)});it("Comment published",function(){const $draftEl=view._makeCommentElement({commentID:16});spyOn($.fn,"user_infobox").and.callThrough();spyOn($.fn,"timesince").and.callThrough();view.render();editor.set("text","Test **comment**");reviewReply.trigger("published");const $el=view.$(".reply-comments li");expect($el.length).toBe(1);expect($draftEl).not.toBe($el);expect($el.hasClass("draft")).toBe(false);expect($el.data("comment-id")).toBe(16);expect(view._$draftComment).toBe(null);expect($.fn.user_infobox).toHaveBeenCalled();expect($.fn.timesince).toHaveBeenCalled();const $anchor=$el.children(".comment-anchor");expect($anchor.length).toBe(1);expect($anchor.attr("name")).toBe("header-reply121");const $floatingAnchor=$el.find("> .floating-anchor > a");expect($floatingAnchor.length).toBe(1);expect($floatingAnchor.attr("href")).toBe("#header-reply121");expect($floatingAnchor.hasClass("fa fa-link fa-flip-horizontal")).toBe(true)})});describe("Methods",function(){it("openCommentEditor",function(){view.render();expect(view._$addCommentLink.is(":visible")).toBe(true);expect(view._$draftComment).toBe(null);view.openCommentEditor();expect(view._$addCommentLink.is(":visible")).toBe(false);expect(view._$draftComment).not.toBe(null);expect(view._$draftComment.hasClass("draft")).toBe(true)})});describe("Text rendering",function(){function testRendering(richText,expectedHTML){view.render();const $comment=view._makeCommentElement({text:"<p><strong>Test</strong> &amp;lt;</p>",richText:richText});const $reviewText=$comment.find(".reviewtext");expect($reviewText.length).toBe(1);expect($reviewText.hasClass("rich-text")).toBe(richText);expect($reviewText.html()).toBe(expectedHTML)}it("richText=true",function(){testRendering(true,"<p><strong>Test</strong> &amp;lt;</p>")});it("richText=false",function(){testRendering(false,"&lt;p&gt;&lt;strong&gt;Test&lt;/strong&gt; "+"&amp;amp;lt;&lt;/p&gt;")})})});"use strict";suite("rb/reviewRequestPage/views/ReviewRequestPageView",function(){const template=`<div id="review-banner"></div>
<a id="collapse-all"></a>
<a id="expand-all"></a>
<div>
 <div class="review review-request-page-entry" id="review123">
  <div class="review-request-page-entry-contents">
   <div class="body">
    <pre class="body_top">Body Top</pre>
    <div class="comment-section" data-context-type="body_top">
    </div>
    <div class="comment-section" data-context-id="123"
         data-context-type="diff_comments">
    </div>
    <pre class="body_bottom">Body Bottom</pre>
    <div class="comment-section" data-context-type="body_bottom">
    </div>
   </div>
 </div>
 <div class="review review-request-page-entry" id="review124">
  <div class="review-request-page-entry-contents">
   <div class="body">
    <pre class="body_top">Body Top</pre>
    <div class="comment-section" data-context-type="body_top">
    </div>
    <pre class="body_bottom">Body Bottom</pre>
    <div class="comment-section" data-context-type="body_bottom">
    </div>
   </div>
  </div>
 </div>
</div>`;let page;let pageView;let entry1;let entry2;beforeEach(function(){const $el=$("<div/>").html(template).appendTo($testsScratch);RB.DnDUploader.instance=null;page=new RB.ReviewRequestPage.ReviewRequestPage({checkForUpdates:false,reviewRequestData:{},editorData:{fileAttachments:[],mutableByUser:true,showSendEmail:false}},{parse:true});pageView=new RB.ReviewRequestPage.ReviewRequestPageView({el:$el,model:page});spyOn(RB.ReviewRequestPage.IssueSummaryTableView.prototype,"render");const reviewRequest=page.get("reviewRequest");pageView.addEntryView(new RB.ReviewRequestPage.ReviewEntryView({model:new RB.ReviewRequestPage.ReviewEntry({review:reviewRequest.createReview(123,{shipIt:true,public:true,bodyTop:"Body Top",bodyBottom:"Body Bottom"}),reviewRequestEditor:pageView.reviewRequestEditor}),el:$el.find("#review123")}));pageView.addEntryView(new RB.ReviewRequestPage.ReviewEntryView({model:new RB.ReviewRequestPage.ReviewEntry({review:reviewRequest.createReview(124,{shipIt:false,public:true,bodyTop:"Body Top",bodyBottom:"Body Bottom"}),reviewRequestEditor:pageView.reviewRequestEditor}),el:$el.find("#review124")}));pageView.render();expect(pageView._entryViews.length).toBe(2);entry1=pageView._entryViews[0];entry2=pageView._entryViews[1]});afterEach(function(){RB.DnDUploader.instance=null});describe("Actions",function(){it("Collapse all",function(){const $el1=entry1.$el.find(".review-request-page-entry-contents");const $el2=entry2.$el.find(".review-request-page-entry-contents");expect($el1.hasClass("collapsed")).toBe(false);expect($el2.hasClass("collapsed")).toBe(false);pageView.$("#collapse-all").click();expect($el1.hasClass("collapsed")).toBe(true);expect($el2.hasClass("collapsed")).toBe(true)});it("Expand all",function(){const $el1=entry1.$el.find(".review-request-page-entry-contents");const $el2=entry2.$el.find(".review-request-page-entry-contents");$el1.addClass("collapsed");$el2.addClass("collapsed");pageView.$("#expand-all").click();expect($el1.hasClass("collapsed")).toBe(false);expect($el2.hasClass("collapsed")).toBe(false)})});describe("Methods",function(){describe("openCommentEditor",function(){beforeEach(function(){spyOn(RB.ReviewRequestPage.ReviewReplyEditorView.prototype,"openCommentEditor");spyOn(entry1,"getReviewReplyEditorView").and.callThrough();spyOn(entry2,"getReviewReplyEditorView").and.callThrough()});it("With body_top",function(){pageView.openCommentEditor("body_top");expect(entry1.getReviewReplyEditorView).toHaveBeenCalled();expect(RB.ReviewRequestPage.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled();expect(entry2.getReviewReplyEditorView).not.toHaveBeenCalled()});it("With body_bottom",function(){pageView.openCommentEditor("body_bottom");expect(entry1.getReviewReplyEditorView).toHaveBeenCalled();expect(RB.ReviewRequestPage.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled();expect(entry2.getReviewReplyEditorView).not.toHaveBeenCalled()});it("With comments",function(){pageView.openCommentEditor("diff_comments",123);expect(entry1.getReviewReplyEditorView).toHaveBeenCalled();expect(RB.ReviewRequestPage.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled();expect(entry2.getReviewReplyEditorView).not.toHaveBeenCalled()})})})});"use strict";suite("rb/reviewRequestPage/views/ReviewView",function(){const template=_.template(`<div class="review review-request-page-entry">
 <div class="review-request-page-entry-contents">
  <div class="collapse-button"></div>
  <div class="banners">
   <input type="button" value="Publish" />
   <input type="button" value="Discard" />
  </div>
  <div class="body">
   <ol class="review-comments">
    <li>
     <div class="review-comment-details">
      <div class="review-comment">
       <pre class="reviewtext body_top"></pre>
      </div>
     </div>
     <div class="review-comment-thread">
      <div class="comment-section"
           data-context-type="body_top"
           data-reply-anchor-prefix="header-reply">
       <a class="add_comment_link"></a>
       <ul class="reply-comments">
        <li class="draft" data-comment-id="456">
         <pre class="reviewtext"></pre>
        </li>
       </ul>
      </div>
     </div>
    </li>
    <li>
     <div class="review-comment-thread">
      <div class="comment-section" data-context-id="123"
           data-context-type="diff_comments"
           data-reply-anchor-prefix="comment">
       <a class="add_comment_link"></a>
       <ul class="reply-comments"></ul>
      </div>
     </div>
    </li>
    <li>
     <div class="review-comment-details">
      <div class="review-comment">
       <pre class="reviewtext body_bottom"></pre>
      </div>
     </div>
     <div class="review-comment-thread">
      <div class="comment-section"
           data-context-type="body_bottom"
           data-reply-anchor-prefix="footer-reply">
       <a class="add_comment_link"></a>
       <ul class="reply-comments"></ul>
      </div>
     </div>
    </div>
   </li>
  </ol>
 </div>
</div>`);let view;let review;let reviewReply;beforeEach(function(){const reviewRequest=new RB.ReviewRequest;const editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest});review=reviewRequest.createReview({loaded:true,links:{replies:{href:"/api/review/123/replies/"}}});const $el=$(template()).appendTo($testsScratch);reviewReply=review.createReply();view=new RB.ReviewRequestPage.ReviewView({el:$el,model:review,entryModel:new RB.ReviewRequestPage.ReviewEntry({review:review,reviewRequest:reviewRequest,reviewRequestEditor:editor})});view._setupNewReply(reviewReply);spyOn(view,"trigger").and.callThrough();view.render()});describe("Model events",function(){it("bodyTop changed",function(){review.set({bodyTop:"new **body** top",htmlTextFields:{bodyTop:"<p>new <strong>body</strong> top</p>"}});expect(view._$bodyTop.html()).toBe("<p>new <strong>body</strong> top</p>")});it("bodyBottom changed",function(){review.set({bodyBottom:"new **body** bottom",htmlTextFields:{bodyBottom:"<p>new <strong>body</strong> bottom</p>"}});expect(view._$bodyBottom.html()).toBe("<p>new <strong>body</strong> bottom</p>")});describe("bodyTopRichText changed",function(){it("To true",function(){expect(view._$bodyTop.hasClass("rich-text")).toBe(false);review.set("bodyTopRichText",true);expect(view._$bodyTop.hasClass("rich-text")).toBe(true)});it("To false",function(){review.attributes.bodyTopRichText=true;view._$bodyTop.addClass("rich-text");review.set("bodyTopRichText",false);expect(view._$bodyTop.hasClass("rich-text")).toBe(false)})});describe("bodyBottomRichText changed",function(){it("To true",function(){expect(view._$bodyBottom.hasClass("rich-text")).toBe(false);review.set("bodyBottomRichText",true);expect(view._$bodyBottom.hasClass("rich-text")).toBe(true)});it("To false",function(){review.attributes.bodyBottomRichText=true;view._$bodyBottom.addClass("rich-text");review.set("bodyBottomRichText",false);expect(view._$bodyBottom.hasClass("rich-text")).toBe(false)})})});describe("Reply editors",function(){it("Views created",function(){expect(view._replyEditorViews.length).toBe(3)});it("Initial state populated",function(){let model=view._replyEditorViews[0].model;expect(model.get("anchorPrefix")).toBe("header-reply");expect(model.get("contextID")).toBe(null);expect(model.get("contextType")).toBe("body_top");expect(model.get("hasDraft")).toBe(true);model=view._replyEditorViews[1].model;expect(model.get("anchorPrefix")).toBe("comment");expect(model.get("contextID")).toBe(123);expect(model.get("contextType")).toBe("diff_comments");expect(model.get("hasDraft")).toBe(false);model=view._replyEditorViews[2].model;expect(model.get("anchorPrefix")).toBe("footer-reply");expect(model.get("contextID")).toBe(null);expect(model.get("contextType")).toBe("body_bottom");expect(model.get("hasDraft")).toBe(false);expect(view._replyDraftsCount).toBe(1)});it("Draft banner when draft comment exists",function(){expect(view.trigger).toHaveBeenCalledWith("hasDraftChanged",true)});describe("reviewReply changes on",function(){it("Discard",function(){spyOn(view,"_setupNewReply");spyOn(reviewReply,"discardIfEmpty").and.callFake((options,context)=>options.success.call(context));reviewReply.trigger("destroyed");expect(view._setupNewReply).toHaveBeenCalled()});it("Publish",function(){spyOn(view,"_setupNewReply");spyOn(RB.BaseResource.prototype,"ready");view._replyEditors.forEach(editor=>editor.save());reviewReply.trigger("published");expect(view._setupNewReply).toHaveBeenCalled()})});describe("When draft deleted",function(){describe("With last one",function(){it("Draft banner hidden",function(){const editor=view._replyEditors[0];expect(editor.get("hasDraft")).toBe(true);expect(view._replyDraftsCount).toBe(1);expect(view._draftBannerShown).toBe(true);editor.set("hasDraft",false);expect(view._replyDraftsCount).toBe(0);expect(view._draftBannerShown).toBe(false)})});describe("With more remaining",function(){it("Draft banner stays visible",function(){view._replyEditors[1].set("hasDraft",true);const editor=view._replyEditors[0];expect(editor.get("hasDraft")).toBe(true);expect(view._replyDraftsCount).toBe(2);expect(view._draftBannerShown).toBe(true);editor.set("hasDraft",false);expect(view._replyDraftsCount).toBe(1);expect(view._draftBannerShown).toBe(true)})})});describe("When reviewReply changes",function(){it("Signals connected",function(){spyOn(view,"listenTo").and.callThrough();view._setupNewReply(new RB.ReviewReply);expect(view.listenTo.calls.argsFor(0)[1]).toBe("destroyed published")});it("Signals disconnected from old reviewReply",function(){spyOn(view,"stopListening").and.callThrough();view._setupNewReply();expect(view.stopListening).toHaveBeenCalledWith(reviewReply)});it("Hide draft banner signal emitted",function(){view._setupNewReply();expect(view.trigger).toHaveBeenCalledWith("hasDraftChanged",false)});it("Editors updated",function(){view._setupNewReply();view._replyEditors.forEach(editor=>expect(editor.get("reviewReply")).toBe(view._reviewReply))})})})});"use strict";suite("rb/ui/views/DialogView",function(){describe("Buttons",function(){describe("Settings",function(){it("Default",function(){const dialogView=new RB.DialogView({buttons:[{label:"Test",id:"testid"}]});dialogView._makeButtons();const buttons=dialogView.$buttonsMap;const button=buttons.testid;expect(Object.keys(buttons).length).toBe(1);expect(button.val()).toBe("Test");expect(button.prop("id")).toBe("testid");expect(button.prop("disabled")).toBe(false);expect(button.hasClass("primary")).toBe(false);expect(button.hasClass("danger")).toBe(false)});it("Primary",function(){const dialogView=new RB.DialogView({buttons:[{label:"Test",id:"testid",primary:true}]});dialogView._makeButtons();const buttons=dialogView.$buttonsMap;const button=buttons.testid;expect(Object.keys(buttons).length).toBe(1);expect(button.val()).toBe("Test");expect(button.prop("id")).toBe("testid");expect(button.prop("disabled")).toBe(false);expect(button.hasClass("primary")).toBe(true);expect(button.hasClass("danger")).toBe(false)});it("Disabled",function(){const dialogView=new RB.DialogView({buttons:[{label:"Test",id:"testid",disabled:true}]});dialogView._makeButtons();const buttons=dialogView.$buttonsMap;const button=buttons.testid;expect(Object.keys(buttons).length).toBe(1);expect(button.val()).toBe("Test");expect(button.prop("id")).toBe("testid");expect(button.prop("disabled")).toBe(true);expect(button.hasClass("primary")).toBe(false);expect(button.hasClass("danger")).toBe(false)});it("Danger",function(){const dialogView=new RB.DialogView({buttons:[{label:"Test",id:"testid",danger:true}]});dialogView._makeButtons();const buttons=dialogView.$buttonsMap;const button=buttons.testid;expect(Object.keys(buttons).length).toBe(1);expect(button.val()).toBe("Test");expect(button.prop("id")).toBe("testid");expect(button.prop("disabled")).toBe(false);expect(button.hasClass("primary")).toBe(false);expect(button.hasClass("danger")).toBe(true)})});describe("Events",function(){describe("Click",function(){it("When function",function(){const myFunc=jasmine.createSpy("cb");const dialogView=new RB.DialogView({buttons:[{label:"Test",id:"testid",onClick:myFunc}]});dialogView._makeButtons();const buttons=dialogView.$buttonsMap;const button=buttons.testid;expect(Object.keys(buttons).length).toBe(1);expect(button.val()).toBe("Test");button.click();expect(myFunc).toHaveBeenCalled()});it("When string on subclass",function(){const MyDialogView=RB.DialogView.extend({buttons:[{label:"Test",id:"testid",onClick:"_onClicked"}],_onClicked:jasmine.createSpy("cb")});const dialogView=new MyDialogView;dialogView._makeButtons();const buttons=dialogView.$buttonsMap;const button=buttons.testid;expect(Object.keys(buttons).length).toBe(1);expect(button.val()).toBe("Test");button.click();expect(dialogView._onClicked).toHaveBeenCalled()});describe("Keydown",function(){it("Esc key",function(){const dialogView=new RB.DialogView({buttons:[{id:"testid",label:"Test"}]});dialogView.show();const myFunc=jasmine.createSpy("hide");dialogView.hide=myFunc;const buttons=dialogView.$buttonsMap;expect(Object.keys(buttons).length).toBe(1);expect(buttons.testid.val()).toBe("Test");dialogView.$el.trigger($.Event("keydown",{which:$.ui.keyCode.ESCAPE}));expect(myFunc).toHaveBeenCalled();dialogView.remove()})});describe("Submit",function(){it("with primary button enabled",function(){const myFunc=jasmine.createSpy("cb");const dialogView=new RB.DialogView({buttons:[{id:"testid",label:"Test",onClick:myFunc,disabled:false,primary:true}],body:_.template(`<form>
 <input value="test">
</form>`)});dialogView.show();const buttons=dialogView.$buttonsMap;const button=buttons.testid;const form=dialogView.$el.find("form");expect(Object.keys(buttons).length).toBe(1);expect(button.val()).toBe("Test");expect(button.prop("disabled")).toBe(false);expect(button.hasClass("primary")).toBe(true);form.trigger($.Event("submit"));expect(myFunc).toHaveBeenCalled();dialogView.remove()});it("with primary button disabled",function(){const myFunc=jasmine.createSpy("cb");const dialogView=new RB.DialogView({buttons:[{id:"testid",label:"Test",onClick:myFunc,disabled:true,primary:true}],body:_.template(`<form>
 <input value="test">
</form>`)});dialogView.show();const buttons=dialogView.$buttonsMap;const button=buttons.testid;const form=dialogView.$el.find("form");expect(Object.keys(buttons).length).toBe(1);expect(button.val()).toBe("Test");expect(button.prop("disabled")).toBe(true);expect(button.hasClass("primary")).toBe(true);form.trigger($.Event("submit"));expect(myFunc).not.toHaveBeenCalled();dialogView.remove()});it("with explicit action",function(){const myFunc1=jasmine.createSpy("cb1");const myFunc2=jasmine.createSpy("cb2").and.returnValue(false);const dialogView=new RB.DialogView({buttons:[{id:"testid",label:"Test",onClick:myFunc1,disabled:false,primary:true}],body:_.template(`<form action=".">
 <input value="test">
</form>`)});dialogView.show();const buttons=dialogView.$buttonsMap;const button=buttons.testid;const form=dialogView.$el.find("form");form.submit(myFunc2);expect(Object.keys(buttons).length).toBe(1);expect(button.val()).toBe("Test");expect(button.prop("disabled")).toBe(false);expect(button.hasClass("primary")).toBe(true);form.trigger($.Event("submit"));expect(myFunc1).not.toHaveBeenCalled();expect(myFunc2).toHaveBeenCalled();dialogView.remove()})})})})})});"use strict";suite("rb/ui/views/DrawerView",function(){let $body;let drawerView;beforeEach(function(){$body=$(document.body);drawerView=new RB.DrawerView;drawerView.render()});afterEach(function(){$body.removeClass("js-rb-c-drawer-is-shown")});describe("Operations",function(){it("show",function(){const onVisibilityChanged=jasmine.createSpy("onVisibilityChanged");drawerView.on("visibilityChanged",onVisibilityChanged);drawerView.show();expect(drawerView.isVisible).toBe(true);expect($body.hasClass("js-rb-c-drawer-is-shown")).toBe(true);expect(onVisibilityChanged).toHaveBeenCalledWith(true)});it("hide",function(){const onVisibilityChanged=jasmine.createSpy("onVisibilityChanged");$body.addClass("js-rb-c-drawer-is-shown");drawerView.on("visibilityChanged",onVisibilityChanged);drawerView.hide();expect(drawerView.isVisible).toBe(false);expect($body.hasClass("js-rb-c-drawer-is-shown")).toBe(false);expect(onVisibilityChanged).toHaveBeenCalledWith(false)})})});"use strict";suite("rb/ui/views/FormView",function(){const template=`<form class="rb-c-form">
 <select id="subform1-selector"
         data-subform-group="group1">
  <option value="subform1">subform1</option>
  <option value="subform2">subform2</option>
 </select>

 <fieldset class="rb-c-form-fieldset">
  <legend class="rb-c-form-fieldset__name">
   Title
   <a href="#" class="rb-c-form-fieldset__toggle">(Hide)</a>
  </legend>
  <div class="rb-c-form-fieldset__content"></div>
 </fieldset>
 <fieldset class="rb-c-form-fieldset -is-collapsed">
  <legend class="rb-c-form-fieldset__name">
   Title
   <a href="#" class="rb-c-form-fieldset__toggle">(Show)</a>
  </legend>
  <div class="rb-c-form-fieldset__content"></div>
 </fieldset>

 <fieldset class="rb-c-form-fieldset -is-subform"
           data-subform-controller="subform1-selector"
           data-subform-id="subform1">
 </fieldset>
 <fieldset class="rb-c-form-fieldset -is-subform"
           data-subform-controller="subform1-selector"
           data-subform-id="subform2">
 </fieldset>

 <fieldset class="rb-c-form-fieldset -is-subform"
           data-subform-group="group2"
           data-subform-id="subform3">
 </fieldset>
 <fieldset class="rb-c-form-fieldset -is-subform"
           data-subform-group="group2"
           data-subform-id="subform4"
           disabled hidden>
 </fieldset>
</form>`;let view;let $subforms;beforeEach(function(){view=new RB.FormView({el:$(template)});view.render().$el.appendTo($testsScratch);$subforms=view._$subforms});function checkSubformVisibility(index,visible){const $subform=$subforms.eq(index);expect($subform.prop("disabled")).toBe(!visible);expect($subform.prop("hidden")).toBe(!visible)}describe("Fieldsets",function(){it("Collapsing",function(){const $fieldset=view.$(".rb-c-form-fieldset").eq(0);expect($fieldset.hasClass("-is-collapsed")).toBe(false);$fieldset.find(".rb-c-form-fieldset__toggle").click();expect($fieldset.hasClass("-is-collapsed")).toBe(true);expect($fieldset.find(".rb-c-form-fieldset__toggle").text()).toBe("(Show)")});it("Expanding",function(){const $fieldset=view.$(".rb-c-form-fieldset").eq(1);expect($fieldset.hasClass("-is-collapsed")).toBe(true);$fieldset.find(".rb-c-form-fieldset__toggle").click();expect($fieldset.hasClass("-is-collapsed")).toBe(false);expect($fieldset.find(".rb-c-form-fieldset__toggle").text()).toBe("(Hide)")})});describe("Subforms",function(){it("Loaded state",function(){expect($subforms.length).toBe(4);expect(_.keys(view._subformsByGroup)).toEqual(["group1","group2"]);expect(_.keys(view._subformsByGroup.group1)).toEqual(["subform1","subform2"]);expect(_.keys(view._subformsByGroup.group2)).toEqual(["subform3","subform4"]);expect(view._subformsByGroup.group1.subform1[0]).toBe($subforms[0]);expect(view._subformsByGroup.group1.subform2[0]).toBe($subforms[1]);expect(view._subformsByGroup.group2.subform3[0]).toBe($subforms[2]);expect(view._subformsByGroup.group2.subform4[0]).toBe($subforms[3]);checkSubformVisibility(0,true);checkSubformVisibility(1,false);checkSubformVisibility(2,true);checkSubformVisibility(3,false)});it("Controller value changed",function(){view.$el.children("select").val("subform2").triggerHandler("change");checkSubformVisibility(0,false);checkSubformVisibility(1,true);checkSubformVisibility(2,true);checkSubformVisibility(3,false)})});describe("Methods",function(){describe("setSubformVisibility",function(){it("With group",function(){view.setSubformVisibility({group:"group2"});checkSubformVisibility(2,false);checkSubformVisibility(3,false)});it("With group, visible",function(){view.setSubformVisibility({group:"group2",visible:true});checkSubformVisibility(2,true);checkSubformVisibility(3,true);view.setSubformVisibility({group:"group2",visible:false});checkSubformVisibility(2,false);checkSubformVisibility(3,false)});it("With group, subformID, visible",function(){checkSubformVisibility(2,true);view.setSubformVisibility({group:"group2",subformID:"subform3",visible:false});checkSubformVisibility(2,false);checkSubformVisibility(3,false);view.setSubformVisibility({group:"group2",subformID:"subform4",visible:true});checkSubformVisibility(3,true)});it("With group, subformID, visible, hideOthers",function(){view.setSubformVisibility({group:"group1",subformID:"subform2",visible:true,hideOthers:true});checkSubformVisibility(0,false);checkSubformVisibility(1,true);view.setSubformVisibility({group:"group1",subformID:"subform1",visible:true,hideOthers:true});checkSubformVisibility(0,true);checkSubformVisibility(1,false)})})})});"use strict";suite("rb/ui/views/InfoboxManagerView",function(){const DummyInfoboxView=RB.BaseInfoboxView.extend({infoboxID:"dummy-infobox"});let infoboxManagerView;beforeEach(function(){infoboxManagerView=RB.InfoboxManagerView.getInstance();spyOn(infoboxManagerView,"_fetchInfoboxContents").and.callFake((url,onDone)=>{expect(url).toBe("/foo/infobox/");onDone("<strong>Hi!</strong>")})});afterEach(function(){infoboxManagerView.remove();RB.InfoboxManagerView._instance=null});describe("addTargets",function(){let $el1;let $el2;let $els;beforeEach(function(){$el1=$("<div/>");$el2=$("<div/>");$els=$([$el1[0],$el2[0]])});it("Registers new targets",function(){infoboxManagerView.addTargets(DummyInfoboxView,$els);expect($el1.data("has-infobox")).toBe(true);expect($el2.data("has-infobox")).toBe(true)});it("Registers event handlers",function(){spyOn(infoboxManagerView,"_onTargetMouseEnter");spyOn(infoboxManagerView,"_onMouseLeave");infoboxManagerView.addTargets(DummyInfoboxView,$els);$el1.triggerHandler("mouseenter");expect(infoboxManagerView._onTargetMouseEnter).toHaveBeenCalled();$el1.triggerHandler("mouseleave");expect(infoboxManagerView._onMouseLeave).toHaveBeenCalled()});it("Skips already-registered targets",function(){spyOn(infoboxManagerView,"_onTargetMouseEnter");infoboxManagerView.addTargets(DummyInfoboxView,$els);infoboxManagerView.addTargets(DummyInfoboxView,$els);$el1.triggerHandler("mouseenter");expect(infoboxManagerView._onTargetMouseEnter.calls.count()).toBe(1)})});describe("getOrCreateInfobox",function(){it("Caches infobox views",function(){const infoboxView1=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);const infoboxView2=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);expect(infoboxView1.cid).toBe(infoboxView2.cid)});it("Starts infobox hidden",function(){const infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);expect(infoboxView.$el.is(":visible")).toBe(false)});it("Registers events",function(){spyOn(infoboxManagerView,"_onInfoboxMouseEnter");spyOn(infoboxManagerView,"_onMouseLeave");const infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);infoboxView.$el.triggerHandler("mouseenter");expect(infoboxManagerView._onInfoboxMouseEnter).toHaveBeenCalled();infoboxView.$el.triggerHandler("mouseleave");expect(infoboxManagerView._onMouseLeave).toHaveBeenCalled()})});describe("setPositioning",function(){it("Overrides default position",function(){infoboxManagerView.setPositioning(DummyInfoboxView,{side:"b",foo:"bar"});const infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);expect(infoboxView.positioning).toEqual({side:"b",foo:"bar"})})});describe("Target Events",function(){let $el;beforeEach(function(){spyOn(window,"setTimeout").and.callFake(cb=>cb());$el=$('<a href="/foo/" />');infoboxManagerView.addTargets(DummyInfoboxView,$el)});describe("mouseenter",function(){it("First time for target",function(){$el.triggerHandler("mouseenter");const infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);expect(infoboxView.$el.html()).toBe("<strong>Hi!</strong>");expect(infoboxView.$el.is(":visible")).toBe(true)});it("Subsequent time for target (cached data)",function(){const infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);spyOn(infoboxView,"setContents").and.callThrough();spyOn(infoboxManagerView,"_showInfobox").and.callThrough();infoboxManagerView._cache["/foo/infobox/"]="Old HTML";$el.triggerHandler("mouseenter");expect(infoboxView.$el.html()).toBe("<strong>Hi!</strong>");expect(infoboxView.$el.is(":visible")).toBe(true);expect(infoboxManagerView._showInfobox.calls.count()).toBe(1);expect(infoboxView.setContents.calls.count()).toBe(2)})});describe("mouseleave",function(){beforeEach(function(){$el.triggerHandler("mouseenter")});it("Cancels showing infobox",function(){infoboxManagerView._showTimeout=123;$el.triggerHandler("mouseleave");expect(infoboxManagerView._showTimeout).toBe(null)});it("Hides infobox",function(){const infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);infoboxManagerView._showTimeout=123;expect(infoboxView.$el.is(":visible")).toBe(true);expect(infoboxManagerView._activeInfoboxView).not.toBe(null);$el.triggerHandler("mouseleave");expect(infoboxView.$el.is(":visible")).toBe(false);expect(infoboxManagerView._activeInfoboxView).toBe(null);expect(infoboxManagerView._showTimeout).toBe(null)})})});describe("Infobox Events",function(){let $el;beforeEach(function(){spyOn(window,"setTimeout").and.callFake(cb=>cb());$el=$('<a href="/foo/" />');infoboxManagerView.addTargets(DummyInfoboxView,$el)});describe("mouseenter",function(){it("Preserves infobox after leaving target",function(){const infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);$el.triggerHandler("mouseenter");expect(infoboxManagerView._activeInfoboxView).toBe(infoboxView);window.setTimeout.and.callThrough();$el.triggerHandler("mouseleave");expect(infoboxManagerView._hideTimeout).not.toBe(null);expect(infoboxManagerView._showTimeout).toBe(null);infoboxView.$el.triggerHandler("mouseenter");expect(infoboxView.$el.is(":visible")).toBe(true);expect(infoboxManagerView._showTimeout).toBe(null);expect(infoboxManagerView._hideTimeout).toBe(null)})});describe("mouseleave",function(){it("Hides infobox",function(){const infoboxView=infoboxManagerView.getOrCreateInfobox(DummyInfoboxView);infoboxManagerView._showInfobox(infoboxView,$el);expect(infoboxView.$el.is(":visible")).toBe(true);expect(infoboxManagerView._activeInfoboxView).toBe(infoboxView);infoboxView.$el.triggerHandler("mouseleave");expect(infoboxView.$el.is(":visible")).toBe(false);expect(infoboxManagerView._activeInfoboxView).toBe(null);expect(infoboxManagerView._showTimeout).toBe(null)})})})});"use strict";suite("rb/ui/views/MenuButtonView",function(){describe("Rendering",function(){it("With primary button",function(){const view=new RB.MenuButtonView({ariaMenuLabel:"Test ARIA label",menuItems:[{text:"Item 1"},{text:"Item 2"},{text:"Item 3"}],onPrimaryButtonClick:()=>{},text:"Button label"});view.render();expect(view.el).toHaveClass("rb-c-menu-button");expect(view.$el.attr("role")).toBe("group");expect(view.$primaryButton.length).toBe(1);const $primaryButton=view.$(".rb-c-menu-button__primary");expect($primaryButton.length).toBe(1);const $toggleButton=view.$(".rb-c-menu-button__toggle");expect($toggleButton.length).toBe(1);expect($toggleButton[0].id).toBe(view.menu.$el.attr("aria-labelledby"));expect($toggleButton.attr("aria-label")).toBe("Test ARIA label");expect($toggleButton.children()[0]).toHaveClass("rb-icon-dropdown-arrow");expect(view.menu.el.children.length).toBe(3)});it("Without primary button",function(){const view=new RB.MenuButtonView({ariaMenuLabel:"Test ARIA label",menuItems:[{text:"Item 1"},{text:"Item 2"}],text:"Button label"});view.render();expect(view.el).toHaveClass("rb-c-menu-button");expect(view.$el.attr("role")).toBe("group");expect(view.$primaryButton).toBeNull();const $primaryButton=view.$(".rb-c-menu-button__primary");expect($primaryButton.length).toBe(0);const $toggleButton=view.$(".rb-c-menu-button__toggle");expect($toggleButton.length).toBe(1);expect($toggleButton[0].id).toBe(view.menu.$el.attr("aria-labelledby"));expect($toggleButton.attr("aria-label")).toBeUndefined();expect($toggleButton.text().trim()).toBe("Button label");expect($toggleButton.children()[0]).toHaveClass("rb-icon-dropdown-arrow");expect(view.menu.el.children.length).toBe(2)})});describe("Events",function(){let view;function sendDropDownButtonEvent(name,options){view._$dropDownButton.trigger($.Event(name,options))}function sendKeyDown(keyCode){sendDropDownButtonEvent("keydown",{which:keyCode})}beforeEach(function(){view=new RB.MenuButtonView;view.render();spyOn(view,"_updateMenuPosition")});describe("keydown",function(){function openMenuTests(keyCode){it("With openDirection=up",function(){view._openDirection="up";spyOn(view.menu,"focusLastItem");sendKeyDown(keyCode);expect(view.menu.isOpen).toBeTrue();expect(view.menu.focusLastItem).toHaveBeenCalled()});it("With openDirection=down",function(){view._openDirection="down";spyOn(view.menu,"focusFirstItem");sendKeyDown(keyCode);expect(view.menu.isOpen).toBeTrue();expect(view.menu.focusFirstItem).toHaveBeenCalled()})}describe("Return key opens menu",function(){openMenuTests($.ui.keyCode.RETURN)});describe("Space key opens menu",function(){openMenuTests($.ui.keyCode.SPACE)});describe("Down key opens menu",function(){openMenuTests($.ui.keyCode.DOWN)});describe("Up key opens menu",function(){openMenuTests($.ui.keyCode.UP)});it("Escape key closes menu",function(){view.menu.open({animate:false});expect(view.menu.isOpen).toBeTrue();sendKeyDown($.ui.keyCode.ESCAPE);expect(view.menu.isOpen).toBeFalse()})});it("focusout closes menu",function(){view.menu.open({animate:false});expect(view.menu.isOpen).toBeTrue();sendDropDownButtonEvent("focusout",{relatedTarget:$testsScratch[0]});expect(view.menu.isOpen).toBeFalse()})})});"use strict";suite("rb/ui/views/MenuView",function(){const ANIMATE_WAIT_MS=300;describe("Rendering",function(){it("Standard menus",function(){const view=new RB.MenuView;view.render().$el.appendTo($testsScratch);expect(view.el.id).toBe(view.id);expect(view.el.id).toMatch(/^__rb-menu\d+/);expect(view.el).toHaveClass("rb-c-menu");expect(view.el).not.toHaveClass("rb-c-button-group");expect(view.el).not.toHaveClass("-is-vertical");expect(view.el.tabIndex).toBe(-1);expect(view.$el.attr("role")).toBe("menu");expect(view.$el.css("display")).toBe("block");expect(view.$el.css("visibility")).toBe("hidden");expect(view.$el.css("opacity")).toBe("0")});it("Button menus",function(){const view=new RB.MenuView({type:RB.MenuView.TYPE_BUTTON_MENU});view.render().$el.appendTo($testsScratch);expect(view.el.id).toBe(view.id);expect(view.el.id).toMatch(/^__rb-menu\d+/);expect(view.el).toHaveClass("rb-c-menu");expect(view.el).toHaveClass("rb-c-button-group");expect(view.el).toHaveClass("-is-vertical");expect(view.el.tabIndex).toBe(-1);expect(view.$el.attr("role")).toBe("menu");expect(view.$el.css("display")).toBe("block");expect(view.$el.css("visibility")).toBe("hidden");expect(view.$el.css("opacity")).toBe("0")});it("With ariaLabelledBy",function(){const view=new RB.MenuView({type:RB.MenuView.TYPE_BUTTON_MENU,ariaLabelledBy:"abc123",ariaLabel:"unused label"});view.render().$el.appendTo($testsScratch);expect(view.$el.attr("aria-label")).toBeUndefined();expect(view.$el.attr("aria-labelledby")).toBe("abc123")});it("With ariaLabel",function(){const view=new RB.MenuView({type:RB.MenuView.TYPE_BUTTON_MENU,ariaLabel:"ARIA label"});view.render();expect(view.$el.attr("aria-label")).toBe("ARIA label");expect(view.$el.attr("aria-labelledby")).toBeUndefined()});it("With $controller",function(){const $controller=$("<div>");const view=new RB.MenuView({type:RB.MenuView.TYPE_BUTTON_MENU,$controller:$controller});view.render();expect(view.el.id).toBe(view.id);expect(view.el.id).toMatch(/^__rb-menu\d+/);expect($controller.attr("aria-controls")).toBe(view.el.id);expect($controller.attr("aria-expanded")).toBe("false");expect($controller.attr("aria-haspopup")).toBe("true")})});describe("Methods",function(){describe("addItem",function(){it("For standard menus",function(){const view=new RB.MenuView;view.render();const $menuItem=view.addItem();const menuItem=$menuItem[0];expect(menuItem.tagName).toBe("DIV");expect(menuItem.tabIndex).toBe(-1);expect(menuItem).toHaveClass("rb-c-menu__item");expect(menuItem).not.toHaveClass("rb-c-button");expect($menuItem.attr("role")).toBe("menuitem");const $children=view.$el.children();expect($children.length).toBe(1);expect($children[0]).toBe(menuItem)});it("For button menus",function(){const view=new RB.MenuView({type:RB.MenuView.TYPE_BUTTON_MENU});view.render();const $menuItem=view.addItem();const menuItem=$menuItem[0];expect(menuItem.tagName).toBe("BUTTON");expect(menuItem.tabIndex).toBe(-1);expect(menuItem).toHaveClass("rb-c-menu__item");expect(menuItem).toHaveClass("rb-c-button");expect($menuItem.attr("type")).toBe("button");expect($menuItem.attr("role")).toBe("menuitem");const $children=view.$el.children();expect($children.length).toBe(1);expect($children[0]).toBe(menuItem)});it("With text",function(){const view=new RB.MenuView({type:RB.MenuView.TYPE_BUTTON_MENU});view.render();const $menuItem=view.addItem({text:"This is a test"});expect($menuItem.text()).toBe("This is a test")})});describe("open",function(){let $controller;let view;beforeEach(function(){$controller=$("<div>").appendTo($testsScratch);view=new RB.MenuView({$controller:$controller});view.render().$el.appendTo($testsScratch);expect(view.$el.css("display")).toBe("block");expect(view.$el.css("visibility")).toBe("hidden");expect(view.$el.css("opacity")).toBe("0");spyOn(view,"trigger").and.callThrough()});it("Default behavior",function(done){view.open();_.delay(()=>{expect(view.isOpen).toBeTrue();expect(view.el).toHaveClass("-is-open");expect(view.el).not.toHaveClass("js-no-animation");expect(view.$el.css("display")).toBe("block");expect(view.$el.css("visibility")).toBe("visible");expect(view.$el.css("opacity")).toBe("1");expect($controller.attr("aria-expanded")).toBe("true");done()},ANIMATE_WAIT_MS)});it("With animate=false",function(done){view.open({animate:false});expect(view.isOpen).toBeTrue();expect(view.el).toHaveClass("-is-open");expect(view.el).toHaveClass("js-no-animation");expect(view.$el.css("display")).toBe("block");expect(view.$el.css("visibility")).toBe("visible");expect(view.$el.css("opacity")).toBe("1");expect(view.trigger).toHaveBeenCalledWith("opening");expect(view.trigger).toHaveBeenCalledWith("opened");expect($controller.attr("aria-expanded")).toBe("true");_.defer(()=>{expect(view.el).not.toHaveClass("js-no-animation");done()})})});describe("close",function(){let $controller;let view;beforeEach(function(){$controller=$('<div aria-expanded="true">').appendTo($testsScratch);view=new RB.MenuView({$controller:$controller});view.render().$el.appendTo($testsScratch);view.isOpen=true;view.$el.addClass("-is-open");expect(view.$el.css("display")).toBe("block");expect(view.$el.css("visibility")).toBe("visible");expect(view.$el.css("opacity")).toBe("1");spyOn(view,"trigger").and.callThrough()});it("Default behavior",function(done){view.close();_.delay(()=>{expect(view.isOpen).toBeFalse();expect(view.el).not.toHaveClass("-is-open");expect(view.el).not.toHaveClass("js-no-animation");expect(view.$el.css("display")).toBe("block");expect(view.$el.css("visibility")).toBe("hidden");expect(view.$el.css("opacity")).toBe("0");expect($controller.attr("aria-expanded")).toBe("false");done()},ANIMATE_WAIT_MS)});it("With animate=false",function(done){view.close({animate:false});expect(view.isOpen).toBeFalse();expect(view.el).toHaveClass("js-no-animation");expect(view.el).not.toHaveClass("-is-open");expect(view.$el.css("display")).toBe("block");expect(view.$el.css("visibility")).toBe("hidden");expect(view.$el.css("opacity")).toBe("0");expect(view.trigger).toHaveBeenCalledWith("closing");expect(view.trigger).toHaveBeenCalledWith("closed");expect($controller.attr("aria-expanded")).toBe("false");_.defer(()=>{expect(view.el).not.toHaveClass("js-no-animation");done()})})});it("focusFirstItem",function(){const view=new RB.MenuView;view.render().$el.appendTo($testsScratch);view.open({animate:false});const itemEl=view.addItem()[0];view.addItem();view.addItem();spyOn(itemEl,"focus");view.focusFirstItem();expect(itemEl.focus).toHaveBeenCalled();expect(view._activeItemIndex).toBe(0)});it("focusLastItem",function(){const view=new RB.MenuView;view.render().$el.appendTo($testsScratch);view.open({animate:false});view.addItem();view.addItem();const itemEl=view.addItem()[0];spyOn(itemEl,"focus");view.focusLastItem();expect(itemEl.focus).toHaveBeenCalled();expect(view._activeItemIndex).toBe(2)})});describe("Keyboard Accessibility",function(){let $controller;let $item1;let $item2;let $item3;let view;function sendKeyDown(keyCode){view.$el.trigger($.Event("keydown",{which:keyCode}))}beforeEach(function(){$controller=$("<div>").appendTo($testsScratch);view=new RB.MenuView({$controller:$controller});view.render().$el.appendTo($testsScratch);$item1=view.addItem();$item2=view.addItem();$item3=view.addItem();view.open({animate:false});view._focusItem(1);spyOn(view,"trigger").and.callThrough()});it("Enter key activates item",function(){const spy=jasmine.createSpy();$item2.on("click",spy);sendKeyDown($.ui.keyCode.ENTER);expect(spy).toHaveBeenCalled()});it("Escape key closes menu",function(){spyOn($controller[0],"focus");sendKeyDown($.ui.keyCode.ESCAPE);expect(view.el).not.toHaveClass("-is-open");expect($controller[0].focus).toHaveBeenCalled()});it("Tab key closes menu",function(){spyOn($controller[0],"focus");sendKeyDown($.ui.keyCode.TAB);expect(view.el).not.toHaveClass("-is-open");expect($controller[0].focus).toHaveBeenCalled()});it("Up key moves focus up",function(){spyOn(view,"_focusItem").and.callThrough();sendKeyDown($.ui.keyCode.UP);expect(view._focusItem).toHaveBeenCalledWith(0);sendKeyDown($.ui.keyCode.UP);expect(view._focusItem).toHaveBeenCalledWith(2)});it("Down key moves focus up",function(){spyOn(view,"_focusItem").and.callThrough();sendKeyDown($.ui.keyCode.DOWN);expect(view._focusItem).toHaveBeenCalledWith(2);sendKeyDown($.ui.keyCode.DOWN);expect(view._focusItem).toHaveBeenCalledWith(0)});it("Home key moves focus to top",function(){spyOn(view,"_focusItem").and.callThrough();sendKeyDown($.ui.keyCode.HOME);expect(view._focusItem).toHaveBeenCalledWith(0)});it("Page Up key moves focus to top",function(){spyOn(view,"_focusItem").and.callThrough();sendKeyDown($.ui.keyCode.PAGE_UP);expect(view._focusItem).toHaveBeenCalledWith(0)});it("End key moves focus to bottom",function(){spyOn(view,"_focusItem").and.callThrough();sendKeyDown($.ui.keyCode.END);expect(view._focusItem).toHaveBeenCalledWith(2)});it("Page Down key moves focus to bottom",function(){spyOn(view,"_focusItem").and.callThrough();sendKeyDown($.ui.keyCode.PAGE_DOWN);expect(view._focusItem).toHaveBeenCalledWith(2)})})});"use strict";suite("rb/ui/managers/NotificationManagerModel",function(){const instance=RB.NotificationManager.instance;let origNotification;const Notification=function(title,options){this.title=title;this.options=options;this.close=function(){}};Notification.requestPermission=function(){Notification.permission="granted"};beforeEach(function(){origNotification=RB.NotificationManager.Notification;RB.NotificationManager.Notification=Notification;RB.UserSession.instance.set("enableDesktopNotifications",true);instance.setup();expect(Notification.permission).toBe("granted")});afterEach(function(){RB.NotificationManager.Notification=origNotification});describe("Notification Manager",function(){it("Calls external API",function(){instance.notify({title:"Test",body:"This is a test"});const notification=instance._notification;expect(notification).not.toBe(null);expect(notification.title).toBe("Test");expect(notification.options.body).toBe("This is a test")});it("Should notify",function(){instance._canNotify=true;spyOn(instance,"_haveNotificationPermissions").and.returnValue(true);expect(instance.shouldNotify()).toBe(true)});it("Should not notify due to user permissions",function(){instance._canNotify=false;spyOn(instance,"_haveNotificationPermissions").and.returnValue(true);expect(instance.shouldNotify()).toBe(false)});it("Should not notify due to browser permissions",function(){instance._canNotify=true;spyOn(instance,"_haveNotificationPermissions").and.returnValue(false);expect(instance.shouldNotify()).toBe(false)})})});"use strict";suite("rb/ui/views/ScrollManagerView",function(){function makeElement(){let dimensions=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const scratchOffset=$testsScratch.offset();return $("<div/>").css({position:"absolute",left:-scratchOffset.left+(dimensions.left||0),top:-scratchOffset.top+(dimensions.top||0),width:dimensions.width||20,height:dimensions.height||20}).appendTo($testsScratch)}let scrollManager;beforeEach(function(){scrollManager=new RB.ScrollManagerView;scrollManager.window={pageXOffset:0,pageYOffset:0,scrollTo(x,y){this.pageXOffset=x;this.pageYOffset=y},requestAnimationFrame(cb){cb()}}});describe("scrollToPosition",function(){it("Without scroll offset",function(){scrollManager.scrollToPosition(100);expect(Math.round(scrollManager.window.pageYOffset)).toBe(100)});it("With scroll offset",function(){scrollManager.scrollYOffset=40;scrollManager.scrollToPosition(100);expect(Math.round(scrollManager.window.pageYOffset)).toBe(60)})});describe("scrollToElement",function(){let $el;beforeEach(function(){$el=makeElement({top:50})});it("Without scroll offset",function(){scrollManager.scrollToElement($el);expect(Math.round(scrollManager.window.pageYOffset)).toBe(50)});it("With scroll offset",function(){scrollManager.scrollYOffset=40;scrollManager.scrollToElement($el);expect(Math.round(scrollManager.window.pageYOffset)).toBe(10)})});describe("markUpdated",function(){let $el;beforeEach(function(){$el=makeElement({top:50})});it("First in a batch",function(){scrollManager.window.pageYOffset=100;expect(scrollManager._oldScrollY).toBe(null);scrollManager.markForUpdate($el);const pendingElement=scrollManager._pendingElements.get($el[0]);expect(Math.round(pendingElement.oldHeight)).toEqual(20);expect(Math.round(pendingElement.oldOffset.top)).toEqual(50);expect(Math.round(pendingElement.oldOffset.left)).toEqual(0);expect(scrollManager._oldScrollY).toBe(100)});it("Subsequent entries",function(){scrollManager._oldScrollY=100;scrollManager.window.pageYOffset=200;scrollManager.markForUpdate($el);const pendingElement=scrollManager._pendingElements.get($el[0]);expect(Math.round(pendingElement.oldHeight)).toEqual(20);expect(Math.round(pendingElement.oldOffset.top)).toEqual(50);expect(Math.round(pendingElement.oldOffset.left)).toEqual(0);expect(scrollManager._oldScrollY).toBe(100)})});describe("markUpdated",function(){let $el;beforeEach(function(){$el=makeElement({top:50})});it("Stores correct state",function(){spyOn(scrollManager.window,"requestAnimationFrame");scrollManager.markForUpdate($el);$el.height(40);$el.css("top",parseInt($el.css("top"),10)-10);scrollManager.markUpdated($el);const el=$el[0];expect(scrollManager._pendingElements.get(el)).toBe(undefined);const element=scrollManager._elements.get(el);expect(Math.round(element.oldHeight)).toEqual(20);expect(Math.round(element.oldOffset.top)).toEqual(50);expect(Math.round(element.oldOffset.left)).toEqual(0);expect(Math.round(element.newHeight)).toEqual(40);expect(Math.round(element.newOffset.top)).toEqual(40);expect(Math.round(element.newOffset.left)).toEqual(0);expect(scrollManager.window.requestAnimationFrame).toHaveBeenCalled()})});describe("Scroll updates",function(){beforeEach(function(){spyOn(scrollManager.window,"requestAnimationFrame");scrollManager.window.pageYOffset=200});it("Includes updates before scroll position",function(){const $el1=makeElement({top:10});const $el2=makeElement({top:60});const $el3=makeElement({top:70});scrollManager.markForUpdate($el1);$el1.height(70);scrollManager.markUpdated($el1);scrollManager.markForUpdate($el2);$el2.height(10);scrollManager.markUpdated($el2);scrollManager.markForUpdate($el3);$el3.css("top",parseInt($el3.css("top"),10)-5);scrollManager.markUpdated($el3);scrollManager._updateScrollPos();expect(Math.round(scrollManager.window.pageYOffset)).toBe(235)});it("Ignores updates after scroll position",function(){const $el1=makeElement({top:10});const $el2=makeElement({top:scrollManager.window.pageYOffset});const $el3=makeElement({top:500});scrollManager.markForUpdate($el1);$el1.height(30);scrollManager.markUpdated($el1);scrollManager.markForUpdate($el2);$el2.height(90);scrollManager.markUpdated($el2);scrollManager.markForUpdate($el3);$el3.height(1e3);scrollManager.markUpdated($el3);scrollManager._updateScrollPos();expect(scrollManager.window.pageYOffset).toBe(210)})})});"use strict";suite("rb/ui/views/TextEditorView",function(){let view;beforeEach(function(){RB.DnDUploader.create()});afterEach(function(){RB.DnDUploader.instance=null});describe("Construction",function(){it("Initial text",function(){view=new RB.TextEditorView({text:"Test"});view.render();expect(view.getText()).toBe("Test")});describe("Text field wrapper",function(){it("If plain text",function(){view=new RB.TextEditorView({richText:false});view.render();view.show();expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)});it("If Markdown",function(){view=new RB.TextEditorView({richText:true});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)})});describe("Default richText",function(){describe("If user default is true",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",true)});it("And richText unset",function(){view=new RB.TextEditorView;view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("And richText=true",function(){view=new RB.TextEditorView({richText:true});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("And richText=false",function(){view=new RB.TextEditorView({richText:false});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)})});describe("If user default is false",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",false)});it("And richText unset",function(){view=new RB.TextEditorView;view.render();view.show();expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)});it("And richText=true",function(){view=new RB.TextEditorView({richText:true});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("And richText=false",function(){view=new RB.TextEditorView({richText:false});view.render();view.show();expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)})})})});describe("Operations",function(){describe("bindRichTextAttr",function(){let myModel;beforeEach(function(){myModel=new Backbone.Model({richText:false});view=new RB.TextEditorView});it("Updates on change",function(){view.bindRichTextAttr(myModel,"richText");expect(view.richText).toBe(false);myModel.set("richText",true);expect(view.richText).toBe(true)});describe("Initial richText value",function(){it("true",function(){myModel.set("richText",true);view.bindRichTextAttr(myModel,"richText");expect(view.richText).toBe(true)});it("false",function(){myModel.set("richText",false);view.bindRichTextAttr(myModel,"richText");expect(view.richText).toBe(false)})})});describe("bindRichTextCheckbox",function(){let $checkbox;beforeEach(function(){$checkbox=$('<input type="checkbox">');view=new RB.TextEditorView;view.setRichText(false)});it("Checkbox reflects richText",function(){view.bindRichTextCheckbox($checkbox);expect($checkbox.prop("checked")).toBe(false);view.setRichText(true);expect($checkbox.prop("checked")).toBe(true)});describe("richText reflects checkbox",function(){it("Checked",function(){view.setRichText(false);view.bindRichTextCheckbox($checkbox);$checkbox.prop("checked",true).triggerHandler("change");expect(view.richText).toBe(true)});it("Unchecked",function(){view.setRichText(true);view.bindRichTextCheckbox($checkbox);$checkbox.prop("checked",false).triggerHandler("change");expect(view.richText).toBe(false)})});describe("Initial checked state",function(){it("richText=true",function(){view.setRichText(true);view.bindRichTextCheckbox($checkbox);expect($checkbox.prop("checked")).toBe(true)});it("richText=false",function(){view.setRichText(false);view.bindRichTextCheckbox($checkbox);expect($checkbox.prop("checked")).toBe(false)})})});describe("bindRichTextVisibility",function(){let $el;beforeEach(function(){$el=$("<div>");view=new RB.TextEditorView;view.setRichText(false)});describe("Initial visibility",function(){it("richText=true",function(){$el.hide();view.setRichText(true);view.bindRichTextVisibility($el);const display=$el.css("display");expect(display==="block"||display==="").toBe(true)});it("richText=false",function(){view.bindRichTextVisibility($el);expect($el.css("display")).toBe("none")})});describe("Toggles visibility on change",function(){it("richText=true",function(){$el.hide();view.bindRichTextVisibility($el);expect($el.css("display")).toBe("none");view.setRichText(true);const display=$el.css("display");expect(display==="block"||display==="").toBe(true)});it("richText=false",function(){view.setRichText(true);view.bindRichTextVisibility($el);const display=$el.css("display");expect(display==="block"||display==="").toBe(true);view.setRichText(false);expect($el.css("display")).toBe("none")})})});describe("setRichText",function(){it("Emits change:richText",function(){let emitted=false;view.on("change:richText",function(){emitted=true});view.show();view.richText=false;view.setRichText(true);expect(emitted).toBe(true)});it("Emits change",function(){let emitted=false;view.on("change",function(){emitted=true});view.show();view.richText=false;view.setRichText(true);expect(emitted).toBe(true)});it("Marks dirty",function(){view.show();view.richText=false;expect(view.isDirty()).toBe(false);view.setRichText(true);expect(view.isDirty()).toBe(true)});describe("Markdown to Text",function(){beforeEach(function(){view=new RB.TextEditorView({richText:true});view.render()});it("If shown",function(){view.show();view.setRichText(false);expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)});it("If hidden",function(){view.setRichText(false);expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(0)})});describe("Text to Markdown",function(){beforeEach(function(){view=new RB.TextEditorView({richText:false});view.render()});it("If shown",function(){view.show();view.setRichText(true);expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("If hidden",function(){view.setRichText(true);expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(0)})})});describe("setText",function(){describe("If shown",function(){it("If plain text",function(){view=new RB.TextEditorView({richText:false});view.show();view.setText("Test");expect(view.$("textarea").val()).toBe("Test")});it("If Markdown",function(){view=new RB.TextEditorView({richText:true});view.show();view.setText("Test");expect(view._editor._codeMirror.getValue()).toBe("Test")})});it("If hidden",function(){view=new RB.TextEditorView;view.setText("Test");expect(view.getText()).toBe("Test")})});describe("getText",function(){it("If plain text",function(){view=new RB.TextEditorView({richText:false});view.show();view.setText("Test");expect(view.getText()).toBe("Test")});it("If Markdown",function(){view=new RB.TextEditorView({richText:true});view.show();view.setText("Test");expect(view.getText()).toBe("Test")})});describe("insertLine",function(){it("If plain text",function(){view=new RB.TextEditorView({richText:false});view.show();view.setText("Test");view.insertLine("Test");expect(view.getText()).toBe("Test\nTest")});it("If Markdown",function(){view=new RB.TextEditorView({richText:true});view.show();view.setText("Test");view.insertLine("Test");expect(view.getText()).toBe("Test\nTest")})});describe("show",function(){it("registers drop target if rich text",function(){spyOn(RB.DnDUploader.instance,"registerDropTarget");view=new RB.TextEditorView({richText:true});view.show();expect(RB.DnDUploader.instance.registerDropTarget).toHaveBeenCalled()});it("does not register drop target if plain text",function(){spyOn(RB.DnDUploader.instance,"registerDropTarget");view=new RB.TextEditorView({richText:false});view.show();expect(RB.DnDUploader.instance.registerDropTarget).not.toHaveBeenCalled()})});describe("hide",function(){it("disables drop target",function(){spyOn(RB.DnDUploader.instance,"unregisterDropTarget");view=new RB.TextEditorView({richText:true});view.show();view.hide();expect(RB.DnDUploader.instance.unregisterDropTarget).toHaveBeenCalled()})})});describe("inlineEditor options",function(){let $el;let $buttons;let $markdownCheckbox;function setupEditor(options){$el=$("<textarea>").inlineEditor(RB.TextEditorView.getInlineEditorOptions(options));view=$el.inlineEditor("field").data("text-editor");$el.inlineEditor("startEdit");$buttons=$el.inlineEditor("buttons");expect($buttons.length).toBe(1);$markdownCheckbox=$buttons.find("input[type=checkbox]");expect($markdownCheckbox.length).toBe(1)}describe("Rich text checkbox",function(){function setChecked(checked){$markdownCheckbox.click().prop("checked",checked).trigger("change")}it("Checking",function(){setupEditor({richText:false});expect($markdownCheckbox.prop("checked")).toBe(false);setChecked(true);expect($markdownCheckbox.prop("checked")).toBe(true);expect(view.richText).toBe(true)});it("Unchecking",function(){setupEditor({richText:true});expect($markdownCheckbox.prop("checked")).toBe(true);setChecked(false);expect($markdownCheckbox.prop("checked")).toBe(false);expect(view.richText).toBe(false)});it("Resets after cancel",function(){setupEditor({richText:true});setChecked(false);$el.inlineEditor("cancel");expect($markdownCheckbox.prop("checked")).toBe(true);expect(view.richText).toBe(true);expect(view.isDirty()).toBe(false)});describe("Initial state",function(){it("If plain text",function(){setupEditor({richText:false});expect($markdownCheckbox.prop("checked")).toBe(false)});it("If Markdown",function(){setupEditor({richText:true});expect($markdownCheckbox.prop("checked")).toBe(true)})})})});describe("Drag and Drop",function(){beforeEach(function(){view=new RB.TextEditorView({richText:true})});describe("_isImage",function(){it("correctly checks mimetype",function(){const file={type:"image/jpeg",name:"testimage.jpg"};expect(view._isImage(file)).toBe(true)});it("checks filename extension",function(){const file={name:"testimage.jpg"};expect(view._isImage(file)).toBe(true)});it("returns false when given invalid type",function(){const file={type:"application/json",name:"testimage.jps"};expect(view._isImage(file)).toBe(false)})})})});"use strict";suite("rb/utils/dataUtils",function(){it("readBlobAsArrayBuffer",function(done){const str="abc123";const blob=new Blob([str]);RB.DataUtils.readBlobAsArrayBuffer(blob,result=>{expect(result.byteLength).toBe(6);const dataView=new DataView(result);for(let i=0;i<result.byteLength;i++){expect(dataView.getUint8(i)).toBe(str.charCodeAt(i))}done()})});it("readBlobAsString",function(done){const blob=new Blob(["This is a test."]);RB.DataUtils.readBlobAsString(blob,result=>{expect(typeof result).toBe("string");expect(result).toBe("This is a test.");done()})});it("readManyBlobsAsArrayBuffers",function(done){const str1="abc123";const str2="foo";const blob1=new Blob([str1]);const blob2=new Blob([str2]);RB.DataUtils.readManyBlobsAsArrayBuffers([blob1,blob2],(result1,result2)=>{expect(result1.byteLength).toBe(6);expect(result2.byteLength).toBe(3);const dataView1=new DataView(result1);for(let i=0;i<result1.byteLength;i++){expect(dataView1.getUint8(i)).toBe(str1.charCodeAt(i))}const dataView2=new DataView(result2);for(let i=0;i<result2.byteLength;i++){expect(dataView2.getUint8(i)).toBe(str2.charCodeAt(i))}done()})});it("readManyBlobsAsStrings",function(done){const blob1=new Blob(["This is a test."]);const blob2=new Blob(["hello world"]);RB.DataUtils.readManyBlobsAsStrings([blob1,blob2],(result1,result2)=>{expect(typeof result1).toBe("string");expect(typeof result2).toBe("string");expect(result1).toBe("This is a test.");expect(result2).toBe("hello world");done()})});describe("buildArrayBuffer",function(){it("With int8",function(){const values=[-1,0,1];const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int8",values:values}]);expect(arrayBuffer.byteLength).toBe(3);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getInt8(i)).toBe(values[i])}});it("With uint8",function(){const values=[1,2,3];const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint8",values:values}]);expect(arrayBuffer.byteLength).toBe(3);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getUint8(i)).toBe(values[i])}});describe("With int16",function(){const values=[-1,0,1];it("Little endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int16",values:values}]);expect(arrayBuffer.byteLength).toBe(6);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getInt16(i*2,true)).toBe(values[i])}});it("Big endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int16",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(6);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getInt16(i*2)).toBe(values[i])}})});describe("With uint16",function(){const values=[1,2,3];it("Little endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint16",values:values}]);expect(arrayBuffer.byteLength).toBe(6);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getUint16(i*2,true)).toBe(values[i])}});it("Big endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint16",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(6);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getUint16(i*2)).toBe(values[i])}})});describe("With int32",function(){const values=[-1,0,1];it("Little endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int32",values:values}]);expect(arrayBuffer.byteLength).toBe(12);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getInt32(i*4,true)).toBe(values[i])}});it("Big endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int32",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(12);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getInt32(i*4)).toBe(values[i])}})});describe("With uint32",function(){const values=[1,2,3];it("Little endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:values}]);expect(arrayBuffer.byteLength).toBe(12);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getUint32(i*4,true)).toBe(values[i])}});it("Big endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(12);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getUint32(i*4)).toBe(values[i])}})});describe("With float32",function(){const values=[1,2,3];it("Little endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"float32",values:values}]);expect(arrayBuffer.byteLength).toBe(12);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getFloat32(i*4,true)).toBe(values[i])}});it("Big endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"float32",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(12);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getFloat32(i*4)).toBe(values[i])}})});describe("With float64",function(){const values=[1,2,3];it("Little endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"float64",values:values}]);expect(arrayBuffer.byteLength).toBe(24);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getFloat64(i*8,true)).toBe(values[i])}});it("Big endian",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"float64",values:values,bigEndian:true}]);expect(arrayBuffer.byteLength).toBe(24);const dataView=new DataView(arrayBuffer);for(let i=0;i<values.length;i++){expect(dataView.getFloat64(i*8)).toBe(values[i])}})});it("With complex schema",function(){const arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"int32",values:[10,20],bigEndian:true},{type:"uint8",values:[100]},{type:"uint16",values:[64]},{type:"float64",values:[1.234]}]);expect(arrayBuffer.byteLength).toBe(19);const dataView=new DataView(arrayBuffer);expect(dataView.getInt32(0)).toBe(10);expect(dataView.getInt32(4)).toBe(20);expect(dataView.getUint8(8)).toBe(100);expect(dataView.getUint16(9,true)).toBe(64);expect(dataView.getFloat64(11,true)).toEqual(1.234)})});it("buildBlob",function(done){const blob=RB.DataUtils.buildBlob(["abc",[{type:"uint8",values:[1,2]},{type:"uint32",values:[100]}],new Blob(["def"])]);RB.DataUtils.readBlobAsArrayBuffer(blob,arrayBuffer=>{expect(arrayBuffer.byteLength).toBe(12);const dataView=new DataView(arrayBuffer);expect(dataView.getUint8(0)).toBe("a".charCodeAt(0));expect(dataView.getUint8(1)).toBe("b".charCodeAt(0));expect(dataView.getUint8(2)).toBe("c".charCodeAt(0));expect(dataView.getUint8(3)).toBe(1);expect(dataView.getUint8(4)).toBe(2);expect(dataView.getUint32(5,true)).toBe(100);expect(dataView.getUint8(9)).toBe("d".charCodeAt(0));expect(dataView.getUint8(10)).toBe("e".charCodeAt(0));expect(dataView.getUint8(11)).toBe("f".charCodeAt(0));done()})})});"use strict";suite("rb/utils/keyBindingUtils",function(){describe("KeyBindingsMixin",function(){function sendKeyPress($el,keyCode,handled){const evt=jQuery.Event("keypress");evt.which=keyCode.charCodeAt(0);$el.trigger(evt);expect(evt.isDefaultPrevented()).toBe(handled);expect(evt.isPropagationStopped()).toBe(handled)}it("Registered on create",function(){const MyView=Backbone.View.extend({keyBindings:{}});_.extend(MyView.prototype,RB.KeyBindingsMixin);spyOn(MyView.prototype,"delegateKeyBindings");this._view=new MyView;expect(MyView.prototype.delegateKeyBindings).toHaveBeenCalled()});it("Unregistered on undelegateEvents",function(){const MyView=Backbone.View.extend({keyBindings:{}});_.extend(MyView.prototype,RB.KeyBindingsMixin);const view=new MyView;spyOn(MyView.prototype,"undelegateKeyBindings");view.undelegateEvents();expect(MyView.prototype.undelegateKeyBindings).toHaveBeenCalled()});it("Keys to function name",function(){const MyView=Backbone.View.extend({keyBindings:{abc:"myFunc1",def:"myFunc2"},myFunc1:function(){},myFunc2:function(){}});_.extend(MyView.prototype,RB.KeyBindingsMixin);const view=new MyView;view.render().$el.appendTo($testsScratch);spyOn(view,"myFunc1");spyOn(view,"myFunc2");sendKeyPress(view.$el,"e",true);expect(view.myFunc1).not.toHaveBeenCalled();expect(view.myFunc2).toHaveBeenCalled()});it("Keys to function",function(){const MyView=Backbone.View.extend({keyBindings:{abc:function(){},def:function(){}}});_.extend(MyView.prototype,RB.KeyBindingsMixin);const view=new MyView;view.render().$el.appendTo($testsScratch);spyOn(view.keyBindings,"abc");spyOn(view.keyBindings,"def");sendKeyPress(view.$el,"b",true);expect(view.keyBindings.abc).toHaveBeenCalled();expect(view.keyBindings.def).not.toHaveBeenCalled()});it("Unmatched keys",function(){const MyView=Backbone.View.extend({keyBindings:{abc:function(){},def:function(){}}});_.extend(MyView.prototype,RB.KeyBindingsMixin);const view=new MyView;view.render().$el.appendTo($testsScratch);spyOn(view.keyBindings,"abc");spyOn(view.keyBindings,"def");sendKeyPress(view.$el,"!",false);expect(view.keyBindings.abc).not.toHaveBeenCalled();expect(view.keyBindings.def).not.toHaveBeenCalled()})})});"use strict";suite("rb/utils/linkifyUtils",function(){var bugTrackerURL="http://issues/?id=--bug_id--";describe("linkifyChildren",function(){it("URLs",function(){var $el=$("<p><span>http://example.com</span></p>");RB.LinkifyUtils.linkifyChildren($el[0]);const $span=$el.children("span");expect($span.length).toBe(1);const $a=$span.children("a");expect($a.length).toBe(1);expect($a.attr("target")).toBe("_blank");expect($a.attr("href")).toBe("http://example.com");expect($a.text()).toBe("http://example.com")});it("Bugs",function(){var $el=$("<p><span>Bug #123</span></p>");RB.LinkifyUtils.linkifyChildren($el[0],bugTrackerURL);const $span=$el.children("span");expect($span.length).toBe(1);const $a=$span.children("a");expect($a.length).toBe(1);expect($a.attr("target")).toBe("_blank");expect($a.attr("href")).toBe("http://issues/?id=123");expect($a.text()).toBe("Bug #123")});it("/r/ paths",function(){var $el=$("<p><span>/r/123/</span></p>");RB.LinkifyUtils.linkifyChildren($el[0]);const $span=$el.children("span");expect($span.length).toBe(1);const $a=$span.children("a");expect($a.length).toBe(1);expect($a.attr("target")).toBe("_blank");expect($a.attr("href")).toBe("/r/123/");expect($a.attr("class")).toBe("review-request-link");expect($a.text()).toBe("/r/123/")});it("Skips <a> elements",function(){var $el=$('<p><span><a href="http://example.com">/r/123</a>'+"</span></p>");RB.LinkifyUtils.linkifyChildren($el[0]);const $span=$el.children("span");expect($span.length).toBe(1);const $a=$span.children("a");expect($a.length).toBe(1);expect($a.attr("target")).toBe(undefined);expect($a.attr("href")).toBe("http://example.com");expect($a.text()).toBe("/r/123")});it("Skips <pre> elements",function(){var $el=$("<div><pre>/r/123</pre></div>");RB.LinkifyUtils.linkifyChildren($el[0]);expect($el.html()).toBe("<pre>/r/123</pre>")})});describe("linkifyText",function(){describe("URLs",function(){const linkifyText=RB.LinkifyUtils.linkifyText;it("http://",function(){expect(linkifyText("http://example.com")).toBe('<a target="_blank" href="http://example.com">'+"http://example.com</a>")});it("https://",function(){expect(linkifyText("https://example.com")).toBe('<a target="_blank" href="https://example.com">'+"https://example.com</a>")});it("ftp://",function(){expect(linkifyText("ftp://example.com")).toBe('<a target="_blank" href="ftp://example.com">'+"ftp://example.com</a>")});it("ftps://",function(){expect(linkifyText("ftps://example.com")).toBe('<a target="_blank" href="ftps://example.com">'+"ftps://example.com</a>")});it("gopher://",function(){expect(linkifyText("gopher://example.com")).toBe('<a target="_blank" href="gopher://example.com">'+"gopher://example.com</a>")});it("mailto:",function(){expect(linkifyText("mailto:user@example.com")).toBe('<a target="_blank" href="mailto:user@example.com">'+"mailto:user@example.com</a>")});it("news:",function(){expect(linkifyText("news:example.com")).toBe('<a target="_blank" href="news:example.com">'+"news:example.com</a>")});it("sms:",function(){expect(linkifyText("sms:example.com")).toBe('<a target="_blank" href="sms:example.com">'+"sms:example.com</a>")});it("javascript: (unlinked)",function(){expect(linkifyText("javascript:test")).toBe("javascript:test")});it("javascript:// (unlinked)",function(){expect(linkifyText("javascript://test")).toBe("javascript://test")});it("Trailing slashes",function(){expect(linkifyText("http://example.com/foo/")).toBe('<a target="_blank" href="http://example.com/foo/">'+"http://example.com/foo/</a>")});it("Anchors",function(){expect(linkifyText("http://example.com/#my-anchor")).toBe('<a target="_blank" href="'+'http://example.com/#my-anchor">'+"http://example.com/#my-anchor</a>")});it("Query strings",function(){expect(linkifyText("http://example.com/?a=b&c=d")).toBe('<a target="_blank" href="'+'http://example.com/?a=b&amp;c=d">'+"http://example.com/?a=b&amp;c=d</a>")});describe("Surrounded by",function(){it("(...)",function(){expect(linkifyText("(http://example.com/)")).toBe('(<a target="_blank" href="http://example.com/">'+"http://example.com/</a>)")});it("[...]",function(){expect(linkifyText("[http://example.com/]")).toBe('[<a target="_blank" href="http://example.com/">'+"http://example.com/</a>]")});it("{...}",function(){expect(linkifyText("{http://example.com/}")).toBe('{<a target="_blank" href="http://example.com/">'+"http://example.com/</a>}")});it("<...>",function(){expect(linkifyText("<http://example.com/>")).toBe('&lt;<a target="_blank" href="'+'http://example.com/">http://example.com/</a>&gt;')})})});describe("/r/ paths",function(){describe("Review requests",function(){it("/r/123",function(){expect(RB.LinkifyUtils.linkifyText("/r/123")).toBe('<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123</a>')});it("/r/123/",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/")).toBe('<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123/</a>')})});describe("Diffs",function(){it("/r/123/diff",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/diff")).toBe('<a target="_blank" href="/r/123/diff/" '+'class="review-request-link">/r/123/diff</a>')});it("/r/123/diff/",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/diff/")).toBe('<a target="_blank" href="/r/123/diff/" '+'class="review-request-link">/r/123/diff/</a>')})})});describe("Surrounded by",function(){it("(...)",function(){expect(RB.LinkifyUtils.linkifyText("(/r/123/)")).toBe('(<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123/</a>)')});it("[...]",function(){expect(RB.LinkifyUtils.linkifyText("[/r/123/]")).toBe('[<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123/</a>]')});it("{...}",function(){expect(RB.LinkifyUtils.linkifyText("{/r/123/}")).toBe('{<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123/</a>}')});it("<...>",function(){expect(RB.LinkifyUtils.linkifyText("</r/123/>")).toBe('&lt;<a target="_blank" href="/r/123/" '+'class="review-request-link">/r/123/</a>&gt;')});it("text",function(){expect(RB.LinkifyUtils.linkifyText("foo/r/123/bar")).toBe("foo/r/123/bar")})})});describe("Bug References",function(){describe("With bugTrackerURL",function(){function linkifyText(text){return RB.LinkifyUtils.linkifyText(text,bugTrackerURL)}it("bug 123",function(){expect(linkifyText("bug 123")).toBe('<a target="_blank" href="http://issues/?id=123">'+"bug 123</a>")});it("bug #123",function(){expect(linkifyText("bug #123")).toBe('<a target="_blank" href="http://issues/?id=123">'+"bug #123</a>")});it("issue 123",function(){expect(linkifyText("issue 123")).toBe('<a target="_blank" href="http://issues/?id=123">'+"issue 123</a>")});it("issue #123",function(){expect(linkifyText("issue #123")).toBe('<a target="_blank" href="http://issues/?id=123">'+"issue #123</a>")});it("bug #abc",function(){expect(linkifyText("bug #abc")).toBe('<a target="_blank" href="http://issues/?id=abc">'+"bug #abc</a>")});it("issue #abc",function(){expect(linkifyText("issue #abc")).toBe('<a target="_blank" href="http://issues/?id=abc">'+"issue #abc</a>")});it("issue #abc, issue 2",function(){expect(linkifyText("issue #abc, issue 2")).toBe('<a target="_blank" href="http://issues/?id=abc">'+'issue #abc</a>, <a target="_blank" '+'href="http://issues/?id=2">issue 2</a>')});it("(issue #abc-123) [bug #cba-321]",function(){expect(linkifyText("(issue #abc-123) [bug #cba-321]")).toBe('(<a target="_blank" href="http://issues/?id=abc-123">'+'issue #abc-123</a>) [<a target="_blank" '+'href="http://issues/?id=cba-321">bug #cba-321</a>]')})});describe("Without bugTrackerURL",function(){const linkifyText=RB.LinkifyUtils.linkifyText;it("bug 123",function(){expect(linkifyText("bug 123")).toBe("bug 123")});it("issue 123",function(){expect(linkifyText("issue 123")).toBe("issue 123")})})})});"use strict";suite("rb/utils/urlUtils",function(){describe("getLocationHash",function(){beforeEach(function(){window.xss=function(){}});afterEach(function(){if(window.hasOwnProperty("xss")){delete window.xss}});it("Prevents XSS injection",function(done){spyOn(window,"xss");const url="http://www.example.com/#<img/src/onerror=window.xss()>";const hash=RB.getLocationHash(url);$(`a[name="${hash}"]`);_.delay(function(){expect(window.xss).not.toHaveBeenCalled();done()})})})});"use strict";suite("rb/views/CollectionView",function(){let collection;let view;const TestModel=Backbone.Model.extend({defaults:_.defaults({data:""})});const TestCollection=Backbone.Collection.extend({model:TestModel});const TestModelView=Backbone.View.extend({className:"test-class",render(){this.$el.text(this.model.get("data"));return this}});const TestCollectionView=RB.CollectionView.extend({itemViewType:TestModelView});beforeEach(function(){collection=new TestCollection;view=new TestCollectionView({collection:collection})});describe("Rendering",function(){it("When empty",function(){view.render();expect(view.$el.children().length).toBe(0)});it("With items",function(){collection.add([{data:"Item 1"},{data:"Item 2"}]);view.render();const $children=view.$el.children();expect($children.length).toBe(2);expect($children[0].innerHTML).toBe("Item 1");expect($children[1].innerHTML).toBe("Item 2")});it("Item model type",function(){collection.add([{data:"Item 1"}]);view.render();expect(view.$el.children().hasClass("test-class")).toBe(true)});it("With custom element container",function(){const $container=$('<div class="rb-test-main-container"/>').appendTo(view.$el);view.$container=$container;collection.add([{data:"Item 1"},{data:"Item 2"}]);view.render();const $viewChildren=view.$el.children();expect($viewChildren.length).toBe(1);expect($viewChildren[0].className).toBe("rb-test-main-container");const $containerChildren=$viewChildren.eq(0).children();expect($containerChildren.length).toBe(2);expect($containerChildren[0].innerHTML).toBe("Item 1");expect($containerChildren[1].innerHTML).toBe("Item 2")})});describe("Live updating",function(){it("Adding items after rendering",function(){collection.add([{data:"Item 1"}]);view.render();expect(view.$el.children().length).toBe(1);collection.add([{data:"Item 2"},{data:"Item 3"}]);const $children=view.$el.children();expect($children.length).toBe(3);expect($children[2].innerHTML).toBe("Item 3")});it("Removing items after rendering",function(){const model1=new TestModel({data:"Item 1"});const model2=new TestModel({data:"Item 2"});const model3=new TestModel({data:"Item 3"});collection.add([model1,model2,model3]);view.render();expect(view.$el.children().length).toBe(3);collection.remove([model1,model3]);const $children=view.$el.children();expect($children.length).toBe(1);expect($children[0].innerHTML).toBe("Item 2")});it("When reset",function(){collection.add([{data:"Item 1"},{data:"Item 2"}]);view.render();let $children=view.$el.children();expect($children.length).toBe(2);expect($children[0].innerHTML).toBe("Item 1");expect($children[1].innerHTML).toBe("Item 2");collection.reset([{data:"Item 3"},{data:"Item 4"},{data:"Item 5"}]);$children=view.$el.children();expect($children.length).toBe(3);expect($children[0].innerHTML).toBe("Item 3");expect($children[1].innerHTML).toBe("Item 4");expect($children[2].innerHTML).toBe("Item 5")});describe("Sorting",function(){it("With order changed",function(){collection.add([{data:"Item 2"},{data:"Item 3"},{data:"Item 1"}]);view.render();let $children=view.$el.children();expect($children.length).toBe(3);expect($children[0].innerHTML).toBe("Item 2");expect($children[1].innerHTML).toBe("Item 3");expect($children[2].innerHTML).toBe("Item 1");self.spyOn(view,"_addCollectionViews").and.callThrough();collection.comparator="data";collection.sort();$children=view.$el.children();expect($children[0].innerHTML).toBe("Item 1");expect($children[1].innerHTML).toBe("Item 2");expect($children[2].innerHTML).toBe("Item 3");expect(view._addCollectionViews).toHaveBeenCalled()});it("With order unchanged",function(){collection.add([{data:"Item 1"},{data:"Item 2"},{data:"Item 3"}]);view.render();let $children=view.$el.children();expect($children.length).toBe(3);expect($children[0].innerHTML).toBe("Item 1");expect($children[1].innerHTML).toBe("Item 2");expect($children[2].innerHTML).toBe("Item 3");collection.comparator="data";collection.sort();self.spyOn(view,"_addCollectionViews").and.callThrough();$children=view.$el.children();expect($children[0].innerHTML).toBe("Item 1");expect($children[1].innerHTML).toBe("Item 2");expect($children[2].innerHTML).toBe("Item 3");expect(view._addCollectionViews).not.toHaveBeenCalled()})})})});"use strict";suite("rb/views/CommentDialogView",function(){let reviewRequest;let reviewRequestEditor;beforeEach(function(){RB.DnDUploader.create();reviewRequest=new RB.ReviewRequest;reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest})});afterEach(function(){RB.DnDUploader.instance=null});describe("Class methods",function(){describe("create",function(){it("Without a comment",function(){expect(()=>RB.CommentDialogView.create({animate:false,container:$testsScratch,reviewRequestEditor:reviewRequestEditor})).toThrow();expect(RB.CommentDialogView._instance).toBeFalsy();expect($testsScratch.children().length).toBe(0)});it("With a comment",function(){const dlg=RB.CommentDialogView.create({animate:false,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg).toBeTruthy();expect(RB.CommentDialogView._instance).toBe(dlg);expect($testsScratch.children().length).toBe(1)});it("Replacing an open dialog",function(){const dlg1=RB.CommentDialogView.create({animate:false,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg1).toBeTruthy();const dlg2=RB.CommentDialogView.create({animate:false,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg2).toBeTruthy();expect(dlg2).not.toBe(dlg1);expect(dlg1.$el.parents().length).toBe(0);expect(RB.CommentDialogView._instance).toBe(dlg2);expect($testsScratch.children().length).toBe(1)})})});describe("Instances",function(){let editor;let dlg;beforeEach(function(){editor=new RB.CommentEditor({comment:new RB.DiffComment,canEdit:true,reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor,commentIssueManager:new RB.CommentIssueManager});dlg.on("closed",()=>{dlg=null});dlg.render().$el.appendTo($testsScratch)});afterEach(function(){if(dlg){dlg.close()}});describe("Buttons",function(){beforeEach(function(){dlg.open()});describe("Cancel",function(){let $button;beforeEach(function(){$button=dlg.$el.find(".buttons .cancel")});it("Enabled",function(){expect($button.is(":disabled")).toBe(false)});it("Cancels editor when clicked",function(){spyOn(editor,"cancel");$button.click();expect(editor.cancel).toHaveBeenCalled()});it("Closes dialog when clicked",function(){spyOn(editor,"cancel");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});it("Confirms before cancelling unsaved comment",function(){spyOn(editor,"cancel");spyOn(dlg,"close");spyOn(window,"confirm").and.returnValue(true);editor.set("dirty",true);$button.click();expect(dlg.close).toHaveBeenCalled()});it("Cancel close when unsaved comment",function(){spyOn(editor,"cancel");spyOn(dlg,"close");spyOn(window,"confirm").and.returnValue(false);editor.set("dirty",true);$button.click();expect(dlg.close).not.toHaveBeenCalled()});describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect($button.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect($button.is(":visible")).toBe(false)})})});describe("Close",function(){let $button;beforeEach(function(){$button=dlg.$el.find(".buttons .close")});it("Cancels editor when clicked",function(){spyOn(editor,"cancel");$button.click();expect(editor.cancel).toHaveBeenCalled()});it("Closes dialog when clicked",function(){spyOn(editor,"cancel");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});describe("Visibility",function(){it("Shown when canEdit=false",function(){editor.set("canEdit",false);expect($button.is(":visible")).toBe(true)});it("Hidden when canEdit=true",function(){editor.set("canEdit",true);expect($button.is(":visible")).toBe(false)})})});describe("Delete",function(){let $button;beforeEach(function(){$button=dlg.$el.find(".buttons .delete")});it("Cancels editor when clicked",function(){editor.set("canDelete",true);spyOn(editor,"deleteComment");$button.click();expect(editor.deleteComment).toHaveBeenCalled()});it("Closes dialog when clicked",function(){editor.set("canDelete",true);spyOn(editor,"deleteComment");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});describe("Enabled state",function(){it("Enabled when editor.canDelete=true",function(){editor.set("canDelete",true);expect($button.is(":disabled")).toBe(false)});it("Disabled when editor.canDelete=false",function(){editor.set("canDelete",false);expect($button.is(":disabled")).toBe(true)})});describe("Visibility",function(){it("Shown when canDelete=true",function(){editor.set("canDelete",true);expect($button.is(":visible")).toBe(true)});it("Hidden when caDelete=false",function(){editor.set("canDelete",false);expect($button.is(":visible")).toBe(false)})})});describe("Save",function(){let $button;beforeEach(function(){$button=dlg.$el.find(".buttons .save")});it("Cancels editor when clicked",function(){editor.set("canSave",true);spyOn(editor,"save");$button.click();expect(editor.save).toHaveBeenCalled()});it("Closes dialog when clicked",function(){editor.set("canSave",true);spyOn(editor,"save");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});describe("Enabled state",function(){it("Enabled when editor.canSave=true",function(){editor.set("canSave",true);expect($button.is(":disabled")).toBe(false)});it("Disabled when editor.canSave=false",function(){editor.set("canSave",false);expect($button.is(":disabled")).toBe(true)})});describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect($button.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect($button.is(":visible")).toBe(false)})})})});describe("Fields",function(){beforeEach(function(){dlg.open()});describe("Open an Issue checkbox",function(){describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect(dlg._$issueOptions.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect(dlg._$issueOptions.is(":visible")).toBe(false)})})});describe("Textbox",function(){describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect(dlg._textEditor.$el.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect(dlg._textEditor.$el.is(":visible")).toBe(false)})})})});describe("Height",function(){beforeEach(function(){editor=new RB.CommentEditor({comment:new RB.DiffComment,reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor})});it("When canEdit=true",function(){editor.set("canEdit",true);dlg.render();dlg.open();expect(dlg.$el.height()).toBe(RB.CommentDialogView.prototype.DIALOG_TOTAL_HEIGHT)});it("When canEdit=false",function(){editor.set("canEdit",false);dlg.render();dlg.open();expect(dlg.$el.height()).toBe(RB.CommentDialogView.prototype.DIALOG_NON_EDITABLE_HEIGHT)})});describe("Other published comments list",function(){let $commentsList;let $commentsPane;beforeEach(function(){$commentsPane=dlg.$el.find(".other-comments");$commentsList=$commentsPane.children("ul");expect($commentsList.length).toBe(1)});describe("Empty list",function(){it("Hidden pane",function(){expect($commentsPane.is(":visible")).toBe(false)})});describe("Populated list",function(){let comment;let commentReply;let parentCommentReplyLink;beforeEach(function(){comment=new RB.DiffComment;comment.user={name:"Test User"};comment.url="http://example.com/";comment.comment_id=1;comment.text="Sample comment.";comment.issue_opened=false;parentCommentReplyLink="/?reply_id="+comment.comment_id;commentReply=new RB.DiffComment;commentReply.user={name:"Test User"};commentReply.url="http://example.com/";commentReply.comment_id=2;commentReply.text="Sample comment.";commentReply.issue_opened=false;commentReply.reply_to_id=1});describe("Visible pane",function(){it("Setting list before opening dialog",function(){editor.set("publishedComments",[comment]);dlg.open();expect($commentsPane.is(":visible")).toBe(true)});it("Setting list after opening dialog",function(){dlg.open();editor.set("publishedComments",[comment]);expect($commentsPane.is(":visible")).toBe(true)})});it("List items added",function(){dlg.open();editor.set("publishedComments",[comment]);expect($commentsList.children().length).toBe(1)});it("Parent comment reply link links to itself",function(){editor.set("publishedComments",[comment]);dlg.open();const $replyLink=$commentsList.find(".comment-list-reply-action");expect($replyLink[0].href).toContain(parentCommentReplyLink)});it("Both parent and reply comment reply links link to parent comment",function(){editor.set("publishedComments",[comment,commentReply]);dlg.open();const $replyLinks=$commentsList.find(".comment-list-reply-action");expect($replyLinks.length).toEqual(2);expect($replyLinks[0].href).toContain(parentCommentReplyLink);expect($replyLinks[1].href).toContain(parentCommentReplyLink)})});describe("Issue bar buttons",function(){let comment;beforeEach(function(){comment=new RB.DiffComment;comment.user={name:"Test User"};comment.url="http://example.com/";comment.comment_id=1;comment.text="Sample comment.";comment.issue_opened=true;comment.issue_status="open"});it("When interactive",function(){reviewRequestEditor.set("editable",true);editor.set("publishedComments",[comment]);dlg=new RB.CommentDialogView({animate:false,model:editor,commentIssueManager:new RB.CommentIssueManager});dlg.render().$el.appendTo($testsScratch);dlg.open();const $buttons=dlg.$el.find(".other-comments .issue-button");expect($buttons.length).toBe(5);expect($buttons.is(":visible")).toBe(true)});it("When not interactive",function(){reviewRequestEditor.set("editable",false);editor.set("publishedComments",[comment]);dlg=new RB.CommentDialogView({animate:false,model:editor,commentIssueManager:new RB.CommentIssueManager});dlg.render().$el.appendTo($testsScratch);dlg.open();const $buttons=dlg.$el.find(".other-comments .issue-button");expect($buttons.length).toBe(0)})})});describe("Methods",function(){describe("close",function(){it("Editor state",function(){dlg.open();expect(editor.get("editing")).toBe(true);dlg.close();expect(editor.get("editing")).toBe(false)});it("Dialog removed",function(){dlg.open();spyOn(dlg,"trigger");dlg.close();expect(dlg.trigger).toHaveBeenCalledWith("closed");expect(dlg.$el.parents().length).toBe(0);expect($testsScratch.children().length).toBe(0)})});describe("open",function(){it("Editor state",function(){expect(editor.get("editing")).toBe(false);dlg.open();expect(editor.get("editing")).toBe(true)});it("Visibility",function(){expect(dlg.$el.is(":visible")).toBe(false);dlg.open();expect(dlg.$el.is(":visible")).toBe(true)});it("Default focus",function(){const $textarea=dlg.$el.find("textarea");expect($textarea.is(":focus")).toBe(false);spyOn($textarea[0],"focus");dlg.open();expect($textarea[0].focus).toHaveBeenCalled()})})});describe("Special keys",function(){let $textarea;function simulateKeyPress(c,altKey,ctrlKey,metaKey){$textarea.focus();["keydown","keypress","keyup"].forEach(type=>{const e=$.Event(type);e.which=c;e.altKey=altKey;e.ctrlKey=ctrlKey;e.metaKey=metaKey;$textarea.trigger(e)})}function setupForRichText(richText,canSave){editor.set("richText",richText);editor.set("canSave",!!canSave);$textarea=dlg.$("textarea")}beforeEach(function(){dlg.open();$textarea=dlg.$("textarea")});describe("Control-Enter to save",function(){beforeEach(function(){spyOn(editor,"save");spyOn(dlg,"close")});describe("With editor.canSave=true",function(){describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(10,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(10,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(13,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(13,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})})});describe("With editor.canSave=false",function(){beforeEach(function(){editor.set("canSave",false)});describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(10,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(10,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(13,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(13,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})})})});describe("Command-Enter to save",function(){beforeEach(function(){spyOn(editor,"save");spyOn(dlg,"close")});describe("With editor.canSave=true",function(){describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(10,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(10,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(13,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(13,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})})});describe("With editor.canSave=false",function(){beforeEach(function(){editor.set("canSave",false)});describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(10,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(10,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(13,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(13,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})})})});describe("Escape to cancel",function(){describe("Pressing escape in text area",function(){beforeEach(function(){spyOn(editor,"cancel");spyOn(dlg,"close")});it("If Markdown",function(){spyOn(window,"confirm").and.returnValue(true);setupForRichText(true);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).toHaveBeenCalled();expect(window.confirm).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If unsaved comment",function(){spyOn(window,"confirm").and.returnValue(true);editor.set("dirty",true);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).toHaveBeenCalled();expect(window.confirm).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If unsaved comment, do not close",function(){spyOn(window,"confirm").and.returnValue(false);editor.set("dirty",true);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).not.toHaveBeenCalled();expect(window.confirm).toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})})});describe("Toggle open issue",function(){let $checkbox;function runToggleIssueTest(richText,startState,keyCode){setupForRichText(richText);$checkbox.prop("checked",startState);editor.set("openIssue",startState);simulateKeyPress(keyCode.charCodeAt(0),true,false);expect($checkbox.prop("checked")).toBe(!startState);expect(editor.get("openIssue")).toBe(!startState);expect($textarea.val()).toBe("")}beforeEach(function(){$checkbox=dlg.$el.find("input[type=checkbox]")});describe("Alt-I",function(){describe("Checked to unchecked",function(){it("If Markdown",function(){runToggleIssueTest(true,true,"I")});it("If Markdown",function(){runToggleIssueTest(false,true,"I")})});describe("Unchecked to checked",function(){it("If Markdown",function(){runToggleIssueTest(true,false,"I")});it("If plain text",function(){runToggleIssueTest(false,false,"I")})})});describe("Alt-i",function(){describe("Checked to unchecked",function(){it("If Markdown",function(){runToggleIssueTest(true,true,"i")});it("If plain text",function(){runToggleIssueTest(false,true,"i")})});describe("Unchecked to checked",function(){it("If Markdown",function(){runToggleIssueTest(true,false,"i")});it("If plain text",function(){runToggleIssueTest(false,false,"i")})})})})});describe("Title text",function(){let $title;beforeEach(function(){dlg.open();$title=dlg.$el.find("form .title")});it("Default state",function(){expect($title.text()).toBe("Your comment")});it("Setting dirty=true",function(){editor.set("dirty",true);expect($title.text()).toBe("Your comment (unsaved)")});it("Setting dirty=false",function(){editor.set("dirty",true);editor.set("dirty",false);expect($title.text()).toBe("Your comment")})});describe("State synchronization",function(){describe("Comment text",function(){let $textarea;beforeEach(function(){dlg.open();$textarea=$(dlg._textEditor.$("textarea"))});describe("Dialog to editor",function(){const text="foo";beforeEach(function(done){$textarea.focus();for(let i=0;i<text.length;i++){const c=text.charCodeAt(i);let e=$.Event("keydown");e.which=c;$textarea.trigger(e);e=$.Event("keypress");e.which=c;$textarea.trigger(e);dlg._textEditor.setText(dlg._textEditor.getText()+text[i]);e=$.Event("keyup");e.which=c;$textarea.trigger(e)}const t=setInterval(()=>{if(dlg._textEditor.getText()===text){clearInterval(t);done()}},100)});it("",function(){expect(editor.get("text")).toEqual(text)})});it("Editor to dialog",function(){const text="bar";editor.set("text",text);expect(dlg._textEditor.getText()).toEqual(text)})});describe("Open Issue checkbox",function(){let $checkbox;beforeEach(function(){dlg.open();$checkbox=dlg.$("#comment_issue");$checkbox.prop("checked",false);editor.set("openIssue",false)});it("Dialog to editor",function(){$checkbox.click();expect(editor.get("openIssue")).toBe(true)});it("Editor to dialog",function(){editor.set("openIssue",true);expect($checkbox.prop("checked")).toBe(true)})});describe("Enable Markdown checkbox",function(){let $checkbox;beforeEach(function(){dlg.open();$checkbox=dlg.$("#enable_markdown");$checkbox.prop("checked",false);editor.set("richText",false);expect(dlg._textEditor.richText).toBe(false)});it("Dialog to editor",function(){$checkbox.click();expect(editor.get("richText")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Editor to dialog",function(){editor.set("richText",true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)})})});describe("User preference defaults",function(){describe("Open Issue checkbox",function(){it("When commentsOpenAnIssue is true",function(){RB.UserSession.instance.set("commentsOpenAnIssue",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();const $checkbox=dlg.$("#comment_issue");expect(editor.get("openIssue")).toBe(true);expect($checkbox.prop("checked")).toBe(true)});it("When commentsOpenAnIssue is false",function(){RB.UserSession.instance.set("commentsOpenAnIssue",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();const $checkbox=dlg.$("#comment_issue");expect(editor.get("openIssue")).toBe(false);expect($checkbox.prop("checked")).toBe(false)})});describe("Enable Markdown checkbox",function(){describe("When defaultUseRichText is true",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",true)});it("New comment",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();const $checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Existing comment with richText=true",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:true})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();const $checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Existing comment with richText=false",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:false})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();const $checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)})});describe("When defaultUseRichText is false",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",false)});it("New comment",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();const $checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(false);expect($checkbox.prop("checked")).toBe(false);expect(dlg._textEditor.richText).toBe(false)});it("Existing comment with richText=true",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:true})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();const $checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Existing comment with richText=false",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:false})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();const $checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(false);expect($checkbox.prop("checked")).toBe(false);expect(dlg._textEditor.richText).toBe(false)})})})});describe("Logged Out indicator",function(){it("When logged in",function(){RB.UserSession.instance.set("authenticated",true);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="login-text"]').length).toBe(0)});it("When logged out",function(){RB.UserSession.instance.set("authenticated",false);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="login-text"]').length).toBe(1)})});describe("In Draft indicator",function(){it("Shown when hasDraft=true",function(){reviewRequest.set("hasDraft",true);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="draft-warning"]').length).toBe(1)});it("Hidden when hasDraft=false",function(){reviewRequest.set("hasDraft",false);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="draft-warning"]').length).toBe(0)})})})});"use strict";suite("rb/views/CommentIssueBarView",function(){const CommentTypes=RB.CommentIssueManager.CommentTypes;let commentIssueManager;let view;let $dropButton;let $reopenButton;let $fixedButton;let $verifyFixedButton;let $verifyDroppedButton;beforeEach(function(){commentIssueManager=new RB.CommentIssueManager({reviewRequest:new RB.ReviewRequest});view=new RB.CommentIssueBarView({commentIssueManager:commentIssueManager,issueStatus:"open",reviewID:1,commentID:2,commentType:CommentTypes.DIFF,interactive:true,canVerify:true});view.render().$el.appendTo($testsScratch);$dropButton=view._$buttons.filter(".drop");$reopenButton=view._$buttons.filter(".reopen");$fixedButton=view._$buttons.filter(".resolve");$verifyFixedButton=view._$buttons.filter(".verify-resolved");$verifyDroppedButton=view._$buttons.filter(".verify-dropped")});describe("Actions",function(){let comment;beforeEach(function(){spyOn(commentIssueManager,"setCommentState");expect(view._$buttons.prop("disabled")).toBe(false);comment=commentIssueManager.getComment(1,2,CommentTypes.DIFF);spyOn(comment,"ready").and.callFake(options=>{if(_.isFunction(options.ready)){options.ready.call(comment)}});spyOn(comment,"getAuthorUsername").and.returnValue("doc")});it("Resolving as fixed",function(){$fixedButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff_comments","resolved")});it("Dropping",function(){$dropButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff_comments","dropped")});it("Re-opening",function(){view._showStatus(RB.BaseComment.STATE_RESOLVED);$reopenButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff_comments","open")});it("Resolving with verification",function(){comment.get("extraData").require_verification=true;$fixedButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff_comments","verifying-resolved")});it("Dropping with verification",function(){comment.get("extraData").require_verification=true;$dropButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff_comments","verifying-dropped")})});describe("Event handling",function(){describe("CommentIssueManager.issueStatusUpdated",function(){const COMMENT_ID=2;const COMMENT_STATUS="open";function _buildTests(commentType,CommentCls,rspNamespace,OtherCommentCls,otherRspNamespace){beforeEach(function(){view=new RB.CommentIssueBarView({commentIssueManager:commentIssueManager,issueStatus:COMMENT_STATUS,reviewID:1,commentID:COMMENT_ID,commentType:commentType,interactive:true,canVerify:true});view.render().$el.appendTo($testsScratch);spyOn(view,"_showStatus")});it("When comment updated",function(){const comment=new CommentCls({id:COMMENT_ID,issueStatus:"resolved"});const rsp={};rsp[rspNamespace]={timestamp:"2022-07-05T01:02:03"};commentIssueManager._notifyIssueStatusChanged(comment,rsp,COMMENT_STATUS);expect(view._showStatus).toHaveBeenCalledWith("resolved")});describe("When different comment updated",function(){it("With same ID, different type",function(){const comment=new OtherCommentCls({id:COMMENT_ID,issueStatus:"resolved"});const rsp={};rsp[otherRspNamespace]={timestamp:"2022-07-05T01:02:03"};commentIssueManager._notifyIssueStatusChanged(comment,rsp,COMMENT_STATUS);expect(view._showStatus).not.toHaveBeenCalled()});it("With different ID, same type",function(){const comment=new CommentCls({id:COMMENT_ID+1,issueStatus:"resolved"});const rsp={};rsp[rspNamespace]={timestamp:"2022-07-05T01:02:03"};commentIssueManager._notifyIssueStatusChanged(comment,rsp,COMMENT_STATUS);expect(view._showStatus).not.toHaveBeenCalled()})})}describe("For diff comments",function(){_buildTests(CommentTypes.DIFF,RB.DiffComment,"diff_comment",RB.GeneralComment,"general_comment")});describe("For general comments",function(){_buildTests(CommentTypes.GENERAL,RB.GeneralComment,"general_comment",RB.DiffComment,"diff_comment")});describe("For file attachment comments",function(){_buildTests(CommentTypes.FILE_ATTACHMENT,RB.FileAttachmentComment,"file_attachment_comment",RB.DiffComment,"diff_comment")});describe("For screenshot comments",function(){_buildTests(CommentTypes.SCREENSHOT,RB.ScreenshotComment,"screenshot_comment",RB.GeneralComment,"general_comment")})})});describe("Issue states",function(){describe("Open",function(){beforeEach(function(){view._showStatus(RB.BaseComment.STATE_OPEN)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(true);expect(view._$state.hasClass("resolved")).toBe(false);expect(view._$state.hasClass("dropped")).toBe(false);expect(view._$state.hasClass("verifying-resolved")).toBe(false);expect(view._$state.hasClass("verifying-dropped")).toBe(false)});it("Text",function(){expect(view._$message.text()).toBe("An issue was opened.")});describe("Button visibility",function(){it('"Drop" shown',function(){expect($dropButton.is(":visible")).toBe(true)});it('"Fixed" shown',function(){expect($fixedButton.is(":visible")).toBe(true)});it('"Re-open" hidden',function(){expect($reopenButton.is(":visible")).toBe(false)});it('"Verify Fixed" hidden',function(){expect($verifyFixedButton.is(":visible")).toBe(false)});it('"Verify Dropped" hidden',function(){expect($verifyDroppedButton.is(":visible")).toBe(false)})})});describe("Fixed",function(){beforeEach(function(){view._showStatus(RB.BaseComment.STATE_RESOLVED)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(false);expect(view._$state.hasClass("resolved")).toBe(true);expect(view._$state.hasClass("dropped")).toBe(false);expect(view._$state.hasClass("verifying-resolved")).toBe(false);expect(view._$state.hasClass("verifying-dropped")).toBe(false)});it("Text",function(){expect(view._$message.text()).toBe("The issue has been resolved.")});describe("Button visibility",function(){it('"Drop" hidden',function(){expect($dropButton.is(":visible")).toBe(false)});it('"Fixed" hidden',function(){expect($fixedButton.is(":visible")).toBe(false)});it('"Re-open" shown',function(){expect($reopenButton.is(":visible")).toBe(true)});it('"Verify Fixed" hidden',function(){expect($verifyFixedButton.is(":visible")).toBe(false)});it('"Verify Dropped" hidden',function(){expect($verifyDroppedButton.is(":visible")).toBe(false)})})});describe("Dropped",function(){beforeEach(function(){view._showStatus(RB.BaseComment.STATE_DROPPED)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(false);expect(view._$state.hasClass("resolved")).toBe(false);expect(view._$state.hasClass("dropped")).toBe(true);expect(view._$state.hasClass("verifying-resolved")).toBe(false);expect(view._$state.hasClass("verifying-dropped")).toBe(false)});it("Text",function(){expect(view._$message.text()).toBe("The issue has been dropped.")});describe("Button visibility",function(){it('"Drop" hidden',function(){expect($dropButton.is(":visible")).toBe(false)});it('"Fixed" hidden',function(){expect($fixedButton.is(":visible")).toBe(false)});it('"Re-open" shown',function(){expect($reopenButton.is(":visible")).toBe(true)});it('"Verify Fixed" hidden',function(){expect($verifyFixedButton.is(":visible")).toBe(false)});it('"Verify Dropped" hidden',function(){expect($verifyDroppedButton.is(":visible")).toBe(false)})})});describe("Verifying Fixed",function(){beforeEach(function(){view._showStatus(RB.BaseComment.STATE_VERIFYING_RESOLVED)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(false);expect(view._$state.hasClass("resolved")).toBe(false);expect(view._$state.hasClass("dropped")).toBe(false);expect(view._$state.hasClass("verifying-resolved")).toBe(true);expect(view._$state.hasClass("verifying-dropped")).toBe(false)});it("Text",function(){expect(view._$message.text()).toBe("Waiting for verification before resolving...")});describe("Button visibility",function(){it('"Drop" hidden',function(){expect($dropButton.is(":visible")).toBe(false)});it('"Fixed" hidden',function(){expect($fixedButton.is(":visible")).toBe(false)});it('"Re-open" shown',function(){expect($reopenButton.is(":visible")).toBe(true)});it('"Verify Fixed" shown',function(){expect($verifyFixedButton.is(":visible")).toBe(true)});it('"Verify Dropped" hidden',function(){expect($verifyDroppedButton.is(":visible")).toBe(false)})})});describe("Verifying Dropped",function(){beforeEach(function(){view._showStatus(RB.BaseComment.STATE_VERIFYING_DROPPED)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(false);expect(view._$state.hasClass("resolved")).toBe(false);expect(view._$state.hasClass("dropped")).toBe(false);expect(view._$state.hasClass("verifying-resolved")).toBe(false);expect(view._$state.hasClass("verifying-dropped")).toBe(true)});it("Text",function(){expect(view._$message.text()).toBe("Waiting for verification before dropping...")});describe("Button visibility",function(){it('"Drop" hidden',function(){expect($dropButton.is(":visible")).toBe(false)});it('"Fixed" hidden',function(){expect($fixedButton.is(":visible")).toBe(false)});it('"Re-open" shown',function(){expect($reopenButton.is(":visible")).toBe(true)});it('"Verify Fixed" hidden',function(){expect($verifyFixedButton.is(":visible")).toBe(false)});it('"Verify Dropped" shown',function(){expect($verifyDroppedButton.is(":visible")).toBe(true)})})})})});"use strict";suite("rb/views/DiffFragmentQueueView",function(){const URL_PREFIX="/r/123/_fragments/diff-comments/";let fragmentQueue;beforeEach(function(){fragmentQueue=new RB.DiffFragmentQueueView({containerPrefix:"container1",reviewRequestPath:"/r/123/",queueName:"diff_fragments"})});describe("Diff fragment loading",function(){let $container1;let $container2;let $container3;let $container4;beforeEach(function(){$container1=$('<div id="container1_123"/>').appendTo(window.$testsScratch);$container2=$('<div id="container1_124"/>').appendTo(window.$testsScratch);$container3=$('<div id="container1_125"/>').appendTo(window.$testsScratch);$container4=$('<div id="container1_126"/>').appendTo(window.$testsScratch);fragmentQueue.queueLoad("123","key1");fragmentQueue.queueLoad("124","key1");fragmentQueue.queueLoad("125","key1");fragmentQueue.queueLoad("126","key2")});it("Fragment queueing",function(){const queue=fragmentQueue._queue;expect(queue.length).not.toBe(0);expect(queue.key1.length).toBe(3);expect(queue.key1).toContain({commentID:"123",onFragmentRendered:null});expect(queue.key1).toContain({commentID:"124",onFragmentRendered:null});expect(queue.key1).toContain({commentID:"125",onFragmentRendered:null});expect(queue.key2.length).toBe(1);expect(queue.key2).toContain({commentID:"126",onFragmentRendered:null})});it("Batch loading",function(done){spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");const url=options.url;let blob;if(url===`${URL_PREFIX}123,124,125/`){const html1=new Blob(["<span>Comment one</span>"]);const html2=new Blob(["<span>Comment two</span>"]);const html3=new Blob(["<span>Comment three</span>"]);blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[123,html1.size]}],html1,[{type:"uint32",values:[124,html2.size]}],html2,[{type:"uint32",values:[125,html3.size]}],html3])}else if(url===`${URL_PREFIX}126/`){const html=new Blob(["<span>Comment 4</span>"]);blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[126,html.size]}],html])}else{fail(`Unexpected URL ${url}`);return}RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});fragmentQueue.loadFragments(()=>{expect($.ajax.calls.count()).toBe(2);expect($container1.data("diff-fragment-view")).toBeTruthy();expect($container1.html()).toBe("<span>Comment one</span>");expect($container2.data("diff-fragment-view")).toBeTruthy();expect($container2.html()).toBe("<span>Comment two</span>");expect($container3.data("diff-fragment-view")).toBeTruthy();expect($container3.html()).toBe("<span>Comment three</span>");expect($container4.data("diff-fragment-view")).toBeTruthy();expect($container4.html()).toBe("<span>Comment 4</span>");done()})});it("With Unicode content",function(done){spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");const url=options.url;let arrayBuffer;if(url===`${URL_PREFIX}123,124,125/`){const html1=[60,115,112,97,110,62,195,161,195,169,195,173,195,179,195,186,32,240,159,148,165,60,47,115,112,97,110,62];const html2=[60,115,112,97,110,62,195,132,195,139,195,143,195,150,195,156,197,184,32,240,159,152,177,60,47,115,112,97,110,62];const html3=[60,115,112,97,110,62,240,159,148,165,240,159,152,177,60,47,115,112,97,110,62];expect(html1.length).toBe(28);expect(html2.length).toBe(30);expect(html3.length).toBe(21);arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:[123,html1.length]},{type:"uint8",values:html1},{type:"uint32",values:[124,html2.length]},{type:"uint8",values:html2},{type:"uint32",values:[125,html3.length]},{type:"uint8",values:html3}])}else if(url===`${URL_PREFIX}126/`){const html=[60,115,112,97,110,62,196,128,196,146,196,170,197,140,32,240,159,145,191,60,47,115,112,97,110,62];expect(html.length).toBe(26);arrayBuffer=RB.DataUtils.buildArrayBuffer([{type:"uint32",values:[126,html.length]},{type:"uint8",values:html}])}else{fail(`Unexpected URL ${url}`);return}options.success(arrayBuffer)});fragmentQueue.loadFragments(()=>{expect($.ajax.calls.count()).toBe(2);expect($container1.data("diff-fragment-view")).toBeTruthy();expect($container1.html()).toBe("<span>áéíóú 🔥</span>");expect($container2.data("diff-fragment-view")).toBeTruthy();expect($container2.html()).toBe("<span>ÄËÏÖÜŸ 😱</span>");expect($container3.data("diff-fragment-view")).toBeTruthy();expect($container3.html()).toBe("<span>🔥😱</span>");expect($container4.data("diff-fragment-view")).toBeTruthy();expect($container4.html()).toBe("<span>ĀĒĪŌ 👿</span>");done()})});it("With saved fragments",function(done){spyOn($,"ajax").and.callFake(function(options){expect(options.dataType).toBe("arraybuffer");const url=options.url;let blob;if(url===`${URL_PREFIX}124/`){const html=new Blob(["<span>New comment 2</span>"]);blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[124,html.size]}],html])}else if(url===`${URL_PREFIX}126/`){const html=new Blob(["<span>New comment 4</span>"]);blob=RB.DataUtils.buildBlob([[{type:"uint32",values:[126,html.size]}],html])}else{fail(`Unexpected URL ${url}`);return}RB.DataUtils.readBlobAsArrayBuffer(blob,options.success)});const view1=new RB.DiffFragmentView;$container1.html("<span>Comment 1</span>").data("diff-fragment-view",view1);const view2=new RB.DiffFragmentView;$container2.html("<span>Comment 2</span>").data("diff-fragment-view",view2);const view3=new RB.DiffFragmentView;$container3.html("<span>Comment 3</span>").data("diff-fragment-view",view3);fragmentQueue.saveFragment("123");fragmentQueue.saveFragment("125");fragmentQueue.saveFragment("126");$container3.removeData("diff-fragment-view");fragmentQueue.loadFragments(()=>{expect($.ajax.calls.count()).toBe(2);expect($container1.data("diff-fragment-view")).toBe(view1);expect($container1.html()).toBe("<span>Comment 1</span>");expect($container2.data("diff-fragment-view")).toBe(view2);expect($container2.html()).toBe("<span>New comment 2</span>");expect($container3.data("diff-fragment-view")).toBeTruthy();expect($container3.data("diff-fragment-view")).not.toBe(view3);expect($container3.html()).toBe("<span>Comment 3</span>");expect($container4.data("diff-fragment-view")).toBeTruthy();expect($container4.html()).toBe("<span>New comment 4</span>");expect(fragmentQueue._saved).toEqual({});done()})})})});"use strict";suite("rb/views/DiffFragmentView",function(){const fragmentTemplate=_.template(`<table>
 <thead>
 </thead>
 <tbody class="diff-header diff-header-above">
  <tr>
   <td>
    <div>
     <a href="#" class="diff-expand-btn"
        data-lines-of-context="20,0"></a>
    </div>
   </td>
  </tr>
 </tbody>
 <tbody class="insert"></tbody>
 <tbody class="insert">
  <tr>
   <td>
    <div class="diff-collapse-btn" data-lines-of-context="0,0"></div>
   </td>
  </tr>
 </tbody>
 <tbody class="diff-header diff-header-below">
  <tr>
   <td>
    <div>
     <a href="#" class="diff-expand-btn"
        data-lines-of-context="0,20"></a>
    </div>
   </td>
  </tr>
 </tbody>
</table>`);let view;let loadDiff;beforeEach(function(){loadDiff=jasmine.createSpy("loadDiff");view=new RB.DiffFragmentView({loadDiff:loadDiff,collapsible:true});view.$el.html(fragmentTemplate());$testsScratch.append(view.$el);spyOn(_,"defer").and.callFake(cb=>cb());spyOn(_,"delay").and.callFake(cb=>cb())});describe("render",function(){it("With visible and collapsible === true",function(){view.render();expect(view.$el.hasClass("allow-transitions")).toBe(true);expect(view._$table.hasClass("expanded")).toBe(false);expect(view._$table.hasClass("collapsed")).toBe(true);expect(view._$thead.css("transform")).not.toBe("none");_.each(view._$diffHeaders,headerEl=>{expect($(headerEl).css("transform")).not.toBe("none")})});it("With hidden and collapsible === true",function(){view.$el.hide();view.render();expect(view.$el.hasClass("allow-transitions")).toBe(true);expect(view._$table.hasClass("expanded")).toBe(true);expect(view._$table.hasClass("collapsed")).toBe(false);expect(view._$thead.css("transform")).toBe("none");_.each(view._$diffHeaders,headerEl=>{expect($(headerEl).css("transform")).toBe("none")})});it("With collapsible === false",function(){view._collapsible=false;view.render();expect(view.$el.hasClass("allow-transitions")).toBe(false);expect(view._$table.hasClass("expanded")).toBe(true);expect(view._$table.hasClass("collapsed")).toBe(false);expect(view._$thead.css("transform")).toBe("none");_.each(view._$diffHeaders,headerEl=>{expect($(headerEl).css("transform")).toBe("none")})})});describe("Events",function(){it("click expansion button",function(){view.render();view.$(".diff-expand-btn").eq(0).click();expect(loadDiff).toHaveBeenCalled();expect(loadDiff.calls.mostRecent().args[0].linesOfContext).toBe("20,0")});it("click collapse button",function(){view.render();view.$(".diff-collapse-btn").eq(0).click();expect(loadDiff).toHaveBeenCalled();expect(loadDiff.calls.mostRecent().args[0].linesOfContext).toBe("0,0")});describe("mouseenter",function(){it("With collapsible === true",function(){view.render();spyOn(view.$el,"is").and.callFake(sel=>{expect(sel).toBe(":hover");return true});view.$el.trigger("mouseenter");expect(view._$table.hasClass("collapsed")).toBe(false);expect(view._$table.hasClass("expanded")).toBe(true);expect(view._$thead.css("transform")).toBe("none");_.each(view._$diffHeaders,headerEl=>{expect($(headerEl).css("transform")).toBe("none")})});it("With collapsible === false",function(){view._collapsible=false;view.render();spyOn(view.$el,"is").and.callFake(sel=>{expect(sel).toBe(":hover");return true});view.$el.trigger("mouseenter");expect(view._$table.hasClass("collapsed")).toBe(false);expect(view._$table.hasClass("expanded")).toBe(true);expect(view._$thead.css("transform")).toBe("none");_.each(view._$diffHeaders,headerEl=>{expect($(headerEl).css("transform")).toBe("none")})})});describe("mouseleave",function(){it("With collapsible === true",function(){let isHovering=true;view.render();spyOn(view.$el,"is").and.callFake(sel=>{expect(sel).toBe(":hover");return isHovering});view.$el.trigger("mouseenter");isHovering=false;view.$el.trigger("mouseleave");expect(view._$table.hasClass("collapsed")).toBe(true);expect(view._$table.hasClass("expanded")).toBe(false);expect(view._$thead.css("transform")).not.toBe("none");_.each(view._$diffHeaders,headerEl=>{expect($(headerEl).css("transform")).not.toBe("none")})});it("With collapsible === false",function(){let isHovering=true;view._collapsible=false;view.render();spyOn(view.$el,"is").and.callFake(sel=>{expect(sel).toBe(":hover");return isHovering});view.$el.trigger("mouseenter");isHovering=false;view.$el.trigger("mouseleave");expect(view._$table.hasClass("collapsed")).toBe(false);expect(view._$table.hasClass("expanded")).toBe(true);expect(view._$thead.css("transform")).toBe("none");_.each(view._$diffHeaders,headerEl=>{expect($(headerEl).css("transform")).toBe("none")})})})})});"use strict";suite("rb/views/DraftReviewBannerView",function(){const template=`<div id="review-banner" hidden class="hidden">
 <div class="banner">
  <h1>You have a pending review.</h1>
  <input id="review-banner-edit" type="button"
         value="Edit Review" />
  <input id="review-banner-publish-container" type="button"
         value="Publish" />
  <input id="review-banner-discard" type="button"
         value="Discard" />
 </div>
</div>'`;let model;let view;beforeEach(function(){model=new RB.DraftReview;view=new RB.DraftReviewBannerView({el:$(template).appendTo($testsScratch),model:model});view.render()});afterEach(function(){view.remove()});describe("Button states",function(){let $buttons;beforeEach(function(){$buttons=view.$("input")});describe("Enabled",function(){it("Default",function(){expect($buttons.prop("disabled")).toBe(false)});it("When saved",function(){$buttons.prop("disabled",true);model.trigger("saved");expect($buttons.prop("disabled")).toBe(false)});it("When destroyed",function(){$buttons.prop("disabled",true);model.trigger("destroyed");expect($buttons.prop("disabled")).toBe(false)})});describe("Disabled",function(){it("When saving",function(){model.trigger("saving");expect($buttons.prop("disabled")).toBe(true)});it("When destroying",function(){model.trigger("destroying");expect($buttons.prop("disabled")).toBe(true)})})});describe("Button events",function(){it("Edit Review",function(){spyOn(RB.ReviewDialogView,"create");view.$("#review-banner-edit").click();expect(RB.ReviewDialogView.create).toHaveBeenCalled();expect(RB.ReviewDialogView.create.calls.argsFor(0)[0].review).toBe(model)});it("Publish",function(){spyOn(model,"publish");view.$("#review-banner-publish").click();expect(model.publish).toHaveBeenCalled()});it("Publish to Submitter Only",function(){spyOn(model,"publish");$("#review-banner-publish-submitter-only").click();expect(model.publish).toHaveBeenCalled()});it("Publish and Archive",function(){spyOn(model,"publish");spyOn(view,"_onPublishClicked").and.callThrough();$("#review-banner-publish-and-archive").click();expect(model.publish).toHaveBeenCalled();expect(view._onPublishClicked).toHaveBeenCalledWith({publishAndArchive:true})});it("Discard",function(){let $buttons=$();spyOn(model,"destroy");spyOn($.fn,"modalBox").and.callFake(options=>{options.buttons.forEach($btn=>{$buttons=$buttons.add($btn)});return{modalBox:cmd=>{expect(cmd).toBe("buttons");return $buttons}}});view.$("#review-banner-discard").click();expect($.fn.modalBox).toHaveBeenCalled();$buttons.filter('input[value="Discard"]').click();expect(model.destroy).toHaveBeenCalled()})});describe("Methods",function(){it("show",function(){expect(view.$el.hasClass("hidden")).toBe(true);expect(view.$el.prop("hidden")).toBe(true);view.show();expect(view.$el.hasClass("hidden")).toBe(false);expect(view.$el.prop("hidden")).toBe(false)});it("hide",function(){view.$el.addClass("hidden").prop("hidden",true);view.hide();expect(view.$el.hasClass("hidden")).toBe(true);expect(view.$el.prop("hidden")).toBe(true)})})});"use strict";suite("rb/views/FileAttachmentThumbnail",function(){let reviewRequest;let model;let view;beforeEach(function(){reviewRequest=new RB.ReviewRequest;model=new RB.FileAttachment({downloadURL:"http://example.com/file.png",filename:"file.png"});spyOn(model,"trigger").and.callThrough()});describe("Rendering",function(){function expectElements(){expect(view.$("a.edit").length).toBe(1);expect(view.$(".file-caption").length).toBe(1);expect(view.$(".file-actions").length).toBe(1);expect(view.$(".file-delete").length).toBe(view.options.canEdit&&model.get("loaded")?1:0);expect(view.$(".file-update").length).toBe(view.options.canEdit&&model.get("loaded")?1:0)}function expectAttributeMatches(){expect(view.$(".file-download").attr("href")).toBe(model.get("downloadURL"));expect(view.$(".file-caption .edit").text()).toBe(model.get("caption"))}it("Using existing elements",function(){const $el=$("<div/>").addClass(RB.FileAttachmentThumbnail.prototype.className).html(RB.FileAttachmentThumbnail.prototype.template(_.defaults({caption:"No caption",captionClass:"edit empty-caption"},model.attributes)));model.set("loaded",true);view=new RB.FileAttachmentThumbnail({renderThumbnail:true,reviewRequest:reviewRequest,el:$el,model:model});$testsScratch.append(view.$el);view.render();expectElements();expect(view.$(".file-actions").is(":visible")).toBe(true);expect(view.$(".fa-spinner").length).toBe(0)});it("Rendered thumbnail with unloaded model",function(){view=new RB.FileAttachmentThumbnail({reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();expectElements();expect(view.$(".file-actions").children().length).toBe(0);expect(view.$(".fa-spinner").length).toBe(1)});describe("Rendered thumbnail with loaded model",function(){beforeEach(function(){model.id=123;model.attributes.id=123;model.set("caption","My Caption");model.set("loaded",true);model.url="/api/file-attachments/123/"});it("With review UI",function(){model.set("reviewURL","/review/");view=new RB.FileAttachmentThumbnail({reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();expectElements();expectAttributeMatches();expect(view.$(".file-actions").children().length).toBe(2);expect(view.$(".fa-spinner").length).toBe(0);expect(view.$(".file-review").length).toBe(1);expect(view.$(".file-add-comment").length).toBe(0)});it("No review UI",function(){view=new RB.FileAttachmentThumbnail({reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();expectElements();expectAttributeMatches();expect(view.$(".file-actions").children().length).toBe(2);expect(view.$(".fa-spinner").length).toBe(0);expect(view.$(".file-review").length).toBe(0);expect(view.$(".file-add-comment").length).toBe(1)})})});describe("Actions",function(){beforeEach(function(){model.id=123;model.attributes.id=123;model.set("loaded",true);model.url="/api/file-attachments/123/";view=new RB.FileAttachmentThumbnail({canEdit:true,reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();spyOn(view,"trigger").and.callThrough()});it("Begin caption editing",function(){view._captionEditorView.startEdit();expect(view.trigger).toHaveBeenCalledWith("beginEdit")});it("Cancel caption editing",function(){view._captionEditorView.startEdit();expect(view.trigger).toHaveBeenCalledWith("beginEdit");view._captionEditorView.cancel();expect(view.trigger).toHaveBeenCalledWith("endEdit")});it("Save caption",function(){spyOn(model,"save");view._captionEditorView.startEdit();expect(view.trigger).toHaveBeenCalledWith("beginEdit");view.$("input").val("Foo").triggerHandler("keyup");view._captionEditorView.submit();expect(view.trigger).toHaveBeenCalledWith("endEdit");expect(model.get("caption")).toBe("Foo");expect(model.save).toHaveBeenCalled()});it("Delete",function(){spyOn(model,"destroy").and.callThrough();spyOn($,"ajax").and.callFake(options=>options.success());spyOn(view.$el,"fadeOut").and.callFake(done=>done());spyOn(view,"remove");view.$(".file-delete").click();expect($.ajax).toHaveBeenCalled();expect(model.destroy).toHaveBeenCalled();expect(model.trigger.calls.argsFor(2)[0]).toBe("destroying");expect(view.$el.fadeOut).toHaveBeenCalled();expect(view.remove).toHaveBeenCalled()})})});"use strict";suite("rb/views/ReviewDialogView",function(){const baseEmptyCommentListPayload={stat:"ok",total_results:0,links:{}};const emptyDiffCommentsPayload=_.defaults({diff_comments:[]},baseEmptyCommentListPayload);const emptyFileAttachmentCommentsPayload=_.defaults({file_attachment_comments:[]},baseEmptyCommentListPayload);const emptyGeneralCommentsPayload=_.defaults({general_comments:[]},baseEmptyCommentListPayload);const emptyScreenshotCommentsPayload=_.defaults({screenshot_comments:[]},baseEmptyCommentListPayload);const baseCommentPayload={id:1,issue_opened:true,issue_status:"opened",text:"My comment"};const diffCommentPayload=_.defaults({first_line:10,num_lines:5,filediff:{id:1,source_file:"my-file",dest_file:"my-file",source_revision:"1"},interfilediff:{id:2,source_file:"my-file",dest_file:"my-file",source_revision:"2"}},baseCommentPayload);const fileAttachmentCommentPayload=_.defaults({extra_data:{},link_text:"my-link-text",thumbnail_html:"<blink>Boo</blink>",review_url:"/review-ui/",file_attachment:{id:10,filename:"file.txt",icon_url:"data:image/gif;base64,"}},baseCommentPayload);const generalCommentPayload=baseCommentPayload;const screenshotCommentPayload=_.defaults({x:10,y:20,w:30,h:40,thumbnail_url:"data:image/gif;base64,",screenshot:{id:10,caption:"My caption",filename:"image.png",review_url:"/review-ui/"}},baseCommentPayload);const origGeneralCommentsEnabled=RB.EnabledFeatures.generalComments;let reviewRequestEditor;let review;let dlg;function createReviewDialog(){return RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor})}beforeEach(function(){const origMove=$.fn.move;const reviewRequest=new RB.ReviewRequest({summary:"My Review Request"});RB.DnDUploader.create();reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest});review=new RB.Review({parentObject:reviewRequest});spyOn(review,"ready").and.callFake((options,context)=>options.ready.call(context));spyOn($.fn,"move").and.callFake(function(x,y,pos){if(pos==="fixed"){pos="absolute"}return origMove.call(this,x,y,pos)});spyOn(RB.DiffFragmentQueueView.prototype,"queueLoad");spyOn(RB.DiffFragmentQueueView.prototype,"loadFragments");RB.EnabledFeatures.generalComments=true});afterEach(function(){RB.DnDUploader.instance=null;RB.ReviewDialogView._instance=null;RB.EnabledFeatures.generalComments=origGeneralCommentsEnabled});describe("Class methods",function(){describe("create",function(){it("Without a review",function(){expect(()=>RB.ReviewDialogView.create({container:$testsScratch,reviewRequestEditor:reviewRequestEditor})).toThrow();expect(RB.ReviewDialogView._instance).toBeFalsy();expect($testsScratch.children().length).toBe(0)});it("With a review",function(){dlg=createReviewDialog();expect(dlg).toBeTruthy();expect(RB.ReviewDialogView._instance).toBe(dlg);expect($testsScratch.children().length).toBe(2)});it("With existing instance",function(){dlg=createReviewDialog();expect(createReviewDialog).toThrow();expect(RB.ReviewDialogView._instance).toBe(dlg);expect($testsScratch.children().length).toBe(2)})})});describe("Instances",function(){describe("Methods",function(){it("close",function(){dlg=createReviewDialog();expect($testsScratch.children().length).toBe(2);dlg.close();expect($testsScratch.children().length).toBe(0);expect(RB.ReviewDialogView._instance).toBe(null)})});describe("Loading",function(){it("With new review",function(){expect(review.isNew()).toBe(true);dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg._bodyTopView.$editor.text()).toBe("");expect(dlg._bodyBottomView.$editor.text()).toBe("");expect(dlg._bodyBottomView.$el.is(":visible")).toBe(false);expect(dlg._$shipIt.prop("checked")).toBe(false);expect(dlg._$spinner).toBe(null)});describe("With body and top text",function(){const bodyTopText="My body top";const bodyBottomText="My body bottom";beforeEach(function(){review.set({bodyTop:bodyTopText,bodyBottom:bodyBottomText,loaded:true})});it("Clearing body bottom hides footer",function(){dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg._bodyBottomView.$editor.text()).toBe(bodyBottomText);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);review.set("bodyBottom","");expect(dlg._bodyBottomView.$el.is(":visible")).toBe(false)})});describe("With existing review",function(){const bodyTopText="My body top";const bodyBottomText="My body bottom";const shipIt=true;let fileAttachmentCommentsPayload;let generalCommentsPayload;let diffCommentsPayload;let screenshotCommentsPayload;let commentView;let ajaxData;beforeEach(function(){review.set({bodyTop:bodyTopText,bodyBottom:bodyBottomText,shipIt:shipIt,loaded:true,id:42,links:{diff_comments:{href:"/diff-comments/"},file_attachment_comments:{href:"/file-attachment-comments/"},general_comments:{href:"/general-comments/"},screenshot_comments:{href:"/screenshot-comments/"}}});diffCommentsPayload=_.clone(emptyDiffCommentsPayload);screenshotCommentsPayload=_.clone(emptyScreenshotCommentsPayload);fileAttachmentCommentsPayload=_.clone(emptyFileAttachmentCommentsPayload);generalCommentsPayload=_.clone(emptyGeneralCommentsPayload);spyOn($,"ajax").and.callFake(options=>{if(options.type==="DELETE"){options.success({})}else if(options.url==="/file-attachment-comments/"){options.success(fileAttachmentCommentsPayload)}else if(options.url==="/diff-comments/"){options.success(diffCommentsPayload)}else if(options.url==="/screenshot-comments/"){options.success(screenshotCommentsPayload)}else if(options.url==="/general-comments/"){options.success(generalCommentsPayload)}})});describe("Review properties",function(){function testLoadReview(){dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg._bodyTopView.$editor.text()).toBe(bodyTopText);expect(dlg._bodyBottomView.$editor.text()).toBe(bodyBottomText);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$shipIt.prop("checked")).toBe(shipIt);expect(dlg.$(".review-comments .draft").length).toBe(2);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadReview();expect(review.ready.calls.argsFor(0)[0].data).toEqual({"force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadReview();expect(review.ready.calls.argsFor(0)[0].data).toEqual({"force-text-type":"html","include-text-types":"raw"})})});describe("General comments",function(){it("Disabled",function(){RB.EnabledFeatures.generalComments=false;dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});const $button=dlg._$buttons.find('input[value="Add General Comment"]');expect($button.length).toBe(0);expect($.ajax).toHaveBeenCalled();expect($.ajax.calls.argsFor(0)[0].url).not.toBe("/general-comments/");expect(dlg._commentViews.length).toBe(0)});describe("Enabled",function(){function testLoadGeneralComments(){generalCommentsPayload.total_results=1;generalCommentsPayload.general_comments=[generalCommentPayload];dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});const $button=dlg._$buttons.find('input[value="Add General Comment"]');expect($button.length).toBe(1);expect($.ajax).toHaveBeenCalled();expect($.ajax.calls.argsFor(0)[0].url).toBe("/general-comments/");ajaxData=$.ajax.calls.argsFor(0)[0].data;expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];expect(commentView.$editor.text()).toBe(generalCommentPayload.text);expect(commentView.$issueOpened.prop("checked")).toBe(generalCommentPayload.issue_opened);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadGeneralComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,"force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadGeneralComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,"force-text-type":"html","include-text-types":"raw"})});it("Deleting comment",function(){spyOn(window,"confirm").and.returnValue(true);testLoadGeneralComments();expect(dlg._generalCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._generalCommentsCollection.length).toBe(0)});it("Deleting comment and cancelling",function(){spyOn(window,"confirm").and.returnValue(false);testLoadGeneralComments();expect(dlg._generalCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._generalCommentsCollection.length).toBe(1)})})});describe("Diff comments",function(){function testLoadDiffComments(){const diffQueueProto=RB.DiffFragmentQueueView.prototype;diffCommentsPayload.total_results=1;diffCommentsPayload.diff_comments=[diffCommentPayload];dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect($.ajax).toHaveBeenCalled();expect($.ajax.calls.argsFor(3)[0].url).toBe("/diff-comments/");ajaxData=$.ajax.calls.argsFor(3)[0].data;expect(diffQueueProto.queueLoad.calls.count()).toBe(1);expect(diffQueueProto.loadFragments).toHaveBeenCalled();expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];expect(commentView.$editor.text()).toBe(diffCommentPayload.text);expect(commentView.$issueOpened.prop("checked")).toBe(diffCommentPayload.issue_opened);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadDiffComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"filediff,interfilediff","order-by":"filediff,first_line","force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadDiffComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"filediff,interfilediff","order-by":"filediff,first_line","force-text-type":"html","include-text-types":"raw"})});it("Deleting comment",function(){spyOn(window,"confirm").and.returnValue(true);testLoadDiffComments();expect(dlg._diffCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._diffCommentsCollection.length).toBe(0)});it("Deleting comment and cancelling",function(){spyOn(window,"confirm").and.returnValue(false);testLoadDiffComments();expect(dlg._diffCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._diffCommentsCollection.length).toBe(1)})});describe("File attachment comments",function(){function testLoadFileAttachmentComments(){fileAttachmentCommentsPayload.total_results=1;fileAttachmentCommentsPayload.file_attachment_comments=[fileAttachmentCommentPayload];dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect($.ajax).toHaveBeenCalled();expect($.ajax.calls.argsFor(2)[0].url).toBe("/file-attachment-comments/");ajaxData=$.ajax.calls.argsFor(2)[0].data;expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];expect(commentView.$editor.text()).toBe(fileAttachmentCommentPayload.text);expect(commentView.$issueOpened.prop("checked")).toBe(fileAttachmentCommentPayload.issue_opened);expect(commentView.$(".filename a").attr("href")).toBe(fileAttachmentCommentPayload.review_url);expect(commentView.$(".filename a").text()).toBe(fileAttachmentCommentPayload.link_text);expect(commentView.$(".thumbnail").html()).toBe(fileAttachmentCommentPayload.thumbnail_html);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadFileAttachmentComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"diff_against_file_attachment,"+"file_attachment","force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadFileAttachmentComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"diff_against_file_attachment,"+"file_attachment","force-text-type":"html","include-text-types":"raw"})});it("Deleting comment",function(){spyOn(window,"confirm").and.returnValue(true);testLoadFileAttachmentComments();expect(dlg._fileAttachmentCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._fileAttachmentCommentsCollection.length).toBe(0)});it("Deleting comment and cancelling",function(){spyOn(window,"confirm").and.returnValue(false);testLoadFileAttachmentComments();expect(dlg._fileAttachmentCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._fileAttachmentCommentsCollection.length).toBe(1)})});describe("Screenshot comments",function(){function testLoadScreenshotComments(){screenshotCommentsPayload.total_results=1;screenshotCommentsPayload.screenshot_comments=[screenshotCommentPayload];dlg=createReviewDialog();expect($.ajax).toHaveBeenCalled();expect($.ajax.calls.argsFor(1)[0].url).toBe("/screenshot-comments/");ajaxData=$.ajax.calls.argsFor(1)[0].data;expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];expect(commentView.$editor.text()).toBe(screenshotCommentPayload.text);expect(commentView.$issueOpened.prop("checked")).toBe(screenshotCommentPayload.issue_opened);const $img=commentView.$("img");expect($img.attr("src")).toBe(screenshotCommentPayload.thumbnail_url);expect($img.attr("width")).toBe(screenshotCommentPayload.w.toString());expect($img.attr("height")).toBe(screenshotCommentPayload.h.toString());expect($img.attr("alt")).toBe(screenshotCommentPayload.screenshot.caption);const $filenameA=commentView.$(".filename a");expect($filenameA.attr("href")).toBe(screenshotCommentPayload.screenshot.review_url);expect($filenameA.text()).toBe(screenshotCommentPayload.screenshot.caption);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadScreenshotComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"screenshot","force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadScreenshotComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"screenshot","force-text-type":"html","include-text-types":"raw"})});it("Deleting comment",function(){spyOn(window,"confirm").and.returnValue(true);testLoadScreenshotComments();expect(dlg._screenshotCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._screenshotCommentsCollection.length).toBe(0)});it("Deleting comment and cancelling",function(){spyOn(window,"confirm").and.returnValue(false);testLoadScreenshotComments();expect(dlg._screenshotCommentsCollection.length).toBe(1);dlg.$(".delete-comment").click();expect(dlg._screenshotCommentsCollection.length).toBe(1)})})})});describe("Saving",function(){let fileAttachmentCommentsPayload;let generalCommentsPayload;let diffCommentsPayload;let screenshotCommentsPayload;let commentView;let comment;function testSaveComment(richText){const newCommentText="New comment text";dlg=createReviewDialog();expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];comment=commentView.model;spyOn(comment,"save");commentView.inlineEditorView.startEdit();commentView.inlineEditorView.setValue(newCommentText);commentView.textEditor.setRichText(richText);commentView.save();expect(comment.save).toHaveBeenCalled();expect(comment.get("text")).toBe(newCommentText);expect(comment.get("richText")).toBe(richText)}function testSaveCommentPreventsXSS(richText){const newCommentText='"><script>window.rbTestFoundXSS = true;<\/script>';delete window.rbTestFoundXSS;dlg=createReviewDialog();expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];comment=commentView.model;spyOn(comment,"save");commentView.inlineEditorView.startEdit();commentView.inlineEditorView.setValue(newCommentText);commentView.textEditor.setRichText(true);commentView.save();expect(comment.save).toHaveBeenCalled();expect(comment.get("text")).toBe(newCommentText);expect(window.rbTestFoundXSS).toBe(undefined)}beforeEach(function(){review.set({loaded:true,id:42,links:{diff_comments:{href:"/diff-comments/"},file_attachment_comments:{href:"/file-attachment-comments/"},general_comments:{href:"/general-comments/"},screenshot_comments:{href:"/screenshot-comments/"}}});diffCommentsPayload=_.clone(emptyDiffCommentsPayload);screenshotCommentsPayload=_.clone(emptyScreenshotCommentsPayload);fileAttachmentCommentsPayload=_.clone(emptyFileAttachmentCommentsPayload);generalCommentsPayload=_.clone(emptyGeneralCommentsPayload);spyOn(review,"save").and.callFake((options,context)=>{if(options&&options.success){options.success.call(context)}});spyOn($,"ajax").and.callFake(options=>{if(options.url==="/file-attachment-comments/"){options.success(fileAttachmentCommentsPayload)}else if(options.url==="/diff-comments/"){options.success(diffCommentsPayload)}else if(options.url==="/screenshot-comments/"){options.success(screenshotCommentsPayload)}else if(options.url==="/general-comments/"){options.success(generalCommentsPayload)}})});describe("Review properties",function(){function testSelfXSS(bodyView,attrName){const text='"><script>window.rbTestFoundXSS = true;'+"<\/script>";const editor=bodyView.textEditor;delete window.rbTestFoundXSS;bodyView.openEditor();editor.setText(text);editor.setRichText(true);bodyView.save();expect(editor.getText()).toBe(text);expect(review.save).toHaveBeenCalled();expect(review.get(attrName)).toBe(text);expect(window.rbTestFoundXSS).toBe(undefined)}beforeEach(function(){dlg=createReviewDialog()});describe("Body Top",function(){function runTest(richText){const text="My new text";const bodyTopEditor=dlg._bodyTopView.textEditor;dlg._bodyTopView.openEditor();bodyTopEditor.setText(text);bodyTopEditor.setRichText(richText);dlg._bodyTopView.save();expect(bodyTopEditor.getText()).toBe(text);expect(review.save).toHaveBeenCalled();expect(review.get("bodyTop")).toBe(text);expect(review.get("bodyTopRichText")).toBe(richText)}it("For Markdown",function(){runTest(true)});it("For plain text",function(){runTest(false)});it("Prevents Self-XSS",function(){testSelfXSS(dlg._bodyTopView,"bodyTop")})});describe("Body Bottom",function(){function runTest(richText){const text="My new text";const bodyBottomEditor=dlg._bodyBottomView.textEditor;dlg._bodyBottomView.openEditor();bodyBottomEditor.setText(text);bodyBottomEditor.setRichText(richText);dlg._bodyBottomView.save();expect(bodyBottomEditor.getText()).toBe(text);expect(review.save).toHaveBeenCalled();expect(review.get("bodyBottom")).toBe(text);expect(review.get("bodyBottomRichText")).toBe(richText)}it("For Markdown",function(){runTest(true)});it("For plain text",function(){runTest(false)});it("Prevents Self-XSS",function(){testSelfXSS(dlg._bodyBottomView,"bodyBottom")})});describe("Ship It",function(){function runTest(shipIt){dlg._$shipIt.prop("checked",shipIt);dlg._saveReview();expect(dlg._$shipIt.prop("checked")).toBe(shipIt)}it("Checked",function(){runTest(true)});it("Unchecked",function(){runTest(false)})})});describe("Diff comments",function(){beforeEach(function(){diffCommentsPayload.total_results=1;diffCommentsPayload.diff_comments=[diffCommentPayload]});it("For Markdown",function(){testSaveComment(true)});it("For plain text",function(){testSaveComment(false)});it("Prevents Self-XSS",function(){testSaveCommentPreventsXSS()})});describe("File attachment comments",function(){beforeEach(function(){fileAttachmentCommentsPayload.total_results=1;fileAttachmentCommentsPayload.file_attachment_comments=[fileAttachmentCommentPayload]});it("For Markdown",function(){testSaveComment(true)});it("For plain text",function(){testSaveComment(false)});it("Prevents Self-XSS",function(){testSaveCommentPreventsXSS()})});describe("General comments",function(){beforeEach(function(){generalCommentsPayload.total_results=1;generalCommentsPayload.general_comments=[generalCommentPayload]});it("For Markdown",function(){testSaveComment(true)});it("For plain text",function(){testSaveComment(false)})});describe("Screenshot comments",function(){beforeEach(function(){screenshotCommentsPayload.total_results=1;screenshotCommentsPayload.screenshot_comments=[screenshotCommentPayload]});it("For Markdown",function(){testSaveComment(true)});it("For plain text",function(){testSaveComment(false)});it("Prevents Self-XSS",function(){testSaveCommentPreventsXSS()})})})})});"use strict";suite("rb/views/ReviewRequestEditorView",function(){const template=`<div>
 <div id="review-request-banners"></div>
 <div id="review-request-warning"></div>
 <div class="actions">
  <a href="#" id="discard-review-request-action"></a>
  <a href="#" id="submit-review-request-action"></a>
  <a href="#" id="delete-review-request-action"></a>
 </div>
 <div class="review-request">
  <div id="review-request-main">
   <span id="field_summary"
         data-field-id="summary"
         class="field editable"></span>
   <span id="field_branch"
         data-field-id="branch"
         class="field editable"></span>
   <span id="field_submitter"
         data-field-id="submitter"
         class="field editable"></span>
   <span id="field_bugs_closed"
         data-field-id="bugs_closed"
         class="field editable comma-editable"></span>
   <span id="field_depends_on"
         data-field-id="depends_on"
         class="field editable comma-editable"></span>
   <span id="field_target_groups"
         data-field-id="target_groups"
         class="field editable comma-editable"></span>
   <span id="field_target_people"
         data-field-id="target_people"
         class="field editable"></span>
   <div class="review-request-section">
    <pre id="field_description"
         data-field-id="description"
         class="field field-text-area editable"></pre>
   </div>
   <div class="review-request-section">
    <pre id="field_testing_done"
         data-field-id="testing_done"
         class="field field-text-area editable"></pre>
   </div>
   <div class="review-request-section">
    <div class="field-container">
     <pre id="field_my_custom"
          data-field-id="my_custom"
          class="field editable"></pre>
     <pre id="field_my_rich_text_custom"
          data-field-id="my_rich_text_custom"
          class="field field-text-area editable rich-text"
          data-allow-markdown="True"></pre>
     <pre id="field_text"
          data-field-id="text"
          class="field field-text-area editable"
          data-allow-markdown="True"></pre>
     <input id="field_checkbox"
            data-field-id="checkbox"
            class="field"
            type="checkbox">
    </div>
   </div>
  </div>
 </div>
 <div id="review-request-extra">
  <div>
   <div id="file-list"><br /></div>
  </div>
  <div>
   <div id="screenshot-thumbnails"><br /></div>
  </div>
 </div>
</div>`;const screenshotThumbnailTemplate=_.template(`<div class="screenshot-container" data-screenshot-id="<%= id %>">
 <div class="screenshot-caption">
  <a class="edit"></a>
 </div>
 <a class="delete">X</a>
'</div>`);let reviewRequest;let editor;let view;let $filesContainer;let $screenshotsContainer;beforeEach(function(){RB.DnDUploader.create();reviewRequest=new RB.ReviewRequest({id:123,public:true,state:RB.ReviewRequest.PENDING});editor=new RB.ReviewRequestEditor({mutableByUser:true,statusMutableByUser:true,reviewRequest:reviewRequest,commentIssueManager:new RB.CommentIssueManager});const $el=$(template).appendTo($testsScratch);view=new RB.ReviewRequestEditorView({el:$el,model:editor});view.addFieldView(new RB.ReviewRequestFields.SummaryFieldView({el:$el.find("#field_summary"),fieldID:"summary",model:editor}));view.addFieldView(new RB.ReviewRequestFields.BranchFieldView({el:$el.find("#field_branch"),fieldID:"branch",model:editor}));view.addFieldView(new RB.ReviewRequestFields.OwnerFieldView({el:$el.find("#field_submitter"),fieldID:"submitter",model:editor}));view.addFieldView(new RB.ReviewRequestFields.BugsFieldView({el:$el.find("#field_bugs_closed"),fieldID:"bugs_closed",model:editor}));view.addFieldView(new RB.ReviewRequestFields.DependsOnFieldView({el:$el.find("#field_depends_on"),fieldID:"depends_on",model:editor}));view.addFieldView(new RB.ReviewRequestFields.TargetGroupsFieldView({el:$el.find("#field_target_groups"),fieldID:"target_groups",model:editor}));view.addFieldView(new RB.ReviewRequestFields.TargetPeopleFieldView({el:$el.find("#field_target_people"),fieldID:"target_people",model:editor}));view.addFieldView(new RB.ReviewRequestFields.DescriptionFieldView({el:$el.find("#field_description"),fieldID:"description",model:editor}));view.addFieldView(new RB.ReviewRequestFields.TestingDoneFieldView({el:$el.find("#field_testing_done"),fieldID:"testing_done",model:editor}));view.addFieldView(new RB.ReviewRequestFields.TextFieldView({el:$el.find("#field_my_custom"),fieldID:"my_custom",model:editor}));view.addFieldView(new RB.ReviewRequestFields.MultilineTextFieldView({el:$el.find("#field_my_rich_text_custom"),fieldID:"my_rich_text_custom",model:editor}));view.addFieldView(new RB.ReviewRequestFields.MultilineTextFieldView({el:$el.find("#field_text"),fieldID:"text",model:editor}));view.addFieldView(new RB.ReviewRequestFields.CheckboxFieldView({el:$el.find("#field_checkbox"),fieldID:"checkbox",model:editor}));$filesContainer=$testsScratch.find("#file-list");$screenshotsContainer=$testsScratch.find("#screenshot-thumbnails");spyOn(view,"_refreshPage");spyOn(reviewRequest.draft,"ready").and.callFake((options,context)=>options.ready.call(context))});afterEach(function(){RB.DnDUploader.instance=null});describe("Actions bar",function(){describe("Close",function(){beforeEach(function(){view.render()});it("Delete Permanently",function(){let $buttons=$();spyOn(reviewRequest,"destroy");spyOn($.fn,"modalBox").and.callFake(options=>{options.buttons.forEach($btn=>{$buttons=$buttons.add($btn)});return{modalBox:cmd=>{expect(cmd).toBe("buttons");return $buttons}}});$("#delete-review-request-action").click();expect($.fn.modalBox).toHaveBeenCalled();$buttons.filter('input[value="Delete"]').click();expect(reviewRequest.destroy).toHaveBeenCalled()});it("Discarded",function(){spyOn(reviewRequest,"close").and.callFake(options=>{expect(options.type).toBe(RB.ReviewRequest.CLOSE_DISCARDED)});spyOn(window,"confirm").and.returnValue(true);$("#discard-review-request-action").click();expect(reviewRequest.close).toHaveBeenCalled()});it("Submitted",function(){spyOn(reviewRequest,"close").and.callFake(options=>{expect(options.type).toBe(RB.ReviewRequest.CLOSE_SUBMITTED)});$("#submit-review-request-action").click();expect(reviewRequest.close).toHaveBeenCalled()})});it("ReviewRequestActionHooks",function(){var MyExtension,extension,$action;MyExtension=RB.Extension.extend({initialize:function(){RB.Extension.prototype.initialize.call(this);new RB.ReviewRequestActionHook({extension:this,callbacks:{"#my-action":_.bind(function(){this.actionClicked=true},this)}})}});extension=new MyExtension;$action=$('<a href="#" id="my-action" />').appendTo(view.$(".actions"));view.render();$action.click();expect(extension.actionClicked).toBe(true)})});describe("Banners",function(){beforeEach(function(){view.render()});describe("Draft banner",function(){describe("Visibility",function(){it("Hidden when saving",function(){expect(view.banner).toBe(null);editor.trigger("saving");expect(view.banner).toBe(null)});it("Show when saved",function(){const summaryField=view.getFieldView("summary");const summaryEditor=summaryField.inlineEditorView;expect(view.banner).toBe(null);spyOn(reviewRequest.draft,"ensureCreated").and.callFake((options,context)=>options.success.call(context));spyOn(reviewRequest.draft,"save").and.callFake((options,context)=>options.success.call(context));summaryEditor.startEdit();summaryEditor.setValue("New summary");summaryEditor.save();expect(view.banner).not.toBe(null);expect(view.banner.$el.is(":visible")).toBe(true)})});describe("Buttons actions",function(){beforeEach(function(){reviewRequest.set({links:{submitter:{title:"submitter"}}})});it("Discard Draft",function(){view.model.set("hasDraft",true);view.showBanner();spyOn(reviewRequest.draft,"destroy");$("#btn-draft-discard").click();expect(reviewRequest.draft.destroy).toHaveBeenCalled()});it("Discard Review Request",function(){reviewRequest.set("public",false);view.model.set("hasDraft",true);view.showBanner();spyOn(reviewRequest,"close").and.callFake(options=>expect(options.type).toBe(RB.ReviewRequest.CLOSE_DISCARDED));$("#btn-review-request-discard").click();expect(reviewRequest.close).toHaveBeenCalled()});describe("Publish",function(){beforeEach(function(){view.model.set("hasDraft",true);spyOn(editor,"publishDraft").and.callThrough();spyOn(reviewRequest.draft,"ensureCreated").and.callFake((options,context)=>options.success.call(context));spyOn(reviewRequest.draft,"publish");reviewRequest.draft.set({targetGroups:[{name:"foo",url:"/groups/foo"}],summary:"foo",links:{submitter:{title:"submitter"}},description:"foo"})});it("Basic publishing",function(){view.showBanner();$("#btn-draft-publish").click();expect(editor.get("publishing")).toBe(true);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled();expect(reviewRequest.draft.publish).toHaveBeenCalled()});it("With submitter changed",function(){reviewRequest.draft.set({links:{submitter:{title:"submitter2"}}});view.showBanner();spyOn(window,"confirm").and.returnValue(true);$("#btn-draft-publish").click();expect(editor.get("publishing")).toBe(true);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled();expect(window.confirm).toHaveBeenCalled();expect(reviewRequest.draft.publish).toHaveBeenCalled()});it("With Send E-Mail turned on",function(){view.model.set("showSendEmail",true);view.showBanner();$("#btn-draft-publish").click();expect(editor.get("publishing")).toBe(true);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled();expect(reviewRequest.draft.publish).toHaveBeenCalled();expect(reviewRequest.draft.publish.calls.argsFor(0)[0].trivial).toBe(0)});it("With Send E-Mail turned off",function(){view.model.set("showSendEmail",true);view.showBanner();$(".send-email").prop("checked",false);$("#btn-draft-publish").click();expect(editor.get("publishing")).toBe(true);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled();expect(reviewRequest.draft.publish).toHaveBeenCalled();expect(reviewRequest.draft.publish.calls.argsFor(0)[0].trivial).toBe(1)})})});describe("Button states",function(){let $buttons;beforeEach(function(){view.model.set("hasDraft",true);view.showBanner();$buttons=view.banner.$buttons});it("Enabled by default",function(){expect($buttons.prop("disabled")).toBe(false)});it("Disabled when saving",function(){expect($buttons.prop("disabled")).toBe(false);editor.trigger("saving");expect($buttons.prop("disabled")).toBe(true)});it("Enabled when saved",function(){expect($buttons.prop("disabled")).toBe(false);editor.trigger("saving");expect($buttons.prop("disabled")).toBe(true);editor.trigger("saved");expect($buttons.prop("disabled")).toBe(false)})})});describe("Discarded banner",function(){beforeEach(function(){reviewRequest.set("state",RB.ReviewRequest.CLOSE_DISCARDED)});it("Visibility",function(){expect(view.banner).toBe(null);view.showBanner();expect(view.banner).not.toBe(null);expect(view.banner.el.id).toBe("discard-banner");expect(view.banner.$el.is(":visible")).toBe(true)});describe("Buttons actions",function(){beforeEach(function(){expect(view.banner).toBe(null);view.showBanner()});it("Reopen",function(){spyOn(reviewRequest,"reopen");$("#btn-review-request-reopen").click();expect(reviewRequest.reopen).toHaveBeenCalled()})});describe("Close description",function(){let fieldEditor;let $input;beforeEach(function(){view.showBanner();fieldEditor=view.banner.field.inlineEditorView;$input=fieldEditor.$field});function testCloseDescription(testName,richText){it(testName,function(done){fieldEditor.startEdit();const textEditor=fieldEditor.textEditor;textEditor.setText("My description");textEditor.setRichText(richText);$input.triggerHandler("keyup");const t=setInterval(()=>{if(fieldEditor.isDirty()){clearInterval(t);spyOn(reviewRequest,"close").and.callFake(options=>{expect(options.type).toBe(RB.ReviewRequest.CLOSE_DISCARDED);expect(options.description).toBe("My description");expect(options.richText).toBe(richText)});fieldEditor.submit();expect(reviewRequest.close).toHaveBeenCalled();done()}},100)})}describe("Saves",function(){testCloseDescription("For Markdown",true);testCloseDescription("For plain text",false)})})});describe("Submitted banner",function(){beforeEach(function(){reviewRequest.set("state",RB.ReviewRequest.CLOSE_SUBMITTED)});it("Visibility",function(){expect(view.banner).toBe(null);view.showBanner();expect(view.banner).not.toBe(null);expect(view.banner.el.id).toBe("submitted-banner");expect(view.banner.$el.is(":visible")).toBe(true)});describe("Buttons actions",function(){beforeEach(function(){expect(view.banner).toBe(null);reviewRequest.set("state",RB.ReviewRequest.CLOSE_SUBMITTED);view.showBanner()});it("Reopen",function(){spyOn(reviewRequest,"reopen");$("#btn-review-request-reopen").click();expect(reviewRequest.reopen).toHaveBeenCalled()})});describe("Close description",function(){let fieldEditor;let $input;beforeEach(function(){view.showBanner();fieldEditor=view.banner.field.inlineEditorView;$input=fieldEditor.$field});function testCloseDescription(testName,richText){it(testName,function(done){fieldEditor.startEdit();const textEditor=fieldEditor.textEditor;textEditor.setText("My description");textEditor.setRichText(richText);$input.triggerHandler("keyup");const t=setInterval(function(){if(fieldEditor.isDirty()){clearInterval(t);spyOn(reviewRequest,"close").and.callFake(options=>{expect(options.type).toBe(RB.ReviewRequest.CLOSE_SUBMITTED);expect(options.description).toBe("My description");expect(options.richText).toBe(richText)});fieldEditor.submit();expect(reviewRequest.close).toHaveBeenCalled();done()}},100)})}describe("Saves",function(){testCloseDescription("For Markdown",true);testCloseDescription("For plain text",false)})})})});describe("Fields",function(){let saveSpyFunc;let fieldName;let jsonFieldName;let jsonTextTypeFieldName;let supportsRichText;let useExtraData;let fieldView;let fieldEditor;let $field;let $input;beforeEach(function(){if(!saveSpyFunc){saveSpyFunc=(options,context)=>{expect(options.data[jsonFieldName]).toBe("My Value");options.success.call(context)}}spyOn(reviewRequest.draft,"save").and.callFake(saveSpyFunc);view.render()});function setupFieldTests(options){beforeEach(function(){fieldName=options.fieldName;jsonFieldName=options.jsonFieldName;jsonTextTypeFieldName=jsonFieldName==="text"?"text_type":jsonFieldName+"_text_type";supportsRichText=!!options.supportsRichText;useExtraData=options.useExtraData;fieldView=view.getFieldView(options.fieldID||options.jsonFieldName);fieldEditor=fieldView.inlineEditorView;$field=view.$(options.selector);$input=fieldEditor.$field})}function hasAutoCompleteTest(){it("Has auto-complete",function(){expect($input.data("uiRbautocomplete")).not.toBe(undefined)})}function hasEditorTest(){it("Has editor",function(){expect(fieldEditor).not.toBe(undefined)})}function runSavingTest(richText,textType,supportsRichTextEV){beforeEach(function(done){expect(supportsRichText).toBe(supportsRichTextEV);fieldEditor.startEdit();if(supportsRichText){expect($field.hasClass("field-text-area")).toBe(true);const textEditor=fieldEditor.textEditor;textEditor.setText("My Value");textEditor.setRichText(richText)}else{$input.val("My Value")}$input.triggerHandler("keyup");expect(fieldEditor.getValue()).toBe("My Value");const t=setInterval(()=>{if(fieldEditor.isDirty()){clearInterval(t);done()}},100)});it("",function(){const expectedData={};const fieldPrefix=useExtraData?"extra_data.":"";expectedData[fieldPrefix+jsonFieldName]="My Value";if(supportsRichText){expectedData[fieldPrefix+jsonTextTypeFieldName]=textType;expectedData.force_text_type="html";expectedData.include_text_types="raw"}expect(fieldEditor.isDirty()).toBe(true);fieldEditor.submit();expect(reviewRequest.draft.save).toHaveBeenCalled();expect(reviewRequest.draft.save.calls.argsFor(0)[0].data).toEqual(expectedData)})}function savingTest(){describe("Saves",function(){runSavingTest(undefined,undefined,false)})}function richTextSavingTest(){describe("Saves",function(){describe("For Markdown",function(){runSavingTest(true,"markdown",true)});describe("For plain text",function(){runSavingTest(false,"plain",true)})})}function inlineEditorResizeTests(){it("Propagates resizes",function(){spyOn(fieldView,"trigger").and.callThrough();fieldView.inlineEditorView.textEditor.$el.triggerHandler("resize");expect(fieldView.trigger).toHaveBeenCalledWith("resize")})}function editCountTests(){describe("Edit counts",function(){it("When opened",function(){expect(editor.get("editCount")).toBe(0);fieldEditor.startEdit();expect(editor.get("editCount")).toBe(1)});it("When canceled",function(){fieldEditor.startEdit();fieldEditor.cancel();expect(editor.get("editCount")).toBe(0)});it("When submitted",function(){fieldEditor.startEdit();$input.val("My Value").triggerHandler("keyup");fieldEditor.submit();expect(editor.get("editCount")).toBe(0)})})}function securityTests(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(options.supportsRichText){describe("Security measures",function(){it("No self-XSS when draft field changes",function(){let fieldOwner;delete window.rbTestFoundXSS;if(options.fieldOnReviewRequest){fieldOwner=reviewRequest}else{fieldOwner=reviewRequest.draft}fieldOwner.set(fieldName,'"><script>window.rbTestFoundXSS = true;<\/script>');fieldOwner.trigger("change:"+fieldName);fieldOwner.trigger("fieldChange:"+fieldName);expect(window.rbTestFoundXSS).toBe(undefined)})})}}describe("Branch",function(){setupFieldTests({fieldName:"branch",jsonFieldName:"branch",selector:"#field_branch"});hasEditorTest();savingTest();editCountTests();securityTests()});describe("Bugs Closed",function(){setupFieldTests({fieldName:"bugsClosed",jsonFieldName:"bugs_closed",selector:"#field_bugs_closed"});hasEditorTest();savingTest();describe("Formatting",function(){it("With bugTrackerURL",function(){reviewRequest.set("bugTrackerURL","http://issues/?id=--bug_id--");reviewRequest.draft.set("bugsClosed",[1,2,3]);editor.trigger("fieldChanged:bugsClosed");expect($field.text()).toBe("1, 2, 3");const $links=$field.children("a");expect($links.length).toBe(3);let $link=$links.eq(0);expect($link.hasClass("bug")).toBe(true);expect($link.text()).toBe("1");expect($link.attr("href")).toBe("http://issues/?id=1");$link=$links.eq(1);expect($link.hasClass("bug")).toBe(true);expect($link.text()).toBe("2");expect($link.attr("href")).toBe("http://issues/?id=2");$link=$links.eq(2);expect($link.hasClass("bug")).toBe(true);expect($link.text()).toBe("3");expect($link.attr("href")).toBe("http://issues/?id=3")});it("Without bugTrackerURL",function(){reviewRequest.set("bugTrackerURL","");reviewRequest.draft.set("bugsClosed",[1,2,3]);editor.trigger("fieldChanged:bugsClosed");expect($field.html()).toBe("1, 2, 3")})});editCountTests();securityTests()});describe("Depends On",function(){setupFieldTests({fieldName:"dependsOn",jsonFieldName:"depends_on",selector:"#field_depends_on"});hasAutoCompleteTest();hasEditorTest();savingTest();it("Formatting",function(){reviewRequest.draft.set("dependsOn",[{id:"123",url:"/r/123/"},{id:"124",url:"/r/124/"}]);editor.trigger("fieldChanged:dependsOn");const $fieldChildren=$field.children();expect($field.text()).toBe("123, 124");expect($fieldChildren.eq(0).attr("href")).toBe("/r/123/");expect($fieldChildren.eq(1).attr("href")).toBe("/r/124/")});editCountTests();securityTests()});describe("Change Descriptions",function(){function closeDescriptionTests(options){beforeEach(function(){reviewRequest.set("state",options.closeType);view.showBanner();spyOn(reviewRequest,"close").and.callThrough();spyOn(reviewRequest,"save")});setupFieldTests({fieldName:"closeDescription",jsonFieldName:"close_description",selector:options.bannerSel+" #field_close_description"});hasEditorTest();it("Starts closed",function(){expect($input.is(":visible")).toBe(false)});describe("Saves",function(){function testSave(richText,textType,setRichText){const expectedData={status:options.jsonCloseType,force_text_type:"html",include_text_types:"raw"};expectedData[options.jsonTextTypeFieldName]=textType;expectedData[options.jsonFieldName]="My Value";fieldEditor.startEdit();const textEditor=fieldEditor.textEditor;textEditor.setText("My Value");if(setRichText!==false){textEditor.setRichText(richText)}$input.triggerHandler("keyup");fieldEditor.submit();expect(reviewRequest.close).toHaveBeenCalled();expect(reviewRequest.save).toHaveBeenCalled();expect(reviewRequest.save.calls.argsFor(0)[0].data).toEqual(expectedData)}it("For Markdown",function(){testSave(true,"markdown")});it("For plain text",function(){testSave(false,"plain")})});describe("State when statusEditable",function(){it("Disabled when false",function(){editor.set("statusEditable",false);expect(fieldEditor.options.enabled).toBe(false)});it("Enabled when true",function(){editor.set("statusEditable",true);expect(fieldEditor.options.enabled).toBe(true)})});describe("Formatting",function(){it("Links",function(){reviewRequest.set("closeDescription","Testing /r/123");editor.trigger("fieldChanged:closeDescription");expect($field.text()).toBe("Testing /r/123");expect($field.find("a").attr("href")).toBe("/r/123/")})});inlineEditorResizeTests();editCountTests();securityTests({fieldOnReviewRequest:true,supportsRichText:true})}describe("Discarded review requests",function(){closeDescriptionTests({bannerSel:"#discard-banner",closeType:RB.ReviewRequest.CLOSE_DISCARDED,jsonCloseType:"discarded",jsonFieldName:"close_description",jsonTextTypeFieldName:"close_description_text_type"})});describe("Draft review requests",function(){beforeEach(function(){view.model.set("hasDraft",true);view.showBanner()});setupFieldTests({supportsRichText:true,fieldID:"change_description",fieldName:"changeDescription",jsonFieldName:"changedescription",selector:"#draft-banner #field_change_description"});hasEditorTest();richTextSavingTest();editCountTests();securityTests({fieldOnReviewRequest:true,supportsRichText:true})});describe("Submitted review requests",function(){closeDescriptionTests({bannerSel:"#submitted-banner",closeType:RB.ReviewRequest.CLOSE_SUBMITTED,jsonCloseType:"submitted",jsonFieldName:"close_description",jsonTextTypeFieldName:"close_description_text_type"})})});describe("Description",function(){setupFieldTests({supportsRichText:true,fieldName:"description",jsonFieldName:"description",selector:"#field_description"});hasEditorTest();richTextSavingTest();describe("Formatting",function(){it("Links",function(){reviewRequest.draft.set("description","Testing /r/123");editor.trigger("fieldChanged:description");expect($field.text()).toBe("Testing /r/123");expect($field.find("a").attr("href")).toBe("/r/123/")})});inlineEditorResizeTests();editCountTests();securityTests({supportsRichText:true})});describe("Summary",function(){setupFieldTests({fieldName:"summary",jsonFieldName:"summary",selector:"#field_summary"});hasEditorTest();savingTest();editCountTests();securityTests()});describe("Testing Done",function(){setupFieldTests({supportsRichText:true,fieldName:"testingDone",jsonFieldName:"testing_done",selector:"#field_testing_done"});hasEditorTest();richTextSavingTest();describe("Formatting",function(){it("Links",function(){reviewRequest.draft.set("testingDone","Testing /r/123");editor.trigger("fieldChanged:testingDone");expect($field.text()).toBe("Testing /r/123");expect($field.find("a").attr("href")).toBe("/r/123/")})});inlineEditorResizeTests();editCountTests();securityTests({supportsRichText:true})});describe("Reviewers",function(){describe("Groups",function(){setupFieldTests({fieldName:"targetGroups",jsonFieldName:"target_groups",selector:"#field_target_groups"});hasAutoCompleteTest();hasEditorTest();savingTest();it("Formatting",function(){reviewRequest.draft.set("targetGroups",[{name:"group1",url:"/groups/group1/"},{name:"group2",url:"/groups/group2/"}]);editor.trigger("fieldChanged:targetGroups");expect($field.html()).toBe('<a href="/groups/group1/">group1</a>, '+'<a href="/groups/group2/">group2</a>')});editCountTests();securityTests()});describe("People",function(){setupFieldTests({fieldName:"targetPeople",jsonFieldName:"target_people",selector:"#field_target_people"});hasAutoCompleteTest();hasEditorTest();savingTest();it("Formatting",function(){reviewRequest.draft.set("targetPeople",[{username:"user1",url:"/users/user1/"},{username:"user2",url:"/users/user2/"}]);editor.trigger("fieldChanged:targetPeople");expect($field.text()).toBe("user1, user2");expect($($field.children()[0]).attr("href")).toBe("/users/user1/");expect($($field.children()[1]).attr("href")).toBe("/users/user2/")});editCountTests();securityTests()})});describe("Owner",function(){setupFieldTests({jsonFieldName:"submitter",selector:"#field_submitter"});hasAutoCompleteTest();hasEditorTest();savingTest();it("Formatting",function(){reviewRequest.draft.set("submitter",{title:"user1",href:"/users/user1/"});editor.trigger("fieldChanged:submitter");expect($field.text()).toBe("user1");expect($field.children().attr("href")).toBe("/users/user1/")});editCountTests()});describe("Custom fields",function(){beforeEach(function(){saveSpyFunc=(options,context)=>{expect(options.data["extra_data."+jsonFieldName]).toBe("My Value");options.success.call(context)}});setupFieldTests({fieldID:"my_custom",jsonFieldName:"my_custom",selector:"#field_my_custom",useExtraData:true});hasEditorTest();savingTest();editCountTests();securityTests()});describe("Custom rich-text field",function(){beforeEach(function(){saveSpyFunc=(options,context)=>{expect(options.data["extra_data."+jsonFieldName]).toBe("My Value");options.success.call(context)}});setupFieldTests({supportsRichText:true,fieldID:"my_rich_text_custom",jsonFieldName:"my_rich_text_custom",selector:"#field_my_rich_text_custom",useExtraData:true});it("Initial rich text state",function(){expect(fieldEditor.textEditor.richText).toBe(true)});hasEditorTest();richTextSavingTest();inlineEditorResizeTests();editCountTests();securityTests()});describe("Custom rich-text field with special name",function(){beforeEach(function(){saveSpyFunc=(options,context)=>{expect(options.data["extra_data."+jsonFieldName]).toBe("My Value");options.success.call(context)}});setupFieldTests({supportsRichText:true,fieldID:"text",jsonFieldName:"text",selector:"#field_text",useExtraData:true});hasEditorTest();richTextSavingTest();inlineEditorResizeTests();editCountTests();securityTests()});describe("Custom checkbox field",function(){beforeEach(function(){$field=view.$("#field_checkbox");saveSpyFunc=(options,context)=>{expect(options.data["extra_data.checkbox"]).toBe(true);options.success.call(context)};reviewRequest.draft.save.and.callFake(saveSpyFunc)});it("Saves",function(){const expectedData={"extra_data.checkbox":true};$field.click();expect(reviewRequest.draft.save).toHaveBeenCalled();expect(reviewRequest.draft.save.calls.argsFor(0)[0].data).toEqual(expectedData)})})});describe("File attachments",function(){it("Rendering when added",function(){spyOn(RB.FileAttachmentThumbnail.prototype,"render").and.callThrough();expect($filesContainer.find(".file-container").length).toBe(0);view.render();editor.createFileAttachment();expect(RB.FileAttachmentThumbnail.prototype.render).toHaveBeenCalled();expect($filesContainer.find(".file-container").length).toBe(1)});describe("Events",function(){let fileAttachment;let $thumbnail;beforeEach(function(){view.render();fileAttachment=editor.createFileAttachment();$thumbnail=$($filesContainer.find(".file-container")[0]);expect($thumbnail.length).toBe(1)});describe("beginEdit",function(){it("Increment edit count",function(){expect(editor.get("editCount")).toBe(0);$thumbnail.find(".file-caption .edit").data("inline-editor").startEdit();expect(editor.get("editCount")).toBe(1)})});describe("endEdit",function(){describe("Decrement edit count",function(){let $caption;let inlineEditorView;beforeEach(function(){expect(editor.get("editCount")).toBe(0);$caption=$thumbnail.find(".file-caption .edit");inlineEditorView=$caption.data("inline-editor");inlineEditorView.startEdit()});it("On cancel",function(){inlineEditorView.cancel();expect(editor.get("editCount")).toBe(0)});it("On submit",function(){spyOn(fileAttachment,"ready").and.callFake((options,context)=>options.ready.call(context));spyOn(fileAttachment,"save");$thumbnail.find("input").val("Foo").triggerHandler("keyup");inlineEditorView.submit();expect(editor.get("editCount")).toBe(0)})})})})});describe("Methods",function(){describe("getFieldView",function(){it("Correct field is returned",function(){const fieldView=view.getFieldView("target_groups");expect(fieldView).not.toBe(undefined);expect(fieldView.fieldID).toBe("target_groups");expect(view.getFieldView("some_random_id")).toBe(undefined)})})});describe("Screenshots",function(){describe("Importing on render",function(){it("No screenshots",function(){view.render();expect(editor.get("screenshots").length).toBe(0)});it("With screenshots",function(){const screenshots=editor.get("screenshots");$screenshotsContainer.append(screenshotThumbnailTemplate({id:42}));spyOn(RB.ScreenshotThumbnail.prototype,"render").and.callThrough();view.render();expect(RB.ScreenshotThumbnail.prototype.render).toHaveBeenCalled();expect(screenshots.length).toBe(1);expect(screenshots.at(0).id).toBe(42)})});describe("Events",function(){let $thumbnail;let screenshot;beforeEach(function(){$thumbnail=$(screenshotThumbnailTemplate({id:42})).appendTo($screenshotsContainer);view.render();screenshot=editor.get("screenshots").at(0)});describe("beginEdit",function(){it("Increment edit count",function(){expect(editor.get("editCount")).toBe(0);$thumbnail.find(".screenshot-caption .edit").inlineEditor("startEdit");expect(editor.get("editCount")).toBe(1)})});describe("endEdit",function(){describe("Decrement edit count",function(){let $caption;beforeEach(function(){expect(editor.get("editCount")).toBe(0);$caption=$thumbnail.find(".screenshot-caption .edit").inlineEditor("startEdit")});it("On cancel",function(){$caption.inlineEditor("cancel");expect(editor.get("editCount")).toBe(0)});it("On submit",function(){spyOn(screenshot,"ready").and.callFake((options,context)=>options.ready.call(context));spyOn(screenshot,"save");$thumbnail.find("input").val("Foo").triggerHandler("keyup");$caption.inlineEditor("submit");expect(editor.get("editCount")).toBe(0)})})})})});describe("beforeUnload event handler",function(){describe("editable=true",function(){beforeEach(function(){editor.set("statusEditable",true);editor.set("editable",true);expect(editor.get("statusEditable")).toBe(true);expect(editor.get("editable")).toBe(true);expect(editor.get("editCount")).toBe(0)});it("Warn user beforeUnload when editing",function(){view.model.incr("editCount");expect(editor.get("editCount")).toBe(1);expect(view._onBeforeUnload($.Event("beforeunload"))).toBeDefined()});it("Don't warn user beforeUnload when not editing",function(){expect(view._onBeforeUnload($.Event("beforeunload"))).toBeUndefined()})});describe("editable=false",function(){beforeEach(function(){editor.set("statusEditable",false);editor.set("editable",false);expect(editor.get("statusEditable")).toBe(false);expect(editor.get("editable")).toBe(false);expect(editor.get("editCount")).toBe(0)});it("Warn user beforeUnload when editing",function(){view.model.incr("editCount");expect(editor.get("editCount")).toBe(1);expect(view._onBeforeUnload($.Event("beforeunload"))).toBeDefined()});it("Don't warn user beforeUnload when not editing",function(){expect(view._onBeforeUnload($.Event("beforeunload"))).toBeUndefined()})})})});"use strict";suite("rb/views/reviewRequestFieldViews",function(){let reviewRequest;let draft;let extraData;let rawTextFields;let editor;let editorView;let field;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:1});draft=reviewRequest.draft;extraData=draft.get("extraData");rawTextFields={extra_data:{}};draft.set("rawTextFields",rawTextFields);editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest});editorView=new RB.ReviewRequestEditorView({model:editor});spyOn(draft,"save");spyOn(draft,"ready").and.callFake(function(options,context){options.ready.call(context)})});describe("BaseFieldView",function(){beforeEach(function(){field=new RB.ReviewRequestFields.BaseFieldView({model:editor,fieldID:"my_field"})});describe("Initialization",function(){it("Default behavior",function(){expect(field.$el.data("field-id")).toBe("my_field");expect(field.jsonFieldName).toBe("my_field")});it("With custom jsonFieldName",function(){const field=new RB.ReviewRequestFields.BaseFieldView({model:editor,fieldID:"my_field",jsonFieldName:"my_custom_name"});expect(field.$el.data("field-id")).toBe("my_field");expect(field.jsonFieldName).toBe("my_custom_name")})});describe("Properties",function(){it("fieldName",function(){expect(field.fieldName()).toBe("myField")})});describe("Methods",function(){describe("_loadValue",function(){it("Built-in field",function(){field.useExtraData=false;draft.set("myField","this is a test");expect(field._loadValue()).toBe("this is a test")});it("Custom field",function(){extraData.my_field="this is a test";expect(field._loadValue()).toBe("this is a test")});it("Custom field and custom jsonFieldName",function(){const field=new RB.ReviewRequestFields.BaseFieldView({model:editor,fieldID:"my_field",jsonFieldName:"foo"});extraData.foo="this is a test";expect(field._loadValue()).toBe("this is a test")})});describe("_saveValue",function(){it("Built-in field",function(){field.useExtraData=false;field._saveValue("test");expect(draft.save.calls.argsFor(0)[0].data).toEqual({my_field:"test"})});it("Custom field",function(){field._saveValue("this is a test");expect(draft.save.calls.argsFor(0)[0].data).toEqual({"extra_data.my_field":"this is a test"})});it("Custom field and custom jsonFieldName",function(){const field=new RB.ReviewRequestFields.BaseFieldView({model:editor,fieldID:"my_field",jsonFieldName:"foo"});field._saveValue("this is a test");expect(draft.save.calls.argsFor(0)[0].data).toEqual({"extra_data.foo":"this is a test"})})})})});describe("TextFieldView",function(){beforeEach(function(){field=new RB.ReviewRequestFields.TextFieldView({model:editor,fieldID:"my_field"});editorView.addFieldView(field)});describe("Properties",function(){describe("jsonTextTypeFieldName",function(){it('With fieldID != "text"',function(){expect(field.jsonTextTypeFieldName).toBe("my_field_text_type")});it('With fieldID = "text"',function(){field=new RB.ReviewRequestFields.TextFieldView({model:editor,fieldID:"text"});expect(field.jsonTextTypeFieldName).toBe("text_type")})});describe("richTextAttr",function(){it("With allowRichText=true",function(){field.allowRichText=true;expect(field.richTextAttr()).toBe("myFieldRichText")});it("With allowRichText=false",function(){field.allowRichText=false;expect(field.richTextAttr()).toBe(null)})})});describe("Methods",function(){describe("render",function(){beforeEach(function(){field.$el.addClass("editable");rawTextFields.extra_data={my_field:"**Hello world**",my_field_text_type:"markdown"}});describe("With allowRichText=true",function(){beforeEach(function(){field.allowRichText=true});it("With richText=true",function(){rawTextFields.extra_data.my_field_text_type="markdown";field.render();expect(field.inlineEditorView.textEditor.richText).toBe(true);expect(field.inlineEditorView.options.rawValue).toBe("**Hello world**")});it("With richText=false",function(){rawTextFields.extra_data.my_field_text_type="plain";field.render();expect(field.inlineEditorView.textEditor.richText).toBe(false);expect(field.inlineEditorView.options.rawValue).toBe("**Hello world**")})})});describe("_formatField",function(){it("With built-in field",function(){field.useExtraData=false;draft.set("myField","Hello world");field._formatField();expect(field.$el.text()).toBe("Hello world")});it("With custom field",function(){editorView.addFieldView(field);extraData.my_field="Hello world";field._formatField();expect(field.$el.text()).toBe("Hello world")});it("With formatValue as function",function(){field.formatValue=function(value){this.$el.text(`[${value}]`)};extraData.my_field="Hello world";field._formatField();expect(field.$el.text()).toBe("[Hello world]")})});describe("_getInlineEditorClass",function(){it("With allowRichText=true",function(){field.allowRichText=true;expect(field._getInlineEditorClass()).toBe(RB.RichTextInlineEditorView)});it("With allowRichText=false",function(){field.allowRichText=false;expect(field._getInlineEditorClass()).toBe(RB.InlineEditorView)})});describe("_loadRichTextValue",function(){beforeEach(function(){field.allowRichText=true});describe("With built-in field",function(){beforeEach(function(){field.useExtraData=false});it("With value=undefined",function(){draft.set("myFieldRichText",undefined);expect(field._loadRichTextValue()).toBe(undefined)});it("With value=false",function(){draft.set("myFieldRichText",false);expect(field._loadRichTextValue()).toBe(false)});it("With value=true",function(){draft.set("myFieldRichText",true);expect(field._loadRichTextValue()).toBe(true)})});describe("With custom field",function(){it("With textType=undefined",function(){expect(field._loadRichTextValue()).toBe(undefined)});it("With textType=plain",function(){rawTextFields.extra_data.my_field_text_type="plain";expect(field._loadRichTextValue()).toBe(false)});it("With textType=markdown",function(){rawTextFields.extra_data.my_field_text_type="markdown";expect(field._loadRichTextValue()).toBe(true)});it("With textType=invalid value",function(){rawTextFields.extra_data.my_field_text_type="html";try{field._loadRichTextValue()}catch(e){}expect(console.assert).toHaveBeenCalledWith(false,'Text type "html" in field "my_field_text_type" '+"not supported.")})})})})});describe("MultilineTextFieldView",function(){describe("Initialization from DOM",function(){let $el;beforeEach(function(){$el=$('<span data-allow-markdown="true"/>').text("DOM text value")});describe("allowRichText",function(){it("allow-markdown=true",function(){field=new RB.ReviewRequestFields.MultilineTextFieldView({model:editor,fieldID:"my_field",jsonFieldName:"foo",el:$el});expect(field.allowRichText).toBe(true)});it("allow-markdown=false",function(){field=new RB.ReviewRequestFields.MultilineTextFieldView({model:editor,fieldID:"my_field",jsonFieldName:"foo",el:$el.attr("data-allow-markdown","false")});expect(field.allowRichText).toBe(false)});it("allow-markdown unset",function(){field=new RB.ReviewRequestFields.MultilineTextFieldView({model:editor,fieldID:"my_field",jsonFieldName:"foo",el:$el.removeAttr("data-allow-markdown")});expect(field.allowRichText).toBe(undefined)})});describe("Text value",function(){it("raw-value set",function(){field=new RB.ReviewRequestFields.MultilineTextFieldView({model:editor,fieldID:"my_field",jsonFieldName:"foo",el:$el.attr("data-raw-value","attr text value")});expect(extraData.foo).toBe("attr text value");expect($el.attr("data-raw-value")).toBe(undefined)});it("raw-value unset",function(){field=new RB.ReviewRequestFields.MultilineTextFieldView({model:editor,fieldID:"my_field",jsonFieldName:"foo",el:$el});expect(extraData.foo).toBe("DOM text value")})});describe("Text type value",function(){it("rich-text class present",function(){field=new RB.ReviewRequestFields.MultilineTextFieldView({model:editor,fieldID:"my_field",jsonFieldName:"foo",el:$el.addClass("rich-text")});expect(extraData.foo_text_type).toBe("markdown")});it("rich-text class not present",function(){field=new RB.ReviewRequestFields.MultilineTextFieldView({model:editor,fieldID:"my_field",jsonFieldName:"foo",el:$el});expect(extraData.foo_text_type).toBe("plain")})})})})});"use strict";suite("rb/views/ScreenshotThumbnail",function(){let model;let view;beforeEach(function(){model=new RB.Screenshot;model.url="/screenshots/123/";model.id=123;model.attributes.id=123;model.set("loaded",true);const template='<div><a class="edit"></a><a class="delete">X</a></div>';view=new RB.ScreenshotThumbnail({el:$(template).appendTo($testsScratch),model:model});view.render();spyOn(model,"trigger").and.callThrough();spyOn(view,"trigger").and.callThrough()});describe("Actions",function(){it("Begin caption editing",function(){view.$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit")});it("Cancel caption editing",function(){view.$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit");view.$caption.inlineEditor("cancel");expect(view.trigger).toHaveBeenCalledWith("endEdit")});it("Save caption",function(){spyOn(model,"save");view.$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit");view.$el.find("input").val("Foo").triggerHandler("keyup");view.$caption.inlineEditor("submit");expect(view.trigger).toHaveBeenCalledWith("endEdit");expect(model.get("caption")).toBe("Foo");expect(model.save).toHaveBeenCalled()});it("Delete",function(){spyOn(model,"destroy").and.callThrough();spyOn($,"ajax").and.callFake(options=>options.success());spyOn(view.$el,"fadeOut").and.callFake(done=>done());spyOn(view,"remove");view.$el.find("a.delete").click();expect($.ajax).toHaveBeenCalled();expect(model.destroy).toHaveBeenCalled();expect(model.trigger.calls.argsFor(0)[0]).toBe("destroying");expect(view.$el.fadeOut).toHaveBeenCalled();expect(view.remove).toHaveBeenCalled()})})});"use strict";suite("rb/views/TextBasedReviewableView",function(){const template=`<div id="container">
 <div class="text-review-ui-views">
  <ul>
   <li class="active" data-view-mode="rendered">
    <a href="#rendered">Rendered</a>
   </li>
   <li data-view-mode="source"><a href="#source">Source</a></li>
  </ul>
 </div>
 <table class="text-review-ui-rendered-table"></table>
 <table class="text-review-ui-text-table"></table>
</div>`;let $container;let reviewRequest;let model;let view;beforeEach(function(){$container=$(template).appendTo($testsScratch);reviewRequest=new RB.ReviewRequest({reviewURL:"/r/123/"});model=new RB.TextBasedReviewable({hasRenderedView:true,viewMode:"rendered",fileAttachmentID:456,reviewRequest:reviewRequest});view=new RB.TextBasedReviewableView({model:model,el:$container});spyOn(window.history,"pushState");spyOn(window.history,"replaceState");spyOn(Backbone.history,"matchRoot").and.returnValue(true);spyOn(view.router,"trigger").and.callThrough();spyOn(view.router,"navigate").and.callFake((url,options)=>{if(!options||options.trigger!==false){Backbone.history.loadUrl(url)}});view.render()});afterEach(function(){view.remove();$container.remove();Backbone.history.stop()});it("Router switches view modes",function(){view.router.navigate("#rendered");expect(view.router.trigger).toHaveBeenCalledWith("route:viewMode","rendered",null,null);expect($container.find(".active").attr("data-view-mode")).toBe("rendered");expect(model.get("viewMode")).toBe("rendered");view.router.navigate("#source");expect(view.router.trigger).toHaveBeenCalledWith("route:viewMode","source",null,null);expect($container.find(".active").attr("data-view-mode")).toBe("source");expect(model.get("viewMode")).toBe("source");view.router.navigate("#rendered");expect(view.router.trigger).toHaveBeenCalledWith("route:viewMode","rendered",null,null);expect($container.find(".active").attr("data-view-mode")).toBe("rendered");expect(model.get("viewMode")).toBe("rendered")})});"use strict";suite("rb/views/UploadAttachmentView",function(){let reviewRequest;beforeEach(function(){reviewRequest=new RB.ReviewRequest({summary:"My Review Request",reviewURL:"/r/1/"})});describe("Instances",function(){let dialog;afterEach(function(){if(dialog){dialog.hide();dialog=null}});describe("Buttons",function(){beforeEach(function(){dialog=new RB.UploadAttachmentView({reviewRequest:reviewRequest})});describe("Cancel",function(){let $button;beforeEach(function(){dialog.show();$button=dialog.$buttonsMap.cancel;expect($button.length).toBe(1)});it("Enabled by default",function(){expect($button.is(":disabled")).toBe(false)});it("Closes dialog when clicked",function(){spyOn($.fn,"modalBox").and.callThrough();dialog.delegateEvents();$button.click();expect($.fn.modalBox).toHaveBeenCalledWith("destroy")})});describe("Upload",function(){let $button;let $path;beforeEach(function(){spyOn(dialog,"send");dialog.show();$button=dialog.$buttonsMap.upload;$path=dialog._$path;$path.attr("type","text");spyOn(dialog,"updateUploadButtonEnabledState").and.callThrough();dialog.delegateEvents();expect($button.length).toBe(1)});it("Disabled by default until a file is uploaded",function(){expect($button.is(":disabled")).toBe(true)});it("Enabled when a file is uploaded",function(){expect($button.is(":disabled")).toBe(true);$path.val("fakefile").trigger("change");expect(dialog.updateUploadButtonEnabledState).toHaveBeenCalledTimes(1);expect($button.is(":disabled")).toBe(false)});it("Disabled when an uploaded file is removed",function(){$path.val("fakefile").trigger("change").val("").trigger("change");expect(dialog.updateUploadButtonEnabledState).toHaveBeenCalledTimes(2);expect($button.is(":disabled")).toBe(true)});it("Uploads the file attachment",function(){expect($button.is(":disabled")).toBe(true);$path.val("fakefile").trigger("change");expect(dialog.updateUploadButtonEnabledState).toHaveBeenCalled();expect($button.is(":disabled")).toBe(false);$button.click();expect(dialog.send).toHaveBeenCalled()})})});it("Dialog for updating an existing file attachment",function(){dialog=new RB.UploadAttachmentView({attachmentHistoryID:14,presetCaption:"fakecaption",reviewRequest:reviewRequest});dialog.show();const $caption=dialog.$('[name="caption"]');const $attachmentHistory=dialog.$('[name="attachment_history"]');expect($caption.length).toBe(1);expect($caption.val()).toBe("fakecaption");expect($attachmentHistory.length).toBe(1);expect($attachmentHistory.val()).toBe("14")})})})}).call(this);
