(function(){"use strict";RB.AbstractCommentBlock=Backbone.Model.extend({defaults:{hasDraft:false,canDelete:false,draftComment:null,reviewRequest:null,review:null,serializedComments:[],count:0},initialize(){console.assert(this.get("reviewRequest"),"reviewRequest must be provided");console.assert(this.get("review"),"review must be provided");const comments=this.get("serializedComments");const newSerializedComments=[];if(comments.length>0){comments.forEach(comment=>{comment.text=$("<div>").html(comment.text).text();if(comment.localdraft){this.ensureDraftComment(comment.comment_id,{text:comment.text,richText:comment.rich_text,issueOpened:comment.issue_opened,issueStatus:comment.issue_status,html:comment.html})}else{newSerializedComments.push(comment)}},this);this.set("serializedComments",newSerializedComments)}else{this.ensureDraftComment()}this.on("change:draftComment",this._updateCount,this);this._updateCount()},isEmpty(){return this.get("serializedComments").length===0&&!this.has("draftComment")},createComment(id){console.assert(false,"This must be implemented by a subclass")},ensureDraftComment(id,comment_attr){if(this.has("draftComment")){return}const comment=this.createComment(id);comment.set(comment_attr);comment.on("saved",this._updateCount,this);comment.on("destroy",()=>{this.set("draftComment",null);this._updateCount()});this.set("draftComment",comment)},_updateCount(){let count=this.get("serializedComments").length;if(this.has("draftComment")){count++}this.set("count",count)}});"use strict";RB.AbstractReviewable=Backbone.Model.extend({defaults:{caption:null,renderedInline:false,reviewRequest:null,review:null,serializedCommentBlocks:[]},commentBlockModel:null,defaultCommentBlockFields:[],initialize(){const reviewRequest=this.get("reviewRequest");console.assert(this.commentBlockModel,"'commentBlockModel' must be defined in the "+"reviewable's object definition");console.assert(reviewRequest,"'reviewRequest' must be provided when constructing "+"the reviewable");if(!this.get("review")){this.set("review",reviewRequest.createReview())}this.commentBlocks=new Backbone.Collection;this.commentBlocks.model=this.commentBlockModel;_.each(this.get("serializedCommentBlocks"),this.loadSerializedCommentBlock,this)},createCommentBlock(attrs){this.commentBlocks.add(_.defaults({reviewRequest:this.get("reviewRequest"),review:this.get("review")},attrs))},loadSerializedCommentBlock(serializedCommentBlock){console.assert(false,"loadSerializedCommentBlock must be "+"implemented by a subclass")}});"use strict";RB.CommentEditor=Backbone.Model.extend(_.defaults({defaults(){const userSession=RB.UserSession.instance;return{canDelete:false,canEdit:undefined,canSave:false,editing:false,extraData:{},comment:null,dirty:false,openIssue:userSession.get("commentsOpenAnIssue"),publishedComments:[],publishedCommentsType:null,requireVerification:false,reviewRequest:null,richText:userSession.get("defaultUseRichText"),text:""}},initialize(){const reviewRequest=this.get("reviewRequest");this.on("change:comment",this._updateFromComment,this);this._updateFromComment();if(this.get("canEdit")===undefined){reviewRequest.on("change:hasDraft",this._updateCanEdit,this);this._updateCanEdit()}this.on("change:dirty",(model,dirty)=>{const reviewRequestEditor=this.get("reviewRequestEditor");if(reviewRequestEditor){if(dirty){reviewRequestEditor.incr("editCount")}else{reviewRequestEditor.decr("editCount")}}});this.on("change:openIssue change:requireVerification "+"change:richText change:text",()=>{if(this.get("editing")){this.set("dirty",true);this._updateState()}});this._updateState();this._setupExtraData()},beginEdit(){console.assert(this.get("canEdit"),"beginEdit() called when canEdit is false.");console.assert(this.get("comment"),"beginEdit() called when no comment was first set.");this.set({dirty:false,editing:true});this._updateState()},deleteComment(){console.assert(this.get("canDelete"),"deleteComment() called when canDelete is false.");const comment=this.get("comment");comment.destroy({success:()=>{this.trigger("deleted");this.close()}})},cancel(){const comment=this.get("comment");this.off("change:comment",this._updateFromComment,this);if(comment){comment.destroyIfEmpty();this.trigger("canceled")}this.close()},close(){this.set("editing",false);this.set({comment:null,dirty:false,extraData:new RB.ExtraData,text:""});this.trigger("closed")},save(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;console.assert(this.get("canSave"),"save() called when canSave is false.");const extraData=_.clone(this.get("extraData"));extraData.require_verification=this.get("requireVerification");const comment=this.get("comment");comment.set({text:this.get("text"),issueOpened:this.get("openIssue"),extraData:extraData,richText:this.get("richText"),includeTextTypes:"html,raw,markdown"});comment.save({success:()=>{this.set("dirty",false);this.trigger("saved");if(_.isFunction(options.success)){options.success.call(context)}},error:_.isFunction(options.error)?options.error.bind(context):undefined})},_updateFromComment(){const oldComment=this.previous("comment");const comment=this.get("comment");if(oldComment){oldComment.destroyIfEmpty()}if(comment){const defaultRichText=this.defaults().richText;this.set({dirty:false,extraData:comment.get("extraData"),openIssue:comment.get("issueOpened")===null?this.defaults().openIssue:comment.get("issueOpened"),requireVerification:comment.requiresVerification(),richText:defaultRichText||!!comment.get("richText")});const textFields=comment.get("richText")||!defaultRichText?comment.get("rawTextFields"):comment.get("markdownTextFields");this.set("text",!_.isEmpty(textFields)?textFields.text:comment.get("text"));comment.ready({ready:this._updateState},this)}},_updateCanEdit(){const reviewRequest=this.get("reviewRequest");const userSession=RB.UserSession.instance;this.set("canEdit",userSession.get("authenticated")&&!userSession.get("readOnly")&&!reviewRequest.get("hasDraft"))},_updateState(){const canEdit=this.get("canEdit");const editing=this.get("editing");const comment=this.get("comment");this.set({canDelete:canEdit&&editing&&comment&&!comment.isNew(),canSave:canEdit&&editing&&this.get("text")!==""})}},RB.ExtraDataMixin));"use strict";RB.CommentIssueManager=Backbone.Model.extend({defaults:{reviewRequest:null},initialize(){this._comments={}},setCommentState(reviewID,commentID,commentType,state){const comment=this.getComment(reviewID,commentID,commentType);this._requestState(comment,state)},getComment(reviewID,commentID,commentType){if(!this._comments[commentID]){const CommentTypes=RB.CommentIssueManager.CommentTypes;const reviewRequest=this.get("reviewRequest");let comment=null;switch(commentType){case CommentTypes.DIFF:comment=reviewRequest.createReview(reviewID).createDiffComment({id:commentID});break;case CommentTypes.SCREENSHOT:comment=reviewRequest.createReview(reviewID).createScreenshotComment(commentID);break;case CommentTypes.FILE_ATTACHMENT:comment=reviewRequest.createReview(reviewID).createFileAttachmentComment(commentID);break;case CommentTypes.GENERAL:comment=reviewRequest.createReview(reviewID).createGeneralComment(commentID);break;default:console.error('getComment received unexpected comment type "%s"',commentType)}this._comments[commentID]=comment}return this._comments[commentID]},_requestState(comment,state){comment.ready({ready:()=>{const oldIssueStatus=comment.get("issueStatus");comment.set("issueStatus",state);comment.save({attrs:["issueStatus"],success:(comment,rsp)=>{this._notifyIssueStatusChanged(comment,rsp,oldIssueStatus)}})}})},_notifyIssueStatusChanged(comment,rsp,oldIssueStatus){const CommentTypes=RB.CommentIssueManager.CommentTypes;let rspComment;let commentType;if(rsp.diff_comment){rspComment=rsp.diff_comment;commentType=CommentTypes.DIFF}else if(rsp.general_comment){rspComment=rsp.general_comment;commentType=CommentTypes.GENERAL}else if(rsp.file_attachment_comment){rspComment=rsp.file_attachment_comment;commentType=CommentTypes.FILE_ATTACHMENT}else if(rsp.screenshot_comment){rspComment=rsp.screenshot_comment;commentType=CommentTypes.SCREENSHOT}else{console.error("RB.CommentIssueManager._notifyIssueStatusChanged received "+'unexpected comment object "%o"',rsp);return}console.assert(rspComment);console.assert(commentType);this.trigger("issueStatusUpdated",comment,oldIssueStatus,rspComment.timestamp,commentType)}},{CommentTypes:{DIFF:"diff_comments",FILE_ATTACHMENT:"file_attachment_comments",GENERAL:"general_comments",SCREENSHOT:"screenshot_comments"}});"use strict";RB.FileAttachmentCommentBlock=RB.AbstractCommentBlock.extend({defaults:_.defaults({fileAttachmentID:null,diffAgainstFileAttachmentID:null},RB.AbstractCommentBlock.prototype.defaults),serializedFields:[],createComment(id){const comment=this.get("review").createFileAttachmentComment(id,this.get("fileAttachmentID"),this.get("diffAgainstFileAttachmentID"));_.extend(comment.get("extraData"),_.pick(this.attributes,this.serializedFields));return comment}});"use strict";RB.FileAttachmentReviewable=RB.AbstractReviewable.extend({defaults:_.defaults({attachmentRevisionIDs:null,diffAgainstFileAttachmentID:null,diffCaption:"",diffRevision:null,diffTypeMismatch:false,fileAttachmentID:null,fileRevision:null,filename:"",numRevisions:null},RB.AbstractReviewable.prototype.defaults),defaultCommentBlockFields:["fileAttachmentID","diffAgainstFileAttachmentID"],loadSerializedCommentBlock(serializedCommentBlock){const parsedData=this.commentBlockModel.prototype.parse(_.pick(serializedCommentBlock[0],this.commentBlockModel.prototype.serializedFields));this.createCommentBlock(_.extend({fileAttachmentID:this.get("fileAttachmentID"),diffAgainstFileAttachmentID:this.get("diffAgainstFileAttachmentID"),serializedComments:serializedCommentBlock},parsedData))}});"use strict";RB.RegionCommentBlock=RB.FileAttachmentCommentBlock.extend({defaults:_.defaults({x:null,y:null,width:null,height:null},RB.AbstractCommentBlock.prototype.defaults),serializedFields:["x","y","width","height"],parse(fields){fields.x=parseInt(fields.x,10)||undefined;fields.y=parseInt(fields.y,10)||undefined;fields.width=parseInt(fields.width,10)||undefined;fields.height=parseInt(fields.height,10)||undefined;return fields},canUpdateBounds(){return _.isEmpty(this.get("serializedComments"))},saveDraftCommentBounds(){const draftComment=this.get("draftComment");draftComment.ready({ready:()=>{const extraData=draftComment.get("extraData");extraData.x=this.get("x");extraData.y=this.get("y");extraData.width=this.get("width");extraData.height=this.get("height");draftComment.save({attrs:["extra_data.x","extra_data.y","extra_data.width","extra_data.height"],boundsUpdated:true})}})}});"use strict";RB.ReviewRequestEditor=Backbone.Model.extend({defaults(){return{commitMessages:[],changeDescriptionRenderedText:"",closeDescriptionRenderedText:"",commentIssueManager:null,editable:false,editCount:0,hasDraft:false,fileAttachments:null,fileAttachmentComments:{},mutableByUser:false,pendingSaveCount:0,publishing:false,reviewRequest:null,screenshots:null,showSendEmail:false,statusEditable:false,statusMutableByUser:false}},initialize(){const reviewRequest=this.get("reviewRequest");let fileAttachments=this.get("fileAttachments");if(fileAttachments===null){fileAttachments=new Backbone.Collection([],{model:RB.FileAttachment});this.set("fileAttachments",fileAttachments)}this.listenTo(fileAttachments,"add",this._onFileAttachmentOrScreenshotAdded);fileAttachments.each(this._onFileAttachmentOrScreenshotAdded.bind(this));let screenshots=this.get("screenshots");if(screenshots===null){screenshots=new Backbone.Collection([],{model:RB.Screenshot});this.set("screenshots",screenshots)}this.listenTo(screenshots,"add",this._onFileAttachmentOrScreenshotAdded);screenshots.each(this._onFileAttachmentOrScreenshotAdded.bind(this));this.listenTo(reviewRequest.draft,"saving",()=>this.trigger("saving"));this.listenTo(reviewRequest.draft,"saved",()=>this.trigger("saved"));this.listenTo(reviewRequest,"change:state",this._computeEditable);this._computeEditable()},parse(attrs){return _.defaults({commits:new RB.DiffCommitCollection(attrs.commits||[],{parse:true})},attrs)},createFileAttachment(){let attributes=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const draft=this.get("reviewRequest").draft;const fileAttachment=draft.createFileAttachment(attributes);const fileAttachments=this.get("fileAttachments");if(attributes.attachmentHistoryID){const oldAttachment=fileAttachments.findWhere({attachmentHistoryID:attributes.attachmentHistoryID});const index=fileAttachments.indexOf(oldAttachment);fileAttachments.remove(oldAttachment);fileAttachments.add(fileAttachment,{at:index})}else{fileAttachments.add(fileAttachment)}return fileAttachment},getDraftField(fieldName){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};const reviewRequest=this.get("reviewRequest");const draft=reviewRequest.draft;if(options.useExtraData){let data;if(options.useRawTextValue){const rawTextFields=draft.get("rawTextFields");if(rawTextFields&&rawTextFields.extra_data){data=rawTextFields.extra_data}}if(!data){data=draft.get("extraData")}return data[fieldName]}else if(fieldName==="closeDescription"||fieldName==="closeDescriptionRichText"){return reviewRequest.get(fieldName)}else{return draft.get(fieldName)}},setDraftField:function(fieldName,value){let options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};let context=arguments.length>3&&arguments[3]!==undefined?arguments[3]:undefined;const reviewRequest=this.get("reviewRequest");const data={};let jsonFieldName=options.jsonFieldName;console.assert(jsonFieldName,`jsonFieldName must be set when setting draft `+`field "${fieldName}".`);if(options.useExtraData){jsonFieldName=`extra_data.${jsonFieldName}`}if(options.allowMarkdown){let jsonTextTypeFieldName=options.jsonTextTypeFieldName;console.assert(jsonTextTypeFieldName,"jsonTextTypeFieldName must be set.");if(options.useExtraData){jsonTextTypeFieldName=`extra_data.${jsonTextTypeFieldName}`}const richText=!!options.richText;data[jsonTextTypeFieldName]=richText?"markdown":"plain";data.force_text_type="html";data.include_text_types="raw"}data[jsonFieldName]=value;reviewRequest.draft.save({data:data,error:(model,xhr)=>{let message="";this.set("publishing",false);if(_.isFunction(options.error)){const rsp=xhr.errorPayload;if(rsp.fields===undefined){message=xhr.errorText}else{const fieldValue=rsp.fields[jsonFieldName];const fieldValueLen=fieldValue.length;_.each(fieldValue,(value,i)=>{if(i===fieldValueLen-1&&fieldValueLen>1){if(i>2){message+=", "}message+=` and "${value}"`}else{if(i>0){message+=", "}message+=`"${value}"`}});if(fieldName==="targetGroups"){message=interpolate(ngettext("Group %s does not exist.","Groups %s do not exist.",fieldValue.length),[message])}else if(fieldName==="targetPeople"){message=interpolate(ngettext("User %s does not exist.","Users %s do not exist.",fieldValue.length),[message])}else if(fieldName==="submitter"){message=interpolate(gettext("User %s does not exist."),[message])}else if(fieldName==="dependsOn"){message=interpolate(ngettext("Review Request %s does not exist.","Review Requests %s do not exist.",fieldValue.length),[message])}}options.error.call(context,{errorText:message})}},success:()=>{this.set("hasDraft",true);if(_.isFunction(options.success)){options.success.call(context)}this.trigger("fieldChanged:"+fieldName,value);this.trigger("fieldChanged",fieldName,value);if(this.get("publishing")){this.decr("pendingSaveCount");if(this.get("pendingSaveCount")===0){this.set("publishing",false);this.publishDraft()}}}},this)},publishDraft(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const reviewRequest=this.get("reviewRequest");const onError=(model,xhr)=>this.trigger("publishError",xhr.errorText);reviewRequest.draft.ensureCreated({success:()=>{if(reviewRequest.attributes.links.submitter.title!==reviewRequest.draft.attributes.links.submitter.title){if(!confirm(gettext("Are you sure you want to change the ownership of this review request? Doing so may prevent you from editing the review request afterwards."))){return}}reviewRequest.draft.publish({success:()=>this.trigger("published"),error:onError,trivial:options.trivial?1:0},this)},error:onError},this)},incr(attr){const value=this.get(attr);console.assert(_.isNumber(value));this.set(attr,value+1,{validate:true})},decr(attr){const value=this.get(attr);console.assert(_.isNumber(value));this.set(attr,value-1,{validate:true})},validate(attrs){const strings=RB.ReviewRequestEditor.strings;if(_.has(attrs,"editCount")&&attrs.editCount<0){return strings.UNBALANCED_EDIT_COUNT}},_computeEditable(){const state=this.get("reviewRequest").get("state");const pending=state===RB.ReviewRequest.PENDING;this.set({editable:this.get("mutableByUser")&&pending,statusEditable:this.get("statusMutableByUser")&&!pending})},_onFileAttachmentOrScreenshotAdded(attachment){this.listenTo(attachment,"saving",()=>this.trigger("saving"));this.listenTo(attachment,"saved destroy",()=>{this.set("hasDraft",true);this.trigger("saved")})}},{strings:{UNBALANCED_EDIT_COUNT:gettext("There is an internal error balancing the edit count")}});"use strict";RB.ImageReviewable=RB.FileAttachmentReviewable.extend({defaults:_.defaults({imageURL:"",diffAgainstImageURL:"",scale:1},RB.FileAttachmentReviewable.prototype.defaults),commentBlockModel:RB.RegionCommentBlock});"use strict";RB.DummyReviewable=RB.FileAttachmentReviewable.extend({commentBlockModel:RB.AbstractCommentBlock});"use strict";RB.ScreenshotCommentBlock=RB.AbstractCommentBlock.extend({defaults:_.defaults({screenshotID:null,x:null,y:null,width:null,height:null},RB.AbstractCommentBlock.prototype.defaults),canUpdateBounds(){return false},createComment(id){return this.get("review").createScreenshotComment(id,this.get("screenshotID"),this.get("x"),this.get("y"),this.get("width"),this.get("height"))}});"use strict";RB.ScreenshotReviewable=RB.AbstractReviewable.extend({defaults:_.defaults({caption:"",imageURL:"",screenshotID:null},RB.AbstractReviewable.prototype.defaults),commentBlockModel:RB.ScreenshotCommentBlock,defaultCommentBlockFields:["screenshotID"],loadSerializedCommentBlock(serializedCommentBlock){this.createCommentBlock({screenshotID:this.get("screenshotID"),x:serializedCommentBlock[0].x,y:serializedCommentBlock[0].y,width:serializedCommentBlock[0].w,height:serializedCommentBlock[0].h,serializedComments:serializedCommentBlock})}});"use strict";RB.TextCommentBlock=RB.FileAttachmentCommentBlock.extend({defaults:_.defaults({beginLineNum:null,endLineNum:null,viewMode:false,$beginRow:null,$endRow:null},RB.FileAttachmentCommentBlock.prototype.defaults),serializedFields:["beginLineNum","endLineNum","viewMode"],parse(fields){fields.beginLineNum=parseInt(fields.beginLineNum,10);fields.endLineNum=parseInt(fields.endLineNum,10);return fields}});"use strict";RB.TextBasedReviewable=RB.FileAttachmentReviewable.extend({defaults:_.defaults({viewMode:"source",hasRenderedView:false},RB.FileAttachmentReviewable.prototype.defaults),commentBlockModel:RB.TextCommentBlock,defaultCommentBlockFields:["viewMode"].concat(RB.FileAttachmentReviewable.prototype.defaultCommentBlockFields)});"use strict";RB.UploadDiffModel=Backbone.Model.extend({defaults:{basedir:null,changeNumber:null,diffFile:null,diffValid:false,error:null,parentDiffFile:null,repository:null,reviewRequest:null,state:0},State:{PROMPT_FOR_DIFF:0,PROMPT_FOR_BASEDIR:1,PROPMT_FOR_CHANGE_NUMBER:2,PROCESSING_DIFF:3,UPLOADING:4,PROMPT_FOR_PARENT_DIFF:5,ERROR:6},initialize(){Backbone.Model.prototype.initialize.apply(this,arguments);this.on("change:diffFile change:parentDiffFile change:basedir "+"change:changeNumber change:diffValid",this._updateState,this)},startOver(){this.set({basedir:null,changeNumber:null,diffFile:null,diffValid:false,error:null,parentDiffFile:null,state:this.State.PROMPT_FOR_DIFF})},handleFiles(files){switch(this.get("state")){case this.State.PROMPT_FOR_DIFF:this.set("diffFile",files[0]);break;case this.State.PROMPT_FOR_PARENT_DIFF:this.set("parentDiffFile",files[0]);break;default:console.assert("File received in wrong state");break}},_updateState(){const basedir=this.get("basedir");const changeNumber=this.get("changeNumber");const diff=this.get("diffFile");const diffValid=this.get("diffValid");const parentDiff=this.get("parentDiffFile");const repository=this.get("repository");const requiresBasedir=repository.get("requiresBasedir");const requiresChangeNumber=repository.get("requiresChangeNumber");const state=this.get("state");switch(state){case this.State.PROMPT_FOR_DIFF:if(diff){if(requiresBasedir&&!basedir){this.set("state",this.State.PROMPT_FOR_BASEDIR)}else if(requiresChangeNumber&&!changeNumber){this.set("state",this.State.PROMPT_FOR_CHANGE_NUMBER)}else{this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}}break;case this.State.PROMPT_FOR_PARENT_DIFF:if(diff&&parentDiff){this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}break;case this.State.PROMPT_FOR_BASEDIR:console.assert(diff,"cannot be in basedir prompt state without a diff");if(basedir){if(requiresChangeNumber&&!changeNumber){this.set("state",this.State.PROMPT_FOR_CHANGE_NUMBER)}else{this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}}break;case this.State.PROMPT_FOR_CHANGE_NUMBER:console.assert(diff,"cannot be in changenum prompt state without a diff");if(changeNumber){this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}break;case this.State.PROCESSING_DIFF:if(diffValid){this.set("state",this.State.UPLOADING);if(this.get("reviewRequest")===null){this._createReviewRequest()}else{this._createDiff()}}break;case this.State.UPLOADING:break;case this.State.ERROR:break}},_tryValidate(){this.set("diffValid",false);const diff=this.get("diffFile");console.assert(diff);const parentDiff=this.get("parentDiffFile");const repository=this.get("repository");const uploader=new RB.ValidateDiffModel;uploader.set({repository:repository.get("id"),localSitePrefix:repository.get("localSitePrefix"),basedir:this.get("basedir"),diff:diff,parentDiff:parentDiff});uploader.save({success:_.bind(this._onValidateSuccess,this),error:_.bind(this._onValidateError,this)})},_onValidateSuccess(){this.set("diffValid",true)},_onValidateError(model,xhr){const rsp=$.parseJSON(xhr.responseText);let newState=this.State.ERROR;let error;if(rsp!==null){switch(rsp.err.code){case RB.APIErrors.REPO_FILE_NOT_FOUND:if(this.get("repository").get("scmtoolName")==="Git"&&rsp.revision.length!==40){error=gettext("The uploaded diff uses short revisions, but Review Board requires full revisions.<br />Please generate a new diff using the <code>--full-index</code> parameter.")}else{error=interpolate(gettext('The file "%(file)s" (revision %(revision)s) was not found in the repository.'),{file:rsp.file,revision:rsp.revision},true);if(this.get("parentDiffFile")===null){newState=this.State.PROMPT_FOR_PARENT_DIFF}}break;case RB.APIErrors.DIFF_PARSE_ERROR:error=interpolate(gettext("%(error)s<br />Line %(line)s: %(reason)s"),{error:rsp.err.msg,line:rsp.linenum,reason:rsp.reason},true);break;default:error=rsp.err.msg;break}}else{error=gettext("Unknown error")}if(error){this.set({state:newState,error:error})}},_createReviewRequest(){const repository=this.get("repository");const reviewRequest=new RB.ReviewRequest({commitID:this.get("changeNumber"),localSitePrefix:repository.get("localSitePrefix"),repository:repository.get("id")});reviewRequest.save({success:()=>{this.set("reviewRequest",reviewRequest);this._createDiff()},error:this._onValidateError.bind(this)})},_createDiff(){const reviewRequest=this.get("reviewRequest");const diff=reviewRequest.createDiff();diff.set({basedir:this.get("basedir"),diff:this.get("diffFile"),parentDiff:this.get("parentDiffFile")});diff.url=reviewRequest.get("links").diffs.href;diff.save({success:()=>{window.location=reviewRequest.get("reviewURL")},error:this._onValidateError.bind(this)})}});"use strict";RB.ReviewablePage=RB.Page.extend({defaults:_.defaults({checkForUpdates:false,checkUpdatesType:null,lastActivityTimestamp:null,pendingReview:null,reviewRequest:null},RB.Page.prototype.defaults),initialize(attributes){RB.Page.prototype.initialize.apply(this,arguments);const reviewRequest=this.get("reviewRequest");console.assert(reviewRequest,"The reviewRequest attribute or parse=true must be provided.");console.assert(this.get("pendingReview"),"The pendingReview attribute or parse=true must be provided.");this.commentIssueManager=new RB.CommentIssueManager({reviewRequest:reviewRequest});const editorData=attributes.editorData||{};const fileAttachments=new Backbone.Collection(_.map(editorData.fileAttachments,editorData.mutableByUser?attrs=>reviewRequest.draft.createFileAttachment(attrs):attrs=>reviewRequest.createFileAttachment(attrs)),{model:RB.FileAttachment});this.reviewRequestEditor=new RB.ReviewRequestEditor(_.defaults({commentIssueManager:this.commentIssueManager,reviewRequest:reviewRequest,fileAttachments:fileAttachments},editorData),{parse:true});this.listenTo(reviewRequest,"updated",info=>this.trigger("reviewRequestUpdated",info));if(this.get("checkForUpdates")){this._registerForUpdates()}},markShipIt(){const pendingReview=this.get("pendingReview");pendingReview.ready({ready(){pendingReview.set({shipIt:true,bodyTop:gettext("Ship It!")});pendingReview.publish()}})},parse(rsp){let reviewRequestData;if(rsp.reviewRequestData){reviewRequestData=_.defaults({state:RB.ReviewRequest[rsp.reviewRequestData.state],visibility:RB.ReviewRequest["VISIBILITY_"+rsp.reviewRequestData.visibility]},rsp.reviewRequestData);if(reviewRequestData.repository){reviewRequestData.repository=new RB.Repository(_.defaults({localSitePrefix:rsp.reviewRequestData.localSitePrefix},rsp.reviewRequestData.repository))}}const reviewRequest=new RB.ReviewRequest(reviewRequestData,{extraDraftAttrs:rsp.extraReviewRequestDraftData});return{reviewRequest:reviewRequest,pendingReview:reviewRequest.createReview(),lastActivityTimestamp:rsp.lastActivityTimestamp,checkForUpdates:rsp.checkForUpdates,checkUpdatesType:rsp.checkUpdatesType}},_registerForUpdates(){this.get("reviewRequest").beginCheckForUpdates(this.get("checkUpdatesType"),this.get("lastActivityTimestamp"))}});"use strict";RB.DiffViewerPage=RB.ReviewablePage.extend({defaults:_.defaults({canDownloadDiff:false,filenamePatterns:null,numDiffs:1},RB.ReviewablePage.prototype.defaults),constructor:function constructor(){this.commentsHint=new RB.DiffCommentsHint;this.commits=new RB.DiffCommitCollection;this.commitHistoryDiff=new RB.CommitHistoryDiffEntryCollection;this.files=new RB.DiffFileCollection;this.pagination=new RB.Pagination;this.revision=new RB.DiffRevision;RB.ReviewablePage.apply(this,arguments)},initialize(){RB.ReviewablePage.prototype.initialize.apply(this,arguments);this.diffReviewables=new RB.DiffReviewableCollection([],{reviewRequest:this.get("reviewRequest")});this.diffReviewables.watchFiles(this.files)},parse(rsp){return _.extend(this._parseDiffContext(rsp),RB.ReviewablePage.prototype.parse.call(this,rsp))},loadDiffRevision(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const reviewRequestURL=this.get("reviewRequest").url();const queryData=[];if(options.revision){queryData.push({name:"revision",value:options.revision})}if(options.interdiffRevision){queryData.push({name:"interdiff-revision",value:options.interdiffRevision})}else{if(options.baseCommitID){queryData.push({name:"base-commit-id",value:options.baseCommitID})}if(options.tipCommitID){queryData.push({name:"tip-commit-id",value:options.tipCommitID})}}if(options.page&&options.page!==1){queryData.push({name:"page",value:options.page})}if(options.filenamePatterns){queryData.push({name:"filenames",value:options.filenamePatterns})}const url=Djblets.buildURL({baseURL:`${reviewRequestURL}diff-context/`,queryData:queryData});$.ajax(url).done(rsp=>this.set(this._parseDiffContext(rsp.diff_context)))},_parseDiffContext(rsp){if(rsp.comments_hint){this.commentsHint.set(this.commentsHint.parse(rsp.comments_hint))}if(rsp.files){this.files.reset(rsp.files,{parse:true})}if(rsp.pagination){this.pagination.set(this.pagination.parse(rsp.pagination))}if(rsp.revision){this.revision.set(this.revision.parse(rsp.revision))}this.commitHistoryDiff.reset(rsp.commit_history_diff||[],{parse:true});if(rsp.commits){this.commits.reset(rsp.commits,{parse:true})}return{canDownloadDiff:rsp.revision&&rsp.revision.interdiff_revision===null,filenamePatterns:rsp.filename_patterns||null,numDiffs:rsp.num_diffs||0}}});"use strict";(function(){const UpdatesBubbleView=Backbone.View.extend({id:"updates-bubble",template:_.template(['<span id="updates-bubble-summary"><%- summary %></span>'," by ",'<a href="<%- user.url %>" id="updates-bubble-user">',"<%- user.fullname || user.username %>","</a>",'<span id="updates-bubble-buttons">',' <a href="#" class="update-page"><%- updatePageText %></a>'," | ",' <a href="#" class="ignore"><%- ignoreText %></a>'].join("")),events:{"click .update-page":"_onUpdatePageClicked","click .ignore":"_onIgnoreClicked"},initialize(options){this.options=options},render(){this.$el.html(this.template(_.defaults({updatePageText:gettext("Update Page"),ignoreText:gettext("Ignore")},this.options.updateInfo))).hide();return this},open(){this.$el.css("position","fixed").fadeIn()},close(){this.trigger("closed");this.$el.fadeOut(_.bind(this.remove,this))},_onUpdatePageClicked(e){e.preventDefault();e.stopPropagation();this.trigger("updatePage")},_onIgnoreClicked(e){e.preventDefault();e.stopPropagation();this.close()}});RB.ReviewablePageView=RB.PageView.extend({events:_.defaults({"click #review-action":"_onEditReviewClicked","click #ship-it-action":"_onShipItClicked","click #general-comment-action":"_onAddCommentClicked","click .has-menu .has-menu":"_onMenuClicked"},RB.PageView.prototype.events),initialize(options){RB.PageView.prototype.initialize.apply(this,arguments);this.options=options;RB.DnDUploader.create();this.reviewRequestEditorView=new RB.ReviewRequestEditorView({el:$("#review-request"),model:this.model.reviewRequestEditor});this._updatesBubble=null;this._favIconURL=null;this._favIconNotifyURL=null;this._logoNotificationsURL=null;["reviewRequest","pendingReview"].forEach(attrName=>{this[attrName]=this.model.get(attrName);this.listenTo(this.model,`change:${attrName}`,()=>{this[attrName]=this.model.get(attrName)})});RB.NotificationManager.instance.setup();if(RB.UserSession.instance.get("authenticated")){this._starManager=new RB.StarManagerView({model:new RB.StarManager,el:this.$(".star").parent()})}this.listenTo(this.model,"reviewRequestUpdated",this._onReviewRequestUpdated)},render(){RB.PageView.prototype.render.call(this);const $favicon=$("head").find('link[rel="shortcut icon"]');this._favIconURL=$favicon.attr("href");this._favIconNotifyURL=STATIC_URLS["rb/images/favicon_notify.ico"];this._logoNotificationsURL=STATIC_URLS["rb/images/logo.png"];const pendingReview=this.model.get("pendingReview");this.draftReviewBanner=RB.DraftReviewBannerView.create({el:$("#review-banner"),model:pendingReview,reviewRequestEditor:this.model.reviewRequestEditor});this.listenTo(pendingReview,"destroy published",()=>this.draftReviewBanner.hideAndReload());this.reviewRequestEditorView.render();return this},remove(){this.draftReviewBanner.remove();_super(this).remove.call(this)},_onReviewRequestUpdated(info){this._updateFavIcon(this._favIconNotifyURL);if(RB.NotificationManager.instance.shouldNotify()){this._showDesktopNotification(info)}this._showUpdatesBubble(info)},_showUpdatesBubble(info){if(this._updatesBubble){this._updatesBubble.remove()}const reviewRequest=this.model.get("reviewRequest");this._updatesBubble=new UpdatesBubbleView({updateInfo:info,reviewRequest:reviewRequest});this.listenTo(this._updatesBubble,"closed",()=>this._updateFavIcon(this._favIconURL));this.listenTo(this._updatesBubble,"updatePage",()=>{window.location=reviewRequest.get("reviewURL")});this._updatesBubble.render().$el.appendTo(this.$el);this._updatesBubble.open()},_showDesktopNotification(info){const reviewRequest=this.model.get("reviewRequest");RB.NotificationManager.instance.notify({title:info.summary,body:interpolate(gettext("Review request #%s, by %s"),[reviewRequest.id,info.user.fullname||info.user.username]),iconURL:this._logoNotificationsURL,onClick:()=>{window.location=reviewRequest.get("reviewURL")}})},_updateFavIcon(url){$("head").find('link[rel="shortcut icon"]').remove().end().append($("<link/>").attr({href:url,rel:"shortcut icon",type:"image/x-icon"}))},_onEditReviewClicked(){RB.ReviewDialogView.create({review:this.model.get("pendingReview"),reviewRequestEditor:this.model.reviewRequestEditor});return false},_onAddCommentClicked(){const pendingReview=this.model.get("pendingReview");const comment=pendingReview.createGeneralComment(undefined,RB.UserSession.instance.get("commentsOpenAnIssue"));this.listenTo(comment,"saved",()=>RB.DraftReviewBannerView.instance.show());RB.CommentDialogView.create({comment:comment,reviewRequestEditor:this.model.reviewRequestEditor});return false},_onShipItClicked(){if(confirm(gettext("Are you sure you want to post this review?"))){this.model.markShipIt()}return false},_onMenuClicked(e){e.preventDefault();e.stopPropagation()}})})();"use strict";RB.DiffViewerPageView=RB.ReviewablePageView.extend({SCROLL_BACKWARD:-1,SCROLL_FORWARD:1,ANCHOR_COMMENT:1,ANCHOR_FILE:2,ANCHOR_CHUNK:4,DIFF_SCROLLDOWN_AMOUNT:15,keyBindings:{"aAKP<m":"_selectPreviousFile","fFJN>":"_selectNextFile","sSkp,":"_selectPreviousDiff","dDjn.":"_selectNextDiff","[x":"_selectPreviousComment","]c":"_selectNextComment","\r":"_recenterSelected",rR:"_createComment"},events:_.extend({"click .toggle-whitespace-only-chunks":"_toggleWhitespaceOnlyChunks","click .toggle-show-whitespace":"_toggleShowExtraWhitespace"},RB.ReviewablePageView.prototype.events),_fileEntryTemplate:_.template(`<div class="diff-container">
 <div class="diff-box">
  <table class="sidebyside loading <% if (newFile) { %>newfile<% } %>"
         id="file_container_<%- id %>">
   <thead>
    <tr class="filename-row">
     <th>
      <span class="fa fa-spinner fa-pulse"></span>
      <%- filename %>
     </th>
    </tr>
   </thead>
  </table>
 </div>
</div>`),anchorTemplate:_.template('<a name="<%- anchorName %>" class="highlight-anchor"></a>'),initialize(options){RB.ReviewablePageView.prototype.initialize.call(this,options);this._selectedAnchorIndex=-1;this._$window=$(window);this._$anchors=$();this._$controls=null;this._$diffs=null;this._diffReviewableViews=[];this._diffFileIndexView=null;this._highlightedChunk=null;this._commitListView=null;this.listenTo(this.model.diffReviewables,"add",this._onDiffReviewableAdded);const diffQueue=$.funcQueue("diff_files");this.listenTo(this.model.diffReviewables,"populating",()=>{this._diffReviewableViews.forEach(view=>view.remove());this._diffReviewableViews=[];this._$diffs.children(".diff-container").remove();this._highlightedChunk=null;diffQueue.clear()});this.listenTo(this.model.diffReviewables,"populated",()=>diffQueue.start());this.router=new Backbone.Router;this.router.route(/^(\d+(?:-\d+)?)\/?(\?[^#]*)?/,"revision",(revision,queryStr)=>{const queryArgs=Djblets.parseQueryString(queryStr||"");const page=queryArgs.page;const revisionRange=revision.split("-",2);const interdiffRevision=revisionRange.length===2?parseInt(revisionRange[1],10):null;let baseCommitID=null;let tipCommitID=null;if(interdiffRevision===null){baseCommitID=queryArgs["base-commit-id"]||null;tipCommitID=queryArgs["tip-commit-id"]||null;if(baseCommitID!==null){baseCommitID=parseInt(baseCommitID,10)}if(tipCommitID!==null){tipCommitID=parseInt(tipCommitID,10)}}this.model.loadDiffRevision({page:page?parseInt(page,10):1,filenamePatterns:queryArgs.filenames||null,revision:parseInt(revisionRange[0],10),interdiffRevision:interdiffRevision,baseCommitID:baseCommitID,tipCommitID:tipCommitID})});Backbone.history.start({pushState:true,hashChange:false,root:`${this.model.get("reviewRequest").get("reviewURL")}diff/`,silent:true});this._setInitialURL(document.location.search||"",RB.getLocationHash())},remove(){RB.ReviewablePageView.prototype.remove.call(this);this._$window.off(`resize.${this.cid}`);this._diffFileIndexView.remove();if(this._commitListView){this._commitListView.remove()}},render(){RB.ReviewablePageView.prototype.render.call(this);this._$controls=$("#view_controls");if(!this.model.commits.isEmpty()){const commitListModel=new RB.DiffCommitList({commits:this.model.commits,historyDiff:this.model.commitHistoryDiff,baseCommitID:this.model.revision.get("baseCommitID"),tipCommitID:this.model.revision.get("tipCommitID")});this.listenTo(this.model.revision,"change:baseCommitID change:tipCommitID",model=>commitListModel.set({baseCommitID:model.get("baseCommitID"),tipCommitID:model.get("tipCommitID")}));this.listenTo(commitListModel,"change:baseCommitID change:tipCommitID",this._onCommitIntervalChanged);this._commitListView=new RB.DiffCommitListView({el:$("#diff_commit_list").find(".commit-list-container"),model:commitListModel,showInterCommitDiffControls:true});this._commitListView.render()}this._diffFileIndexView=new RB.DiffFileIndexView({el:$("#diff_index").find(".diff-index-container"),collection:this.model.files});this._diffFileIndexView.render();this.listenTo(this._diffFileIndexView,"anchorClicked",this.selectAnchorByName);this._diffRevisionLabelView=new RB.DiffRevisionLabelView({el:$("#diff_revision_label"),model:this.model.revision});this._diffRevisionLabelView.render();this.listenTo(this._diffRevisionLabelView,"revisionSelected",this._onRevisionSelected);const numDiffs=this.model.get("numDiffs");if(numDiffs>1){this._diffRevisionSelectorView=new RB.DiffRevisionSelectorView({el:$("#diff_revision_selector"),model:this.model.revision,numDiffs:numDiffs});this._diffRevisionSelectorView.render();this.listenTo(this._diffRevisionSelectorView,"revisionSelected",this._onRevisionSelected)}this._commentsHintView=new RB.DiffCommentsHintView({el:$("#diff_comments_hint"),model:this.model.commentsHint});this._commentsHintView.render();this.listenTo(this._commentsHintView,"revisionSelected",this._onRevisionSelected);this._paginationView1=new RB.PaginationView({el:$("#pagination1"),model:this.model.pagination});this._paginationView1.render();this.listenTo(this._paginationView1,"pageSelected",_.partial(this._onPageSelected,false));this._paginationView2=new RB.PaginationView({el:$("#pagination2"),model:this.model.pagination});this._paginationView2.render();this.listenTo(this._paginationView2,"pageSelected",_.partial(this._onPageSelected,true));this._$diffs=$("#diffs").bindClass(RB.UserSession.instance,"diffsShowExtraWhitespace","ewhl");this._chunkHighlighter=new RB.ChunkHighlighterView;this._chunkHighlighter.render().$el.prependTo(this._$diffs);$("#diff-details").removeClass("loading");$("#download-diff-action").bindVisibility(this.model,"canDownloadDiff");this._$window.on(`resize.${this.cid}`,_.throttleLayout(this._onWindowResize.bind(this)));if(this.model.diffReviewables.length>0){this.model.diffReviewables.each(diffReviewable=>this._onDiffReviewableAdded(diffReviewable));$.funcQueue("diff_files").start()}return this},queueLoadDiff(diffReviewable){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};$.funcQueue("diff_files").add(()=>{const fileDiffID=diffReviewable.get("fileDiffID");if(!options.showDeleted&&$(`#file${fileDiffID}`).length===1){this._renderFileDiff(diffReviewable)}else{const prefix=options.showDeleted?"#file":"#file_container_";diffReviewable.getRenderedDiff({complete:xhr=>{const $container=$(prefix+fileDiffID).parent();if($container.length===0){return}$container.hide();$container[0].innerHTML=xhr.responseText;this._renderFileDiff(diffReviewable)}},this,options)}})},_renderFileDiff(diffReviewable){const elementName="file"+diffReviewable.get("fileDiffID");const $el=$(`#${elementName}`);if($el.length===0){$.funcQueue("diff_files").next();return}const diffReviewableView=new RB.DiffReviewableView({el:$el,model:diffReviewable});this._diffFileIndexView.addDiff(this._diffReviewableViews.length,diffReviewableView);this._diffReviewableViews.push(diffReviewableView);diffReviewableView.render();diffReviewableView.$el.parent().show();this.listenTo(diffReviewableView,"fileClicked",()=>{this.selectAnchorByName(diffReviewable.get("file").get("index"))});this.listenTo(diffReviewableView,"chunkClicked",name=>{this.selectAnchorByName(name,false)});this.listenTo(diffReviewableView,"moveFlagClicked",line=>{this.selectAnchor(this.$(`a[target=${line}]`))});this._updateAnchors(diffReviewableView.$el);this.listenTo(diffReviewableView,"chunkExpansionChanged",()=>{this._highlightAnchor($(this._$anchors[this._selectedAnchorIndex]))});if(this._startAtAnchorName){let $anchor=$(document.getElementsByName(this._startAtAnchorName));const urlSplit=this._startAtAnchorName.split(",");if($anchor.length===0&&urlSplit.length===2&&elementName===urlSplit[0]){$anchor=$(this.anchorTemplate({anchorName:this._startAtAnchorName}));diffReviewableView.$el.find(`tr[line='${urlSplit[1]}']`).addClass("highlight-anchor").append($anchor)}if($anchor.length!==0){this.selectAnchor($anchor);this._startAtAnchorName=null}}this.listenTo(diffReviewableView,"showDeletedClicked",()=>{this.queueLoadDiff(diffReviewable,{showDeleted:true});$.funcQueue("diff_files").start()});$.funcQueue("diff_files").next()},selectAnchor($anchor,scroll){if(!$anchor||$anchor.length===0||$anchor.parent().is(":hidden")){return false}if(scroll!==false){this._navigate({anchor:$anchor.attr("name"),updateURLOnly:true});let scrollAmount=this.DIFF_SCROLLDOWN_AMOUNT;if(RB.DraftReviewBannerView.instance){scrollAmount+=RB.DraftReviewBannerView.instance.getHeight()}this._$window.scrollTop($anchor.offset().top-scrollAmount)}this._highlightAnchor($anchor);for(let i=0;i<this._$anchors.length;i++){if(this._$anchors[i]===$anchor[0]){this._selectedAnchorIndex=i;break}}return true},selectAnchorByName(name,scroll){return this.selectAnchor($(document.getElementsByName(name)),scroll)},_highlightAnchor($anchor){this._highlightedChunk=$anchor.closest("tbody").add($anchor.closest("thead"));this._chunkHighlighter.highlight(this._highlightedChunk)},_updateAnchors($table){this._$anchors=this._$anchors.add($table.find("th a[name]"));if(this._selectedAnchorIndex===-1&&this._$anchors.length>0){this._selectedAnchorIndex=0;this._highlightAnchor($(this._$anchors[this._selectedAnchorIndex]))}},_getNextAnchor(dir,anchorTypes){for(let i=this._selectedAnchorIndex+dir;i>=0&&i<this._$anchors.length;i+=dir){const $anchor=$(this._$anchors[i]);if($anchor.closest("tr").hasClass("dimmed")){continue}if(anchorTypes&this.ANCHOR_COMMENT&&$anchor.hasClass("commentflag-anchor")||anchorTypes&this.ANCHOR_FILE&&$anchor.hasClass("file-anchor")||anchorTypes&this.ANCHOR_CHUNK&&$anchor.hasClass("chunk-anchor")){return $anchor}}return null},_selectPreviousFile(){this.selectAnchor(this._getNextAnchor(this.SCROLL_BACKWARD,this.ANCHOR_FILE))},_selectNextFile(){this.selectAnchor(this._getNextAnchor(this.SCROLL_FORWARD,this.ANCHOR_FILE))},_selectPreviousDiff(){this.selectAnchor(this._getNextAnchor(this.SCROLL_BACKWARD,this.ANCHOR_CHUNK|this.ANCHOR_FILE))},_selectNextDiff(){this.selectAnchor(this._getNextAnchor(this.SCROLL_FORWARD,this.ANCHOR_CHUNK|this.ANCHOR_FILE))},_selectPreviousComment(){this.selectAnchor(this._getNextAnchor(this.SCROLL_BACKWARD,this.ANCHOR_COMMENT))},_selectNextComment(){this.selectAnchor(this._getNextAnchor(this.SCROLL_FORWARD,this.ANCHOR_COMMENT))},_recenterSelected(){this.selectAnchor($(this._$anchors[this._selectedAnchorIndex]))},_createComment(){const chunkID=this._highlightedChunk[0].id;const chunkElement=document.getElementById(chunkID);if(chunkElement){const lineElements=chunkElement.getElementsByTagName("tr");const beginLineNum=lineElements[0].getAttribute("line");const beginNode=lineElements[0].cells[2];const endLineNum=lineElements[lineElements.length-1].getAttribute("line");const endNode=lineElements[lineElements.length-1].cells[2];this._diffReviewableViews.forEach(diffReviewableView=>{if($.contains(diffReviewableView.el,beginNode)){diffReviewableView.createComment(beginLineNum,endLineNum,beginNode,endNode)}})}},_toggleWhitespaceOnlyChunks(){this._diffReviewableViews.forEach(view=>view.toggleWhitespaceOnlyChunks());this._$controls.find(".ws").toggle();return false},_toggleShowExtraWhitespace(){this._$controls.find(".ew").toggle();RB.UserSession.instance.toggleAttr("diffsShowExtraWhitespace");return false},_setInitialURL(queryString,anchor){this._startAtAnchorName=anchor||null;this._navigate({queryString:queryString,anchor:anchor,updateURLOnly:true})},_navigate(options){const curRevision=this.model.revision.get("revision");const curInterdiffRevision=this.model.revision.get("interdiffRevision");const revision=options.revision!==undefined?options.revision:curRevision;const interdiffRevision=options.interdiffRevision!==undefined?options.interdiffRevision:curInterdiffRevision;let baseURL=revision;if(interdiffRevision){baseURL+=`-${interdiffRevision}`}baseURL+="/";let queryData=options.queryString;if(queryData===undefined){queryData=[];let page=options.page;if(page===undefined&&revision===curRevision&&interdiffRevision===curInterdiffRevision){page=this.model.pagination.get("currentPage")}if(page&&page!==1){queryData.push({name:"page",value:page})}if(options.baseCommitID){queryData.push({name:"base-commit-id",value:options.baseCommitID})}if(options.tipCommitID){queryData.push({name:"tip-commit-id",value:options.tipCommitID})}const filenamePatterns=this.model.get("filenamePatterns");if(filenamePatterns&&filenamePatterns.length>0){queryData.push({name:"filenames",value:filenamePatterns})}}const url=Djblets.buildURL({baseURL:baseURL,queryData:queryData,anchor:options.anchor});let navOptions;if(options.updateURLOnly){navOptions={replace:true,trigger:false}}else{navOptions={trigger:true}}this.router.navigate(url,navOptions)},_onDiffReviewableAdded(diffReviewable){const file=diffReviewable.get("file");this._$diffs.append(this._fileEntryTemplate({id:file.id,newFile:file.get("isnew"),filename:file.get("depotFilename")}));this.queueLoadDiff(diffReviewable)},_onWindowResize(){for(let i=0;i<this._diffReviewableViews.length;i++){this._diffReviewableViews[i].updateLayout()}this._chunkHighlighter.updateLayout()},_onRevisionSelected(revisions){let base=revisions[0];let tip=revisions[1];if(base===0){base=tip;tip=null}this._navigate({revision:base,interdiffRevision:tip})},_onPageSelected(scroll,page){if(scroll){this.selectAnchorByName("index_header",true)}this._navigate({page:page})},_onCommitIntervalChanged(model){this._navigate({baseCommitID:model.get("baseCommitID"),tipCommitID:model.get("tipCommitID")})}});_.extend(RB.DiffViewerPageView.prototype,RB.KeyBindingsMixin);"use strict";RB.formatText=function($el){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(options.richText){if(options.newText!==undefined){$el.html(options.newText)}$el.addClass("rich-text").find("a").attr("target","_blank");RB.LinkifyUtils.linkifyChildren($el[0],options.bugTrackerURL)}else if(options.newText!==undefined){$el.html(RB.LinkifyUtils.linkifyText(options.newText||"",options.bugTrackerURL,options.isHTMLEncoded)).removeClass("rich-text")}else if($el!==undefined&&$el.length!==0){RB.LinkifyUtils.linkifyChildren($el[0],options.bugTrackerURL)}};"use strict";RB.AbstractCommentBlockView=Backbone.View.extend({events:{click:"_onClicked"},tooltipSides:"lrbt",dispose(){this.trigger("removing");this.remove();this._$tooltip.remove()},render(){this._$tooltip=$.tooltip(this.$el,{side:this.tooltipSides}).addClass("comments");this.renderContent();this.model.on("change:draftComment",this._onDraftCommentChanged,this);this._onDraftCommentChanged();this._updateTooltip();return this},hideTooltip(){this._$tooltip.hide()},positionCommentDlg(commentDlg){commentDlg.positionBeside(this.$el,{side:"r",fitOnScreen:true})},positionNotifyBubble($bubble){$bubble.move(Math.round((this.$el.width()-$bubble.width())/2),Math.round((this.$el.height()-$bubble.height())/2))},notify(text,cb,context){const $bubble=$('<div class="bubble">').css("opacity",0).appendTo(this.$el).text(text);this.positionNotifyBubble($bubble);$bubble.animate({top:"-=10px",opacity:.8},350,"swing").delay(1200).animate({top:"+=10px",opacity:0},350,"swing",()=>{$bubble.remove();if(_.isFunction(cb)){cb.call(context)}})},_updateTooltip(){const $list=$("<ul/>");const draftComment=this.model.get("draftComment");const tooltipTemplate=_.template(`<li>
 <div class="reviewer">
  <%- user %>:
 </div>
 <pre class="rich-text"><%= html %></pre>
</li>`);if(draftComment){$(tooltipTemplate({user:RB.UserSession.instance.get("fullName"),html:draftComment.get("html")})).addClass("draft").appendTo($list)}this.model.get("serializedComments").forEach(comment=>{$(tooltipTemplate({user:comment.user.name,html:comment.html})).appendTo($list)});this._$tooltip.empty().append($list)},_onDraftCommentChanged(){const comment=this.model.get("draftComment");if(!comment){this.$el.removeClass("draft");return}comment.on("change:text",this._updateTooltip,this);comment.on("destroy",()=>{this.notify(gettext("Comment Deleted"),()=>{if(this.model.isEmpty()){this.$el.fadeOut(350,()=>this.dispose())}else{this.$el.removeClass("draft");this._updateTooltip()}})});comment.on("saved",options=>{this._updateTooltip();if(!options.boundsUpdated){this.notify(gettext("Comment Saved"))}RB.DraftReviewBannerView.instance.show()});this.$el.addClass("draft")},_onClicked(){this.trigger("clicked")}});"use strict";RB.AbstractReviewableView=Backbone.View.extend({commentBlockView:null,commentsListName:null,initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};console.assert(this.commentBlockView,"commentBlockView must be defined by the subclass");console.assert(this.commentsListName,"commentsListName must be defined by the subclass");this.commentDlg=null;this._activeCommentBlock=null;this.renderedInline=options.renderedInline||false},render(){this.renderContent();this.model.commentBlocks.each(this._addCommentBlockView,this);this.model.commentBlocks.on("add",this._addCommentBlockView,this);return this},renderContent(){},createAndEditCommentBlock(options){if(this.commentDlg!==null&&this.commentDlg.model.get("dirty")&&!confirm(gettext("You are currently editing another comment. Would you like to discard it and create a new one?"))){return}let defaultCommentBlockFields=_.result(this.model,"defaultCommentBlockFields");if(defaultCommentBlockFields.length===0&&this.model.reviewableIDField){console.log("Deprecation notice: Reviewable subclass is missing "+"defaultCommentBlockFields. Rename reviewableIDField "+"to defaultCommentBlockFields, and make it a list.");defaultCommentBlockFields=[this.model.reviewableIDField]}this.once("commentBlockViewAdded",commentBlockView=>this.showCommentDlg(commentBlockView));_.extend(options,_.pick(this.model.attributes,defaultCommentBlockFields));this.model.createCommentBlock(options)},showCommentDlg(commentBlockView){const commentBlock=commentBlockView.model;commentBlock.ensureDraftComment();if(this._activeCommentBlock===commentBlock){return}this.stopListening(this.commentDlg,"closed");this.commentDlg=RB.CommentDialogView.create({comment:commentBlock.get("draftComment"),publishedComments:commentBlock.get("serializedComments"),publishedCommentsType:this.commentsListName,position:dlg=>commentBlockView.positionCommentDlg(dlg)});this._activeCommentBlock=commentBlock;this.listenTo(this.commentDlg,"closed",()=>{this.commentDlg=null;this._activeCommentBlock=null})},_addCommentBlockView(commentBlock){const commentBlockView=new this.commentBlockView({model:commentBlock});commentBlockView.on("clicked",()=>this.showCommentDlg(commentBlockView));commentBlockView.render();this.trigger("commentBlockViewAdded",commentBlockView)}});"use strict";(function(){const CommentsListView=Backbone.View.extend({itemTemplate:_.template(`<li class="<%= itemClass %>">
 <h2>
  <%- comment.user.name %>
  <span class="actions">
   <a class="comment-list-view-action" href="<%= comment.url %>"><%- viewText %></a>
   <a class="comment-list-reply-action"
      href="<%= reviewRequestURL %>?reply_id=<%= comment.reply_to_id || comment.comment_id %>&reply_type=<%= replyType %>"
      ><%- replyText %></a>
  </span>
 </h2>
 <pre><%- comment.text %></pre>
</li>`),initialize(options){this.options=options},setComments(comments,replyType){if(comments.length===0){return}const reviewRequestURL=this.options.reviewRequestURL;const commentIssueManager=this.options.commentIssueManager;const interactive=this.options.issuesInteractive;let odd=true;let $items=$();_.each(comments,serializedComment=>{const commentID=serializedComment.comment_id;const $item=$(this.itemTemplate({comment:serializedComment,itemClass:odd?"odd":"even",reviewRequestURL:reviewRequestURL,replyText:CommentsListView._replyText,replyType:replyType,viewText:CommentsListView._viewText}));if(serializedComment.issue_opened){const commentIssueBar=new RB.CommentIssueBarView({reviewID:serializedComment.review_id,commentID:commentID,commentType:replyType,issueStatus:serializedComment.issue_status,interactive:interactive,commentIssueManager:commentIssueManager});commentIssueBar.render().$el.appendTo($item);this.listenTo(commentIssueManager,"issueStatusUpdated",comment=>{if(comment.id===commentID){serializedComment.issue_status=comment.get("issueStatus")}})}$items=$items.add($item);odd=!odd});this.$el.empty().append($items)}},{_replyText:gettext("Reply"),_viewText:gettext("View")});RB.CommentDialogView=Backbone.View.extend({DIALOG_TOTAL_HEIGHT:350,DIALOG_NON_EDITABLE_HEIGHT:120,DIALOG_READ_ONLY_HEIGHT:104,SLIDE_DISTANCE:10,COMMENTS_BOX_WIDTH:280,FORM_BOX_WIDTH:450,className:"comment-dlg",template:_.template(`<div class="other-comments">
 <h1 class="title"><%- otherReviewsText %></h1>
 <ul></ul>
</div>
<form method="post">
 <h1 class="comment-dlg-header">
  <span class="title"></span>
  <% if (authenticated && !hasDraft) { %>
   <a class="markdown-info" href="<%- markdownDocsURL %>"
      target="_blank"><%- markdownText %></a>
  <% } %>
 </h1>
 <% if (!authenticated) { %>
  <p class="login-text"><%= loginText %></p>
 <% } else if (readOnly) { %>
  <p class="read-only-text"><%= readOnlyText %></p>
 <% } else if (hasDraft) { %>
  <p class="draft-warning"><%= draftWarning %></p>
 <% } %>
 <div class="comment-dlg-body">
  <div class="comment-text-field"></div>
  <ul class="comment-dlg-options">
   <li class="comment-issue-options">
    <input type="checkbox" id="comment_issue">
    <label for="comment_issue" accesskey="i"><%= openAnIssueText %></label>
    <% if (showVerify) { %>
     <input type="checkbox" id="comment_issue_verify">
     <label for="comment_issue_verify"><%= verifyIssueText %></label>
    <% } %>
   </li>
   <li class="comment-markdown-options">
    <input type="checkbox" id="enable_markdown">
    <label for="enable_markdown" accesskey="m"><%= enableMarkdownText %></label>
   </li>
  </ul>
 </div>
 <div class="comment-dlg-footer">
  <div class="buttons">
   <input type="button" class="save" value="<%- saveButton %>"
          disabled="true">
   <input type="button" class="cancel" value="<%- cancelButton %>">
   <input type="button" class="delete" value="<%- deleteButton %>"
          disabled="true">
   <input type="button" class="close" value="<%- closeButton %>">
  </div>
 </div>
</form>`),events:{"click .buttons .cancel":"_onCancelClicked","click .buttons .close":"_onCancelClicked","click .buttons .delete":"_onDeleteClicked","click .buttons .save":"save","keydown .comment-text-field":"_onTextKeyDown"},initialize(options){this.options=options},render(){const userSession=RB.UserSession.instance;const reviewRequest=this.model.get("reviewRequest");const reviewRequestEditor=this.model.get("reviewRequestEditor");this.options.animate=this.options.animate!==false;this.$el.hide().html(this.template({authenticated:userSession.get("authenticated"),hasDraft:reviewRequest.get("hasDraft"),markdownDocsURL:MANUAL_URL+"users/markdown/",markdownText:RB.CommentDialogView._markdownText,otherReviewsText:RB.CommentDialogView._otherReviewsText,loginText:interpolate(RB.CommentDialogView._loginTextTemplate,[userSession.get("loginURL")]),draftWarning:interpolate(RB.CommentDialogView._draftWarningTextTemplate,[reviewRequest.get("reviewURL")]),openAnIssueText:RB.CommentDialogView._openAnIssueText,enableMarkdownText:RB.CommentDialogView._enableMarkdownText,saveButton:RB.CommentDialogView._saveText,cancelButton:RB.CommentDialogView._cancelText,deleteButton:RB.CommentDialogView._deleteText,closeButton:RB.CommentDialogView._closeText,readOnly:userSession.get("readOnly"),readOnlyText:gettext("Review Board is currently in read-only mode."),showVerify:RB.EnabledFeatures.issueVerification,verifyIssueText:RB.CommentDialogView._verifyIssueText}));this._$commentsPane=this.$(".other-comments");this._$draftForm=this.$("form");this._$body=this._$draftForm.children(".comment-dlg-body");this._$header=this._$draftForm.children(".comment-dlg-header");this._$footer=this._$draftForm.children(".comment-dlg-footer");this._$title=this._$header.children(".title");this._$commentOptions=this._$body.children(".comment-dlg-options");this._$issueOptions=this._$commentOptions.children(".comment-issue-options").bindVisibility(this.model,"canEdit");this._$markdownOptions=this._$commentOptions.children(".comment-markdown-options").bindVisibility(this.model,"canEdit");this._$issueField=this._$issueOptions.find("#comment_issue").bindProperty("checked",this.model,"openIssue").bindProperty("disabled",this.model,"editing",{elementToModel:false,inverse:true});this._$issueVerificationField=this._$issueOptions.find("#comment_issue_verify").bindProperty("checked",this.model,"requireVerification").bindProperty("disabled",this.model,"editing",{elementToModel:false,inverse:true});this._$enableMarkdownField=this._$markdownOptions.find("#enable_markdown").bindProperty("checked",this.model,"richText").bindProperty("disabled",this.model,"editing",{elementToModel:false,inverse:true});this.$buttons=this._$footer.find(".buttons");this.$saveButton=this.$buttons.find("input.save").bindVisibility(this.model,"canEdit").bindProperty("disabled",this.model,"canSave",{elementToModel:false,inverse:true});this.$cancelButton=this.$buttons.find("input.cancel").bindVisibility(this.model,"canEdit");this.$deleteButton=this.$buttons.find("input.delete").bindVisibility(this.model,"canDelete").bindProperty("disabled",this.model,"canDelete",{elementToModel:false,inverse:true});this.$closeButton=this.$buttons.find("input.close").bindVisibility(this.model,"canEdit",{inverse:true});this.commentsList=new CommentsListView({el:this._$commentsPane.find("ul"),reviewRequestURL:reviewRequest.get("reviewURL"),commentIssueManager:this.options.commentIssueManager,issuesInteractive:reviewRequestEditor.get("editable")});this._textEditor=new RB.TextEditorView({el:this._$draftForm.find(".comment-text-field"),autoSize:false,minHeight:0,text:this.model.get("text"),bindRichText:{model:this.model,attrName:"richText"}});this._textEditor.render();this._textEditor.show();this._textEditor.$el.bindVisibility(this.model,"canEdit");this.listenTo(this._textEditor,"change",()=>this.model.set("text",this._textEditor.getText()));this._textEditor.bindRichTextCheckbox(this._$enableMarkdownField);this._textEditor.bindRichTextVisibility(this._$draftForm.find(".markdown-info"));this.listenTo(this.model,"change:text",()=>this._textEditor.setText(this.model.get("text")));this.listenTo(this.model,"change:richText",this._handleResize);this.$el.css("position","absolute").mousedown(evt=>{evt.stopPropagation()}).resizable({handles:$.support.touch?"grip,se":"grip,n,e,s,w,se,sw,ne,nw",transparent:true,resize:_.bind(this._handleResize,this)}).proxyTouchEvents();this._$header.css("cursor","move");this.$el.draggable({handle:".comment-dlg-header"});this.listenTo(this.model,"change:dirty",this._updateTitle);this._updateTitle();this.listenTo(this.model,"change:publishedComments",()=>this._onPublishedCommentsChanged());this._onPublishedCommentsChanged();RB.CommentDialogHook.each(hook=>{const HookViewType=hook.get("viewType");const hookView=new HookViewType({extension:hook.get("extension"),commentDialog:this,commentEditor:this.model,el:this.el});hookView.render()});return this},save(){this.model.set("text",this._textEditor.getText());if(this.model.get("canSave")){this.model.save({error:(model,xhr)=>{alert(gettext("Error saving comment:")+xhr.errorText)}});this.close()}},open(){function openDialog(){this.$el.scrollIntoView();this._textEditor.focus()}this.$el.css({top:parseInt(this.$el.css("top"),10)-this.SLIDE_DISTANCE,opacity:0}).show();this._handleResize();if(this.model.get("canEdit")){this.model.beginEdit()}if(this.options.animate){this.$el.animate({top:`+=${this.SLIDE_DISTANCE}px`,opacity:1},350,"swing",_.bind(openDialog,this))}else{openDialog.call(this)}},close(){let onClosed=arguments.length>0&&arguments[0]!==undefined?arguments[0]:undefined;let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};function closeDialog(){this.model.close();this.$el.remove();this.trigger("closed");if(_.isFunction(onClosed)){onClosed.call(context)}}if(this.options.animate&&this.$el.is(":visible")){this.$el.animate({top:`-=${this.SLIDE_DISTANCE}px`,opacity:0},350,"swing",_.bind(closeDialog,this))}else{closeDialog.call(this)}},move(x,y){this.$el.move(x,y)},positionBeside($el,options){this.$el.positionToSide($el,options)},_updateTitle(){this._$title.text(this.model.get("dirty")?RB.CommentDialogView._yourCommentDirtyText:RB.CommentDialogView._yourCommentText)},_onPublishedCommentsChanged(){const comments=this.model.get("publishedComments")||[];this.commentsList.setComments(comments,this.model.get("publishedCommentsType"));const showComments=comments.length>0;this._$commentsPane.setVisible(showComments);let width=this.FORM_BOX_WIDTH;if(showComments){width+=this.COMMENTS_BOX_WIDTH}let height;if(this.model.get("canEdit")){height=this.DIALOG_TOTAL_HEIGHT}else if(RB.UserSession.instance.get("readOnly")){height=this.DIALOG_READ_ONLY_HEIGHT}else{height=this.DIALOG_NON_EDITABLE_HEIGHT}this.$el.width(width).height(height)},_handleResize(){const height=this.$el.height();let width=this.$el.width();let commentsWidth=0;if(this._$commentsPane.is(":visible")){this._$commentsPane.outerWidth(this.COMMENTS_BOX_WIDTH).outerHeight(height).move(0,0,"absolute");const $commentsList=this.commentsList.$el;$commentsList.height(this._$commentsPane.height()-$commentsList.position().top);commentsWidth=this._$commentsPane.outerWidth(true);width-=commentsWidth}this._$draftForm.outerWidth(width).outerHeight(height).move(commentsWidth,0,"absolute");const $textField=this._textEditor.$el;this._textEditor.setSize(this._$body.width()-$textField.getExtents("b","lr"),this._$draftForm.height()-this._$header.outerHeight()-this._$commentOptions.outerHeight()-this._$footer.outerHeight()-$textField.getExtents("b","tb"))},_onCancelClicked(){let shouldExit=true;if(this.model.get("dirty")){shouldExit=confirm(RB.CommentDialogView._shouldExitText)}if(shouldExit){this.model.cancel();this.close()}},_onDeleteClicked(){if(this.model.get("canDelete")){this.model.deleteComment();this.close()}},_onTextKeyDown(e){e.stopPropagation();switch(e.which){case $.ui.keyCode.ESCAPE:this._onCancelClicked();return false;case 10:case $.ui.keyCode.ENTER:if(e.metaKey||e.ctrlKey){this.save();e.preventDefault();e.stopPropagation()}break;case 73:case 105:if(e.metaKey||e.altKey){e.preventDefault();this.model.set("openIssue",!this.model.get("openIssue"))}break;case 77:case 109:if(e.metaKey||e.altKey){e.preventDefault();this.model.set("richText",!this.model.get("richText"))}break;default:break}}},{_instance:null,create:function(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};console.assert(options.comment,"A comment must be specified");const reviewRequestEditor=options.reviewRequestEditor||RB.PageManager.getPage().model.reviewRequestEditor;const dlg=new RB.CommentDialogView({animate:options.animate,commentIssueManager:options.commentIssueManager||reviewRequestEditor.get("commentIssueManager"),model:new RB.CommentEditor({comment:options.comment,reviewRequest:reviewRequestEditor.get("reviewRequest"),reviewRequestEditor:reviewRequestEditor,publishedComments:options.publishedComments||undefined,publishedCommentsType:options.publishedCommentsType||undefined})});dlg.render().$el.css("z-index",999).appendTo(options.container||document.body);options.position=options.position||{};if(_.isFunction(options.position)){options.position(dlg)}else if(options.position.beside){dlg.positionBeside(options.position.beside.el,options.position.beside)}else{let x=options.position.x;let y=options.position.y;if(x===undefined){x=$(document).scrollLeft()+($(window).width()-dlg.$el.width())/2}if(y===undefined){y=$(document).scrollTop()+($(window).height()-dlg.$el.height())/2}dlg.move(x,y)}dlg.on("closed",()=>RB.CommentDialogView._instance=null);const instance=RB.CommentDialogView._instance;const showCommentDlg=function showCommentDlg(){try{dlg.open()}catch(e){dlg.close();throw e}RB.CommentDialogView._instance=dlg};if(instance){instance.on("closed",showCommentDlg);instance.close()}else{showCommentDlg()}return dlg},_cancelText:gettext("Cancel"),_closeText:gettext("Close"),_deleteText:gettext("Delete"),_draftWarningTextTemplate:gettext('The review request\'s current <a href="%s">draft</a> needs to be published before you can comment.'),_enableMarkdownText:gettext("Enable <u>M</u>arkdown"),_loginTextTemplate:gettext('You must <a href="%s">log in</a> to post a comment.'),_markdownText:gettext("Markdown"),_openAnIssueText:gettext("Open an <u>I</u>ssue"),_otherReviewsText:gettext("Other reviews"),_saveText:gettext("Save"),_shouldExitText:gettext("You have unsaved changes. Are you sure you want to exit?"),_verifyIssueText:gettext("Require Verification"),_yourCommentText:gettext("Your comment"),_yourCommentDirtyText:gettext("Your comment (unsaved)")})})();"use strict";RB.CommentIssueBarView=Backbone.View.extend({events:{"click .reopen":"_onReopenClicked","click .resolve":"_onFixedClicked","click .drop":"_onDropClicked","click .verify-dropped":"_onVerifyDroppedClicked","click .verify-resolved":"_onVerifyFixedClicked"},statusInfo:{open:{visibleButtons:[".drop",".resolve"],text:gettext("An issue was opened.")},resolved:{visibleButtons:[".reopen"],text:gettext("The issue has been resolved.")},dropped:{visibleButtons:[".reopen"],text:gettext("The issue has been dropped.")},"verifying-dropped":{visibleButtons:[".reopen"],text:gettext("Waiting for verification before dropping...")},"verifying-resolved":{visibleButtons:[".reopen"],text:gettext("Waiting for verification before resolving...")}},template:_.template(`<div class="issue-state">
 <div class="issue-container">
  <span class="rb-icon"></span>
  <span class="issue-details">
   <span class="issue-message"></span>
   <% if (interactive) { %>
    <span class="issue-actions">
     <input type="button" class="issue-button resolve"
            value="<%- fixedLabel %>">
     <input type="button" class="issue-button drop"
            value="<%- dropLabel %>">
     <input type="button" class="issue-button reopen"
            value="<%- reopenLabel %>">
     <input type="button" class="issue-button verify-resolved"
            value="<%- verifyFixedLabel %>">
     <input type="button" class="issue-button verify-dropped"
            value="<%- verifyDroppedLabel %>">
    </span>
   <% } %>
  </span>
 </div>
</div>`),initialize(options){this.options=options;const page=RB.PageManager.getPage();this._manager=this.options.commentIssueManager||page.model.commentIssueManager;this._issueStatus=this.options.issueStatus;this._$buttons=null;this._$state=null;this._$icon=null;this._$message=null},render(){if(this.$el.children().length===0){this.$el.append(this.template({interactive:this.options.interactive,fixedLabel:gettext("Fixed"),dropLabel:gettext("Drop"),reopenLabel:gettext("Re-open"),verifyDroppedLabel:gettext("Verify Dropped"),verifyFixedLabel:gettext("Verify Fixed")}))}this._$buttons=this.$(".issue-button");this._$state=this.$(".issue-state");this._$icon=this.$(".rb-icon");this._$message=this.$(".issue-message");this._manager.on("issueStatusUpdated",this._onIssueStatusUpdated,this);this._showStatus(this._issueStatus);return this},_setStatus(issueStatus){this._$buttons.prop("disabled",true);this._manager.setCommentState(this.options.reviewID,this.options.commentID,this.options.commentType,issueStatus)},_showStatus(issueStatus){const statusInfo=this.statusInfo[issueStatus];const prevStatus=this._issueStatus;this._issueStatus=issueStatus;this._$state.removeClass(prevStatus).addClass(issueStatus);let iconClass;if(issueStatus===RB.BaseComment.STATE_VERIFYING_DROPPED||issueStatus===RB.BaseComment.STATE_VERIFYING_RESOLVED){iconClass="rb-icon rb-icon-issue-verifying"}else{iconClass=`rb-icon rb-icon-issue-${issueStatus}`}this._$icon.attr("class",iconClass);this._$buttons.hide();this._$message.text(statusInfo.text);if(this.options.interactive){let visibleButtons=statusInfo.visibleButtons;if(this.options.canVerify){if(issueStatus===RB.BaseComment.STATE_VERIFYING_DROPPED){visibleButtons.push(".verify-dropped")}else if(issueStatus===RB.BaseComment.STATE_VERIFYING_RESOLVED){visibleButtons.push(".verify-resolved")}}this._$buttons.filter(visibleButtons.join(",")).show();this._$buttons.prop("disabled",false)}this.trigger("statusChanged",prevStatus,issueStatus)},_onReopenClicked(){this._setStatus(RB.BaseComment.STATE_OPEN)},_onFixedClicked(){const comment=this._manager.getComment(this.options.reviewID,this.options.commentID,this.options.commentType);comment.ready({ready:()=>{if(comment.requiresVerification()&&comment.getAuthorUsername()!==RB.UserSession.instance.get("username")){this._setStatus(RB.BaseComment.STATE_VERIFYING_RESOLVED)}else{this._setStatus(RB.BaseComment.STATE_RESOLVED)}}})},_onDropClicked(){const comment=this._manager.getComment(this.options.reviewID,this.options.commentID,this.options.commentType);comment.ready({ready:()=>{if(comment.requiresVerification()&&comment.getAuthorUsername()!==RB.UserSession.instance.get("username")){this._setStatus(RB.BaseComment.STATE_VERIFYING_DROPPED)}else{this._setStatus(RB.BaseComment.STATE_DROPPED)}}})},_onVerifyFixedClicked(){this._setStatus(RB.BaseComment.STATE_RESOLVED)},_onVerifyDroppedClicked(){this._setStatus(RB.BaseComment.STATE_DROPPED)},_onIssueStatusUpdated(comment,oldIssueStatus,timestamp,commentType){const options=this.options;if(comment.id===options.commentID&&commentType===options.commentType){this._showStatus(comment.get("issueStatus"))}}});"use strict";RB.DiffFragmentQueueView=Backbone.View.extend({initialize(options){this._containerPrefix=options.containerPrefix;this._diffFragmentViewOptions=options.diffFragmentViewOptions;this._fragmentsBasePath=`${options.reviewRequestPath}_fragments/diff-comments/`;this._queueName=options.queueName;this._queue={};this._saved={}},queueLoad(commentID,key,onFragmentRendered){const queue=this._queue;if(!queue[key]){queue[key]=[]}queue[key].push({commentID:commentID,onFragmentRendered:onFragmentRendered||null})},saveFragment(commentID){const $el=this._getCommentContainer(commentID);if($el.length===1&&$el.data("diff-fragment-view")){this._saved[commentID]=$el.html()}},loadFragments(onDone){if(_.isEmpty(this._queue)&&_.isEmpty(this._saved)){if(_.isFunction(onDone)){onDone()}return}const queueName=this._queueName;_.each(this._queue,queuedLoads=>{$.funcQueue(queueName).add(()=>{const pendingCommentIDs=[];const onFragmentRenderedFuncs={};for(let i=0;i<queuedLoads.length;i++){const queuedLoad=queuedLoads[i];const commentID=queuedLoad.commentID;const onFragmentRendered=_.isFunction(queuedLoad.onFragmentRendered)?queuedLoad.onFragmentRendered:null;if(this._saved.hasOwnProperty(commentID)){const html=this._saved[commentID];const container=this._getCommentContainer(commentID);console.assert(container);let view=container.data("diff-fragment-view");if(view){view.$el.html(html);view.render()}else{view=this._renderFragment(container,commentID,html)}if(onFragmentRendered){onFragmentRendered(view)}delete this._saved[commentID]}else{pendingCommentIDs.push(commentID);onFragmentRenderedFuncs[commentID]=onFragmentRendered}}if(pendingCommentIDs.length>0){this._loadDiff(pendingCommentIDs.join(","),{queueName:queueName,onFragmentRendered:(commentID,view)=>{if(onFragmentRenderedFuncs[commentID]){onFragmentRenderedFuncs[commentID](view)}},onDone:()=>$.funcQueue(queueName).next()})}else{$.funcQueue(queueName).next()}})});if(_.isFunction(onDone)){$.funcQueue(queueName).add(()=>{onDone();$.funcQueue(queueName).next()})}this._queue={};$.funcQueue(queueName).start()},_getCommentContainer(commentID){return $(`#${this._containerPrefix}_${commentID}`)},_loadDiff(commentIDs){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};const containerPrefix=this._containerPrefix;const queryArgs=[];const onFragmentRendered=_.isFunction(options.onFragmentRendered)?options.onFragmentRendered:null;if(options.linesOfContext!==undefined){queryArgs.push(`lines_of_context=${options.linesOfContext}`)}if(!containerPrefix.includes("draft")){queryArgs.push("allow_expansion=1")}queryArgs.push(TEMPLATE_SERIAL);RB.apiCall({url:`${this._fragmentsBasePath}${commentIDs}/`,data:queryArgs.join("&"),dataType:"arraybuffer",type:"GET",success:arrayBuffer=>{const dataView=new DataView(arrayBuffer);const len=dataView.byteLength;let pos=0;let totalFragments=0;let totalRenders=0;let done=false;const onFragmentLoaded=(commentID,html)=>{const containerID=`#${containerPrefix}_${commentID}`;const $container=$(containerID);if($container.length===0){console.error("Unable to find container %s for "+"comment ID %s. There may be missing "+"state in the database.",containerID,commentID)}else{const view=this._renderFragment($(`#${containerPrefix}_${commentID}`),commentID,html);if(onFragmentRendered){onFragmentRendered(commentID,view)}}totalRenders++;if(done&&totalRenders===totalFragments&&_.isFunction(options.onDone)){options.onDone()}};while(!done){const parsed=this._parseDiffFragmentFromPayload(arrayBuffer,dataView,pos);totalFragments++;pos=parsed.pos;done=pos>=len;parsed.load(onFragmentLoaded)}}})},_parseDiffFragmentFromPayload(arrayBuffer,dataView,pos){const commentID=dataView.getUint32(pos,true);pos+=4;const htmlLen=dataView.getUint32(pos,true);pos+=4;const htmlStart=pos;pos+=htmlLen;return{pos:pos,load(cb){RB.DataUtils.readBlobAsString(new Blob([arrayBuffer.slice(htmlStart,htmlStart+htmlLen)]),html=>cb(commentID,html))}}},_renderFragment($container,commentID,html){RB.scrollManager.markForUpdate($container);$container.html(html);let view=$container.data("diff-fragment-view");if(!view){view=new RB.DiffFragmentView(_.defaults({el:$container,loadDiff:options=>{RB.setActivityIndicator(true,{type:"GET"});this._loadDiff(commentID,_.defaults({onDone(){RB.setActivityIndicator(false,{});if(options.onDone){options.onDone()}}},options))}},this._diffFragmentViewOptions));$container.data("diff-fragment-view",view)}view.render();RB.scrollManager.markUpdated($container);return view}});"use strict";RB.DiffFragmentView=Backbone.View.extend({events:{"click .diff-expand-btn":"_onExpandButtonClicked","click .diff-collapse-btn":"_onCollapseButtonClicked",mouseenter:"_tryShowControlsDelayed",mouseleave:"_tryHideControlsDelayed"},COLLAPSED_HEADERS_HEIGHT:4,_controlsHoverTimeout:250,initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this._loadDiff=options.loadDiff;this._collapsible=!!options.collapsible;this._$table=null;this._$thead=null;this._$diffHeaders=null;this._$controls=null;this._centeredMgr=null;this._contextExpanded=false},render(){this.$el.removeClass("allow-transitions");this._$table=this.$el.children("table");this._$diffHeaders=this._$table.find(".diff-header");this._$thead=this._$table.children("thead");this._$controls=this._$diffHeaders.find("td > div");if(this._collapsible&&this.$el.is(":visible")){this.hideControls()}else{this.showControls()}if(this._collapsible){_.defer(()=>this.$el.addClass("allow-transitions"))}return this},showControls(){this._$table.removeClass("collapsed").addClass("expanded");this._$thead.css("transform","");this._$diffHeaders.css("transform","")},hideControls(animate){if(this._contextExpanded){return}if(animate===false){this.$el.removeClass("allow-transitions")}this._$table.removeClass("expanded").addClass("collapsed");const $firstDiffHeader=this._$diffHeaders.eq(0);if($firstDiffHeader.hasClass("diff-header-above")){const translateY=$firstDiffHeader.height()-this.COLLAPSED_HEADERS_HEIGHT;this._$thead.css("transform",`translateY(${translateY}px)`)}_.each(this._$diffHeaders,diffHeaderEl=>{const $diffHeader=$(diffHeaderEl);const scale=this.COLLAPSED_HEADERS_HEIGHT/$diffHeader.height();$diffHeader.css("transform",`scaleY(${scale})`)});if(animate===false){_.defer(()=>this.$el.addClass("allow-transitions"))}},_expandOrCollapse($btn){this._loadDiff({linesOfContext:$btn.data("lines-of-context"),onDone:this._onExpandOrCollapseFinished.bind(this)})},_tryShowControlsDelayed(){if(this._collapsible){_.delay(()=>{if(this.$el.is(":hover")){this.showControls()}},this._controlsHoverTimeout)}},_tryHideControlsDelayed(){if(this._collapsible){_.delay(()=>{if(!this.$el.is(":hover")){this.hideControls()}},this._controlsHoverTimeout)}},_onExpandOrCollapseFinished(){RB.setActivityIndicator(false,{});if(this._centeredMgr!==null){this._centeredMgr.remove();this._centeredMgr=null}const $collapseButtons=this.$(".diff-collapse-btn");if($collapseButtons.length>0){this._centeredMgr=new RB.CenteredElementManager({elements:new Map(Array.prototype.map.call($collapseButtons,el=>{const $chunks=$(el).closest(".sidebyside").children("tbody").not(".diff-header");return[el,{$top:$chunks.eq(0),$bottom:$chunks.eq(-1)}]}))});this._centeredMgr.updatePosition();this._contextExpanded=true}else{this._contextExpanded=false}this.render();if(!this._contextExpanded){this._tryHideControlsDelayed()}},_onExpandButtonClicked(e){e.preventDefault();e.stopPropagation();this._expandOrCollapse($(e.target).closest(".diff-expand-btn"),e)},_onCollapseButtonClicked(e){e.preventDefault();e.stopPropagation();this._expandOrCollapse($(e.target).closest(".diff-collapse-btn"),e)}});"use strict";(function(){const DnDDropTarget=Backbone.Model.extend({defaults(){return{$target:$(window),callback:function(){},dropText:gettext("Drop to upload")}}});const DnDDropOverlayView=Backbone.View.extend({className:"dnd-overlay",events:{dragenter:"_onDragEnter",dragover:"_onDragOver",dragleave:"_onDragLeave",drop:"_onDrop"},render(){this.$el.text(this.model.get("dropText"));return this},show(){const $target=this.model.get("$target");$target.addClass("dnd-overlay-visible");_.defer(()=>{const offset=$target.offset();const width=$target.outerWidth()+"px";const height=$target.outerHeight()+"px";this.$el.css({width:width,height:height,"line-height":height,left:offset.left+"px",top:offset.top+"px"}).show()})},hide(){this.model.get("$target").removeClass("dnd-overlay-visible");this.$el.hide()},close(){this.$el.fadeOut(()=>{this.trigger("closed");this.remove()})},_onDrop(e){e.stopPropagation();e.preventDefault();const dt=e.originalEvent.dataTransfer;const files=dt&&dt.files;if(files){const callback=this.model.get("callback");for(let file of Array.from(files)){callback(file)}}this.trigger("closing")},_onDragEnter(e){e.preventDefault();const dt=e.originalEvent.dataTransfer;if(dt){dt.dropEffect="copy";this.$el.addClass("dnd-overlay-highlight")}},_onDragOver(e){e.preventDefault()},_onDragLeave(e){e.preventDefault();const dt=e.originalEvent.dataTransfer;if(dt){dt.dropEffect="none";this.$el.removeClass("dnd-overlay-highlight")}}});RB.DnDUploader=Backbone.View.extend({initialize(){this._dropTargets=new Backbone.Collection({model:DnDDropTarget});this._dropOverlays=[];this._hideOverlayTimeout=null;this._overlaysVisible=false;this._overlaysHiding=false;_.bindAll(this,"_showOverlays","_hideOverlays");$(window).on("dragstart dragenter dragover",this._showOverlays).on("dragend dragleave",this._hideOverlays)},registerDropTarget($target,dropText,callback){if(this._dropTargets.findWhere({$target:$target})===undefined){const target=new DnDDropTarget({$target:$target,dropText:dropText,callback:callback});this._dropTargets.add(target);const overlay=new DnDDropOverlayView({model:target});overlay.render().$el.hide().appendTo(document.body);this.listenTo(overlay,"closing",this._hideOverlays);this._dropOverlays.push(overlay)}else{console.error("Drop target was already registered!",$target)}},unregisterDropTarget($target){const target=this._dropTargets.findWhere({$target:$target});const overlayIx=this._dropOverlays.findIndex(overlay=>overlay.model===target);if(overlayIx!==-1){this._dropOverlays[overlayIx].remove();this._dropOverlays.splice(overlayIx,1)}if(target!==undefined){this._dropTargets.remove(target)}},_showOverlays(e){if(e.originalEvent.dataTransfer!==undefined&&Array.from(e.originalEvent.dataTransfer.types).includes("Files")){this._overlaysHiding=false;if(!this._overlaysVisible){this._overlaysVisible=true;this._dropOverlays.forEach(overlay=>overlay.show())}}},_hideOverlays(){if(this._hideOverlayTimeout){clearTimeout(this._hideOverlayTimeout)}this._overlaysHiding=true;this._hideOverlayTimeout=setTimeout(()=>{if(this._overlaysHiding){this._overlaysVisible=false;this._dropOverlays.forEach(overlay=>overlay.hide())}},200)}},{instance:null,create(){console.assert(RB.DnDUploader.instance===null,"DnDUploader.create may only be called once");RB.DnDUploader.instance=new RB.DnDUploader;return RB.DnDUploader.instance}})})();"use strict";RB.DraftReviewBannerView=Backbone.View.extend({events:{"click #review-banner-edit":"_onEditReviewClicked","click #review-banner-discard":"_onDiscardClicked"},initialize(options){this.options=options},render(){this._$buttons=this.$("input");this._$banner=this.$(".banner");const model=this.model;this.listenTo(model,"saving destroying",()=>this._$buttons.prop("disabled",true));this.listenTo(model,"saved destroyed",()=>this._$buttons.prop("disabled",false));this.listenTo(model,"publishError",errorText=>alert(errorText));this._publishButton=new RB.SplitButtonView({el:document.getElementById("review-banner-publish-container"),text:gettext("Publish Review"),ariaMenuLabel:gettext("More publishing options"),click:this._onPublishClicked.bind(this),id:"review-banner-publish",alternatives:[{text:gettext("... and only e-mail the owner"),click:()=>this._onPublishClicked({publishToOwnerOnly:true}),id:"review-banner-publish-submitter-only"},{text:gettext("... and archive the review request"),click:()=>this._onPublishClicked({publishAndArchive:true}),id:"review-banner-publish-and-archive"}]});this._publishButton.render();if(!this.$el.prop("hidden")){this.show()}this.$el.addClass("ui-ready");return this},show(){const height=this._$banner.outerHeight();RB.scrollManager.markForUpdate(this.$el);this.$el.prop("hidden",false).removeClass("hidden").css({maxHeight:height,height:height});RB.scrollManager.scrollYOffset+=height;RB.scrollManager.markUpdated(this.$el)},hide(){RB.scrollManager.markForUpdate(this.$el);const height=this._$banner.outerHeight();this.$el.prop("hidden",true).addClass("hidden").css("max-height","");_.delay(()=>{this.$el.css("height","");RB.scrollManager.markUpdated(this.$el);RB.scrollManager.scrollYOffset-=height},500)},hideAndReload(){this.hide();_.defer(()=>{window.location=this.model.get("parentObject").get("reviewURL")})},getHeight(){return this._$banner.outerHeight()},remove(){if(this._publishButton){this._publishButton.remove()}_super(this).remove.call(this)},_onEditReviewClicked(){RB.ReviewDialogView.create({review:this.model,reviewRequestEditor:this.options.reviewRequestEditor});return false},_onPublishClicked(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(options.publishToOwnerOnly){this.model.set("publishToOwnerOnly",true)}if(options.publishAndArchive){this.model.set("publishAndArchive",true)}this.model.publish({attrs:["public","publishToOwnerOnly","publishAndArchive"]});return false},_onDiscardClicked(){$("<p/>").text(gettext("If you discard this review, all related comments will be permanently deleted.")).modalBox({title:gettext("Are you sure you want to discard this review?"),buttons:[$('<input type="button">').val(gettext("Cancel")),$('<input type="button">').val(gettext("Discard")).click(()=>this.model.destroy())]});return false}},{instance:null,create(options){if(!this.instance){this.instance=new RB.DraftReviewBannerView(options);this.instance.render()}return this.instance}});"use strict";RB.UploadAttachmentView=RB.DialogView.extend({className:"upload-attachment",title:gettext("Upload File"),buttons:[{id:"cancel",label:gettext("Cancel")},{id:"upload",label:gettext("Upload"),primary:true,disabled:true,onClick:"send"}],template:_.template(`<div class="formdlg" style="width: 50em;">
 <div class="error" style="display: none;"></div>
 <form encoding="multipart/form-data" enctype="multipart/form-data"
       id="attachment-upload-form">
  <table>
   <tbody>
    <tr>
     <td class="label"><label><%- captionText %></label></td>
     <td>
      <input name="caption" type="text" value="<%- presetCaption %>">
     </td>
     <td><ul class="errorlist" style="display: none;"></ul></td>
    </tr>
    <tr>
     <td class="label">
      <label class="required"><%- pathText %></label>
     </td>
     <td><input name="path" id="path" type="file" class="js-path"></td>
     <td><ul class="errorlist" style="display: none;"></ul></td>
    </tr>
   </tbody>
  </table>
  <% if (attachmentHistoryID >= 0) { %>
    <input type="hidden" name="attachment_history"
           value="<%- attachmentHistoryID %>" />
  <% } %>
 </form>
</div>`),events:_.extend({"change .js-path":"updateUploadButtonEnabledState"},RB.DialogView.prototype.events),initialize:function(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};_.defaults(options,{attachmentHistoryID:-1,presetCaption:""});const body=this.template({attachmentHistoryID:options.attachmentHistoryID,captionText:gettext("Caption:"),pathText:gettext("Path:"),presetCaption:options.presetCaption});RB.DialogView.prototype.initialize.call(this,$.extend({body:body},options))},send(){const attrs={attachmentHistoryID:this.options.attachmentHistoryID};this.options.reviewRequestEditor.createFileAttachment(attrs).save({form:this.$("#attachment-upload-form"),success:()=>{this.remove()},error:function(model,xhr){this.displayErrors($.parseJSON(xhr.responseText))}},this)},displayErrors(rsp){const errorStr=rsp&&rsp.err?rsp.err.msg:gettext("Unknown Error");this.$(".error").text(errorStr).show();if(rsp&&rsp.fields){const nameToRow={caption:0,path:1};for(let fieldName in rsp.fields){if(rsp.fields.hasOwnProperty(fieldName)){const $errorList=this.$(".errorlist").css("display","block");const elIndex=nameToRow[fieldName];const errorListEl=$errorList[elIndex];for(let i=0;i<rsp.fields[fieldName].length;i++){$("<li>").html(rsp.fields[fieldName][i]).appendTo(errorListEl)}}}}},render(){RB.DialogView.prototype.render.call(this);this._$path=this.$(".js-path");this._$uploadBtn=this.$buttonsMap.upload;return this},updateUploadButtonEnabledState(){this._$uploadBtn.enable(this._$path.val())}});"use strict";RB.RevisionSelectorView=Backbone.View.extend({template:_.template(`<div class="revision-selector">
 <div class="revision-selector-trough"></div>
 <div class="revision-selector-range"></div>
 <div class="revision-selector-ticks"></div>
 <div class="revision-selector-labels"></div>
 <div class="revision-selector-handles"></div>
</div>`),events:{"mousedown .revision-selector-handle":"_onHandleMouseDown","mousedown .revision-selector-label":"_onLabelMouseDown","click .revision-selector-label":"_onLabelClick"},initialize(options){console.assert(_.isObject(options));console.assert(options.numHandles===1||options.numHandles===2);this._activeHandle=null;this._firstLabelActive=options.firstLabelActive;this._mouseActive=false;this._numHandles=options.numHandles;this._values=[];this._rendered=false;this.listenTo(this.model,"change",this._update);_.bindAll(this,"_onHandleMouseUp","_onHandleMouseMove")},render(revisionLabels){this.$el.html(this.template());this._positions=[];let i;for(i=0;i<revisionLabels.length;i++){this._positions.push(i*30)}this._$handles=this.$(".revision-selector-handles");this._$range=this.$(".revision-selector-range");this._$ticks=this.$(".revision-selector-ticks");this._$labels=this.$(".revision-selector-labels");this._$trough=this.$(".revision-selector-trough").width(this._positions[i-1]);_.each(revisionLabels,(label,i)=>{$("<div/>").addClass("revision-selector-tick").css("left",this._positions[i]+"px").appendTo(this._$ticks);const $label=$("<div/>").text(label).addClass("revision-selector-label").appendTo(this._$labels);$label.css("left",this._positions[i]-$label.width()/2+"px");if(this._firstLabelActive||i>0){$label.data("revision",i).addClass("revision-selector-label-active")}});for(i=0;i<this._numHandles;i++){$("<div/>").addClass("revision-selector-handle rb-icon rb-icon-range-slider").data("handle-id",i).appendTo(this._$handles)}this._rendered=true;this._update();return this},_updateHandles(){const positions=this._positions;const values=this._mouseActive?this._activeValues:this._values;this._$handles.children().each((i,el)=>{$(el).css("left",positions[values[i]]-4+"px")});if(this._numHandles===2){this._$range.css({left:positions[values[0]]+"px",width:positions[values[1]-values[0]]+"px"})}},_onHandleMouseDown(ev){ev.preventDefault();ev.stopPropagation();this._activeValues=[];for(let i=0;i<this._values.length;i++){this._activeValues.push(i)}this._mouseActive=true;this._activeHandle=$(ev.currentTarget).data("handle-id");document.addEventListener("mouseup",this._onHandleMouseUp,true);document.addEventListener("mousemove",this._onHandleMouseMove,true);$("body").addClass("revision-selector-grabbed")},_onHandleMouseUp(ev){console.assert(this._mouseActive);ev.stopPropagation();ev.preventDefault();this._mouseActive=false;this._activeHandle=null;document.removeEventListener("mouseup",this._onHandleMouseUp,true);document.removeEventListener("mousemove",this._onHandleMouseMove,true);$("body").removeClass("revision-selector-grabbed");if(!_.isEqual(this._activeValues,this._values)){this.trigger("revisionSelected",this._activeValues)}},_onHandleMouseMove(ev){console.assert(this._mouseActive);const mouseX=window.pageXOffset+ev.clientX-this._$trough.offset().left;let closestPos;let closestDist;for(let i=0;i<this._positions.length;i++){const dist=Math.abs(this._positions[i]-mouseX);if(closestDist===undefined||dist<closestDist){closestDist=dist;closestPos=i}}if(this._numHandles===1){this._activeValues[0]=closestPos}else if(this._numHandles===2){if(this._activeHandle===0){this._activeValues[0]=Math.min(closestPos,this._positions.length-2);if(this._values[1]<=this._activeValues[0]){this._activeValues[1]=this._activeValues[0]+1}else{this._activeValues[1]=this._values[1]}}else if(this._activeHandle===1){this._activeValues[1]=Math.max(closestPos,1);if(this._values[0]>=this._activeValues[1]){this._activeValues[0]=this._activeValues[1]-1}else{this._activeValues[0]=this._values[0]}}}this._updateHandles()}});"use strict";RB.FileAttachmentReviewableView=RB.AbstractReviewableView.extend({commentsListName:"file_attachment_comments"});"use strict";RB.FileAttachmentRevisionLabelView=Backbone.View.extend({events:{"click .select-latest":"_onSelectLatest","click .select-changed":"_onSelectChanged"},template:_.template(`<p><%- header %></p>
<% if (detail) { %><p><%= detail %></p><% } %>`),_interdiffTemplate:_.template(gettext("This file attachment has multiple revisions. Showing changes between revision <%- diffAgainstRevision %> and <%- revision %>.")),_latestTemplate:_.template(gettext("This file attachment has multiple revisions. Showing revision <%- revision %> (latest).")),_oldHeaderTemplate:_.template(gettext("This file attachment has multiple revisions. Showing revision <%- revision %>.")),_oldDetailTemplate:_.template(gettext('This is not the most recent revision of the file. The <a href="#" class="select-latest">latest version</a> is revision <%- latestRevision %>. <a href="#" class="select-changed">See what\'s changed.</a>')),initialize(){this.listenTo(this.model,"change",this.render)},render(){const revision=this.model.get("fileRevision");const diffAgainstRevision=this.model.get("diffRevision");const latestRevision=this.model.get("numRevisions");let header="";let detail=null;if(diffAgainstRevision){header=this._interdiffTemplate({revision:revision,diffAgainstRevision:diffAgainstRevision})}else if(revision===latestRevision){header=this._latestTemplate({revision:revision})}else{header=this._oldHeaderTemplate({revision:revision});detail=this._oldDetailTemplate({revision:revision,latestRevision:latestRevision})}this.$el.html(this.template({header:header,detail:detail}));return this},_onSelectLatest(ev){ev.stopPropagation();ev.preventDefault();this.trigger("revisionSelected",[0,this.model.get("numRevisions")])},_onSelectChanged(ev){ev.stopPropagation();ev.preventDefault();this.trigger("revisionSelected",[this.model.get("fileRevision"),this.model.get("numRevisions")])}});"use strict";RB.FileAttachmentRevisionSelectorView=RB.RevisionSelectorView.extend({initialize(){RB.RevisionSelectorView.prototype.initialize.call(this,{firstLabelActive:true,numHandles:2})},render(){const numRevisions=this.model.get("numRevisions");const labels=[gettext("No Diff")];for(let i=1;i<=numRevisions;i++){labels.push(i.toString())}RB.RevisionSelectorView.prototype.render.call(this,labels,true)},_update(){const revision=this.model.get("fileRevision");const diffRevision=this.model.get("diffRevision");if(diffRevision){this._values=[revision,diffRevision]}else{this._values=[0,revision]}if(this._rendered){this._updateHandles()}},_onLabelClick(ev){const $target=$(ev.currentTarget);this.trigger("revisionSelected",[0,$target.data("revision")])}});"use strict";RB.FileAttachmentThumbnail=Backbone.View.extend({className:"file-container",events:{"click .file-delete":"_onDeleteClicked","click .file-add-comment a":"_onAddCommentClicked","click .file-update a":"_onUpdateClicked"},template:_.template(`<div class="file">
 <div class="file-actions-container">
  <ul class="file-actions"></ul>
 </div>
 <div class="file-thumbnail-container"></div>
 <div class="file-caption-container">
  <div class="file-caption can-edit"><a href="<%- downloadURL %>" class="<%- captionClass %>"><%- caption %></a></div>
 </div>
</div>`),actionsTemplate:_.template(["<% if (loaded) { %>","<%  if (reviewURL) { %>",'<li><a class="file-review" href="<%- reviewURL %>">','<span class="fa fa-comment-o"></span> <%- reviewText %></a>',"</li>","<%  } else { %>",'<li class="file-add-comment">','<a href="#"><span class="fa fa-comment-o"></span> <%- commentText %></a>',"</li>","<%  } %>",'<li><a class="file-download" href="<%- downloadURL %>">','<span class="fa fa-download"></span> <%- downloadText %>',"</a></li>","<%  if (canEdit) { %>","<%   if (attachmentHistoryID) { %>",'<li class="file-update">','<a href="#" data-attachment-history-id="<%- attachmentHistoryID %>">','<span class="fa fa-upload"></span> <%- updateText %>',"</a></li>","<%   } %>",'<li class="file-delete"><a href="#">','<span class="fa fa-trash-o"></span> <%- deleteText %>',"</a></li>","<%  } %>","<% } %>"].join("")),thumbnailContainerTemplate:_.template(["<% if (!loaded) { %>",'<span class="fa fa-spinner fa-pulse"></span>',"<% } else { %>","<%     if (reviewURL) { %>",'<a href="<%- reviewURL %>" class="file-thumbnail-overlay"></a>',"<%     } %>","<%=  thumbnailHTML %>","<% } %>"].join("")),initialize(options){this.options=options;this._draftComment=null;this._comments=[];this._commentsProcessed=false;this._scrollingThumbnail=false;this._playingVideo=false},render(){if(this.options.renderThumbnail){this._renderContents()}this._$captionContainer=this.$(".file-caption");this._$caption=this._$captionContainer.find("a.edit");this.listenTo(this.model,"destroy",()=>{this.$el.fadeOut(()=>this.remove())});this.listenTo(this.model,"change:caption",this._onCaptionChanged);this._onCaptionChanged();this.$el.hover(this._onHoverIn.bind(this),this._onHoverOut.bind(this));if(this.options.renderThumbnail){this._$actionsContainer=this.$(".file-actions-container");this._$actions=this._$actionsContainer.children(".file-actions");this._$captionContainer=this.$(".file-caption-container");this._$thumbnailContainer=this.$(".file-thumbnail-container");this._$file=this.$(".file");this._$actions.find(".file-download").bindProperty("href",this.model,"downloadURL",{elementToModel:false});this._$caption.bindProperty("href",this.model,"downloadURL",{elementToModel:false});this.listenTo(this.model,"change:loaded",this._onLoadedChanged);this._onLoadedChanged();this.listenTo(this.model,"change:thumbnailHTML",this._renderThumbnail);this._renderThumbnail()}if(this.options.canEdit!==false){this._captionEditorView=new RB.InlineEditorView({el:this._$caption,editIconClass:"rb-icon rb-icon-edit",showButtons:true});this._captionEditorView.render();this.listenTo(this._captionEditorView,"beginEditPreShow",()=>{this.$el.addClass("editing");this._stopAnimating()});this.listenTo(this._captionEditorView,"beginEdit",()=>{if(this._$caption.hasClass("empty-caption")){this._captionEditorView.$field.val("")}this.trigger("beginEdit")});this.listenTo(this._captionEditorView,"cancel",()=>{this.$el.removeClass("editing");this.trigger("endEdit")});this.listenTo(this._captionEditorView,"complete",value=>{this.$el.removeClass("editing");this.model.ready({ready:()=>{this.model.set("caption",value);this.trigger("endEdit");this.model.save({attrs:["caption"]})}})})}return this},fadeIn(){this.$el.css("opacity",0).fadeTo(1e3,1)},showCommentDlg(){console.assert(!this.model.get("reviewURL"),"showCommentDlg can only be called if the file "+"attachment does not have a review UI");this._processComments();this._createDraftComment();RB.CommentDialogView.create({comment:this._draftComment,publishedComments:this._comments,publishedCommentsType:"file_attachment_comments",position:{beside:{el:this.$el,side:"br",fitOnScreen:true}}})},_processComments(){if(this._commentsProcessed){return}const comments=this.options.comments||[];comments.forEach(comment=>{if(comment.localdraft){this._createDraftComment(comment.comment_id,comment.text)}else{this._comments.push(comment)}});this._commentsProcessed=true},_createDraftComment(commentID,text){if(this._draftComment!==null){return}const review=this.options.reviewRequest.createReview();this._draftComment=review.createFileAttachmentComment(commentID,this.model.id);if(text){this._draftComment.set("text",text)}this.listenTo(this._draftComment,"saved",()=>this.trigger("commentSaved",this._draftComment))},_renderContents(){const caption=this.model.get("caption");const captionText=caption?caption:gettext("No caption");const captionClass=caption?"edit":"edit empty-caption";this.$el.html(this.template(_.defaults({caption:captionText,captionClass:captionClass},this.model.attributes))).addClass(this.className)},_renderThumbnail(){this._$thumbnailContainer.html(this.thumbnailContainerTemplate(this.model.attributes));Djblets.enableRetinaImages(this._$thumbnailContainer);this._$thumbnailContainer.find("a").each((i,el)=>{el.tabIndex=-1})},_onLoadedChanged(){this._$actions.html(this.actionsTemplate(_.defaults({canEdit:this.options.canEdit,deleteText:gettext("Delete"),downloadText:gettext("Download"),reviewText:gettext("Review"),commentText:gettext("Comment"),updateText:gettext("Update")},this.model.attributes)))},_onCaptionChanged(){const caption=this.model.get("caption");if(caption){this._$caption.text(caption).removeClass("empty-caption")}else{this._$caption.text(gettext("No caption")).addClass("empty-caption")}},_onAddCommentClicked(e){e.preventDefault();e.stopPropagation();this.showCommentDlg()},_onUpdateClicked(e){e.preventDefault();e.stopPropagation();const updateDlg=new RB.UploadAttachmentView({attachmentHistoryID:$(e.target).data("attachment-history-id"),presetCaption:this.model.get("caption"),reviewRequestEditor:this.options.reviewRequestEditor});updateDlg.show()},_onDeleteClicked(e){e.preventDefault();e.stopPropagation();this.model.destroy()},_onHoverIn(){const $thumbnail=this.$(".file-thumbnail").children();const actionsWidth=this._$actionsContainer.outerWidth();const actionsRight=this._$file.offset().left+this._$file.outerWidth()+actionsWidth;this.trigger("hoverIn",this.$el);if(actionsRight>$(window).width()){this._$actionsContainer.css("left",-actionsWidth).addClass("left")}else{this._$actionsContainer.css("left","100%").addClass("right")}if(!this.$el.hasClass("editing")&&$thumbnail.length===1){const thumbnailEl=$thumbnail[0];if(thumbnailEl.tagName==="VIDEO"){const promise=thumbnailEl.play();if(promise===undefined){this._playingVideo=true}else{promise.then(()=>{this._playingVideo=true}).catch(error=>{console.error("Unable to play the video attachment: %s",error)})}}else{const elHeight=this.$el.height();const thumbnailHeight=$thumbnail.height()||0;if(thumbnailHeight>elHeight){const distance=elHeight-thumbnailHeight;const duration=Math.abs(distance)/200*1e3;this._scrollingThumbnail=true;$thumbnail.delay(1e3).animate({"margin-top":distance+"px"},{duration:duration,easing:"linear"}).delay(500).animate({"margin-top":0},{duration:duration,easing:"linear",complete:()=>{this._scrollingThumbnail=false}})}}}},_onHoverOut(){this.trigger("hoverOut");this._$actionsContainer.removeClass("left").removeClass("right");this._stopAnimating()},_stopAnimating(){if(this._scrollingThumbnail){this._scrollingThumbnail=false;this.$(".file-thumbnail").children().stop(true).animate({"margin-top":0},{duration:100})}else if(this._playingVideo){this._playingVideo=false;this.$("video")[0].pause()}}});"use strict";RB.FloatingBannerView=Backbone.View.extend({initialize(options){this.options=options;this._$floatSpacer=null;_.bindAll(this,"_updateFloatPosition","_updateSize")},render(){$(window).scroll(this._updateFloatPosition).resize(this._updateSize);_.defer(this._updateFloatPosition);return this},remove(){if(this._$floatSpacer!==null){this._$floatSpacer.remove()}Backbone.View.prototype.remove.call(this)},_updateSize(){if(this._$floatSpacer!==null){if(this.$el.hasClass("floating")){const rect=this._$floatSpacer.parent()[0].getBoundingClientRect();this.$el.width(Math.ceil(rect.width)-this.$el.getExtents("bpm","lr"))}else{this.$el.width("auto")}}},_updateFloatPosition(){if(this.$el.parent().length===0){return}if(this._$floatSpacer===null){this._$floatSpacer=this.$el.wrap($("<div/>")).parent();this._updateSize()}const $container=this.options.$floatContainer;const containerTop=$container.offset().top;const containerHeight=$container.outerHeight();const containerBottom=containerTop+containerHeight;const windowTop=$(window).scrollTop();const topOffset=this._$floatSpacer.offset().top-windowTop;const outerHeight=this.$el.outerHeight(true);const wasFloating=this.$el.hasClass("floating");if(!$container.hasClass(this.options.noFloatContainerClass)&&topOffset<0&&containerTop<windowTop&&windowTop<containerBottom){if(!wasFloating){this._$floatSpacer.height(this.$el.outerHeight()).css({"margin-top":this.$el.css("margin-top"),"margin-bottom":this.$el.css("margin-bottom")});this.$el.addClass("floating").css("position","fixed")}this.$el.css("top",windowTop>containerBottom-outerHeight?containerBottom-outerHeight-windowTop:0);this._updateSize()}else if(wasFloating){this.$el.removeClass("floating").css({top:"",position:""});this._$floatSpacer.height("auto").css("margin",0)}}});"use strict";RB.RegionCommentBlockView=RB.AbstractCommentBlockView.extend({className:"selection",events:_.defaults({click:"_onClicked",mousedown:"_onMouseDown"},RB.AbstractCommentBlockView.prototype.events),initialize(){this._scale=1;this._moveState={hasMoved:false,initialCursor:{},initialBounds:{},dragCallback:_.noop};_.bindAll(this,"_onDrag","_onWindowMouseUp")},delegateEvents(){RB.AbstractCommentBlockView.prototype.delegateEvents.call(this);this.listenTo(this.model,"change:x change:y change:width change:height",this._updateBounds);this.listenTo(this.model,"change:count",this._updateCount)},undelegateEvents(){RB.AbstractCommentBlockView.prototype.undelegateEvents.call(this);$(window).off("mousemove",this._onDrag);this.stopListening(this.model)},setSelectionRegionSizeFunc(func){this.selectionRegionSizeFunc=func},getSelectionRegionSize(){return _.result(this,"selectionRegionSizeFunc")},_startDragging(left,top,callback){this._moveState.hasMoved=false;this._moveState.initialCursor.left=left;this._moveState.initialCursor.top=top;this._moveState.initialBounds.left=this.$el.position().left;this._moveState.initialBounds.top=this.$el.position().top;this._moveState.initialBounds.width=this.$el.width();this._moveState.initialBounds.height=this.$el.height();this._moveState.dragCallback=callback;$(window).on("mousemove",this._onDrag)},_endDragging(){_.defer(()=>{this._moveState.hasMoved=false});$(window).off("mousemove",this._onDrag)},_moveTo(left,top){const region=this.getSelectionRegionSize();const maxLeft=region.width-this.model.get("width")*this._scale;const maxTop=region.height-this.model.get("height")*this._scale;const newLeft=this._moveState.initialBounds.left+left-this._moveState.initialCursor.left;const newTop=this._moveState.initialBounds.top+top-this._moveState.initialCursor.top;this.model.set({x:RB.MathUtils.clip(newLeft,0,maxLeft)/this._scale,y:RB.MathUtils.clip(newTop,0,maxTop)/this._scale})},_resizeTo(left,top){const region=this.getSelectionRegionSize();const maxWidth=region.width-this.model.get("x")*this._scale;const maxHeight=region.height-this.model.get("y")*this._scale;const newWidth=this._moveState.initialBounds.width+left-this._moveState.initialCursor.left;const newHeight=this._moveState.initialBounds.height+top-this._moveState.initialCursor.top;this.model.set({width:RB.MathUtils.clip(newWidth,0,maxWidth)/this._scale,height:RB.MathUtils.clip(newHeight,0,maxHeight)/this._scale})},_onMouseDown(e){if(this.model.canUpdateBounds()){e.preventDefault();e.stopPropagation();let draggingCallback=null;if(e.target===this._$flag.get(0)){draggingCallback=this._moveTo}else if(e.target===this._$resizeIcon.get(0)){draggingCallback=this._resizeTo}if(draggingCallback){this._startDragging(e.pageX,e.pageY,draggingCallback);$(window).one("mouseup",this._onWindowMouseUp)}}},_onWindowMouseUp(){if(this._moveState.hasMoved){this.model.saveDraftCommentBounds()}this._endDragging()},_onDrag(e){e.preventDefault();e.stopPropagation();this.hideTooltip();this._moveState.hasMoved=true;this._moveState.dragCallback.call(this,e.pageX,e.pageY)},renderContent(){this._updateBounds();if(this.model.canUpdateBounds()){this.$el.addClass("can-update-bound");this._$resizeIcon=$('<div class="resize-icon" />').appendTo(this.$el)}this._$flag=$('<div class="selection-flag" />').appendTo(this.$el);this._updateCount()},positionCommentDlg(commentDlg){commentDlg.positionBeside(this._$flag,{side:"b",fitOnScreen:true})},_updateBounds(){this.$el.move(this.model.get("x")*this._scale,this.model.get("y")*this._scale,"absolute").width(this.model.get("width")*this._scale).height(this.model.get("height")*this._scale)},_updateCount(){if(this._$flag){this._$flag.text(this.model.get("count"))}},_onClicked(){if(!this._moveState.hasMoved){this.trigger("clicked")}},setScale(scale){this._scale=scale;this._updateBounds()}});"use strict";(function(){const BaseCommentView=Backbone.View.extend({tagName:"li",thumbnailTemplate:null,events:{"click .delete-comment":"_deleteComment"},editorTemplate:_.template(`<div class="edit-fields">
 <div class="edit-field">
  <div class="comment-text-field">
   <label class="comment-label" for="<%= id %>">
    <%- commentText %>
    <a href="#" role="button" class="delete-comment"
       aria-label="<%- deleteCommentText %>"
       title="<%- deleteCommentText %>"
       ><span class="fa fa-trash-o" aria-hidden="true"></span></a>
   </label>
   <pre id="<%= id %>" class="reviewtext rich-text"
        data-rich-text="true"><%- text %></pre>
  </div>
 </div>
 <div class="edit-field">
  <input class="issue-opened" id="<%= issueOpenedID %>"
         type="checkbox">
  <label for="<%= issueOpenedID %>"><%- openAnIssueText %></label>
  <% if (showVerify) { %>
   <input class="issue-verify" id="<%= verifyIssueID %>"
          type="checkbox">
   <label for="<%= verifyIssueID %>"><%- verifyIssueText %></label>
  <% } %>
 </div>
</div>`),_DELETE_COMMENT_TEXT:gettext("Are you sure you want to delete this comment?"),initialize(){this.$issueOpened=null;this.$editor=null;this.textEditor=null;this._origExtraData=_.clone(this.model.get("extraData"));this._hookViews=[]},remove(){this._hookViews.forEach(view=>view.remove());this._hookViews=[];Backbone.View.prototype.remove.call(this)},needsSave(){return this.inlineEditorView.isDirty()||!_.isEqual(this.model.get("extraData"),this._origExtraData)},save(options){if(this.inlineEditorView.isDirty()){this.model.once("sync",()=>options.success());this.inlineEditorView.submit()}else{this.model.save(_.extend({attrs:["forceTextType","includeTextTypes","extraData"]},options))}},render(){this.$el.addClass("draft").append(this.renderThumbnail()).append(this.editorTemplate({deleteCommentText:gettext("Delete comment"),commentText:gettext("Comment"),id:_.uniqueId("draft_comment_"),issueOpenedID:_.uniqueId("issue-opened"),openAnIssueText:gettext("Open an Issue"),text:this.model.get("text"),verifyIssueID:_.uniqueId("issue-verify"),showVerify:RB.EnabledFeatures.issueVerification,verifyIssueText:RB.CommentDialogView._verifyIssueText})).find("time.timesince").timesince().end();this.$issueOpened=this.$(".issue-opened").prop("checked",this.model.get("issueOpened")).change(()=>{this.model.set("issueOpened",this.$issueOpened.prop("checked"));if(!this.model.isNew()){this.model.save({attrs:["forceTextType","includeTextTypes","issueOpened"]})}});this._$issueVerify=this.$(".issue-verify").prop("checked",this.model.requiresVerification()).change(()=>{const extraData=_.clone(this.model.get("extraData"));extraData.require_verification=this._$issueVerify.prop("checked");this.model.set("extraData",extraData);if(!this.model.isNew()){this.model.save({attrs:["forceTextType","includeTextTypes","extra_data.require_verification"]})}});const $editFields=this.$(".edit-fields");this.$editor=this.$("pre.reviewtext");this.inlineEditorView=new RB.RichTextInlineEditorView({el:this.$editor,editIconClass:"rb-icon rb-icon-edit",notifyUnchangedCompletion:true,multiline:true,textEditorOptions:{bindRichText:{model:this.model,attrName:"richText"}}});this.inlineEditorView.render();this.textEditor=this.inlineEditorView.textEditor;this.listenTo(this.inlineEditorView,"complete",value=>{const attrs=["forceTextType","includeTextTypes","richText","text"];if(this.model.isNew()){attrs.push("extra_data.require_verification","issueOpened")}this.model.set({text:value,richText:this.textEditor.richText});this.model.save({attrs:attrs})});this.listenTo(this.model,`change:${this._getRawValueFieldsName()}`,this._updateRawValue);this._updateRawValue();this.listenTo(this.model,"saved",this.renderText);this.renderText();this.listenTo(this.model,"destroying",()=>this.stopListening(this.model));RB.ReviewDialogCommentHook.each(hook=>{const HookView=hook.get("viewType");const hookView=new HookView({extension:hook.get("extension"),model:this.model});this._hookViews.push(hookView);$('<div class="edit-field"/>').append(hookView.$el).appendTo($editFields);hookView.render()});return this},renderThumbnail(){if(this.thumbnailTemplate===null){return null}return $(this.thumbnailTemplate(this.model.attributes))},renderText(){const reviewRequest=this.model.get("parentObject").get("parentObject");if(this.$editor){RB.formatText(this.$editor,{newText:this.model.get("text"),richText:this.model.get("richText"),isHTMLEncoded:true,bugTrackerURL:reviewRequest.get("bugTrackerURL")})}},_deleteComment(){if(confirm(this._DELETE_COMMENT_TEXT)){this.model.destroy()}},_updateRawValue(){if(this.$editor){this.inlineEditorView.options.hasRawValue=true;this.inlineEditorView.options.rawValue=this.model.get(this._getRawValueFieldsName()).text}},_getRawValueFieldsName(){return RB.UserSession.instance.get("defaultUseRichText")?"markdownTextFields":"rawTextFields"}});const DiffCommentView=BaseCommentView.extend({thumbnailTemplate:_.template(`<div class="review-dialog-comment-diff"
     id="review_draft_comment_container_<%= id %>">
 <table class="sidebyside loading">
  <thead>
   <tr>
    <th class="filename"><%- revisionText %></th>
   </tr>
  </thead>
  <tbody>
   <% for (var i = 0; i < numLines; i++) { %>
    <tr><td><pre>&nbsp;</pre></td></tr>
   <% } %>
  </tbody>
 </table>
</div>`),initialize(options){this.options=options;BaseCommentView.prototype.initialize.call(this,options)},render(){BaseCommentView.prototype.render.call(this);const fileDiffID=this.model.get("fileDiffID");const interFileDiffID=this.model.get("interFileDiffID");this.options.diffQueue.queueLoad(this.model.id,interFileDiffID?fileDiffID+"-"+interFileDiffID:fileDiffID);return this},renderThumbnail(){const fileDiff=this.model.get("fileDiff");const interFileDiff=this.model.get("interFileDiff");let revisionText;if(interFileDiff){revisionText=interpolate(gettext("%(filename)s (Diff revisions %(fileDiffRevision)s - %(interFileDiffRevision)s)"),{filename:fileDiff.get("destFilename"),fileDiffRevision:fileDiff.get("sourceRevision"),inteFfileDiffRevision:interFileDiff.get("sourceRevision")},true)}else{revisionText=interpolate(gettext("%(filename)s (Diff revision %(fileDiffRevision)s)"),{filename:fileDiff.get("destFilename"),fileDiffRevision:fileDiff.get("sourceRevision")},true)}return $(this.thumbnailTemplate({id:this.model.get("id"),numLines:this.model.getNumLines(),revisionText:revisionText}))}});const FileAttachmentCommentView=BaseCommentView.extend({thumbnailTemplate:_.template(`<div class="file-attachment">
 <span class="filename">
  <a href="<%- reviewURL %>"><%- linkText %></a>
 </span>
 <span class="diffrevision"><%- revisionsStr %></span>
 <div class="thumbnail"><%= thumbnailHTML %></div>
</div>`),renderThumbnail(){const fileAttachment=this.model.get("fileAttachment");const diffAgainstFileAttachment=this.model.get("diffAgainstFileAttachment");const revision=fileAttachment.get("revision");let revisionsStr;if(!revision){revisionsStr=""}else if(diffAgainstFileAttachment){revisionsStr=interpolate(gettext("(Revisions %(revision1)s - %(revision2)s)"),{revision1:diffAgainstFileAttachment.get("revision"),revision2:revision},true)}else{revisionsStr=interpolate(gettext("(Revision %s)"),[revision])}return $(this.thumbnailTemplate(_.defaults({revisionsStr:revisionsStr},this.model.attributes)))}});const GeneralCommentView=BaseCommentView.extend({thumbnailTemplate:null});const ScreenshotCommentView=BaseCommentView.extend({thumbnailTemplate:_.template(`<div class="screenshot">
 <span class="filename">
  <a href="<%- screenshot.reviewURL %>"><%- displayName %></a>
 </span>
 <img src="<%= thumbnailURL %>" width="<%= width %>"
      height="<%= height %>" alt="<%- displayName %>" />
</div>`),renderThumbnail(){const screenshot=this.model.get("screenshot");return $(this.thumbnailTemplate(_.defaults({screenshot:screenshot.attributes,displayName:screenshot.getDisplayName()},this.model.attributes)))}});const HeaderFooterCommentView=Backbone.View.extend({tagName:"li",editorTemplate:_.template(`<div class="edit-fields">
 <div class="edit-field">
  <div class="add-link-container">
   <a href="#" class="add-link"><%- linkText %></a>
  </div>
  <div class="comment-text-field">
   <label for="<%= id %>" class="comment-label">
    <%- commentText %>
   </label>
   <pre id="<%= id %>" class="reviewtext rich-text"
        data-rich-text="true"><%- text %></pre>
  </div>
 </div>
</div>`),events:{"click .add-link":"openEditor"},initialize(options){this.propertyName=options.propertyName;this.richTextPropertyName=options.richTextPropertyName;this.linkText=options.linkText;this.commentText=options.commentText;this.$editor=null;this.textEditor=null},setLinkText(linkText){this.$(".add-link").text(linkText)},render(){const text=this.model.get(this.propertyName);this.$el.addClass("draft").append(this.editorTemplate({commentText:this.commentText,id:this.propertyName,linkText:this.linkText,text:text||""})).find("time.timesince").timesince().end();this.$editor=this.$("pre.reviewtext");this.inlineEditorView=new RB.RichTextInlineEditorView({el:this.$editor,editIconClass:"rb-icon rb-icon-edit",notifyUnchangedCompletion:true,multiline:true,textEditorOptions:{bindRichText:{model:this.model,attrName:this.richTextPropertyName}}});this.inlineEditorView.render();this.textEditor=this.inlineEditorView.textEditor;this.listenTo(this.inlineEditorView,"complete",value=>{this.model.set(this.propertyName,value);this.model.set(this.richTextPropertyName,this.textEditor.richText);this.model.save({attrs:[this.propertyName,this.richTextPropertyName,"forceTextType","includeTextTypes"]})});this.listenTo(this.inlineEditorView,"cancel",()=>{if(!this.model.get(this.propertyName)){this._$editorContainer.hide();this._$linkContainer.show()}});this._$editorContainer=this.$(".comment-text-field");this._$linkContainer=this.$(".add-link-container");this.listenTo(this.model,`change:${this._getRawValueFieldsName()}`,this._updateRawValue);this._updateRawValue();this.listenTo(this.model,"saved",this.renderText);this.renderText()},renderText(){if(this.$editor){const text=this.model.get(this.propertyName);if(text){const reviewRequest=this.model.get("parentObject");this._$editorContainer.show();this._$linkContainer.hide();RB.formatText(this.$editor,{newText:text,richText:this.model.get(this.richTextPropertyName),isHTMLEncoded:true,bugTrackerURL:reviewRequest.get("bugTrackerURL")})}else{this._$editorContainer.hide();this._$linkContainer.show()}}},needsSave(){return this.inlineEditorView.isDirty()},save(options){this.model.once("sync",()=>options.success());this.inlineEditorView.submit()},openEditor(ev){this._$linkContainer.hide();this._$editorContainer.show();this.inlineEditorView.startEdit();if(ev){ev.preventDefault()}return false},_deleteComment(){},_updateRawValue(){if(this.$editor){const rawValues=this.model.get(this._getRawValueFieldsName());this.inlineEditorView.options.hasRawValue=true;this.inlineEditorView.options.rawValue=rawValues[this.propertyName]}},_getRawValueFieldsName(){return RB.UserSession.instance.get("defaultUseRichText")?"markdownTextFields":"rawTextFields"}});RB.ReviewDialogView=Backbone.View.extend({id:"review-form-comments",className:"review",template:_.template(`<div class="edit-field">
 <input id="id_shipit" type="checkbox" />
 <label for="id_shipit"><%- shipItText %></label>
</div>
<div class="review-dialog-hooks-container"></div>
<div class="edit-field body-top"></div>
<ol id="review-dialog-body-top-comments" class="review-comments"></ol>
<ol id="review-dialog-general-comments" class="review-comments"></ol>
<ol id="review-dialog-screenshot-comments" class="review-comments"></ol>
<ol id="review-dialog-file-attachment-comments" class="review-comments"></ol>
<ol id="review-dialog-diff-comments" class="review-comments"></ol>
<ol id="review-dialog-body-bottom-comments" class="review-comments"></ol>
<div class="spinner"><span class="fa fa-spinner fa-pulse"></span></div>
<div class="edit-field body-bottom"></div>`),initialize(options){this.options=options;this._$diffComments=$();this._$fileAttachmentComments=$();this._$generalComments=$();this._$screenshotComments=$();this._$dlg=null;this._$buttons=null;this._$spinner=null;this._$shipIt=null;this._commentViews=[];this._hookViews=[];_.bindAll(this,"_onAddCommentClicked");const reviewRequest=this.model.get("parentObject");this._diffQueue=new RB.DiffFragmentQueueView({containerPrefix:"review_draft_comment_container",reviewRequestPath:reviewRequest.get("reviewURL"),queueName:"review_draft_diff_comments"});this._diffCommentsCollection=new RB.ResourceCollection([],{model:RB.DiffComment,parentResource:this.model,extraQueryData:{"order-by":"filediff,first_line"}});this._bodyTopView=new HeaderFooterCommentView({model:this.model,propertyName:"bodyTop",richTextPropertyName:"bodyTopRichText",linkText:gettext("Add header"),commentText:gettext("Header")});this._bodyBottomView=new HeaderFooterCommentView({model:this.model,propertyName:"bodyBottom",richTextPropertyName:"bodyBottomRichText",linkText:gettext("Add footer"),commentText:gettext("Footer")});this.listenTo(this._diffCommentsCollection,"add",comment=>{const view=new DiffCommentView({model:comment,diffQueue:this._diffQueue});this._renderComment(view,this._$diffComments)});this._fileAttachmentCommentsCollection=new RB.ResourceCollection([],{model:RB.FileAttachmentComment,parentResource:this.model});this.listenTo(this._fileAttachmentCommentsCollection,"add",comment=>{const view=new FileAttachmentCommentView({model:comment});this._renderComment(view,this._$fileAttachmentComments)});this._$lastGeneralComment=null;this._generalCommentsCollection=new RB.ResourceCollection([],{model:RB.GeneralComment,parentResource:this.model});this.listenTo(this._generalCommentsCollection,"add",comment=>{const view=new GeneralCommentView({model:comment});this._renderComment(view,this._$generalComments)});this._screenshotCommentsCollection=new RB.ResourceCollection([],{model:RB.ScreenshotComment,parentResource:this.model});this.listenTo(this._screenshotCommentsCollection,"add",comment=>{const view=new ScreenshotCommentView({model:comment});this._renderComment(view,this._$screenshotComments)});this._defaultUseRichText=RB.UserSession.instance.get("defaultUseRichText");this._queryData={"force-text-type":"html"};if(this._defaultUseRichText){this._queryData["include-text-types"]="raw,markdown"}else{this._queryData["include-text-types"]="raw"}this._setTextTypeAttributes(this.model);this.options.reviewRequestEditor.incr("editCount")},remove(){if(this._publishButton){this._publishButton.remove();this._publishButton=null}this._hookViews.forEach(view=>view.remove());this._hookViews=[];_super(this).remove.call(this)},close(){this.options.reviewRequestEditor.decr("editCount");this._$dlg.modalBox("destroy");this.trigger("closed");this.remove()},render(){this.$el.html(this.template({addHeaderText:gettext("Add header"),addFooterText:gettext("Add footer"),shipItText:gettext("Ship It"),markdownDocsURL:MANUAL_URL+"users/markdown/",markdownText:gettext("Markdown Reference")}));this._$diffComments=this.$("#review-dialog-diff-comments");this._$fileAttachmentComments=this.$("#review-dialog-file-attachment-comments");this._$generalComments=this.$("#review-dialog-general-comments");this._$screenshotComments=this.$("#review-dialog-screenshot-comments");this._$spinner=this.$(".spinner");this._$shipIt=this.$("#id_shipit");const $hooksContainer=this.$(".review-dialog-hooks-container");RB.ReviewDialogHook.each(hook=>{const HookView=hook.get("viewType");const hookView=new HookView({extension:hook.get("extension"),model:this.model});this._hookViews.push(hookView);$hooksContainer.append(hookView.$el);hookView.render()});this._bodyTopView.$el.appendTo(this.$("#review-dialog-body-top-comments"));this._bodyBottomView.$el.appendTo(this.$("#review-dialog-body-bottom-comments"));this.model.set("loaded",false);this.model.ready({data:this._queryData,ready:()=>{this._renderDialog();this._bodyTopView.render();this._bodyBottomView.render();if(this.model.isNew()||this.model.get("bodyTop")===""){this._bodyTopView.openEditor()}if(this.model.isNew()){this._$spinner.remove();this._$spinner=null;this._handleEmptyReview()}else{this._$shipIt.prop("checked",this.model.get("shipIt"));this._loadComments()}this.listenTo(this.model,"change:bodyBottom",this._handleEmptyReview)}});return this},_loadComments(){const collections=[this._screenshotCommentsCollection,this._fileAttachmentCommentsCollection,this._diffCommentsCollection];if(RB.EnabledFeatures.generalComments){collections.unshift(this._generalCommentsCollection)}this._loadCommentsFromCollection(collections,()=>{this._$spinner.remove();this._$spinner=null;this._handleEmptyReview()})},_handleEmptyReview(){if(this._commentViews.length===0&&!this.model.get("bodyBottom")){this._bodyBottomView.$el.hide();this._bodyTopView.setLinkText(gettext("Add text"))}},_loadCommentsFromCollection(collections,onDone){const collection=collections.shift();if(collection){collection.fetchAll({data:this._queryData,success:()=>{if(collection===this._diffCommentsCollection){this._diffQueue.loadFragments()}this._loadCommentsFromCollection(collections,onDone)},error:rsp=>{alert(rsp.errorText)}})}else{onDone()}},_renderComment(view,$container){this._setTextTypeAttributes(view.model);this._commentViews.push(view);this.listenTo(view.model,"destroyed",()=>{view.$el.fadeOut({complete:()=>{view.remove();this._handleEmptyReview()}});this._commentViews=_.without(this._commentViews,view)});$container.append(view.$el);view.render();this._$dlg.scrollTop(view.$el.position().top+this._$dlg.getExtents("p","t"))},_renderDialog(){const $leftButtons=$('<div class="review-dialog-buttons-left"/>');const $rightButtons=$('<div class="review-dialog-buttons-right"/>');const buttons=[$leftButtons,$rightButtons];if(RB.EnabledFeatures.generalComments){$leftButtons.append($('<input type="button" />').val(gettext("Add General Comment")).attr("title",gettext("Add a new general comment to the review")).click(this._onAddCommentClicked))}$rightButtons.append($('<div id="review-form-publish-split-btn-container" />'));$rightButtons.append($('<input type="button"/>').val(gettext("Discard Review")).click(()=>this._onDiscardClicked()));$rightButtons.append($('<input type="button"/>').val(gettext("Close")).click(()=>{this._saveReview(false);return false}));const reviewRequest=this.model.get("parentObject");this._$dlg=$("<div/>").attr("id","review-form").append(this.$el).modalBox({container:this.options.container||"body",boxID:"review-form-modalbox",title:interpolate(gettext("Review for: %s"),[reviewRequest.get("summary")]),stretchX:true,stretchY:true,buttons:buttons}).keypress(e=>e.stopPropagation()).attr("scrollTop",0).trigger("ready");this._publishButton=new RB.SplitButtonView({el:$("#review-form-publish-split-btn-container"),text:gettext("Publish Review"),ariaMenuLabel:gettext("More publishing options"),click:()=>{this._saveReview(true);return false},direction:"up",alternatives:[{text:gettext("... and only e-mail the owner"),click:()=>{this._saveReview(true,{publishToOwnerOnly:true});this.close();return false}},{text:gettext("... and archive the review request"),click:()=>{this._saveReview(true,{publishAndArchive:true});this.close();return false}}]});this._publishButton.render();this._$buttons=this._$dlg.modalBox("buttons")},_onAddCommentClicked(){const comment=this.model.createGeneralComment(undefined,RB.UserSession.instance.get("commentsOpenAnIssue"));this._generalCommentsCollection.add(comment);this._bodyBottomView.$el.show();this._commentViews[this._commentViews.length-1].inlineEditorView.startEdit();return false},_onDiscardClicked(){const $cancelButton=$('<input type="button">').val(gettext("Cancel"));const $discardButton=$('<input type="button">').val(gettext("Discard")).click(()=>{this.close();this.model.destroy({success:()=>RB.DraftReviewBannerView.instance.hideAndReload()})});$("<p/>").text(gettext("If you discard this review, all related comments will be permanently deleted.")).modalBox({title:gettext("Are you sure you want to discard this review?"),buttons:[$cancelButton,$discardButton]});return false},_saveReview(publish){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(publish&&options.publishToOwnerOnly){this.model.set("publishToOwnerOnly",true)}if(publish&&options.publishAndArchive){this.model.set("publishAndArchive",true)}this._$buttons.prop("disabled");let madeChanges=false;$.funcQueue("reviewForm").clear();function maybeSave(view){if(view.needsSave()){$.funcQueue("reviewForm").add(()=>{madeChanges=true;view.save({success:()=>$.funcQueue("reviewForm").next()})})}}maybeSave(this._bodyTopView);maybeSave(this._bodyBottomView);this._commentViews.forEach(view=>maybeSave(view));$.funcQueue("reviewForm").add(()=>{const shipIt=this._$shipIt.prop("checked");const saveFunc=publish?this.model.publish:this.model.save;if(this.model.get("public")===publish&&this.model.get("shipIt")===shipIt){$.funcQueue("reviewForm").next()}else{madeChanges=true;this.model.set({shipIt:shipIt});saveFunc.call(this.model,{attrs:["forceTextType","includeTextTypes","public","publishAndArchive","publishToOwnerOnly","shipIt"],success:()=>$.funcQueue("reviewForm").next(),error:function(){console.error("Failed to save review",arguments)}})}});$.funcQueue("reviewForm").add(()=>{const reviewBanner=RB.DraftReviewBannerView.instance;this.close();if(reviewBanner){if(publish){reviewBanner.hideAndReload()}else if(this.model.isNew()&&!madeChanges){reviewBanner.hide()}else{reviewBanner.show()}}});$.funcQueue("reviewForm").start()},_setTextTypeAttributes(model){model.set({forceTextType:"html",includeTextTypes:this._defaultUseRichText?"raw,markdown":"raw"})}},{_instance:null,create(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};console.assert(!RB.ReviewDialogView._instance,"A ReviewDialogView is already opened");console.assert(options.review,"A review must be specified");const dialog=new RB.ReviewDialogView({container:options.container,model:options.review,reviewRequestEditor:options.reviewRequestEditor});RB.ReviewDialogView._instance=dialog;dialog.render();dialog.on("closed",()=>{RB.ReviewDialogView._instance=null});return dialog}})})();"use strict";(function(){const Fields={};Fields.BaseFieldView=Backbone.View.extend({editableProp:"editable",useExtraData:true,initialize(options){this.fieldID=options.fieldID;this.jsonFieldName=options.jsonFieldName||this.jsonFieldName||this.fieldID;this._fieldName=undefined;this.$el.data("field-id",this.fieldID)},fieldName(){if(this._fieldName===undefined){this._fieldName=this.fieldID.replace(/_(.)/g,(m,c)=>c.toUpperCase())}return this._fieldName},_loadValue(options){const fieldName=this.useExtraData?this.jsonFieldName:_.result(this,"fieldName");return this.model.getDraftField(fieldName,_.defaults({useExtraData:this.useExtraData},options))},_saveValue(value,options){this.model.setDraftField(_.result(this,"fieldName"),value,_.defaults({jsonFieldName:this.jsonFieldName,useExtraData:this.useExtraData},options))},needsSave(){return false},finishSave(){}});Fields.TextFieldView=Fields.BaseFieldView.extend({autocomplete:null,multiline:false,allowRichText:false,useEditIconOnly:false,richTextAttr(){return this.allowRichText?`${_.result(this,"fieldName")}RichText`:null},initialize(options){Fields.BaseFieldView.prototype.initialize.call(this,options);this.jsonTextTypeFieldName=this.jsonFieldName==="text"?"text_type":`${this.jsonFieldName}_text_type`},_getInlineEditorClass(){return this.allowRichText?RB.RichTextInlineEditorView:RB.InlineEditorView},render(){if(!this.$el.hasClass("editable")){return this}const fieldName=_.result(this,"fieldName");const EditorClass=this._getInlineEditorClass();const inlineEditorOptions={el:this.$el,formClass:`${this.$el.prop("id")}-editor`,editIconClass:"rb-icon rb-icon-edit",enabled:this.model.get(this.editableProp),multiline:this.multiline,useEditIconOnly:this.useEditIconOnly,showRequiredFlag:this.$el.hasClass("required"),deferEventSetup:this.autocomplete!==null};if(this.allowRichText){_.extend(inlineEditorOptions,{textEditorOptions:{minHeight:0,richText:this._loadRichTextValue()},matchHeight:false,hasRawValue:true,rawValue:this._loadValue({useRawTextValue:true})||""})}this.inlineEditorView=new EditorClass(inlineEditorOptions);this.inlineEditorView.render();this.listenTo(this.inlineEditorView,"beginEdit",()=>this.model.incr("editCount"));this.listenTo(this.inlineEditorView,"resize",()=>this.trigger("resize"));this.listenTo(this.inlineEditorView,"cancel",()=>{this.trigger("resize");this.model.decr("editCount")});this.listenTo(this.inlineEditorView,"complete",value=>{this.trigger("resize");this.model.decr("editCount");const saveOptions={allowMarkdown:this.allowRichText,error:err=>{this._formatField();this.trigger("fieldError",err)},success:()=>{this._formatField();this.trigger("fieldSaved")}};if(this.allowRichText){saveOptions.richText=this.inlineEditorView.textEditor.richText;saveOptions.jsonTextTypeFieldName=this.jsonTextTypeFieldName}this._saveValue(value,saveOptions)});if(this.autocomplete!==null){this._buildAutoComplete();this.inlineEditorView.setupEvents()}this.listenTo(this.model,`change:${this.editableProp}`,(model,editable)=>{if(editable){this.inlineEditorView.enable()}else{this.inlineEditorView.disable()}});this.listenTo(this.model,`fieldChanged:${fieldName}`,this._formatField);return this},_convertToLink(item){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(!item){return $()}const $link=$("<a/>").attr("href",options.makeItemURL?options.makeItemURL(item):item).text(options.makeItemText?options.makeItemText(item):item);if(options.cssClass){$link.addClass(options.cssClass)}return $link},_buildAutoComplete(){const ac=this.autocomplete;const reviewRequest=this.model.get("reviewRequest");this.inlineEditorView.$field.rbautocomplete({formatItem:data=>{let s=data[ac.nameKey];if(ac.descKey&&data[ac.descKey]){s+=` <span>(${_.escape(data[ac.descKey])})</span>`}return s},matchCase:false,multiple:true,parse:data=>{const items=_.isFunction(ac.fieldName)?ac.fieldName(data):data[ac.fieldName];return items.map(item=>{if(ac.parseItem){item=ac.parseItem(item)}return{data:item,value:item[ac.nameKey],result:item[ac.nameKey]}})},url:SITE_ROOT+reviewRequest.get("localSitePrefix")+"api/"+(ac.resourceName||ac.fieldName)+"/",extraParams:ac.extraParams,cmp:ac.cmp,width:350,error:xhr=>{let text;try{text=JSON.parse(xhr.responseText).err.msg}catch(e){text=`HTTP ${xhr.status} ${xhr.statusText}`}alert(text)}}).on("autocompleteshow",()=>{const resultsPane=$(".ui-autocomplete-results:not("+":has(.ui-autocomplete-footer))");if(resultsPane.length>0){$("<div/>").addClass("ui-autocomplete-footer").text(gettext("Press Tab to auto-complete.")).appendTo(resultsPane)}})},_formatField(){const value=this._loadValue();if(_.isFunction(this.formatValue)){this.formatValue(value)}else{this.$el.text(value)}},needsSave(){return this.inlineEditorView&&this.inlineEditorView.isDirty()},finishSave(){this.inlineEditorView.submit()},_loadRichTextValue(){if(this.useExtraData){const textTypeFieldName=this.jsonTextTypeFieldName;const textType=this.model.getDraftField(textTypeFieldName,{useExtraData:true,useRawTextValue:true});if(textType===undefined){return undefined}console.assert(textType==="plain"||textType==="markdown",`Text type "${textType}" in field "${textTypeFieldName}" `+`not supported.`);return textType==="markdown"}else{return this.model.getDraftField(_.result(this,"richTextAttr"))}}});Fields.MultilineTextFieldView=Fields.TextFieldView.extend({multiline:true,allowRichText:null,initialize(options){Fields.TextFieldView.prototype.initialize.call(this,options);if(this.allowRichText===null){this.allowRichText=this.$el.data("allow-markdown");const reviewRequest=this.model.get("reviewRequest");const extraData=reviewRequest.draft.get("extraData");const rawValue=this.$el.data("raw-value");extraData[this.jsonFieldName]=rawValue!==undefined?rawValue||"":this.$el.text();this.$el.removeAttr("data-raw-value");if(this.allowRichText){extraData[this.jsonTextTypeFieldName]=this.$el.hasClass("rich-text")?"markdown":"plain"}}},formatText(options){const reviewRequest=this.model.get("reviewRequest");options=_.defaults({bugTrackerURL:reviewRequest.get("bugTrackerURL"),isHTMLEncoded:true},options);if(this.allowRichText){options.richText=this._loadRichTextValue()}RB.formatText(this.$el,options);this.$("img").on("load",()=>this.trigger("resize"))},render(){Fields.TextFieldView.prototype.render.call(this);this.formatText();return this},formatValue(data){if(this.allowRichText){this.formatText({newText:data})}}});Fields.CommaSeparatedValuesTextFieldView=Fields.TextFieldView.extend({useEditIconOnly:true,_urlizeList(list){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let $links=$();if(list){for(let i=0;i<list.length;i++){$links=$links.add(this._convertToLink(list[i],options));if(i<list.length-1){$links=$links.add(document.createTextNode(", "))}}}return $links},formatValue(data){data=data||[];this.$el.html(data.join(", "))}});Fields.CheckboxFieldView=Fields.BaseFieldView.extend({render(){Fields.BaseFieldView.prototype.render.call(this);this.$el.change(()=>{this._saveValue(this.$el.is(":checked"),{error:err=>this.trigger("fieldError",err),success:()=>this.trigger("fieldSaved")})});return this}});Fields.DropdownFieldView=Fields.BaseFieldView.extend({render(){Fields.BaseFieldView.prototype.render.call(this);this.$el.change(()=>{this._saveValue(this.$el.val(),{error:err=>this.trigger("fieldError",err),success:()=>this.trigger("fieldSaved")})});return this}});Fields.DateFieldView=Fields.TextFieldView.extend({render(){Fields.TextFieldView.prototype.render.call(this);this.inlineEditorView.$field.datepicker({changeMonth:true,changeYear:true,dateFormat:$.datepicker.ISO_8601,showButtonPanel:true,onSelect:(dateText,instance)=>{if(dateText!==instance.lastVal){this.inlineEditorView._dirty=true}}});return this},_saveValue(value,options){const m=moment(value,"YYYY-MM-DD",true);if(!m.isValid()){value="";this.$el.text("")}Fields.TextFieldView.prototype._saveValue.call(this,value,options)}});Fields.BranchFieldView=Fields.TextFieldView.extend({useExtraData:false});Fields.BugsFieldView=Fields.CommaSeparatedValuesTextFieldView.extend({useExtraData:false,formatValue(data){data=data||[];const reviewRequest=this.model.get("reviewRequest");const bugTrackerURL=reviewRequest.get("bugTrackerURL");if(bugTrackerURL){this.$el.empty().append(this._urlizeList(data,{makeItemURL:item=>bugTrackerURL.replace("--bug_id--",item),cssClass:"bug"})).find(".bug").bug_infobox()}else{this.$el.text(data.join(", "))}}});Fields.ChangeDescriptionFieldView=Fields.MultilineTextFieldView.extend({allowRichText:true,jsonFieldName:"changedescription",useExtraData:false});Fields.CommitListFieldView=Fields.BaseFieldView.extend({initialize(){this._commitListView=null},render(){Fields.BaseFieldView.prototype.render.call(this);this._commitListView=new RB.DiffCommitListView({el:this.$(".commit-list"),model:new RB.DiffCommitList({commits:this.model.get("commits"),isInterdiff:false})});return this}});Fields.CloseDescriptionFieldView=Fields.MultilineTextFieldView.extend({allowRichText:true,useExtraData:false,editableProp:"statusEditable",_saveValue(value,options){this.model.get("reviewRequest").close(_.defaults({type:this.closeType,description:value,postData:{force_text_type:"html",include_text_types:"raw"}},options))}});Fields.DependsOnFieldView=Fields.CommaSeparatedValuesTextFieldView.extend({autocomplete:{fieldName:data=>data.search.review_requests,nameKey:"id",descKey:"id",display_name:"summary",resourceName:"search",parseItem:item=>{item.id=item.id.toString();item.display_name=item.summary;return item},extraParams:{summary:1},cmp:(term,a,b)=>b.data.id-a.data.id},useEditIconOnly:true,useExtraData:false,formatValue(data){data=data||[];this.$el.empty().append(this._urlizeList(data,{makeItemURL:item=>item.url,makeItemText:item=>item.id,cssClass:"review-request-link"})).find(".review-request-link").review_request_infobox()}});Fields.DescriptionFieldView=Fields.MultilineTextFieldView.extend({allowRichText:true,useExtraData:false});Fields.OwnerFieldView=Fields.TextFieldView.extend({autocomplete:{fieldName:"users",nameKey:"username",descKey:"fullname",extraParams:{fullname:1},cmp:(term,a,b)=>{const aUsername=a.data.username;const bUsername=b.data.username;const aFullname=a.data.fullname;const bFullname=a.data.fullname;if(aUsername.indexOf(term)===0){if(bUsername.indexOf(term)===0){return aUsername.localeCompare(bUsername)}return-1}else if(bUsername.indexOf(term)===0){return 1}else{return aFullname.localeCompare(bFullname)}}},useEditIconOnly:true,useExtraData:false,formatValue(data){const $link=this._convertToLink(data,{makeItemURL:item=>{const href=item.href;return href.substr(href.indexOf("/users"))},makeItemText:item=>item.title,cssClass:"user"});this.$el.empty().append($link.user_infobox())}});Fields.SummaryFieldView=Fields.TextFieldView.extend({useExtraData:false});Fields.TargetGroupsFieldView=Fields.CommaSeparatedValuesTextFieldView.extend({autocomplete:{fieldName:"groups",nameKey:"name",descKey:"display_name",extraParams:{displayname:1}},useEditIconOnly:true,useExtraData:false,formatValue(data){data=data||[];this.$el.empty().append(this._urlizeList(data,{makeItemURL:item=>item.url,makeItemText:item=>item.name}))}});Fields.TargetPeopleFieldView=Fields.CommaSeparatedValuesTextFieldView.extend({autocomplete:{fieldName:"users",nameKey:"username",descKey:"fullname",extraParams:{fullname:1},cmp:(term,a,b)=>{const aUsername=a.data.username;const bUsername=b.data.username;const aFullname=a.data.fullname;const bFullname=a.data.fullname;if(aUsername.indexOf(term)===0){if(bUsername.indexOf(term)===0){return aUsername.localeCompare(bUsername)}return-1}else if(bUsername.indexOf(term)===0){return 1}else{return aFullname.localeCompare(bFullname)}}},useEditIconOnly:true,useExtraData:false,formatValue(data){data=data||[];this.$el.empty().append(this._urlizeList(data,{makeItemURL:item=>item.url,makeItemText:item=>item.username,cssClass:"user"})).find(".user").user_infobox()}});Fields.TestingDoneFieldView=Fields.MultilineTextFieldView.extend({allowRichText:true,useExtraData:false});RB.ReviewRequestFields=Fields})();"use strict";(function(){const BannerView=Backbone.View.extend({className:"banner",title:"",subtitle:"",actions:[],showChangesField:true,describeText:"",fieldOptions:{},descriptionFieldID:"change_description",descriptionFieldName:null,descriptionFieldHTML:"",descriptionFieldClasses:"",showSendEmail:false,DescriptionFieldViewType:RB.ReviewRequestFields.ChangeDescriptionFieldView,template:_.template(`<h1><%- title %></h1>
<% if (subtitle) { %>
<p><%- subtitle %></p>
<% } %>
<span class="banner-actions">
<% _.each(actions, function(action) { %>
 <input type="button" id="<%= action.id %>"
        value="<%- action.label %>" />
<% }); %>
<% if (showSendEmail) { %>
 <label>
  <input type="checkbox" class="send-email" checked />
  <%- sendEmailText %>
</label>
<% } %>
</span>
<% if (showChangesField) { %>
 <p><label for="field_<%- descriptionFieldID %>"><%- describeText %></label></p>
 <pre id="field_<%- descriptionFieldID %>"
      class="field field-text-area <%- descriptionFieldClasses %>"
      data-field-id="field_<%- descriptionFieldID %>"
      ><%= descriptionFieldHTML %></pre>
<% } %>`),initialize(options){this.reviewRequestEditorView=options.reviewRequestEditorView;this.reviewRequestEditor=this.reviewRequestEditorView.model;this.reviewRequest=this.reviewRequestEditor.get("reviewRequest");this.$buttons=null},render(){const readOnly=RB.UserSession.instance.get("readOnly");if(this.$el.children().length===0){this.$el.html(this.template({title:this.title,subtitle:this.subtitle,actions:readOnly?[]:this.actions,showChangesField:this.showChangesField&&!readOnly,describeText:this.describeText,descriptionFieldID:this.descriptionFieldID,descriptionFieldHTML:this.descriptionFieldHTML,descriptionFieldClasses:this.descriptionFieldClasses,showSendEmail:this.showSendEmail,sendEmailText:gettext("Send E-Mail")}))}if(this.DescriptionFieldViewType){this.field=new this.DescriptionFieldViewType({el:this.$(`#field_${this.descriptionFieldID}`),fieldID:this.descriptionFieldID,model:this.reviewRequestEditor});this.reviewRequestEditorView.addFieldView(this.field)}this.$buttons=this.$("input");this.reviewRequestEditor.on("saving destroying",()=>this.$buttons.prop("disabled",true));this.reviewRequestEditor.on("saved saveFailed destroyed",()=>this.$buttons.prop("disabled",false));return this}});const ClosedBannerView=BannerView.extend({descriptionFieldID:"close_description",descriptionFieldName:"closeDescription",DescriptionFieldViewType:RB.ReviewRequestFields.CloseDescriptionFieldView,actions:[{id:"btn-review-request-reopen",label:gettext("Reopen for Review")}],closeType:undefined,events:{"click #btn-review-request-reopen":"_onReopenClicked"},render(){const descriptionFieldClasses=[];if(this.reviewRequestEditor.get("statusMutableByUser")){descriptionFieldClasses.push("editable")}if(this.reviewRequest.get("closeDescriptionRichText")){descriptionFieldClasses.push("rich-text")}this.descriptionFieldClasses=descriptionFieldClasses.join(" ");this.descriptionFieldHTML=this.reviewRequestEditor.get("closeDescriptionRenderedText");BannerView.prototype.render.apply(this,arguments);this.field.closeType=this.closeType;return this},_onReopenClicked(){this.reviewRequest.reopen({error:(model,xhr)=>alert(xhr.errorText)});return false}});const DiscardedBannerView=ClosedBannerView.extend({id:"discard-banner",title:gettext("This change has been discarded."),describeText:gettext("Describe the reason it's discarded (optional):"),closeType:RB.ReviewRequest.CLOSE_DISCARDED});const SubmittedBannerView=ClosedBannerView.extend({id:"submitted-banner",title:gettext("This change has been marked as submitted."),describeText:gettext("Describe the submission (optional):"),closeType:RB.ReviewRequest.CLOSE_SUBMITTED});const DraftBannerView=BannerView.extend({id:"draft-banner",title:gettext("This review request is a draft."),subtitle:gettext("Be sure to publish when finished."),describeText:gettext("Describe your changes (optional):"),descriptionFieldID:"change_description",descriptionFieldName:"changeDescription",_newDraftTemplate:_.template(`<div class="interdiff-link">
 <%- newDiffText %>
 <a href="<%- interdiffLink %>"><%- showChangesText %></a>
</div>`),events:{"click #btn-draft-publish":"_onPublishDraftClicked","click #btn-draft-discard":"_onDiscardDraftClicked","click #btn-review-request-discard":"_onCloseDiscardedClicked"},initialize(){BannerView.prototype.initialize.apply(this,arguments);if(this.reviewRequest.get("public")){this.showSendEmail=this.reviewRequestEditor.get("showSendEmail");this.title=gettext("This review request is a draft.");this.actions=[{id:"btn-draft-publish",label:gettext("Publish Changes")},{id:"btn-draft-discard",label:gettext("Discard Draft")}]}else{this.showChangesField=false;this.actions=[{id:"btn-draft-publish",label:gettext("Publish")},{id:"btn-review-request-discard",label:gettext("Discard Review Request")}]}},_onPublishDraftClicked(){const $sendEmail=this.$(".send-email");this.reviewRequestEditorView.publishDraft({trivial:$sendEmail.length===1&&!$sendEmail.is(":checked")});return false},_onDiscardDraftClicked(){this.reviewRequest.draft.destroy({error:xhr=>alert(xhr.errorText)});return false},_onCloseDiscardedClicked(){this.reviewRequest.close({type:RB.ReviewRequest.CLOSE_DISCARDED});return false},render(){const descriptionFieldClasses=[];if(this.reviewRequestEditor.get("mutableByUser")){descriptionFieldClasses.push("editable")}const draft=this.reviewRequest.draft;if(draft.get("changeDescriptionRichText")){descriptionFieldClasses.push("rich-text")}this.descriptionFieldClasses=descriptionFieldClasses.join(" ");this.descriptionFieldHTML=this.reviewRequestEditor.get("changeDescriptionRenderedText");BannerView.prototype.render.apply(this,arguments);const interdiffLink=draft.get("interdiffLink");if(interdiffLink){this.$el.append(this._newDraftTemplate({newDiffText:gettext("This draft adds a new diff."),showChangesText:gettext("Show changes"),interdiffLink:interdiffLink}))}return this}});RB.ReviewRequestEditorView=Backbone.View.extend({defaultFields:[{fieldID:"branch"},{fieldID:"bugs_closed",fieldName:"bugsClosed",selector:"#field_bugs_closed",useEditIconOnly:true},{fieldID:"depends_on",fieldName:"dependsOn",useEditIconOnly:true},{fieldID:"description",allowMarkdown:true},{fieldID:"summary"},{fieldID:"submitter",fieldName:"submitter",useEditIconOnly:true},{fieldID:"target_groups",fieldName:"targetGroups",useEditIconOnly:true},{fieldID:"target_people",fieldName:"targetPeople",useEditIconOnly:true},{fieldID:"testing_done",fieldName:"testingDone",allowMarkdown:true}],events:{"click #archive-review-request-link":"_onArchiveClicked","click #unarchive-review-request-link":"_onUnarchiveClicked","click #mute-review-request-link":"_onMuteClicked","click #unmute-review-request-link":"_onUnmuteClicked","click #toggle-unarchived":"_onUnarchiveClicked","click #toggle-archived":"_onArchiveClicked"},_archiveActionsTemplate:_.template(`<% if (visibility === RB.ReviewRequest.VISIBILITY_VISIBLE) { %>
 <li><a id="archive-review-request-link" href="#"><%- archiveText %></a></li>
 <li><a id="mute-review-request-link" href="#"><%- muteText %></a></li>
<% } else if (visibility === RB.ReviewRequest.VISIBILITY_ARCHIVED) { %>
 <li><a id="unarchive-review-request-link" href="#"><%- unarchiveText %></a></li>
<% } else if (visibility === RB.ReviewRequest.VISIBILITY_MUTED) { %>
 <li><a id="unmute-review-request-link" href="#"><%- unmuteText %></a></li>
<% } %>`),initialize(){_.bindAll(this,"_checkResizeLayout","_scheduleResizeLayout","_onCloseDiscardedClicked","_onCloseSubmittedClicked","_onDeleteReviewRequestClicked","_onUpdateDiffClicked","_onArchiveClicked","_onUnarchiveClicked","_onMuteClicked","_onUnmuteClicked","_onUploadFileClicked");this._fieldViews={};this._fileAttachmentThumbnailViews=[];this.rendered=false;this.draft=this.model.get("reviewRequest").draft;this.banner=null;this._$main=null;this._$extra=null;this._blockResizeLayout=false},addFieldView(view){this._fieldViews[view.fieldID]=view;view.reviewRequestEditorView=this;this.listenTo(view,"resize",this._scheduleResizeLayout);this.listenTo(view,"fieldError",err=>{this._$warning.delay(6e3).fadeOut(400,()=>this._$warning.hide()).html(err.errorText).show()});this.listenTo(view,"fieldSaved",this.showBanner);if(this.rendered){view.render()}},getFieldView(fieldID){return this._fieldViews[fieldID]},render(){const reviewRequest=this.model.get("reviewRequest");const fileAttachments=this.model.get("fileAttachments");const draft=reviewRequest.draft;this._$box=this.$(".review-request");this._$warning=$("#review-request-warning");this._$screenshots=$("#screenshot-thumbnails");this._$attachments=$("#file-list");this._$attachmentsContainer=$(this._$attachments.parent()[0]);this._$bannersContainer=$("#review-request-banners");this._$main=$("#review-request-main");this._$extra=$("#review-request-extra");this.listenTo(reviewRequest,"change:visibility",this._updateArchiveVisibility);this._updateArchiveVisibility();this.showBanner();if(this.model.get("editable")){RB.DnDUploader.instance.registerDropTarget(this._$attachmentsContainer,gettext("Drop to add a file attachment"),this._uploadFile.bind(this))}this._$attachments.find(".file-container").remove();fileAttachments.each(fileAttachment=>this.buildFileAttachmentThumbnail(fileAttachment,fileAttachments,{noAnimation:true}));this._$attachmentsContainer.find(".djblets-o-spinner").remove();this._$attachmentsContainer.attr("aria-busy","false");this.listenTo(fileAttachments,"add",this.buildFileAttachmentThumbnail);this.listenTo(fileAttachments,"remove",model=>{const index=this._fileAttachmentThumbnailViews.findIndex(view=>view.model===model);this._fileAttachmentThumbnailViews[index].remove();this._fileAttachmentThumbnailViews.splice(index,1)});this.listenTo(fileAttachments,"destroy",()=>{if(fileAttachments.length===0){this._$attachmentsContainer.hide()}});_.each(this._$screenshots.find(".screenshot-container"),this._importScreenshotThumbnail,this);_.each($(".binary"),this._importFileAttachmentThumbnail,this);for(let fieldID in this._fieldViews){if(this._fieldViews.hasOwnProperty(fieldID)){this._fieldViews[fieldID].render()}}$(window).resize(this._scheduleResizeLayout);this.listenTo(this.model,"change:editCount",this._checkResizeLayout);this._checkResizeLayout();this._setupActions();this.model.on("publishError",errorText=>{alert(errorText);this.$("#btn-draft-publish").enable();this.$("#btn-draft-discard").enable()});this.model.on("closeError",errorText=>alert(errorText));this.model.on("saved",this.showBanner,this);this.model.on("published",this._refreshPage,this);reviewRequest.on("closed reopened",this._refreshPage,this);draft.on("destroyed",this._refreshPage,this);window.onbeforeunload=this._onBeforeUnload.bind(this);this.rendered=true;return this},_onBeforeUnload(evt){if(this.model.get("editCount")>0){const msg=gettext("You have unsaved changes that will be lost if you navigate away from this page.");evt=evt||window.event;evt.returnValue=msg;return msg}},showBanner(){if(this.banner){return}const reviewRequest=this.model.get("reviewRequest");const state=reviewRequest.get("state");let BannerClass;if(state===RB.ReviewRequest.CLOSE_SUBMITTED){BannerClass=SubmittedBannerView}else if(state===RB.ReviewRequest.CLOSE_DISCARDED){BannerClass=DiscardedBannerView}else if(state===RB.ReviewRequest.PENDING&&this.model.get("hasDraft")){BannerClass=DraftBannerView}else{return}let $existingBanner=this._$bannersContainer.children();console.assert(BannerClass);console.assert($existingBanner.length<=1);if($existingBanner.length===0){$existingBanner=undefined}this.banner=new BannerClass({el:$existingBanner,reviewRequestEditorView:this});if($existingBanner){$existingBanner.show()}else{this.banner.$el.appendTo(this._$bannersContainer)}this.banner.render()},publishDraft(options){const fields=Object.values(this._fieldViews).filter(view=>view.needsSave());this.model.set({publishing:true,pendingSaveCount:fields.length});if(fields.length===0){this.model.publishDraft(options)}else{fields.forEach(field=>field.finishSave())}},_uploadFile(file){const fileAttachment=this.model.createFileAttachment();fileAttachment.set("file",file);fileAttachment.save()},_setupActions(){const $closeDiscarded=this.$("#discard-review-request-action");const $closeSubmitted=this.$("#submit-review-request-action");const $deletePermanently=this.$("#delete-review-request-action");const $updateDiff=this.$("#upload-diff-action");const $uploadFile=this.$("#upload-file-action");$closeDiscarded.click(this._onCloseDiscardedClicked);$closeSubmitted.click(this._onCloseSubmittedClicked);$deletePermanently.click(this._onDeleteReviewRequestClicked);$updateDiff.click(this._onUpdateDiffClicked);$uploadFile.click(this._onUploadFileClicked);RB.ReviewRequestActionHook.each(hook=>{_.each(hook.get("callbacks"),(handler,selector)=>this.$(selector).click(handler))})},buildFileAttachmentThumbnail(fileAttachment,collection){let options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};const fileAttachmentComments=this.model.get("fileAttachmentComments");const $thumbnail=options.$el;const view=new RB.FileAttachmentThumbnail({el:$thumbnail,model:fileAttachment,comments:fileAttachmentComments[fileAttachment.id],renderThumbnail:$thumbnail===undefined,reviewRequest:this.model.get("reviewRequest"),reviewRequestEditor:this.model,canEdit:this.model.get("editable")===true});view.render();this._fileAttachmentThumbnailViews.push(view);if(!$thumbnail){const fileAttachments=this.model.get("fileAttachments");const index=fileAttachments.indexOf(fileAttachment);this._$attachmentsContainer.show();view.$el.insertBefore(this._$attachments.children().eq(index));if(!options.noAnimation){view.fadeIn()}}this.listenTo(view,"hoverIn",$thumbnail=>{this._$attachments.find(".file").not($thumbnail.find(".file")[0]).addClass("faded")});this.listenTo(view,"hoverOut",()=>this._$attachments.find(".file").removeClass("faded"));view.on("beginEdit",()=>this.model.incr("editCount"));view.on("endEdit",()=>this.model.decr("editCount"));view.on("commentSaved",()=>RB.DraftReviewBannerView.instance.show())},_importFileAttachmentThumbnail(thumbnailEl){const $thumbnail=$(thumbnailEl);const id=$thumbnail.data("file-id");const $caption=$thumbnail.find(".file-caption .edit");const reviewRequest=this.model.get("reviewRequest");const fileAttachment=reviewRequest.draft.createFileAttachment({id:id});if(!$caption.hasClass("empty-caption")){fileAttachment.set("caption",$caption.text())}this.model.get("fileAttachments").add(fileAttachment,{$el:$thumbnail})},_importScreenshotThumbnail(thumbnailEl){const $thumbnail=$(thumbnailEl);const id=$thumbnail.data("screenshot-id");const reviewRequest=this.model.get("reviewRequest");const screenshot=reviewRequest.createScreenshot(id);const view=new RB.ScreenshotThumbnail({el:$thumbnail,model:screenshot});view.render();this.model.get("screenshots").add(screenshot);view.on("beginEdit",()=>this.model.incr("editCount"));view.on("endEdit",()=>this.model.decr("editCount"))},_checkResizeLayout(){if(this._$main.length!==0&&!this._blockResizeLayout){this._resizeLayout()}},_resizeLayout(){const $lastContent=this._$main.children(".review-request-section:last-child");const $lastFieldContainer=$lastContent.children(".field-container");const $lastField=$lastFieldContainer.children(".editable");const lastFieldView=this._fieldViews[$lastField.data("field-id")];const lastContentTop=Math.ceil($lastContent.position().top);const editor=lastFieldView.inlineEditorView.textEditor;const detailsWidth=300;const detailsPadding=10;const $detailsBody=$("#review-request-details tbody");const $detailsLabels=$detailsBody.find("th:first-child");const $detailsValues=$detailsBody.find("span");this._blockResizeLayout=true;$detailsValues.css("max-width",detailsWidth-$detailsLabels.outerWidth()-detailsPadding*3+"px");this._$main.height("auto");$lastContent.height("auto");$lastField.height("auto");if(editor){editor.setSize(null,"auto")}this._$main.height(Math.ceil(this._$extra.offset().top-this._$main.offset().top));const height=this._$main.height();if($lastContent.outerHeight()+lastContentTop<height){$lastContent.outerHeight(height-lastContentTop);const contentHeight=$lastContent.height()-Math.ceil($lastFieldContainer.position().top);if(lastFieldView.inlineEditorView.editing()&&editor){editor.setSize(null,contentHeight-lastFieldView.inlineEditorView.$buttons.height())}else{const newEditableHeight=contentHeight+$lastField.getExtents("m","tb");if(newEditableHeight>$lastField.outerHeight()){$lastField.outerHeight(newEditableHeight)}}}this._blockResizeLayout=false},_scheduleResizeLayout:_.throttleLayout(function(){this._checkResizeLayout()},{defer:true}),_onCloseDiscardedClicked(){const confirmText=gettext("Are you sure you want to discard this review request?");if(confirm(confirmText)){this.model.get("reviewRequest").close({type:RB.ReviewRequest.CLOSE_DISCARDED,error:(model,xhr)=>this.model.trigger("closeError",xhr.errorText)})}return false},_onCloseSubmittedClicked(){let submit=true;if(this.banner){submit=confirm(gettext("You have an unpublished draft. If you close this review request, the draft will be discarded. Are you sure you want to close the review request?"))}if(submit){this.model.get("reviewRequest").close({type:RB.ReviewRequest.CLOSE_SUBMITTED,error:(model,xhr)=>this.model.trigger("closeError",xhr.errorText)})}return false},_onDeleteReviewRequestClicked(){const $dlg=$("<p>").text(gettext("This deletion cannot be undone. All diffs and reviews will be deleted as well.")).modalBox({title:gettext("Are you sure you want to delete this review request?"),buttons:[$(`<input type="button" value="${gettext("Cancel")}"/>`),$(`<input type="button" value="${gettext("Delete")}"/>`).click(()=>{this.model.get("reviewRequest").destroy({buttons:$("input",$dlg.modalBox("buttons")),success:()=>{window.location=SITE_ROOT}})})]});return false},_onUpdateDiffClicked(){const reviewRequest=this.model.get("reviewRequest");const updateDiffView=new RB.UpdateDiffView({model:new RB.UploadDiffModel({changeNumber:reviewRequest.get("commitID"),repository:reviewRequest.get("repository"),reviewRequest:reviewRequest})});updateDiffView.render();return false},_onUploadFileClicked(e){e.stopPropagation();e.preventDefault();const uploadDialog=new RB.UploadAttachmentView({reviewRequestEditor:this.model});uploadDialog.show()},_onArchiveClicked(){return this._updateArchiveState(RB.UserSession.instance.archivedReviewRequests,true,RB.ReviewRequest.VISIBILITY_ARCHIVED)},_onUnarchiveClicked(){return this._updateArchiveState(RB.UserSession.instance.archivedReviewRequests,false,RB.ReviewRequest.VISIBILITY_VISIBLE)},_onMuteClicked(){return this._updateArchiveState(RB.UserSession.instance.mutedReviewRequests,true,RB.ReviewRequest.VISIBILITY_MUTED)},_onUnmuteClicked(){return this._updateArchiveState(RB.UserSession.instance.mutedReviewRequests,false,RB.ReviewRequest.VISIBILITY_VISIBLE)},_updateArchiveState(collection,add,newState){const reviewRequest=this.model.get("reviewRequest");const options={success:()=>reviewRequest.set("visibility",newState)};if(add){collection.addImmediately(reviewRequest,options,this)}else{collection.removeImmediately(reviewRequest,options,this)}return false},_updateArchiveVisibility(){const visibility=this.model.get("reviewRequest").get("visibility");this.$("#hide-review-request-menu").html(this._archiveActionsTemplate({visibility:visibility,archiveText:gettext("Archive"),muteText:gettext("Mute"),unarchiveText:gettext("Unarchive"),unmuteText:gettext("Unmute")}));const visible=visibility===RB.ReviewRequest.VISIBILITY_VISIBLE;const iconClass=visible?"rb-icon-archive-off":"rb-icon-archive-on";const iconTitle=visible?gettext("Archive review request"):gettext("Unarchive review request");const iconId=visible?"toggle-archived":"toggle-unarchived";this.$("#hide-review-request-link").html(`<span class="rb-icon ${iconClass}" id="${iconId}" title="${iconTitle}"></span>`);if(RB.UserSession.instance.get("readOnly")){this.$("#hide-review-request-menu").hide()}},_refreshPage(){window.location=this.model.get("reviewRequest").get("reviewURL")}})})();"use strict";RB.ScreenshotThumbnail=Backbone.View.extend({events:{"click a.delete":"_onDeleteClicked"},render(){this.listenTo(this.model,"destroy",()=>{this.$el.fadeOut(()=>this.remove())});this.$caption=this.$el.find("a.edit").inlineEditor({editIconClass:"rb-icon rb-icon-edit",showButtons:false}).on({beginEdit:()=>this.trigger("beginEdit"),cancel:()=>this.trigger("endEdit"),complete:(e,value)=>{this.model.ready({ready:()=>{this.model.set("caption",value);this.trigger("endEdit");this.model.save()}})}});return this},_onDeleteClicked(e){e.preventDefault();e.stopPropagation();this.model.destroy()}});"use strict";(function(){const scalingFactors=new Map([[.33,"33%"],[.5,"50%"],[1,"100%"],[2,"200%"]]);const BaseImageView=Backbone.View.extend({template:null,mode:null,name:null,initialize(){this.$commentRegion=null;this.listenTo(this.model,"change:scale",(model,scale)=>this._onScaleChanged(scale))},className(){return`image-diff-${this.mode}`},loadImages($images){const scale=this.model.get("scale");let loadsRemaining=$images.length;this._$images=$images;$images.each((ix,image)=>{const $image=$(image);if($image.data("initial-width")===undefined){image.onload=()=>{loadsRemaining--;console.assert(loadsRemaining>=0);$image.data({"initial-width":image.width,"initial-height":image.height}).css({width:image.width*scale,height:image.height*scale});if(loadsRemaining===0){this.onImagesLoaded();this.trigger("regionChanged")}}}else{loadsRemaining--;if(loadsRemaining===0){this.onImagesLoaded();this.trigger("regionChanged")}}})},getSelectionRegion(){const $region=this.$commentRegion;const offset=$region.position();offset.left+=$region.getExtents("m","l");return{left:offset.left,top:offset.top,width:$region.width(),height:$region.height()}},onImagesLoaded(){let scale=null;const filename=this.model.get("filename");if(filename){if(filename.includes("@2x.")){scale=.5}else if(filename.includes("@3x.")){scale=.33}}if(scale===null){const{width}=this.getInitialSize();const maxWidth=this.$el.closest(".image-content").width();const scales=Array.from(scalingFactors.keys()).filter(f=>f<=1);for(let i=scales.length-1;i>=0;i--){scale=scales[i];if(width*scale<=maxWidth){break}}}this.model.set("scale",scale)},_onScaleChanged(scale){this._$images.each((index,el)=>{const $image=$(el);$image.css({width:$image.data("initial-width")*scale,height:$image.data("initial-height")*scale})})},getInitialSize(){console.assert(false,"subclass of BaseImageView must implement getInitialSize")}});const ImageAttachmentView=BaseImageView.extend({mode:"attachment",tagName:"img",render(){this.$el.attr({title:this.model.get("caption"),src:this.model.get("imageURL")});this.$commentRegion=this.$el;this.loadImages(this.$el);return this},getInitialSize(){const $img=this._$images.eq(0);return{width:$img.data("initial-width"),height:$img.height("initial-height")}}});const ImageDifferenceDiffView=BaseImageView.extend({mode:"difference",name:gettext("Difference"),template:_.template(['<div class="image-container">'," <canvas></canvas>","</div>"].join("")),initialize(){_super(this).initialize.call(this);this._origImage=null;this._modifiedImage=null},render(){this.$el.html(this.template(this.model.attributes));this.$commentRegion=this.$("canvas");this._$canvas=this.$commentRegion;this._origImage=new Image;this._origImage.src=this.model.get("diffAgainstImageURL");this._modifiedImage=new Image;this._modifiedImage.src=this.model.get("imageURL");this.loadImages($([this._origImage,this._modifiedImage]));return this},onImagesLoaded(){const origImage=this._origImage;const modifiedImage=this._modifiedImage;const scale=this.model.get("scale");this._maxWidth=Math.max(origImage.width,modifiedImage.width);this._maxHeight=Math.max(origImage.height,modifiedImage.height);_super(this).onImagesLoaded.call(this);this._$canvas.attr({width:this._maxWidth,height:this._maxHeight}).css({width:this._maxWidth*scale+"px",height:this._maxHeight*scale+"px"});const $modifiedCanvas=$("<canvas/>").attr({width:this._maxWidth,height:this._maxHeight});const origContext=this._$canvas[0].getContext("2d");origContext.drawImage(origImage,0,0);const modifiedContext=$modifiedCanvas[0].getContext("2d");modifiedContext.drawImage(modifiedImage,0,0);const origImageData=origContext.getImageData(0,0,this._maxWidth,this._maxHeight);const origPixels=origImageData.data;const modifiedPixels=modifiedContext.getImageData(0,0,this._maxWidth,this._maxHeight).data;for(let i=0;i<origPixels.length;i+=4){origPixels[i]+=modifiedPixels[i]-2*Math.min(origPixels[i],modifiedPixels[i]);origPixels[i+1]+=modifiedPixels[i+1]-2*Math.min(origPixels[i+1],modifiedPixels[i+1]);origPixels[i+2]+=modifiedPixels[i+2]-2*Math.min(origPixels[i+2],modifiedPixels[i+2]);origPixels[i+3]=modifiedPixels[i+3]}origContext.putImageData(origImageData,0,0)},_onScaleChanged(scale){this._$canvas.css({width:this._maxWidth*scale+"px",height:this._maxHeight*scale+"px"})},getInitialSize(){return{width:this._maxWidth,height:this._maxHeight}}});const ImageOnionDiffView=BaseImageView.extend({mode:"onion",name:gettext("Onion Skin"),template:_.template(['<div class="image-containers">',' <div class="orig-image">','  <img title="<%- caption %>" src="<%- diffAgainstImageURL %>" />'," </div>",' <div class="modified-image">','  <img title="<%- caption %>" src="<%- imageURL %>" />'," </div>","</div>",'<div class="image-slider"></div>'].join("")),DEFAULT_OPACITY:.25,initialize(){_super(this).initialize.call(this);this._$origImage=null;this._$modifiedImage=null;this._$modifiedImageContainer=null},render(){this.$el.html(this.template(this.model.attributes));this.$commentRegion=this.$(".image-containers");this._$origImage=this.$(".orig-image img");this._$modifiedImage=this.$(".modified-image img");this._$modifiedImageContainer=this._$modifiedImage.parent();this.$(".image-slider").slider({value:this.DEFAULT_OPACITY*100,slide:(e,ui)=>this.setOpacity(ui.value/100)});this.setOpacity(this.DEFAULT_OPACITY);this.loadImages(this.$("img"));return this},setOpacity(percentage){this._$modifiedImageContainer.css("opacity",percentage)},onImagesLoaded(){_super(this).onImagesLoaded.call(this);this._resize()},_onScaleChanged(scale){_super(this)._onScaleChanged.call(this,scale);this._resize()},_resize(){const scale=this.model.get("scale");const origW=this._$origImage.data("initial-width")*scale;const origH=this._$origImage.data("initial-height")*scale;const newW=this._$modifiedImage.data("initial-width")*scale;const newH=this._$modifiedImage.data("initial-height")*scale;this._$origImage.parent().width(origW).height(origH);this._$modifiedImage.parent().width(newW).height(newH);this.$(".image-containers").width(Math.max(origW,newW)).height(Math.max(origH,newH))},getInitialSize(){return{width:Math.max(this._$origImage.data("initial-width"),this._$modifiedImage.data("initial-width")),height:Math.max(this._$origImage.data("initial-height"),this._$modifiedImage.data("initial-height"))}}});const ImageSplitDiffView=BaseImageView.extend({mode:"split",name:gettext("Split"),template:_.template(['<div class="image-containers">',' <div class="image-diff-split-container-orig">','  <div class="orig-image">','   <img title="<%- caption %>" src="<%- diffAgainstImageURL %>" />',"  </div>"," </div>",' <div class="image-diff-split-container-modified">','  <div class="modified-image">','   <img title="<%- caption %>" src="<%- imageURL %>" />',"  </div>"," </div>","</div>",'<div class="image-slider"></div>'].join("")),DEFAULT_SPLIT_PCT:.25,initialize(){_super(this).initialize.call(this);this._$modifiedImage=null;this._$origImage=null;this._$origSplitContainer=null;this._$modifiedSplitContainer=null;this._$slider=null;this._maxWidth=0},render(){this.$el.html(this.template(this.model.attributes));this.$commentRegion=this.$(".image-containers");this._$origImage=this.$(".orig-image img");this._$modifiedImage=this.$(".modified-image img");this._$origSplitContainer=this.$(".image-diff-split-container-orig");this._$modifiedSplitContainer=this.$(".image-diff-split-container-modified");this._$slider=this.$(".image-slider").slider({value:this.DEFAULT_SPLIT_PCT*100,slide:(e,ui)=>this.setSplitPercentage(ui.value/100)});this.loadImages(this.$("img"));return this},setSplitPercentage(percentage){this._$origSplitContainer.outerWidth(this._maxWidth*percentage);this._$modifiedSplitContainer.outerWidth(this._maxWidth*(1-percentage))},onImagesLoaded(){_super(this).onImagesLoaded.call(this);this._resize()},_onScaleChanged(scale){_super(this)._onScaleChanged.call(this,scale);this._resize()},_resize(){const $origImageContainer=this._$origImage.parent();const scale=this.model.get("scale");const origW=this._$origImage.data("initial-width")*scale;const origH=this._$origImage.data("initial-height")*scale;const newW=this._$modifiedImage.data("initial-width")*scale;const newH=this._$modifiedImage.data("initial-height")*scale;const maxH=Math.max(origH,newH);const maxOuterH=maxH+$origImageContainer.getExtents("b","tb");this._maxWidth=Math.max(origW,newW);this._maxHeight=Math.max(origH,newH);$origImageContainer.outerWidth(origW).height(origH);this._$modifiedImage.parent().outerWidth(newW).height(newH);this._$origSplitContainer.outerWidth(this._maxWidth).height(maxOuterH);this._$modifiedSplitContainer.outerWidth(this._maxWidth).height(maxOuterH);this.$(".image-containers").width(this._maxWidth).height(maxH);this._$slider.width(this._maxWidth);this.setSplitPercentage(this.DEFAULT_SPLIT_PCT)},getInitialSize(){return{width:this._maxWidth,height:this._maxHeight}}});const ImageTwoUpDiffView=BaseImageView.extend({mode:"two-up",name:gettext("Two-Up"),template:_.template(['<div class="image-container image-container-orig">',' <div class="orig-image">','  <img title="<%- caption %>" src="<%- diffAgainstImageURL %>" />'," </div>","</div>",'<div class="image-container image-container-modified">',' <div class="modified-image">','  <img title="<%- caption %>" src="<%- imageURL %>" />'," </div>","</div>"].join("")),render(){this.$el.html(this.template(this.model.attributes));this.$commentRegion=this.$(".modified-image img");this._$origImage=this.$(".orig-image img");this._$modifiedImage=this.$(".modified-image img");this.loadImages(this.$("img"));return this},getInitialSize(){return{width:Math.max(this._$origImage.data("initial-width"),this._$modifiedImage.data("initial-width")),height:Math.max(this._$origImage.data("initial-height"),this._$modifiedImage.data("initial-height"))}}});RB.ImageReviewableView=RB.FileAttachmentReviewableView.extend({className:"image-review-ui",commentBlockView:RB.RegionCommentBlockView,events:{"click .image-diff-mode":"_onImageModeClicked","click .image-resolution-menu .menu-item":"_onImageZoomLevelClicked","mousedown .selection-container":"_onMouseDown","mouseup .selection-container":"_onMouseUp","mousemove .selection-container":"_onMouseMove"},modeItemTemplate:_.template('<li><a class="image-diff-mode" href="#" data-mode="<%- mode %>"><%- name %></a></li>'),captionTableTemplate:_.template("<table><tr><%= items %></tr></table>"),captionItemTemplate:_.template(["<td>",' <h1 class="caption">',"  <%- caption %>"," </h1>","</td>"].join("")),errorTemplate:_.template(['<div class="review-ui-error">',' <div class="rb-icon rb-icon-warning"></div>'," <%- errorStr %>","</div>"].join("")),ANIM_SPEED_MS:200,initialize(){RB.FileAttachmentReviewableView.prototype.initialize.apply(this,arguments);_.bindAll(this,"_adjustPos");this._activeSelection={};this._diffModeSelectors={};this._diffModeViews={};this._commentBlockViews=[];this.on("commentBlockViewAdded",commentBlockView=>{commentBlockView.setSelectionRegionSizeFunc(()=>_.pick(this._imageView.getSelectionRegion(),"width","height"));commentBlockView.setScale(this.model.get("scale"));this._$selectionArea.append(commentBlockView.$el);this._commentBlockViews.push(commentBlockView);this.listenTo(commentBlockView,"removing",()=>{this._commentBlockViews=_.without(this._commentBlockViews,commentBlockView)})});this.listenTo(this.model,"change:scale",(model,scale)=>{this._commentBlockViews.forEach(view=>view.setScale(scale));this.$(".image-resolution-menu-current").text(scalingFactors.get(scale));_.defer(this._adjustPos)})},renderContent(){const hasDiff=!!this.model.get("diffAgainstFileAttachmentID");this._$selectionArea=$("<div/>").addClass("selection-container").hide().proxyTouchEvents();this._$selectionRect=$("<div/>").addClass("selection-rect").prependTo(this._$selectionArea).proxyTouchEvents().hide();this.$el.hover(()=>{this._$selectionArea.show();this._adjustPos()},()=>{if(this._$selectionRect.is(":hidden")&&!this.commentDlg){this._$selectionArea.hide()}});const $wrapper=$('<div class="image-content" />').append(this._$selectionArea);if(this.model.get("diffTypeMismatch")){this.$el.append(this.errorTemplate({errorStr:gettext("These revisions cannot be compared because they are different file types.")}))}else if(hasDiff){this._$modeBar=$('<ul class="image-diff-modes"/>').appendTo(this.$el);this._$imageDiffs=$('<div class="image-diffs"/>');this._addDiffMode(ImageTwoUpDiffView);this._addDiffMode(ImageDifferenceDiffView);this._addDiffMode(ImageSplitDiffView);this._addDiffMode(ImageOnionDiffView);$wrapper.append(this._$imageDiffs).appendTo(this.$el);this._setDiffMode(ImageTwoUpDiffView.prototype.mode)}else{this._imageView=new ImageAttachmentView({model:this.model});$wrapper.append(this._imageView.$el).appendTo(this.$el);this._imageView.render()}$(window).on({load:this._adjustPos,resize:this._adjustPos});const $header=$("<div />").addClass("review-ui-header").prependTo(this.$el);if(this.model.get("numRevisions")>1){const $revisionLabel=$('<div id="revision_label" />').appendTo($header);this._revisionLabelView=new RB.FileAttachmentRevisionLabelView({el:$revisionLabel,model:this.model});this._revisionLabelView.render();this.listenTo(this._revisionLabelView,"revisionSelected",this._onRevisionSelected);const $revisionSelector=$('<div id="attachment_revision_selector" />').appendTo($header);this._revisionSelectorView=new RB.FileAttachmentRevisionSelectorView({el:$revisionSelector,model:this.model});this._revisionSelectorView.render();this.listenTo(this._revisionSelectorView,"revisionSelected",this._onRevisionSelected);if(!this.renderedInline){if(hasDiff){const captionItems=[this.captionItemTemplate({caption:interpolate(gettext("%(caption)s (revision %(revision)s)"),{caption:this.model.get("diffCaption"),revision:this.model.get("diffRevision")},true)}),this.captionItemTemplate({caption:interpolate(gettext("%(caption)s (revision %(revision)s)"),{caption:this.model.get("caption"),revision:this.model.get("fileRevision")},true)})];$header.append(this.captionTableTemplate({items:captionItems.join("")}))}else{const $captionBar=$('<div class="image-single-revision">').appendTo($header);$('<h1 class="caption" />').text(interpolate(gettext("%(caption)s (revision %(revision)s)"),{caption:this.model.get("caption"),revision:this.model.get("fileRevision")},true)).appendTo($captionBar)}}}else{if(!this.renderedInline){$header.addClass("image-single-revision");$('<h1 class="caption" />').text(this.model.get("caption")).appendTo($header)}}const $resolutionMenu=$(['<li class="image-resolution-menu has-menu">',' <a href="#" class="menu-header">','  <span class="fa fa-search-plus"></span>','  <span class="image-resolution-menu-current">100%</span>','  <span class="rb-icon rb-icon-dropdown-arrow">'," </a>",' <ul class="menu" />',"</li>"].join(""));const $menu=$resolutionMenu.find(".menu");scalingFactors.forEach((text,scale)=>{$(`<li class="menu-item" data-image-scale="${scale}" />`).text(text).appendTo($menu)});if(hasDiff){this._$modeBar.append($resolutionMenu)}else{this.$(".caption").after($resolutionMenu)}},_onRevisionSelected(revisions){const revisionIDs=this.model.get("attachmentRevisionIDs");const[base,tip]=revisions;if(tip===0){return}const revisionTip=revisionIDs[tip-1];let redirectURL;if(base===0){redirectURL=`../${revisionTip}/`}else{const revisionBase=revisionIDs[base-1];redirectURL=`../${revisionBase}-${revisionTip}/`}window.location.replace(redirectURL)},_addDiffMode(ViewClass){const mode=ViewClass.prototype.mode;const view=new ViewClass({model:this.model});this._diffModeViews[mode]=view;view.$el.hide();this._$imageDiffs.append(view.$el);view.render();const $selector=$(this.modeItemTemplate({mode:mode,name:view.name}));$selector.appendTo(this._$modeBar).addClass("selected");const selectorWidth=$selector.outerWidth(true);$selector.removeClass("selected").width(selectorWidth);this._diffModeSelectors[mode]=$selector},_setDiffMode(mode){const newView=this._diffModeViews[mode];if(this._imageView){this._diffModeSelectors[this._imageView.mode].removeClass("selected");newView.$el.show();const height=newView.$el.height();newView.$el.hide();this._$imageDiffs.animate({height:height,duration:this.ANIM_SPEED_MS});this._$selectionArea.fadeOut(this.ANIM_SPEED_MS);this._imageView.$el.fadeOut(this.ANIM_SPEED_MS,()=>this._showDiffMode(newView,true))}else{this._showDiffMode(newView)}this._diffModeSelectors[newView.mode].addClass("selected")},_showDiffMode(newView,animate){if(this._imageView){this.stopListening(this._imageView,"regionChanged")}this._imageView=newView;if(animate){this._imageView.$el.fadeIn(this.ANIM_SPEED_MS);this._$selectionArea.fadeIn(this.ANIM_SPEED_MS)}else{this._imageView.$el.show();this._$selectionArea.show()}this.listenTo(this._imageView,"regionChanged",this._adjustPos);this._adjustPos()},_onImageModeClicked(e){e.preventDefault();e.stopPropagation();this._setDiffMode($(e.target).data("mode"))},_onImageZoomLevelClicked(e){e.preventDefault();e.stopPropagation();this.model.set("scale",$(e.target).data("image-scale"))},_onMouseDown(e){if(e.which===1&&!this.commentDlg&&!$(e.target).hasClass("selection-flag")){const offset=this._$selectionArea.offset();this._activeSelection.beginX=e.pageX-Math.floor(offset.left)-1;this._activeSelection.beginY=e.pageY-Math.floor(offset.top)-1;const updateData={left:this._activeSelection.beginX,top:this._activeSelection.beginY,width:1,height:1};this._$selectionRect.css(updateData).data(updateData).show();if(this._$selectionRect.is(":hidden")){this.commentDlg.close()}return false}},_onMouseUp(e){if(!this.commentDlg&&this._$selectionRect.is(":visible")){e.stopPropagation();this._$selectionRect.hide();const position=this._$selectionRect.data();const scale=this.model.get("scale");if(position.width>5&&position.height>5){this.createAndEditCommentBlock({x:Math.floor(position.left/scale),y:Math.floor(position.top/scale),width:Math.floor(position.width/scale),height:Math.floor(position.height/scale)})}}},_onMouseMove(e){if(!this.commentDlg&&this._$selectionRect.is(":visible")){const offset=this._$selectionArea.offset();const x=e.pageX-Math.floor(offset.left)-1;const y=e.pageY-Math.floor(offset.top)-1;const updateData={};if(this._activeSelection.beginX<=x){updateData.left=this._activeSelection.beginX;updateData.width=x-this._activeSelection.beginX}else{updateData.left=x;updateData.width=this._activeSelection.beginX-x}if(this._activeSelection.beginY<=y){updateData.top=this._activeSelection.beginY;updateData.height=y-this._activeSelection.beginY}else{updateData.top=y;updateData.height=this._activeSelection.beginY-y}this._$selectionRect.css(updateData).data(updateData);return false}},_adjustPos(){const region=this._imageView.getSelectionRegion();this._$selectionArea.width(region.width).height(region.height).css({left:region.left,top:region.top});if(this._$imageDiffs){this._$imageDiffs.height(this._imageView.$el.height())}}})})();"use strict";RB.DummyReviewableView=RB.FileAttachmentReviewableView.extend({commentBlockView:RB.AbstractCommentBlockView,captionTableTemplate:_.template("<table><tr><%= items %></tr></table>"),captionItemTemplate:_.template(`<td>
 <h1 class="caption"><%- caption %></h1>
</td>`),renderContent(){const $header=$("<div/>").addClass("review-ui-header").prependTo(this.$el);if(this.model.get("numRevisions")>1){const $revisionLabel=$('<div id="revision_label"/>').appendTo($header);this._revisionLabelView=new RB.FileAttachmentRevisionLabelView({el:$revisionLabel,model:this.model});this._revisionLabelView.render();this.listenTo(this._revisionLabelView,"revisionSelected",this._onRevisionSelected);const $revisionSelector=$('<div id="attachment_revision_selector" />').appendTo($header);this._revisionSelectorView=new RB.FileAttachmentRevisionSelectorView({el:$revisionSelector,model:this.model});this._revisionSelectorView.render();this.listenTo(this._revisionSelectorView,"revisionSelected",this._onRevisionSelected);const captionItems=[];captionItems.push(this.captionItemTemplate({caption:interpolate(gettext("%(caption)s (revision %(revision)s)"),{caption:this.model.get("caption"),revision:this.model.get("fileRevision")},true)}));if(this.model.get("diffAgainstFileAttachmentID")!==null){captionItems.push(this.captionItemTemplate({caption:interpolate(gettext("%(caption)s (revision %(revision)s)"),{caption:this.model.get("diffCaption"),revision:this.model.get("diffRevision")},true)}))}$header.append(this.captionTableTemplate({items:captionItems.join("")}))}else{$('<h1 class="caption file-attachment-single-revision">').text(this.model.get("caption")).appendTo($header)}},_onRevisionSelected(revisions){const[base,tip]=revisions;if(tip===0){return}const revisionIDs=this.model.get("attachmentRevisionIDs");const revisionTip=revisionIDs[tip-1];let redirectURL;if(base===0){redirectURL=`../${revisionTip}/`}else{const revisionBase=revisionIDs[base-1];redirectURL=`../${revisionBase}-${revisionTip}/`}window.location.replace(redirectURL)}});"use strict";RB.TextBasedCommentBlockView=RB.AbstractCommentBlockView.extend({tagName:"span",className:"commentflag",template:_.template(`<span class="commentflag-shadow"></span>
<span class="commentflag-inner">
 <span class="commentflag-count"></span>
</span>
<a name="<%= anchorName %>" class="commentflag-anchor"></a>`),initialize(){this.$beginRow=null;this.$endRow=null;this._$window=$(window);this._prevCommentHeight=null;this._prevWindowWidth=null;this._resizeRegistered=false},renderContent(){this.$el.html(this.template(_.defaults(this.model.attributes,{anchorName:this.buildAnchorName()})));this.$(".commentflag-count").bindProperty("text",this.model,"count",{elementToModel:false})},remove(){Backbone.View.prototype.remove.call(this);if(this._resizeRegistered){this._$window.off("resize."+this.cid)}},setRows($beginRow,$endRow){this.$beginRow=$beginRow;this.$endRow=$endRow;_.defer(_.bind(function(){this._updateSize();this.$el.show()},this));if($beginRow&&$endRow){if(!this._resizeRegistered){this._$window.on("resize."+this.cid,_.bind(this._updateSize,this))}}else{if(this._resizeRegistered){this._$window.off("resize."+this.cid)}}},positionCommentDlg(commentDlg){commentDlg.$el.css({left:$(document).scrollLeft()+(this._$window.width()-commentDlg.$el.width())/2,top:this.$endRow.offset().top+this.$endRow.height()})},positionNotifyBubble($bubble){$bubble.css({left:this.$el.width(),top:0})},buildAnchorName(){return`line${this.model.get("beginLineNum")}`},_updateSize(){const windowWidth=this._$window.width();if(this._prevWindowWidth===windowWidth){return}this._prevWindowWidth=windowWidth;const commentHeight=this.$endRow.offset().top+this.$endRow.outerHeight()-this.$beginRow.offset().top-(this.$el.getExtents("m","t")||-4);if(commentHeight!==this._prevCommentHeight){this.$el.height(commentHeight);this._prevCommentHeight=commentHeight}}});"use strict";RB.TextBasedReviewableView=RB.FileAttachmentReviewableView.extend({commentBlockView:RB.TextBasedCommentBlockView,initialize(options){RB.FileAttachmentReviewableView.prototype.initialize.call(this,options);this._$viewTabs=null;this._$textTable=null;this._$renderedTable=null;this._textSelector=null;this._renderedSelector=null;this.on("commentBlockViewAdded",this._placeCommentBlockView,this);this.router=new Backbone.Router({routes:{":viewMode(/line:lineNum)":"viewMode"}});this.listenTo(this.router,"route:viewMode",(viewMode,lineNum)=>{if(viewMode.indexOf("line")===0){lineNum=viewMode.substr(4);viewMode=null}if(viewMode){this.model.set("viewMode",viewMode)}if(lineNum){this._scrollToLine(lineNum)}})},remove(){_super(this).remove.call(this);this._textSelector.remove();this._renderedSelector.remove()},renderContent(){this._$viewTabs=this.$(".text-review-ui-views li");this._$textTable=this.$(".text-review-ui-text-table");this._textSelector=new RB.TextCommentRowSelector({el:this._$textTable,reviewableView:this});this._textSelector.render();if(this.model.get("hasRenderedView")){this._$renderedTable=this.$(".text-review-ui-rendered-table");this._renderedSelector=new RB.TextCommentRowSelector({el:this._$renderedTable,reviewableView:this});this._renderedSelector.render()}this.listenTo(this.model,"change:viewMode",this._onViewChanged);const $fileHeader=this.$(".review-ui-header");if(this.model.get("numRevisions")>1){this._revisionSelectorView=new RB.FileAttachmentRevisionSelectorView({el:$fileHeader.find("#attachment_revision_selector"),model:this.model});this._revisionSelectorView.render();this.listenTo(this._revisionSelectorView,"revisionSelected",this._onRevisionSelected);this._revisionLabelView=new RB.FileAttachmentRevisionLabelView({el:$fileHeader.find("#revision_label"),model:this.model});this._revisionLabelView.render();this.listenTo(this._revisionLabelView,"revisionSelected",this._onRevisionSelected)}const reviewURL=this.model.get("reviewRequest").get("reviewURL");const attachmentID=this.model.get("fileAttachmentID");const diffID=this.model.get("diffAgainstFileAttachmentID");Backbone.history.start({root:diffID==null?`${reviewURL}file/${attachmentID}/`:`${reviewURL}file/${diffID}-${attachmentID}/`})},_onRevisionSelected(revisions){const[base,tip]=revisions;if(tip===0){return}const revisionIDs=this.model.get("attachmentRevisionIDs");const revisionTip=revisionIDs[tip-1];let redirectURL;if(base===0){redirectURL=`../${revisionTip}/`}else{const revisionBase=revisionIDs[base-1];redirectURL=`../${revisionBase}-${revisionTip}/`}window.location.replace(redirectURL)},_scrollToLine(lineNum){const $table=this._getTableForViewMode(this.model.get("viewMode"));const rows=$table[0].tBodies[0].rows;lineNum=RB.MathUtils.clip(lineNum,1,rows.length)-1;const $row=$($table[0].tBodies[0].rows[lineNum]);$(window).scrollTop($row.offset().top)},_getTableForViewMode(viewMode){if(viewMode==="source"){return this._$textTable}else if(viewMode==="rendered"&&this.model.get("hasRenderedView")){return this._$renderedTable}else{console.assert(false,"Unexpected viewMode "+viewMode);return null}},_getRowSelectorForViewMode(viewMode){if(viewMode==="source"){return this._textSelector}else if(viewMode==="rendered"&&this.model.get("hasRenderedView")){return this._renderedSelector}else{console.assert(false,"Unexpected viewMode "+viewMode);return null}},_placeCommentBlockView(commentBlockView){const commentBlock=commentBlockView.model;const beginLineNum=commentBlock.get("beginLineNum");const endLineNum=commentBlock.get("endLineNum");if(beginLineNum&&endLineNum){const viewMode=commentBlock.get("viewMode");const rowSelector=this._getRowSelectorForViewMode(viewMode);if(!rowSelector){return}let rowEls;if(this.model.get("diffRevision")){rowEls=rowSelector.getRowsForRange(beginLineNum,endLineNum)}else{const rows=rowSelector.el.tBodies[0].rows;rowEls=[rows[beginLineNum-1],rows[endLineNum-1]]}if(rowEls){commentBlockView.setRows($(rowEls[0]),$(rowEls[1]));commentBlockView.$el.appendTo(commentBlockView.$beginRow[0].cells[0])}}},_onViewChanged(){const viewMode=this.model.get("viewMode");this._$viewTabs.removeClass("active").filter(`[data-view-mode=${viewMode}]`).addClass("active");this._$textTable.setVisible(viewMode==="source");this._$renderedTable.setVisible(viewMode==="rendered");$(window).triggerHandler("resize")}});"use strict";RB.TextCommentRowSelector=Backbone.View.extend({ghostCommentFlagTemplate:`<span class="commentflag ghost-commentflag">
 <span class="commentflag-shadow"></span>
 <span class="commentflag-inner"></span>
</span>`,events:{copy:"_onCopy",mousedown:"_onMouseDown",mouseup:"_onMouseUp",mouseover:"_onMouseOver",mouseout:"_onMouseOut",touchstart:"_onTouchStart",touchend:"_onTouchEnd",touchmove:"_onTouchMove",touchcancel:"_onTouchCancel"},initialize(options){this.options=options;this._$begin=null;this._$end=null;this._beginLineNum=0;this._endLineNum=0;this._lastSeenIndex=0;this._selectionClass=null;this._supportsSetClipboard=window.getSelection!==undefined&&window.Range!==undefined&&window.Range.prototype.cloneContents!==undefined;this._newlineChar=null;this._$ghostCommentFlag=null;this._$ghostCommentFlagCell=null},remove(){Backbone.View.prototype.remove.call(this);this._$ghostCommentFlag.remove()},render(){this._$ghostCommentFlag=$(this.ghostCommentFlagTemplate).on({mousedown:_.bind(this._onMouseDown,this),mouseup:_.bind(this._onMouseUp,this),mouseover:_.bind(this._onMouseOver,this),mouseout:_.bind(this._onMouseOut,this)}).hide().appendTo("body");return this},createComment(beginLineNum,endLineNum,beginNode,endNode){this._beginLineNum=beginLineNum;this._endLineNum=endLineNum;this._$begin=this._getActualLineNumCell($(beginNode)).parent();this._$end=this._getActualLineNumCell($(endNode)).parent();if(this._isLineNumCell(endNode)){this._end(this._getActualLineNumCell($(endNode)).parent())}this._reset()},getRowsForRange(beginLineNum,endLineNum,minRowIndex){const beginRowEl=this.findLineNumRow(beginLineNum,minRowIndex);if(beginRowEl){const rowIndex=beginRowEl.rowIndex;const endRowEl=endLineNum===beginLineNum?beginRowEl:this.findLineNumRow(endLineNum,rowIndex,rowIndex+endLineNum-beginLineNum);return[beginRowEl,endRowEl]}else{return null}},findLineNumRow(lineNum,startRow,endRow){const table=this.el;const rowOffset=1;let row=null;if(table.rows.length-rowOffset>lineNum){row=table.rows[rowOffset+lineNum];if(row&&this.getLineNum(row)===lineNum){return row}}if(startRow){startRow-=rowOffset}let low=startRow||0;let high=Math.min(endRow||table.rows.length,table.rows.length);if(endRow!==undefined&&endRow<table.rows.length){if(this.getLineNum(table.rows[endRow])===lineNum){return table.rows[endRow]}}else if(row!==null){high=Math.min(high,rowOffset+lineNum)}for(let i=Math.round((low+high)/2);low<high-1;){row=table.rows[rowOffset+i];if(!row){high--;i=Math.round((low+high)/2);continue}let value=this.getLineNum(row);if(!value){let found=false;for(let j=1;j<=(high-low)/2;j++){row=table.rows[rowOffset+i+j];if(row&&this.getLineNum(row)){i=i+j;found=true;break}else{row=table.rows[rowOffset+i-j];if(row&&this.getLineNum(row)){i=i-j;found=true;break}}}if(found){value=this.getLineNum(row)}else{return null}}const guessRowNum=lineNum-value+rowOffset+i;if(guessRowNum>=0&&guessRowNum<table.rows.length){const guessRow=table.rows[guessRowNum];if(guessRow&&this.getLineNum(guessRow)===lineNum){return guessRow}}const oldHigh=high;const oldLow=low;if(value>lineNum){high=i}else if(value<lineNum){low=i}else{return row}if(oldHigh===high&&oldLow===low){break}i=Math.round((low+high)/2)}return null},_begin($row){const lineNum=this.getLineNum($row[0]);this._$begin=$row;this._$end=$row;this._beginLineNum=lineNum;this._endLineNum=lineNum;this._lastSeenIndex=$row[0].rowIndex;$row.addClass("selected");this.$el.disableSelection()},_end($row){if(this._beginLineNum===this._endLineNum){const $commentFlag=$row.find(".commentflag");if($commentFlag.length===1){$commentFlag.click();return}}this.options.reviewableView.createAndEditCommentBlock({beginLineNum:this._beginLineNum,endLineNum:this._endLineNum,$beginRow:this._$begin,$endRow:this._$end})},_addRow($row){const lineNum=this.getLineNum($row[0]);if(lineNum<this._beginLineNum){this._$begin=$row;this._beginLineNum=lineNum}else if(lineNum>this._beginLineNum){this._$end=$row;this._endLineNum=lineNum}const min=Math.min(this._lastSeenIndex,$row[0].rowIndex);const max=Math.max(this._lastSeenIndex,$row[0].rowIndex);for(let i=min;i<=max;i++){$(this.el.rows[i]).addClass("selected")}this._lastSeenIndex=$row[0].rowIndex},_highlightRow($row){const $lineNumCell=$($row[0].cells[0]);if($lineNumCell.find(".commentflag").length===0){this._$ghostCommentFlag.css("top",$row.offset().top-1).show().parent().removeClass("selected");this._$ghostCommentFlagCell=$lineNumCell}$row.addClass("selected")},_removeOldRows($row){const destRowIndex=$row[0].rowIndex;if(destRowIndex>=this._$begin[0].rowIndex){if(this._lastSeenIndex!==this._$end[0].rowIndex&&this._lastSeenIndex<destRowIndex){this._removeSelectionClasses(this._lastSeenIndex,destRowIndex);this._$begin=$row;this._beginLineNum=this.getLineNum($row[0])}else{this._removeSelectionClasses(destRowIndex,this._lastSeenIndex);this._$end=$row;this._endLineNum=this.getLineNum($row[0])}this._lastSeenIndex=destRowIndex}},_reset(){if(this._$begin){this._removeSelectionClasses(this._$begin[0].rowIndex,this._$end[0].rowIndex);this._$begin=null;this._$end=null;this._beginLineNum=0;this._endLineNum=0;this._lastSeenIndex=0}this._$ghostCommentFlagCell=null;this.$el.enableSelection()},_removeSelectionClasses(startRowIndex,endRowIndex){for(let i=startRowIndex;i<=endRowIndex;i++){$(this.el.rows[i]).removeClass("selected")}},_isLineNumCell(cell){return cell.tagName==="TH"&&cell.parentNode.getAttribute("line")},_getActualLineNumCell($node){if($node.hasClass("commentflag")){if($node[0]===this._$ghostCommentFlag[0]){return this._$ghostCommentFlagCell}else{return $node.parent()}}return $node},_onCopy(e){const clipboardData=e.originalEvent.clipboardData||window.clipboardData;if(clipboardData&&this._supportsSetClipboard&&this._copySelectionToClipboard(clipboardData)){e.preventDefault();e.stopPropagation()}},_findPreTags(result,parentEl,tdClass,excludeTBodyClass){for(let i=0;i<parentEl.children.length;i++){const node=parentEl.children[i];if(node.nodeType===Node.ELEMENT_NODE){if(node.tagName==="PRE"){result.push(node)}else if((node.tagName!=="TD"||$(node).hasClass(tdClass))&&(node.tagName!=="TBODY"||!$(node).hasClass(excludeTBodyClass))){findPreTags(result,node,tdClass,excludeTBodyClass)}}}},_copySelectionToClipboard(clipboardData){let excludeTBodyClass;let tdClass;if(this._newlineChar===null){if(navigator.appVersion.includes("Win")){this._newlineChar="\r\n"}else{this._newlineChar="\n"}}if(this._selectedCellIndex===3||this.$el.hasClass("newfile")){tdClass="r";excludeTBodyClass="delete"}else{tdClass="l";excludeTBodyClass="insert"}const sel=window.getSelection();const textParts=[];for(let i=0;i<sel.rangeCount;i++){const range=sel.getRangeAt(i);if(range.collapsed){continue}const nodes=[];const doc=range.cloneContents();findPreTags(nodes,doc,tdClass,excludeTBodyClass);if(nodes.length>0){for(let j=0;j<nodes.length;j++){textParts.push(nodes[j].textContent)}}else{textParts.push($(doc).text());break}}try{clipboardData.setData("text",textParts.join(this._newlineChar))}catch(e){this._supportsSetClipboard=false;return false}return true},_onMouseDown(e){if(this._selectionClass){this.$el.removeClass(this._selectionClass)}const node=this._$ghostCommentFlagCell?this._$ghostCommentFlagCell[0]:e.target;if(this._isLineNumCell(node)){this._begin($(node.parentNode))}else{const $node=node.tagName==="TD"?$(node):$(node).parentsUntil("tr","td");if($node.length>0){this._selectionClass="selecting-col-"+$node[0].cellIndex;this._selectedCellIndex=$node[0].cellIndex;this.$el.addClass(this._selectionClass)}}},_onMouseUp(e){const node=this._$ghostCommentFlagCell?this._$ghostCommentFlagCell[0]:e.target;if(this._isLineNumCell(node)){this._end(this._getActualLineNumCell($(node)).parent());e.stopImmediatePropagation()}this._reset()},_onMouseOver(e){const $node=this._getActualLineNumCell($(e.target));const $row=$node.parent();if(this._isLineNumCell($node[0])){if(this._$begin){this._addRow($row)}else{this._highlightRow($row)}}else if(this._$ghostCommentFlagCell&&$node[0]!==this._$ghostCommentFlagCell[0]){$row.removeClass("selected")}},_onMouseOut(e){const relTarget=e.relatedTarget;if(relTarget!==this._$ghostCommentFlag[0]){this._$ghostCommentFlag.hide();this._$ghostCommentFlagCell=null}const $node=this._getActualLineNumCell($(e.target));if(this._$begin){if(relTarget&&this._isLineNumCell(relTarget)){this._removeOldRows($(relTarget.parentNode))}}else if($node&&this._isLineNumCell($node[0])){$node.parent().removeClass("selected")}},_onTouchStart(e){const firstTouch=e.originalEvent.targetTouches[0];const $node=this._getActualLineNumCell($(firstTouch.target));if($node!==null&&this._isLineNumCell($node[0])){e.preventDefault();this._begin($node.parent())}},_onTouchEnd(e){const firstTouch=e.originalEvent.changedTouches[0];const target=document.elementFromPoint(firstTouch.clientX,firstTouch.clientY);const $node=this._getActualLineNumCell($(target));if($node!==null&&this._isLineNumCell($node[0])){e.preventDefault();this._end($node.parent())}this._reset()},_onTouchMove(e){const firstTouch=e.originalEvent.targetTouches[0];const target=document.elementFromPoint(firstTouch.clientX,firstTouch.clientY);const $node=this._getActualLineNumCell($(target));if($node!==null){const $row=$node.parent();if(this._lastSeenIndex!==$row[0].rowIndex&&this._isLineNumCell($node[0])){e.preventDefault();this._removeOldRows($row);this._addRow($row)}}},_onTouchCancel(){this._reset()},getLineNum(row){return parseInt(row.getAttribute("line"),10)}});"use strict";RB.MarkdownReviewableView=RB.TextBasedReviewableView.extend({className:"markdown-review-ui"});"use strict";RB.UploadDiffView=Backbone.View.extend({events:{"dragenter .dnd":"_onDragEnter","dragover .dnd":"_onDragOver","dragleave .dnd":"_onDragLeave","drop .dnd":"_onDrop","submit #basedir-form":"_onBasedirSubmit","submit #changenum-form":"_onChangenumSubmit","click .startover":"_onStartOverClicked","click #select-diff-file":"_onSelectFileClicked","click #select-parent-diff-file":"_onSelectFileClicked"},initialize(){this.listenTo(this.model,"change:state",this._onStateChanged);this.listenTo(this.model,"change:error",this._onErrorChanged)},render(){let selectDiffText;let selectParentDiffText;if(this._canDragDrop()){selectDiffText=gettext('<input type="button" id="select-diff-file" value="Select"> or drag and drop a diff file to begin');selectParentDiffText=gettext('<input type="button" id="select-parent-diff-file" value="Select"> or drag and drop a parent diff file if you have one')}else{selectDiffText=gettext('<input type="button" id="select-diff-file" value="Select"> a file to begin');selectParentDiffText=gettext('<input type="button" id="select-parent-diff-file" value="Select"> a parent diff file if you have one')}this.$el.html(this.template({pendingChangeHeader:gettext("Create from a local change"),tipHeader:gettext("Tip:"),tip:gettext('Use <tt>rbt post</tt> from <a href="https://www.reviewboard.org/downloads/rbtools/">RBTools</a> to more easily create and update review requests.'),selectDiff:selectDiffText,selectParentDiff:selectParentDiffText,baseDir:gettext("What is the base directory for this diff?"),changeNum:gettext("What is the change number for this diff?"),startOver:gettext("Start Over"),ok:gettext("OK")}));this._$fileInput=$('<input type="file">').hide().appendTo(this.$el).change(()=>this.model.handleFiles(this._$fileInput.get(0).files));this._$diffRevisionError=this.$("#parent-diff-error-contents");this._$error=this.$("#error-indicator").hide();this._$errorContents=this.$("#error-contents");this._$processingDiff=this.$("#processing-diff").hide();this._$promptForBasedir=this.$("#prompt-for-basedir").hide();this._$promptForChangeNumber=this.$("#prompt-for-change-number").hide();this._$promptForDiff=this.$("#prompt-for-diff").hide();this._$promptForParentDiff=this.$("#prompt-for-parent-diff").hide();this._$uploading=this.$("#uploading-diffs").hide();this._onStateChanged(this.model,this.model.get("state"));return this},_canDragDrop(){return("draggable"in this.el||"ondragstart"in this.el&&"ondrop"in this.el)&&!navigator.userAgent.match("iPhone OS")&&!navigator.userAgent.match("iPad")},_onErrorChanged(model,error){const errorHTML=`<div class="rb-icon rb-icon-warning"></div> ${error}`;this._$errorContents.html(errorHTML);this._$diffRevisionError.html(errorHTML);const innerHeight=this._$errorContents.height();const outerHeight=this._$error.height();this._$errorContents.css({top:Math.floor((outerHeight-innerHeight)/2)+"px"})},_onStateChanged(model,state){this._$promptForDiff.setVisible(state===this.model.State.PROMPT_FOR_DIFF);this._$promptForParentDiff.setVisible(state===this.model.State.PROMPT_FOR_PARENT_DIFF);this._$promptForBasedir.setVisible(state===this.model.State.PROMPT_FOR_BASEDIR);this._$processingDiff.setVisible(state===this.model.State.PROCESSING_DIFF);this._$promptForChangeNumber.setVisible(state===this.model.State.PROMPT_FOR_CHANGE_NUMBER);this._$uploading.setVisible(state===this.model.State.UPLOADING);this._$error.setVisible(state===this.model.State.ERROR)},_onDragEnter(event){event.stopPropagation();event.preventDefault();this.$(".dnd").addClass("drag-hover")},_onDragOver(event){event.stopPropagation();event.preventDefault();const dt=event.originalEvent.dataTransfer;if(dt){dt.dropEffect="copy"}},_onDragLeave(event){event.stopPropagation();event.preventDefault();this.$(".dnd").removeClass("drag-hover");const dt=event.originalEvent.dataTransfer;if(dt){dt.dropEffect="none"}},_onDrop(event){event.stopPropagation();event.preventDefault();const dt=event.originalEvent.dataTransfer;const files=dt&&dt.files;if(files){this.model.handleFiles(files)}},_onBasedirSubmit(event){event.stopPropagation();event.preventDefault();const basedir=this.$("#basedir-input").val();if(basedir){this.model.set("basedir",basedir)}},_onChangenumSubmit(){const changenum=this.$("#changenum-input").val();if(changenum){this.model.set("changeNumber",changenum)}},_onStartOverClicked(){const $input=this._$fileInput.clone(true);this._$fileInput.replaceWith($input);this._$fileInput=$input;this.model.startOver()},_onSelectFileClicked(){this._$fileInput.click()}});"use strict";RB.UpdateDiffView=RB.UploadDiffView.extend({className:"update-diff",template:_.template(`<div class="input dnd" id="prompt-for-diff">
 <form>
  <%= selectDiff %>
 </form>
</div>
<div class="input dnd" id="prompt-for-parent-diff">
 <form>
  <div id="parent-diff-error-contents" />
  <%= selectParentDiff %>
 </form>
 <a href="#" class="startover"><%- startOver %></a>
</div>
<div class="input" id="prompt-for-basedir">
 <form id="basedir-form">
  <%- baseDir %>
  <input id="basedir-input" />
  <input type="submit" value="<%- ok %>" />
 </form>
 <a href="#" class="startover"><%- startOver %></a>
</div>
<div class="input" id="processing-diff">
 <div class="spinner"><span class="fa fa-spinner fa-pulse"></div>
</div>
<div class="input" id="uploading-diffs">
 <div class="spinner"><span class="fa fa-spinner fa-pulse"></div>
</div>
<div class="input" id="error-indicator">
 <div id="error-contents" />
 <a href="#" class="startover"><%- startOver %></a>
</div>`),render(){RB.UploadDiffView.prototype.render.call(this);this.$el.modalBox({title:gettext("Update Diff"),buttons:[$('<input type="button" />').val(gettext("Cancel"))]});return this}});"use strict";(function(){RB.CommitHistoryDiffEntry=Backbone.Model.extend({defaults:{entryType:null,newCommitID:null,oldCommitID:null},parse(rsp){return{entryType:rsp.entry_type,newCommitID:rsp.new_commit_id,oldCommitID:rsp.old_commit_id}},getSymbol(){const entryType=this.get("entryType");return RB.CommitHistoryDiffEntry.HISTORY_SYMBOL_MAP[entryType]||null}},{ADDED:"added",REMOVED:"removed",MODIFIED:"modified",UNMODIFIED:"unmodified"});const symbolMap={};symbolMap[RB.CommitHistoryDiffEntry.ADDED]="+";symbolMap[RB.CommitHistoryDiffEntry.REMOVED]="-";symbolMap[RB.CommitHistoryDiffEntry.MODIFIED]="~";symbolMap[RB.CommitHistoryDiffEntry.UNMODIFIED]=" ";RB.CommitHistoryDiffEntry.HISTORY_SYMBOL_MAP=symbolMap})();"use strict";RB.DiffCommentBlock=RB.AbstractCommentBlock.extend({defaults:_.defaults({fileDiffID:null,interFileDiffID:null,baseFileDiffID:null,beginLineNum:null,endLineNum:null,$beginRow:null,$endRow:null},RB.AbstractCommentBlock.prototype.defaults),getNumLines(){return this.get("endLineNum")+this.get("beginLineNum")+1},createComment(id){return this.get("review").createDiffComment({id:id,fileDiffID:this.get("fileDiffID"),interFileDiffID:this.get("interFileDiffID"),beginLineNum:this.get("beginLineNum"),endLineNum:this.get("endLineNum"),baseFileDiffID:this.get("baseFileDiffID")})}});"use strict";RB.DiffCommentsHint=Backbone.Model.extend({defaults(){return{diffsetsWithComments:[],hasOtherComments:false,interdiffsWithComments:[]}},parse(rsp){return{hasOtherComments:rsp.has_other_comments,diffsetsWithComments:rsp.diffsets_with_comments.map(diffset=>({revision:diffset.revision,isCurrent:diffset.is_current})),interdiffsWithComments:rsp.interdiffs_with_comments.map(interdiff=>({oldRevision:interdiff.old_revision,newRevision:interdiff.new_revision,isCurrent:interdiff.is_current}))}}});"use strict";RB.DiffCommitList=Backbone.Model.extend({defaults(){return{baseCommitID:null,commits:new RB.DiffCommitCollection,historyDiff:new RB.CommitHistoryDiffEntryCollection,tipCommitID:null}},isInterdiff(){return!this.get("historyDiff").isEmpty()}});"use strict";(function(){const MAX_SUMMARY_LEN=80;RB.DiffCommit=Backbone.Model.extend({defaults:{authorName:null,commitID:null,commitMessage:null,parentID:null,summary:null},parse(attrs){let summary=attrs.commit_message.split("\n",1)[0].trim();if(summary.length>MAX_SUMMARY_LEN){summary=summary.substr(0,MAX_SUMMARY_LEN-3)+"..."}return{authorName:attrs.author_name,commitID:attrs.commit_id,commitMessage:attrs.commit_message.trim(),id:attrs.id,parentID:attrs.parent_id,summary:summary}},hasSummary(){return this.get("summary")!==this.get("commitMessage")}})})();"use strict";RB.DiffFile=Backbone.Model.extend({defaults:{baseFileDiffID:null,binary:false,commentCounts:null,deleted:false,depotFilename:null,destFilename:null,destRevision:null,filediff:null,index:null,interfilediff:null,newfile:false,forceInterdiff:null,forceInterdiffRevision:null},parse(rsp){return{binary:rsp.binary,baseFileDiffID:rsp.base_filediff_id,commentCounts:rsp.comment_counts,deleted:rsp.deleted,depotFilename:rsp.depot_filename,destFilename:rsp.dest_filename,destRevision:rsp.dest_revision,filediff:rsp.filediff,id:rsp.id,index:rsp.index,interfilediff:rsp.interfilediff,newfile:rsp.newfile,revision:rsp.revision,forceInterdiff:rsp.force_interdiff,forceInterdiffRevision:rsp.interdiff_revision}}});"use strict";RB.DiffReviewable=RB.AbstractReviewable.extend({defaults:_.defaults({baseFileDiffID:null,file:null,fileDiffID:null,interdiffRevision:null,interFileDiffID:null,revision:null},RB.AbstractReviewable.prototype.defaults),commentBlockModel:RB.DiffCommentBlock,defaultCommentBlockFields:["baseFileDiffID","fileDiffID","interFileDiffID"],loadSerializedCommentBlock(serializedCommentBlock){this.createCommentBlock({reviewRequest:this.get("reviewRequest"),review:this.get("review"),fileDiffID:this.get("fileDiffID"),interFileDiffID:this.get("interFileDiffID"),beginLineNum:serializedCommentBlock.linenum,endLineNum:serializedCommentBlock.linenum+serializedCommentBlock.num_lines-1,serializedComments:serializedCommentBlock.comments||[]})},getRenderedDiff(callbacks,context){let options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};this._fetchFragment({url:this._buildRenderedDiffURL({index:this.get("file").get("index"),showDeleted:options.showDeleted}),noActivityIndicator:true},callbacks,context)},getRenderedDiffFragment(options,callbacks,context){console.assert(options.chunkIndex!==undefined,"chunkIndex must be provided");this._fetchFragment({url:this._buildRenderedDiffURL({chunkIndex:options.chunkIndex,index:this.get("file").get("index"),linesOfContext:options.linesOfContext})},callbacks,context)},_fetchFragment(options,callbacks,context){RB.apiCall(_.defaults({type:"GET",dataType:"html"},options,_.bindCallbacks(callbacks,context)))},_buildRenderedDiffURL(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const reviewURL=this.get("reviewRequest").get("reviewURL");const interdiffRevision=this.get("interdiffRevision");const fileDiffID=this.get("fileDiffID");const interFileDiffID=this.get("interFileDiffID");const baseFileDiffID=this.get("baseFileDiffID");const revision=this.get("revision");const revisionPart=interdiffRevision?`${revision}-${interdiffRevision}`:revision;const fileDiffPart=interFileDiffID?`${fileDiffID}-${interFileDiffID}`:fileDiffID;let url=`${reviewURL}diff/${revisionPart}/fragment/${fileDiffPart}/`;if(options.chunkIndex!==undefined){url+=`chunk/${options.chunkIndex}/`}const queryParts=[];if(baseFileDiffID){queryParts.push(`base-filediff-id=${baseFileDiffID}`)}if(options.index!==undefined){queryParts.push(`index=${options.index}`)}if(options.linesOfContext!==undefined){queryParts.push(`lines-of-context=${options.linesOfContext}`)}if(options.showDeleted){queryParts.push(`show-deleted=1`)}queryParts.push(`_=${TEMPLATE_SERIAL}`);const queryStr=queryParts.join("&");return`${url}?${queryStr}`}});"use strict";RB.DiffRevision=Backbone.Model.extend({defaults:{baseCommitID:null,interdiffRevision:null,isDraftDiff:false,isInterdiff:false,latestRevision:null,revision:null,tipCommitID:null},parse(attrs){return{baseCommitID:attrs.base_commit_id||null,interdiffRevision:attrs.interdiff_revision,isDraftDiff:attrs.is_draft_diff,isInterdiff:attrs.is_interdiff,latestRevision:attrs.latest_revision,revision:attrs.revision,tipCommitID:attrs.tip_commit_id||null}}});"use strict";RB.Pagination=Backbone.Model.extend({defaults(){return{currentPage:null,hasNext:false,hasPrevious:false,isPaginated:false,nextPage:null,pageNumbers:[],pages:0,previousPage:null}},parse(rsp){return{currentPage:rsp.current_page,hasNext:rsp.has_next,hasPrevious:rsp.has_previous,isPaginated:rsp.is_paginated,nextPage:rsp.next_page,pageNumbers:rsp.page_numbers,pages:rsp.pages,previousPage:rsp.previous_page}}});"use strict";RB.CommitHistoryDiffEntryCollection=Backbone.Collection.extend({model:RB.CommitHistoryDiffEntry});"use strict";RB.DiffCommitCollection=Backbone.Collection.extend({model:RB.DiffCommit,getParent(commit){return this.findWhere({commitID:commit.get("parentID")})},getChild(commit){return this.findWhere({parentID:commit.get("commitID")})}});"use strict";RB.DiffFileCollection=Backbone.Collection.extend({model:RB.DiffFile});"use strict";RB.DiffReviewableCollection=Backbone.Collection.extend({model:RB.DiffReviewable,initialize(models,options){this.reviewRequest=options.reviewRequest},watchFiles(files){this.listenTo(files,"reset",()=>this._populateFromFiles(files));this._populateFromFiles(files)},_populateFromFiles(files){const reviewRequest=this.reviewRequest;console.assert(reviewRequest,"RB.DiffReviewableCollection.reviewRequest must be set");this.reset();this.trigger("populating");files.each(file=>{const filediff=file.get("filediff");const interfilediff=file.get("interfilediff");let interdiffRevision=null;if(interfilediff){interdiffRevision=interfilediff.revision}else if(file.get("forceInterdiff")){interdiffRevision=file.get("forceInterdiffRevision")}this.add({baseFileDiffID:file.get("baseFileDiffID"),reviewRequest:reviewRequest,file:file,fileDiffID:filediff.id,interFileDiffID:interfilediff?interfilediff.id:null,revision:filediff.revision,interdiffRevision:interdiffRevision,serializedCommentBlocks:file.get("commentCounts")})});this.trigger("populated")}});"use strict";RB.ChunkHighlighterView=Backbone.View.extend({className:"diff-highlight",initialize(){this._chunkEl=null;this._chunkContainerEl=null;this._$pageContainer=null;this._$window=$(window);this._prevWindowWidth=null;this._prevTop=null;this._prevHeight=null;_.bindAll(this,"updateLayout")},render(){this._$window.on("resize."+this.cid,()=>{const windowWidth=this._$window.width();if(windowWidth!==this._prevWindowWidth){this._prevWindowWidth=windowWidth;this.updateLayout()}});this._$pageContainer=$("#page-container");this.updateLayout();return this},remove(){Backbone.View.prototype.remove.call(this);this._$window.off(this.cid)},highlight($chunk){this._chunkEl=$chunk[0];this._chunkContainerEl=$chunk.parents(".diff-container")[0];this.updateLayout()},updateLayout(){const chunkEl=this._chunkEl;if(!chunkEl){return}let changed=false;const css={};const top=Math.floor(chunkEl.offsetTop+this._chunkContainerEl.offsetTop+1);const height=chunkEl.clientHeight+1;if(top!==this._prevTop){css.top=top;this._prevTop=top;changed=true}if(height!==this._prevHeight){css.height=height;this._prevHeight=height;changed=true}if(changed){const padding=this._$pageContainer.getExtents("p","l");css.left=-padding;css.right=-padding;this.$el.css(css)}}});"use strict";RB.DiffCommentBlockView=RB.TextBasedCommentBlockView.extend({buildAnchorName(){const fileDiffID=this.model.get("fileDiffID");const beginLineNum=this.model.get("beginLineNum");return`file${fileDiffID}line${beginLineNum}`}});"use strict";RB.DiffCommentsHintView=Backbone.View.extend({events:{"click .revision":"_onRevisionSelected","click .interdiff":"_onInterdiffSelected"},template:_.template(`<div class="box-container">
 <div class="box important">
  <div class="box-inner comments-hint">
   <h1><%- unpublishedCommentsHeader %></h1>
   <p><%- unpublishedCommentsText %></p>
   <ul>
   </ul>
  </div>
 </div>
</div>`),initialize(){this.listenTo(this.model,"change",this.render)},render(){const revisionText=gettext("Revision %s");const interdiffText=gettext("Interdiff revision %(oldRevision)s - %(newRevision)s");if(this.model.get("hasOtherComments")){this.$el.html(this.template({unpublishedCommentsHeader:gettext("You have unpublished comments on other revisions"),unpublishedCommentsText:gettext("Your review consists of comments on the following revisions:")}));const $ul=this.$("ul");this.model.get("diffsetsWithComments").forEach(diffset=>{const $li=$("<li/>").addClass("revision").data("revision",diffset.revision).text(interpolate(revisionText,[diffset.revision])).appendTo($ul);if(diffset.isCurrent){$li.addClass("current")}});this.model.get("interdiffsWithComments").forEach(interdiff=>{const $li=$("<li/>").addClass("interdiff").data({"first-revision":interdiff.oldRevision,"second-revision":interdiff.newRevision}).text(interpolate(interdiffText,{oldRevision:interdiff.oldRevision,newRevision:interdiff.newRevision},true)).appendTo($ul);if(interdiff.isCurrent){$li.addClass("current")}})}else{this.$el.empty()}return this},_onRevisionSelected(ev){const $target=$(ev.currentTarget);if(!$target.hasClass("current")){this.trigger("revisionSelected",[0,$target.data("revision")])}},_onInterdiffSelected(ev){const $target=$(ev.currentTarget);if(!$target.hasClass("current")){this.trigger("revisionSelected",[$target.data("first-revision"),$target.data("second-revision")])}}});"use strict";(function(){const itemTemplate=_.template(`<tr<% if (rowClass) { %> class="<%- rowClass %>"<% } %>>
 <% if (showHistorySymbol) { %>
  <td class="marker">
   <%- historyDiffEntry.getSymbol() %>
  </td>
 <% } else if (showInterCommitDiffControls) { %>
  <td class="select-base">
   <input type="radio"
          class="base-commit-selector"
          name="base-commit-id"
          <% if (baseSelected) { %>checked<% } %>
          <% if (baseDisabled) { %>disabled<% } %>
          value="<%- commit.id %>">
  </td>
  <td class="select-tip">
   <input type="radio"
          class="tip-commit-selector"
          name="tip-commit-id"
          <% if (tipSelected) { %>checked<% } %>
          <% if (tipDisabled) { %>disabled<% } %>
          value="<%- commit.id %>">
  </td>
 <% } %>
 <% if (showExpandCollapse) { %>
  <td>
   <% if (commit && commit.hasSummary()) { %>
    <a href="#"
       class="expand-commit-message"
       data-commit-id="<%- commit.id %>"
       aria-role="button">
     <span class="fa fa-plus" title="<%- expandText %>"></span>
    </a>
   <% } %>
  </td>
 <% } %>
 <td<% if (showHistorySymbol) { %> class="value"<% } %>>
  <% if (commit !== null) { %>
   <pre><%- commit.get('summary') %></pre>
  <% } %>
 </td>
 <td<% if (showHistorySymbol) { %> class="value"<% } %>>
  <% if (commit !== null) { %>
   <%- commit.get('authorName') %>
  <% } %>
 </td>
</tr>`);const headerTemplate=_.template(`<thead>
 <tr>
  <% if (showHistorySymbol) { %>
   <th></th>
  <% } else if (showInterCommitDiffControls) { %>
   <th><%- firstText %></th>
   <th><%- lastText %></th>
  <% } %>
  <th<% if (showExpandCollapse) { %> colspan="2"<% } %>>
   <%- summaryText %>
   </th>
  <th><%- authorText %></th>
 </tr>
</thead>`);const tableTemplate=_.template(`<form>
 <table class="commit-list">
  <colgroup>
   <% if (showHistorySymbol) { %>
    <col>
   <% } else if (showInterCommitDiffControls) { %>
     <col>
     <col>
   <% } %>
   <% if (showExpandCollapse) { %>
    <col class="expand-collapse-control">
   <% } %>
   <col>
   <col>
  </colgroup>
 </table>
</form>`);RB.DiffCommitListView=Backbone.View.extend({events:{"change .base-commit-selector":"_onBaseChanged","change .tip-commit-selector":"_onTipChanged","click .collapse-commit-message":"_collapseCommitMessage","click .expand-commit-message":"_expandCommitMessage"},initialize(options){this.listenTo(this.model.get("commits"),"reset",this.render);this._showInterCommitDiffControls=!!options.showInterCommitDiffControls;this._$baseSelectors=$();this._$tipSelectors=$()},render(){const commits=this.model.get("commits");const isInterdiff=this.model.isInterdiff();const commonContext={showExpandCollapse:commits.some(commit=>commit.hasSummary()),showHistorySymbol:isInterdiff,showInterCommitDiffControls:this._showInterCommitDiffControls};const $content=$(tableTemplate(commonContext));const $table=$content.find("table").toggleClass("changed",isInterdiff).append(headerTemplate(_.extend({authorText:gettext("Author"),firstText:gettext("First"),lastText:gettext("Last"),summaryText:gettext("Summary")},commonContext)));const $tbody=$("<tbody />");commonContext.expandText=gettext("Expand commit message.");if(isInterdiff){this.model.get("historyDiff").each(historyDiffEntry=>{const entryType=historyDiffEntry.get("entryType");let key;let rowClass;switch(entryType){case RB.CommitHistoryDiffEntry.ADDED:rowClass="new-value";key="newCommitID";break;case RB.CommitHistoryDiffEntry.REMOVED:rowClass="old-value";key="oldCommitID";break;case RB.CommitHistoryDiffEntry.UNMODIFIED:case RB.CommitHistoryDiffEntry.MODIFIED:key="newCommitID";break;default:console.error("Invalid history entry type: %s",entryType);break}const commit=commits.get(historyDiffEntry.get(key));$tbody.append(itemTemplate(_.extend({commit:commit,historyDiffEntry:historyDiffEntry,rowClass:rowClass},commonContext)))})}else{commonContext.rowClass="";const baseCommitID=this.model.get("baseCommitID");const tipCommitID=this.model.get("tipCommitID");const lastIndex=commits.size()-1;const baseIndex=baseCommitID===null?0:commits.indexOf(commits.getChild(commits.get(baseCommitID)));const tipIndex=tipCommitID===null?lastIndex:commits.indexOf(commits.get(tipCommitID));commits.each((commit,i)=>{$tbody.append(itemTemplate(_.extend({commit:commit,baseSelected:i===baseIndex,tipSelected:i===tipIndex,baseDisabled:i>tipIndex,tipDisabled:i<baseIndex},commonContext)))})}$table.append($tbody);this.$el.empty().append($content);this._$baseSelectors=this.$(".base-commit-selector");this._$tipSelectors=this.$(".tip-commit-selector");return this},_expandCommitMessage(e){e.preventDefault();e.stopPropagation();this._expandOrCollapse($(e.target).closest(".expand-commit-message"),true)},_collapseCommitMessage(e){e.preventDefault();e.stopPropagation();this._expandOrCollapse($(e.target).closest(".collapse-commit-message"),false)},_expandOrCollapse($link,expand){const $icon=$link.find(".fa");const commitID=$link.data("commitId");const commit=this.model.get("commits").get(commitID);const newText=commit.get(expand?"commitMessage":"summary");$link.closest("tr").find("pre").text(newText);$link.attr("class",expand?"collapse-commit-message":"expand-commit-message");$icon.attr({class:expand?"fa fa-minus":"fa fa-plus",title:expand?gettext("Collapse commit message."):gettext("Expand commit message.")})},_onBaseChanged(e){const $target=$(e.target);const commits=this.model.get("commits");const commit=commits.get(parseInt($target.val(),10));const index=commits.indexOf(commit);this.model.set("baseCommitID",index===0?null:commits.getParent(commit).id);this._$tipSelectors.slice(0,index).prop("disabled",true);this._$tipSelectors.slice(index).prop("disabled",false)},_onTipChanged(e){const $target=$(e.target);const commits=this.model.get("commits");const commit=commits.get(parseInt($target.val(),10));const index=commits.indexOf(commit);this.model.set("tipCommitID",index===commits.size()-1?null:commit.id);this._$baseSelectors.slice(0,index+1).prop("disabled",false);this._$baseSelectors.slice(index+1).prop("disabled",true)}})})();"use strict";RB.DiffComplexityIconView=Backbone.View.extend({ICON_SIZE:20,initialize(options){this.numInserts=options.numInserts||0;this.numDeletes=options.numDeletes||0;this.numReplaces=options.numReplaces||0;this.totalLines=options.totalLines||null},render(){const numTotal=this.numInserts+this.numDeletes+this.numReplaces;const numInsertsPct=this.numInserts/numTotal;const numDeletesPct=this.numDeletes/numTotal;const numReplacesPct=this.numReplaces/numTotal;const minValue=360*.15;const innerRadius=.5*(this.totalLines===null?1:(this.totalLines-numTotal)/this.totalLines);const iconColors=RB.DiffComplexityIconView.getIconColors();this.$el.width(this.ICON_SIZE).height(this.ICON_SIZE).plot([{color:iconColors.insertColor,data:this._clampValue(numInsertsPct*360,minValue)},{color:iconColors.deleteColor,data:this._clampValue(numDeletesPct*360,minValue)},{color:iconColors.replaceColor,data:this._clampValue(numReplacesPct*360,minValue)}],{series:{pie:{show:true,innerRadius:innerRadius,radius:.8}}});return this},_clampValue(val,minValue){return val===0?0:Math.max(val,minValue)}},{_iconColors:null,getIconColors(){if(!this._iconColors){this._iconColors={};const $iconColor=$("<div/>").hide().appendTo(document.body);$iconColor[0].className="diff-changes-icon-insert";this._iconColors.insertColor=$iconColor.css("color");$iconColor[0].className="diff-changes-icon-replace";this._iconColors.replaceColor=$iconColor.css("color");$iconColor[0].className="diff-changes-icon-delete";this._iconColors.deleteColor=$iconColor.css("color");$iconColor.remove()}return this._iconColors}});"use strict";RB.DiffFileIndexView=Backbone.View.extend({chunkTemplate:_.template('<a href="#<%= chunkID %>" class="<%= className %>"> </a>'),_itemTemplate:_.template(`<tr class="loading
 <% if (newfile) { %>new-file<% } %>
 <% if (binary) { %>binary-file<% } %>
 <% if (deleted) { %>deleted-file<% } %>
 <% if (destFilename !== depotFilename) { %>renamed-file<% } %>
 ">
 <td class="diff-file-icon">
  <span class="fa fa-spinner fa-pulse"></span>
 </td>
 <td class="diff-file-info">
  <a href="#<%- index %>"><%- destFilename %></a>
  <% if (destFilename !== depotFilename) { %>
  <span class="diff-file-rename"><%- wasText %></span>
  <% } %>
 </td>
 <td class="diff-chunks-cell">
  <% if (binary) { %>
   <%- binaryFileText %>
  <% } else if (deleted) { %>
   <%- deletedFileText %>
  <% } else { %>
   <div class="diff-chunks"></div>
  <% } %>
 </td>
</tr>`),events:{"click a":"_onAnchorClicked"},initialize(options){this.options=options;this._$items=null;this._$itemsTable=null;this.collection=this.options.collection;this.listenTo(this.collection,"reset update",this.update)},render(){this.$el.empty();this._$itemsTable=$("<table/>").appendTo(this.$el);this._$items=this.$("tr");this.update();return this},update(){this._$itemsTable.empty();this.collection.each(file=>{this._$itemsTable.append(this._itemTemplate(_.defaults({binaryFileText:gettext("Binary file"),deletedFileText:gettext("Deleted"),wasText:interpolate(gettext("Was %s"),[file.get("depotFilename")])},file.attributes)))});this._$items=this.$("tr")},addDiff(index,diffReviewableView){const $item=$(this._$items[index]).removeClass("loading");if(diffReviewableView.$el.hasClass("diff-error")){this._renderDiffError($item)}else{this._renderDiffEntry($item,diffReviewableView)}},_renderDiffError($item){$item.find(".diff-file-icon").html('<div class="rb-icon rb-icon-warning" />').attr("title",gettext("There was an error loading this diff. See the details below."))},_renderDiffEntry($item,diffReviewableView){const $table=diffReviewableView.$el;const fileDeleted=$item.hasClass("deleted-file");const fileAdded=$item.hasClass("new-file");const linesEqual=$table.data("lines-equal");let numDeletes=0;let numInserts=0;let numReplaces=0;let tooltip="";const tooltipParts=[];const chunksList=[];if(fileAdded){numInserts=1}else if(fileDeleted){numDeletes=1}else if($item.hasClass("binary-file")){numReplaces=1}else{$table.children("tbody").each((i,chunk)=>{const numRows=chunk.rows.length;const $chunk=$(chunk);if($chunk.hasClass("delete")){numDeletes+=numRows}else if($chunk.hasClass("insert")){numInserts+=numRows}else if($chunk.hasClass("replace")){numReplaces+=numRows}else{return}chunksList.push(this.chunkTemplate({chunkID:chunk.id.substr(5),className:chunk.className}))});$item.find(".diff-chunks").html(chunksList.join(""))}const iconView=new RB.DiffComplexityIconView({numInserts:numInserts,numDeletes:numDeletes,numReplaces:numReplaces,totalLines:linesEqual+numDeletes+numInserts+numReplaces});const $fileIcon=$item.find(".diff-file-icon");$fileIcon.empty().append(iconView.$el);iconView.render();if(fileAdded){tooltip=gettext("New file")}else if(fileDeleted){tooltip=gettext("Deleted file")}else{if(numInserts>0){tooltipParts.push(interpolate(ngettext("%s new line","%s new lines",numInserts),[numInserts]))}if(numReplaces>0){tooltipParts.push(interpolate(ngettext("%s line changed","%s lines changed",numReplaces),[numReplaces]))}if(numDeletes>0){tooltipParts.push(interpolate(ngettext("%s line removed","%s lines removed",numDeletes),[numDeletes]))}tooltip=tooltipParts.join(", ")}$fileIcon.attr("title",tooltip);this.listenTo(diffReviewableView,"chunkDimmed chunkUndimmed",chunkID=>{this.$(`a[href="#${chunkID}"]`).toggleClass("dimmed")})},_onAnchorClicked:function(e){e.preventDefault();e.stopPropagation();this.trigger("anchorClicked",e.target.href.split("#")[1])}});"use strict";RB.DiffReviewableView=RB.AbstractReviewableView.extend({tagName:"table",commentBlockView:RB.DiffCommentBlockView,commentsListName:"diff_comments",events:{"click .download-link":"_onDownloadLinkClicked","click thead tr":"_onFileHeaderClicked","click .moved-to, .moved-from":"_onMovedLineClicked","click .diff-collapse-btn":"_onCollapseChunkClicked","click .diff-expand-btn":"_onExpandChunkClicked","click .show-deleted-content-action":"_onShowDeletedClicked",mouseup:"_onMouseUp"},initialize(){RB.AbstractReviewableView.prototype.initialize.call(this);this._selector=new RB.TextCommentRowSelector({el:this.el,reviewableView:this});this._hiddenCommentBlockViews=[];this._visibleCommentBlockViews=[];this._$filenameRow=null;this._$revisionRow=null;this._filenameReservedWidths=0;this._colReservedWidths=0;this._numColumns=0;this._numFilenameColumns=0;this._prevContentWidth=null;this._prevFilenameWidth=null;this._prevFullWidth=null;this._$window=$(window);this._$parent=this.$el.parent();this.on("commentBlockViewAdded",this._placeCommentBlockView,this)},remove(){RB.AbstractReviewableView.prototype.remove.call(this);this._selector.remove()},render(){RB.AbstractReviewableView.prototype.render.call(this);this._centered=new RB.CenteredElementManager;const $thead=$(this.el.tHead);this._$revisionRow=$thead.children(".revision-row");this._$filenameRow=$thead.children(".filename-row");this._selector.render();_.each(this.$el.children("tbody.binary"),thumbnailEl=>{const $thumbnail=$(thumbnailEl);const id=$thumbnail.data("file-id");const $caption=$thumbnail.find(".file-caption .edit");const reviewRequest=this.model.get("reviewRequest");const fileAttachment=reviewRequest.createFileAttachment({id:id});if(!$caption.hasClass("empty-caption")){fileAttachment.set("caption",$caption.text())}});this._precalculateContentWidths();this._updateColumnSizes();return this},toggleWhitespaceOnlyChunks(){this.$("tbody tr.whitespace-line").toggleClass("dimmed");_.each(this.$el.children("tbody.whitespace-chunk"),chunk=>{const $chunk=$(chunk);const dimming=$chunk.hasClass("replace");$chunk.toggleClass("replace");const $children=$chunk.children();$children.first().toggleClass("first");$children.last().toggleClass("last");const chunkID=chunk.id.split("chunk")[1];if(dimming){this.trigger("chunkDimmed",chunkID)}else{this.trigger("chunkUndimmed",chunkID)}});this.$el.children("tbody.whitespace-file").siblings("tbody").addBack().toggle()},createComment(beginLineNum,endLineNum,beginNode,endNode){this._selector.createComment(beginLineNum,endLineNum,beginNode,endNode)},_placeCommentBlockView(commentBlockView,prevBeginRowIndex){const commentBlock=commentBlockView.model;const rowEls=this._selector.getRowsForRange(commentBlock.get("beginLineNum"),commentBlock.get("endLineNum"),prevBeginRowIndex);if(rowEls!==null){const beginRowEl=rowEls[0];const endRowEl=rowEls[1];commentBlockView.setRows($(beginRowEl),$(endRowEl||beginRowEl));commentBlockView.$el.appendTo(commentBlockView.$beginRow[0].cells[0]);this._visibleCommentBlockViews.push(commentBlockView);return beginRowEl.rowIndex}else{this._hiddenCommentBlockViews.push(commentBlockView);return prevBeginRowIndex}},_placeHiddenCommentBlockViews(){const hiddenCommentBlockViews=this._hiddenCommentBlockViews;this._hiddenCommentBlockViews=[];let prevBeginRowIndex;for(let i=0;i<hiddenCommentBlockViews.length;i++){prevBeginRowIndex=this._placeCommentBlockView(hiddenCommentBlockViews[i],prevBeginRowIndex)}},_hideRemovedCommentBlockViews(){const visibleCommentBlockViews=this._visibleCommentBlockViews;this._visibleCommentBlockViews=[];for(let i=0;i<visibleCommentBlockViews.length;i++){const commentBlockView=visibleCommentBlockViews[i];if(commentBlockView.$el.is(":visible")){this._visibleCommentBlockViews.push(commentBlockView)}else{this._hiddenCommentBlockViews.push(commentBlockView)}}_.sortBy(this._hiddenCommentBlockViews,commentBlockView=>commentBlockView.model.get("beginLineNum"))},_updateCollapseButtonPos(){this._centered.updatePosition()},_expandOrCollapse($btn,expanding){const chunkIndex=$btn.data("chunk-index");const linesOfContext=$btn.data("lines-of-context");this.model.getRenderedDiffFragment({chunkIndex:chunkIndex,linesOfContext:linesOfContext},{success:html=>{const $tbody=$btn.closest("tbody");let tbodyID;let $scrollAnchor;let scrollAnchorID;if(expanding){$scrollAnchor=this.$el;scrollAnchorID=$scrollAnchor[0].id;if(linesOfContext===0){tbodyID=/collapsed-(.*)/.exec(scrollAnchorID)[1]}else{tbodyID=scrollAnchorID}}else{$scrollAnchor=$btn}const scrollOffsetTop=$scrollAnchor.offset().top-this._$window.scrollTop();$tbody.prev(".diff-header, .loaded").remove();$tbody.next(".diff-header, .loaded").remove();$tbody.replaceWith(html);if(expanding){this._placeHiddenCommentBlockViews()}else{this._hideRemovedCommentBlockViews()}if(tbodyID!==undefined){const newEl=document.getElementById(tbodyID);if(newEl!==null){$scrollAnchor=$(newEl);this._$window.scrollTop($scrollAnchor.offset().top-scrollOffsetTop)}}this._centered.setElements(new Map(Array.prototype.map.call(this.$(".diff-collapse-btn"),el=>[el,{$top:$(el).closest("tbody")}])));this._updateCollapseButtonPos();this._precalculateContentWidths();this._updateColumnSizes();this.trigger("chunkExpansionChanged")}})},_precalculateContentWidths(){let cellPadding=0;if(!this.$el.hasClass("diff-error")&&this._$revisionRow.length>0){const containerExtents=this.$el.getExtents("p","lr");let $cells=$(this._$revisionRow[0].cells);cellPadding=$(this.el.querySelector("pre")).parent().addBack().getExtents("p","lr");this._colReservedWidths=$cells.eq(0).outerWidth()+cellPadding+containerExtents;this._numColumns=$cells.length;if(this._numColumns===4){this._colReservedWidths+=$cells.eq(2).outerWidth()+cellPadding}$cells=$(this._$filenameRow[0].cells);this._numFilenameColumns=$cells.length;this._filenameReservedWidths=containerExtents+2*this._numFilenameColumns}else{this._colReservedWidths=0;this._filenameReservedWidths=0;this._numColumns=0;this._numFilenameColumns=0}},_updateColumnSizes(){if(this.$el.hasClass("diff-error")){return}let $parent=this._$parent;if(!$parent.is(":visible")){$parent=$parent.parent()}const fullWidth=$parent.width();if(fullWidth===this._prevFullWidth){return}this._prevFullWidth=fullWidth;let contentWidth=fullWidth-this._colReservedWidths;if(this._numColumns===4){contentWidth/=2}let filenameWidth=fullWidth-this._filenameReservedWidths;if(this._numFilenameColumns===2){filenameWidth/=2}this.$el.width(fullWidth);if(filenameWidth!==this._prevFilenameWidth){this._$filenameRow.children("th").css({"min-width":Math.ceil(filenameWidth*.66),"max-width":Math.ceil(filenameWidth)});this._prevFilenameWidth=filenameWidth}if(contentWidth!==this._prevContentWidth){this._$revisionRow.children(".revision-col").css({"min-width":Math.ceil(contentWidth*.66),"max-width":Math.ceil(contentWidth)});this._prevContentWidth=contentWidth}},updateLayout(){this._updateColumnSizes();this._updateCollapseButtonPos()},_onDownloadLinkClicked(e){e.stopPropagation()},_onFileHeaderClicked(e){e.preventDefault();e.stopPropagation();this.trigger("fileClicked")},_onMovedLineClicked(e){e.preventDefault();e.stopPropagation();this.trigger("moveFlagClicked",$(e.target).data("line"))},_onMouseUp(e){const node=e.target;const $tbody=$(node).closest("tbody");if($tbody.length>0&&($tbody.hasClass("delete")||$tbody.hasClass("insert")||$tbody.hasClass("replace"))){const anchor=$tbody[0].querySelector("a");if(anchor){this.trigger("chunkClicked",anchor.name)}}},_onExpandChunkClicked(e){e.preventDefault();let $target=$(e.target);if(!$target.hasClass("diff-expand-btn")){$target=$target.closest(".diff-expand-btn")}this._expandOrCollapse($target,true)},_onCollapseChunkClicked(e){e.preventDefault();let $target=$(e.target);if(!$target.hasClass("diff-collapse-btn")){$target=$target.closest(".diff-collapse-btn")}this._expandOrCollapse($target,false)},_onShowDeletedClicked(e){e.preventDefault();e.stopPropagation();$(e.target).parent().html('<span class="fa fa-spinner fa-pulse"></span>');this.trigger("showDeletedClicked")}});"use strict";RB.DiffRevisionLabelView=Backbone.View.extend({events:{"click .select-latest":"_onSelectLatest","click .select-changed":"_onSelectChanged"},template:_.template(`<h1><%- header %></h1>
<% if (detail) { %><p><%= detail %><% } %>`),_interdiffTemplate:_.template(gettext("Changes between revision <%- revision %> and <%- interdiffRevision %>")),_latestTemplate:_.template(gettext("Diff Revision <%- revision %> (Latest)")),_oldHeaderTemplate:_.template(gettext("Diff Revision <%- revision %>")),_oldDetailTemplate:_.template(gettext('This is not the most recent revision of the diff. The <a href="#" class="select-latest">latest diff</a> is revision <%- latestRevision %>. <a href="#" class="select-changed">See what\'s changed.</a>')),initialize(){this.listenTo(this.model,"change",this.render)},render(){const revision=this.model.get("revision");const latestRevision=this.model.get("latestRevision");let header="";let detail=null;if(this.model.get("isInterdiff")){const interdiffRevision=this.model.get("interdiffRevision");header=this._interdiffTemplate({revision:revision,interdiffRevision:interdiffRevision})}else if(revision===latestRevision){header=this._latestTemplate({revision:revision})}else if(this.model.get("isDraftDiff")){header=gettext("Draft diff");detail=gettext("This diff is part of your current draft. Other users will not see this diff until you publish your draft.")}else{header=this._oldHeaderTemplate({revision:revision});detail=this._oldDetailTemplate({revision:revision,latestRevision:latestRevision})}this.$el.html(this.template({header:header,detail:detail}));return this},_onSelectLatest(ev){ev.preventDefault();ev.stopPropagation();this.trigger("revisionSelected",[0,this.model.get("latestRevision")])},_onSelectChanged(ev){ev.preventDefault();ev.stopPropagation();this.trigger("revisionSelected",[this.model.get("revision"),this.model.get("latestRevision")])}});"use strict";RB.DiffRevisionSelectorView=RB.RevisionSelectorView.extend({initialize:function(options){this.options=options;RB.RevisionSelectorView.prototype.initialize.call(this,{firstLabelActive:true,numHandles:2})},render:function(){const labels=["orig"];for(let i=1;i<=this.options.numDiffs;i++){labels.push(i.toString())}return RB.RevisionSelectorView.prototype.render.call(this,labels)},_update:function(){const revision=this.model.get("revision");const interdiffRevision=this.model.get("interdiffRevision");this._values=[interdiffRevision?revision:0,interdiffRevision?interdiffRevision:revision];if(this._rendered){this._updateHandles()}},_onLabelClick:function(ev){const $target=$(ev.currentTarget);this.trigger("revisionSelected",[0,$target.data("revision")])}});"use strict";RB.PaginationView=Backbone.View.extend({template:_.template(`<% if (isPaginated) { %>
 <%- splitText %>
 <% if (hasPrevious) { %>
  <span class="paginate-link" data-page="<%- previousPage %>"><a href="?page=<%- previousPage %><%= extraURLOptions %>" title="<%- previousPageText %>">&lt;</a></span>
 <% } %>
 <% _.each(pageNumbers, function(page) { %>
  <% if (page === currentPage) { %>
   <span class="paginate-current" title="<%- currentPageText %>"><%- page %></span>
  <% } else { %>
   <span class="paginate-link" data-page="<%- page %>"><a href="?page=<%- page %><%= extraURLOptions %>"
       title="<% print(interpolate(pageText, [page])); %>"
       ><%- page %></a></span>
  <% } %>
 <% }); %>
 <% if (hasNext) { %>
  <span class="paginate-link" data-page="<%- nextPage %>"><a href="?page=<%- nextPage %><%= extraURLOptions %>" title="<%- nextPageText %>">&gt;</a></span>
 <% } %>
<% } %>`),events:{"click .paginate-link":"_onPageClicked"},initialize(){this.listenTo(this.model,"change",this.render)},render(){this.$el.empty().html(this.template(_.defaults({splitText:interpolate(gettext("This diff has been split across %s pages:"),[this.model.get("pages")]),previousPageText:gettext("Previous Page"),nextPageText:gettext("Next Page"),currentPageText:gettext("Current Page"),extraURLOptions:this._buildExtraQueryString(),pageText:gettext("Page %s")},this.model.attributes)));return this},_buildExtraQueryString(){let queryString=window.location.search||"";let parts=[];if(queryString.startsWith("?")){queryString=queryString.substr(1)}if(queryString){parts=queryString.split("&");const newParts=[];for(let i=0;i<parts.length;i++){const part=parts[i];if(!part.startsWith("page=")){newParts.push(part)}}if(newParts.length>0){return"&"+newParts.join("&")}}return""},_onPageClicked(ev){const page=$(ev.currentTarget).data("page");if(page!==undefined){this.trigger("pageSelected",page);ev.stopPropagation();ev.preventDefault()}}})}).call(this);
