/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.analysis;

import fpp.compiler.analysis.GenericPortInterface$;
import fpp.compiler.analysis.Interface;
import fpp.compiler.analysis.PortInstance;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.AstNode;
import fpp.compiler.ast.Locations$;
import fpp.compiler.util.Error;
import fpp.compiler.util.Location;
import fpp.compiler.util.Result$;
import fpp.compiler.util.SemanticError$DuplicatePortInstance$;
import fpp.compiler.util.SemanticError$InterfaceImport$;
import fpp.compiler.util.SemanticError$InvalidPortInstanceId$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public interface GenericPortInterface<T extends GenericPortInterface<T>> {
    public static <T extends GenericPortInterface<T>> Map<String, PortInstance> $lessinit$greater$default$2() {
        return GenericPortInterface$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T extends GenericPortInterface<T>> Map<Ast.SpecPortInstance.SpecialKind, PortInstance.Special> $lessinit$greater$default$3() {
        return GenericPortInterface$.MODULE$.$lessinit$greater$default$3();
    }

    public String fpp$compiler$analysis$GenericPortInterface$$defName();

    public Map<String, PortInstance> fpp$compiler$analysis$GenericPortInterface$$portMap();

    public Map<Ast.SpecPortInstance.SpecialKind, PortInstance.Special> fpp$compiler$analysis$GenericPortInterface$$specialPortMap();

    public T withPortMap(Map<String, PortInstance> var1);

    public T withSpecialPortMap(Map<Ast.SpecPortInstance.SpecialKind, PortInstance.Special> var1);

    public static Either getPortInstance$(GenericPortInterface $this, AstNode name) {
        return $this.getPortInstance(name);
    }

    default public Either<Error, PortInstance> getPortInstance(AstNode<String> name) {
        Either either;
        Option option = this.fpp$compiler$analysis$GenericPortInterface$$portMap().get(name.data());
        if (option instanceof Some) {
            PortInstance portInstance = (PortInstance)((Some)option).value();
            either = package$.MODULE$.Right().apply(portInstance);
        } else if (None$.MODULE$.equals(option)) {
            either = package$.MODULE$.Left().apply(SemanticError$InvalidPortInstanceId$.MODULE$.apply(Locations$.MODULE$.get(name.id()), name.data(), this.fpp$compiler$analysis$GenericPortInterface$$defName()));
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    public static Either addPortInstance$(GenericPortInterface $this, PortInstance instance) {
        return $this.addPortInstance(instance);
    }

    default public Either<Error, T> addPortInstance(PortInstance instance) {
        return this.updatePortMap(instance).flatMap((Function1<GenericPortInterface, Either> & Serializable)c2 -> {
            Either either;
            PortInstance portInstance = instance;
            if (portInstance instanceof PortInstance.Special) {
                PortInstance.Special special = (PortInstance.Special)portInstance;
                either = c2.updateSpecialPortMap(special);
            } else {
                either = package$.MODULE$.Right().apply(c2);
            }
            return either.map((Function1<GenericPortInterface, GenericPortInterface> & Serializable)c -> c);
        });
    }

    public static Either addImportedInterface$(GenericPortInterface $this, Interface interface_, int importNodeId) {
        return $this.addImportedInterface(interface_, importNodeId);
    }

    default public Either<Error, T> addImportedInterface(Interface interface_, int importNodeId) {
        T init = this.withPortMap(this.fpp$compiler$analysis$GenericPortInterface$$portMap());
        return Result$.MODULE$.foldLeft(interface_.portMap().values().toList(), init, (Function2<GenericPortInterface, PortInstance, Either> & Serializable)(c, pi) -> {
            Either either;
            Either either2 = c.addPortInstance(pi.withImportSpecifier(importNodeId));
            if (either2 instanceof Right) {
                GenericPortInterface cc = (GenericPortInterface)((Right)either2).value();
                either = package$.MODULE$.Right().apply(cc);
            } else if (either2 instanceof Left) {
                Error err = (Error)((Left)either2).value();
                either = package$.MODULE$.Left().apply(SemanticError$InterfaceImport$.MODULE$.apply(Locations$.MODULE$.get(importNodeId), err));
            } else {
                throw new MatchError(either2);
            }
            return either;
        });
    }

    private Either<Error, T> updatePortMap(PortInstance instance) {
        Either either;
        String name = instance.getUnqualifiedName();
        Option option = this.fpp$compiler$analysis$GenericPortInterface$$portMap().get(name);
        if (option instanceof Some) {
            PortInstance prevInstance = (PortInstance)((Some)option).value();
            Location loc = instance.getLoc();
            List<Location> importLocs = instance.getImportLocs();
            Location prevLoc = prevInstance.getLoc();
            List<Location> prevImportLocs = prevInstance.getImportLocs();
            either = package$.MODULE$.Left().apply(SemanticError$DuplicatePortInstance$.MODULE$.apply(name, loc, importLocs, prevLoc, prevImportLocs));
        } else if (None$.MODULE$.equals(option)) {
            String string2 = Predef$.MODULE$.ArrowAssoc(name);
            Map portMap = (Map)this.fpp$compiler$analysis$GenericPortInterface$$portMap().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, instance));
            T t = this.withPortMap(portMap);
            either = package$.MODULE$.Right().apply(t);
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    private Either<Error, T> updateSpecialPortMap(PortInstance.Special instance) {
        Either either;
        Ast.SpecPortInstance.SpecialKind kind = instance.specifier().kind();
        Option option = this.fpp$compiler$analysis$GenericPortInterface$$specialPortMap().get(kind);
        if (option instanceof Some) {
            PortInstance.Special prevInstance = (PortInstance.Special)((Some)option).value();
            Location loc = instance.getLoc();
            List importLocs = instance.getImportLocs();
            Location prevLoc = prevInstance.getLoc();
            List prevImportLocs = prevInstance.getImportLocs();
            either = package$.MODULE$.Left().apply(SemanticError$DuplicatePortInstance$.MODULE$.apply(kind.toString(), loc, importLocs, prevLoc, prevImportLocs));
        } else if (None$.MODULE$.equals(option)) {
            Ast.SpecPortInstance.SpecialKind specialKind = Predef$.MODULE$.ArrowAssoc(kind);
            Map specialPortMap = (Map)this.fpp$compiler$analysis$GenericPortInterface$$specialPortMap().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(specialKind, instance));
            T t = this.withSpecialPortMap(specialPortMap);
            either = package$.MODULE$.Right().apply(t);
        } else {
            throw new MatchError(option);
        }
        return either;
    }
}

