/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.analysis;

import fpp.compiler.analysis.StateMachineTypedElement;
import fpp.compiler.analysis.StateOrChoice;
import fpp.compiler.analysis.TransitionGraph$;
import fpp.compiler.analysis.TransitionGraph$Arc$;
import fpp.compiler.analysis.TransitionGraph$Node$;
import java.io.Serializable;
import scala.Equals;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TransitionGraph
implements Product,
Serializable {
    private final Option initialNode;
    private final Map arcMap;

    public static TransitionGraph apply(Option<Node> option, Map<Node, Set<Arc>> map) {
        return TransitionGraph$.MODULE$.apply(option, map);
    }

    public static TransitionGraph fromProduct(Product product) {
        return TransitionGraph$.MODULE$.fromProduct(product);
    }

    public static TransitionGraph unapply(TransitionGraph transitionGraph) {
        return TransitionGraph$.MODULE$.unapply(transitionGraph);
    }

    public static Option<Node> $lessinit$greater$default$1() {
        return TransitionGraph$.MODULE$.$lessinit$greater$default$1();
    }

    public static Map<Node, Set<Arc>> $lessinit$greater$default$2() {
        return TransitionGraph$.MODULE$.$lessinit$greater$default$2();
    }

    public TransitionGraph(Option<Node> initialNode, Map<Node, Set<Arc>> arcMap) {
        this.initialNode = initialNode;
        this.arcMap = arcMap;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TransitionGraph)) return false;
        TransitionGraph transitionGraph = (TransitionGraph)object;
        Option<Node> option = this.initialNode();
        Option<Node> option2 = transitionGraph.initialNode();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Map<Node, Set<Arc>> map = this.arcMap();
        Map<Node, Set<Arc>> map2 = transitionGraph.arcMap();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!transitionGraph.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof TransitionGraph;
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public String productPrefix() {
        return "TransitionGraph";
    }

    @Override
    public Object productElement(int n) {
        Equals equals;
        int n2 = n;
        if (0 == n2) {
            equals = this._1();
        } else if (1 == n2) {
            equals = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }
        return equals;
    }

    @Override
    public String productElementName(int n) {
        String string2;
        int n2 = n;
        if (0 == n2) {
            string2 = "initialNode";
        } else if (1 == n2) {
            string2 = "arcMap";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }
        return string2;
    }

    public Option<Node> initialNode() {
        return this.initialNode;
    }

    public Map<Node, Set<Arc>> arcMap() {
        return this.arcMap;
    }

    public TransitionGraph addNode(Node node) {
        TransitionGraph transitionGraph;
        Option option = this.arcMap().get(node);
        if (option instanceof Some) {
            transitionGraph = this;
        } else if (None$.MODULE$.equals(option)) {
            Node node2 = Predef$.MODULE$.ArrowAssoc(node);
            Map map = (Map)this.arcMap().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(node2, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Arc[0]))));
            Option<Node> option2 = this.copy$default$1();
            transitionGraph = this.copy(option2, map);
        } else {
            throw new MatchError(option);
        }
        return transitionGraph;
    }

    public TransitionGraph addArc(Arc arc) {
        Node startNode = arc.getStartNode();
        Set arcs = (Set)((SetOps)this.arcMap().get(startNode).getOrElse(TransitionGraph::$anonfun$1)).$plus(arc);
        Node node = Predef$.MODULE$.ArrowAssoc(startNode);
        Map map = (Map)this.arcMap().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(node, arcs));
        Option<Node> option = this.copy$default$1();
        return this.copy(option, map);
    }

    public TransitionGraph addReverseArc(Arc arc) {
        Node endNode = arc.getEndNode();
        Set arcs = (Set)((SetOps)this.arcMap().get(endNode).getOrElse(TransitionGraph::$anonfun$2)).$plus(arc);
        Node node = Predef$.MODULE$.ArrowAssoc(endNode);
        Map map = (Map)this.arcMap().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(node, arcs));
        Option<Node> option = this.copy$default$1();
        return this.copy(option, map);
    }

    public TransitionGraph getReverseGraph() {
        TransitionGraph tg = TransitionGraph$.MODULE$.apply(this.initialNode(), (Map)this.initialNode().map((Function1<Node, Map> & Serializable)node -> {
            Tuple2[] tuple2Array = new Tuple2[1];
            Node node2 = Predef$.MODULE$.ArrowAssoc(node);
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(node2, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Arc[0])));
            return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        }).getOrElse(TransitionGraph::$anonfun$4));
        return this.arcMap().values().foldLeft(tg, (Function2<TransitionGraph, Set, TransitionGraph> & Serializable)(tg2, arcs) -> arcs.foldLeft(tg2, (Function2<TransitionGraph, Arc, TransitionGraph> & Serializable)(tg, a) -> tg.addReverseArc((Arc)a)));
    }

    public TransitionGraph copy(Option<Node> initialNode, Map<Node, Set<Arc>> arcMap) {
        return new TransitionGraph(initialNode, arcMap);
    }

    public Option<Node> copy$default$1() {
        return this.initialNode();
    }

    public Map<Node, Set<Arc>> copy$default$2() {
        return this.arcMap();
    }

    public Option<Node> _1() {
        return this.initialNode();
    }

    public Map<Node, Set<Arc>> _2() {
        return this.arcMap();
    }

    private static final Set $anonfun$1() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Arc[0]));
    }

    private static final Set $anonfun$2() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Arc[0]));
    }

    private static final Map $anonfun$4() {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
    }

    public static interface Arc {
        public static int ordinal(Arc arc) {
            return TransitionGraph$Arc$.MODULE$.ordinal(arc);
        }

        public Node getStartNode();

        public Node getEndNode();

        public StateMachineTypedElement getTypedElement();

        public String showKind();

        public String showTransition();
    }

    public static class Node
    implements Product,
    Serializable {
        private final StateOrChoice soc;

        public static Node apply(StateOrChoice stateOrChoice) {
            return TransitionGraph$Node$.MODULE$.apply(stateOrChoice);
        }

        public static Node fromProduct(Product product) {
            return TransitionGraph$Node$.MODULE$.fromProduct(product);
        }

        public static Node unapply(Node node) {
            return TransitionGraph$Node$.MODULE$.unapply(node);
        }

        public Node(StateOrChoice soc) {
            this.soc = soc;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Node)) return false;
            Node node = (Node)object;
            StateOrChoice stateOrChoice = this.soc();
            StateOrChoice stateOrChoice2 = node.soc();
            if (stateOrChoice == null) {
                if (stateOrChoice2 != null) {
                    return false;
                }
            } else if (!stateOrChoice.equals(stateOrChoice2)) return false;
            if (!node.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Node;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Node";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return this._1();
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return "soc";
        }

        public StateOrChoice soc() {
            return this.soc;
        }

        public Node copy(StateOrChoice soc) {
            return new Node(soc);
        }

        public StateOrChoice copy$default$1() {
            return this.soc();
        }

        public StateOrChoice _1() {
            return this.soc();
        }
    }
}

